/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.IOException;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum LtBuildInfo {
    OS("/git.properties"),
    PREMIUM("/git-premium.properties");

    private final Logger logger = LoggerFactory.getLogger(LtBuildInfo.class);
    @Nullable
    private final String buildDate;
    @Nullable
    private final String shortGitId;
    @Nullable
    private final String version;

    private LtBuildInfo(String gitPropertiesFilePath) {
        InputStream in = JLanguageTool.getDataBroker().getAsStream(gitPropertiesFilePath);
        Properties gitProperties = null;
        if (in != null) {
            gitProperties = new Properties();
            try {
                gitProperties.load(in);
            }
            catch (IOException e) {
                this.logger.warn("Failed to read {}", (Object)gitPropertiesFilePath, (Object)e);
            }
        }
        if (gitProperties != null) {
            OffsetDateTime offsetDateTime = OffsetDateTime.parse(gitProperties.getProperty("git.build.time"), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXX"));
            this.buildDate = offsetDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss Z"));
            this.shortGitId = gitProperties.getProperty("git.commit.id.abbrev");
            this.version = gitProperties.getProperty("git.build.version");
        } else {
            this.buildDate = null;
            this.shortGitId = null;
            this.version = null;
        }
    }

    @Nullable
    @Generated
    public String getBuildDate() {
        return this.buildDate;
    }

    @Nullable
    @Generated
    public String getShortGitId() {
        return this.shortGitId;
    }

    @Nullable
    @Generated
    public String getVersion() {
        return this.version;
    }
}

