/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session.state;

import java.io.IOException;
import org.jsmpp.GenericNackResponseException;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DataSmResp;
import org.jsmpp.bean.EnquireLinkResp;
import org.jsmpp.bean.UnbindResp;
import org.jsmpp.extra.PendingResponse;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.session.BaseResponseHandler;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.state.GenericSMPPSessionState;
import org.jsmpp.util.DefaultDecomposer;
import org.jsmpp.util.IntUtil;
import org.jsmpp.util.PDUDecomposer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractGenericSMPPSessionBound
implements GenericSMPPSessionState {
    protected static final PDUDecomposer pduDecomposer = new DefaultDecomposer();
    private static final Logger logger = LoggerFactory.getLogger(AbstractGenericSMPPSessionBound.class);

    AbstractGenericSMPPSessionBound() {
    }

    @Override
    public void processEnquireLink(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        responseHandler.sendEnquireLinkResp(pduHeader.getSequenceNumber());
    }

    @Override
    public void processEnquireLinkResp(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(pduHeader.getSequenceNumber());
        if (pendingResp != null) {
            EnquireLinkResp resp = pduDecomposer.enquireLinkResp(pdu);
            pendingResp.done(resp);
        } else {
            logger.error("No request found for {}", (Object)pduHeader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processUnbind(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        logger.info("Receiving unbind request");
        try {
            responseHandler.sendUnbindResp(pduHeader.getSequenceNumber());
        }
        finally {
            responseHandler.notifyUnbonded();
        }
    }

    @Override
    public void processUnbindResp(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(pduHeader.getSequenceNumber());
        if (pendingResp != null) {
            UnbindResp resp = pduDecomposer.unbindResp(pdu);
            pendingResp.done(resp);
        } else {
            logger.error("No request found for {}", (Object)pduHeader);
        }
    }

    @Override
    public void processUnknownCid(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        responseHandler.sendGenerickNack(3, pduHeader.getSequenceNumber());
    }

    @Override
    public void processGenericNack(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(pduHeader.getSequenceNumber());
        if (pendingResp != null) {
            pendingResp.doneWithInvalidResponse(new GenericNackResponseException("Receive generic_nack with command_status " + pduHeader.getCommandStatusAsHex(), pduHeader.getCommandStatus()));
            logger.error("Receive generick_nack. command_status=" + pduHeader.getCommandStatusAsHex() + ", sequence_number=" + IntUtil.toHexString(pduHeader.getSequenceNumber()));
        }
    }

    @Override
    public void processDataSm(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        try {
            DataSm dataSm = pduDecomposer.dataSm(pdu);
            DataSmResult dataSmResult = responseHandler.processDataSm(dataSm);
            logger.debug("Sending response with message_id {} for request with sequence_number {}", (Object)dataSmResult.getMessageId(), (Object)pduHeader.getSequenceNumber());
            responseHandler.sendDataSmResp(dataSmResult, pduHeader.getSequenceNumber());
        }
        catch (PDUStringException e) {
            responseHandler.sendNegativeResponse(pduHeader.getCommandId(), e.getErrorCode(), pduHeader.getSequenceNumber());
        }
        catch (ProcessRequestException e) {
            responseHandler.sendNegativeResponse(pduHeader.getCommandId(), e.getErrorCode(), pduHeader.getSequenceNumber());
        }
    }

    @Override
    public void processDataSmResp(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(pduHeader.getSequenceNumber());
        if (pendingResp != null) {
            try {
                DataSmResp resp = pduDecomposer.dataSmResp(pdu);
                pendingResp.done(resp);
            }
            catch (PDUStringException e) {
                logger.error("Failed decomposing data_sm_resp", (Throwable)e);
                responseHandler.sendGenerickNack(e.getErrorCode(), pduHeader.getSequenceNumber());
            }
        } else {
            logger.warn("No request with sequence_number {} found", (Object)pduHeader.getSequenceNumber());
        }
    }
}

