/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.time;

import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.common.time.JavaDateFormatter;

class EpochTime {
    private static final ValueRange LONG_POSITIVE_RANGE = ValueRange.of(0L, Long.MAX_VALUE);
    private static final ValueRange LONG_RANGE = ValueRange.of(Long.MIN_VALUE, Long.MAX_VALUE);
    private static final EpochField SECONDS = new EpochField(ChronoUnit.SECONDS, ChronoUnit.FOREVER, LONG_RANGE){

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            return temporal.isSupported(ChronoField.INSTANT_SECONDS);
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            return temporal.getLong(ChronoField.INSTANT_SECONDS);
        }

        @Override
        public TemporalAccessor resolve(Map<TemporalField, Long> fieldValues, TemporalAccessor partialTemporal, ResolverStyle resolverStyle) {
            long seconds = fieldValues.remove(this);
            fieldValues.put(ChronoField.INSTANT_SECONDS, seconds);
            Long nanos = fieldValues.remove(NANOS_OF_SECOND);
            if (nanos != null) {
                fieldValues.put(ChronoField.NANO_OF_SECOND, nanos);
            }
            return null;
        }
    };
    private static final EpochField NANOS_OF_SECOND = new EpochField(ChronoUnit.NANOS, ChronoUnit.SECONDS, ValueRange.of(0L, 999999999L)){

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            return temporal.isSupported(ChronoField.NANO_OF_SECOND);
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            return temporal.getLong(ChronoField.NANO_OF_SECOND);
        }
    };
    private static final long NEGATIVE = 0L;
    private static final long POSITIVE = 1L;
    private static final EpochField SIGN = new EpochField(ChronoUnit.FOREVER, ChronoUnit.FOREVER, ValueRange.of(0L, 1L)){

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            return temporal.isSupported(ChronoField.INSTANT_SECONDS);
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            return temporal.getLong(ChronoField.INSTANT_SECONDS) < 0L ? 0L : 1L;
        }
    };
    private static final EpochField NANOS_OF_MICRO = new EpochField(ChronoUnit.NANOS, ChronoUnit.MICROS, ValueRange.of(0L, 999L)){

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            return temporal.isSupported(ChronoField.INSTANT_SECONDS) && temporal.isSupported(ChronoField.NANO_OF_SECOND) && temporal.getLong(ChronoField.NANO_OF_SECOND) % 1000L != 0L;
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            if (temporal.getLong(ChronoField.INSTANT_SECONDS) < 0L) {
                return (1000000000L - temporal.getLong(ChronoField.NANO_OF_SECOND)) % 1000L;
            }
            return temporal.getLong(ChronoField.NANO_OF_SECOND) % 1000L;
        }
    };
    private static final EpochField NANOS_OF_MILLI = new EpochField(ChronoUnit.NANOS, ChronoUnit.MILLIS, ValueRange.of(0L, 999999L)){

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            return temporal.isSupported(ChronoField.INSTANT_SECONDS) && temporal.isSupported(ChronoField.NANO_OF_SECOND) && temporal.getLong(ChronoField.NANO_OF_SECOND) % 1000000L != 0L;
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            if (temporal.getLong(ChronoField.INSTANT_SECONDS) < 0L) {
                return (1000000000L - temporal.getLong(ChronoField.NANO_OF_SECOND)) % 1000000L;
            }
            return temporal.getLong(ChronoField.NANO_OF_SECOND) % 1000000L;
        }
    };
    private static final EpochField MILLIS_ABS = new AbsoluteEpochField(ChronoUnit.MILLIS, 1000L, 1000000L, ChronoField.MILLI_OF_SECOND, NANOS_OF_MILLI);
    private static final EpochField MICROS = new AbsoluteEpochField(ChronoUnit.MICROS, 1000000L, 1000L, ChronoField.MICRO_OF_SECOND, NANOS_OF_MICRO);
    private static final DateTimeFormatter SECONDS_FORMATTER1 = new DateTimeFormatterBuilder().appendValue(SECONDS, 1, 19, SignStyle.NORMAL).optionalStart().appendFraction(NANOS_OF_SECOND, 0, 9, true).optionalEnd().toFormatter(Locale.ROOT);
    private static final DateTimeFormatter SECONDS_FORMATTER2 = new DateTimeFormatterBuilder().appendValue(SECONDS, 1, 19, SignStyle.NORMAL).appendLiteral('.').toFormatter(Locale.ROOT);
    private static final Map<Long, String> SIGN_FORMATTER_LOOKUP = new HashMap<Long, String>(){
        {
            this.put(1L, "");
            this.put(0L, "-");
        }
    };
    private static final DateTimeFormatter MILLISECONDS_FORMATTER1 = new DateTimeFormatterBuilder().optionalStart().appendText((TemporalField)SIGN, SIGN_FORMATTER_LOOKUP).optionalEnd().appendValue(MILLIS_ABS, 1, 19, SignStyle.NOT_NEGATIVE).optionalStart().appendFraction(NANOS_OF_MILLI, 0, 6, true).optionalEnd().toFormatter(Locale.ROOT);
    private static final DateTimeFormatter MILLISECONDS_FORMATTER2 = new DateTimeFormatterBuilder().append(MILLISECONDS_FORMATTER1).appendLiteral('.').toFormatter(Locale.ROOT);
    private static final DateTimeFormatter MICROSECONDS_FORMATTER1 = new DateTimeFormatterBuilder().optionalStart().appendText((TemporalField)SIGN, SIGN_FORMATTER_LOOKUP).optionalEnd().appendValue(MICROS, 1, 19, SignStyle.NOT_NEGATIVE).optionalStart().appendFraction(NANOS_OF_MICRO, 0, 3, true).optionalEnd().toFormatter(Locale.ROOT);
    private static final DateTimeFormatter MICROSECONDS_FORMATTER2 = new DateTimeFormatterBuilder().append(MICROSECONDS_FORMATTER1).appendLiteral('.').toFormatter(Locale.ROOT);
    static final DateFormatter SECONDS_FORMATTER = new JavaDateFormatter("epoch_second", SECONDS_FORMATTER1, (builder, parser) -> builder.parseDefaulting(ChronoField.NANO_OF_SECOND, 999999999L), SECONDS_FORMATTER1, SECONDS_FORMATTER2);
    static final DateFormatter MILLIS_FORMATTER = new JavaDateFormatter("epoch_millis", MILLISECONDS_FORMATTER1, (builder, parser) -> builder.parseDefaulting(NANOS_OF_MILLI, 999999L), MILLISECONDS_FORMATTER1, MILLISECONDS_FORMATTER2);
    static final DateFormatter MICROS_FORMATTER = new JavaDateFormatter("epoch_micros", MICROSECONDS_FORMATTER1, (builder, parser) -> builder.parseDefaulting(NANOS_OF_MICRO, 999L), MICROSECONDS_FORMATTER1, MICROSECONDS_FORMATTER2);

    EpochTime() {
    }

    private static abstract class EpochField
    implements TemporalField {
        private final TemporalUnit baseUnit;
        private final TemporalUnit rangeUnit;
        private final ValueRange range;

        private EpochField(TemporalUnit baseUnit, TemporalUnit rangeUnit, ValueRange range) {
            this.baseUnit = baseUnit;
            this.rangeUnit = rangeUnit;
            this.range = range;
        }

        @Override
        public String getDisplayName(Locale locale) {
            return this.toString();
        }

        @Override
        public String toString() {
            return "Epoch" + this.baseUnit.toString() + (String)(this.rangeUnit != ChronoUnit.FOREVER ? "Of" + this.rangeUnit.toString() : "");
        }

        @Override
        public TemporalUnit getBaseUnit() {
            return this.baseUnit;
        }

        @Override
        public TemporalUnit getRangeUnit() {
            return this.rangeUnit;
        }

        @Override
        public ValueRange range() {
            return this.range;
        }

        @Override
        public boolean isDateBased() {
            return false;
        }

        @Override
        public boolean isTimeBased() {
            return true;
        }

        @Override
        public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
            return this.range();
        }

        @Override
        public <R extends Temporal> R adjustInto(R temporal, long newValue) {
            return (R)temporal.with(this, newValue);
        }
    }

    private static class AbsoluteEpochField
    extends EpochField {
        private final long unitsPerSecond;
        private final long nanosPerUnit;
        private final ChronoField unitField;
        private final EpochField nanosOfUnitField;

        private AbsoluteEpochField(TemporalUnit baseUnit, long unitsPerSecond, long nanosPerUnit, ChronoField unitField, EpochField nanosOfUnitField) {
            super(baseUnit, ChronoUnit.FOREVER, LONG_POSITIVE_RANGE);
            this.unitsPerSecond = unitsPerSecond;
            this.nanosPerUnit = nanosPerUnit;
            this.unitField = unitField;
            this.nanosOfUnitField = nanosOfUnitField;
        }

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            return temporal.isSupported(ChronoField.INSTANT_SECONDS) && (temporal.isSupported(ChronoField.NANO_OF_SECOND) || temporal.isSupported(this.unitField));
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            long instantSeconds = temporal.getLong(ChronoField.INSTANT_SECONDS);
            if (instantSeconds < Long.MIN_VALUE / this.unitsPerSecond || instantSeconds > Long.MAX_VALUE / this.unitsPerSecond) {
                return Long.MAX_VALUE;
            }
            long instantSecondsInUnits = instantSeconds * this.unitsPerSecond;
            if (instantSecondsInUnits >= 0L) {
                if (temporal.isSupported(ChronoField.NANO_OF_SECOND)) {
                    return instantSecondsInUnits + temporal.getLong(ChronoField.NANO_OF_SECOND) / this.nanosPerUnit;
                }
                return instantSecondsInUnits + temporal.getLong(this.unitField);
            }
            if (temporal.isSupported(ChronoField.NANO_OF_SECOND)) {
                long units = instantSecondsInUnits;
                long nanos = temporal.getLong(ChronoField.NANO_OF_SECOND);
                if (nanos % this.nanosPerUnit != 0L) {
                    ++units;
                }
                return -(units += nanos / this.nanosPerUnit);
            }
            long unitsOfSecond = temporal.getLong(this.unitField);
            return -(instantSecondsInUnits + unitsOfSecond);
        }

        @Override
        public TemporalAccessor resolve(Map<TemporalField, Long> fieldValues, TemporalAccessor partialTemporal, ResolverStyle resolverStyle) {
            long nanos;
            long seconds;
            Long sign = Optional.ofNullable(fieldValues.remove(SIGN)).orElse(1L);
            Long nanosOfUnit = fieldValues.remove(this.nanosOfUnitField);
            long secondsAndUnits = fieldValues.remove(this);
            if (sign == 0L) {
                secondsAndUnits = -secondsAndUnits;
                seconds = secondsAndUnits / this.unitsPerSecond;
                nanos = secondsAndUnits % this.unitsPerSecond * this.nanosPerUnit;
                if (nanosOfUnit != null) {
                    nanos -= nanosOfUnit.longValue();
                }
                if (nanos != 0L) {
                    --seconds;
                    nanos = 1000000000L + nanos;
                }
            } else {
                seconds = secondsAndUnits / this.unitsPerSecond;
                nanos = secondsAndUnits % this.unitsPerSecond * this.nanosPerUnit;
                if (nanosOfUnit != null) {
                    nanos += nanosOfUnit.longValue();
                }
            }
            fieldValues.put(ChronoField.INSTANT_SECONDS, seconds);
            fieldValues.put(ChronoField.NANO_OF_SECOND, nanos);
            if (fieldValues.containsKey(ChronoField.MILLI_OF_SECOND)) {
                fieldValues.put(ChronoField.MILLI_OF_SECOND, nanos / 1000000L);
            }
            if (fieldValues.containsKey(ChronoField.MICRO_OF_SECOND)) {
                fieldValues.put(ChronoField.MICRO_OF_SECOND, nanos / 1000L);
            }
            return null;
        }
    }
}

