/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import java.io.Closeable;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.IngestionShardPointer;
import org.opensearch.index.Message;

@ExperimentalApi
public interface IngestionShardConsumer<T extends IngestionShardPointer, M extends Message>
extends Closeable {
    public List<ReadResult<T, M>> readNext(T var1, boolean var2, long var3, int var5) throws TimeoutException;

    public List<ReadResult<T, M>> readNext(long var1, int var3) throws TimeoutException;

    public IngestionShardPointer earliestPointer();

    public IngestionShardPointer latestPointer();

    public IngestionShardPointer pointerFromTimestampMillis(long var1);

    public IngestionShardPointer pointerFromOffset(String var1);

    public int getShardId();

    @ExperimentalApi
    public static class ReadResult<T, M> {
        T pointer;
        M message;

        public ReadResult(T pointer, M message) {
            this.pointer = pointer;
            this.message = message;
        }

        public T getPointer() {
            return this.pointer;
        }

        public M getMessage() {
            return this.message;
        }
    }
}

