/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.response.common;

import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import java.util.List;
import java.util.Map;

public class StructProtoUtils {
    private StructProtoUtils() {
    }

    public static Value toProto(Object javaObject) {
        Value.Builder valueBuilder = Value.newBuilder();
        if (javaObject == null) {
            valueBuilder.setNullValue(NullValue.NULL_VALUE);
        } else if (javaObject instanceof Number) {
            valueBuilder.setNumberValue(((Number)javaObject).doubleValue());
        } else if (javaObject instanceof String) {
            valueBuilder.setStringValue((String)javaObject);
        } else if (javaObject instanceof Boolean) {
            valueBuilder.setBoolValue(((Boolean)javaObject).booleanValue());
        } else if (javaObject instanceof List) {
            ListValue.Builder listBuilder = ListValue.newBuilder();
            for (Object listEntry : (List)javaObject) {
                listBuilder.addValues(StructProtoUtils.toProto(listEntry));
            }
            valueBuilder.setListValue(listBuilder.build());
        } else if (javaObject instanceof Map) {
            Struct.Builder structBuilder = Struct.newBuilder();
            Map fieldMap = (Map)javaObject;
            for (Map.Entry entry : fieldMap.entrySet()) {
                structBuilder.putFields((String)entry.getKey(), StructProtoUtils.toProto(entry.getValue()));
            }
            valueBuilder.setStructValue(structBuilder.build());
        } else {
            throw new IllegalArgumentException("Cannot convert " + javaObject.toString() + " to google.protobuf.Struct");
        }
        return valueBuilder.build();
    }
}

