/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.response.document.get;

import com.google.protobuf.ByteString;
import org.opensearch.common.document.DocumentField;
import org.opensearch.index.get.GetResult;
import org.opensearch.protobufs.Id;
import org.opensearch.protobufs.InlineGetDictUserDefined;
import org.opensearch.protobufs.ObjectMap;
import org.opensearch.protobufs.ResponseItem;
import org.opensearch.transport.grpc.proto.response.document.common.DocumentFieldProtoUtils;

public class GetResultProtoUtils {
    private GetResultProtoUtils() {
    }

    public static ResponseItem.Builder toProto(GetResult getResult, ResponseItem.Builder responseItemBuilder) {
        responseItemBuilder.setXIndex(getResult.getIndex());
        Id id = Id.newBuilder().setString(getResult.getId()).build();
        responseItemBuilder.setXId(id);
        InlineGetDictUserDefined.Builder inlineGetDictUserDefinedBuilder = InlineGetDictUserDefined.newBuilder();
        if (getResult.isExists()) {
            if (getResult.getVersion() != -1L) {
                responseItemBuilder.setXVersion(getResult.getVersion());
            }
            GetResultProtoUtils.toProtoEmbedded(getResult, inlineGetDictUserDefinedBuilder);
        } else {
            inlineGetDictUserDefinedBuilder.setFound(false);
        }
        responseItemBuilder.setGet(inlineGetDictUserDefinedBuilder.build());
        return responseItemBuilder;
    }

    public static void toProtoEmbedded(GetResult getResult, InlineGetDictUserDefined.Builder builder) {
        if (getResult.getSeqNo() != -2L) {
            builder.setSeqNo(getResult.getSeqNo());
            builder.setXPrimaryTerm(getResult.getPrimaryTerm());
        }
        builder.setFound(getResult.isExists());
        if (getResult.source() != null) {
            builder.setXSource(ByteString.copyFrom((byte[])getResult.source()));
        }
        if (!getResult.getMetadataFields().isEmpty()) {
            ObjectMap.Builder metadataFieldsBuilder = ObjectMap.newBuilder();
            for (DocumentField field : getResult.getMetadataFields().values()) {
                if (field.getName().equals("_ignored")) {
                    metadataFieldsBuilder.putFields(field.getName(), DocumentFieldProtoUtils.toProto(field.getValues()));
                    continue;
                }
                metadataFieldsBuilder.putFields(field.getName(), DocumentFieldProtoUtils.toProto(field.getValue()));
            }
            builder.setMetadataFields(metadataFieldsBuilder.build());
        }
        if (!getResult.getDocumentFields().isEmpty()) {
            ObjectMap.Builder documentFieldsBuilder = ObjectMap.newBuilder();
            for (DocumentField field : getResult.getDocumentFields().values()) {
                documentFieldsBuilder.putFields(field.getName(), DocumentFieldProtoUtils.toProto(field.getValues()));
            }
            builder.setFields(documentFieldsBuilder.build());
        }
    }
}

