/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.crypto;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.crypto.DecryptedRangedStreamProvider;
import org.opensearch.common.crypto.EncryptedHeaderContentSupplier;
import org.opensearch.common.io.InputStreamContainer;

@ExperimentalApi
public interface CryptoHandler<T, U>
extends Closeable {
    public T initEncryptionMetadata();

    public U loadEncryptionMetadata(EncryptedHeaderContentSupplier var1) throws IOException;

    public long adjustContentSizeForPartialEncryption(T var1, long var2);

    public long estimateEncryptedLengthOfEntireContent(T var1, long var2);

    public long estimateDecryptedLength(U var1, long var2);

    public InputStreamContainer createEncryptingStream(T var1, InputStreamContainer var2);

    public InputStreamContainer createEncryptingStreamOfPart(T var1, InputStreamContainer var2, int var3, int var4);

    public InputStream createDecryptingStream(InputStream var1);

    public DecryptedRangedStreamProvider createDecryptingStreamOfRange(U var1, long var2, long var4);
}

