/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ppl.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.ast.EmptySourcePropagateVisitor;
import org.opensearch.sql.ast.dsl.AstDSL;
import org.opensearch.sql.ast.expression.Alias;
import org.opensearch.sql.ast.expression.AllFieldsExcludeMeta;
import org.opensearch.sql.ast.expression.Argument;
import org.opensearch.sql.ast.expression.DataType;
import org.opensearch.sql.ast.expression.EqualTo;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.Let;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.Map;
import org.opensearch.sql.ast.expression.ParseMethod;
import org.opensearch.sql.ast.expression.PatternMethod;
import org.opensearch.sql.ast.expression.PatternMode;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.ast.expression.SearchAnd;
import org.opensearch.sql.ast.expression.SearchExpression;
import org.opensearch.sql.ast.expression.SearchGroup;
import org.opensearch.sql.ast.expression.UnresolvedArgument;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.expression.WindowFrame;
import org.opensearch.sql.ast.expression.WindowFunction;
import org.opensearch.sql.ast.tree.AD;
import org.opensearch.sql.ast.tree.Aggregation;
import org.opensearch.sql.ast.tree.Append;
import org.opensearch.sql.ast.tree.AppendCol;
import org.opensearch.sql.ast.tree.AppendPipe;
import org.opensearch.sql.ast.tree.Chart;
import org.opensearch.sql.ast.tree.CountBin;
import org.opensearch.sql.ast.tree.Dedupe;
import org.opensearch.sql.ast.tree.DefaultBin;
import org.opensearch.sql.ast.tree.DescribeRelation;
import org.opensearch.sql.ast.tree.Eval;
import org.opensearch.sql.ast.tree.Expand;
import org.opensearch.sql.ast.tree.FillNull;
import org.opensearch.sql.ast.tree.Filter;
import org.opensearch.sql.ast.tree.Flatten;
import org.opensearch.sql.ast.tree.Head;
import org.opensearch.sql.ast.tree.Join;
import org.opensearch.sql.ast.tree.Kmeans;
import org.opensearch.sql.ast.tree.Lookup;
import org.opensearch.sql.ast.tree.ML;
import org.opensearch.sql.ast.tree.MinSpanBin;
import org.opensearch.sql.ast.tree.Multisearch;
import org.opensearch.sql.ast.tree.Parse;
import org.opensearch.sql.ast.tree.Patterns;
import org.opensearch.sql.ast.tree.Project;
import org.opensearch.sql.ast.tree.RangeBin;
import org.opensearch.sql.ast.tree.RareTopN;
import org.opensearch.sql.ast.tree.Regex;
import org.opensearch.sql.ast.tree.Relation;
import org.opensearch.sql.ast.tree.Rename;
import org.opensearch.sql.ast.tree.Replace;
import org.opensearch.sql.ast.tree.ReplacePair;
import org.opensearch.sql.ast.tree.Reverse;
import org.opensearch.sql.ast.tree.Rex;
import org.opensearch.sql.ast.tree.SPath;
import org.opensearch.sql.ast.tree.Search;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.ast.tree.SpanBin;
import org.opensearch.sql.ast.tree.StreamWindow;
import org.opensearch.sql.ast.tree.SubqueryAlias;
import org.opensearch.sql.ast.tree.TableFunction;
import org.opensearch.sql.ast.tree.Trendline;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.ast.tree.Window;
import org.opensearch.sql.calcite.utils.CalciteUtils;
import org.opensearch.sql.common.antlr.SyntaxCheckException;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.lang.PPLLangSpec;
import org.opensearch.sql.ppl.antlr.parser.OpenSearchPPLParser;
import org.opensearch.sql.ppl.antlr.parser.OpenSearchPPLParserBaseVisitor;
import org.opensearch.sql.ppl.parser.AstExpressionBuilder;
import org.opensearch.sql.ppl.utils.ArgumentFactory;
import org.opensearch.sql.utils.SystemIndexUtils;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableMap;

public class AstBuilder
extends OpenSearchPPLParserBaseVisitor<UnresolvedPlan> {
    private final AstExpressionBuilder expressionBuilder = new AstExpressionBuilder(this);
    private final Settings settings;
    private final String query;

    public AstBuilder(String query) {
        this(query, null);
    }

    public AstBuilder(String query, Settings settings) {
        this.query = query;
        this.settings = settings;
    }

    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public UnresolvedPlan visitQueryStatement(OpenSearchPPLParser.QueryStatementContext ctx) {
        UnresolvedPlan pplCommand = (UnresolvedPlan)this.visit((ParseTree)ctx.pplCommands());
        return ctx.commands().stream().map(arg_0 -> ((AstBuilder)this).visit(arg_0)).reduce(pplCommand, (r, e) -> e.attach(e instanceof Join ? this.projectExceptMeta((UnresolvedPlan)r) : r));
    }

    @Override
    public UnresolvedPlan visitSubPipeline(OpenSearchPPLParser.SubPipelineContext ctx) {
        List<OpenSearchPPLParser.CommandsContext> cmds = ctx.commands();
        if (cmds.isEmpty()) {
            throw new IllegalArgumentException("appendpipe [] is empty");
        }
        UnresolvedPlan seed = (UnresolvedPlan)this.visit((ParseTree)cmds.getFirst());
        return cmds.stream().skip(1L).map(arg_0 -> ((AstBuilder)this).visit(arg_0)).reduce(seed, (left, op) -> op.attach((UnresolvedPlan)left));
    }

    @Override
    public UnresolvedPlan visitSubSearch(OpenSearchPPLParser.SubSearchContext ctx) {
        UnresolvedPlan searchCommand = (UnresolvedPlan)this.visit((ParseTree)ctx.searchCommand());
        return this.projectExceptMeta(ctx.commands().stream().map(arg_0 -> ((AstBuilder)this).visit(arg_0)).reduce(searchCommand, (r, e) -> e.attach((UnresolvedPlan)r)));
    }

    @Override
    public UnresolvedPlan visitSearchFrom(OpenSearchPPLParser.SearchFromContext ctx) {
        if (ctx.searchExpression().isEmpty()) {
            return (UnresolvedPlan)this.visitFromClause(ctx.fromClause());
        }
        List<SearchExpression> searchExprs = ctx.searchExpression().stream().map(expr -> (SearchExpression)this.expressionBuilder.visit((ParseTree)expr)).toList();
        SearchExpression combined = searchExprs.size() == 1 ? searchExprs.getFirst() : searchExprs.stream().map(SearchGroup::new).map(SearchExpression.class::cast).reduce(SearchAnd::new).get();
        String queryString = combined.toQueryString();
        Relation relation = (Relation)this.visitFromClause(ctx.fromClause());
        return new Search(relation, queryString, combined);
    }

    @Override
    public UnresolvedPlan visitDescribeCommand(OpenSearchPPLParser.DescribeCommandContext ctx) {
        Relation table = (Relation)this.visitTableSourceClause(ctx.tableSourceClause());
        QualifiedName tableQualifiedName = table.getTableQualifiedName();
        ArrayList<String> parts = new ArrayList<String>(tableQualifiedName.getParts());
        parts.set(parts.size() - 1, SystemIndexUtils.mappingTable(parts.get(parts.size() - 1), PPLLangSpec.PPL_SPEC));
        return new DescribeRelation(new QualifiedName(parts));
    }

    @Override
    public UnresolvedPlan visitShowDataSourcesCommand(OpenSearchPPLParser.ShowDataSourcesCommandContext ctx) {
        return new DescribeRelation(AstDSL.qualifiedName(".DATASOURCES"));
    }

    @Override
    public UnresolvedPlan visitWhereCommand(OpenSearchPPLParser.WhereCommandContext ctx) {
        return new Filter(this.internalVisitExpression((ParseTree)ctx.logicalExpression()));
    }

    @Override
    public UnresolvedPlan visitAppendPipeCommand(OpenSearchPPLParser.AppendPipeCommandContext ctx) {
        UnresolvedPlan plan = (UnresolvedPlan)this.visit((ParseTree)ctx.subPipeline());
        return new AppendPipe(plan);
    }

    @Override
    public UnresolvedPlan visitJoinCommand(OpenSearchPPLParser.JoinCommandContext ctx) {
        List<Argument> arguments;
        Argument.ArgumentMap argumentMap;
        boolean sqlLike = ctx.joinCriteria() != null;
        Join.JoinType joinType = null;
        if (sqlLike) {
            joinType = ArgumentFactory.getJoinType(ctx.sqlLikeJoinType());
        }
        if ((argumentMap = Argument.ArgumentMap.of(arguments = ctx.joinOption().stream().map(o -> (Argument)this.expressionBuilder.visit((ParseTree)o)).toList())).get("type") != null) {
            Join.JoinType joinTypeFromArgument = ArgumentFactory.getJoinType(argumentMap);
            if (sqlLike && joinType != joinTypeFromArgument && ctx.sqlLikeJoinType() != null) {
                throw new SemanticCheckException("Join type is ambiguous, remove either the join type before JOIN keyword or 'type=' option.");
            }
            joinType = joinTypeFromArgument;
        }
        if (!sqlLike && argumentMap.get("type") == null) {
            joinType = Join.JoinType.INNER;
        }
        this.validateJoinType(joinType);
        Join.JoinHint joinHint = this.getJoinHint(ctx.joinHintList());
        Optional<String> leftAlias = Optional.empty();
        Optional<Object> rightAlias = Optional.empty();
        if (ctx.sideAlias() != null && ctx.sideAlias().leftAlias != null) {
            leftAlias = Optional.of(this.internalVisitExpression((ParseTree)ctx.sideAlias().leftAlias).toString());
        }
        if (ctx.tableOrSubqueryClause().alias != null) {
            rightAlias = Optional.of(this.internalVisitExpression((ParseTree)ctx.tableOrSubqueryClause().alias).toString());
        }
        if (ctx.sideAlias() != null && ctx.sideAlias().rightAlias != null) {
            rightAlias = Optional.of(this.internalVisitExpression((ParseTree)ctx.sideAlias().rightAlias).toString());
        }
        UnresolvedPlan rightRelation = (UnresolvedPlan)this.visit((ParseTree)ctx.tableOrSubqueryClause());
        UnresolvedPlan right = rightAlias.isEmpty() || rightRelation instanceof SubqueryAlias && ((String)rightAlias.get()).equals(((SubqueryAlias)rightRelation).getAlias()) ? rightRelation : new SubqueryAlias((String)rightAlias.get(), rightRelation);
        Optional<UnresolvedExpression> joinCondition = ctx.joinCriteria() == null ? Optional.empty() : Optional.of((UnresolvedExpression)this.expressionBuilder.visitJoinCriteria(ctx.joinCriteria()));
        Optional<List<Field>> joinFields = Optional.empty();
        if (ctx.fieldList() != null) {
            joinFields = Optional.of(this.getFieldList(ctx.fieldList()));
        }
        return new Join(this.projectExceptMeta(right), leftAlias, rightAlias, joinType, joinCondition, joinHint, joinFields, argumentMap);
    }

    private Join.JoinHint getJoinHint(OpenSearchPPLParser.JoinHintListContext ctx) {
        Join.JoinHint joinHint = ctx == null ? new Join.JoinHint() : new Join.JoinHint(ctx.hintPair().stream().map(arg_0 -> ((AstExpressionBuilder)this.expressionBuilder).visit(arg_0)).filter(e -> e instanceof EqualTo).map(e -> (EqualTo)e).collect(Collectors.toMap(k -> k.getLeft().toString(), v -> v.getRight().toString(), (v1, v2) -> v2, LinkedHashMap::new)));
        return joinHint;
    }

    private void validateJoinType(Join.JoinType joinType) {
        Object config = this.settings.getSettingValue(Settings.Key.CALCITE_SUPPORT_ALL_JOIN_TYPES);
        if (config != null && !((Boolean)config).booleanValue() && Join.highCostJoinTypes().contains((Object)joinType)) {
            throw new SemanticCheckException(String.format("Join type %s is performance sensitive. Set %s to true to enable it.", joinType.name(), Settings.Key.CALCITE_SUPPORT_ALL_JOIN_TYPES.getKeyValue()));
        }
    }

    @Override
    public UnresolvedPlan visitFieldsCommand(OpenSearchPPLParser.FieldsCommandContext ctx) {
        return this.buildProjectCommand(ctx.fieldsCommandBody(), ArgumentFactory.getArgumentList(ctx));
    }

    @Override
    public UnresolvedPlan visitTableCommand(OpenSearchPPLParser.TableCommandContext ctx) {
        if (this.settings != null && Boolean.TRUE.equals(this.settings.getSettingValue(Settings.Key.CALCITE_ENGINE_ENABLED))) {
            List<Argument> arguments = Collections.singletonList(ctx.fieldsCommandBody().MINUS() != null ? new Argument("exclude", new Literal(true, DataType.BOOLEAN)) : new Argument("exclude", new Literal(false, DataType.BOOLEAN)));
            return this.buildProjectCommand(ctx.fieldsCommandBody(), arguments);
        }
        throw CalciteUtils.getOnlyForCalciteException("Table command");
    }

    private UnresolvedPlan buildProjectCommand(OpenSearchPPLParser.FieldsCommandBodyContext bodyCtx, List<Argument> arguments) {
        List<UnresolvedExpression> fields = this.extractFieldExpressions(bodyCtx);
        if (this.settings != null && Boolean.FALSE.equals(this.settings.getSettingValue(Settings.Key.CALCITE_ENGINE_ENABLED)) && this.hasEnhancedFieldFeatures(bodyCtx, fields)) {
            throw CalciteUtils.getOnlyForCalciteException("Enhanced fields feature");
        }
        return new Project(fields, arguments);
    }

    private List<UnresolvedExpression> extractFieldExpressions(OpenSearchPPLParser.FieldsCommandBodyContext bodyCtx) {
        if (bodyCtx.wcFieldList() != null) {
            return this.processFieldExpressions(bodyCtx.wcFieldList().selectFieldExpression());
        }
        return Collections.emptyList();
    }

    private List<UnresolvedExpression> processFieldExpressions(List<OpenSearchPPLParser.SelectFieldExpressionContext> fieldExpressions) {
        Stream<UnresolvedExpression> stream = fieldExpressions.stream().map(this::internalVisitExpression);
        if (this.settings != null && Boolean.TRUE.equals(this.settings.getSettingValue(Settings.Key.CALCITE_ENGINE_ENABLED))) {
            stream = stream.distinct();
        }
        return stream.collect(Collectors.toList());
    }

    @Override
    public UnresolvedPlan visitRenameCommand(OpenSearchPPLParser.RenameCommandContext ctx) {
        return new Rename(ctx.renameClasue().stream().map(ct -> new Map(this.internalVisitExpression((ParseTree)ct.orignalField), this.internalVisitExpression((ParseTree)ct.renamedField))).collect(Collectors.toList()));
    }

    @Override
    public UnresolvedPlan visitReplaceCommand(OpenSearchPPLParser.ReplaceCommandContext ctx) {
        List<ReplacePair> replacePairs = ctx.replacePair().stream().map(this::buildReplacePair).collect(Collectors.toList());
        Set<Field> fieldList = this.getUniqueFieldSet(ctx.fieldList());
        return new Replace(replacePairs, fieldList);
    }

    private ReplacePair buildReplacePair(OpenSearchPPLParser.ReplacePairContext ctx) {
        Literal pattern = (Literal)this.internalVisitExpression((ParseTree)ctx.pattern);
        Literal replacement = (Literal)this.internalVisitExpression((ParseTree)ctx.replacement);
        return new ReplacePair(pattern, replacement);
    }

    @Override
    public UnresolvedPlan visitStatsCommand(OpenSearchPPLParser.StatsCommandContext ctx) {
        List<UnresolvedExpression> aggregations = this.parseAggTerms(ctx.statsAggTerm());
        List<UnresolvedExpression> groupList = Optional.ofNullable(ctx.statsByClause()).map(OpenSearchPPLParser.StatsByClauseContext::fieldList).map(expr -> expr.fieldExpression().stream().map(groupCtx -> new Alias(StringUtils.unquoteIdentifier(this.getTextInQuery((ParserRuleContext)groupCtx)), this.internalVisitExpression((ParseTree)groupCtx))).collect(Collectors.toList())).orElse(Collections.emptyList());
        UnresolvedExpression span = Optional.ofNullable(ctx.statsByClause()).map(OpenSearchPPLParser.StatsByClauseContext::bySpanClause).map(this::internalVisitExpression).orElse(null);
        Aggregation aggregation = new Aggregation(aggregations, Collections.emptyList(), groupList, span, ArgumentFactory.getArgumentList(ctx, this.settings));
        return aggregation;
    }

    @Override
    public UnresolvedPlan visitEventstatsCommand(OpenSearchPPLParser.EventstatsCommandContext ctx) {
        List<Argument> argExprList = ArgumentFactory.getArgumentList(ctx, this.settings);
        Argument.ArgumentMap arguments = Argument.ArgumentMap.of(argExprList);
        boolean bucketNullable = (Boolean)arguments.get("bucket_nullable").getValue();
        List<UnresolvedExpression> groupList = this.getPartitionExprList(ctx.statsByClause());
        ImmutableList.Builder windownFunctionListBuilder = new ImmutableList.Builder();
        for (OpenSearchPPLParser.EventstatsAggTermContext aggCtx : ctx.eventstatsAggTerm()) {
            UnresolvedExpression windowFunction = this.internalVisitExpression((ParseTree)aggCtx.windowFunction());
            if (windowFunction instanceof WindowFunction) {
                ((WindowFunction)windowFunction).setPartitionByList(groupList);
            }
            String name = aggCtx.alias == null ? this.getTextInQuery(aggCtx) : StringUtils.unquoteIdentifier(aggCtx.alias.getText());
            Alias alias = new Alias(name, windowFunction);
            windownFunctionListBuilder.add((Object)alias);
        }
        return new Window((List<UnresolvedExpression>)windownFunctionListBuilder.build(), groupList, bucketNullable);
    }

    @Override
    public UnresolvedPlan visitStreamstatsCommand(OpenSearchPPLParser.StreamstatsCommandContext ctx) {
        List<Argument> argExprList = ArgumentFactory.getArgumentList(ctx, this.settings);
        Argument.ArgumentMap arguments = Argument.ArgumentMap.of(argExprList);
        boolean current = (Boolean)arguments.get("current").getValue();
        int window = (Integer)arguments.get("window").getValue();
        boolean global = (Boolean)arguments.get("global").getValue();
        boolean bucketNullable = (Boolean)arguments.get("bucket_nullable").getValue();
        if (window < 0) {
            throw new IllegalArgumentException("Window size must be >= 0, but got: " + window);
        }
        UnresolvedExpression resetBeforeExpr = Optional.ofNullable(ctx.streamstatsArgs()).filter(args -> args.resetBeforeArg() != null && !args.resetBeforeArg().isEmpty()).map(args -> (UnresolvedExpression)this.expressionBuilder.visit((ParseTree)args.resetBeforeArg(0).logicalExpression())).orElse(null);
        UnresolvedExpression resetAfterExpr = Optional.ofNullable(ctx.streamstatsArgs()).filter(args -> args.resetAfterArg() != null && !args.resetAfterArg().isEmpty()).map(args -> (UnresolvedExpression)this.expressionBuilder.visit((ParseTree)args.resetAfterArg(0).logicalExpression())).orElse(null);
        WindowFrame frame = this.buildFrameFromArgs(current, window);
        List<UnresolvedExpression> groupList = this.getPartitionExprList(ctx.statsByClause());
        ImmutableList.Builder windowFunctionListBuilder = new ImmutableList.Builder();
        for (OpenSearchPPLParser.StreamstatsAggTermContext aggCtx : ctx.streamstatsAggTerm()) {
            UnresolvedExpression windowFunction = this.internalVisitExpression((ParseTree)aggCtx.windowFunction());
            if (windowFunction instanceof WindowFunction) {
                WindowFunction wf = (WindowFunction)windowFunction;
                wf.setPartitionByList(groupList);
                wf.setWindowFrame(frame);
            }
            String name = aggCtx.alias == null ? this.getTextInQuery(aggCtx) : StringUtils.unquoteIdentifier(aggCtx.alias.getText());
            Alias alias = new Alias(name, windowFunction);
            windowFunctionListBuilder.add((Object)alias);
        }
        return new StreamWindow((List<UnresolvedExpression>)windowFunctionListBuilder.build(), groupList, current, window, global, bucketNullable, resetBeforeExpr, resetAfterExpr);
    }

    private WindowFrame buildFrameFromArgs(boolean current, int window) {
        if (window > 0) {
            if (current) {
                return WindowFrame.of(WindowFrame.FrameType.ROWS, window - 1 + " PRECEDING", "CURRENT ROW");
            }
            return WindowFrame.of(WindowFrame.FrameType.ROWS, window + " PRECEDING", "1 PRECEDING");
        }
        if (current) {
            return WindowFrame.toCurrentRow();
        }
        return WindowFrame.of(WindowFrame.FrameType.ROWS, "UNBOUNDED PRECEDING", "1 PRECEDING");
    }

    @Override
    public UnresolvedPlan visitDedupCommand(OpenSearchPPLParser.DedupCommandContext ctx) {
        return new Dedupe(ArgumentFactory.getArgumentList(ctx), this.getFieldList(ctx.fieldList()));
    }

    @Override
    public UnresolvedPlan visitHeadCommand(OpenSearchPPLParser.HeadCommandContext ctx) {
        Integer size = ctx.number != null ? Integer.parseInt(ctx.number.getText()) : 10;
        Integer from = ctx.from != null ? Integer.parseInt(ctx.from.getText()) : 0;
        return new Head(size, from);
    }

    @Override
    public UnresolvedPlan visitBinCommand(OpenSearchPPLParser.BinCommandContext ctx) {
        UnresolvedExpression field = this.internalVisitExpression((ParseTree)ctx.fieldExpression());
        String alias = ctx.alias != null ? StringUtils.unquoteIdentifier(ctx.alias.getText()) : null;
        HashSet<String> seenParams = new HashSet<String>();
        UnresolvedExpression span = null;
        Integer bins = null;
        UnresolvedExpression minspan = null;
        UnresolvedExpression aligntime = null;
        UnresolvedExpression start = null;
        UnresolvedExpression end = null;
        String errorFormat = "Duplicate %s parameter in bin command";
        for (OpenSearchPPLParser.BinOptionContext option : ctx.binOption()) {
            UnresolvedExpression resolvedOption = this.internalVisitExpression((ParseTree)option);
            if (option.span != null) {
                this.checkParamDuplication(seenParams, option.SPAN(), errorFormat);
                span = resolvedOption;
            }
            if (option.bins != null) {
                this.checkParamDuplication(seenParams, option.BINS(), errorFormat);
                bins = (Integer)((Literal)resolvedOption).getValue();
            }
            if (option.minspan != null) {
                this.checkParamDuplication(seenParams, option.MINSPAN(), errorFormat);
                minspan = resolvedOption;
            }
            if (option.aligntime != null) {
                this.checkParamDuplication(seenParams, option.ALIGNTIME(), errorFormat);
                aligntime = resolvedOption;
            }
            if (option.start != null) {
                this.checkParamDuplication(seenParams, option.START(), errorFormat);
                start = resolvedOption;
            }
            if (option.end == null) continue;
            this.checkParamDuplication(seenParams, option.END(), errorFormat);
            end = resolvedOption;
        }
        if (span != null) {
            return SpanBin.builder().field(field).span(span).aligntime(aligntime).alias(alias).build();
        }
        if (minspan != null) {
            return MinSpanBin.builder().field(field).minspan(minspan).start(start).end(end).alias(alias).build();
        }
        if (bins != null) {
            return CountBin.builder().field(field).bins(bins).start(start).end(end).alias(alias).build();
        }
        if (start != null || end != null) {
            return RangeBin.builder().field(field).start(start).end(end).alias(alias).build();
        }
        return DefaultBin.builder().field(field).alias(alias).build();
    }

    private void checkParamDuplication(Set<String> seenParams, TerminalNode terminalNode, String errorFormat) {
        String paramName = terminalNode.getText();
        if (!seenParams.add(paramName)) {
            throw new IllegalArgumentException(StringUtils.format(errorFormat, paramName));
        }
    }

    @Override
    public UnresolvedPlan visitSortCommand(OpenSearchPPLParser.SortCommandContext ctx) {
        Integer count = ctx.count != null ? Math.max(0, Integer.parseInt(ctx.count.getText())) : 0;
        List<OpenSearchPPLParser.SortFieldContext> sortFieldContexts = ctx.sortbyClause().sortField();
        this.validateSortDirectionSyntax(sortFieldContexts);
        List<Field> sortFields = sortFieldContexts.stream().map(sort -> (Field)this.internalVisitExpression((ParseTree)sort)).collect(Collectors.toList());
        return new Sort(count, sortFields);
    }

    private void validateSortDirectionSyntax(List<OpenSearchPPLParser.SortFieldContext> sortFields) {
        boolean hasPrefix = sortFields.stream().anyMatch(sortField -> sortField instanceof OpenSearchPPLParser.PrefixSortFieldContext);
        boolean hasSuffix = sortFields.stream().anyMatch(sortField -> sortField instanceof OpenSearchPPLParser.SuffixSortFieldContext);
        if (hasPrefix && hasSuffix) {
            throw new SemanticCheckException("Cannot mix prefix (+/-) and suffix (asc/desc) sort direction syntax in the same command.");
        }
    }

    @Override
    public UnresolvedPlan visitReverseCommand(OpenSearchPPLParser.ReverseCommandContext ctx) {
        return new Reverse();
    }

    @Override
    public UnresolvedPlan visitChartCommand(OpenSearchPPLParser.ChartCommandContext ctx) {
        UnresolvedExpression rowSplit = ctx.rowSplit() == null ? null : this.internalVisitExpression((ParseTree)ctx.rowSplit());
        UnresolvedExpression columnSplit = ctx.columnSplit() == null ? null : this.internalVisitExpression((ParseTree)ctx.columnSplit());
        List<Argument> arguments = ArgumentFactory.getArgumentList(ctx);
        UnresolvedExpression aggFunction = this.parseAggTerms(List.of(ctx.statsAggTerm())).getFirst();
        return Chart.builder().rowSplit(rowSplit).columnSplit(columnSplit).aggregationFunction(aggFunction).arguments(arguments).build();
    }

    private List<UnresolvedExpression> parseAggTerms(List<OpenSearchPPLParser.StatsAggTermContext> statsAggTermContexts) {
        ImmutableList.Builder aggListBuilder = new ImmutableList.Builder();
        for (OpenSearchPPLParser.StatsAggTermContext aggCtx : statsAggTermContexts) {
            UnresolvedExpression aggExpression = this.internalVisitExpression((ParseTree)aggCtx.statsFunction());
            String name = aggCtx.alias == null ? this.getTextInQuery(aggCtx) : StringUtils.unquoteIdentifier(aggCtx.alias.getText());
            Alias alias = new Alias(name, aggExpression);
            aggListBuilder.add((Object)alias);
        }
        return aggListBuilder.build();
    }

    @Override
    public UnresolvedPlan visitTimechartCommand(OpenSearchPPLParser.TimechartCommandContext ctx) {
        List<Argument> arguments = ArgumentFactory.getArgumentList(ctx, this.expressionBuilder);
        Argument.ArgumentMap argMap = Argument.ArgumentMap.of(arguments);
        Literal spanLiteral = argMap.getOrDefault("spanliteral", AstDSL.stringLiteral("1m"));
        String timeFieldName = Optional.ofNullable(argMap.get("timefield")).map(l -> (String)l.getValue()).orElse("@timestamp");
        Field spanField = AstDSL.field(timeFieldName);
        Alias span = AstDSL.alias(timeFieldName, AstDSL.spanFromSpanLengthLiteral(spanField, spanLiteral));
        UnresolvedExpression aggregateFunction = this.parseAggTerms(List.of(ctx.statsAggTerm())).getFirst();
        UnresolvedExpression byField = Optional.ofNullable(ctx.fieldExpression()).map(f -> AstDSL.alias(StringUtils.unquoteIdentifier(this.getTextInQuery((ParserRuleContext)f)), this.internalVisitExpression((ParseTree)f))).orElse(null);
        return Chart.builder().aggregationFunction(aggregateFunction).rowSplit(span).columnSplit(byField).arguments(arguments).build();
    }

    @Override
    public UnresolvedPlan visitEvalCommand(OpenSearchPPLParser.EvalCommandContext ctx) {
        return new Eval(ctx.evalClause().stream().map(ct -> (Let)this.internalVisitExpression((ParseTree)ct)).collect(Collectors.toList()));
    }

    private List<UnresolvedExpression> getGroupByList(OpenSearchPPLParser.ByClauseContext ctx) {
        return ctx.fieldList().fieldExpression().stream().map(this::internalVisitExpression).collect(Collectors.toList());
    }

    private List<Field> getFieldList(OpenSearchPPLParser.FieldListContext ctx) {
        return ctx.fieldExpression().stream().map(field -> (Field)this.internalVisitExpression((ParseTree)field)).collect(Collectors.toList());
    }

    private Set<Field> getUniqueFieldSet(OpenSearchPPLParser.FieldListContext ctx) {
        List<Field> fields = ctx.fieldExpression().stream().map(field -> (Field)this.internalVisitExpression((ParseTree)field)).toList();
        LinkedHashSet<Field> uniqueFields = new LinkedHashSet<Field>(fields);
        if (uniqueFields.size() < fields.size()) {
            HashSet seen = new HashSet();
            Set duplicates = fields.stream().map(f -> f.getField().toString()).filter(name -> !seen.add(name)).collect(Collectors.toSet());
            throw new IllegalArgumentException(String.format("Duplicate fields [%s] in Replace command", String.join((CharSequence)", ", duplicates)));
        }
        return uniqueFields;
    }

    @Override
    public UnresolvedPlan visitRareTopCommand(OpenSearchPPLParser.RareTopCommandContext ctx) {
        List<UnresolvedExpression> groupList = ctx.byClause() == null ? Collections.emptyList() : this.getGroupByList(ctx.byClause());
        Integer noOfResults = ctx.number != null ? (Integer)((Literal)this.expressionBuilder.visitIntegerLiteral(ctx.number)).getValue() : 10;
        return new RareTopN(ctx.TOP() != null ? RareTopN.CommandType.TOP : RareTopN.CommandType.RARE, noOfResults, ArgumentFactory.getArgumentList(ctx, this.settings), this.getFieldList(ctx.fieldList()), groupList);
    }

    @Override
    public UnresolvedPlan visitExpandCommand(OpenSearchPPLParser.ExpandCommandContext ctx) {
        Field fieldExpression = (Field)this.internalVisitExpression((ParseTree)ctx.fieldExpression());
        String alias = ctx.alias != null ? this.internalVisitExpression((ParseTree)ctx.alias).toString() : null;
        return new Expand(fieldExpression, alias);
    }

    @Override
    public UnresolvedPlan visitGrokCommand(OpenSearchPPLParser.GrokCommandContext ctx) {
        UnresolvedExpression sourceField = this.internalVisitExpression((ParseTree)ctx.source_field);
        Literal pattern = (Literal)this.internalVisitExpression((ParseTree)ctx.pattern);
        return new Parse(ParseMethod.GROK, sourceField, pattern, (java.util.Map<String, Literal>)ImmutableMap.of());
    }

    @Override
    public UnresolvedPlan visitParseCommand(OpenSearchPPLParser.ParseCommandContext ctx) {
        UnresolvedExpression sourceField = this.internalVisitExpression((ParseTree)ctx.source_field);
        Literal pattern = (Literal)this.internalVisitExpression((ParseTree)ctx.pattern);
        return new Parse(ParseMethod.REGEX, sourceField, pattern, (java.util.Map<String, Literal>)ImmutableMap.of());
    }

    @Override
    public UnresolvedPlan visitSpathCommand(OpenSearchPPLParser.SpathCommandContext ctx) {
        String inField = null;
        String outField = null;
        String path = null;
        for (OpenSearchPPLParser.SpathParameterContext param : ctx.spathParameter()) {
            if (param.input != null) {
                inField = param.input.getText();
            }
            if (param.output != null) {
                outField = param.output.getText();
            }
            if (param.path == null) continue;
            path = param.path.getText();
        }
        if (inField == null) {
            throw new IllegalArgumentException("`input` parameter is required for `spath`");
        }
        if (path == null) {
            throw new IllegalArgumentException("`path` parameter is required for `spath`");
        }
        return new SPath(inField, outField, path);
    }

    @Override
    public UnresolvedPlan visitPatternsCommand(OpenSearchPPLParser.PatternsCommandContext ctx) {
        UnresolvedExpression sourceField = this.internalVisitExpression((ParseTree)ctx.source_field);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ctx.patternsParameter().forEach(x -> {
            String argName = ((ParseTree)x.children.get(0)).toString();
            Literal value = (Literal)this.internalVisitExpression((ParseTree)x.children.get(2));
            builder.put((Object)argName, (Object)value);
        });
        ImmutableMap arguments = builder.build();
        ImmutableMap.Builder cmdOptionsBuilder = ImmutableMap.builder();
        ctx.patternsCommandOption().forEach(option -> {
            String argName = ((ParseTree)option.children.get(0)).toString();
            Literal value = (Literal)this.internalVisitExpression((ParseTree)option.children.get(2));
            cmdOptionsBuilder.put((Object)argName, (Object)value);
        });
        ImmutableMap cmdOptions = cmdOptionsBuilder.build();
        String patternMethod = cmdOptions.getOrDefault("method", AstDSL.stringLiteral((String)this.settings.getSettingValue(Settings.Key.PATTERN_METHOD))).toString();
        String patternMode = cmdOptions.getOrDefault("mode", AstDSL.stringLiteral((String)this.settings.getSettingValue(Settings.Key.PATTERN_MODE))).toString();
        Literal patternMaxSampleCount = cmdOptions.getOrDefault("max_sample_count", AstDSL.intLiteral((Integer)this.settings.getSettingValue(Settings.Key.PATTERN_MAX_SAMPLE_COUNT)));
        Literal patternBufferLimit = cmdOptions.getOrDefault("buffer_limit", AstDSL.intLiteral((Integer)this.settings.getSettingValue(Settings.Key.PATTERN_BUFFER_LIMIT)));
        Literal showNumberedToken = cmdOptions.getOrDefault("show_numbered_token", AstDSL.booleanLiteral((Boolean)this.settings.getSettingValue(Settings.Key.PATTERN_SHOW_NUMBERED_TOKEN)));
        List<UnresolvedExpression> partitionByList = this.getPartitionExprList(ctx.statsByClause());
        return new Patterns(sourceField, partitionByList, arguments.getOrDefault("new_field", AstDSL.stringLiteral("patterns_field")).toString(), PatternMethod.valueOf(patternMethod.toUpperCase(Locale.ROOT)), PatternMode.valueOf(patternMode.toUpperCase(Locale.ROOT)), patternMaxSampleCount, patternBufferLimit, showNumberedToken, (java.util.Map<String, Literal>)arguments);
    }

    @Override
    public UnresolvedPlan visitLookupCommand(OpenSearchPPLParser.LookupCommandContext ctx) {
        Relation lookupRelation = new Relation(this.internalVisitExpression((ParseTree)ctx.tableSource()));
        Lookup.OutputStrategy strategy = ctx.APPEND() != null ? Lookup.OutputStrategy.APPEND : Lookup.OutputStrategy.REPLACE;
        java.util.Map<String, String> mappingAliasMap = this.buildFieldAliasMap(ctx.lookupMappingList().lookupPair());
        java.util.Map<String, String> outputAliasMap = ctx.outputCandidateList() == null ? Collections.emptyMap() : this.buildFieldAliasMap(ctx.outputCandidateList().lookupPair());
        return new Lookup(lookupRelation, mappingAliasMap, strategy, outputAliasMap);
    }

    private java.util.Map<String, String> buildFieldAliasMap(List<OpenSearchPPLParser.LookupPairContext> lookupPairContext) {
        return lookupPairContext.stream().collect(Collectors.toMap(pair -> pair.inputField.getText(), pair -> pair.AS() != null ? pair.outputField.getText() : pair.inputField.getText(), (x, y) -> y, LinkedHashMap::new));
    }

    @Override
    public UnresolvedPlan visitTableOrSubqueryClause(OpenSearchPPLParser.TableOrSubqueryClauseContext ctx) {
        if (ctx.subSearch() != null) {
            return ctx.alias != null ? new SubqueryAlias(this.internalVisitExpression((ParseTree)ctx.alias).toString(), this.visitSubSearch(ctx.subSearch())) : this.visitSubSearch(ctx.subSearch());
        }
        return this.visitTableSourceClause(ctx.tableSourceClause());
    }

    @Override
    public UnresolvedPlan visitTableSourceClause(OpenSearchPPLParser.TableSourceClauseContext ctx) {
        Relation relation = new Relation(ctx.tableSource().stream().map(this::internalVisitExpression).collect(Collectors.toList()));
        return ctx.alias != null ? new SubqueryAlias(this.internalVisitExpression((ParseTree)ctx.alias).toString(), relation) : relation;
    }

    @Override
    public UnresolvedPlan visitDynamicSourceClause(OpenSearchPPLParser.DynamicSourceClauseContext ctx) {
        throw new UnsupportedOperationException("Dynamic source clause with metadata filters is not supported.");
    }

    @Override
    public UnresolvedPlan visitTableFunction(OpenSearchPPLParser.TableFunctionContext ctx) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ctx.namedFunctionArgs().namedFunctionArg().forEach(arg -> {
            String argName = arg.ident() != null ? arg.ident().getText() : null;
            builder.add((Object)new UnresolvedArgument(argName, this.internalVisitExpression((ParseTree)arg.functionArgExpression())));
        });
        return new TableFunction(this.internalVisitExpression((ParseTree)ctx.qualifiedName()), (List<UnresolvedExpression>)builder.build());
    }

    private UnresolvedExpression internalVisitExpression(ParseTree tree) {
        return (UnresolvedExpression)this.expressionBuilder.visit(tree);
    }

    protected UnresolvedPlan aggregateResult(UnresolvedPlan aggregate, UnresolvedPlan nextResult) {
        if (nextResult != this.defaultResult()) {
            return nextResult;
        }
        return aggregate;
    }

    @Override
    public UnresolvedPlan visitKmeansCommand(OpenSearchPPLParser.KmeansCommandContext ctx) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ctx.kmeansParameter().forEach(x -> builder.put((Object)((ParseTree)x.children.get(0)).toString(), (Object)((Literal)this.internalVisitExpression((ParseTree)x.children.get(2)))));
        return new Kmeans((java.util.Map<String, Literal>)builder.build());
    }

    @Override
    public UnresolvedPlan visitAdCommand(OpenSearchPPLParser.AdCommandContext ctx) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ctx.adParameter().forEach(x -> builder.put((Object)((ParseTree)x.children.get(0)).toString(), (Object)((Literal)this.internalVisitExpression((ParseTree)x.children.get(2)))));
        return new AD((java.util.Map<String, Literal>)builder.build());
    }

    @Override
    public UnresolvedPlan visitMlCommand(OpenSearchPPLParser.MlCommandContext ctx) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ctx.mlArg().forEach(x -> builder.put((Object)x.argName.getText(), (Object)((Literal)this.internalVisitExpression((ParseTree)x.argValue))));
        return new ML((java.util.Map<String, Literal>)builder.build());
    }

    @Override
    public UnresolvedPlan visitFillNullWith(OpenSearchPPLParser.FillNullWithContext ctx) {
        if (ctx.IN() != null) {
            return FillNull.ofSameValue(this.internalVisitExpression((ParseTree)ctx.replacement), ctx.fieldList().fieldExpression().stream().map(f -> (Field)this.internalVisitExpression((ParseTree)f)).toList());
        }
        return FillNull.ofSameValue(this.internalVisitExpression((ParseTree)ctx.replacement), List.of());
    }

    @Override
    public UnresolvedPlan visitFillNullUsing(OpenSearchPPLParser.FillNullUsingContext ctx) {
        ImmutableList.Builder replacementsBuilder = ImmutableList.builder();
        for (int i = 0; i < ctx.replacementPair().size(); ++i) {
            replacementsBuilder.add((Object)Pair.of((Object)((Field)this.internalVisitExpression((ParseTree)ctx.replacementPair(i).fieldExpression())), (Object)this.internalVisitExpression((ParseTree)ctx.replacementPair((int)i).replacement)));
        }
        return FillNull.ofVariousValue((List<Pair<Field, UnresolvedExpression>>)replacementsBuilder.build());
    }

    @Override
    public UnresolvedPlan visitFillNullValueWithFields(OpenSearchPPLParser.FillNullValueWithFieldsContext ctx) {
        return FillNull.ofSameValue(this.internalVisitExpression((ParseTree)ctx.replacement), ctx.fieldList().fieldExpression().stream().map(f -> (Field)this.internalVisitExpression((ParseTree)f)).toList(), true);
    }

    @Override
    public UnresolvedPlan visitFillNullValueAllFields(OpenSearchPPLParser.FillNullValueAllFieldsContext ctx) {
        return FillNull.ofSameValue(this.internalVisitExpression((ParseTree)ctx.replacement), List.of(), true);
    }

    @Override
    public UnresolvedPlan visitFlattenCommand(OpenSearchPPLParser.FlattenCommandContext ctx) {
        Field field = (Field)this.internalVisitExpression((ParseTree)ctx.fieldExpression());
        List<String> aliases = ctx.aliases == null ? null : this.getAliasList((OpenSearchPPLParser.IdentsAsQualifiedNameSeqContext)ctx.aliases);
        return new Flatten(field, aliases);
    }

    private List<String> getAliasList(OpenSearchPPLParser.IdentsAsQualifiedNameSeqContext ctx) {
        return ctx.qualifiedName().stream().map(this::internalVisitExpression).map(Object::toString).collect(Collectors.toList());
    }

    @Override
    public UnresolvedPlan visitTrendlineCommand(OpenSearchPPLParser.TrendlineCommandContext ctx) {
        List<Trendline.TrendlineComputation> trendlineComputations = ctx.trendlineClause().stream().map(arg_0 -> ((AstExpressionBuilder)this.expressionBuilder).visit(arg_0)).map(Trendline.TrendlineComputation.class::cast).collect(Collectors.toList());
        return Optional.ofNullable(ctx.sortField()).map(this::internalVisitExpression).map(Field.class::cast).map(sort -> new Trendline(Optional.of(sort), trendlineComputations)).orElse(new Trendline(Optional.empty(), trendlineComputations));
    }

    @Override
    public UnresolvedPlan visitAppendcolCommand(OpenSearchPPLParser.AppendcolCommandContext ctx) {
        boolean override;
        Optional<UnresolvedPlan> subsearch = ctx.commands().stream().map(arg_0 -> ((AstBuilder)this).visit(arg_0)).reduce((r, e) -> e.attach((UnresolvedPlan)r));
        boolean bl = override = ctx.override != null && Boolean.parseBoolean(ctx.override.getText());
        if (subsearch.isEmpty()) {
            throw new SemanticCheckException("subsearch should not be empty");
        }
        return new AppendCol(override, subsearch.get());
    }

    @Override
    public UnresolvedPlan visitRegexCommand(OpenSearchPPLParser.RegexCommandContext ctx) {
        UnresolvedExpression field = this.internalVisitExpression((ParseTree)ctx.regexExpr().field);
        boolean negated = ctx.regexExpr().operator.getType() == 192;
        Literal pattern = (Literal)this.internalVisitExpression((ParseTree)ctx.regexExpr().pattern);
        return new Regex(field, negated, pattern);
    }

    @Override
    public UnresolvedPlan visitAppendCommand(OpenSearchPPLParser.AppendCommandContext ctx) {
        UnresolvedPlan searchCommandInSubSearch = ctx.searchCommand() != null ? (UnresolvedPlan)this.visit((ParseTree)ctx.searchCommand()) : EmptySourcePropagateVisitor.EMPTY_SOURCE;
        UnresolvedPlan subsearch = ctx.commands().stream().map(arg_0 -> ((AstBuilder)this).visit(arg_0)).reduce(searchCommandInSubSearch, (r, e) -> e.attach((UnresolvedPlan)r));
        return new Append(subsearch);
    }

    @Override
    public UnresolvedPlan visitMultisearchCommand(OpenSearchPPLParser.MultisearchCommandContext ctx) {
        ArrayList<UnresolvedPlan> subsearches = new ArrayList<UnresolvedPlan>();
        for (OpenSearchPPLParser.SubSearchContext subsearchCtx : ctx.subSearch()) {
            UnresolvedPlan fullSubsearch = this.visitSubSearch(subsearchCtx);
            subsearches.add(fullSubsearch);
        }
        if (subsearches.size() < 2) {
            throw new SyntaxCheckException("Multisearch command requires at least two subsearches. Provided: " + subsearches.size());
        }
        return new Multisearch(subsearches);
    }

    @Override
    public UnresolvedPlan visitRexCommand(OpenSearchPPLParser.RexCommandContext ctx) {
        int effectiveMaxMatch;
        UnresolvedExpression field = this.internalVisitExpression((ParseTree)ctx.rexExpr().field);
        Literal pattern = (Literal)this.internalVisitExpression((ParseTree)ctx.rexExpr().pattern);
        Rex.RexMode mode = Rex.RexMode.EXTRACT;
        Optional<Integer> maxMatch = Optional.empty();
        Optional<String> offsetField = Optional.empty();
        for (OpenSearchPPLParser.RexOptionContext optionCtx : ctx.rexExpr().rexOption()) {
            if (optionCtx.maxMatch != null) {
                maxMatch = Optional.of(Integer.parseInt(optionCtx.maxMatch.getText()));
            }
            if (optionCtx.EXTRACT() != null) {
                mode = Rex.RexMode.EXTRACT;
            }
            if (optionCtx.SED() != null) {
                mode = Rex.RexMode.SED;
            }
            if (optionCtx.offsetField == null) continue;
            offsetField = Optional.of(optionCtx.offsetField.getText());
        }
        if (mode == Rex.RexMode.SED && offsetField.isPresent()) {
            throw new IllegalArgumentException("Rex command: offset_field cannot be used with mode=sed. The offset_field option is only supported in extract mode.");
        }
        int maxMatchLimit = this.settings != null ? (Integer)this.settings.getSettingValue(Settings.Key.PPL_REX_MAX_MATCH_LIMIT) : 10;
        int userMaxMatch = maxMatch.orElse(1);
        if (userMaxMatch == 0) {
            effectiveMaxMatch = maxMatchLimit;
        } else {
            if (userMaxMatch > maxMatchLimit) {
                throw new IllegalArgumentException(String.format("Rex command max_match value (%d) exceeds the configured limit (%d). Consider using a smaller max_match value" + (this.settings != null ? " or adjust the plugins.ppl.rex.max_match.limit setting." : "."), userMaxMatch, maxMatchLimit));
            }
            effectiveMaxMatch = userMaxMatch;
        }
        return new Rex(field, pattern, mode, Optional.of(effectiveMaxMatch), offsetField);
    }

    private String getTextInQuery(ParserRuleContext ctx) {
        Token start = ctx.getStart();
        Token stop = ctx.getStop();
        return this.query.substring(start.getStartIndex(), stop.getStopIndex() + 1);
    }

    private UnresolvedPlan projectExceptMeta(UnresolvedPlan plan) {
        if (plan instanceof Project && !((Project)plan).isExcluded()) {
            return plan;
        }
        if (plan instanceof SubqueryAlias) {
            SubqueryAlias subqueryAlias = (SubqueryAlias)plan;
            return new SubqueryAlias(subqueryAlias.getAlias(), new Project((List<UnresolvedExpression>)ImmutableList.of((Object)AllFieldsExcludeMeta.of())).attach(subqueryAlias.getChild().getFirst()));
        }
        return new Project((List<UnresolvedExpression>)ImmutableList.of((Object)AllFieldsExcludeMeta.of())).attach(plan);
    }

    private List<UnresolvedExpression> getPartitionExprList(OpenSearchPPLParser.StatsByClauseContext ctx) {
        ImmutableList.Builder partExprListBuilder = new ImmutableList.Builder();
        Optional.ofNullable(ctx).map(OpenSearchPPLParser.StatsByClauseContext::bySpanClause).map(this::internalVisitExpression).ifPresent(arg_0 -> ((ImmutableList.Builder)partExprListBuilder).add(arg_0));
        Optional.ofNullable(ctx).map(OpenSearchPPLParser.StatsByClauseContext::fieldList).map(expr -> expr.fieldExpression().stream().map(groupCtx -> new Alias(StringUtils.unquoteIdentifier(this.getTextInQuery((ParserRuleContext)groupCtx)), this.internalVisitExpression((ParseTree)groupCtx))).collect(Collectors.toList())).ifPresent(arg_0 -> ((ImmutableList.Builder)partExprListBuilder).addAll(arg_0));
        return partExprListBuilder.build();
    }

    private boolean hasEnhancedFieldFeatures(OpenSearchPPLParser.FieldsCommandBodyContext bodyCtx, List<UnresolvedExpression> fields) {
        if (this.hasActualWildcards(bodyCtx)) {
            return true;
        }
        return this.hasSpaceDelimitedFields(bodyCtx);
    }

    private boolean hasSpaceDelimitedFields(OpenSearchPPLParser.FieldsCommandBodyContext bodyCtx) {
        if (bodyCtx.wcFieldList() == null) {
            return false;
        }
        String fieldsText = this.getTextInQuery(bodyCtx.wcFieldList());
        if (this.isAllFieldsBacktickEnclosed(bodyCtx)) {
            return false;
        }
        if (bodyCtx.wcFieldList().selectFieldExpression().size() > 1 && !fieldsText.contains(",")) {
            return true;
        }
        return fieldsText.contains(",") && this.hasSpacesBetweenFields(fieldsText);
    }

    private boolean hasSpacesBetweenFields(String fieldsText) {
        String[] parts;
        for (String part : parts = fieldsText.split(",")) {
            String trimmed = part.trim();
            if (!trimmed.contains(" ") || trimmed.split("\\s+").length <= 1 || trimmed.startsWith("`") && trimmed.endsWith("`")) continue;
            return true;
        }
        return false;
    }

    private boolean isAllFieldsBacktickEnclosed(OpenSearchPPLParser.FieldsCommandBodyContext bodyCtx) {
        for (OpenSearchPPLParser.SelectFieldExpressionContext fieldExpr : bodyCtx.wcFieldList().selectFieldExpression()) {
            String originalText;
            if (fieldExpr.wcQualifiedName() == null || (originalText = this.getTextInQuery(fieldExpr.wcQualifiedName())).startsWith("`") && originalText.endsWith("`")) continue;
            return false;
        }
        return true;
    }

    private boolean hasActualWildcards(OpenSearchPPLParser.FieldsCommandBodyContext bodyCtx) {
        if (bodyCtx.wcFieldList() == null) {
            return false;
        }
        for (OpenSearchPPLParser.SelectFieldExpressionContext fieldExpr : bodyCtx.wcFieldList().selectFieldExpression()) {
            String originalText;
            if (fieldExpr.STAR() != null) {
                return true;
            }
            if (fieldExpr.wcQualifiedName() == null || !(originalText = this.getTextInQuery(fieldExpr.wcQualifiedName())).contains("*") || originalText.contains("`")) continue;
            return true;
        }
        return false;
    }
}

