/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.returntypes;

import com.amazon.randomcutforest.returntypes.DiVector;
import com.amazon.randomcutforest.returntypes.InterpolationMeasure;

public class DensityOutput
extends InterpolationMeasure {
    public static final double DEFAULT_SUM_OF_POINTS_SCALING_FACTOR = 0.001;

    public DensityOutput(int dimensions, int sampleSize) {
        super(dimensions, sampleSize);
    }

    public DensityOutput(InterpolationMeasure base) {
        super(base);
    }

    public double getDensity(double q, int manifoldDimension) {
        double sumOfPts = this.measure.getHighLowSum() / (double)this.sampleSize;
        if (sumOfPts <= 0.0) {
            return 0.0;
        }
        double sumOfFactors = 0.0;
        for (int i = 0; i < this.dimensions; ++i) {
            double t;
            double d = t = this.probMass.getHighLowSum(i) > 0.0 ? this.distances.getHighLowSum(i) / this.probMass.getHighLowSum(i) : 0.0;
            if (t > 0.0) {
                t = Math.exp(Math.log(t) * (double)manifoldDimension) * this.probMass.getHighLowSum(i);
            }
            sumOfFactors += t;
        }
        return sumOfPts / (q * sumOfPts + sumOfFactors);
    }

    public double getDensity() {
        return this.getDensity(0.001, this.dimensions);
    }

    public DiVector getDirectionalDensity(double q, int manifoldDimension) {
        double density = this.getDensity(q, manifoldDimension);
        double sumOfPts = this.measure.getHighLowSum();
        DiVector factors = new DiVector(super.getDimensions());
        if (sumOfPts > 0.0) {
            factors = this.measure.scale(density / sumOfPts);
        }
        return factors;
    }

    public DiVector getDirectionalDensity() {
        return this.getDirectionalDensity(0.001, this.dimensions);
    }
}

