"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.config = exports.configMetadata = void 0;
var config_objects_1 = require("../../../../common/config_objects");
exports.configMetadata = {
    width: { dflt: 300, min: 0, max: 1024, type: 'number', reconfigurable: false },
    height: { dflt: 150, min: 0, max: 1024, type: 'number', reconfigurable: false },
    margin: {
        type: 'group',
        values: {
            left: { dflt: 0, min: -0.25, max: 0.25, type: 'number' },
            right: { dflt: 0, min: -0.25, max: 0.25, type: 'number' },
            top: { dflt: 0, min: -0.25, max: 0.25, type: 'number' },
            bottom: { dflt: 0, min: -0.25, max: 0.25, type: 'number' },
        },
    },
    fontFamily: {
        dflt: 'Impact',
        type: 'string',
    },
    minFontSize: { dflt: 10, min: 10, max: 50, type: 'number', reconfigurable: true },
    maxFontSize: { dflt: 70, min: 15, max: 150, type: 'number', reconfigurable: true },
    backgroundColor: { dflt: '#ffffff', type: 'color' },
    sectorLineWidth: { dflt: 1, min: 0, max: 4, type: 'number' },
};
exports.config = config_objects_1.configMap(function (item) { return item.dflt; }, exports.configMetadata);
//# sourceMappingURL=config.js.map