"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiTourStep", {
  enumerable: true,
  get: function get() {
    return _tour_step.EuiTourStep;
  }
});
exports.OuiTourStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _beacon = require("../beacon");
var _button = require("../button");
var _flex = require("../flex");
var _i18n = require("../i18n");
var _popover = require("../popover");
var _title = require("../title");
var _tour_step_indicator = require("./tour_step_indicator");
var _services = require("../../services");
var _tour_step = require("../../eui_components/tour/tour_step");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0) { ; } } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) { n[e] = r[e]; } return n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var OuiTourStep = function OuiTourStep(_ref) {
  var _ref$anchorPosition = _ref.anchorPosition,
    anchorPosition = _ref$anchorPosition === void 0 ? 'leftUp' : _ref$anchorPosition,
    children = _ref.children,
    className = _ref.className,
    _ref$closePopover = _ref.closePopover,
    closePopover = _ref$closePopover === void 0 ? function () {} : _ref$closePopover,
    content = _ref.content,
    _ref$isStepOpen = _ref.isStepOpen,
    isStepOpen = _ref$isStepOpen === void 0 ? false : _ref$isStepOpen,
    _ref$minWidth = _ref.minWidth,
    minWidth = _ref$minWidth === void 0 ? true : _ref$minWidth,
    onFinish = _ref.onFinish,
    _ref$step = _ref.step,
    step = _ref$step === void 0 ? 1 : _ref$step,
    stepsTotal = _ref.stepsTotal,
    style = _ref.style,
    subtitle = _ref.subtitle,
    title = _ref.title,
    _ref$decoration = _ref.decoration,
    decoration = _ref$decoration === void 0 ? 'beacon' : _ref$decoration,
    footerAction = _ref.footerAction,
    rest = _objectWithoutProperties(_ref, ["anchorPosition", "children", "className", "closePopover", "content", "isStepOpen", "minWidth", "onFinish", "step", "stepsTotal", "style", "subtitle", "title", "decoration", "footerAction"]);
  var generatedId = (0, _services.htmlIdGenerator)();
  var titleId = generatedId();
  if (step === 0) {
    console.warn('OuiTourStep `step` should 1-based indexing. Please update to eliminate 0 indexes.');
  }
  var newStyle;
  var widthClassName;
  if (minWidth === true) {
    widthClassName = 'ouiTour--minWidth-default';
  } else if (minWidth !== false) {
    var value = typeof minWidth === 'number' ? "".concat(minWidth, "px") : minWidth;
    newStyle = _objectSpread(_objectSpread({}, style), {}, {
      minWidth: value
    });
  }
  var classes = (0, _classnames.default)('ouiTour', widthClassName, className);
  var finishButtonProps = {
    color: 'text',
    flush: 'right',
    size: 'xs'
  };
  var footer = /*#__PURE__*/_react.default.createElement(_flex.OuiFlexGroup, {
    responsive: false,
    justifyContent: stepsTotal > 1 ? 'spaceBetween' : 'flexEnd'
  }, stepsTotal > 1 && /*#__PURE__*/_react.default.createElement(_flex.OuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("ul", {
    className: "ouiTourFooter__stepList"
  }, _toConsumableArray(Array(stepsTotal).keys()).map(function (_, i) {
    var status = 'complete';
    if (step === i + 1) {
      status = 'active';
    } else if (step <= i) {
      status = 'incomplete';
    }
    return /*#__PURE__*/_react.default.createElement(_tour_step_indicator.OuiTourStepIndicator, {
      key: i,
      number: i + 1,
      status: status
    });
  }))), footerAction ? /*#__PURE__*/_react.default.createElement(_flex.OuiFlexItem, {
    grow: false
  }, footerAction) : /*#__PURE__*/_react.default.createElement(_flex.OuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
    tokens: ['ouiTourStep.endTour', 'ouiTourStep.skipTour', 'ouiTourStep.closeTour'],
    defaults: ['End tour', 'Skip tour', 'Close tour']
  }, function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 3),
      endTour = _ref3[0],
      skipTour = _ref3[1],
      closeTour = _ref3[2];
    var content = closeTour;
    if (stepsTotal > 1) {
      content = stepsTotal === step ? endTour : skipTour;
    }
    return /*#__PURE__*/_react.default.createElement(_button.OuiButtonEmpty, _extends({
      onClick: onFinish
    }, finishButtonProps), content);
  })));
  var hasBeacon = decoration === 'beacon';
  return /*#__PURE__*/_react.default.createElement(_popover.OuiPopover, _extends({
    anchorPosition: anchorPosition,
    button: children,
    closePopover: closePopover,
    isOpen: isStepOpen,
    ownFocus: false,
    panelClassName: classes,
    panelStyle: newStyle || style,
    offset: hasBeacon ? 10 : 0,
    "aria-labelledby": titleId,
    arrowChildren: hasBeacon && /*#__PURE__*/_react.default.createElement(_beacon.OuiBeacon, {
      className: "ouiTour__beacon"
    })
  }, rest), /*#__PURE__*/_react.default.createElement(_popover.OuiPopoverTitle, {
    className: "ouiTourHeader",
    id: titleId
  }, /*#__PURE__*/_react.default.createElement(_title.OuiTitle, {
    size: "xxxs",
    className: "ouiTourHeader__subtitle"
  }, /*#__PURE__*/_react.default.createElement("h1", null, subtitle)), /*#__PURE__*/_react.default.createElement(_title.OuiTitle, {
    size: "xxs",
    className: "ouiTourHeader__title"
  }, /*#__PURE__*/_react.default.createElement("h2", null, title))), /*#__PURE__*/_react.default.createElement("div", {
    className: "ouiTour__content"
  }, content), /*#__PURE__*/_react.default.createElement(_popover.OuiPopoverFooter, {
    className: "ouiTourFooter"
  }, footer));
};

/* OUI -> EUI Aliases: Build-Time */
exports.OuiTourStep = OuiTourStep;
OuiTourStep.propTypes = {
  /**
     * Element to which the tour step popover attaches when open
     */
  children: _propTypes.default.element.isRequired,
  /**
     * Contents of the tour step popover
     */
  content: _propTypes.default.node.isRequired,
  /**
     * Step will display if set to `true`
     */
  isStepOpen: _propTypes.default.bool,
  /**
     * Sets the min-width of the tour popover,
     * set to `true` to use the default size,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  minWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),
  /**
     * Function to call for 'Skip tour' and 'End tour' actions
     */
  onFinish: _propTypes.default.func.isRequired,
  /**
     * The number of the step within the parent tour. 1-based indexing.
     */
  step: _propTypes.default.number.isRequired,
  /**
     * The total number of steps in the tour
     */
  stepsTotal: _propTypes.default.number.isRequired,
  /**
     * Optional, standard DOM `style` attribute. Passed to the OuiPopover panel.
     */
  style: _propTypes.default.any,
  /**
     * Smaller title text that appears atop each step in the tour. The subtitle gets wrapped in the appropriate heading level.
     */
  subtitle: _propTypes.default.node.isRequired,
  /**
     * Larger title text specific to this step. The title gets wrapped in the appropriate heading level.
     */
  title: _propTypes.default.node.isRequired,
  /**
     * Extra visual indication of step location
     */
  decoration: _propTypes.default.oneOf(["none", "beacon"]),
  /**
     * Element to replace the 'Skip tour' link in the footer
     */
  footerAction: _propTypes.default.element,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};
/* OUI -> EUI Aliases: Build-Time */