var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/tree/AbstractParseTreeVisitor.ts
var AbstractParseTreeVisitor_exports = {};
__export(AbstractParseTreeVisitor_exports, {
  AbstractParseTreeVisitor: () => AbstractParseTreeVisitor
});
module.exports = __toCommonJS(AbstractParseTreeVisitor_exports);
var AbstractParseTreeVisitor = class {
  static {
    __name(this, "AbstractParseTreeVisitor");
  }
  visit(tree) {
    return tree.accept(this);
  }
  visitChildren(node) {
    let result = this.defaultResult();
    const n = node.getChildCount();
    for (let i = 0; i < n; i++) {
      if (!this.shouldVisitNextChild(node, result)) {
        break;
      }
      const c = node.getChild(i);
      if (c) {
        const childResult = c.accept(this);
        result = this.aggregateResult(result, childResult);
      }
    }
    return result;
  }
  visitTerminal(_node) {
    return this.defaultResult();
  }
  visitErrorNode(_node) {
    return this.defaultResult();
  }
  defaultResult() {
    return null;
  }
  shouldVisitNextChild(_node, _currentResult) {
    return true;
  }
  aggregateResult(aggregate, nextResult) {
    return nextResult;
  }
};
