"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PLUGIN_NAME_AS_TITLE = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.PLUGIN_DESCRIPTION = exports.NDJSON_FILE_TYPE = exports.JSON_FILE_TYPE = exports.DYNAMIC_MAPPING_TYPES = exports.DEFAULT_SUPPORTED_FILE_TYPES_LIST = exports.CSV_SUPPORTED_DELIMITERS = exports.CSV_FILE_TYPE = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const PLUGIN_NAME_AS_TITLE = exports.PLUGIN_NAME_AS_TITLE = 'Import Data';
const PLUGIN_DESCRIPTION = exports.PLUGIN_DESCRIPTION = 'Import data from files (CSV, JSON, NDJSON) into OpenSearch indexes.';
const PLUGIN_ID = exports.PLUGIN_ID = 'dataImporter';
const PLUGIN_NAME = exports.PLUGIN_NAME = 'dataImporter';
const CSV_FILE_TYPE = exports.CSV_FILE_TYPE = 'csv';
const JSON_FILE_TYPE = exports.JSON_FILE_TYPE = 'json';
const NDJSON_FILE_TYPE = exports.NDJSON_FILE_TYPE = 'ndjson';
const DEFAULT_SUPPORTED_FILE_TYPES_LIST = exports.DEFAULT_SUPPORTED_FILE_TYPES_LIST = [CSV_FILE_TYPE, JSON_FILE_TYPE, NDJSON_FILE_TYPE];
const CSV_SUPPORTED_DELIMITERS = exports.CSV_SUPPORTED_DELIMITERS = [',', ';', '\t', '|'];
let DYNAMIC_MAPPING_TYPES = exports.DYNAMIC_MAPPING_TYPES = /*#__PURE__*/function (DYNAMIC_MAPPING_TYPES) {
  DYNAMIC_MAPPING_TYPES["NULL"] = "null";
  DYNAMIC_MAPPING_TYPES["BOOLEAN"] = "boolean";
  DYNAMIC_MAPPING_TYPES["FLOAT"] = "float";
  DYNAMIC_MAPPING_TYPES["DOUBLE"] = "double";
  DYNAMIC_MAPPING_TYPES["INTEGER"] = "integer";
  DYNAMIC_MAPPING_TYPES["OBJECT"] = "object";
  DYNAMIC_MAPPING_TYPES["ARRAY"] = "array";
  DYNAMIC_MAPPING_TYPES["TEXT"] = "text";
  DYNAMIC_MAPPING_TYPES["KEYWORD"] = "keyword";
  DYNAMIC_MAPPING_TYPES["DATE"] = "date";
  return DYNAMIC_MAPPING_TYPES;
}({});