"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _constants = require("../../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled = false) {
  const {
    indexService
  } = services;
  let getIndicesQuerySchema = {
    from: _configSchema.schema.number(),
    size: _configSchema.schema.number(),
    search: _configSchema.schema.string(),
    sortField: _configSchema.schema.string(),
    sortDirection: _configSchema.schema.string(),
    terms: _configSchema.schema.maybe(_configSchema.schema.any()),
    indices: _configSchema.schema.maybe(_configSchema.schema.any()),
    dataStreams: _configSchema.schema.maybe(_configSchema.schema.any()),
    showDataStreams: _configSchema.schema.boolean(),
    expandWildcards: _configSchema.schema.maybe(_configSchema.schema.string()),
    exactSearch: _configSchema.schema.maybe(_configSchema.schema.string())
  };
  if (dataSourceEnabled) {
    getIndicesQuerySchema = {
      ...getIndicesQuerySchema,
      dataSourceId: _configSchema.schema.string()
    };
  }
  router.get({
    path: _constants.NODE_API._INDICES,
    validate: {
      query: _configSchema.schema.object(getIndicesQuerySchema)
    }
  }, indexService.getIndices);
  router.post({
    path: _constants.NODE_API.APPLY_POLICY,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, indexService.applyPolicy);
  router.post({
    path: _constants.NODE_API.EDIT_ROLLOVER_ALIAS,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, indexService.editRolloverAlias);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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