"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _common = require("../../common");
var _helpers = require("./utils/helpers");
var _configSchema = require("@osd/config-schema");
var _constants = require("./utils/constants");
var _metricHelper = require("./utils/metricHelper");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(router) {
  router.get({
    path: `${_common.API_PREFIX}/getReportSource/{reportSourceType}`,
    validate: {
      params: _configSchema.schema.object({
        reportSourceType: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    let responseParams;
    if (request.params.reportSourceType === 'dashboard') {
      const params = {
        index: '.kibana',
        q: 'type:dashboard',
        size: _constants.DEFAULT_MAX_SIZE
      };
      responseParams = params;
    } else if (request.params.reportSourceType === 'visualization') {
      const params = {
        index: '.kibana',
        q: 'type:visualization',
        size: _constants.DEFAULT_MAX_SIZE
      };
      responseParams = params;
    } else if (request.params.reportSourceType === 'search') {
      const params = {
        index: '.kibana',
        q: 'type:search',
        size: _constants.DEFAULT_MAX_SIZE
      };
      responseParams = params;
    }
    try {
      const opensearchResp = await context.core.opensearch.legacy.client.callAsCurrentUser('search', responseParams);
      (0, _metricHelper.addToMetric)('report_source', 'list', 'count');
      return response.ok({
        body: opensearchResp
      });
    } catch (error) {
      //@ts-ignore
      context.reporting_plugin.logger.error(`Failed to get reports source for ${request.params.reportSourceType}: ${error}`);
      (0, _metricHelper.addToMetric)('report_source', 'list', (0, _helpers.checkErrorType)(error));
      return response.custom({
        statusCode: error.statusCode,
        body: (0, _helpers.parseOpenSearchErrorResponse)(error)
      });
    }
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29tbW9uIiwicmVxdWlyZSIsIl9oZWxwZXJzIiwiX2NvbmZpZ1NjaGVtYSIsIl9jb25zdGFudHMiLCJfbWV0cmljSGVscGVyIiwiX2RlZmF1bHQiLCJyb3V0ZXIiLCJnZXQiLCJwYXRoIiwiQVBJX1BSRUZJWCIsInZhbGlkYXRlIiwicGFyYW1zIiwic2NoZW1hIiwib2JqZWN0IiwicmVwb3J0U291cmNlVHlwZSIsInN0cmluZyIsImNvbnRleHQiLCJyZXF1ZXN0IiwicmVzcG9uc2UiLCJyZXNwb25zZVBhcmFtcyIsImluZGV4IiwicSIsInNpemUiLCJERUZBVUxUX01BWF9TSVpFIiwib3BlbnNlYXJjaFJlc3AiLCJjb3JlIiwib3BlbnNlYXJjaCIsImxlZ2FjeSIsImNsaWVudCIsImNhbGxBc0N1cnJlbnRVc2VyIiwiYWRkVG9NZXRyaWMiLCJvayIsImJvZHkiLCJlcnJvciIsInJlcG9ydGluZ19wbHVnaW4iLCJsb2dnZXIiLCJjaGVja0Vycm9yVHlwZSIsImN1c3RvbSIsInN0YXR1c0NvZGUiLCJwYXJzZU9wZW5TZWFyY2hFcnJvclJlc3BvbnNlIiwibW9kdWxlIiwiZXhwb3J0cyIsImRlZmF1bHQiXSwic291cmNlcyI6WyJyZXBvcnRTb3VyY2UudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQge1xuICBJUm91dGVyLFxuICBJT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZSxcbiAgUmVzcG9uc2VFcnJvcixcbn0gZnJvbSAnLi4vLi4vLi4vLi4vc3JjL2NvcmUvc2VydmVyJztcbmltcG9ydCB7IEFQSV9QUkVGSVggfSBmcm9tICcuLi8uLi9jb21tb24nO1xuaW1wb3J0IHsgY2hlY2tFcnJvclR5cGUsIHBhcnNlT3BlblNlYXJjaEVycm9yUmVzcG9uc2UgfSBmcm9tICcuL3V0aWxzL2hlbHBlcnMnO1xuaW1wb3J0IHsgUmVxdWVzdFBhcmFtcyB9IGZyb20gJ0BlbGFzdGljL2VsYXN0aWNzZWFyY2gnO1xuaW1wb3J0IHsgc2NoZW1hIH0gZnJvbSAnQG9zZC9jb25maWctc2NoZW1hJztcbmltcG9ydCB7IERFRkFVTFRfTUFYX1NJWkUgfSBmcm9tICcuL3V0aWxzL2NvbnN0YW50cyc7XG5pbXBvcnQgeyBhZGRUb01ldHJpYyB9IGZyb20gJy4vdXRpbHMvbWV0cmljSGVscGVyJztcblxuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKHJvdXRlcjogSVJvdXRlcikge1xuICByb3V0ZXIuZ2V0KFxuICAgIHtcbiAgICAgIHBhdGg6IGAke0FQSV9QUkVGSVh9L2dldFJlcG9ydFNvdXJjZS97cmVwb3J0U291cmNlVHlwZX1gLFxuICAgICAgdmFsaWRhdGU6IHtcbiAgICAgICAgcGFyYW1zOiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICByZXBvcnRTb3VyY2VUeXBlOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgIH0pLFxuICAgICAgfSxcbiAgICB9LFxuICAgIGFzeW5jIChcbiAgICAgIGNvbnRleHQsXG4gICAgICByZXF1ZXN0LFxuICAgICAgcmVzcG9uc2VcbiAgICApOiBQcm9taXNlPElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlPGFueSB8IFJlc3BvbnNlRXJyb3I+PiA9PiB7XG4gICAgICBsZXQgcmVzcG9uc2VQYXJhbXM7XG4gICAgICBpZiAocmVxdWVzdC5wYXJhbXMucmVwb3J0U291cmNlVHlwZSA9PT0gJ2Rhc2hib2FyZCcpIHtcbiAgICAgICAgY29uc3QgcGFyYW1zOiBSZXF1ZXN0UGFyYW1zLlNlYXJjaCA9IHtcbiAgICAgICAgICBpbmRleDogJy5raWJhbmEnLFxuICAgICAgICAgIHE6ICd0eXBlOmRhc2hib2FyZCcsXG4gICAgICAgICAgc2l6ZTogREVGQVVMVF9NQVhfU0laRSxcbiAgICAgICAgfTtcbiAgICAgICAgcmVzcG9uc2VQYXJhbXMgPSBwYXJhbXM7XG4gICAgICB9IGVsc2UgaWYgKHJlcXVlc3QucGFyYW1zLnJlcG9ydFNvdXJjZVR5cGUgPT09ICd2aXN1YWxpemF0aW9uJykge1xuICAgICAgICBjb25zdCBwYXJhbXM6IFJlcXVlc3RQYXJhbXMuU2VhcmNoID0ge1xuICAgICAgICAgIGluZGV4OiAnLmtpYmFuYScsXG4gICAgICAgICAgcTogJ3R5cGU6dmlzdWFsaXphdGlvbicsXG4gICAgICAgICAgc2l6ZTogREVGQVVMVF9NQVhfU0laRSxcbiAgICAgICAgfTtcbiAgICAgICAgcmVzcG9uc2VQYXJhbXMgPSBwYXJhbXM7XG4gICAgICB9IGVsc2UgaWYgKHJlcXVlc3QucGFyYW1zLnJlcG9ydFNvdXJjZVR5cGUgPT09ICdzZWFyY2gnKSB7XG4gICAgICAgIGNvbnN0IHBhcmFtczogUmVxdWVzdFBhcmFtcy5TZWFyY2ggPSB7XG4gICAgICAgICAgaW5kZXg6ICcua2liYW5hJyxcbiAgICAgICAgICBxOiAndHlwZTpzZWFyY2gnLFxuICAgICAgICAgIHNpemU6IERFRkFVTFRfTUFYX1NJWkUsXG4gICAgICAgIH07XG4gICAgICAgIHJlc3BvbnNlUGFyYW1zID0gcGFyYW1zO1xuICAgICAgfSB0cnkge1xuICAgICAgICBjb25zdCBvcGVuc2VhcmNoUmVzcCA9IGF3YWl0IGNvbnRleHQuY29yZS5vcGVuc2VhcmNoLmxlZ2FjeS5jbGllbnQuY2FsbEFzQ3VycmVudFVzZXIoXG4gICAgICAgICAgJ3NlYXJjaCcsXG4gICAgICAgICAgcmVzcG9uc2VQYXJhbXNcbiAgICAgICAgKTtcbiAgICAgICAgYWRkVG9NZXRyaWMoJ3JlcG9ydF9zb3VyY2UnLCAnbGlzdCcsICdjb3VudCcpO1xuXG4gICAgICAgIHJldHVybiByZXNwb25zZS5vayh7XG4gICAgICAgICAgYm9keTogb3BlbnNlYXJjaFJlc3AsXG4gICAgICAgIH0pO1xuICAgICAgfSBjYXRjaCAoZXJyb3IpIHtcbiAgICAgICAgLy9AdHMtaWdub3JlXG4gICAgICAgIGNvbnRleHQucmVwb3J0aW5nX3BsdWdpbi5sb2dnZXIuZXJyb3IoXG4gICAgICAgICAgYEZhaWxlZCB0byBnZXQgcmVwb3J0cyBzb3VyY2UgZm9yICR7cmVxdWVzdC5wYXJhbXMucmVwb3J0U291cmNlVHlwZX06ICR7ZXJyb3J9YFxuICAgICAgICApO1xuICAgICAgICBhZGRUb01ldHJpYygncmVwb3J0X3NvdXJjZScsICdsaXN0JywgY2hlY2tFcnJvclR5cGUoZXJyb3IpKTtcbiAgICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgICAgc3RhdHVzQ29kZTogZXJyb3Iuc3RhdHVzQ29kZSxcbiAgICAgICAgICBib2R5OiBwYXJzZU9wZW5TZWFyY2hFcnJvclJlc3BvbnNlKGVycm9yKSxcbiAgICAgICAgfSk7XG4gICAgICB9XG4gICAgfVxuICApO1xufVxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFVQSxJQUFBQSxPQUFBLEdBQUFDLE9BQUE7QUFDQSxJQUFBQyxRQUFBLEdBQUFELE9BQUE7QUFFQSxJQUFBRSxhQUFBLEdBQUFGLE9BQUE7QUFDQSxJQUFBRyxVQUFBLEdBQUFILE9BQUE7QUFDQSxJQUFBSSxhQUFBLEdBQUFKLE9BQUE7QUFmQTtBQUNBO0FBQ0E7QUFDQTs7QUFjZSxTQUFBSyxTQUFVQyxNQUFlLEVBQUU7RUFDeENBLE1BQU0sQ0FBQ0MsR0FBRyxDQUNSO0lBQ0VDLElBQUksRUFBRyxHQUFFQyxrQkFBVyxxQ0FBb0M7SUFDeERDLFFBQVEsRUFBRTtNQUNSQyxNQUFNLEVBQUVDLG9CQUFNLENBQUNDLE1BQU0sQ0FBQztRQUNwQkMsZ0JBQWdCLEVBQUVGLG9CQUFNLENBQUNHLE1BQU0sQ0FBQztNQUNsQyxDQUFDO0lBQ0g7RUFDRixDQUFDLEVBQ0QsT0FDRUMsT0FBTyxFQUNQQyxPQUFPLEVBQ1BDLFFBQVEsS0FDd0Q7SUFDaEUsSUFBSUMsY0FBYztJQUNsQixJQUFJRixPQUFPLENBQUNOLE1BQU0sQ0FBQ0csZ0JBQWdCLEtBQUssV0FBVyxFQUFFO01BQ25ELE1BQU1ILE1BQTRCLEdBQUc7UUFDbkNTLEtBQUssRUFBRSxTQUFTO1FBQ2hCQyxDQUFDLEVBQUUsZ0JBQWdCO1FBQ25CQyxJQUFJLEVBQUVDO01BQ1IsQ0FBQztNQUNESixjQUFjLEdBQUdSLE1BQU07SUFDekIsQ0FBQyxNQUFNLElBQUlNLE9BQU8sQ0FBQ04sTUFBTSxDQUFDRyxnQkFBZ0IsS0FBSyxlQUFlLEVBQUU7TUFDOUQsTUFBTUgsTUFBNEIsR0FBRztRQUNuQ1MsS0FBSyxFQUFFLFNBQVM7UUFDaEJDLENBQUMsRUFBRSxvQkFBb0I7UUFDdkJDLElBQUksRUFBRUM7TUFDUixDQUFDO01BQ0RKLGNBQWMsR0FBR1IsTUFBTTtJQUN6QixDQUFDLE1BQU0sSUFBSU0sT0FBTyxDQUFDTixNQUFNLENBQUNHLGdCQUFnQixLQUFLLFFBQVEsRUFBRTtNQUN2RCxNQUFNSCxNQUE0QixHQUFHO1FBQ25DUyxLQUFLLEVBQUUsU0FBUztRQUNoQkMsQ0FBQyxFQUFFLGFBQWE7UUFDaEJDLElBQUksRUFBRUM7TUFDUixDQUFDO01BQ0RKLGNBQWMsR0FBR1IsTUFBTTtJQUN6QjtJQUFFLElBQUk7TUFDSixNQUFNYSxjQUFjLEdBQUcsTUFBTVIsT0FBTyxDQUFDUyxJQUFJLENBQUNDLFVBQVUsQ0FBQ0MsTUFBTSxDQUFDQyxNQUFNLENBQUNDLGlCQUFpQixDQUNsRixRQUFRLEVBQ1JWLGNBQ0YsQ0FBQztNQUNELElBQUFXLHlCQUFXLEVBQUMsZUFBZSxFQUFFLE1BQU0sRUFBRSxPQUFPLENBQUM7TUFFN0MsT0FBT1osUUFBUSxDQUFDYSxFQUFFLENBQUM7UUFDakJDLElBQUksRUFBRVI7TUFDUixDQUFDLENBQUM7SUFDSixDQUFDLENBQUMsT0FBT1MsS0FBSyxFQUFFO01BQ2Q7TUFDQWpCLE9BQU8sQ0FBQ2tCLGdCQUFnQixDQUFDQyxNQUFNLENBQUNGLEtBQUssQ0FDbEMsb0NBQW1DaEIsT0FBTyxDQUFDTixNQUFNLENBQUNHLGdCQUFpQixLQUFJbUIsS0FBTSxFQUNoRixDQUFDO01BQ0QsSUFBQUgseUJBQVcsRUFBQyxlQUFlLEVBQUUsTUFBTSxFQUFFLElBQUFNLHVCQUFjLEVBQUNILEtBQUssQ0FBQyxDQUFDO01BQzNELE9BQU9mLFFBQVEsQ0FBQ21CLE1BQU0sQ0FBQztRQUNyQkMsVUFBVSxFQUFFTCxLQUFLLENBQUNLLFVBQVU7UUFDNUJOLElBQUksRUFBRSxJQUFBTyxxQ0FBNEIsRUFBQ04sS0FBSztNQUMxQyxDQUFDLENBQUM7SUFDSjtFQUNGLENBQ0YsQ0FBQztBQUNIO0FBQUNPLE1BQUEsQ0FBQUMsT0FBQSxHQUFBQSxPQUFBLENBQUFDLE9BQUEifQ==