/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.core.utils;

import java.util.EnumSet;

public final class EnumUtility {
    public static <T extends Enum<T>> T fromString(Class<T> enumClass, String name) {
        if (name == null) {
            return null;
        }
        EnumSet<Enum> values = EnumSet.allOf(enumClass);
        for (Enum value : values) {
            if (!value.name().equalsIgnoreCase(name)) continue;
            return (T)value;
        }
        int index = Integer.parseInt(name);
        if (index < values.size() && index >= 0) {
            return (T)((Enum)values.toArray()[index]);
        }
        throw new IllegalArgumentException("No enum constant " + enumClass.getCanonicalName() + "." + name);
    }
}

