/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.FieldMemoryUsage;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class FielddataStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, FielddataStats> {
    @Nullable
    private final Long evictions;
    @Nonnull
    private final Map<String, FieldMemoryUsage> fields;
    @Nullable
    private final String memorySize;
    private final long memorySizeInBytes;
    public static final JsonpDeserializer<FielddataStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FielddataStats::setupFielddataStatsDeserializer);

    private FielddataStats(Builder builder) {
        this.evictions = builder.evictions;
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.memorySize = builder.memorySize;
        this.memorySizeInBytes = ApiTypeHelper.requireNonNull(builder.memorySizeInBytes, this, "memorySizeInBytes");
    }

    public static FielddataStats of(Function<Builder, ObjectBuilder<FielddataStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long evictions() {
        return this.evictions;
    }

    @Nonnull
    public final Map<String, FieldMemoryUsage> fields() {
        return this.fields;
    }

    @Nullable
    public final String memorySize() {
        return this.memorySize;
    }

    public final long memorySizeInBytes() {
        return this.memorySizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.evictions != null) {
            generator.writeKey("evictions");
            generator.write(this.evictions.longValue());
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, FieldMemoryUsage> item0 : this.fields.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.memorySize != null) {
            generator.writeKey("memory_size");
            generator.write(this.memorySize);
        }
        generator.writeKey("memory_size_in_bytes");
        generator.write(this.memorySizeInBytes);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupFielddataStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::evictions, JsonpDeserializer.longDeserializer(), "evictions");
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(FieldMemoryUsage._DESERIALIZER), "fields");
        op.add(Builder::memorySize, JsonpDeserializer.stringDeserializer(), "memory_size");
        op.add(Builder::memorySizeInBytes, JsonpDeserializer.longDeserializer(), "memory_size_in_bytes");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.evictions);
        result = 31 * result + Objects.hashCode(this.fields);
        result = 31 * result + Objects.hashCode(this.memorySize);
        result = 31 * result + Long.hashCode(this.memorySizeInBytes);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FielddataStats other = (FielddataStats)o;
        return Objects.equals(this.evictions, other.evictions) && Objects.equals(this.fields, other.fields) && Objects.equals(this.memorySize, other.memorySize) && this.memorySizeInBytes == other.memorySizeInBytes;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, FielddataStats> {
        @Nullable
        private Long evictions;
        @Nullable
        private Map<String, FieldMemoryUsage> fields;
        @Nullable
        private String memorySize;
        private Long memorySizeInBytes;

        public Builder() {
        }

        private Builder(FielddataStats o) {
            this.evictions = o.evictions;
            this.fields = Builder._mapCopy(o.fields);
            this.memorySize = o.memorySize;
            this.memorySizeInBytes = o.memorySizeInBytes;
        }

        private Builder(Builder o) {
            this.evictions = o.evictions;
            this.fields = Builder._mapCopy(o.fields);
            this.memorySize = o.memorySize;
            this.memorySizeInBytes = o.memorySizeInBytes;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder evictions(@Nullable Long value) {
            this.evictions = value;
            return this;
        }

        @Nonnull
        public final Builder fields(Map<String, FieldMemoryUsage> map) {
            this.fields = Builder._mapPutAll(this.fields, map);
            return this;
        }

        @Nonnull
        public final Builder fields(String key, FieldMemoryUsage value) {
            this.fields = Builder._mapPut(this.fields, key, value);
            return this;
        }

        @Nonnull
        public final Builder fields(String key, Function<FieldMemoryUsage.Builder, ObjectBuilder<FieldMemoryUsage>> fn) {
            return this.fields(key, fn.apply(new FieldMemoryUsage.Builder()).build());
        }

        @Nonnull
        public final Builder memorySize(@Nullable String value) {
            this.memorySize = value;
            return this;
        }

        @Nonnull
        public final Builder memorySizeInBytes(long value) {
            this.memorySizeInBytes = value;
            return this;
        }

        @Override
        @Nonnull
        public FielddataStats build() {
            this._checkSingleUse();
            return new FielddataStats(this);
        }
    }
}

