/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class WordDelimiterTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant,
ToCopyableBuilder<Builder, WordDelimiterTokenFilter> {
    @Nullable
    private final Boolean catenateAll;
    @Nullable
    private final Boolean catenateNumbers;
    @Nullable
    private final Boolean catenateWords;
    @Nullable
    private final Boolean generateNumberParts;
    @Nullable
    private final Boolean generateWordParts;
    @Nullable
    private final Boolean preserveOriginal;
    @Nonnull
    private final List<String> protectedWords;
    @Nullable
    private final String protectedWordsPath;
    @Nullable
    private final Boolean splitOnCaseChange;
    @Nullable
    private final Boolean splitOnNumerics;
    @Nullable
    private final Boolean stemEnglishPossessive;
    @Nonnull
    private final List<String> typeTable;
    @Nullable
    private final String typeTablePath;
    public static final JsonpDeserializer<WordDelimiterTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WordDelimiterTokenFilter::setupWordDelimiterTokenFilterDeserializer);

    private WordDelimiterTokenFilter(Builder builder) {
        super(builder);
        this.catenateAll = builder.catenateAll;
        this.catenateNumbers = builder.catenateNumbers;
        this.catenateWords = builder.catenateWords;
        this.generateNumberParts = builder.generateNumberParts;
        this.generateWordParts = builder.generateWordParts;
        this.preserveOriginal = builder.preserveOriginal;
        this.protectedWords = ApiTypeHelper.unmodifiable(builder.protectedWords);
        this.protectedWordsPath = builder.protectedWordsPath;
        this.splitOnCaseChange = builder.splitOnCaseChange;
        this.splitOnNumerics = builder.splitOnNumerics;
        this.stemEnglishPossessive = builder.stemEnglishPossessive;
        this.typeTable = ApiTypeHelper.unmodifiable(builder.typeTable);
        this.typeTablePath = builder.typeTablePath;
    }

    public static WordDelimiterTokenFilter of(Function<Builder, ObjectBuilder<WordDelimiterTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.WordDelimiter;
    }

    @Nullable
    public final Boolean catenateAll() {
        return this.catenateAll;
    }

    @Nullable
    public final Boolean catenateNumbers() {
        return this.catenateNumbers;
    }

    @Nullable
    public final Boolean catenateWords() {
        return this.catenateWords;
    }

    @Nullable
    public final Boolean generateNumberParts() {
        return this.generateNumberParts;
    }

    @Nullable
    public final Boolean generateWordParts() {
        return this.generateWordParts;
    }

    @Nullable
    public final Boolean preserveOriginal() {
        return this.preserveOriginal;
    }

    @Nonnull
    public final List<String> protectedWords() {
        return this.protectedWords;
    }

    @Nullable
    public final String protectedWordsPath() {
        return this.protectedWordsPath;
    }

    @Nullable
    public final Boolean splitOnCaseChange() {
        return this.splitOnCaseChange;
    }

    @Nullable
    public final Boolean splitOnNumerics() {
        return this.splitOnNumerics;
    }

    @Nullable
    public final Boolean stemEnglishPossessive() {
        return this.stemEnglishPossessive;
    }

    @Nonnull
    public final List<String> typeTable() {
        return this.typeTable;
    }

    @Nullable
    public final String typeTablePath() {
        return this.typeTablePath;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "word_delimiter");
        super.serializeInternal(generator, mapper);
        if (this.catenateAll != null) {
            generator.writeKey("catenate_all");
            generator.write(this.catenateAll.booleanValue());
        }
        if (this.catenateNumbers != null) {
            generator.writeKey("catenate_numbers");
            generator.write(this.catenateNumbers.booleanValue());
        }
        if (this.catenateWords != null) {
            generator.writeKey("catenate_words");
            generator.write(this.catenateWords.booleanValue());
        }
        if (this.generateNumberParts != null) {
            generator.writeKey("generate_number_parts");
            generator.write(this.generateNumberParts.booleanValue());
        }
        if (this.generateWordParts != null) {
            generator.writeKey("generate_word_parts");
            generator.write(this.generateWordParts.booleanValue());
        }
        if (this.preserveOriginal != null) {
            generator.writeKey("preserve_original");
            generator.write(this.preserveOriginal.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.protectedWords)) {
            generator.writeKey("protected_words");
            generator.writeStartArray();
            for (String item0 : this.protectedWords) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.protectedWordsPath != null) {
            generator.writeKey("protected_words_path");
            generator.write(this.protectedWordsPath);
        }
        if (this.splitOnCaseChange != null) {
            generator.writeKey("split_on_case_change");
            generator.write(this.splitOnCaseChange.booleanValue());
        }
        if (this.splitOnNumerics != null) {
            generator.writeKey("split_on_numerics");
            generator.write(this.splitOnNumerics.booleanValue());
        }
        if (this.stemEnglishPossessive != null) {
            generator.writeKey("stem_english_possessive");
            generator.write(this.stemEnglishPossessive.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.typeTable)) {
            generator.writeKey("type_table");
            generator.writeStartArray();
            for (String item0 : this.typeTable) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.typeTablePath != null) {
            generator.writeKey("type_table_path");
            generator.write(this.typeTablePath);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupWordDelimiterTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        WordDelimiterTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::catenateAll, JsonpDeserializer.booleanDeserializer(), "catenate_all");
        op.add(Builder::catenateNumbers, JsonpDeserializer.booleanDeserializer(), "catenate_numbers");
        op.add(Builder::catenateWords, JsonpDeserializer.booleanDeserializer(), "catenate_words");
        op.add(Builder::generateNumberParts, JsonpDeserializer.booleanDeserializer(), "generate_number_parts");
        op.add(Builder::generateWordParts, JsonpDeserializer.booleanDeserializer(), "generate_word_parts");
        op.add(Builder::preserveOriginal, JsonpDeserializer.booleanDeserializer(), "preserve_original");
        op.add(Builder::protectedWords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "protected_words");
        op.add(Builder::protectedWordsPath, JsonpDeserializer.stringDeserializer(), "protected_words_path");
        op.add(Builder::splitOnCaseChange, JsonpDeserializer.booleanDeserializer(), "split_on_case_change");
        op.add(Builder::splitOnNumerics, JsonpDeserializer.booleanDeserializer(), "split_on_numerics");
        op.add(Builder::stemEnglishPossessive, JsonpDeserializer.booleanDeserializer(), "stem_english_possessive");
        op.add(Builder::typeTable, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "type_table");
        op.add(Builder::typeTablePath, JsonpDeserializer.stringDeserializer(), "type_table_path");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.catenateAll);
        result = 31 * result + Objects.hashCode(this.catenateNumbers);
        result = 31 * result + Objects.hashCode(this.catenateWords);
        result = 31 * result + Objects.hashCode(this.generateNumberParts);
        result = 31 * result + Objects.hashCode(this.generateWordParts);
        result = 31 * result + Objects.hashCode(this.preserveOriginal);
        result = 31 * result + Objects.hashCode(this.protectedWords);
        result = 31 * result + Objects.hashCode(this.protectedWordsPath);
        result = 31 * result + Objects.hashCode(this.splitOnCaseChange);
        result = 31 * result + Objects.hashCode(this.splitOnNumerics);
        result = 31 * result + Objects.hashCode(this.stemEnglishPossessive);
        result = 31 * result + Objects.hashCode(this.typeTable);
        result = 31 * result + Objects.hashCode(this.typeTablePath);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WordDelimiterTokenFilter other = (WordDelimiterTokenFilter)o;
        return Objects.equals(this.catenateAll, other.catenateAll) && Objects.equals(this.catenateNumbers, other.catenateNumbers) && Objects.equals(this.catenateWords, other.catenateWords) && Objects.equals(this.generateNumberParts, other.generateNumberParts) && Objects.equals(this.generateWordParts, other.generateWordParts) && Objects.equals(this.preserveOriginal, other.preserveOriginal) && Objects.equals(this.protectedWords, other.protectedWords) && Objects.equals(this.protectedWordsPath, other.protectedWordsPath) && Objects.equals(this.splitOnCaseChange, other.splitOnCaseChange) && Objects.equals(this.splitOnNumerics, other.splitOnNumerics) && Objects.equals(this.stemEnglishPossessive, other.stemEnglishPossessive) && Objects.equals(this.typeTable, other.typeTable) && Objects.equals(this.typeTablePath, other.typeTablePath);
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, WordDelimiterTokenFilter> {
        @Nullable
        private Boolean catenateAll;
        @Nullable
        private Boolean catenateNumbers;
        @Nullable
        private Boolean catenateWords;
        @Nullable
        private Boolean generateNumberParts;
        @Nullable
        private Boolean generateWordParts;
        @Nullable
        private Boolean preserveOriginal;
        @Nullable
        private List<String> protectedWords;
        @Nullable
        private String protectedWordsPath;
        @Nullable
        private Boolean splitOnCaseChange;
        @Nullable
        private Boolean splitOnNumerics;
        @Nullable
        private Boolean stemEnglishPossessive;
        @Nullable
        private List<String> typeTable;
        @Nullable
        private String typeTablePath;

        public Builder() {
        }

        private Builder(WordDelimiterTokenFilter o) {
            super(o);
            this.catenateAll = o.catenateAll;
            this.catenateNumbers = o.catenateNumbers;
            this.catenateWords = o.catenateWords;
            this.generateNumberParts = o.generateNumberParts;
            this.generateWordParts = o.generateWordParts;
            this.preserveOriginal = o.preserveOriginal;
            this.protectedWords = Builder._listCopy(o.protectedWords);
            this.protectedWordsPath = o.protectedWordsPath;
            this.splitOnCaseChange = o.splitOnCaseChange;
            this.splitOnNumerics = o.splitOnNumerics;
            this.stemEnglishPossessive = o.stemEnglishPossessive;
            this.typeTable = Builder._listCopy(o.typeTable);
            this.typeTablePath = o.typeTablePath;
        }

        private Builder(Builder o) {
            super(o);
            this.catenateAll = o.catenateAll;
            this.catenateNumbers = o.catenateNumbers;
            this.catenateWords = o.catenateWords;
            this.generateNumberParts = o.generateNumberParts;
            this.generateWordParts = o.generateWordParts;
            this.preserveOriginal = o.preserveOriginal;
            this.protectedWords = Builder._listCopy(o.protectedWords);
            this.protectedWordsPath = o.protectedWordsPath;
            this.splitOnCaseChange = o.splitOnCaseChange;
            this.splitOnNumerics = o.splitOnNumerics;
            this.stemEnglishPossessive = o.stemEnglishPossessive;
            this.typeTable = Builder._listCopy(o.typeTable);
            this.typeTablePath = o.typeTablePath;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder catenateAll(@Nullable Boolean value) {
            this.catenateAll = value;
            return this;
        }

        @Nonnull
        public final Builder catenateNumbers(@Nullable Boolean value) {
            this.catenateNumbers = value;
            return this;
        }

        @Nonnull
        public final Builder catenateWords(@Nullable Boolean value) {
            this.catenateWords = value;
            return this;
        }

        @Nonnull
        public final Builder generateNumberParts(@Nullable Boolean value) {
            this.generateNumberParts = value;
            return this;
        }

        @Nonnull
        public final Builder generateWordParts(@Nullable Boolean value) {
            this.generateWordParts = value;
            return this;
        }

        @Nonnull
        public final Builder preserveOriginal(@Nullable Boolean value) {
            this.preserveOriginal = value;
            return this;
        }

        @Nonnull
        public final Builder protectedWords(List<String> list) {
            this.protectedWords = Builder._listAddAll(this.protectedWords, list);
            return this;
        }

        @Nonnull
        public final Builder protectedWords(String value, String ... values) {
            this.protectedWords = Builder._listAdd(this.protectedWords, value, values);
            return this;
        }

        @Nonnull
        public final Builder protectedWordsPath(@Nullable String value) {
            this.protectedWordsPath = value;
            return this;
        }

        @Nonnull
        public final Builder splitOnCaseChange(@Nullable Boolean value) {
            this.splitOnCaseChange = value;
            return this;
        }

        @Nonnull
        public final Builder splitOnNumerics(@Nullable Boolean value) {
            this.splitOnNumerics = value;
            return this;
        }

        @Nonnull
        public final Builder stemEnglishPossessive(@Nullable Boolean value) {
            this.stemEnglishPossessive = value;
            return this;
        }

        @Nonnull
        public final Builder typeTable(List<String> list) {
            this.typeTable = Builder._listAddAll(this.typeTable, list);
            return this;
        }

        @Nonnull
        public final Builder typeTable(String value, String ... values) {
            this.typeTable = Builder._listAdd(this.typeTable, value, values);
            return this;
        }

        @Nonnull
        public final Builder typeTablePath(@Nullable String value) {
            this.typeTablePath = value;
            return this;
        }

        @Override
        @Nonnull
        public WordDelimiterTokenFilter build() {
            this._checkSingleUse();
            return new WordDelimiterTokenFilter(this);
        }
    }
}

