/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyBase;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class FlatObjectProperty
extends PropertyBase
implements PropertyVariant,
ToCopyableBuilder<Builder, FlatObjectProperty> {
    @Nullable
    private final Boolean aggregatable;
    @Nullable
    private final Boolean searchable;
    public static final JsonpDeserializer<FlatObjectProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FlatObjectProperty::setupFlatObjectPropertyDeserializer);

    private FlatObjectProperty(Builder builder) {
        super(builder);
        this.aggregatable = builder.aggregatable;
        this.searchable = builder.searchable;
    }

    public static FlatObjectProperty of(Function<Builder, ObjectBuilder<FlatObjectProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.FlatObject;
    }

    @Nullable
    public final Boolean aggregatable() {
        return this.aggregatable;
    }

    @Nullable
    public final Boolean searchable() {
        return this.searchable;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "flat_object");
        super.serializeInternal(generator, mapper);
        if (this.aggregatable != null) {
            generator.writeKey("aggregatable");
            generator.write(this.aggregatable.booleanValue());
        }
        if (this.searchable != null) {
            generator.writeKey("searchable");
            generator.write(this.searchable.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupFlatObjectPropertyDeserializer(ObjectDeserializer<Builder> op) {
        FlatObjectProperty.setupPropertyBaseDeserializer(op);
        op.add(Builder::aggregatable, JsonpDeserializer.booleanDeserializer(), "aggregatable");
        op.add(Builder::searchable, JsonpDeserializer.booleanDeserializer(), "searchable");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.aggregatable);
        result = 31 * result + Objects.hashCode(this.searchable);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlatObjectProperty other = (FlatObjectProperty)o;
        return Objects.equals(this.aggregatable, other.aggregatable) && Objects.equals(this.searchable, other.searchable);
    }

    public static class Builder
    extends PropertyBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, FlatObjectProperty> {
        @Nullable
        private Boolean aggregatable;
        @Nullable
        private Boolean searchable;

        public Builder() {
        }

        private Builder(FlatObjectProperty o) {
            super(o);
            this.aggregatable = o.aggregatable;
            this.searchable = o.searchable;
        }

        private Builder(Builder o) {
            super(o);
            this.aggregatable = o.aggregatable;
            this.searchable = o.searchable;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder aggregatable(@Nullable Boolean value) {
            this.aggregatable = value;
            return this;
        }

        @Nonnull
        public final Builder searchable(@Nullable Boolean value) {
            this.searchable = value;
            return this;
        }

        @Override
        @Nonnull
        public FlatObjectProperty build() {
            this._checkSingleUse();
            return new FlatObjectProperty(this);
        }
    }
}

