/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ism;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.ism.ErrorNotification;
import org.opensearch.client.opensearch.ism.IsmTemplate;
import org.opensearch.client.opensearch.ism.States;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Policy
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Policy> {
    @Nullable
    private final String defaultState;
    @Nullable
    private final String description;
    @Nullable
    private final ErrorNotification errorNotification;
    @Nonnull
    private final List<IsmTemplate> ismTemplate;
    @Nullable
    private final Integer lastUpdatedTime;
    @Nullable
    private final String policyId;
    @Nullable
    private final Number schemaVersion;
    @Nonnull
    private final List<States> states;
    public static final JsonpDeserializer<Policy> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Policy::setupPolicyDeserializer);

    private Policy(Builder builder) {
        this.defaultState = builder.defaultState;
        this.description = builder.description;
        this.errorNotification = builder.errorNotification;
        this.ismTemplate = ApiTypeHelper.unmodifiable(builder.ismTemplate);
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.policyId = builder.policyId;
        this.schemaVersion = builder.schemaVersion;
        this.states = ApiTypeHelper.unmodifiable(builder.states);
    }

    public static Policy of(Function<Builder, ObjectBuilder<Policy>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String defaultState() {
        return this.defaultState;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final ErrorNotification errorNotification() {
        return this.errorNotification;
    }

    @Nonnull
    public final List<IsmTemplate> ismTemplate() {
        return this.ismTemplate;
    }

    @Nullable
    public final Integer lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    @Nullable
    public final String policyId() {
        return this.policyId;
    }

    @Nullable
    public final Number schemaVersion() {
        return this.schemaVersion;
    }

    @Nonnull
    public final List<States> states() {
        return this.states;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.defaultState != null) {
            generator.writeKey("default_state");
            generator.write(this.defaultState);
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.errorNotification != null) {
            generator.writeKey("error_notification");
            this.errorNotification.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.ismTemplate)) {
            generator.writeKey("ism_template");
            generator.writeStartArray();
            for (IsmTemplate ismTemplate : this.ismTemplate) {
                ismTemplate.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.lastUpdatedTime != null) {
            generator.writeKey("last_updated_time");
            generator.write(this.lastUpdatedTime.intValue());
        }
        if (this.policyId != null) {
            generator.writeKey("policy_id");
            generator.write(this.policyId);
        }
        if (this.schemaVersion != null) {
            generator.writeKey("schema_version");
            generator.write(this.schemaVersion.doubleValue());
        }
        if (ApiTypeHelper.isDefined(this.states)) {
            generator.writeKey("states");
            generator.writeStartArray();
            for (States states : this.states) {
                states.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPolicyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::defaultState, JsonpDeserializer.stringDeserializer(), "default_state");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::errorNotification, ErrorNotification._DESERIALIZER, "error_notification");
        op.add(Builder::ismTemplate, JsonpDeserializer.arrayDeserializer(IsmTemplate._DESERIALIZER), "ism_template");
        op.add(Builder::lastUpdatedTime, JsonpDeserializer.integerDeserializer(), "last_updated_time");
        op.add(Builder::policyId, JsonpDeserializer.stringDeserializer(), "policy_id");
        op.add(Builder::schemaVersion, JsonpDeserializer.numberDeserializer(), "schema_version");
        op.add(Builder::states, JsonpDeserializer.arrayDeserializer(States._DESERIALIZER), "states");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.defaultState);
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.errorNotification);
        result = 31 * result + Objects.hashCode(this.ismTemplate);
        result = 31 * result + Objects.hashCode(this.lastUpdatedTime);
        result = 31 * result + Objects.hashCode(this.policyId);
        result = 31 * result + Objects.hashCode(this.schemaVersion);
        result = 31 * result + Objects.hashCode(this.states);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Policy other = (Policy)o;
        return Objects.equals(this.defaultState, other.defaultState) && Objects.equals(this.description, other.description) && Objects.equals(this.errorNotification, other.errorNotification) && Objects.equals(this.ismTemplate, other.ismTemplate) && Objects.equals(this.lastUpdatedTime, other.lastUpdatedTime) && Objects.equals(this.policyId, other.policyId) && Objects.equals(this.schemaVersion, other.schemaVersion) && Objects.equals(this.states, other.states);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Policy> {
        @Nullable
        private String defaultState;
        @Nullable
        private String description;
        @Nullable
        private ErrorNotification errorNotification;
        @Nullable
        private List<IsmTemplate> ismTemplate;
        @Nullable
        private Integer lastUpdatedTime;
        @Nullable
        private String policyId;
        @Nullable
        private Number schemaVersion;
        @Nullable
        private List<States> states;

        public Builder() {
        }

        private Builder(Policy o) {
            this.defaultState = o.defaultState;
            this.description = o.description;
            this.errorNotification = o.errorNotification;
            this.ismTemplate = Builder._listCopy(o.ismTemplate);
            this.lastUpdatedTime = o.lastUpdatedTime;
            this.policyId = o.policyId;
            this.schemaVersion = o.schemaVersion;
            this.states = Builder._listCopy(o.states);
        }

        private Builder(Builder o) {
            this.defaultState = o.defaultState;
            this.description = o.description;
            this.errorNotification = o.errorNotification;
            this.ismTemplate = Builder._listCopy(o.ismTemplate);
            this.lastUpdatedTime = o.lastUpdatedTime;
            this.policyId = o.policyId;
            this.schemaVersion = o.schemaVersion;
            this.states = Builder._listCopy(o.states);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder defaultState(@Nullable String value) {
            this.defaultState = value;
            return this;
        }

        @Nonnull
        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder errorNotification(@Nullable ErrorNotification value) {
            this.errorNotification = value;
            return this;
        }

        @Nonnull
        public final Builder errorNotification(Function<ErrorNotification.Builder, ObjectBuilder<ErrorNotification>> fn) {
            return this.errorNotification(fn.apply(new ErrorNotification.Builder()).build());
        }

        @Nonnull
        public final Builder ismTemplate(List<IsmTemplate> list) {
            this.ismTemplate = Builder._listAddAll(this.ismTemplate, list);
            return this;
        }

        @Nonnull
        public final Builder ismTemplate(IsmTemplate value, IsmTemplate ... values) {
            this.ismTemplate = Builder._listAdd(this.ismTemplate, value, values);
            return this;
        }

        @Nonnull
        public final Builder ismTemplate(Function<IsmTemplate.Builder, ObjectBuilder<IsmTemplate>> fn) {
            return this.ismTemplate(fn.apply(new IsmTemplate.Builder()).build(), new IsmTemplate[0]);
        }

        @Nonnull
        public final Builder lastUpdatedTime(@Nullable Integer value) {
            this.lastUpdatedTime = value;
            return this;
        }

        @Nonnull
        public final Builder policyId(@Nullable String value) {
            this.policyId = value;
            return this;
        }

        @Nonnull
        public final Builder schemaVersion(@Nullable Number value) {
            this.schemaVersion = value;
            return this;
        }

        @Nonnull
        public final Builder states(List<States> list) {
            this.states = Builder._listAddAll(this.states, list);
            return this;
        }

        @Nonnull
        public final Builder states(States value, States ... values) {
            this.states = Builder._listAdd(this.states, value, values);
            return this;
        }

        @Nonnull
        public final Builder states(Function<States.Builder, ObjectBuilder<States>> fn) {
            return this.states(fn.apply(new States.Builder()).build(), new States[0]);
        }

        @Override
        @Nonnull
        public Policy build() {
            this._checkSingleUse();
            return new Policy(this);
        }
    }
}

