/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.tasks;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.BulkByScrollTaskStatusOrException;
import org.opensearch.client.opensearch._types.Retries;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Status
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Status> {
    @Nullable
    private final Integer batches;
    @Nullable
    private final String canceled;
    @Nullable
    private final Long created;
    @Nullable
    private final Long deleted;
    @Nonnull
    private final Map<String, JsonData> metadata;
    @Nullable
    private final Long noops;
    @Nullable
    private final String phase;
    @Nullable
    private final Float requestsPerSecond;
    @Nullable
    private final Retries retries;
    @Nullable
    private final Integer sliceId;
    @Nonnull
    private final List<BulkByScrollTaskStatusOrException> slices;
    @Nullable
    private final String state;
    @Nullable
    private final Time throttled;
    @Nullable
    private final Long throttledMillis;
    @Nullable
    private final Time throttledUntil;
    @Nullable
    private final Long throttledUntilMillis;
    @Nullable
    private final Long total;
    @Nullable
    private final Long updated;
    @Nullable
    private final Long versionConflicts;
    public static final JsonpDeserializer<Status> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Status::setupStatusDeserializer);

    private Status(Builder builder) {
        this.batches = builder.batches;
        this.canceled = builder.canceled;
        this.created = builder.created;
        this.deleted = builder.deleted;
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.noops = builder.noops;
        this.phase = builder.phase;
        this.requestsPerSecond = builder.requestsPerSecond;
        this.retries = builder.retries;
        this.sliceId = builder.sliceId;
        this.slices = ApiTypeHelper.unmodifiable(builder.slices);
        this.state = builder.state;
        this.throttled = builder.throttled;
        this.throttledMillis = builder.throttledMillis;
        this.throttledUntil = builder.throttledUntil;
        this.throttledUntilMillis = builder.throttledUntilMillis;
        this.total = builder.total;
        this.updated = builder.updated;
        this.versionConflicts = builder.versionConflicts;
    }

    public static Status of(Function<Builder, ObjectBuilder<Status>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer batches() {
        return this.batches;
    }

    @Nullable
    public final String canceled() {
        return this.canceled;
    }

    @Nullable
    public final Long created() {
        return this.created;
    }

    @Nullable
    public final Long deleted() {
        return this.deleted;
    }

    @Nonnull
    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public final Long noops() {
        return this.noops;
    }

    @Nullable
    public final String phase() {
        return this.phase;
    }

    @Nullable
    public final Float requestsPerSecond() {
        return this.requestsPerSecond;
    }

    @Nullable
    public final Retries retries() {
        return this.retries;
    }

    @Nullable
    public final Integer sliceId() {
        return this.sliceId;
    }

    @Nonnull
    public final List<BulkByScrollTaskStatusOrException> slices() {
        return this.slices;
    }

    @Nullable
    public final String state() {
        return this.state;
    }

    @Nullable
    public final Time throttled() {
        return this.throttled;
    }

    @Nullable
    public final Long throttledMillis() {
        return this.throttledMillis;
    }

    @Nullable
    public final Time throttledUntil() {
        return this.throttledUntil;
    }

    @Nullable
    public final Long throttledUntilMillis() {
        return this.throttledUntilMillis;
    }

    @Nullable
    public final Long total() {
        return this.total;
    }

    @Nullable
    public final Long updated() {
        return this.updated;
    }

    @Nullable
    public final Long versionConflicts() {
        return this.versionConflicts;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        for (Map.Entry<String, JsonData> entry : this.metadata.entrySet()) {
            generator.writeKey(entry.getKey());
            entry.getValue().serialize(generator, mapper);
        }
        if (this.batches != null) {
            generator.writeKey("batches");
            generator.write(this.batches.intValue());
        }
        if (this.canceled != null) {
            generator.writeKey("canceled");
            generator.write(this.canceled);
        }
        if (this.created != null) {
            generator.writeKey("created");
            generator.write(this.created.longValue());
        }
        if (this.deleted != null) {
            generator.writeKey("deleted");
            generator.write(this.deleted.longValue());
        }
        if (this.noops != null) {
            generator.writeKey("noops");
            generator.write(this.noops.longValue());
        }
        if (this.phase != null) {
            generator.writeKey("phase");
            generator.write(this.phase);
        }
        if (this.requestsPerSecond != null) {
            generator.writeKey("requests_per_second");
            generator.write((double)this.requestsPerSecond.floatValue());
        }
        if (this.retries != null) {
            generator.writeKey("retries");
            this.retries.serialize(generator, mapper);
        }
        if (this.sliceId != null) {
            generator.writeKey("slice_id");
            generator.write(this.sliceId.intValue());
        }
        if (ApiTypeHelper.isDefined(this.slices)) {
            generator.writeKey("slices");
            generator.writeStartArray();
            for (BulkByScrollTaskStatusOrException bulkByScrollTaskStatusOrException : this.slices) {
                bulkByScrollTaskStatusOrException.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.state != null) {
            generator.writeKey("state");
            generator.write(this.state);
        }
        if (this.throttled != null) {
            generator.writeKey("throttled");
            this.throttled.serialize(generator, mapper);
        }
        if (this.throttledMillis != null) {
            generator.writeKey("throttled_millis");
            generator.write(this.throttledMillis.longValue());
        }
        if (this.throttledUntil != null) {
            generator.writeKey("throttled_until");
            this.throttledUntil.serialize(generator, mapper);
        }
        if (this.throttledUntilMillis != null) {
            generator.writeKey("throttled_until_millis");
            generator.write(this.throttledUntilMillis.longValue());
        }
        if (this.total != null) {
            generator.writeKey("total");
            generator.write(this.total.longValue());
        }
        if (this.updated != null) {
            generator.writeKey("updated");
            generator.write(this.updated.longValue());
        }
        if (this.versionConflicts != null) {
            generator.writeKey("version_conflicts");
            generator.write(this.versionConflicts.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupStatusDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::batches, JsonpDeserializer.integerDeserializer(), "batches");
        op.add(Builder::canceled, JsonpDeserializer.stringDeserializer(), "canceled");
        op.add(Builder::created, JsonpDeserializer.longDeserializer(), "created");
        op.add(Builder::deleted, JsonpDeserializer.longDeserializer(), "deleted");
        op.add(Builder::noops, JsonpDeserializer.longDeserializer(), "noops");
        op.add(Builder::phase, JsonpDeserializer.stringDeserializer(), "phase");
        op.add(Builder::requestsPerSecond, JsonpDeserializer.floatDeserializer(), "requests_per_second");
        op.add(Builder::retries, Retries._DESERIALIZER, "retries");
        op.add(Builder::sliceId, JsonpDeserializer.integerDeserializer(), "slice_id");
        op.add(Builder::slices, JsonpDeserializer.arrayDeserializer(BulkByScrollTaskStatusOrException._DESERIALIZER), "slices");
        op.add(Builder::state, JsonpDeserializer.stringDeserializer(), "state");
        op.add(Builder::throttled, Time._DESERIALIZER, "throttled");
        op.add(Builder::throttledMillis, JsonpDeserializer.longDeserializer(), "throttled_millis");
        op.add(Builder::throttledUntil, Time._DESERIALIZER, "throttled_until");
        op.add(Builder::throttledUntilMillis, JsonpDeserializer.longDeserializer(), "throttled_until_millis");
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
        op.add(Builder::updated, JsonpDeserializer.longDeserializer(), "updated");
        op.add(Builder::versionConflicts, JsonpDeserializer.longDeserializer(), "version_conflicts");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            if (((Builder)builder).metadata == null) {
                ((Builder)builder).metadata = new HashMap();
            }
            ((Builder)builder).metadata.put(name, JsonData._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.batches);
        result = 31 * result + Objects.hashCode(this.canceled);
        result = 31 * result + Objects.hashCode(this.created);
        result = 31 * result + Objects.hashCode(this.deleted);
        result = 31 * result + Objects.hashCode(this.metadata);
        result = 31 * result + Objects.hashCode(this.noops);
        result = 31 * result + Objects.hashCode(this.phase);
        result = 31 * result + Objects.hashCode(this.requestsPerSecond);
        result = 31 * result + Objects.hashCode(this.retries);
        result = 31 * result + Objects.hashCode(this.sliceId);
        result = 31 * result + Objects.hashCode(this.slices);
        result = 31 * result + Objects.hashCode(this.state);
        result = 31 * result + Objects.hashCode(this.throttled);
        result = 31 * result + Objects.hashCode(this.throttledMillis);
        result = 31 * result + Objects.hashCode(this.throttledUntil);
        result = 31 * result + Objects.hashCode(this.throttledUntilMillis);
        result = 31 * result + Objects.hashCode(this.total);
        result = 31 * result + Objects.hashCode(this.updated);
        result = 31 * result + Objects.hashCode(this.versionConflicts);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Status other = (Status)o;
        return Objects.equals(this.batches, other.batches) && Objects.equals(this.canceled, other.canceled) && Objects.equals(this.created, other.created) && Objects.equals(this.deleted, other.deleted) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.noops, other.noops) && Objects.equals(this.phase, other.phase) && Objects.equals(this.requestsPerSecond, other.requestsPerSecond) && Objects.equals(this.retries, other.retries) && Objects.equals(this.sliceId, other.sliceId) && Objects.equals(this.slices, other.slices) && Objects.equals(this.state, other.state) && Objects.equals(this.throttled, other.throttled) && Objects.equals(this.throttledMillis, other.throttledMillis) && Objects.equals(this.throttledUntil, other.throttledUntil) && Objects.equals(this.throttledUntilMillis, other.throttledUntilMillis) && Objects.equals(this.total, other.total) && Objects.equals(this.updated, other.updated) && Objects.equals(this.versionConflicts, other.versionConflicts);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Status> {
        @Nullable
        private Integer batches;
        @Nullable
        private String canceled;
        @Nullable
        private Long created;
        @Nullable
        private Long deleted;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private Long noops;
        @Nullable
        private String phase;
        @Nullable
        private Float requestsPerSecond;
        @Nullable
        private Retries retries;
        @Nullable
        private Integer sliceId;
        @Nullable
        private List<BulkByScrollTaskStatusOrException> slices;
        @Nullable
        private String state;
        @Nullable
        private Time throttled;
        @Nullable
        private Long throttledMillis;
        @Nullable
        private Time throttledUntil;
        @Nullable
        private Long throttledUntilMillis;
        @Nullable
        private Long total;
        @Nullable
        private Long updated;
        @Nullable
        private Long versionConflicts;

        public Builder() {
        }

        private Builder(Status o) {
            this.batches = o.batches;
            this.canceled = o.canceled;
            this.created = o.created;
            this.deleted = o.deleted;
            this.metadata = Builder._mapCopy(o.metadata);
            this.noops = o.noops;
            this.phase = o.phase;
            this.requestsPerSecond = o.requestsPerSecond;
            this.retries = o.retries;
            this.sliceId = o.sliceId;
            this.slices = Builder._listCopy(o.slices);
            this.state = o.state;
            this.throttled = o.throttled;
            this.throttledMillis = o.throttledMillis;
            this.throttledUntil = o.throttledUntil;
            this.throttledUntilMillis = o.throttledUntilMillis;
            this.total = o.total;
            this.updated = o.updated;
            this.versionConflicts = o.versionConflicts;
        }

        private Builder(Builder o) {
            this.batches = o.batches;
            this.canceled = o.canceled;
            this.created = o.created;
            this.deleted = o.deleted;
            this.metadata = Builder._mapCopy(o.metadata);
            this.noops = o.noops;
            this.phase = o.phase;
            this.requestsPerSecond = o.requestsPerSecond;
            this.retries = o.retries;
            this.sliceId = o.sliceId;
            this.slices = Builder._listCopy(o.slices);
            this.state = o.state;
            this.throttled = o.throttled;
            this.throttledMillis = o.throttledMillis;
            this.throttledUntil = o.throttledUntil;
            this.throttledUntilMillis = o.throttledUntilMillis;
            this.total = o.total;
            this.updated = o.updated;
            this.versionConflicts = o.versionConflicts;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder batches(@Nullable Integer value) {
            this.batches = value;
            return this;
        }

        @Nonnull
        public final Builder canceled(@Nullable String value) {
            this.canceled = value;
            return this;
        }

        @Nonnull
        public final Builder created(@Nullable Long value) {
            this.created = value;
            return this;
        }

        @Nonnull
        public final Builder deleted(@Nullable Long value) {
            this.deleted = value;
            return this;
        }

        @Nonnull
        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        @Nonnull
        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        @Nonnull
        public final Builder noops(@Nullable Long value) {
            this.noops = value;
            return this;
        }

        @Nonnull
        public final Builder phase(@Nullable String value) {
            this.phase = value;
            return this;
        }

        @Nonnull
        public final Builder requestsPerSecond(@Nullable Float value) {
            this.requestsPerSecond = value;
            return this;
        }

        @Nonnull
        public final Builder retries(@Nullable Retries value) {
            this.retries = value;
            return this;
        }

        @Nonnull
        public final Builder retries(Function<Retries.Builder, ObjectBuilder<Retries>> fn) {
            return this.retries(fn.apply(new Retries.Builder()).build());
        }

        @Nonnull
        public final Builder sliceId(@Nullable Integer value) {
            this.sliceId = value;
            return this;
        }

        @Nonnull
        public final Builder slices(List<BulkByScrollTaskStatusOrException> list) {
            this.slices = Builder._listAddAll(this.slices, list);
            return this;
        }

        @Nonnull
        public final Builder slices(BulkByScrollTaskStatusOrException value, BulkByScrollTaskStatusOrException ... values) {
            this.slices = Builder._listAdd(this.slices, value, values);
            return this;
        }

        @Nonnull
        public final Builder slices(Function<BulkByScrollTaskStatusOrException.Builder, ObjectBuilder<BulkByScrollTaskStatusOrException>> fn) {
            return this.slices(fn.apply(new BulkByScrollTaskStatusOrException.Builder()).build(), new BulkByScrollTaskStatusOrException[0]);
        }

        @Nonnull
        public final Builder state(@Nullable String value) {
            this.state = value;
            return this;
        }

        @Nonnull
        public final Builder throttled(@Nullable Time value) {
            this.throttled = value;
            return this;
        }

        @Nonnull
        public final Builder throttled(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.throttled(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder throttledMillis(@Nullable Long value) {
            this.throttledMillis = value;
            return this;
        }

        @Nonnull
        public final Builder throttledUntil(@Nullable Time value) {
            this.throttledUntil = value;
            return this;
        }

        @Nonnull
        public final Builder throttledUntil(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.throttledUntil(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder throttledUntilMillis(@Nullable Long value) {
            this.throttledUntilMillis = value;
            return this;
        }

        @Nonnull
        public final Builder total(@Nullable Long value) {
            this.total = value;
            return this;
        }

        @Nonnull
        public final Builder updated(@Nullable Long value) {
            this.updated = value;
            return this;
        }

        @Nonnull
        public final Builder versionConflicts(@Nullable Long value) {
            this.versionConflicts = value;
            return this;
        }

        @Override
        @Nonnull
        public Status build() {
            this._checkSingleUse();
            return new Status(this);
        }
    }
}

