/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification;

import com.oracle.labs.mlrg.olcut.util.MutableLong;
import java.util.Map;
import org.tribuo.MutableOutputInfo;
import org.tribuo.classification.Label;
import org.tribuo.classification.LabelFactory;
import org.tribuo.classification.LabelInfo;

public class MutableLabelInfo
extends LabelInfo
implements MutableOutputInfo<Label> {
    private static final long serialVersionUID = 1L;

    MutableLabelInfo() {
    }

    public MutableLabelInfo(LabelInfo info) {
        super(info);
    }

    public void observe(Label output) {
        if (output == LabelFactory.UNKNOWN_LABEL) {
            ++this.unknownCount;
        } else {
            String label = output.getLabel();
            MutableLong value = this.labelCounts.computeIfAbsent(label, k -> new MutableLong());
            this.labels.computeIfAbsent(label, Label::new);
            value.increment();
        }
    }

    public void clear() {
        this.labelCounts.clear();
    }

    @Override
    public MutableLabelInfo copy() {
        return new MutableLabelInfo(this);
    }

    public String toReadableString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry e : this.labelCounts.entrySet()) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append('(');
            builder.append((String)e.getKey());
            builder.append(',');
            builder.append(((MutableLong)e.getValue()).longValue());
            builder.append(')');
        }
        return builder.toString();
    }

    public String toString() {
        return this.toReadableString();
    }
}

