/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.sequence.viterbi;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tribuo.Feature;
import org.tribuo.classification.Label;
import org.tribuo.classification.sequence.viterbi.LabelFeatureExtractor;

public class DefaultFeatureExtractor
implements LabelFeatureExtractor {
    private static final long serialVersionUID = 1L;
    @Config(mandatory=true, description="Position of the most recent outcome to include.")
    private int mostRecentOutcome;
    @Config(mandatory=true, description="Position of the least recent output to include.")
    private int leastRecentOutcome;
    @Config(mandatory=true, description="Use bigrams of the labels as features.")
    private boolean useBigram;
    @Config(mandatory=true, description="Use trigrams of the labels as features.")
    private boolean useTrigram;
    @Config(mandatory=true, description="Use 4-grams of the labels as features.")
    private boolean use4gram;

    public DefaultFeatureExtractor() {
        this(1, 3, true, true, false);
    }

    public DefaultFeatureExtractor(int mostRecentOutcome, int leastRecentOutcome, boolean useBigram, boolean useTrigram, boolean use4gram) {
        this.mostRecentOutcome = mostRecentOutcome;
        this.leastRecentOutcome = leastRecentOutcome;
        this.useBigram = useBigram;
        this.useTrigram = useTrigram;
        this.use4gram = use4gram;
    }

    public String toString() {
        return "DefaultFeatureExtractor(mostRecent=" + this.mostRecentOutcome + ",leastRecent=" + this.leastRecentOutcome + ",useBigram=" + this.useBigram + ",useTrigram=" + this.useTrigram + ",use4gram=" + this.use4gram + ")";
    }

    @Override
    public List<Feature> extractFeatures(List<Label> previousOutcomes, double value) {
        int size;
        Feature feature;
        if (previousOutcomes == null || previousOutcomes.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (int i = this.mostRecentOutcome; i <= this.leastRecentOutcome; ++i) {
            int index = previousOutcomes.size() - i;
            if (index < 0) continue;
            feature = new Feature("PreviousOutcome_L" + i + "_" + previousOutcomes.get(index).getLabel(), value);
            features.add(feature);
        }
        if (this.useBigram && previousOutcomes.size() >= 2) {
            size = previousOutcomes.size();
            String featureValue = previousOutcomes.get(size - 1).getLabel() + "_" + previousOutcomes.get(size - 2).getLabel();
            feature = new Feature("PreviousOutcomes_L1_2gram_L2R_" + featureValue, value);
            features.add(feature);
        }
        if (this.useTrigram && previousOutcomes.size() >= 3) {
            size = previousOutcomes.size();
            String featureValue = previousOutcomes.get(size - 1).getLabel() + "_" + previousOutcomes.get(size - 2).getLabel() + "_" + previousOutcomes.get(size - 3).getLabel();
            feature = new Feature("PreviousOutcomes_L1_3gram_L2R_" + featureValue, value);
            features.add(feature);
        }
        if (this.use4gram && previousOutcomes.size() >= 4) {
            size = previousOutcomes.size();
            String featureValue = previousOutcomes.get(size - 1).getLabel() + "_" + previousOutcomes.get(size - 2).getLabel() + "_" + previousOutcomes.get(size - 3).getLabel() + "_" + previousOutcomes.get(size - 4).getLabel();
            feature = new Feature("PreviousOutcomes_L1_4gram_L2R_" + featureValue, value);
            features.add(feature);
        }
        return features;
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "LabelFeatureExtractor");
    }
}

