/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.regression;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.CharProvenance;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.MutableOutputInfo;
import org.tribuo.OutputFactory;
import org.tribuo.evaluation.Evaluator;
import org.tribuo.provenance.OutputFactoryProvenance;
import org.tribuo.regression.ImmutableRegressionInfo;
import org.tribuo.regression.MutableRegressionInfo;
import org.tribuo.regression.Regressor;
import org.tribuo.regression.evaluation.RegressionEvaluation;
import org.tribuo.regression.evaluation.RegressionEvaluator;

public final class RegressionFactory
implements OutputFactory<Regressor> {
    private static final long serialVersionUID = 2L;
    public static final char DEFAULT_SPLIT_CHAR = ',';
    @Config(description="The character to split the dimensions on.")
    private char splitChar = (char)44;
    public static final Regressor UNKNOWN_REGRESSOR;
    @Deprecated
    public static final Regressor UNKNOWN_MULTIPLE_REGRESSOR;
    private RegressionFactoryProvenance provenance;
    private static final RegressionEvaluator evaluator;

    public RegressionFactory() {
        this.provenance = new RegressionFactoryProvenance(this.splitChar);
    }

    public RegressionFactory(char splitChar) {
        this.splitChar = splitChar;
        this.postConfig();
    }

    public void postConfig() {
        this.provenance = new RegressionFactoryProvenance(this.splitChar);
    }

    public <V> Regressor generateOutput(V label) {
        if (label instanceof Collection) {
            Collection c = (Collection)label;
            ArrayList<Pair<String, Double>> dimensions = new ArrayList<Pair<String, Double>>();
            int i = 0;
            for (Object o : c) {
                dimensions.add(Regressor.parseElement(i, o.toString()));
                ++i;
            }
            return Regressor.createFromPairList(dimensions);
        }
        return Regressor.parseString(label.toString(), this.splitChar);
    }

    public Regressor getUnknownOutput() {
        return UNKNOWN_REGRESSOR;
    }

    public MutableOutputInfo<Regressor> generateInfo() {
        return new MutableRegressionInfo();
    }

    public ImmutableOutputInfo<Regressor> constructInfoForExternalModel(Map<Regressor, Integer> mapping) {
        OutputFactory.validateMapping(mapping);
        String[] names = new String[mapping.size()];
        double[] values = new double[mapping.size()];
        double[] variances = new double[mapping.size()];
        int i = 0;
        for (Map.Entry<Regressor, Integer> m : mapping.entrySet()) {
            Regressor r = m.getKey();
            if (r.size() != 1) {
                throw new IllegalArgumentException("Expected to find a DimensionTuple, found multiple dimensions for a single integer. Found = " + r);
            }
            names[i] = r.getNames()[0];
            values[i] = r.getValues()[0];
            variances[i] = r.getVariances()[0];
            ++i;
        }
        Regressor newRegressor = new Regressor(names, values, variances);
        MutableRegressionInfo info = new MutableRegressionInfo();
        info.observe(newRegressor);
        return new ImmutableRegressionInfo(info, mapping);
    }

    public Evaluator<Regressor, RegressionEvaluation> getEvaluator() {
        return evaluator;
    }

    public int hashCode() {
        return "RegressionFactory".hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof RegressionFactory;
    }

    public OutputFactoryProvenance getProvenance() {
        return this.provenance;
    }

    static {
        UNKNOWN_MULTIPLE_REGRESSOR = UNKNOWN_REGRESSOR = new Regressor(new String[]{"UNKNOWN"}, new double[]{Double.NaN});
        evaluator = new RegressionEvaluator();
    }

    public static final class RegressionFactoryProvenance
    implements OutputFactoryProvenance {
        private static final long serialVersionUID = 1L;
        private final char splitChar;

        RegressionFactoryProvenance(char splitChar) {
            this.splitChar = splitChar;
        }

        public RegressionFactoryProvenance(Map<String, Provenance> map) {
            this.splitChar = ((CharProvenance)map.get("splitChar")).getValue().charValue();
        }

        public Map<String, Provenance> getConfiguredParameters() {
            return Collections.singletonMap("splitChar", new CharProvenance("splitChar", this.splitChar));
        }

        public String getClassName() {
            return RegressionFactory.class.getName();
        }

        public String toString() {
            return this.generateString("OutputFactory");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RegressionFactoryProvenance)) {
                return false;
            }
            RegressionFactoryProvenance pairs = (RegressionFactoryProvenance)o;
            return this.splitChar == pairs.splitChar;
        }

        public int hashCode() {
            return Objects.hash(Character.valueOf(this.splitChar));
        }
    }
}

