/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.agent;

import com.google.gson.reflect.TypeToken;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.text.StringSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.get.GetResponse;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.ml.common.agent.MLAgent;
import org.opensearch.ml.common.agent.MLToolSpec;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.connector.McpConnector;
import org.opensearch.ml.common.connector.McpStreamableHttpConnector;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensorOutput;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.common.utils.ToolUtils;
import org.opensearch.ml.engine.MLEngineClassLoader;
import org.opensearch.ml.engine.algorithms.remote.McpConnectorExecutor;
import org.opensearch.ml.engine.algorithms.remote.McpStreamableHttpConnectorExecutor;
import org.opensearch.ml.engine.encryptor.Encryptor;
import org.opensearch.ml.engine.function_calling.FunctionCalling;
import org.opensearch.ml.engine.memory.ConversationIndexMemory;
import org.opensearch.ml.engine.tools.McpSseTool;
import org.opensearch.ml.engine.tools.McpStreamableHttpTool;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.transport.client.Client;

public class AgentUtils {
    @Generated
    private static final Logger log = LogManager.getLogger(AgentUtils.class);
    public static final String SELECTED_TOOLS = "selected_tools";
    public static final String PROMPT_PREFIX = "prompt.prefix";
    public static final String PROMPT_SUFFIX = "prompt.suffix";
    public static final String RESPONSE_FORMAT_INSTRUCTION = "prompt.format_instruction";
    public static final String TOOL_RESPONSE = "prompt.tool_response";
    public static final String PROMPT_CHAT_HISTORY_PREFIX = "prompt.chat_history_prefix";
    public static final String DISABLE_TRACE = "disable_trace";
    public static final String VERBOSE = "verbose";
    public static final String LLM_GEN_INPUT = "llm_generated_input";
    public static final String LLM_RESPONSE_EXCLUDE_PATH = "llm_response_exclude_path";
    public static final String LLM_RESPONSE_FILTER = "llm_response_filter";
    public static final String TOOL_RESULT = "tool_result";
    public static final String TOOL_CALL_ID = "tool_call_id";
    public static final String LLM_INTERFACE_BEDROCK_CONVERSE_CLAUDE = "bedrock/converse/claude";
    public static final String LLM_INTERFACE_OPENAI_V1_CHAT_COMPLETIONS = "openai/v1/chat/completions";
    public static final String LLM_INTERFACE_BEDROCK_CONVERSE_DEEPSEEK_R1 = "bedrock/converse/deepseek_r1";
    public static final String TOOL_CALLS_PATH = "tool_calls_path";
    public static final String TOOL_CALLS_TOOL_NAME = "tool_calls.tool_name";
    public static final String TOOL_CALLS_TOOL_INPUT = "tool_calls.tool_input";
    public static final String TOOL_CALL_ID_PATH = "tool_calls.id_path";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    public static final String TOOLS = "_tools";
    public static final String TOOL_TEMPLATE = "tool_template";
    public static final String INTERACTION_TEMPLATE_ASSISTANT_TOOL_CALLS = "interaction_template.assistant_tool_calls";
    public static final String INTERACTION_TEMPLATE_ASSISTANT_TOOL_CALLS_PATH = "interaction_template.assistant_tool_calls_path";
    public static final String INTERACTION_TEMPLATE_ASSISTANT_TOOL_CALLS_EXCLUDE_PATH = "interaction_template.assistant_tool_calls_exclude_path";
    public static final String INTERACTIONS_PREFIX = "${_interactions.";
    public static final String LLM_FINAL_RESPONSE_POST_FILTER = "llm_final_response_post_filter";
    public static final String LLM_FINISH_REASON_PATH = "llm_finish_reason_path";
    public static final String LLM_FINISH_REASON_TOOL_USE = "llm_finish_reason_tool_use";
    public static final String TOOL_FILTERS_FIELD = "tool_filters";
    public static final String DEFAULT_NO_ESCAPE_PARAMS = "_chat_history,_tools,_interactions,tool_configs";
    public static final String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String DEFAULT_DATETIME_PREFIX = "Current date and time: ";
    private static final ZoneId UTC_ZONE = ZoneId.of("UTC");
    public static List<String> MODEL_RESPONSE_PATTERNS = List.of("\\{\\s*(\"(thought|action|action_input|final_answer)\"\\s*:\\s*\".*?\"\\s*,?\\s*)+\\}");

    public static String addExamplesToPrompt(Map<String, String> parameters, String prompt) {
        HashMap<String, String> examplesMap = new HashMap<String, String>();
        if (parameters.containsKey("examples")) {
            String examples = parameters.get("examples");
            List exampleList = (List)StringUtils.gson.fromJson(examples, List.class);
            StringBuilder exampleBuilder = new StringBuilder();
            exampleBuilder.append("EXAMPLES\n--------\n");
            String examplesPrefix = Optional.ofNullable(parameters.get("examples.prefix")).orElse("You should follow and learn from examples defined in <examples>: \n<examples>\n");
            String examplesSuffix = Optional.ofNullable(parameters.get("examples.suffix")).orElse("</examples>\n");
            exampleBuilder.append(examplesPrefix);
            String examplePrefix = Optional.ofNullable(parameters.get("examples.example.prefix")).orElse("<example>\n");
            String exampleSuffix = Optional.ofNullable(parameters.get("examples.example.suffix")).orElse("\n</example>\n");
            for (String example : exampleList) {
                exampleBuilder.append(examplePrefix).append(example).append(exampleSuffix);
            }
            exampleBuilder.append(examplesSuffix);
            examplesMap.put("examples", exampleBuilder.toString());
        } else {
            examplesMap.put("examples", "");
        }
        StringSubstitutor substitutor = new StringSubstitutor(examplesMap, "${parameters.", "}");
        return substitutor.replace(prompt);
    }

    public static String addPrefixSuffixToPrompt(Map<String, String> parameters, String prompt) {
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        String prefix = parameters.getOrDefault(PROMPT_PREFIX, "");
        String suffix = parameters.getOrDefault(PROMPT_SUFFIX, "");
        prefixMap.put(PROMPT_PREFIX, prefix);
        prefixMap.put(PROMPT_SUFFIX, suffix);
        StringSubstitutor substitutor = new StringSubstitutor(prefixMap, "${parameters.", "}");
        return substitutor.replace(prompt);
    }

    public static String addToolsToPrompt(Map<String, Tool> tools, Map<String, String> parameters, List<String> inputTools, String prompt) {
        if (parameters.containsKey(TOOL_TEMPLATE)) {
            return AgentUtils.addToolsToFunctionCalling(tools, parameters, inputTools, prompt);
        }
        return AgentUtils.addToolsToPromptString(tools, parameters, inputTools, prompt);
    }

    public static String addToolsToFunctionCalling(Map<String, Tool> tools, Map<String, String> parameters, List<String> inputTools, String prompt) {
        String toolTemplate = parameters.get(TOOL_TEMPLATE);
        ArrayList<String> toolInfos = new ArrayList<String>();
        for (String toolName : inputTools) {
            if (!tools.containsKey(toolName)) {
                throw new IllegalArgumentException("Tool [" + toolName + "] not registered for model");
            }
            Tool tool = tools.get(toolName);
            HashMap<Object, String> toolParams = new HashMap<Object, String>();
            toolParams.put(NAME, tool.getName());
            toolParams.put(DESCRIPTION, tool.getDescription());
            Map attributes = tool.getAttributes();
            if (attributes != null) {
                for (String key : attributes.keySet()) {
                    toolParams.put("attributes." + key, (String)attributes.get(key));
                }
            }
            StringSubstitutor substitutor = new StringSubstitutor(toolParams, "${tool.", "}");
            String chatQuestionMessage = substitutor.replace(toolTemplate);
            toolInfos.add(chatQuestionMessage);
        }
        parameters.put(TOOLS, String.join((CharSequence)", ", toolInfos));
        return prompt;
    }

    public static String addToolsToPromptString(Map<String, Tool> tools, Map<String, String> parameters, List<String> inputTools, String prompt) {
        StringBuilder toolsBuilder = new StringBuilder();
        StringBuilder toolNamesBuilder = new StringBuilder();
        String toolsPrefix = Optional.ofNullable(parameters.get("agent.tools.prefix")).orElse("You have access to the following tools defined in <tools>: \n<tools>\n");
        String toolsSuffix = Optional.ofNullable(parameters.get("agent.tools.suffix")).orElse("</tools>\n");
        String toolPrefix = Optional.ofNullable(parameters.get("agent.tools.tool.prefix")).orElse("<tool>\n");
        String toolSuffix = Optional.ofNullable(parameters.get("agent.tools.tool.suffix")).orElse("\n</tool>\n");
        toolsBuilder.append(toolsPrefix);
        for (String toolName : inputTools) {
            if (!tools.containsKey(toolName)) {
                throw new IllegalArgumentException("Tool [" + toolName + "] not registered for model");
            }
            toolsBuilder.append(toolPrefix).append(toolName).append(": ").append(tools.get(toolName).getDescription()).append(toolSuffix);
            toolNamesBuilder.append(toolName).append(", ");
        }
        toolsBuilder.append(toolsSuffix);
        HashMap<String, String> toolsPromptMap = new HashMap<String, String>();
        toolsPromptMap.put("tool_descriptions", toolsBuilder.toString());
        toolsPromptMap.put("tool_names", toolNamesBuilder.substring(0, toolNamesBuilder.length() - 1));
        if (parameters.containsKey("tool_descriptions")) {
            toolsPromptMap.put("tool_descriptions", parameters.get("tool_descriptions"));
        }
        if (parameters.containsKey("tool_names")) {
            toolsPromptMap.put("tool_names", parameters.get("tool_names"));
        }
        StringSubstitutor substitutor = new StringSubstitutor(toolsPromptMap, "${parameters.", "}");
        return substitutor.replace(prompt);
    }

    public static String addIndicesToPrompt(Map<String, String> parameters, String prompt) {
        HashMap<String, String> indicesMap = new HashMap<String, String>();
        if (parameters.containsKey("opensearch_indices")) {
            String indices = parameters.get("opensearch_indices");
            List indicesList = (List)StringUtils.gson.fromJson(indices, List.class);
            StringBuilder indicesBuilder = new StringBuilder();
            String indicesPrefix = Optional.ofNullable(parameters.get("opensearch_indices.prefix")).orElse("You have access to the following OpenSearch Index defined in <opensearch_indexes>: \n<opensearch_indexes>\n");
            String indicesSuffix = Optional.ofNullable(parameters.get("opensearch_indices.suffix")).orElse("</opensearch_indexes>\n");
            String indexPrefix = Optional.ofNullable(parameters.get("opensearch_indices.index.prefix")).orElse("<index>\n");
            String indexSuffix = Optional.ofNullable(parameters.get("opensearch_indices.index.suffix")).orElse("\n</index>\n");
            indicesBuilder.append(indicesPrefix);
            for (String e : indicesList) {
                indicesBuilder.append(indexPrefix).append(e).append(indexSuffix);
            }
            indicesBuilder.append(indicesSuffix);
            indicesMap.put("opensearch_indices", indicesBuilder.toString());
        } else {
            indicesMap.put("opensearch_indices", "");
        }
        StringSubstitutor substitutor = new StringSubstitutor(indicesMap, "${parameters.", "}");
        return substitutor.replace(prompt);
    }

    public static String addChatHistoryToPrompt(Map<String, String> parameters, String prompt) {
        HashMap<String, String> chatHistoryMap = new HashMap<String, String>();
        String chatHistory = parameters.getOrDefault("chat_history", "");
        chatHistoryMap.put("chat_history", chatHistory);
        parameters.put("chat_history", chatHistory);
        StringSubstitutor substitutor = new StringSubstitutor(chatHistoryMap, "${parameters.", "}");
        return substitutor.replace(prompt);
    }

    public static String addContextToPrompt(Map<String, String> parameters, String prompt) {
        HashMap<String, String> contextMap = new HashMap<String, String>();
        contextMap.put("context", parameters.getOrDefault("context", ""));
        parameters.put("context", (String)contextMap.get("context"));
        if (!contextMap.isEmpty()) {
            StringSubstitutor substitutor = new StringSubstitutor(contextMap, "${parameters.", "}");
            return substitutor.replace(prompt);
        }
        return prompt;
    }

    public static String extractModelResponseJson(String text) {
        return AgentUtils.extractModelResponseJson(text, null);
    }

    public static Map<String, String> parseLLMOutput(Map<String, String> parameters, ModelTensorOutput tmpModelTensorOutput, List<String> llmResponsePatterns, Set<String> inputTools, List<String> interactions, FunctionCalling functionCalling) {
        HashMap<String, String> modelOutput;
        block34: {
            modelOutput = new HashMap<String, String>();
            Map<String, ?> dataAsMap = ((ModelTensor)((ModelTensors)tmpModelTensorOutput.getMlModelOutputs().get(0)).getMlModelTensors().get(0)).getDataAsMap();
            String llmResponseExcludePath = parameters.get(LLM_RESPONSE_EXCLUDE_PATH);
            if (llmResponseExcludePath != null) {
                dataAsMap = AgentUtils.removeJsonPath(dataAsMap, llmResponseExcludePath, true);
            }
            if (dataAsMap.size() == 1 && dataAsMap.containsKey("response")) {
                String llmReasoningResponse = StringUtils.toJson(dataAsMap.get("response"));
                String thoughtResponse = null;
                try {
                    thoughtResponse = AgentUtils.extractModelResponseJson(llmReasoningResponse, llmResponsePatterns);
                    modelOutput.put("thought_response", thoughtResponse);
                }
                catch (IllegalArgumentException e) {
                    modelOutput.put("thought_response", llmReasoningResponse);
                    thoughtResponse = llmReasoningResponse;
                }
                AgentUtils.parseThoughtResponse(modelOutput, thoughtResponse);
            } else if (parameters.containsKey(TOOL_CALLS_PATH)) {
                Map llmResponse;
                Object response;
                modelOutput.put("thought_response", StringUtils.toJson(dataAsMap));
                boolean isToolUseResponse = false;
                try {
                    response = JsonPath.read(dataAsMap, (String)parameters.get(LLM_RESPONSE_FILTER), (Predicate[])new Predicate[0]);
                }
                catch (PathNotFoundException e) {
                    response = JsonPath.read(dataAsMap, (String)parameters.get(TOOL_CALLS_PATH), (Predicate[])new Predicate[0]);
                    isToolUseResponse = true;
                }
                String llmFinishReasonPath = parameters.get(LLM_FINISH_REASON_PATH);
                String llmFinishReason = "";
                if (llmFinishReasonPath.startsWith("_llm_response.")) {
                    llmResponse = StringUtils.fromJson((String)response.toString(), (String)"response");
                    llmFinishReason = (String)JsonPath.read((Object)llmResponse, (String)llmFinishReasonPath.substring("_llm_response.".length()), (Predicate[])new Predicate[0]);
                } else {
                    llmFinishReason = (String)JsonPath.read(dataAsMap, (String)llmFinishReasonPath, (Predicate[])new Predicate[0]);
                }
                if (parameters.get(LLM_FINISH_REASON_TOOL_USE).equalsIgnoreCase(llmFinishReason) || isToolUseResponse) {
                    List toolCalls = null;
                    try {
                        String toolName = "";
                        String toolInput = "";
                        String toolCallId = "";
                        if (functionCalling != null) {
                            toolCalls = functionCalling.handle(tmpModelTensorOutput, parameters);
                            if (!toolCalls.isEmpty()) {
                                toolName = toolCalls.getFirst().get("tool_name");
                                toolInput = (String)((Map)toolCalls.getFirst()).get("tool_input");
                                toolCallId = (String)((Map)toolCalls.getFirst()).get(TOOL_CALL_ID);
                            }
                        } else {
                            String toolCallsPath = parameters.get(TOOL_CALLS_PATH);
                            if (toolCallsPath.startsWith("_llm_response.")) {
                                Map llmResponse2 = StringUtils.fromJson((String)response.toString(), (String)"response");
                                toolCalls = (List)JsonPath.read((Object)llmResponse2, (String)toolCallsPath.substring("_llm_response.".length()), (Predicate[])new Predicate[0]);
                            } else {
                                toolCalls = (List)JsonPath.read(dataAsMap, (String)toolCallsPath, (Predicate[])new Predicate[0]);
                            }
                            if (!toolCalls.isEmpty()) {
                                toolName = (String)JsonPath.read(toolCalls.get(0), (String)parameters.get(TOOL_CALLS_TOOL_NAME), (Predicate[])new Predicate[0]);
                                toolInput = StringUtils.toJson((Object)JsonPath.read(toolCalls.get(0), (String)parameters.get(TOOL_CALLS_TOOL_INPUT), (Predicate[])new Predicate[0]));
                                toolCallId = (String)JsonPath.read(toolCalls.get(0), (String)parameters.get(TOOL_CALL_ID_PATH), (Predicate[])new Predicate[0]);
                            }
                        }
                        String toolCallsMsgPath = parameters.get(INTERACTION_TEMPLATE_ASSISTANT_TOOL_CALLS_PATH);
                        String toolCallsMsgExcludePath = parameters.get(INTERACTION_TEMPLATE_ASSISTANT_TOOL_CALLS_EXCLUDE_PATH);
                        if (toolCallsMsgPath != null) {
                            if (toolCallsMsgExcludePath != null) {
                                Map<String, ?> newDataAsMap = AgentUtils.removeJsonPath(dataAsMap, toolCallsMsgExcludePath, false);
                                Object toolCallsMsg = JsonPath.read(newDataAsMap, (String)toolCallsMsgPath, (Predicate[])new Predicate[0]);
                                interactions.add(StringUtils.toJson((Object)toolCallsMsg));
                            } else {
                                Object toolCallsMsg = JsonPath.read(dataAsMap, (String)toolCallsMsgPath, (Predicate[])new Predicate[0]);
                                interactions.add(StringUtils.toJson((Object)toolCallsMsg));
                            }
                        } else {
                            interactions.add(AgentUtils.substitute(parameters.get(INTERACTION_TEMPLATE_ASSISTANT_TOOL_CALLS), Map.of("tool_calls", StringUtils.toJson((Object)toolCalls)), INTERACTIONS_PREFIX));
                        }
                        modelOutput.put("thought", "");
                        modelOutput.put("action", toolName);
                        modelOutput.put("action_input", toolInput);
                        modelOutput.put(TOOL_CALL_ID, toolCallId);
                    }
                    catch (PathNotFoundException e) {
                        if (StringUtils.isJson((String)response.toString())) {
                            Map llmResponse3 = StringUtils.fromJson((String)response.toString(), (String)"response");
                            modelOutput.put("final_answer", StringUtils.toJson((Object)AgentUtils.postFilterFinalAnswer(parameters, llmResponse3)));
                            break block34;
                        }
                        modelOutput.put("final_answer", StringUtils.toJson((Object)response));
                    }
                } else if (StringUtils.isJson((String)response.toString())) {
                    llmResponse = StringUtils.fromJson((String)response.toString(), (String)"response");
                    modelOutput.put("final_answer", StringUtils.toJson((Object)AgentUtils.postFilterFinalAnswer(parameters, llmResponse)));
                } else {
                    modelOutput.put("final_answer", StringUtils.toJson((Object)response));
                }
            } else {
                AgentUtils.extractParams(modelOutput, dataAsMap, "thought");
                AgentUtils.extractParams(modelOutput, dataAsMap, "action");
                AgentUtils.extractParams(modelOutput, dataAsMap, "action_input");
                AgentUtils.extractParams(modelOutput, dataAsMap, "final_answer");
                try {
                    modelOutput.put("thought_response", StringUtils.toJson(dataAsMap));
                }
                catch (Exception e) {
                    log.warn("Failed to parse model response", (Throwable)e);
                }
            }
        }
        String action = (String)modelOutput.get("action");
        if (action != null) {
            String matchedTool = AgentUtils.getMatchedTool(inputTools, action);
            if (matchedTool != null) {
                modelOutput.put("action", matchedTool);
            } else {
                modelOutput.remove("action");
            }
        }
        if (!modelOutput.containsKey("action") && !modelOutput.containsKey("final_answer")) {
            modelOutput.put("final_answer", (String)modelOutput.get("thought_response"));
        }
        return modelOutput;
    }

    private static String postFilterFinalAnswer(Map<String, String> parameters, Map<String, Object> llmResponse) {
        String filter = parameters.get(LLM_FINAL_RESPONSE_POST_FILTER);
        if (filter != null) {
            return StringUtils.toJson((Object)JsonPath.read(llmResponse, (String)filter, (Predicate[])new Predicate[0]));
        }
        return StringUtils.toJson(llmResponse);
    }

    public static Map<String, ?> removeJsonPath(Map<String, ?> json, String excludePaths, boolean inPlace) {
        Type listType = new TypeToken<List<String>>(){}.getType();
        List excludedPath = (List)StringUtils.gson.fromJson(excludePaths, listType);
        return AgentUtils.removeJsonPath(json, excludedPath, inPlace);
    }

    public static Map<String, ?> removeJsonPath(Map<String, ?> json, List<String> excludePaths, boolean inPlace) {
        if (json == null || excludePaths == null || excludePaths.isEmpty()) {
            return json;
        }
        if (inPlace) {
            DocumentContext context = JsonPath.parse(json);
            for (String path : excludePaths) {
                try {
                    context.delete(path, new Predicate[0]);
                }
                catch (PathNotFoundException e) {
                    log.warn("can't find path: {}", (Object)path);
                }
            }
            return json;
        }
        Map copy = StringUtils.fromJson((String)StringUtils.gson.toJson(json), (String)"response");
        DocumentContext context = JsonPath.parse((Object)copy);
        for (String path : excludePaths) {
            try {
                context.delete(path, new Predicate[0]);
            }
            catch (PathNotFoundException e) {
                log.warn("can't find path: {}", (Object)path);
            }
        }
        return (Map)context.json();
    }

    public static String substitute(String template, Map<String, String> params, String prefix) {
        StringSubstitutor substitutor = new StringSubstitutor(params, prefix, "}");
        return substitutor.replace(template);
    }

    public static String getMatchedTool(Collection<String> tools, String action) {
        for (String tool : tools) {
            if (!action.toLowerCase(Locale.ROOT).contains(tool.toLowerCase(Locale.ROOT))) continue;
            return tool;
        }
        return null;
    }

    public static void extractParams(Map<String, String> modelOutput, Map<String, ?> dataAsMap, String paramName) {
        if (dataAsMap.containsKey(paramName)) {
            modelOutput.put(paramName, StringUtils.toJson(dataAsMap.get(paramName)));
        }
    }

    public static String extractModelResponseJson(String text, List<String> llmResponsePatterns) {
        if (text.contains("```json") && (text = text.substring(text.indexOf("```json") + "```json".length())).contains("```")) {
            text = text.substring(0, text.lastIndexOf("```"));
        }
        if (StringUtils.isJson((String)(text = text.trim()))) {
            return text;
        }
        String matchedPart = null;
        if (llmResponsePatterns != null && (matchedPart = AgentUtils.findMatchedPart(text, llmResponsePatterns)) != null) {
            return matchedPart;
        }
        matchedPart = AgentUtils.findMatchedPart(text, MODEL_RESPONSE_PATTERNS);
        if (matchedPart != null) {
            return matchedPart;
        }
        throw new IllegalArgumentException("Model output is invalid");
    }

    public static void parseThoughtResponse(Map<String, String> modelOutput, String thoughtResponse) {
        if (thoughtResponse != null) {
            if (StringUtils.isJson((String)thoughtResponse)) {
                modelOutput.putAll(StringUtils.getParameterMap((Map)((Map)StringUtils.gson.fromJson(thoughtResponse, Map.class))));
            } else {
                String thought = AgentUtils.extractThought(thoughtResponse);
                String action = AgentUtils.extractAction(thoughtResponse);
                String actionInput = AgentUtils.extractActionInput(thoughtResponse);
                String finalAnswer = AgentUtils.extractFinalAnswer(thoughtResponse);
                if (thought != null) {
                    modelOutput.put("thought", thought);
                }
                if (action != null) {
                    modelOutput.put("action", action);
                }
                if (actionInput != null) {
                    modelOutput.put("action_input", actionInput);
                }
                if (finalAnswer != null) {
                    modelOutput.put("final_answer", finalAnswer);
                }
            }
        }
    }

    public static String extractFinalAnswer(String text) {
        String pattern;
        Pattern jsonBlockPattern;
        Matcher jsonBlockMatcher;
        String result = null;
        if (text.contains("\"final_answer\"") && (jsonBlockMatcher = (jsonBlockPattern = Pattern.compile(pattern = "\"final_answer\"\\s*:\\s*\"(.*)\"", 32)).matcher(text)).find()) {
            result = jsonBlockMatcher.group(1);
        }
        return result;
    }

    public static String extractThought(String text) {
        String pattern;
        Pattern jsonBlockPattern;
        Matcher jsonBlockMatcher;
        String result = null;
        if (text.contains("\"thought\"") && (jsonBlockMatcher = (jsonBlockPattern = Pattern.compile(pattern = "\"thought\"\\s*:\\s*\"(.*?)\"\\s*,\\s*[\"final_answer\"|\"action\"]", 32)).matcher(text)).find()) {
            result = jsonBlockMatcher.group(1);
        }
        return result;
    }

    public static String extractAction(String text) {
        String pattern;
        Pattern jsonBlockPattern;
        Matcher jsonBlockMatcher;
        String result = null;
        if (text.contains("\"action\"") && (jsonBlockMatcher = (jsonBlockPattern = Pattern.compile(pattern = "\"action\"\\s*:\\s*\"(.*?)(?:\"action_input\"|$)", 32)).matcher(text)).find()) {
            result = jsonBlockMatcher.group(1);
        }
        return result;
    }

    public static String extractActionInput(String text) {
        String pattern;
        Pattern jsonBlockPattern;
        Matcher jsonBlockMatcher;
        String result = null;
        if (text.contains("\"action_input\"") && (jsonBlockMatcher = (jsonBlockPattern = Pattern.compile(pattern = "\"action_input\"\\s*:\\s*\"((?:[^\\\"]|\\\")*)\"", 32)).matcher(text)).find()) {
            result = jsonBlockMatcher.group(1);
            result = result.replace("\\\"", "\"");
        }
        return result;
    }

    public static String findMatchedPart(String text, List<String> patternList) {
        for (String p : patternList) {
            Pattern pattern = Pattern.compile(p);
            Matcher matcher = pattern.matcher(text);
            if (!matcher.find()) continue;
            return matcher.group();
        }
        return null;
    }

    public static String outputToOutputString(Object output) throws PrivilegedActionException {
        ModelTensor outputModel;
        String outputString = output instanceof ModelTensorOutput ? ((outputModel = (ModelTensor)((ModelTensors)((ModelTensorOutput)output).getMlModelOutputs().get(0)).getMlModelTensors().get(0)).getDataAsMap() != null ? AccessController.doPrivileged(() -> StringUtils.gson.toJson((Object)outputModel.getDataAsMap())) : outputModel.getResult()) : (output instanceof String ? (String)output : AccessController.doPrivileged(() -> StringUtils.gson.toJson(output)));
        return outputString;
    }

    public static int getMessageHistoryLimit(Map<String, String> params) {
        String messageHistoryLimitStr = params.get("message_history_limit");
        return messageHistoryLimitStr != null ? Integer.parseInt(messageHistoryLimitStr) : ConversationIndexMemory.LAST_N_INTERACTIONS;
    }

    public static List<MLToolSpec> getMlToolSpecs(MLAgent mlAgent, Map<String, String> params) {
        String selectedToolsStr = params.get(SELECTED_TOOLS);
        ArrayList<MLToolSpec> toolSpecs = new ArrayList<MLToolSpec>();
        List mlToolSpecs = mlAgent.getTools();
        if (mlToolSpecs != null) {
            toolSpecs.addAll(mlToolSpecs);
        }
        if (!Strings.isEmpty((CharSequence)selectedToolsStr)) {
            List selectedTools = (List)StringUtils.gson.fromJson(selectedToolsStr, List.class);
            HashMap<String, MLToolSpec> toolNameSpecMap = new HashMap<String, MLToolSpec>();
            for (MLToolSpec toolSpec : toolSpecs) {
                toolNameSpecMap.put(ToolUtils.getToolName((MLToolSpec)toolSpec), toolSpec);
            }
            ArrayList<MLToolSpec> selectedToolSpecs = new ArrayList<MLToolSpec>();
            for (String tool : selectedTools) {
                if (!toolNameSpecMap.containsKey(tool)) continue;
                selectedToolSpecs.add((MLToolSpec)toolNameSpecMap.get(tool));
            }
            toolSpecs = selectedToolSpecs;
        }
        return toolSpecs;
    }

    public static void getMcpToolSpecs(MLAgent mlAgent, Client client, SdkClient sdkClient, Encryptor encryptor, ActionListener<List<MLToolSpec>> finalListener) {
        String mcpConnectorConfigJSON;
        String tenantId = mlAgent.getTenantId();
        String string = mcpConnectorConfigJSON = mlAgent.getParameters() != null ? (String)mlAgent.getParameters().get("mcp_connectors") : null;
        if (mcpConnectorConfigJSON == null) {
            finalListener.onResponse(Collections.emptyList());
            return;
        }
        Type listType = new TypeToken<List<Map<String, Object>>>(){}.getType();
        List mcpConnectorConfigs = (List)StringUtils.gson.fromJson(mcpConnectorConfigJSON, listType);
        AtomicInteger remainingConnectors = new AtomicInteger(mcpConnectorConfigs.size());
        List finalToolSpecs = Collections.synchronizedList(new ArrayList());
        for (Map mcpConnectorConfig : mcpConnectorConfigs) {
            String connectorId = (String)mcpConnectorConfig.get("mcp_connector_id");
            List toolFilters = (List)mcpConnectorConfig.get(TOOL_FILTERS_FIELD);
            AgentUtils.getMCPToolSpecsFromConnector(connectorId, tenantId, sdkClient, client, encryptor, (ActionListener<List<MLToolSpec>>)ActionListener.wrap(mcpToolspecs -> {
                ArrayList<MLToolSpec> filteredTools;
                if (toolFilters == null || toolFilters.isEmpty()) {
                    filteredTools = mcpToolspecs;
                } else {
                    filteredTools = new ArrayList<MLToolSpec>();
                    List compiledPatterns = toolFilters.stream().map(Pattern::compile).collect(Collectors.toList());
                    block0: for (MLToolSpec toolSpec : mcpToolspecs) {
                        for (Pattern pattern : compiledPatterns) {
                            if (!pattern.matcher(toolSpec.getName()).matches()) continue;
                            filteredTools.add(toolSpec);
                            continue block0;
                        }
                    }
                }
                finalToolSpecs.addAll(filteredTools);
                if (remainingConnectors.decrementAndGet() == 0) {
                    finalListener.onResponse((Object)finalToolSpecs);
                }
            }, e -> {
                log.error("Error processing connector: " + connectorId, (Throwable)e);
                if (remainingConnectors.decrementAndGet() == 0) {
                    finalListener.onResponse((Object)finalToolSpecs);
                }
            }));
        }
    }

    private static void getMCPToolSpecsFromConnector(String connectorId, String tenantId, SdkClient sdkClient, Client client, Encryptor encryptor, ActionListener<List<MLToolSpec>> toolListener) {
        AgentUtils.getConnector(connectorId, tenantId, sdkClient, client, (ActionListener<Connector>)ActionListener.wrap(connector -> {
            try {
                if (!(connector instanceof McpConnector) && !(connector instanceof McpStreamableHttpConnector)) {
                    log.error("Connector with ID " + connectorId + " is not of type McpConnector or McpStreamableHttpConnector");
                    toolListener.onResponse(Collections.emptyList());
                    return;
                }
                connector.decrypt("", (credential, tid) -> encryptor.decrypt((String)credential, tenantId), tenantId);
                if (connector instanceof McpConnector) {
                    McpConnectorExecutor connectorExecutor = (McpConnectorExecutor)MLEngineClassLoader.initInstance(connector.getProtocol(), connector, Connector.class);
                    List<MLToolSpec> mcpToolSpecs = connectorExecutor.getMcpToolSpecs();
                    toolListener.onResponse(mcpToolSpecs);
                    return;
                }
                if (connector instanceof McpStreamableHttpConnector) {
                    McpStreamableHttpConnectorExecutor connectorExecutor = (McpStreamableHttpConnectorExecutor)MLEngineClassLoader.initInstance(connector.getProtocol(), connector, Connector.class);
                    List<MLToolSpec> mcpToolSpecs = connectorExecutor.getMcpToolSpecs();
                    toolListener.onResponse(mcpToolSpecs);
                    return;
                }
                log.error("Unsupported connector type for connector: " + connectorId);
                toolListener.onResponse(Collections.emptyList());
            }
            catch (Exception e) {
                log.error("Failed to get tools from connector: " + connectorId, (Throwable)e);
                toolListener.onResponse(Collections.emptyList());
            }
        }, e -> {
            log.error("Failed to get the MCP Connector: " + connectorId, (Throwable)e);
            toolListener.onResponse(Collections.emptyList());
        }));
    }

    public static void getConnector(String connectorId, String tenantId, SdkClient sdkClient, Client client, ActionListener<Connector> listener) {
        GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-connector")).id(connectorId)).tenantId(tenantId)).build();
        try (ThreadContext.StoredContext ctx = client.threadPool().getThreadContext().stashContext();){
            sdkClient.getDataObjectAsync(getDataObjectRequest).whenComplete((r, throwable) -> {
                block15: {
                    log.debug("Completed Get Connector Request, id:{}", (Object)connectorId);
                    ctx.restore();
                    if (throwable != null) {
                        Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        if (ExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
                            log.error("Failed to get connector index", (Throwable)cause);
                            listener.onFailure((Exception)new OpenSearchStatusException("Failed to find connector", RestStatus.NOT_FOUND, new Object[0]));
                        } else {
                            log.error("Failed to get ML connector {}", (Object)connectorId, (Object)cause);
                            listener.onFailure(cause);
                        }
                    } else {
                        try {
                            GetResponse gr;
                            GetResponse getResponse = gr = r.parser() == null ? null : GetResponse.fromXContent((XContentParser)r.parser());
                            if (gr != null && gr.isExists()) {
                                try (XContentParser parser = AgentUtils.createXContentParserFromRegistry(NamedXContentRegistry.EMPTY, gr.getSourceAsBytesRef());){
                                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                    Connector connector = Connector.createConnector((XContentParser)parser);
                                    listener.onResponse((Object)connector);
                                    break block15;
                                }
                                catch (Exception e) {
                                    log.error("Failed to parse connector:{}", (Object)connectorId);
                                    listener.onFailure(e);
                                }
                                break block15;
                            }
                            listener.onFailure((Exception)new OpenSearchStatusException("Failed to find connector:" + connectorId, RestStatus.NOT_FOUND, new Object[0]));
                        }
                        catch (Exception e) {
                            listener.onFailure(e);
                        }
                    }
                }
            });
        }
    }

    public static XContentParser createXContentParserFromRegistry(NamedXContentRegistry xContentRegistry, BytesReference bytesReference) throws IOException {
        return XContentHelper.createParser((NamedXContentRegistry)xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)bytesReference, (MediaType)XContentType.JSON);
    }

    public static void createTools(Map<String, Tool.Factory> toolFactories, Map<String, String> params, List<MLToolSpec> toolSpecs, Map<String, Tool> tools, Map<String, MLToolSpec> toolSpecMap, MLAgent mlAgent) {
        if (toolSpecs == null) {
            return;
        }
        for (MLToolSpec toolSpec : toolSpecs) {
            Map toolParams = ToolUtils.buildToolParameters(params, (MLToolSpec)toolSpec, (String)mlAgent.getTenantId());
            Tool tool = AgentUtils.createTool(toolFactories, toolParams, toolSpec);
            tools.put(tool.getName(), tool);
            if (toolSpec.getAttributes() != null) {
                if (tool.getAttributes() == null) {
                    HashMap attributes = new HashMap();
                    attributes.putAll(toolSpec.getAttributes());
                    tool.setAttributes(attributes);
                } else {
                    tool.getAttributes().putAll(toolSpec.getAttributes());
                }
            }
            toolSpecMap.put(tool.getName(), toolSpec);
        }
    }

    public static Map<String, String> constructToolParams(Map<String, Tool> tools, Map<String, MLToolSpec> toolSpecMap, String question, AtomicReference<String> lastActionInput, String action, String actionInput) {
        HashMap<String, String> toolParams = new HashMap<String, String>();
        Map toolSpecParams = toolSpecMap.get(action).getParameters();
        Map toolSpecConfigMap = toolSpecMap.get(action).getConfigMap();
        MLToolSpec toolSpec = toolSpecMap.get(action);
        if (toolSpecParams != null) {
            toolParams.putAll(toolSpecParams);
            for (String key : toolSpecParams.keySet()) {
                String toolNamePrefix;
                if (!key.startsWith(toolNamePrefix = ToolUtils.getToolName((MLToolSpec)toolSpec) + ".")) continue;
                toolParams.put(key.replace(toolNamePrefix, ""), (String)toolSpecParams.get(key));
            }
        }
        if (toolSpecConfigMap != null) {
            toolParams.putAll(toolSpecConfigMap);
        }
        toolParams.put(LLM_GEN_INPUT, actionInput);
        if (StringUtils.isJson((String)actionInput)) {
            Map params = StringUtils.getParameterMap((Map)((Map)StringUtils.gson.fromJson(actionInput, Map.class)));
            toolParams.putAll(params);
        }
        if (tools.get(action).useOriginalInput()) {
            toolParams.put("input", question);
            lastActionInput.set(question);
        } else if (toolSpecConfigMap != null && toolSpecConfigMap.containsKey("input")) {
            input = (String)toolSpecConfigMap.get("input");
            substitutor = new StringSubstitutor(toolParams, "${parameters.", "}");
            input = substitutor.replace(input);
            toolParams.put("input", input);
            if (StringUtils.isJson((String)input)) {
                Map params = StringUtils.getParameterMap((Map)((Map)StringUtils.gson.fromJson(input, Map.class)));
                toolParams.putAll(params);
            }
        } else if (toolParams.containsKey("input")) {
            input = (String)toolParams.get("input");
            substitutor = new StringSubstitutor(toolParams, "${parameters.", "}");
            input = substitutor.replace(input);
            toolParams.put("input", input);
        } else {
            toolParams.put("input", actionInput);
        }
        return toolParams;
    }

    public static void cleanUpResource(Map<String, Tool> tools) {
        for (Map.Entry<String, Tool> entry : tools.entrySet()) {
            Tool tool = entry.getValue();
            if (tool instanceof McpSseTool) {
                ((McpSseTool)tool).getMcpSyncClient().closeGracefully();
                continue;
            }
            if (!(tool instanceof McpStreamableHttpTool)) continue;
            ((McpStreamableHttpTool)tool).getMcpSyncClient().closeGracefully();
        }
    }

    public static String getCurrentDateTime(String dateFormat) {
        DateTimeFormatter formatter;
        Instant now = Instant.now();
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dateFormat)) {
            try {
                formatter = DateTimeFormatter.ofPattern(dateFormat).withZone(UTC_ZONE);
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid date format provided: {}. Using default format.", (Object)dateFormat);
                formatter = DateTimeFormatter.ofPattern(DEFAULT_DATETIME_FORMAT).withZone(UTC_ZONE);
            }
        } else {
            formatter = DateTimeFormatter.ofPattern(DEFAULT_DATETIME_FORMAT).withZone(UTC_ZONE);
        }
        return DEFAULT_DATETIME_PREFIX + formatter.format(now);
    }

    public static List<String> getToolNames(Map<String, Tool> tools) {
        ArrayList<String> inputTools = new ArrayList<String>();
        for (Map.Entry<String, Tool> entry : tools.entrySet()) {
            String toolName = entry.getValue().getName();
            inputTools.add(toolName);
        }
        return inputTools;
    }

    public static Tool createTool(Map<String, Tool.Factory> toolFactories, Map<String, String> executeParams, MLToolSpec toolSpec) {
        if (!toolFactories.containsKey(toolSpec.getType())) {
            throw new IllegalArgumentException("Tool not found: " + toolSpec.getType());
        }
        HashMap<String, String> toolParams = new HashMap<String, String>();
        toolParams.putAll(executeParams);
        Map runtimeResources = toolSpec.getRuntimeResources();
        if (runtimeResources != null) {
            toolParams.putAll(runtimeResources);
        }
        Tool tool = toolFactories.get(toolSpec.getType()).create(toolParams);
        String toolName = ToolUtils.getToolName((MLToolSpec)toolSpec);
        tool.setName(toolName);
        if (toolSpec.getDescription() != null) {
            tool.setDescription(toolSpec.getDescription());
        }
        if (executeParams.containsKey(toolName + ".description")) {
            tool.setDescription(executeParams.get(toolName + ".description"));
        }
        return tool;
    }
}

