/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Strings;
import org.opensearch.action.admin.indices.get.GetIndexRequest;
import org.opensearch.action.admin.indices.get.GetIndexResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeRequest;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.spi.tools.Parser;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.utils.ToolUtils;
import org.opensearch.ml.engine.tools.parser.ToolParser;
import org.opensearch.transport.client.Client;

@ToolAnnotation(value="IndexMappingTool")
public class IndexMappingTool
implements Tool {
    @Generated
    private static final Logger log = LogManager.getLogger(IndexMappingTool.class);
    public static final String TYPE = "IndexMappingTool";
    public static final String STRICT_FIELD = "strict";
    private static final String DEFAULT_DESCRIPTION = String.join((CharSequence)" ", "This tool returns index mappings and settings for specified indices.", "Required argument: 'index' - comma-delimited list of one or more indices (supports wildcards like 'my-index-*').", "Optional argument: 'local' - if true, returns info from local node only instead of cluster manager (default: false).", "Response format: For each index, 'mappings' contains field definitions under 'properties' (each field has a 'type'), and 'settings' contains configuration as a flattened key-value map.");
    public static final String DEFAULT_INPUT_SCHEMA = "{\"type\":\"object\",\"properties\":{\"index\":{\"type\":\"array\",\"description\":\"OpenSearch index name list, separated by comma. for example: [\\\"index1\\\", \\\"index2\\\"]\",\"items\":{\"type\":\"string\"}}},\"required\":[\"index\"],\"additionalProperties\":false}";
    public static final Map<String, Object> DEFAULT_ATTRIBUTES = Map.of("input_schema", "{\"type\":\"object\",\"properties\":{\"index\":{\"type\":\"array\",\"description\":\"OpenSearch index name list, separated by comma. for example: [\\\"index1\\\", \\\"index2\\\"]\",\"items\":{\"type\":\"string\"}}},\"required\":[\"index\"],\"additionalProperties\":false}", "strict", true);
    private String name = "IndexMappingTool";
    private Map<String, Object> attributes;
    private String description = DEFAULT_DESCRIPTION;
    private String version;
    private Client client;
    private Parser<?, ?> inputParser;
    private Parser outputParser;

    public IndexMappingTool(Client client) {
        this.client = client;
        this.attributes = new HashMap<String, Object>();
        this.attributes.put("input_schema", DEFAULT_INPUT_SCHEMA);
        this.attributes.put(STRICT_FIELD, true);
    }

    public <T> void run(Map<String, String> originalParameters, final ActionListener<T> listener) {
        try {
            final Map parameters = ToolUtils.extractInputParameters(originalParameters, this.attributes);
            List<String> indexList = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)parameters.get("index")))) {
                try {
                    indexList = (List)org.opensearch.ml.common.utils.StringUtils.gson.fromJson((String)parameters.get("index"), List.class);
                }
                catch (Exception e) {
                    indexList.add((String)parameters.get("index"));
                }
            }
            if (indexList.isEmpty()) {
                String empty = "There were no results searching the index parameter [" + (String)parameters.get("index") + "].";
                listener.onResponse((Object)empty);
                return;
            }
            String[] indices = indexList.toArray(Strings.EMPTY_ARRAY);
            IndicesOptions indicesOptions = IndicesOptions.strictExpand();
            boolean local = Boolean.parseBoolean(parameters.getOrDefault("local", "false"));
            TimeValue clusterManagerNodeTimeout = ClusterManagerNodeRequest.DEFAULT_CLUSTER_MANAGER_NODE_TIMEOUT;
            ActionListener<GetIndexResponse> internalListener = new ActionListener<GetIndexResponse>(){

                public void onResponse(GetIndexResponse getIndexResponse) {
                    try {
                        if (getIndexResponse.indices().length == 0) {
                            String empty = "There were no results searching the index parameter [" + (String)parameters.get("index") + "].";
                            listener.onResponse((Object)empty);
                            return;
                        }
                        StringBuilder sb = new StringBuilder();
                        for (String index : getIndexResponse.indices()) {
                            Settings settings;
                            sb.append("index: ").append(index).append("\n\n");
                            MappingMetadata mapping = (MappingMetadata)getIndexResponse.mappings().get(index);
                            if (mapping != null) {
                                sb.append("mappings:\n");
                                for (Map.Entry entry : mapping.sourceAsMap().entrySet()) {
                                    sb.append((String)entry.getKey()).append("=").append(entry.getValue()).append('\n');
                                }
                                sb.append("\n\n");
                            }
                            if ((settings = (Settings)getIndexResponse.settings().get(index)) == null) continue;
                            sb.append("settings:\n").append(settings.toDelimitedString('\n')).append("\n\n");
                        }
                        String output = sb.toString();
                        listener.onResponse(IndexMappingTool.this.outputParser != null ? IndexMappingTool.this.outputParser.parse((Object)output) : output);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            };
            GetIndexRequest getIndexRequest = (GetIndexRequest)((GetIndexRequest)((GetIndexRequest)((GetIndexRequest)new GetIndexRequest().indices(indices)).indicesOptions(indicesOptions)).local(local)).clusterManagerNodeTimeout(clusterManagerNodeTimeout);
            this.client.admin().indices().getIndex(getIndexRequest, (ActionListener)internalListener);
        }
        catch (Exception e) {
            log.error("Failed to run IndexMappingTool", (Throwable)e);
            listener.onFailure(e);
        }
    }

    public String getType() {
        return TYPE;
    }

    public boolean validate(Map<String, String> parameters) {
        return parameters != null && !parameters.isEmpty() && parameters.containsKey("index");
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public void setInputParser(Parser<?, ?> inputParser) {
        this.inputParser = inputParser;
    }

    @Generated
    public void setOutputParser(Parser outputParser) {
        this.outputParser = outputParser;
    }

    public static class Factory
    implements Tool.Factory<IndexMappingTool> {
        private Client client;
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<IndexMappingTool> clazz = IndexMappingTool.class;
            synchronized (IndexMappingTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client) {
            this.client = client;
        }

        public IndexMappingTool create(Map<String, Object> params) {
            IndexMappingTool indexMappingTool = new IndexMappingTool(this.client);
            indexMappingTool.setOutputParser(ToolParser.createFromToolParams(params));
            return indexMappingTool;
        }

        public String getDefaultDescription() {
            return DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return IndexMappingTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }

        public Map<String, Object> getDefaultAttributes() {
            return DEFAULT_ATTRIBUTES;
        }
    }
}

