/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.inference.streaming;

import ai.djl.ndarray.BytesSupplier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ChunkedBytesSupplier
implements BytesSupplier {
    private LinkedBlockingQueue<BytesSupplier> queue = new LinkedBlockingQueue();
    private AtomicBoolean completed = new AtomicBoolean();

    public void appendContent(byte[] data, boolean lastChunk) {
        this.appendContent(BytesSupplier.wrap(data), lastChunk);
    }

    public void appendContent(BytesSupplier bytesSupplier, boolean lastChunk) {
        if (lastChunk) {
            this.completed.set(true);
        }
        this.queue.offer(bytesSupplier);
    }

    public boolean hasNext() {
        return !this.completed.get() || !this.queue.isEmpty();
    }

    public BytesSupplier next(long timeout, TimeUnit unit) throws InterruptedException {
        BytesSupplier data = this.queue.poll(timeout, unit);
        if (data == null) {
            throw new IllegalStateException("Read chunk timeout.");
        }
        return data;
    }

    public byte[] nextChunk(long timeout, TimeUnit unit) throws InterruptedException {
        return this.next(timeout, unit).getAsBytes();
    }

    public BytesSupplier poll() {
        return this.queue.poll();
    }

    public byte[] pollChunk() {
        BytesSupplier data = this.poll();
        return data == null ? null : data.getAsBytes();
    }

    @Override
    public byte[] getAsBytes() {
        byte[] byArray;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            while (this.hasNext()) {
                bos.write(this.nextChunk(1L, TimeUnit.MINUTES));
            }
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | InterruptedException e) {
                throw new AssertionError("Failed to read BytesSupplier", e);
            }
        }
        bos.close();
        return byArray;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.getAsBytes());
    }
}

