/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.inference.streaming;

import ai.djl.ndarray.BytesSupplier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class IteratorBytesSupplier
implements BytesSupplier,
Iterator<byte[]> {
    private Iterator<BytesSupplier> sources;

    public IteratorBytesSupplier(Iterator<BytesSupplier> sources) {
        this.sources = sources;
    }

    @Override
    public boolean hasNext() {
        return this.sources.hasNext();
    }

    @Override
    public byte[] next() {
        return this.sources.next().getAsBytes();
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.getAsBytes());
    }

    @Override
    public byte[] getAsBytes() {
        byte[] byArray;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            while (this.hasNext()) {
                bos.write(this.next());
            }
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new AssertionError("Failed to read BytesSupplier", e);
            }
        }
        bos.close();
        return byArray;
    }
}

