/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.tasks;

import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.MLTask;
import org.opensearch.ml.common.MLTaskState;
import org.opensearch.ml.common.MLTaskType;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.connector.ConnectorAction;
import org.opensearch.ml.common.dataset.MLInputDataset;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.exception.MLValidationException;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensorOutput;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.MLTaskResponse;
import org.opensearch.ml.common.transport.task.MLTaskGetRequest;
import org.opensearch.ml.common.transport.task.MLTaskGetResponse;
import org.opensearch.ml.engine.MLEngine;
import org.opensearch.ml.engine.MLEngineClassLoader;
import org.opensearch.ml.engine.algorithms.remote.ConnectorUtils;
import org.opensearch.ml.engine.algorithms.remote.RemoteConnectorExecutor;
import org.opensearch.ml.engine.encryptor.EncryptorImpl;
import org.opensearch.ml.engine.indices.MLIndicesHandler;
import org.opensearch.ml.engine.utils.S3Utils;
import org.opensearch.ml.helper.ConnectorAccessControlHelper;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.task.MLTaskManager;
import org.opensearch.ml.utils.MLExceptionUtils;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.GetDataObjectResponse;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.script.ScriptService;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.S3Exception;

public class GetTaskTransportAction
extends HandledTransportAction<ActionRequest, MLTaskGetResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(GetTaskTransportAction.class);
    Client client;
    SdkClient sdkClient;
    NamedXContentRegistry xContentRegistry;
    ClusterService clusterService;
    ScriptService scriptService;
    ConnectorAccessControlHelper connectorAccessControlHelper;
    ModelAccessControlHelper modelAccessControlHelper;
    EncryptorImpl encryptor;
    MLModelManager mlModelManager;
    MLTaskManager mlTaskManager;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    volatile List<String> remoteJobStatusFields;
    volatile Pattern remoteJobCompletedStatusRegexPattern;
    volatile Pattern remoteJobCancelledStatusRegexPattern;
    volatile Pattern remoteJobCancellingStatusRegexPattern;
    volatile Pattern remoteJobExpiredStatusRegexPattern;
    volatile Pattern remoteJobFailedStatusRegexPattern;
    private final MLEngine mlEngine;

    @Inject
    public GetTaskTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, NamedXContentRegistry xContentRegistry, ClusterService clusterService, ScriptService scriptService, ConnectorAccessControlHelper connectorAccessControlHelper, ModelAccessControlHelper modelAccessControlHelper, EncryptorImpl encryptor, MLTaskManager mlTaskManager, MLModelManager mlModelManager, MLFeatureEnabledSetting mlFeatureEnabledSetting, Settings settings, MLEngine mlEngine) {
        super("cluster:admin/opensearch/ml/tasks/get", transportService, actionFilters, MLTaskGetRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.scriptService = scriptService;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.encryptor = encryptor;
        this.mlTaskManager = mlTaskManager;
        this.mlModelManager = mlModelManager;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.mlEngine = mlEngine;
        this.remoteJobStatusFields = (List)MLCommonsSettings.ML_COMMONS_REMOTE_JOB_STATUS_FIELD.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_REMOTE_JOB_STATUS_FIELD, it -> {
            this.remoteJobStatusFields = it;
        });
        this.initializeRegexPattern((Setting<String>)MLCommonsSettings.ML_COMMONS_REMOTE_JOB_STATUS_COMPLETED_REGEX, settings, clusterService, regex -> {
            this.remoteJobCompletedStatusRegexPattern = Pattern.compile(regex, 2);
        });
        this.initializeRegexPattern((Setting<String>)MLCommonsSettings.ML_COMMONS_REMOTE_JOB_STATUS_CANCELLED_REGEX, settings, clusterService, regex -> {
            this.remoteJobCancelledStatusRegexPattern = Pattern.compile(regex, 2);
        });
        this.initializeRegexPattern((Setting<String>)MLCommonsSettings.ML_COMMONS_REMOTE_JOB_STATUS_CANCELLING_REGEX, settings, clusterService, regex -> {
            this.remoteJobCancellingStatusRegexPattern = Pattern.compile(regex, 2);
        });
        this.initializeRegexPattern((Setting<String>)MLCommonsSettings.ML_COMMONS_REMOTE_JOB_STATUS_EXPIRED_REGEX, settings, clusterService, regex -> {
            this.remoteJobExpiredStatusRegexPattern = Pattern.compile(regex, 2);
        });
        this.initializeRegexPattern((Setting<String>)MLCommonsSettings.ML_COMMONS_REMOTE_JOB_STATUS_FAILED_REGEX, settings, clusterService, regex -> {
            this.remoteJobFailedStatusRegexPattern = Pattern.compile(regex, 2);
        });
    }

    private void initializeRegexPattern(Setting<String> setting, Settings settings, ClusterService clusterService, Consumer<String> patternInitializer) {
        String regex = (String)setting.get(settings);
        patternInitializer.accept(regex);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(setting, it -> patternInitializer.accept((String)it));
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLTaskGetResponse> actionListener) {
        MLTaskGetRequest mlTaskGetRequest = MLTaskGetRequest.fromActionRequest((ActionRequest)request);
        String taskId = mlTaskGetRequest.getTaskId();
        Boolean isUserInitiatedGetTaskRequest = mlTaskGetRequest.isUserInitiatedGetTaskRequest();
        String tenantId = mlTaskGetRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, tenantId, actionListener)) {
            return;
        }
        FetchSourceContext fetchSourceContext = new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
        GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-task")).id(taskId)).tenantId(tenantId)).fetchSourceContext(fetchSourceContext).build();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.sdkClient.getDataObjectAsync(getDataObjectRequest).whenComplete((r, throwable) -> {
                context.restore();
                this.handleAsyncResponse((GetDataObjectResponse)r, (Throwable)throwable, taskId, isUserInitiatedGetTaskRequest, tenantId, actionListener);
            });
        }
        catch (Exception e) {
            log.error("Failed to get ML task {}", (Object)taskId, (Object)e);
            actionListener.onFailure(e);
        }
    }

    private void handleAsyncResponse(GetDataObjectResponse response, Throwable throwable, String taskId, Boolean isUserInitiatedGetTaskRequest, String tenantId, ActionListener<MLTaskGetResponse> actionListener) {
        log.debug("Completed Get task Request, id:{}", (Object)taskId);
        if (throwable != null) {
            this.handleThrowable(throwable, taskId, actionListener);
            return;
        }
        this.processResponse(response, taskId, isUserInitiatedGetTaskRequest, tenantId, actionListener);
    }

    private void handleThrowable(Throwable throwable, String taskId, ActionListener<MLTaskGetResponse> actionListener) {
        Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
        if (ExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
            log.error("Failed to get task index", (Throwable)cause);
            actionListener.onFailure((Exception)new OpenSearchStatusException("Failed to find task", RestStatus.NOT_FOUND, new Object[0]));
        } else {
            log.error("Failed to get ML task {}", (Object)taskId, (Object)cause);
            actionListener.onFailure(cause);
        }
    }

    private void processResponse(GetDataObjectResponse response, String taskId, Boolean isUserInitiatedGetTaskRequest, String tenantId, ActionListener<MLTaskGetResponse> actionListener) {
        try {
            GetResponse gr = response.getResponse();
            if (gr == null || !gr.isExists()) {
                actionListener.onFailure((Exception)new OpenSearchStatusException("Failed to find task", RestStatus.NOT_FOUND, new Object[0]));
                return;
            }
            this.parseAndHandleTask(gr, taskId, isUserInitiatedGetTaskRequest, tenantId, actionListener);
        }
        catch (Exception e) {
            log.error("Failed to parse GetDataObjectResponse for task {}", (Object)taskId, (Object)e);
            actionListener.onFailure(e);
        }
    }

    private void parseAndHandleTask(GetResponse gr, String taskId, Boolean isUserInitiatedGetTaskRequest, String tenantId, ActionListener<MLTaskGetResponse> actionListener) {
        try (XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, gr.getSourceAsString());){
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            MLTask mlTask = MLTask.parse((XContentParser)parser);
            if (!TenantAwareHelper.validateTenantResource(this.mlFeatureEnabledSetting, tenantId, mlTask.getTenantId(), actionListener)) {
                return;
            }
            if (mlTask.getTaskType() == MLTaskType.BATCH_PREDICTION && !this.mlFeatureEnabledSetting.isOfflineBatchInferenceEnabled().booleanValue()) {
                throw new IllegalStateException("Offline Batch Inference is currently disabled. To enable it, update the setting \"plugins.ml_commons.offline_batch_inference_enabled\" to true.");
            }
            if (mlTask.getTaskType() == MLTaskType.BATCH_PREDICTION && mlTask.getFunctionName() == FunctionName.REMOTE) {
                this.processRemoteBatchPrediction(mlTask, taskId, isUserInitiatedGetTaskRequest, tenantId, actionListener);
            } else {
                actionListener.onResponse((Object)MLTaskGetResponse.builder().mlTask(mlTask).build());
            }
        }
        catch (Exception e) {
            log.error("Failed to parse ML task {}", (Object)taskId, (Object)e);
            actionListener.onFailure(e);
        }
    }

    private void processRemoteBatchPrediction(MLTask mlTask, String taskId, Boolean isUserInitiatedGetTaskRequest, String tenantId, ActionListener<MLTaskGetResponse> actionListener) {
        Map remoteJob = mlTask.getRemoteJob();
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (Map.Entry entry : remoteJob.entrySet()) {
            if (entry.getValue() instanceof String) {
                parameters.put((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            log.debug("Value for key {} is not a String", entry.getKey());
        }
        parameters.computeIfAbsent("TransformJobName", key -> Optional.ofNullable((String)parameters.get("TransformJobArn")).map(jobArn -> jobArn.substring(jobArn.lastIndexOf("/") + 1)).orElse(null));
        RemoteInferenceInputDataSet inferenceInputDataSet = new RemoteInferenceInputDataSet(parameters, ConnectorAction.ActionType.BATCH_PREDICT_STATUS, null);
        MLInput mlInput = MLInput.builder().algorithm(FunctionName.REMOTE).inputDataset((MLInputDataset)inferenceInputDataSet).build();
        String modelId = mlTask.getModelId();
        User user = RestActionUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener getModelListener = ActionListener.wrap(model -> this.modelAccessControlHelper.validateModelGroupAccess(user, this.mlFeatureEnabledSetting, tenantId, model.getModelGroupId(), "cluster:admin/opensearch/ml/tasks/get", this.client, this.sdkClient, (ActionListener<Boolean>)ActionListener.wrap(access -> {
                if (!access.booleanValue()) {
                    actionListener.onFailure((Exception)new MLValidationException("You don't have permission to access this batch job"));
                } else if (model.getConnector() != null) {
                    Connector connector2 = model.getConnector();
                    this.executeConnector(connector2, mlInput, taskId, isUserInitiatedGetTaskRequest, mlTask, remoteJob, actionListener);
                } else if (MLIndicesHandler.doesMultiTenantIndexExist((ClusterService)this.clusterService, (boolean)this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), (String)".plugins-ml-connector")) {
                    ActionListener listener = ActionListener.wrap(connector -> this.executeConnector((Connector)connector, mlInput, taskId, isUserInitiatedGetTaskRequest, mlTask, remoteJob, actionListener), e -> {
                        log.error("Failed to get connector {}", (Object)model.getConnectorId(), e);
                        actionListener.onFailure(e);
                    });
                    try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                        this.connectorAccessControlHelper.getConnector(this.client, model.getConnectorId(), (ActionListener<Connector>)ActionListener.runBefore((ActionListener)listener, () -> ((ThreadContext.StoredContext)threadContext).restore()));
                    }
                } else {
                    actionListener.onFailure((Exception)new ResourceNotFoundException("Can't find connector " + model.getConnectorId(), new Object[0]));
                }
            }, e -> {
                log.error("Failed to validate Access for Model Group {}", (Object)model.getModelGroupId(), e);
                actionListener.onFailure(e);
            })), e -> {
                log.error("Failed to retrieve the ML model for the given task ID", (Throwable)e);
                actionListener.onFailure((Exception)new OpenSearchStatusException("Failed to retrieve the ML model for the given task ID", RestStatus.NOT_FOUND, new Object[0]));
            });
            this.mlModelManager.getModel(modelId, null, null, (ActionListener<MLModel>)ActionListener.runBefore((ActionListener)getModelListener, () -> ((ThreadContext.StoredContext)context).restore()));
        }
        catch (Exception e2) {
            log.error("Unable to fetch status for ml task ", (Throwable)e2);
            throw new OpenSearchException("Unable to fetch status for ml task " + e2.getMessage(), new Object[0]);
        }
    }

    private void executeConnector(Connector connector, MLInput mlInput, String taskId, Boolean isUserInitiatedGetTaskRequest, MLTask mlTask, Map<String, Object> remoteJob, ActionListener<MLTaskGetResponse> actionListener) {
        Optional batchPredictStatusAction = connector.findAction(ConnectorAction.ActionType.BATCH_PREDICT_STATUS.name());
        if (batchPredictStatusAction.isEmpty() || ((ConnectorAction)batchPredictStatusAction.get()).getRequestBody() == null) {
            ConnectorAction connectorAction = ConnectorUtils.createConnectorAction((Connector)connector, (ConnectorAction.ActionType)ConnectorAction.ActionType.BATCH_PREDICT_STATUS);
            connector.addAction(connectorAction);
        }
        Map decryptedCredential = connector.getDecryptedCredential() != null && !connector.getDecryptedCredential().isEmpty() ? connector.getDecryptedCredential() : this.mlEngine.getConnectorCredential(connector);
        RemoteConnectorExecutor connectorExecutor = (RemoteConnectorExecutor)MLEngineClassLoader.initInstance((Object)connector.getProtocol(), (Object)connector, Connector.class);
        connectorExecutor.setScriptService(this.scriptService);
        connectorExecutor.setClusterService(this.clusterService);
        connectorExecutor.setClient(this.client);
        connectorExecutor.setXContentRegistry(this.xContentRegistry);
        connectorExecutor.executeAction(ConnectorAction.ActionType.BATCH_PREDICT_STATUS.name(), mlInput, ActionListener.wrap(taskResponse -> this.processTaskResponse(mlTask, taskId, isUserInitiatedGetTaskRequest, (MLTaskResponse)taskResponse, remoteJob, decryptedCredential, actionListener), e -> {
            if (!isUserInitiatedGetTaskRequest.booleanValue()) {
                HashMap<String, Object> updatedTask = new HashMap<String, Object>();
                Integer numberOfRetries = remoteJob.getOrDefault("num_of_retries", 0);
                numberOfRetries = numberOfRetries + 1;
                remoteJob.put("num_of_retries", numberOfRetries);
                if (numberOfRetries > 10) {
                    log.debug("Limit exceeded trying to reach the task {} . Marking as UNREACHABLE in task index and removing from further execution", (Object)taskId);
                    updatedTask.put("state", MLTaskState.UNREACHABLE);
                    mlTask.setState(MLTaskState.UNREACHABLE);
                    mlTask.setError(e.getMessage());
                    this.updateDLQ(mlTask, decryptedCredential);
                }
                updatedTask.put("remote_job", remoteJob);
                this.mlTaskManager.updateMLTaskDirectly(taskId, updatedTask);
            }
            actionListener.onFailure(e);
        }));
    }

    protected void processTaskResponse(MLTask mlTask, String taskId, Boolean isUserInitiatedGetTaskRequest, MLTaskResponse taskResponse, Map<String, Object> remoteJob, Map<String, String> decryptedCredential, ActionListener<MLTaskGetResponse> actionListener) {
        try {
            ModelTensorOutput tensorOutput = (ModelTensorOutput)taskResponse.getOutput();
            if (tensorOutput != null && tensorOutput.getMlModelOutputs() != null && !tensorOutput.getMlModelOutputs().isEmpty()) {
                ModelTensors modelOutput = (ModelTensors)tensorOutput.getMlModelOutputs().get(0);
                if (modelOutput.getMlModelTensors() != null && !modelOutput.getMlModelTensors().isEmpty()) {
                    Map remoteJobStatus = ((ModelTensor)modelOutput.getMlModelTensors().get(0)).getDataAsMap();
                    if (remoteJobStatus != null) {
                        remoteJob.putAll(remoteJobStatus);
                        HashMap<String, Object> updatedTask = new HashMap<String, Object>();
                        updatedTask.put("remote_job", remoteJob);
                        mlTask.setRemoteJob(remoteJob);
                        for (String statusField : this.remoteJobStatusFields) {
                            String statusValue = String.valueOf(remoteJob.get(statusField));
                            if (!remoteJob.containsKey(statusField)) continue;
                            this.updateTaskState(updatedTask, mlTask, statusValue);
                        }
                        this.mlTaskManager.updateMLTaskDirectly(taskId, updatedTask, (ActionListener<UpdateResponse>)ActionListener.wrap(response -> {
                            if (mlTask.getState().equals((Object)MLTaskState.FAILED) && !isUserInitiatedGetTaskRequest.booleanValue()) {
                                this.updateDLQ(mlTask, decryptedCredential);
                            }
                            actionListener.onResponse((Object)MLTaskGetResponse.builder().mlTask(mlTask).build());
                        }, e -> {
                            MLExceptionUtils.logException("Failed to update task for batch predict model", e, log);
                            actionListener.onFailure(e);
                        }));
                    } else {
                        log.debug("Transform job status is null.");
                        actionListener.onFailure((Exception)new ResourceNotFoundException("Couldn't fetch status of the transform job", new Object[0]));
                    }
                } else {
                    log.debug("ML Model Tensors are null or empty.");
                    actionListener.onFailure((Exception)new ResourceNotFoundException("Couldn't fetch status of the transform job", new Object[0]));
                }
            } else {
                log.debug("ML Model Outputs are null or empty.");
                actionListener.onFailure((Exception)new ResourceNotFoundException("Couldn't fetch status of the transform job", new Object[0]));
            }
        }
        catch (Exception e2) {
            log.error("Unable to fetch status for ml task ", (Throwable)e2);
        }
    }

    @VisibleForTesting
    protected void updateDLQ(MLTask mlTask, Map<String, String> decryptedCredential) {
        Map remoteJob = mlTask.getRemoteJob();
        Map dlq = (Map)remoteJob.get("dlq");
        if (dlq != null && !dlq.isEmpty()) {
            String taskId = mlTask.getTaskId();
            try {
                Map remoteJobDetails = mlTask.getRemoteJob();
                String accessKey = decryptedCredential.get("access_key");
                String secretKey = decryptedCredential.get("secret_key");
                String sessionToken = decryptedCredential.get("session_token");
                String bucketName = (String)dlq.get("bucket");
                String region = (String)dlq.get("region");
                if (bucketName == null || region == null) {
                    log.error("Failed to get the bucket name and region from batch predict request");
                }
                remoteJobDetails.remove("dlq");
                try (S3Client s3Client = S3Utils.initS3Client((String)accessKey, (String)secretKey, (String)sessionToken, (String)region);){
                    String jobName = (String)remoteJobDetails.getOrDefault("TransformJobName", remoteJob.get("job_name"));
                    String s3ObjectKey = "BatchJobFailure_" + jobName;
                    String content = mlTask.getState().equals((Object)MLTaskState.UNREACHABLE) ? String.format("Unable to reach the Job: %s. Error Message: %s", jobName, mlTask.getError()) : remoteJobDetails.toString();
                    S3Utils.putObject((S3Client)s3Client, (String)bucketName, (String)s3ObjectKey, (String)content);
                    log.debug("Task status successfully uploaded to S3 for task ID: {} at {}", (Object)taskId, (Object)Instant.now());
                }
            }
            catch (S3Exception e) {
                log.error("Failed to update task status for task: {}. S3 Exception: {}", (Object)taskId, (Object)e.awsErrorDetails().errorMessage());
            }
            catch (Exception e) {
                log.error("Failed to update task status for task: " + taskId, (Throwable)e);
            }
        }
    }

    private void updateTaskState(Map<String, Object> updatedTask, MLTask mlTask, String statusValue) {
        if (this.matchesPattern(this.remoteJobCancellingStatusRegexPattern, statusValue)) {
            updatedTask.put("state", MLTaskState.CANCELLING);
            mlTask.setState(MLTaskState.CANCELLING);
        } else if (this.matchesPattern(this.remoteJobCancelledStatusRegexPattern, statusValue)) {
            updatedTask.put("state", MLTaskState.CANCELLED);
            mlTask.setState(MLTaskState.CANCELLED);
        } else if (this.matchesPattern(this.remoteJobCompletedStatusRegexPattern, statusValue)) {
            updatedTask.put("state", MLTaskState.COMPLETED);
            mlTask.setState(MLTaskState.COMPLETED);
        } else if (this.matchesPattern(this.remoteJobExpiredStatusRegexPattern, statusValue)) {
            updatedTask.put("state", MLTaskState.EXPIRED);
            mlTask.setState(MLTaskState.EXPIRED);
        } else if (this.matchesPattern(this.remoteJobFailedStatusRegexPattern, statusValue)) {
            updatedTask.put("state", MLTaskState.FAILED);
            mlTask.setState(MLTaskState.FAILED);
        }
    }

    private boolean matchesPattern(Pattern pattern, String input) {
        Matcher matcher = pattern.matcher(input);
        return matcher.find();
    }
}

