/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.jobs;

import java.io.IOException;
import java.time.Instant;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.schedule.Schedule;
import org.opensearch.jobscheduler.spi.schedule.ScheduleParser;
import org.opensearch.ml.jobs.MLJobType;
import org.opensearch.ml.utils.ParseUtils;

public class MLJobParameter
implements ScheduledJobParameter {
    @Generated
    private static final Logger log = LogManager.getLogger(MLJobParameter.class);
    public static final String NAME_FIELD = "name";
    public static final String ENABLED_FILED = "enabled";
    public static final String LAST_UPDATE_TIME_FIELD = "last_update_time";
    public static final String LAST_UPDATE_TIME_FIELD_READABLE = "last_update_time_field";
    public static final String SCHEDULE_FIELD = "schedule";
    public static final String ENABLED_TIME_FILED = "enabled_time";
    public static final String ENABLED_TIME_FILED_READABLE = "enabled_time_field";
    public static final String LOCK_DURATION_SECONDS = "lock_duration_seconds";
    public static final String JITTER = "jitter";
    public static final String TYPE = "type";
    private String jobName;
    private Instant lastUpdateTime;
    private Instant enabledTime;
    private boolean isEnabled;
    private Schedule schedule;
    private Long lockDurationSeconds;
    private Double jitter;
    private MLJobType jobType;

    public MLJobParameter() {
    }

    public MLJobParameter(String name, Schedule schedule, Long lockDurationSeconds, Double jitter, MLJobType jobType, boolean isEnabled) {
        this.jobName = name;
        this.schedule = schedule;
        this.lockDurationSeconds = lockDurationSeconds;
        this.jitter = jitter;
        Instant now = Instant.now();
        this.isEnabled = isEnabled;
        this.enabledTime = now;
        this.lastUpdateTime = now;
        this.jobType = jobType;
    }

    public String getName() {
        return this.jobName;
    }

    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Instant getEnabledTime() {
        return this.enabledTime;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public Long getLockDurationSeconds() {
        return this.lockDurationSeconds;
    }

    public Double getJitter() {
        return this.jitter;
    }

    public static MLJobParameter parse(XContentParser parser) throws IOException {
        MLJobParameter jobParameter = new MLJobParameter();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        block20: while (!parser.nextToken().equals((Object)XContentParser.Token.END_OBJECT)) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    jobParameter.setJobName(parser.text());
                    continue block20;
                }
                case "enabled": {
                    jobParameter.setEnabled(parser.booleanValue());
                    continue block20;
                }
                case "enabled_time": {
                    jobParameter.setEnabledTime(ParseUtils.toInstant(parser));
                    continue block20;
                }
                case "last_update_time": {
                    jobParameter.setLastUpdateTime(ParseUtils.toInstant(parser));
                    continue block20;
                }
                case "schedule": {
                    jobParameter.setSchedule(ScheduleParser.parse((XContentParser)parser));
                    continue block20;
                }
                case "lock_duration_seconds": {
                    jobParameter.setLockDurationSeconds(parser.longValue());
                    continue block20;
                }
                case "jitter": {
                    jobParameter.setJitter(parser.doubleValue());
                    continue block20;
                }
                case "type": {
                    String type = parser.text();
                    jobParameter.setJobType(MLJobType.valueOf(type));
                    continue block20;
                }
            }
            XContentParserUtils.throwUnknownToken((XContentParser.Token)parser.currentToken(), (XContentLocation)parser.getTokenLocation());
        }
        return jobParameter;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME_FIELD, this.jobName).field(ENABLED_FILED, this.isEnabled).field(SCHEDULE_FIELD, (ToXContent)this.schedule);
        if (this.enabledTime != null) {
            builder.timeField(ENABLED_TIME_FILED, ENABLED_TIME_FILED_READABLE, this.enabledTime.toEpochMilli());
        }
        if (this.lastUpdateTime != null) {
            builder.timeField(LAST_UPDATE_TIME_FIELD, LAST_UPDATE_TIME_FIELD_READABLE, this.lastUpdateTime.toEpochMilli());
        }
        if (this.lockDurationSeconds != null) {
            builder.field(LOCK_DURATION_SECONDS, this.lockDurationSeconds);
        }
        if (this.jitter != null) {
            builder.field(JITTER, this.jitter);
        }
        if (this.jobType != null) {
            builder.field(TYPE, this.jobType.toString());
        }
        builder.endObject();
        return builder;
    }

    @Generated
    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Generated
    public void setLastUpdateTime(Instant lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Generated
    public void setEnabledTime(Instant enabledTime) {
        this.enabledTime = enabledTime;
    }

    @Generated
    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Generated
    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    @Generated
    public void setLockDurationSeconds(Long lockDurationSeconds) {
        this.lockDurationSeconds = lockDurationSeconds;
    }

    @Generated
    public void setJitter(Double jitter) {
        this.jitter = jitter;
    }

    @Generated
    public void setJobType(MLJobType jobType) {
        this.jobType = jobType;
    }

    @Generated
    public MLJobType getJobType() {
        return this.jobType;
    }
}

