/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.session.MLCreateSessionAction;
import org.opensearch.ml.common.transport.session.MLCreateSessionInput;
import org.opensearch.ml.common.transport.session.MLCreateSessionRequest;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestMLCreateSessionAction
extends BaseRestHandler {
    private static final String ML_CREATE_SESSION_ACTION = "ml_create_session_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLCreateSessionAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_CREATE_SESSION_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, "/_plugins/_ml/memory_containers/{memory_container_id}/memories/sessions"));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!this.mlFeatureEnabledSetting.isAgenticMemoryEnabled()) {
            throw new OpenSearchStatusException(MLCommonsSettings.ML_COMMONS_AGENTIC_MEMORY_DISABLED_MESSAGE, RestStatus.FORBIDDEN, new Object[0]);
        }
        MLCreateSessionRequest mlCreateSessionRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLCreateSessionAction.INSTANCE, (ActionRequest)mlCreateSessionRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLCreateSessionRequest getRequest(RestRequest request) throws IOException {
        if (!request.hasContent()) {
            throw new IllegalArgumentException("Request body is required");
        }
        String containerId = RestActionUtils.getParameterId(request, "memory_container_id");
        if (containerId == null || containerId.isBlank()) {
            throw new IllegalArgumentException("Memory container ID is required");
        }
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLCreateSessionInput input = MLCreateSessionInput.parse((XContentParser)parser);
        String tenantId = TenantAwareHelper.getTenantID(this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), request);
        input.setTenantId(tenantId);
        input.setMemoryContainerId(containerId);
        return new MLCreateSessionRequest(input);
    }
}

