/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockruntime.model.CitationLocation;
import software.amazon.awssdk.services.bedrockruntime.model.CitationSourceContent;
import software.amazon.awssdk.services.bedrockruntime.model.CitationSourceContentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Citation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Citation> {
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(Citation.getter(Citation::title)).setter(Citation.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<List<CitationSourceContent>> SOURCE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceContent").getter(Citation.getter(Citation::sourceContent)).setter(Citation.setter(Builder::sourceContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceContent").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CitationSourceContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CitationLocation> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("location").getter(Citation.getter(Citation::location)).setter(Citation.setter(Builder::location)).constructor(CitationLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, SOURCE_CONTENT_FIELD, LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Citation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String title;
    private final List<CitationSourceContent> sourceContent;
    private final CitationLocation location;

    private Citation(BuilderImpl builder) {
        this.title = builder.title;
        this.sourceContent = builder.sourceContent;
        this.location = builder.location;
    }

    public final String title() {
        return this.title;
    }

    public final boolean hasSourceContent() {
        return this.sourceContent != null && !(this.sourceContent instanceof SdkAutoConstructList);
    }

    public final List<CitationSourceContent> sourceContent() {
        return this.sourceContent;
    }

    public final CitationLocation location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceContent() ? this.sourceContent() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Citation)) {
            return false;
        }
        Citation other = (Citation)obj;
        return Objects.equals(this.title(), other.title()) && this.hasSourceContent() == other.hasSourceContent() && Objects.equals(this.sourceContent(), other.sourceContent()) && Objects.equals(this.location(), other.location());
    }

    public final String toString() {
        return ToString.builder((String)"Citation").add("Title", (Object)this.title()).add("SourceContent", this.hasSourceContent() ? this.sourceContent() : null).add("Location", (Object)this.location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "sourceContent": {
                return Optional.ofNullable(clazz.cast(this.sourceContent()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("title", TITLE_FIELD);
        map.put("sourceContent", SOURCE_CONTENT_FIELD);
        map.put("location", LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Citation, T> g) {
        return obj -> g.apply((Citation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String title;
        private List<CitationSourceContent> sourceContent = DefaultSdkAutoConstructList.getInstance();
        private CitationLocation location;

        private BuilderImpl() {
        }

        private BuilderImpl(Citation model) {
            this.title(model.title);
            this.sourceContent(model.sourceContent);
            this.location(model.location);
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final List<CitationSourceContent.Builder> getSourceContent() {
            List<CitationSourceContent.Builder> result = CitationSourceContentListCopier.copyToBuilder(this.sourceContent);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceContent(Collection<CitationSourceContent.BuilderImpl> sourceContent) {
            this.sourceContent = CitationSourceContentListCopier.copyFromBuilder(sourceContent);
        }

        @Override
        public final Builder sourceContent(Collection<CitationSourceContent> sourceContent) {
            this.sourceContent = CitationSourceContentListCopier.copy(sourceContent);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceContent(CitationSourceContent ... sourceContent) {
            this.sourceContent(Arrays.asList(sourceContent));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceContent(Consumer<CitationSourceContent.Builder> ... sourceContent) {
            this.sourceContent(Stream.of(sourceContent).map(c -> (CitationSourceContent)((CitationSourceContent.Builder)CitationSourceContent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CitationLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        public final void setLocation(CitationLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(CitationLocation location) {
            this.location = location;
            return this;
        }

        public Citation build() {
            return new Citation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Citation> {
        public Builder title(String var1);

        public Builder sourceContent(Collection<CitationSourceContent> var1);

        public Builder sourceContent(CitationSourceContent ... var1);

        public Builder sourceContent(Consumer<CitationSourceContent.Builder> ... var1);

        public Builder location(CitationLocation var1);

        default public Builder location(Consumer<CitationLocation.Builder> location) {
            return this.location((CitationLocation)((CitationLocation.Builder)CitationLocation.builder().applyMutation(location)).build());
        }
    }
}

