/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningLogicWarning;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningRule;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningRuleListCopier;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningScenario;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningTranslation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailAutomatedReasoningValidFinding
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailAutomatedReasoningValidFinding> {
    private static final SdkField<GuardrailAutomatedReasoningTranslation> TRANSLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("translation").getter(GuardrailAutomatedReasoningValidFinding.getter(GuardrailAutomatedReasoningValidFinding::translation)).setter(GuardrailAutomatedReasoningValidFinding.setter(Builder::translation)).constructor(GuardrailAutomatedReasoningTranslation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("translation").build()}).build();
    private static final SdkField<GuardrailAutomatedReasoningScenario> CLAIMS_TRUE_SCENARIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("claimsTrueScenario").getter(GuardrailAutomatedReasoningValidFinding.getter(GuardrailAutomatedReasoningValidFinding::claimsTrueScenario)).setter(GuardrailAutomatedReasoningValidFinding.setter(Builder::claimsTrueScenario)).constructor(GuardrailAutomatedReasoningScenario::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("claimsTrueScenario").build()}).build();
    private static final SdkField<List<GuardrailAutomatedReasoningRule>> SUPPORTING_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportingRules").getter(GuardrailAutomatedReasoningValidFinding.getter(GuardrailAutomatedReasoningValidFinding::supportingRules)).setter(GuardrailAutomatedReasoningValidFinding.setter(Builder::supportingRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportingRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailAutomatedReasoningRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<GuardrailAutomatedReasoningLogicWarning> LOGIC_WARNING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logicWarning").getter(GuardrailAutomatedReasoningValidFinding.getter(GuardrailAutomatedReasoningValidFinding::logicWarning)).setter(GuardrailAutomatedReasoningValidFinding.setter(Builder::logicWarning)).constructor(GuardrailAutomatedReasoningLogicWarning::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicWarning").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSLATION_FIELD, CLAIMS_TRUE_SCENARIO_FIELD, SUPPORTING_RULES_FIELD, LOGIC_WARNING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GuardrailAutomatedReasoningValidFinding.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final GuardrailAutomatedReasoningTranslation translation;
    private final GuardrailAutomatedReasoningScenario claimsTrueScenario;
    private final List<GuardrailAutomatedReasoningRule> supportingRules;
    private final GuardrailAutomatedReasoningLogicWarning logicWarning;

    private GuardrailAutomatedReasoningValidFinding(BuilderImpl builder) {
        this.translation = builder.translation;
        this.claimsTrueScenario = builder.claimsTrueScenario;
        this.supportingRules = builder.supportingRules;
        this.logicWarning = builder.logicWarning;
    }

    public final GuardrailAutomatedReasoningTranslation translation() {
        return this.translation;
    }

    public final GuardrailAutomatedReasoningScenario claimsTrueScenario() {
        return this.claimsTrueScenario;
    }

    public final boolean hasSupportingRules() {
        return this.supportingRules != null && !(this.supportingRules instanceof SdkAutoConstructList);
    }

    public final List<GuardrailAutomatedReasoningRule> supportingRules() {
        return this.supportingRules;
    }

    public final GuardrailAutomatedReasoningLogicWarning logicWarning() {
        return this.logicWarning;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.translation());
        hashCode = 31 * hashCode + Objects.hashCode(this.claimsTrueScenario());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportingRules() ? this.supportingRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logicWarning());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailAutomatedReasoningValidFinding)) {
            return false;
        }
        GuardrailAutomatedReasoningValidFinding other = (GuardrailAutomatedReasoningValidFinding)obj;
        return Objects.equals(this.translation(), other.translation()) && Objects.equals(this.claimsTrueScenario(), other.claimsTrueScenario()) && this.hasSupportingRules() == other.hasSupportingRules() && Objects.equals(this.supportingRules(), other.supportingRules()) && Objects.equals(this.logicWarning(), other.logicWarning());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailAutomatedReasoningValidFinding").add("Translation", (Object)this.translation()).add("ClaimsTrueScenario", (Object)this.claimsTrueScenario()).add("SupportingRules", this.hasSupportingRules() ? this.supportingRules() : null).add("LogicWarning", (Object)this.logicWarning()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "translation": {
                return Optional.ofNullable(clazz.cast(this.translation()));
            }
            case "claimsTrueScenario": {
                return Optional.ofNullable(clazz.cast(this.claimsTrueScenario()));
            }
            case "supportingRules": {
                return Optional.ofNullable(clazz.cast(this.supportingRules()));
            }
            case "logicWarning": {
                return Optional.ofNullable(clazz.cast(this.logicWarning()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("translation", TRANSLATION_FIELD);
        map.put("claimsTrueScenario", CLAIMS_TRUE_SCENARIO_FIELD);
        map.put("supportingRules", SUPPORTING_RULES_FIELD);
        map.put("logicWarning", LOGIC_WARNING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailAutomatedReasoningValidFinding, T> g) {
        return obj -> g.apply((GuardrailAutomatedReasoningValidFinding)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GuardrailAutomatedReasoningTranslation translation;
        private GuardrailAutomatedReasoningScenario claimsTrueScenario;
        private List<GuardrailAutomatedReasoningRule> supportingRules = DefaultSdkAutoConstructList.getInstance();
        private GuardrailAutomatedReasoningLogicWarning logicWarning;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailAutomatedReasoningValidFinding model) {
            this.translation(model.translation);
            this.claimsTrueScenario(model.claimsTrueScenario);
            this.supportingRules(model.supportingRules);
            this.logicWarning(model.logicWarning);
        }

        public final GuardrailAutomatedReasoningTranslation.Builder getTranslation() {
            return this.translation != null ? this.translation.toBuilder() : null;
        }

        public final void setTranslation(GuardrailAutomatedReasoningTranslation.BuilderImpl translation) {
            this.translation = translation != null ? translation.build() : null;
        }

        @Override
        public final Builder translation(GuardrailAutomatedReasoningTranslation translation) {
            this.translation = translation;
            return this;
        }

        public final GuardrailAutomatedReasoningScenario.Builder getClaimsTrueScenario() {
            return this.claimsTrueScenario != null ? this.claimsTrueScenario.toBuilder() : null;
        }

        public final void setClaimsTrueScenario(GuardrailAutomatedReasoningScenario.BuilderImpl claimsTrueScenario) {
            this.claimsTrueScenario = claimsTrueScenario != null ? claimsTrueScenario.build() : null;
        }

        @Override
        public final Builder claimsTrueScenario(GuardrailAutomatedReasoningScenario claimsTrueScenario) {
            this.claimsTrueScenario = claimsTrueScenario;
            return this;
        }

        public final List<GuardrailAutomatedReasoningRule.Builder> getSupportingRules() {
            List<GuardrailAutomatedReasoningRule.Builder> result = GuardrailAutomatedReasoningRuleListCopier.copyToBuilder(this.supportingRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportingRules(Collection<GuardrailAutomatedReasoningRule.BuilderImpl> supportingRules) {
            this.supportingRules = GuardrailAutomatedReasoningRuleListCopier.copyFromBuilder(supportingRules);
        }

        @Override
        public final Builder supportingRules(Collection<GuardrailAutomatedReasoningRule> supportingRules) {
            this.supportingRules = GuardrailAutomatedReasoningRuleListCopier.copy(supportingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportingRules(GuardrailAutomatedReasoningRule ... supportingRules) {
            this.supportingRules(Arrays.asList(supportingRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportingRules(Consumer<GuardrailAutomatedReasoningRule.Builder> ... supportingRules) {
            this.supportingRules(Stream.of(supportingRules).map(c -> (GuardrailAutomatedReasoningRule)((GuardrailAutomatedReasoningRule.Builder)GuardrailAutomatedReasoningRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final GuardrailAutomatedReasoningLogicWarning.Builder getLogicWarning() {
            return this.logicWarning != null ? this.logicWarning.toBuilder() : null;
        }

        public final void setLogicWarning(GuardrailAutomatedReasoningLogicWarning.BuilderImpl logicWarning) {
            this.logicWarning = logicWarning != null ? logicWarning.build() : null;
        }

        @Override
        public final Builder logicWarning(GuardrailAutomatedReasoningLogicWarning logicWarning) {
            this.logicWarning = logicWarning;
            return this;
        }

        public GuardrailAutomatedReasoningValidFinding build() {
            return new GuardrailAutomatedReasoningValidFinding(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailAutomatedReasoningValidFinding> {
        public Builder translation(GuardrailAutomatedReasoningTranslation var1);

        default public Builder translation(Consumer<GuardrailAutomatedReasoningTranslation.Builder> translation) {
            return this.translation((GuardrailAutomatedReasoningTranslation)((GuardrailAutomatedReasoningTranslation.Builder)GuardrailAutomatedReasoningTranslation.builder().applyMutation(translation)).build());
        }

        public Builder claimsTrueScenario(GuardrailAutomatedReasoningScenario var1);

        default public Builder claimsTrueScenario(Consumer<GuardrailAutomatedReasoningScenario.Builder> claimsTrueScenario) {
            return this.claimsTrueScenario((GuardrailAutomatedReasoningScenario)((GuardrailAutomatedReasoningScenario.Builder)GuardrailAutomatedReasoningScenario.builder().applyMutation(claimsTrueScenario)).build());
        }

        public Builder supportingRules(Collection<GuardrailAutomatedReasoningRule> var1);

        public Builder supportingRules(GuardrailAutomatedReasoningRule ... var1);

        public Builder supportingRules(Consumer<GuardrailAutomatedReasoningRule.Builder> ... var1);

        public Builder logicWarning(GuardrailAutomatedReasoningLogicWarning var1);

        default public Builder logicWarning(Consumer<GuardrailAutomatedReasoningLogicWarning.Builder> logicWarning) {
            return this.logicWarning((GuardrailAutomatedReasoningLogicWarning)((GuardrailAutomatedReasoningLogicWarning.Builder)GuardrailAutomatedReasoningLogicWarning.builder().applyMutation(logicWarning)).build());
        }
    }
}

