/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;
import software.amazon.awssdk.services.bedrockruntime.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockruntime.model.AsyncInvokeSummary;
import software.amazon.awssdk.services.bedrockruntime.model.ListAsyncInvokesRequest;
import software.amazon.awssdk.services.bedrockruntime.model.ListAsyncInvokesResponse;

public class ListAsyncInvokesIterable
implements SdkIterable<ListAsyncInvokesResponse> {
    private final BedrockRuntimeClient client;
    private final ListAsyncInvokesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAsyncInvokesIterable(BedrockRuntimeClient client, ListAsyncInvokesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAsyncInvokesResponseFetcher();
    }

    public Iterator<ListAsyncInvokesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AsyncInvokeSummary> asyncInvokeSummaries() {
        Function<ListAsyncInvokesResponse, Iterator> getIterator = response -> {
            if (response != null && response.asyncInvokeSummaries() != null) {
                return response.asyncInvokeSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAsyncInvokesResponseFetcher
    implements SyncPageFetcher<ListAsyncInvokesResponse> {
        private ListAsyncInvokesResponseFetcher() {
        }

        public boolean hasNextPage(ListAsyncInvokesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAsyncInvokesResponse nextPage(ListAsyncInvokesResponse previousPage) {
            if (previousPage == null) {
                return ListAsyncInvokesIterable.this.client.listAsyncInvokes(ListAsyncInvokesIterable.this.firstRequest);
            }
            return ListAsyncInvokesIterable.this.client.listAsyncInvokes((ListAsyncInvokesRequest)((Object)ListAsyncInvokesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

