/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.memorycontainer;

import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.memorycontainer.MemoryStrategyType;
import org.opensearch.ml.common.utils.StringUtils;

public class MLLongTermMemory
implements ToXContentObject,
Writeable {
    private String memory;
    private MemoryStrategyType strategyType;
    private Map<String, String> namespace;
    private Map<String, String> tags;
    private Instant createdTime;
    private Instant lastUpdatedTime;
    private Object memoryEmbedding;
    private String ownerId;
    private String memoryContainerId;
    private String strategyId;

    public MLLongTermMemory(String memory, MemoryStrategyType strategyType, Map<String, String> namespace, Map<String, String> tags, Instant createdTime, Instant lastUpdatedTime, Object memoryEmbedding, String ownerId, String memoryContainerId, String strategyId) {
        this.memory = memory;
        this.strategyType = strategyType;
        this.namespace = namespace;
        this.tags = tags;
        this.createdTime = createdTime;
        this.lastUpdatedTime = lastUpdatedTime;
        this.memoryEmbedding = memoryEmbedding;
        this.ownerId = ownerId;
        this.memoryContainerId = memoryContainerId;
        this.strategyId = strategyId;
    }

    public MLLongTermMemory(StreamInput in) throws IOException {
        this.memory = in.readString();
        this.strategyType = (MemoryStrategyType)in.readEnum(MemoryStrategyType.class);
        if (in.readBoolean()) {
            this.namespace = in.readMap(StreamInput::readString, StreamInput::readString);
        }
        if (in.readBoolean()) {
            this.tags = in.readMap(StreamInput::readString, StreamInput::readString);
        }
        this.createdTime = in.readInstant();
        this.lastUpdatedTime = in.readInstant();
        this.ownerId = in.readOptionalString();
        this.memoryContainerId = in.readOptionalString();
        this.strategyId = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.memory);
        out.writeEnum((Enum)this.strategyType);
        if (this.namespace != null && !this.namespace.isEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.namespace, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.tags, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        out.writeInstant(this.createdTime);
        out.writeInstant(this.lastUpdatedTime);
        out.writeOptionalString(this.ownerId);
        out.writeOptionalString(this.memoryContainerId);
        out.writeOptionalString(this.strategyId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("memory", this.memory);
        builder.field("strategy_type", this.strategyType.getValue());
        if (this.tags != null && !this.tags.isEmpty()) {
            builder.field("tags", this.tags);
        }
        if (this.namespace != null && !this.namespace.isEmpty()) {
            builder.field("namespace", this.namespace);
            builder.field("namespace_size", this.namespace.size());
        }
        builder.field("created_time", this.createdTime.toEpochMilli());
        builder.field("last_updated_time", this.lastUpdatedTime.toEpochMilli());
        if (this.memoryEmbedding != null) {
            builder.field("memory_embedding", this.memoryEmbedding);
        }
        if (this.ownerId != null) {
            builder.field("owner_id", this.ownerId);
        }
        if (this.strategyId != null) {
            builder.field("strategy_id", this.strategyId);
        }
        builder.endObject();
        return builder;
    }

    public static MLLongTermMemory parse(XContentParser parser) throws IOException {
        String memory = null;
        MemoryStrategyType strategyType = null;
        Map<String, String> namespace = null;
        Map<String, String> tags = null;
        Instant createdTime = null;
        Instant lastUpdatedTime = null;
        Object memoryEmbedding = null;
        String ownerId = null;
        String memoryContainerId = null;
        String strategyId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block24: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "memory": {
                    memory = parser.text();
                    continue block24;
                }
                case "strategy_type": {
                    strategyType = MemoryStrategyType.fromString(parser.text());
                    continue block24;
                }
                case "tags": {
                    tags = StringUtils.getParameterMap(parser.map());
                    continue block24;
                }
                case "namespace": {
                    namespace = StringUtils.getParameterMap(parser.map());
                    continue block24;
                }
                case "created_time": {
                    createdTime = Instant.ofEpochMilli(parser.longValue());
                    continue block24;
                }
                case "last_updated_time": {
                    lastUpdatedTime = Instant.ofEpochMilli(parser.longValue());
                    continue block24;
                }
                case "memory_embedding": {
                    if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                        memoryEmbedding = parser.list();
                        continue block24;
                    }
                    if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                        memoryEmbedding = parser.map();
                        continue block24;
                    }
                    parser.skipChildren();
                    continue block24;
                }
                case "owner_id": {
                    ownerId = parser.text();
                    continue block24;
                }
                case "memory_container_id": {
                    memoryContainerId = parser.text();
                    continue block24;
                }
                case "strategy_id": {
                    strategyId = parser.text();
                    continue block24;
                }
            }
            parser.skipChildren();
        }
        return MLLongTermMemory.builder().memory(memory).strategyType(strategyType).namespace(namespace).tags(tags).createdTime(createdTime).lastUpdatedTime(lastUpdatedTime).memoryEmbedding(memoryEmbedding).ownerId(ownerId).memoryContainerId(memoryContainerId).strategyId(strategyId).build();
    }

    public Map<String, Object> toIndexMap() {
        Map<String, Long> map = Map.of("memory", this.memory, "strategy_type", this.strategyType.getValue(), "created_time", this.createdTime.toEpochMilli(), "last_updated_time", this.lastUpdatedTime.toEpochMilli());
        HashMap<String, Object> result = new HashMap<String, Object>(map);
        if (this.namespace != null && !this.namespace.isEmpty()) {
            result.put("namespace", this.namespace);
            result.put("namespace_size", (Long)this.namespace.size());
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            result.put("tags", this.tags);
        }
        if (this.memoryEmbedding != null) {
            result.put("memory_embedding", (Long)this.memoryEmbedding);
        }
        if (this.ownerId != null) {
            result.put("owner_id", (Long)((Object)this.ownerId));
        }
        if (this.memoryContainerId != null) {
            result.put("memory_container_id", (Long)((Object)this.memoryContainerId));
        }
        if (this.strategyId != null) {
            result.put("strategy_id", this.strategyId);
        }
        return result;
    }

    @Generated
    public static MLLongTermMemoryBuilder builder() {
        return new MLLongTermMemoryBuilder();
    }

    @Generated
    public String getMemory() {
        return this.memory;
    }

    @Generated
    public MemoryStrategyType getStrategyType() {
        return this.strategyType;
    }

    @Generated
    public Map<String, String> getNamespace() {
        return this.namespace;
    }

    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Generated
    public Instant getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    @Generated
    public Object getMemoryEmbedding() {
        return this.memoryEmbedding;
    }

    @Generated
    public String getOwnerId() {
        return this.ownerId;
    }

    @Generated
    public String getMemoryContainerId() {
        return this.memoryContainerId;
    }

    @Generated
    public String getStrategyId() {
        return this.strategyId;
    }

    @Generated
    public void setMemory(String memory) {
        this.memory = memory;
    }

    @Generated
    public void setStrategyType(MemoryStrategyType strategyType) {
        this.strategyType = strategyType;
    }

    @Generated
    public void setNamespace(Map<String, String> namespace) {
        this.namespace = namespace;
    }

    @Generated
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setCreatedTime(Instant createdTime) {
        this.createdTime = createdTime;
    }

    @Generated
    public void setLastUpdatedTime(Instant lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    @Generated
    public void setMemoryEmbedding(Object memoryEmbedding) {
        this.memoryEmbedding = memoryEmbedding;
    }

    @Generated
    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    @Generated
    public void setMemoryContainerId(String memoryContainerId) {
        this.memoryContainerId = memoryContainerId;
    }

    @Generated
    public void setStrategyId(String strategyId) {
        this.strategyId = strategyId;
    }

    @Generated
    public static class MLLongTermMemoryBuilder {
        @Generated
        private String memory;
        @Generated
        private MemoryStrategyType strategyType;
        @Generated
        private Map<String, String> namespace;
        @Generated
        private Map<String, String> tags;
        @Generated
        private Instant createdTime;
        @Generated
        private Instant lastUpdatedTime;
        @Generated
        private Object memoryEmbedding;
        @Generated
        private String ownerId;
        @Generated
        private String memoryContainerId;
        @Generated
        private String strategyId;

        @Generated
        MLLongTermMemoryBuilder() {
        }

        @Generated
        public MLLongTermMemoryBuilder memory(String memory) {
            this.memory = memory;
            return this;
        }

        @Generated
        public MLLongTermMemoryBuilder strategyType(MemoryStrategyType strategyType) {
            this.strategyType = strategyType;
            return this;
        }

        @Generated
        public MLLongTermMemoryBuilder namespace(Map<String, String> namespace) {
            this.namespace = namespace;
            return this;
        }

        @Generated
        public MLLongTermMemoryBuilder tags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        @Generated
        public MLLongTermMemoryBuilder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Generated
        public MLLongTermMemoryBuilder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Generated
        public MLLongTermMemoryBuilder memoryEmbedding(Object memoryEmbedding) {
            this.memoryEmbedding = memoryEmbedding;
            return this;
        }

        @Generated
        public MLLongTermMemoryBuilder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        @Generated
        public MLLongTermMemoryBuilder memoryContainerId(String memoryContainerId) {
            this.memoryContainerId = memoryContainerId;
            return this;
        }

        @Generated
        public MLLongTermMemoryBuilder strategyId(String strategyId) {
            this.strategyId = strategyId;
            return this;
        }

        @Generated
        public MLLongTermMemory build() {
            return new MLLongTermMemory(this.memory, this.strategyType, this.namespace, this.tags, this.createdTime, this.lastUpdatedTime, this.memoryEmbedding, this.ownerId, this.memoryContainerId, this.strategyId);
        }

        @Generated
        public String toString() {
            return "MLLongTermMemory.MLLongTermMemoryBuilder(memory=" + this.memory + ", strategyType=" + String.valueOf((Object)this.strategyType) + ", namespace=" + String.valueOf(this.namespace) + ", tags=" + String.valueOf(this.tags) + ", createdTime=" + String.valueOf(this.createdTime) + ", lastUpdatedTime=" + String.valueOf(this.lastUpdatedTime) + ", memoryEmbedding=" + String.valueOf(this.memoryEmbedding) + ", ownerId=" + this.ownerId + ", memoryContainerId=" + this.memoryContainerId + ", strategyId=" + this.strategyId + ")";
        }
    }
}

