/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class OpenSearchVersionInfo
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, OpenSearchVersionInfo> {
    @Nonnull
    private final String buildDate;
    @Nullable
    private final String buildFlavor;
    @Nonnull
    private final String buildHash;
    private final boolean buildSnapshot;
    @Nonnull
    private final String buildType;
    @Nonnull
    private final String distribution;
    @Nonnull
    private final String luceneVersion;
    @Nonnull
    private final String minimumIndexCompatibilityVersion;
    @Nonnull
    private final String minimumWireCompatibilityVersion;
    @Nonnull
    private final String number;
    public static final JsonpDeserializer<OpenSearchVersionInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OpenSearchVersionInfo::setupOpenSearchVersionInfoDeserializer);

    private OpenSearchVersionInfo(Builder builder) {
        this.buildDate = ApiTypeHelper.requireNonNull(builder.buildDate, this, "buildDate");
        this.buildFlavor = builder.buildFlavor;
        this.buildHash = ApiTypeHelper.requireNonNull(builder.buildHash, this, "buildHash");
        this.buildSnapshot = ApiTypeHelper.requireNonNull(builder.buildSnapshot, this, "buildSnapshot");
        this.buildType = ApiTypeHelper.requireNonNull(builder.buildType, this, "buildType");
        this.distribution = ApiTypeHelper.requireNonNull(builder.distribution, this, "distribution");
        this.luceneVersion = ApiTypeHelper.requireNonNull(builder.luceneVersion, this, "luceneVersion");
        this.minimumIndexCompatibilityVersion = ApiTypeHelper.requireNonNull(builder.minimumIndexCompatibilityVersion, this, "minimumIndexCompatibilityVersion");
        this.minimumWireCompatibilityVersion = ApiTypeHelper.requireNonNull(builder.minimumWireCompatibilityVersion, this, "minimumWireCompatibilityVersion");
        this.number = ApiTypeHelper.requireNonNull(builder.number, this, "number");
    }

    public static OpenSearchVersionInfo of(Function<Builder, ObjectBuilder<OpenSearchVersionInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String buildDate() {
        return this.buildDate;
    }

    @Nullable
    public final String buildFlavor() {
        return this.buildFlavor;
    }

    @Nonnull
    public final String buildHash() {
        return this.buildHash;
    }

    public final boolean buildSnapshot() {
        return this.buildSnapshot;
    }

    @Nonnull
    public final String buildType() {
        return this.buildType;
    }

    @Nonnull
    public final String distribution() {
        return this.distribution;
    }

    @Nonnull
    public final String luceneVersion() {
        return this.luceneVersion;
    }

    @Nonnull
    public final String minimumIndexCompatibilityVersion() {
        return this.minimumIndexCompatibilityVersion;
    }

    @Nonnull
    public final String minimumWireCompatibilityVersion() {
        return this.minimumWireCompatibilityVersion;
    }

    @Nonnull
    public final String number() {
        return this.number;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("build_date");
        generator.write(this.buildDate);
        if (this.buildFlavor != null) {
            generator.writeKey("build_flavor");
            generator.write(this.buildFlavor);
        }
        generator.writeKey("build_hash");
        generator.write(this.buildHash);
        generator.writeKey("build_snapshot");
        generator.write(this.buildSnapshot);
        generator.writeKey("build_type");
        generator.write(this.buildType);
        generator.writeKey("distribution");
        generator.write(this.distribution);
        generator.writeKey("lucene_version");
        generator.write(this.luceneVersion);
        generator.writeKey("minimum_index_compatibility_version");
        generator.write(this.minimumIndexCompatibilityVersion);
        generator.writeKey("minimum_wire_compatibility_version");
        generator.write(this.minimumWireCompatibilityVersion);
        generator.writeKey("number");
        generator.write(this.number);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupOpenSearchVersionInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::buildDate, JsonpDeserializer.stringDeserializer(), "build_date");
        op.add(Builder::buildFlavor, JsonpDeserializer.stringDeserializer(), "build_flavor");
        op.add(Builder::buildHash, JsonpDeserializer.stringDeserializer(), "build_hash");
        op.add(Builder::buildSnapshot, JsonpDeserializer.booleanDeserializer(), "build_snapshot");
        op.add(Builder::buildType, JsonpDeserializer.stringDeserializer(), "build_type");
        op.add(Builder::distribution, JsonpDeserializer.stringDeserializer(), "distribution");
        op.add(Builder::luceneVersion, JsonpDeserializer.stringDeserializer(), "lucene_version");
        op.add(Builder::minimumIndexCompatibilityVersion, JsonpDeserializer.stringDeserializer(), "minimum_index_compatibility_version");
        op.add(Builder::minimumWireCompatibilityVersion, JsonpDeserializer.stringDeserializer(), "minimum_wire_compatibility_version");
        op.add(Builder::number, JsonpDeserializer.stringDeserializer(), "number");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.buildDate.hashCode();
        result = 31 * result + Objects.hashCode(this.buildFlavor);
        result = 31 * result + this.buildHash.hashCode();
        result = 31 * result + Boolean.hashCode(this.buildSnapshot);
        result = 31 * result + this.buildType.hashCode();
        result = 31 * result + this.distribution.hashCode();
        result = 31 * result + this.luceneVersion.hashCode();
        result = 31 * result + this.minimumIndexCompatibilityVersion.hashCode();
        result = 31 * result + this.minimumWireCompatibilityVersion.hashCode();
        result = 31 * result + this.number.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenSearchVersionInfo other = (OpenSearchVersionInfo)o;
        return this.buildDate.equals(other.buildDate) && Objects.equals(this.buildFlavor, other.buildFlavor) && this.buildHash.equals(other.buildHash) && this.buildSnapshot == other.buildSnapshot && this.buildType.equals(other.buildType) && this.distribution.equals(other.distribution) && this.luceneVersion.equals(other.luceneVersion) && this.minimumIndexCompatibilityVersion.equals(other.minimumIndexCompatibilityVersion) && this.minimumWireCompatibilityVersion.equals(other.minimumWireCompatibilityVersion) && this.number.equals(other.number);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, OpenSearchVersionInfo> {
        private String buildDate;
        @Nullable
        private String buildFlavor;
        private String buildHash;
        private Boolean buildSnapshot;
        private String buildType;
        private String distribution;
        private String luceneVersion;
        private String minimumIndexCompatibilityVersion;
        private String minimumWireCompatibilityVersion;
        private String number;

        public Builder() {
        }

        private Builder(OpenSearchVersionInfo o) {
            this.buildDate = o.buildDate;
            this.buildFlavor = o.buildFlavor;
            this.buildHash = o.buildHash;
            this.buildSnapshot = o.buildSnapshot;
            this.buildType = o.buildType;
            this.distribution = o.distribution;
            this.luceneVersion = o.luceneVersion;
            this.minimumIndexCompatibilityVersion = o.minimumIndexCompatibilityVersion;
            this.minimumWireCompatibilityVersion = o.minimumWireCompatibilityVersion;
            this.number = o.number;
        }

        private Builder(Builder o) {
            this.buildDate = o.buildDate;
            this.buildFlavor = o.buildFlavor;
            this.buildHash = o.buildHash;
            this.buildSnapshot = o.buildSnapshot;
            this.buildType = o.buildType;
            this.distribution = o.distribution;
            this.luceneVersion = o.luceneVersion;
            this.minimumIndexCompatibilityVersion = o.minimumIndexCompatibilityVersion;
            this.minimumWireCompatibilityVersion = o.minimumWireCompatibilityVersion;
            this.number = o.number;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder buildDate(String value) {
            this.buildDate = value;
            return this;
        }

        @Nonnull
        public final Builder buildFlavor(@Nullable String value) {
            this.buildFlavor = value;
            return this;
        }

        @Nonnull
        public final Builder buildHash(String value) {
            this.buildHash = value;
            return this;
        }

        @Nonnull
        public final Builder buildSnapshot(boolean value) {
            this.buildSnapshot = value;
            return this;
        }

        @Nonnull
        public final Builder buildType(String value) {
            this.buildType = value;
            return this;
        }

        @Nonnull
        public final Builder distribution(String value) {
            this.distribution = value;
            return this;
        }

        @Nonnull
        public final Builder luceneVersion(String value) {
            this.luceneVersion = value;
            return this;
        }

        @Nonnull
        public final Builder minimumIndexCompatibilityVersion(String value) {
            this.minimumIndexCompatibilityVersion = value;
            return this;
        }

        @Nonnull
        public final Builder minimumWireCompatibilityVersion(String value) {
            this.minimumWireCompatibilityVersion = value;
            return this;
        }

        @Nonnull
        public final Builder number(String value) {
            this.number = value;
            return this;
        }

        @Override
        @Nonnull
        public OpenSearchVersionInfo build() {
            this._checkSingleUse();
            return new OpenSearchVersionInfo(this);
        }
    }
}

