/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.AggregateBase;
import org.opensearch.client.opensearch._types.aggregations.Buckets;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

public abstract class MultiBucketAggregateBase<TBucket>
extends AggregateBase {
    @Nonnull
    private final Buckets<TBucket> buckets;

    protected MultiBucketAggregateBase(AbstractBuilder<TBucket, ?> builder) {
        super(builder);
        this.buckets = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).buckets, this, "buckets");
    }

    @Nonnull
    public final Buckets<TBucket> buckets() {
        return this.buckets;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("buckets");
        this.buckets.serialize(generator, mapper);
    }

    protected static <TBucket, BuilderT extends AbstractBuilder<TBucket, BuilderT>> void setupMultiBucketAggregateBaseDeserializer(ObjectDeserializer<BuilderT> op, JsonpDeserializer<TBucket> tBucketDeserializer) {
        MultiBucketAggregateBase.setupAggregateBaseDeserializer(op);
        op.add(AbstractBuilder::buckets, Buckets.createBucketsDeserializer(tBucketDeserializer), "buckets");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.buckets.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiBucketAggregateBase other = (MultiBucketAggregateBase)o;
        return this.buckets.equals(other.buckets);
    }

    public static abstract class AbstractBuilder<TBucket, BuilderT extends AbstractBuilder<TBucket, BuilderT>>
    extends AggregateBase.AbstractBuilder<BuilderT> {
        private Buckets<TBucket> buckets;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(MultiBucketAggregateBase<TBucket> o) {
            super(o);
            this.buckets = ((MultiBucketAggregateBase)o).buckets;
        }

        protected AbstractBuilder(AbstractBuilder<TBucket, BuilderT> o) {
            super(o);
            this.buckets = o.buckets;
        }

        @Nonnull
        public final BuilderT buckets(Buckets<TBucket> value) {
            this.buckets = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT buckets(Function<Buckets.Builder<TBucket>, ObjectBuilder<Buckets<TBucket>>> fn) {
            return this.buckets(fn.apply(new Buckets.Builder()).build());
        }
    }
}

