/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.indices.IndexTemplateDataStreamConfiguration;
import org.opensearch.client.opensearch.indices.SimulateIndexTemplateResponse;
import org.opensearch.client.opensearch.indices.put_index_template.IndexTemplateMapping;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class SimulateIndexTemplateRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, SimulateIndexTemplateRequest> {
    @Nullable
    private final Boolean allowAutoCreate;
    @Nullable
    private final Time clusterManagerTimeout;
    @Nonnull
    private final List<String> composedOf;
    @Nullable
    private final IndexTemplateDataStreamConfiguration dataStream;
    @Nonnull
    private final List<String> indexPatterns;
    @Deprecated
    @Nullable
    private final Time masterTimeout;
    @Nonnull
    private final Map<String, JsonData> meta;
    @Nonnull
    private final String name;
    @Nullable
    private final Integer priority;
    @Nullable
    private final IndexTemplateMapping template;
    @Nullable
    private final Long version;
    public static final JsonpDeserializer<SimulateIndexTemplateRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SimulateIndexTemplateRequest::setupSimulateIndexTemplateRequestDeserializer);
    public static final Endpoint<SimulateIndexTemplateRequest, SimulateIndexTemplateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SimulateIndexTemplateRequest, SimulateIndexTemplateResponse>(request -> "POST", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_index_template/_simulate_index/");
        SimpleEndpoint.pathEncode(request.name, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, SimulateIndexTemplateResponse._DESERIALIZER);

    private SimulateIndexTemplateRequest(Builder builder) {
        super(builder);
        this.allowAutoCreate = builder.allowAutoCreate;
        this.clusterManagerTimeout = builder.clusterManagerTimeout;
        this.composedOf = ApiTypeHelper.unmodifiable(builder.composedOf);
        this.dataStream = builder.dataStream;
        this.indexPatterns = ApiTypeHelper.unmodifiable(builder.indexPatterns);
        this.masterTimeout = builder.masterTimeout;
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.priority = builder.priority;
        this.template = builder.template;
        this.version = builder.version;
    }

    public static SimulateIndexTemplateRequest of(Function<Builder, ObjectBuilder<SimulateIndexTemplateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowAutoCreate() {
        return this.allowAutoCreate;
    }

    @Nullable
    public final Time clusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    @Nonnull
    public final List<String> composedOf() {
        return this.composedOf;
    }

    @Nullable
    public final IndexTemplateDataStreamConfiguration dataStream() {
        return this.dataStream;
    }

    @Nonnull
    public final List<String> indexPatterns() {
        return this.indexPatterns;
    }

    @Deprecated
    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nonnull
    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nonnull
    public final String name() {
        return this.name;
    }

    @Nullable
    public final Integer priority() {
        return this.priority;
    }

    @Nullable
    public final IndexTemplateMapping template() {
        return this.template;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allowAutoCreate != null) {
            generator.writeKey("allow_auto_create");
            generator.write(this.allowAutoCreate.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.composedOf)) {
            generator.writeKey("composed_of");
            generator.writeStartArray();
            for (String string : this.composedOf) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.dataStream != null) {
            generator.writeKey("data_stream");
            this.dataStream.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.indexPatterns)) {
            generator.writeKey("index_patterns");
            generator.writeStartArray();
            for (String string : this.indexPatterns) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry entry : this.meta.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.priority != null) {
            generator.writeKey("priority");
            generator.write(this.priority.intValue());
        }
        if (this.template != null) {
            generator.writeKey("template");
            this.template.serialize(generator, mapper);
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSimulateIndexTemplateRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allowAutoCreate, JsonpDeserializer.booleanDeserializer(), "allow_auto_create");
        op.add(Builder::composedOf, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "composed_of");
        op.add(Builder::dataStream, IndexTemplateDataStreamConfiguration._DESERIALIZER, "data_stream");
        op.add(Builder::indexPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index_patterns");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");
        op.add(Builder::priority, JsonpDeserializer.integerDeserializer(), "priority");
        op.add(Builder::template, IndexTemplateMapping._DESERIALIZER, "template");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.clusterManagerTimeout != null) {
            params.put("cluster_manager_timeout", this.clusterManagerTimeout._toJsonString());
        }
        if (this.masterTimeout != null) {
            params.put("master_timeout", this.masterTimeout._toJsonString());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.allowAutoCreate);
        result = 31 * result + Objects.hashCode(this.clusterManagerTimeout);
        result = 31 * result + Objects.hashCode(this.composedOf);
        result = 31 * result + Objects.hashCode(this.dataStream);
        result = 31 * result + Objects.hashCode(this.indexPatterns);
        result = 31 * result + Objects.hashCode(this.masterTimeout);
        result = 31 * result + Objects.hashCode(this.meta);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Objects.hashCode(this.priority);
        result = 31 * result + Objects.hashCode(this.template);
        result = 31 * result + Objects.hashCode(this.version);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimulateIndexTemplateRequest other = (SimulateIndexTemplateRequest)o;
        return Objects.equals(this.allowAutoCreate, other.allowAutoCreate) && Objects.equals(this.clusterManagerTimeout, other.clusterManagerTimeout) && Objects.equals(this.composedOf, other.composedOf) && Objects.equals(this.dataStream, other.dataStream) && Objects.equals(this.indexPatterns, other.indexPatterns) && Objects.equals(this.masterTimeout, other.masterTimeout) && Objects.equals(this.meta, other.meta) && this.name.equals(other.name) && Objects.equals(this.priority, other.priority) && Objects.equals(this.template, other.template) && Objects.equals(this.version, other.version);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, SimulateIndexTemplateRequest> {
        @Nullable
        private Boolean allowAutoCreate;
        @Nullable
        private Time clusterManagerTimeout;
        @Nullable
        private List<String> composedOf;
        @Nullable
        private IndexTemplateDataStreamConfiguration dataStream;
        @Nullable
        private List<String> indexPatterns;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Map<String, JsonData> meta;
        private String name;
        @Nullable
        private Integer priority;
        @Nullable
        private IndexTemplateMapping template;
        @Nullable
        private Long version;

        public Builder() {
        }

        private Builder(SimulateIndexTemplateRequest o) {
            super(o);
            this.allowAutoCreate = o.allowAutoCreate;
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.composedOf = Builder._listCopy(o.composedOf);
            this.dataStream = o.dataStream;
            this.indexPatterns = Builder._listCopy(o.indexPatterns);
            this.masterTimeout = o.masterTimeout;
            this.meta = Builder._mapCopy(o.meta);
            this.name = o.name;
            this.priority = o.priority;
            this.template = o.template;
            this.version = o.version;
        }

        private Builder(Builder o) {
            super(o);
            this.allowAutoCreate = o.allowAutoCreate;
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.composedOf = Builder._listCopy(o.composedOf);
            this.dataStream = o.dataStream;
            this.indexPatterns = Builder._listCopy(o.indexPatterns);
            this.masterTimeout = o.masterTimeout;
            this.meta = Builder._mapCopy(o.meta);
            this.name = o.name;
            this.priority = o.priority;
            this.template = o.template;
            this.version = o.version;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder allowAutoCreate(@Nullable Boolean value) {
            this.allowAutoCreate = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(@Nullable Time value) {
            this.clusterManagerTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.clusterManagerTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder composedOf(List<String> list) {
            this.composedOf = Builder._listAddAll(this.composedOf, list);
            return this;
        }

        @Nonnull
        public final Builder composedOf(String value, String ... values) {
            this.composedOf = Builder._listAdd(this.composedOf, value, values);
            return this;
        }

        @Nonnull
        public final Builder dataStream(@Nullable IndexTemplateDataStreamConfiguration value) {
            this.dataStream = value;
            return this;
        }

        @Nonnull
        public final Builder dataStream(Function<IndexTemplateDataStreamConfiguration.Builder, ObjectBuilder<IndexTemplateDataStreamConfiguration>> fn) {
            return this.dataStream(fn.apply(new IndexTemplateDataStreamConfiguration.Builder()).build());
        }

        @Nonnull
        public final Builder indexPatterns(List<String> list) {
            this.indexPatterns = Builder._listAddAll(this.indexPatterns, list);
            return this;
        }

        @Nonnull
        public final Builder indexPatterns(String value, String ... values) {
            this.indexPatterns = Builder._listAdd(this.indexPatterns, value, values);
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        @Nonnull
        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        @Nonnull
        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder priority(@Nullable Integer value) {
            this.priority = value;
            return this;
        }

        @Nonnull
        public final Builder template(@Nullable IndexTemplateMapping value) {
            this.template = value;
            return this;
        }

        @Nonnull
        public final Builder template(Function<IndexTemplateMapping.Builder, ObjectBuilder<IndexTemplateMapping>> fn) {
            return this.template(fn.apply(new IndexTemplateMapping.Builder()).build());
        }

        @Nonnull
        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Override
        @Nonnull
        public SimulateIndexTemplateRequest build() {
            this._checkSingleUse();
            return new SimulateIndexTemplateRequest(this);
        }
    }
}

