/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.nodes.stats.IoStatDevice;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IoStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, IoStats> {
    @Nonnull
    private final List<IoStatDevice> devices;
    @Nullable
    private final IoStatDevice total;
    public static final JsonpDeserializer<IoStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IoStats::setupIoStatsDeserializer);

    private IoStats(Builder builder) {
        this.devices = ApiTypeHelper.unmodifiable(builder.devices);
        this.total = builder.total;
    }

    public static IoStats of(Function<Builder, ObjectBuilder<IoStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<IoStatDevice> devices() {
        return this.devices;
    }

    @Nullable
    public final IoStatDevice total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.devices)) {
            generator.writeKey("devices");
            generator.writeStartArray();
            for (IoStatDevice item0 : this.devices) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.total != null) {
            generator.writeKey("total");
            this.total.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIoStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::devices, JsonpDeserializer.arrayDeserializer(IoStatDevice._DESERIALIZER), "devices");
        op.add(Builder::total, IoStatDevice._DESERIALIZER, "total");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.devices);
        result = 31 * result + Objects.hashCode(this.total);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoStats other = (IoStats)o;
        return Objects.equals(this.devices, other.devices) && Objects.equals(this.total, other.total);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, IoStats> {
        @Nullable
        private List<IoStatDevice> devices;
        @Nullable
        private IoStatDevice total;

        public Builder() {
        }

        private Builder(IoStats o) {
            this.devices = Builder._listCopy(o.devices);
            this.total = o.total;
        }

        private Builder(Builder o) {
            this.devices = Builder._listCopy(o.devices);
            this.total = o.total;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder devices(List<IoStatDevice> list) {
            this.devices = Builder._listAddAll(this.devices, list);
            return this;
        }

        @Nonnull
        public final Builder devices(IoStatDevice value, IoStatDevice ... values) {
            this.devices = Builder._listAdd(this.devices, value, values);
            return this;
        }

        @Nonnull
        public final Builder devices(Function<IoStatDevice.Builder, ObjectBuilder<IoStatDevice>> fn) {
            return this.devices(fn.apply(new IoStatDevice.Builder()).build(), new IoStatDevice[0]);
        }

        @Nonnull
        public final Builder total(@Nullable IoStatDevice value) {
            this.total = value;
            return this;
        }

        @Nonnull
        public final Builder total(Function<IoStatDevice.Builder, ObjectBuilder<IoStatDevice>> fn) {
            return this.total(fn.apply(new IoStatDevice.Builder()).build());
        }

        @Override
        @Nonnull
        public IoStats build() {
            this._checkSingleUse();
            return new IoStats(this);
        }
    }
}

