/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.observability.metrics;

import java.time.Clock;
import java.util.concurrent.ConcurrentSkipListMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.observability.metrics.Counter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB%\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u000e\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002J\b\u0010\u0014\u001a\u00020\rH\u0002J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002H\u0002J\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002H\u0002J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/opensearch/observability/metrics/RollingCounter;", "Lorg/opensearch/observability/metrics/Counter;", "", "window", "interval", "clock", "Ljava/time/Clock;", "<init>", "(JJLjava/time/Clock;)V", "capacity", "timeToCountMap", "Ljava/util/concurrent/ConcurrentSkipListMap;", "increment", "", "add", "n", "value", "getValue", "()Ljava/lang/Long;", "key", "trim", "getKey", "millis", "getPreKey", "size", "", "reset", "Companion", "opensearch-observability"})
public final class RollingCounter
implements Counter<Long> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long window;
    private final long interval;
    @NotNull
    private final Clock clock;
    private final long capacity;
    @NotNull
    private final ConcurrentSkipListMap<Long, Long> timeToCountMap;
    private static final long METRICS_ROLLING_WINDOW_VALUE = 3600L;
    private static final long METRICS_ROLLING_INTERVAL_VALUE = 60L;
    private static final int MILLIS_MULTIPLIER = 1000;

    public RollingCounter(long window, long interval, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.window = window;
        this.interval = interval;
        this.clock = clock;
        this.capacity = this.window / this.interval * (long)2;
        this.timeToCountMap = new ConcurrentSkipListMap();
    }

    public /* synthetic */ RollingCounter(long l, long l2, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 3600L;
        }
        if ((n & 2) != 0) {
            l2 = 60L;
        }
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemDefaultZone();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemDefaultZone(...)");
            clock = clock2;
        }
        this(l, l2, clock);
    }

    @Override
    public void increment() {
        this.add(1L);
    }

    @Override
    public void add(long n) {
        this.trim();
        this.timeToCountMap.compute(this.getKey(this.clock.millis()), (arg_0, arg_1) -> RollingCounter.add$lambda$1((arg_0, arg_1) -> RollingCounter.add$lambda$0(n, arg_0, arg_1), arg_0, arg_1));
    }

    @Override
    @NotNull
    public Long getValue() {
        return this.getValue(this.getPreKey(this.clock.millis()));
    }

    public final long getValue(long key) {
        Long l = this.timeToCountMap.get(key);
        if (l == null) {
            return 0L;
        }
        return l;
    }

    private final void trim() {
        if ((long)this.timeToCountMap.size() > this.capacity) {
            this.timeToCountMap.headMap((Object)this.getKey(this.clock.millis() - this.window * (long)1000)).clear();
        }
    }

    private final long getKey(long millis) {
        return millis / (long)1000 / this.interval;
    }

    private final long getPreKey(long millis) {
        return this.getKey(millis) - 1L;
    }

    public final int size() {
        return this.timeToCountMap.size();
    }

    @Override
    public void reset() {
        this.timeToCountMap.clear();
    }

    private static final Long add$lambda$0(long $n, Long l, Long v) {
        Long l2 = v;
        return l2 == null ? Long.valueOf($n) : Long.valueOf(l2 + $n);
    }

    private static final Long add$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Long)$tmp0.invoke(p0, p1);
    }

    public RollingCounter() {
        this(0L, 0L, null, 7, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/opensearch/observability/metrics/RollingCounter$Companion;", "", "<init>", "()V", "METRICS_ROLLING_WINDOW_VALUE", "", "METRICS_ROLLING_INTERVAL_VALUE", "MILLIS_MULTIPLIER", "", "opensearch-observability"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

