/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.crypto.Agreement;
import org.bouncycastle.crypto.AgreementFactory;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.KDFCalculator;
import org.bouncycastle.crypto.KDFOperatorFactory;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHPublicKey;
import org.bouncycastle.crypto.fips.FipsDH;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.jcajce.AgreedKeyWithMacKey;
import org.bouncycastle.jcajce.provider.DESUtil;
import org.bouncycastle.jcajce.provider.KeyIvSizeProvider;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.PrivateKeyConverter;
import org.bouncycastle.jcajce.provider.ProvDHPublicKey;
import org.bouncycastle.jcajce.provider.PublicKeyConverter;
import org.bouncycastle.jcajce.spec.DHUParameterSpec;
import org.bouncycastle.jcajce.spec.HKDFParameterSpec;
import org.bouncycastle.jcajce.spec.HybridValueParameterSpec;
import org.bouncycastle.jcajce.spec.MQVParameterSpec;
import org.bouncycastle.jcajce.spec.TwoStepKDFParameterSpec;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

class BaseAgreement
extends KeyAgreementSpi {
    private static final Map<String, ASN1ObjectIdentifier> defaultOids = new HashMap<String, ASN1ObjectIdentifier>();
    private static final Map<String, String> nameTable = new HashMap<String, String>();
    private static final KeyIvSizeProvider keySizeProvider = new KeyIvSizeProvider();
    private final AgreementFactory agreementFactory;
    private final PublicKeyConverter publicKeyConverter;
    private final PrivateKeyConverter privateKeyConverter;
    private final ParametersCreator parametersCreator;
    private final FipsKDF.AgreementKDFParametersBuilder kdfAlgorithm;
    private FipsKDF.HKDFKeyBuilder hkdfKeyBuilder;
    private FipsKDF.TwoStepKDFKeyBuilder twoStepKeyBuilder;
    private KDFOperatorFactory kdfOperatorFactory;
    private FipsKDF.CounterModeParametersBuilder ctrParamsBldr;
    private FipsKDF.FeedbackModeParametersBuilder fbParamsBldr;
    private FipsKDF.DoublePipelineModeParametersBuilder dblppParamsBldr;
    private FipsKDF.CounterLocation fixedInputLocation;
    protected Agreement agreement;
    protected byte[] result;
    private Parameters parameters;
    private byte[] salt;
    private byte[] userKeyingMaterial;
    private byte[] iv;
    private HybridValueParameterSpec hybridSpec;

    protected BaseAgreement(AgreementFactory agreementFactory, PublicKeyConverter publicKeyConverter, PrivateKeyConverter privateKeyConverter, ParametersCreator parametersCreator) {
        this(agreementFactory, publicKeyConverter, privateKeyConverter, parametersCreator, (FipsKDF.AgreementKDFParametersBuilder)null);
    }

    protected BaseAgreement(AgreementFactory agreementFactory, PublicKeyConverter publicKeyConverter, PrivateKeyConverter privateKeyConverter, ParametersCreator parametersCreator, FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder) {
        this(agreementFactory, publicKeyConverter, privateKeyConverter, parametersCreator, agreementKDFParametersBuilder, null);
    }

    protected BaseAgreement(AgreementFactory agreementFactory, PublicKeyConverter publicKeyConverter, PrivateKeyConverter privateKeyConverter, ParametersCreator parametersCreator, FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, FipsKDF.HKDFKeyBuilder hKDFKeyBuilder) {
        this.agreementFactory = agreementFactory;
        this.publicKeyConverter = publicKeyConverter;
        this.privateKeyConverter = privateKeyConverter;
        this.parametersCreator = parametersCreator;
        this.kdfAlgorithm = agreementKDFParametersBuilder;
        this.kdfOperatorFactory = new FipsKDF.AgreementOperatorFactory();
        this.hkdfKeyBuilder = hKDFKeyBuilder;
    }

    protected BaseAgreement(AgreementFactory agreementFactory, PublicKeyConverter publicKeyConverter, PrivateKeyConverter privateKeyConverter, ParametersCreator parametersCreator, FipsKDF.TwoStepKDFKeyBuilder twoStepKDFKeyBuilder) {
        this.agreementFactory = agreementFactory;
        this.publicKeyConverter = publicKeyConverter;
        this.privateKeyConverter = privateKeyConverter;
        this.parametersCreator = parametersCreator;
        this.kdfOperatorFactory = null;
        this.twoStepKeyBuilder = twoStepKDFKeyBuilder;
        this.kdfAlgorithm = null;
    }

    @Override
    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (this.parameters == null) {
            throw new IllegalStateException("KeyAgreement not initialized");
        }
        Algorithm algorithm = this.parameters.getAlgorithm();
        if (!(key instanceof PublicKey)) {
            throw new InvalidKeyException(algorithm.getName() + " key agreement requires " + BaseAgreement.getSimpleName(PublicKey.class) + " for doPhase");
        }
        PublicKey publicKey = (PublicKey)key;
        if (algorithm.equals(FipsDH.ALGORITHM)) {
            Object t = this.publicKeyConverter.convertKey(this.parameters.getAlgorithm(), publicKey);
            this.result = this.calculateAgreement((AsymmetricPublicKey)t);
            return new ProvDHPublicKey(new AsymmetricDHPublicKey(FipsDH.ALGORITHM, ((AsymmetricDHKey)t).getDomainParameters(), new BigInteger(1, this.result)));
        }
        if (!bl) {
            throw new IllegalStateException(algorithm.getName() + " can only be between two parties.");
        }
        Object t = this.publicKeyConverter.convertKey(this.parameters.getAlgorithm(), publicKey);
        this.result = this.calculateAgreement((AsymmetricPublicKey)t);
        return null;
    }

    private byte[] calculateAgreement(AsymmetricPublicKey asymmetricPublicKey) throws InvalidKeyException {
        try {
            return this.agreement.calculate(asymmetricPublicKey);
        }
        catch (IllegalKeyException illegalKeyException) {
            throw new InvalidKeyException(illegalKeyException.getMessage());
        }
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        byte[] byArray;
        if (this.result == null) {
            throw new IllegalStateException("KeyAgreement not initialized");
        }
        if (this.kdfAlgorithm != null) {
            byArray = this.calcSecret(this.result);
            byte[] byArray2 = new byte[this.result.length];
            FipsKDF.AgreementKDFParameters agreementKDFParameters = this.createKdfParameters(byArray);
            KDFCalculator<FipsKDF.AgreementKDFParameters> kDFCalculator = this.kdfOperatorFactory.createKDFCalculator(agreementKDFParameters);
            kDFCalculator.generateBytes(byArray2, 0, byArray2.length);
            Arrays.fill(byArray, (byte)0);
            this.result = byArray2;
        } else if (this.twoStepKeyBuilder != null) {
            byArray = this.calcSecret(this.result);
            byte[] byArray3 = new byte[this.result.length];
            KDFCalculator kDFCalculator = this.getKdf108Calculator(byArray);
            kDFCalculator.generateBytes(byArray3, 0, byArray3.length);
            Arrays.fill(byArray, (byte)0);
            this.result = byArray3;
        }
        byArray = this.result;
        this.result = null;
        return byArray;
    }

    private byte[] calcSecret(byte[] byArray) {
        if (this.hybridSpec != null) {
            byte[] byArray2 = Arrays.concatenate(byArray, this.hybridSpec.getT());
            Arrays.clear(byArray);
            return byArray2;
        }
        return byArray;
    }

    private FipsKDF.AgreementKDFParameters createKdfParameters(byte[] byArray) {
        FipsKDF.AgreementKDFParameters agreementKDFParameters;
        if (this.hkdfKeyBuilder != null) {
            FipsKDF.HKDFKey hKDFKey = this.hkdfKeyBuilder.build(byArray);
            agreementKDFParameters = this.kdfAlgorithm.withPRF(hKDFKey.getPRF()).using(hKDFKey.getKey());
        } else {
            agreementKDFParameters = this.kdfAlgorithm.using(byArray);
        }
        agreementKDFParameters = agreementKDFParameters.withIV(this.userKeyingMaterial);
        if (this.salt != null) {
            agreementKDFParameters = agreementKDFParameters.withSalt(this.salt);
        }
        return agreementKDFParameters;
    }

    @Override
    protected int engineGenerateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        byte[] byArray2 = this.engineGenerateSecret();
        if (byArray.length - n < byArray2.length) {
            throw new ShortBufferException(this.parameters.getAlgorithm().getName() + " key agreement: need " + byArray2.length + " bytes");
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    @Override
    protected SecretKey engineGenerateSecret(String string) throws NoSuchAlgorithmException {
        if (this.result == null) {
            throw new IllegalStateException("KeyAgreement not initialized");
        }
        byte[] byArray = this.result;
        this.result = null;
        String string2 = Strings.toUpperCase(string);
        if (string2.indexOf(47) < 0) {
            int n;
            String string3 = string;
            if (defaultOids.containsKey(string2)) {
                string3 = defaultOids.get(string2).getId();
            }
            if ((n = BaseAgreement.getKeySize(string3)) < 0) {
                if (string.equals("TlsPremasterSecret") && this.agreement.getParameters().getAlgorithm().getName().equals("DH")) {
                    return new SecretKeySpec(BaseAgreement.trimZeroes(byArray), string);
                }
                return new SecretKeySpec(byArray, BaseAgreement.getAlgorithm(string3));
            }
            if (this.kdfAlgorithm != null) {
                byte[] byArray2 = new byte[n];
                FipsKDF.AgreementKDFParameters agreementKDFParameters = this.createKdfParameters(this.calcSecret(byArray));
                KDFCalculator<FipsKDF.AgreementKDFParameters> kDFCalculator = this.kdfOperatorFactory.createKDFCalculator(agreementKDFParameters);
                kDFCalculator.generateBytes(byArray2, 0, byArray2.length);
                Arrays.fill(byArray, (byte)0);
                byArray = byArray2;
            } else if (this.twoStepKeyBuilder != null) {
                byte[] byArray3 = new byte[n];
                KDFCalculator kDFCalculator = this.getKdf108Calculator(this.calcSecret(byArray));
                kDFCalculator.generateBytes(byArray3, 0, byArray3.length);
                Arrays.fill(byArray, (byte)0);
                byArray = byArray3;
            } else {
                byte[] byArray4 = new byte[n];
                System.arraycopy(byArray, 0, byArray4, 0, byArray4.length);
                Arrays.fill(byArray, (byte)0);
                byArray = byArray4;
            }
            if (DESUtil.isDES(string3)) {
                DESUtil.setOddParity(byArray);
            }
            return new SecretKeySpec(byArray, BaseAgreement.getAlgorithm(string3));
        }
        String string4 = string2.substring(0, string2.indexOf(47));
        String string5 = string2.substring(string2.indexOf(47) + 1);
        int n = BaseAgreement.getKeySize(string4);
        int n2 = BaseAgreement.getKeySize(string5);
        byte[] byArray5 = new byte[n];
        byte[] byArray6 = new byte[n2];
        if (this.kdfAlgorithm != null) {
            byte[] byArray7 = new byte[n + n2];
            FipsKDF.AgreementKDFParameters agreementKDFParameters = this.createKdfParameters(byArray);
            KDFCalculator<FipsKDF.AgreementKDFParameters> kDFCalculator = this.kdfOperatorFactory.createKDFCalculator(agreementKDFParameters);
            kDFCalculator.generateBytes(byArray7, 0, byArray7.length);
            System.arraycopy(byArray7, 0, byArray5, 0, n);
            System.arraycopy(byArray7, n, byArray6, 0, n2);
            Arrays.fill(byArray, (byte)0);
            Arrays.fill(byArray7, (byte)0);
        } else if (this.twoStepKeyBuilder != null) {
            byte[] byArray8 = new byte[n + n2];
            KDFCalculator kDFCalculator = this.getKdf108Calculator(byArray);
            kDFCalculator.generateBytes(byArray8, 0, byArray8.length);
            System.arraycopy(byArray8, 0, byArray5, 0, n);
            System.arraycopy(byArray8, n, byArray6, 0, n2);
            Arrays.fill(byArray, (byte)0);
            Arrays.fill(byArray8, (byte)0);
        } else {
            throw new IllegalStateException("KDF is required for key agreement with confirmation");
        }
        return new AgreedKeyWithMacKey(new SecretKeySpec(byArray6, BaseAgreement.getAlgorithm(string5)), BaseAgreement.getAlgorithm(string4), byArray5);
    }

    private KDFCalculator getKdf108Calculator(byte[] byArray) {
        if (this.ctrParamsBldr != null) {
            if (FipsKDF.CounterLocation.AFTER_FIXED_INPUT.equals((Object)this.fixedInputLocation)) {
                return new FipsKDF.CounterModeFactory().createKDFCalculator(this.ctrParamsBldr.using(this.twoStepKeyBuilder.build(byArray).getKey(), this.userKeyingMaterial));
            }
            return new FipsKDF.CounterModeFactory().createKDFCalculator(this.ctrParamsBldr.using(this.twoStepKeyBuilder.build(byArray).getKey(), null, this.userKeyingMaterial));
        }
        if (this.fbParamsBldr != null) {
            return new FipsKDF.FeedbackModeFactory().createKDFCalculator(this.fbParamsBldr.using(this.twoStepKeyBuilder.build(byArray).getKey(), this.iv, this.userKeyingMaterial));
        }
        if (this.dblppParamsBldr != null) {
            return new FipsKDF.DoublePipelineModeFactory().createKDFCalculator(this.dblppParamsBldr.using(this.twoStepKeyBuilder.build(byArray).getKey(), this.userKeyingMaterial));
        }
        throw new IllegalStateException("cannot create SP 800-108 KDF");
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initFromKey(key, algorithmParameterSpec, secureRandom);
    }

    @Override
    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.initFromKey(key, null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException("Issue processing null paramSpec: " + invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
        }
    }

    private void initFromKey(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof HybridValueParameterSpec) {
            this.hybridSpec = (HybridValueParameterSpec)algorithmParameterSpec;
            algorithmParameterSpec = this.hybridSpec.getBaseParameterSpec();
        } else {
            this.hybridSpec = null;
        }
        this.parameters = this.parametersCreator.createParameters(true, algorithmParameterSpec, secureRandom);
        if (algorithmParameterSpec instanceof MQVParameterSpec) {
            this.initSpecDetails(((MQVParameterSpec)algorithmParameterSpec).getKdfParameterSpec());
        } else if (algorithmParameterSpec instanceof DHUParameterSpec) {
            this.initSpecDetails(((DHUParameterSpec)algorithmParameterSpec).getKdfParameterSpec());
        } else {
            this.initSpecDetails(algorithmParameterSpec);
        }
        if (this.hybridSpec != null && this.kdfAlgorithm == null && this.twoStepKeyBuilder == null) {
            throw new InvalidAlgorithmParameterException("cannot use HybridValueParameterSpec with algorithm");
        }
        Algorithm algorithm = this.parameters.getAlgorithm();
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException(algorithm.getName() + " key agreement requires " + BaseAgreement.getSimpleName(ECPrivateKey.class) + " for initialisation");
        }
        PrivateKey privateKey = (PrivateKey)key;
        Object t = this.privateKeyConverter.convertKey(algorithm, privateKey);
        try {
            this.agreement = this.agreementFactory.createAgreement((AsymmetricPrivateKey)t, this.parameters);
        }
        catch (IllegalKeyException illegalKeyException) {
            throw new InvalidAlgorithmParameterException(illegalKeyException.getMessage());
        }
        catch (FipsUnapprovedOperationError fipsUnapprovedOperationError) {
            throw new InvalidKeyException(fipsUnapprovedOperationError.getMessage(), (Throwable)((Object)fipsUnapprovedOperationError));
        }
    }

    private void initSpecDetails(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.userKeyingMaterial = null;
        this.salt = null;
        this.iv = null;
        this.ctrParamsBldr = null;
        this.fbParamsBldr = null;
        this.dblppParamsBldr = null;
        if (algorithmParameterSpec instanceof UserKeyingMaterialSpec) {
            this.userKeyingMaterial = ((UserKeyingMaterialSpec)algorithmParameterSpec).getUserKeyingMaterial();
            this.salt = ((UserKeyingMaterialSpec)algorithmParameterSpec).getSalt();
        } else if (algorithmParameterSpec instanceof HKDFParameterSpec) {
            if (this.hkdfKeyBuilder == null) {
                throw new InvalidAlgorithmParameterException("cannot use HKDParameterSpec with algorithm");
            }
            this.hkdfKeyBuilder = this.hkdfKeyBuilder.withSalt(((HKDFParameterSpec)algorithmParameterSpec).getSalt());
            this.userKeyingMaterial = ((HKDFParameterSpec)algorithmParameterSpec).getInfo();
        } else if (algorithmParameterSpec instanceof TwoStepKDFParameterSpec) {
            if (this.twoStepKeyBuilder == null) {
                throw new InvalidAlgorithmParameterException("cannot use TwoStepParameterSpec with algorithm");
            }
            TwoStepKDFParameterSpec twoStepKDFParameterSpec = (TwoStepKDFParameterSpec)algorithmParameterSpec;
            this.twoStepKeyBuilder = this.twoStepKeyBuilder.withSalt(twoStepKDFParameterSpec.getSalt());
            switch (twoStepKDFParameterSpec.getKDFMode()) {
                case Counter: {
                    this.ctrParamsBldr = FipsKDF.COUNTER_MODE.withPRFAndR(this.twoStepKeyBuilder.getPRF(), twoStepKDFParameterSpec.getR());
                    this.fixedInputLocation = this.convertLocation(twoStepKDFParameterSpec.getCounterLocation());
                    break;
                }
                case Feedback: {
                    this.fbParamsBldr = FipsKDF.FEEDBACK_MODE.withPRF(this.twoStepKeyBuilder.getPRF()).withRAndLocation(twoStepKDFParameterSpec.getR(), this.convertLocation(twoStepKDFParameterSpec.getCounterLocation()));
                    this.iv = twoStepKDFParameterSpec.getIV();
                    break;
                }
                case DoublePipeline: {
                    this.dblppParamsBldr = FipsKDF.DOUBLE_PIPELINE_ITERATION_MODE.withPRF(this.twoStepKeyBuilder.getPRF()).withRAndLocation(twoStepKDFParameterSpec.getR(), this.convertLocation(twoStepKDFParameterSpec.getCounterLocation()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown KDF mode: " + (Object)((Object)twoStepKDFParameterSpec.getKDFMode()));
                }
            }
            this.userKeyingMaterial = twoStepKDFParameterSpec.getInfo();
        }
    }

    private FipsKDF.CounterLocation convertLocation(TwoStepKDFParameterSpec.CounterLocation counterLocation) {
        switch (counterLocation) {
            case AfterFixedInput: {
                return FipsKDF.CounterLocation.AFTER_FIXED_INPUT;
            }
            case BeforeIterationData: {
                return FipsKDF.CounterLocation.BEFORE_ITERATION_DATA;
            }
            case AfterIterationData: {
                return FipsKDF.CounterLocation.AFTER_ITERATION_DATA;
            }
        }
        throw new IllegalStateException("unknown location seen!!");
    }

    private static byte[] trimZeroes(byte[] byArray) {
        int n;
        if (byArray[0] != 0) {
            return byArray;
        }
        for (n = 0; n < byArray.length && byArray[n] == 0; ++n) {
        }
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private static String getSimpleName(Class<?> clazz) {
        String string = clazz.getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    private static int getKeySize(String string) {
        if (string.indexOf(91) > 0) {
            return (Integer.parseInt(string.substring(string.indexOf(91) + 1, string.indexOf(93))) + 7) / 8;
        }
        return keySizeProvider.getKeySize(string);
    }

    private static String getAlgorithm(String string) {
        if (string.indexOf(91) > 0) {
            return string.substring(0, string.indexOf(91));
        }
        if (string.startsWith(NISTObjectIdentifiers.aes.getId())) {
            return "AES";
        }
        if (string.startsWith(GNUObjectIdentifiers.Serpent.getId())) {
            return "Serpent";
        }
        String string2 = nameTable.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    static {
        defaultOids.put("DESEDE", PKCSObjectIdentifiers.des_EDE3_CBC);
        defaultOids.put("AES", NISTObjectIdentifiers.id_aes256_CBC);
        defaultOids.put("CAMELLIA", NTTObjectIdentifiers.id_camellia256_cbc);
        defaultOids.put("SEED", KISAObjectIdentifiers.id_seedCBC);
        defaultOids.put("DES", OIWObjectIdentifiers.desCBC);
        nameTable.put(MiscObjectIdentifiers.cast5CBC.getId(), "CAST5");
        nameTable.put(MiscObjectIdentifiers.as_sys_sec_alg_ideaCBC.getId(), "IDEA");
        nameTable.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_ECB.getId(), "Blowfish");
        nameTable.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC.getId(), "Blowfish");
        nameTable.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CFB.getId(), "Blowfish");
        nameTable.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_OFB.getId(), "Blowfish");
        nameTable.put(OIWObjectIdentifiers.desECB.getId(), "DES");
        nameTable.put(OIWObjectIdentifiers.desCBC.getId(), "DES");
        nameTable.put(OIWObjectIdentifiers.desCFB.getId(), "DES");
        nameTable.put(OIWObjectIdentifiers.desOFB.getId(), "DES");
        nameTable.put(OIWObjectIdentifiers.desEDE.getId(), "DESede");
        nameTable.put(PKCSObjectIdentifiers.des_EDE3_CBC.getId(), "DESede");
        nameTable.put(PKCSObjectIdentifiers.id_alg_CMS3DESwrap.getId(), "DESede");
        nameTable.put(PKCSObjectIdentifiers.id_alg_CMSRC2wrap.getId(), "RC2");
        nameTable.put(PKCSObjectIdentifiers.id_hmacWithSHA1.getId(), "HmacSHA1");
        nameTable.put(PKCSObjectIdentifiers.id_hmacWithSHA224.getId(), "HmacSHA224");
        nameTable.put(PKCSObjectIdentifiers.id_hmacWithSHA256.getId(), "HmacSHA256");
        nameTable.put(PKCSObjectIdentifiers.id_hmacWithSHA384.getId(), "HmacSHA384");
        nameTable.put(PKCSObjectIdentifiers.id_hmacWithSHA512.getId(), "HmacSHA512");
        nameTable.put(NTTObjectIdentifiers.id_camellia128_cbc.getId(), "Camellia");
        nameTable.put(NTTObjectIdentifiers.id_camellia192_cbc.getId(), "Camellia");
        nameTable.put(NTTObjectIdentifiers.id_camellia256_cbc.getId(), "Camellia");
        nameTable.put(NTTObjectIdentifiers.id_camellia128_wrap.getId(), "Camellia");
        nameTable.put(NTTObjectIdentifiers.id_camellia192_wrap.getId(), "Camellia");
        nameTable.put(NTTObjectIdentifiers.id_camellia256_wrap.getId(), "Camellia");
        nameTable.put(KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap.getId(), "SEED");
        nameTable.put(KISAObjectIdentifiers.id_seedCBC.getId(), "SEED");
        nameTable.put(KISAObjectIdentifiers.id_seedMAC.getId(), "SEED");
        nameTable.put(CryptoProObjectIdentifiers.gostR28147_gcfb.getId(), "GOST28147");
        nameTable.put(NISTObjectIdentifiers.id_aes128_wrap.getId(), "AES");
        nameTable.put(NISTObjectIdentifiers.id_aes128_CCM.getId(), "AES");
        nameTable.put(NISTObjectIdentifiers.id_aes128_CCM.getId(), "AES");
    }
}

