/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eventbus;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.greenrobot.eventbus.EventBusException;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.SubscriberMethod;
import org.greenrobot.eventbus.ThreadMode;
import org.greenrobot.eventbus.meta.SubscriberInfo;
import org.greenrobot.eventbus.meta.SubscriberInfoIndex;

class SubscriberMethodFinder {
    private static final int BRIDGE = 64;
    private static final int SYNTHETIC = 4096;
    private static final int MODIFIERS_IGNORE = 5192;
    private static final Map<Class<?>, List<SubscriberMethod>> METHOD_CACHE = new ConcurrentHashMap();
    private List<SubscriberInfoIndex> subscriberInfoIndexes;
    private final boolean strictMethodVerification;
    private final boolean ignoreGeneratedIndex;
    private static final int POOL_SIZE = 4;
    private static final FindState[] FIND_STATE_POOL = new FindState[4];

    SubscriberMethodFinder(List<SubscriberInfoIndex> subscriberInfoIndexes, boolean strictMethodVerification, boolean ignoreGeneratedIndex) {
        this.subscriberInfoIndexes = subscriberInfoIndexes;
        this.strictMethodVerification = strictMethodVerification;
        this.ignoreGeneratedIndex = ignoreGeneratedIndex;
    }

    List<SubscriberMethod> findSubscriberMethods(Class<?> subscriberClass) {
        List<SubscriberMethod> subscriberMethods = METHOD_CACHE.get(subscriberClass);
        if (subscriberMethods != null) {
            return subscriberMethods;
        }
        subscriberMethods = this.ignoreGeneratedIndex ? this.findUsingReflection(subscriberClass) : this.findUsingInfo(subscriberClass);
        if (subscriberMethods.isEmpty()) {
            throw new EventBusException("Subscriber " + subscriberClass + " and its super classes have no public methods with the @Subscribe annotation");
        }
        METHOD_CACHE.put(subscriberClass, subscriberMethods);
        return subscriberMethods;
    }

    private List<SubscriberMethod> findUsingInfo(Class<?> subscriberClass) {
        FindState findState = this.prepareFindState();
        findState.initForSubscriber(subscriberClass);
        while (findState.clazz != null) {
            findState.subscriberInfo = this.getSubscriberInfo(findState);
            if (findState.subscriberInfo != null) {
                SubscriberMethod[] array;
                for (SubscriberMethod subscriberMethod : array = findState.subscriberInfo.getSubscriberMethods()) {
                    if (!findState.checkAdd(subscriberMethod.method, subscriberMethod.eventType)) continue;
                    findState.subscriberMethods.add(subscriberMethod);
                }
            } else {
                this.findUsingReflectionInSingleClass(findState);
            }
            findState.moveToSuperclass();
        }
        return this.getMethodsAndRelease(findState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SubscriberMethod> getMethodsAndRelease(FindState findState) {
        ArrayList<SubscriberMethod> subscriberMethods = new ArrayList<SubscriberMethod>(findState.subscriberMethods);
        findState.recycle();
        FindState[] findStateArray = FIND_STATE_POOL;
        synchronized (FIND_STATE_POOL) {
            for (int i = 0; i < 4; ++i) {
                if (FIND_STATE_POOL[i] != null) continue;
                SubscriberMethodFinder.FIND_STATE_POOL[i] = findState;
                break;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return subscriberMethods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FindState prepareFindState() {
        FindState[] findStateArray = FIND_STATE_POOL;
        synchronized (FIND_STATE_POOL) {
            for (int i = 0; i < 4; ++i) {
                FindState state = FIND_STATE_POOL[i];
                if (state == null) continue;
                SubscriberMethodFinder.FIND_STATE_POOL[i] = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return state;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new FindState();
        }
    }

    private SubscriberInfo getSubscriberInfo(FindState findState) {
        SubscriberInfo superclassInfo;
        if (findState.subscriberInfo != null && findState.subscriberInfo.getSuperSubscriberInfo() != null && findState.clazz == (superclassInfo = findState.subscriberInfo.getSuperSubscriberInfo()).getSubscriberClass()) {
            return superclassInfo;
        }
        if (this.subscriberInfoIndexes != null) {
            for (SubscriberInfoIndex index : this.subscriberInfoIndexes) {
                SubscriberInfo info = index.getSubscriberInfo(findState.clazz);
                if (info == null) continue;
                return info;
            }
        }
        return null;
    }

    private List<SubscriberMethod> findUsingReflection(Class<?> subscriberClass) {
        FindState findState = this.prepareFindState();
        findState.initForSubscriber(subscriberClass);
        while (findState.clazz != null) {
            this.findUsingReflectionInSingleClass(findState);
            findState.moveToSuperclass();
        }
        return this.getMethodsAndRelease(findState);
    }

    private void findUsingReflectionInSingleClass(FindState findState) {
        Method[] methods;
        try {
            methods = findState.clazz.getDeclaredMethods();
        }
        catch (Throwable th) {
            try {
                methods = findState.clazz.getMethods();
            }
            catch (LinkageError error) {
                String msg = "Could not inspect methods of " + findState.clazz.getName();
                msg = this.ignoreGeneratedIndex ? msg + ". Please consider using EventBus annotation processor to avoid reflection." : msg + ". Please make this class visible to EventBus annotation processor to avoid reflection.";
                throw new EventBusException(msg, error);
            }
            findState.skipSuperClasses = true;
        }
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            if ((modifiers & 1) != 0 && (modifiers & 0x1448) == 0) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (parameterTypes.length == 1) {
                    Class<?> eventType;
                    Subscribe subscribeAnnotation = method.getAnnotation(Subscribe.class);
                    if (subscribeAnnotation == null || !findState.checkAdd(method, eventType = parameterTypes[0])) continue;
                    ThreadMode threadMode = subscribeAnnotation.threadMode();
                    findState.subscriberMethods.add(new SubscriberMethod(method, eventType, threadMode, subscribeAnnotation.priority(), subscribeAnnotation.sticky()));
                    continue;
                }
                if (!this.strictMethodVerification || !method.isAnnotationPresent(Subscribe.class)) continue;
                String methodName = method.getDeclaringClass().getName() + "." + method.getName();
                throw new EventBusException("@Subscribe method " + methodName + "must have exactly 1 parameter but has " + parameterTypes.length);
            }
            if (!this.strictMethodVerification || !method.isAnnotationPresent(Subscribe.class)) continue;
            String methodName = method.getDeclaringClass().getName() + "." + method.getName();
            throw new EventBusException(methodName + " is a illegal @Subscribe method: must be public, non-static, and non-abstract");
        }
    }

    static void clearCaches() {
        METHOD_CACHE.clear();
    }

    static class FindState {
        final List<SubscriberMethod> subscriberMethods = new ArrayList<SubscriberMethod>();
        final Map<Class, Object> anyMethodByEventType = new HashMap<Class, Object>();
        final Map<String, Class> subscriberClassByMethodKey = new HashMap<String, Class>();
        final StringBuilder methodKeyBuilder = new StringBuilder(128);
        Class<?> subscriberClass;
        Class<?> clazz;
        boolean skipSuperClasses;
        SubscriberInfo subscriberInfo;

        FindState() {
        }

        void initForSubscriber(Class<?> subscriberClass) {
            this.clazz = subscriberClass;
            this.subscriberClass = this.clazz;
            this.skipSuperClasses = false;
            this.subscriberInfo = null;
        }

        void recycle() {
            this.subscriberMethods.clear();
            this.anyMethodByEventType.clear();
            this.subscriberClassByMethodKey.clear();
            this.methodKeyBuilder.setLength(0);
            this.subscriberClass = null;
            this.clazz = null;
            this.skipSuperClasses = false;
            this.subscriberInfo = null;
        }

        boolean checkAdd(Method method, Class<?> eventType) {
            Object existing = this.anyMethodByEventType.put(eventType, method);
            if (existing == null) {
                return true;
            }
            if (existing instanceof Method) {
                if (!this.checkAddWithMethodSignature((Method)existing, eventType)) {
                    throw new IllegalStateException();
                }
                this.anyMethodByEventType.put(eventType, this);
            }
            return this.checkAddWithMethodSignature(method, eventType);
        }

        private boolean checkAddWithMethodSignature(Method method, Class<?> eventType) {
            this.methodKeyBuilder.setLength(0);
            this.methodKeyBuilder.append(method.getName());
            this.methodKeyBuilder.append('>').append(eventType.getName());
            String methodKey = this.methodKeyBuilder.toString();
            Class<?> methodClass = method.getDeclaringClass();
            Class<?> methodClassOld = this.subscriberClassByMethodKey.put(methodKey, methodClass);
            if (methodClassOld == null || methodClassOld.isAssignableFrom(methodClass)) {
                return true;
            }
            this.subscriberClassByMethodKey.put(methodKey, methodClassOld);
            return false;
        }

        void moveToSuperclass() {
            if (this.skipSuperClasses) {
                this.clazz = null;
            } else {
                this.clazz = this.clazz.getSuperclass();
                String clazzName = this.clazz.getName();
                if (clazzName.startsWith("java.") || clazzName.startsWith("javax.") || clazzName.startsWith("android.") || clazzName.startsWith("androidx.")) {
                    this.clazz = null;
                }
            }
        }
    }
}

