/*
 * Decompiled with CFR 0.152.
 */
package org.passay.dictionary;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.passay.dictionary.ArrayWordList;
import org.passay.dictionary.WordList;
import org.passay.dictionary.sort.ArraySorter;

public final class WordLists {
    public static final Comparator<String> CASE_SENSITIVE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String a, String b) {
            return a.compareTo(b);
        }

        public String toString() {
            return String.format("%s-%s@%d", this.getClass().getName(), "CASE_SENSITIVE", this.hashCode());
        }
    };
    public static final Comparator<String> CASE_INSENSITIVE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String a, String b) {
            return a.compareToIgnoreCase(b);
        }

        public String toString() {
            return String.format("%s-%s@%d", this.getClass().getName(), "CASE_INSENSITIVE", this.hashCode());
        }
    };
    public static final int NOT_FOUND = -1;

    private WordLists() {
    }

    public static int binarySearch(WordList wordList, String word) {
        Comparator<String> comparator = wordList.getComparator();
        int low = 0;
        int high = wordList.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = comparator.compare(wordList.get(mid), word);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public static ArrayWordList createFromReader(Reader[] readers) throws IOException {
        return WordLists.createFromReader(readers, true);
    }

    public static ArrayWordList createFromReader(Reader[] readers, boolean caseSensitive) throws IOException {
        return WordLists.createFromReader(readers, caseSensitive, null);
    }

    public static ArrayWordList createFromReader(Reader[] readers, boolean caseSensitive, ArraySorter sorter) throws IOException {
        ArrayList<String> words = new ArrayList<String>();
        for (Reader r : readers) {
            WordLists.readWordList(r, words);
        }
        return new ArrayWordList(words.toArray(new String[words.size()]), caseSensitive, sorter);
    }

    public static void readWords(Reader reader, List<String> words) throws IOException {
        String word;
        BufferedReader bufferedReader;
        BufferedReader bufferedReader2 = bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        while ((word = bufferedReader.readLine()) != null) {
            if (word.isEmpty()) continue;
            words.add(word);
        }
    }

    public static void readWords(InputStream in, String charset, List<String> words) throws IOException {
        WordLists.readWords(new InputStreamReader(in, charset), words);
    }

    public static void readZippedWords(InputStream in, String charset, String regex, List<String> words) throws IOException {
        ZipEntry entry;
        Pattern pattern = regex == null ? null : Pattern.compile(regex);
        ZipInputStream zin = new ZipInputStream(in);
        while ((entry = zin.getNextEntry()) != null) {
            if (!entry.isDirectory() && (pattern == null || pattern.matcher(entry.getName()).matches())) {
                WordLists.readWords(zin, charset, words);
            }
            zin.closeEntry();
        }
    }

    public static void readWordList(Reader reader, List<String> words) throws IOException {
        try {
            WordLists.readWords(reader, words);
        }
        finally {
            reader.close();
        }
    }
}

