/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.naming.cosnaming;

import com.sun.corba.ee.impl.naming.cosnaming.InterOperableNamingImpl;
import com.sun.corba.ee.impl.naming.cosnaming.NamingContextDataStore;
import com.sun.corba.ee.impl.naming.namingutil.INSURLHandler;
import com.sun.corba.ee.spi.logging.NamingSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.trace.Naming;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Object;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.BindingTypeHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExtPOA;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

@Naming
public abstract class NamingContextImpl
extends NamingContextExtPOA
implements NamingContextDataStore {
    protected ORB orb;
    protected POA nsPOA;
    private static final NamingSystemException wrapper = NamingSystemException.self;
    private InterOperableNamingImpl insImpl;

    public NamingContextImpl(ORB orb, POA poa) throws Exception {
        this.orb = orb;
        this.insImpl = new InterOperableNamingImpl();
        this.nsPOA = poa;
    }

    @Override
    public POA getNSPOA() {
        return this.nsPOA;
    }

    @Naming
    public void bind(NameComponent[] n, Object obj) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (obj == null) {
            throw wrapper.objectIsNull();
        }
        NamingContextImpl impl = this;
        NamingContextImpl.doBind(impl, n, obj, false, BindingType.nobject);
    }

    @Naming
    public void bind_context(NameComponent[] n, NamingContext nc) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (nc == null) {
            wrapper.objectIsNull();
        }
        NamingContextImpl impl = this;
        NamingContextImpl.doBind(impl, n, (Object)nc, false, BindingType.ncontext);
    }

    @Naming
    public void rebind(NameComponent[] n, Object obj) throws NotFound, CannotProceed, InvalidName {
        if (obj == null) {
            throw wrapper.objectIsNull();
        }
        try {
            NamingContextImpl impl = this;
            NamingContextImpl.doBind(impl, n, obj, true, BindingType.nobject);
        }
        catch (AlreadyBound ex) {
            throw wrapper.namingCtxRebindAlreadyBound((Exception)((java.lang.Object)ex));
        }
    }

    @Naming
    public void rebind_context(NameComponent[] n, NamingContext nc) throws NotFound, CannotProceed, InvalidName {
        if (nc == null) {
            throw wrapper.objectIsNull();
        }
        try {
            NamingContextImpl impl = this;
            NamingContextImpl.doBind(impl, n, (Object)nc, true, BindingType.ncontext);
        }
        catch (AlreadyBound ex) {
            throw wrapper.namingCtxRebindctxAlreadyBound((Exception)((java.lang.Object)ex));
        }
    }

    @Naming
    public Object resolve(NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        NamingContextImpl impl = this;
        return NamingContextImpl.doResolve(impl, n);
    }

    @Naming
    public void unbind(NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        NamingContextImpl impl = this;
        NamingContextImpl.doUnbind(impl, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Naming
    public void list(int how_many, BindingListHolder bl, BindingIteratorHolder bi) {
        NamingContextImpl impl;
        NamingContextImpl namingContextImpl = impl = this;
        synchronized (namingContextImpl) {
            impl.listImpl(how_many, bl, bi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Naming
    public synchronized NamingContext new_context() {
        NamingContextImpl impl;
        NamingContextImpl namingContextImpl = impl = this;
        synchronized (namingContextImpl) {
            return impl.newContextImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Naming
    public NamingContext bind_new_context(NameComponent[] n) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
        NamingContext nc = null;
        NamingContext rnc = null;
        try {
            nc = this.new_context();
            this.bind_context(n, nc);
            rnc = nc;
            nc = null;
        }
        finally {
            try {
                if (nc != null) {
                    nc.destroy();
                }
            }
            catch (NotEmpty e) {
                throw new CannotProceed("Old naming context is not empty", nc, n);
            }
        }
        return rnc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Naming
    public void destroy() throws NotEmpty {
        NamingContextImpl impl;
        NamingContextImpl namingContextImpl = impl = this;
        synchronized (namingContextImpl) {
            if (!impl.isEmptyImpl()) {
                throw new NotEmpty();
            }
            impl.destroyImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Naming
    public static void doBind(NamingContextDataStore impl, NameComponent[] n, Object obj, boolean rebind, BindingType bt) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (n.length < 1) {
            throw new InvalidName();
        }
        if (n.length == 1) {
            if (n[0].id.length() == 0 && n[0].kind.length() == 0) {
                throw new InvalidName();
            }
            NamingContextDataStore namingContextDataStore = impl;
            synchronized (namingContextDataStore) {
                BindingTypeHolder bth = new BindingTypeHolder();
                if (rebind) {
                    Object objRef = impl.resolveImpl(n[0], bth);
                    if (objRef != null) {
                        if (bth.value.value() == BindingType.nobject.value()) {
                            if (bt.value() == BindingType.ncontext.value()) {
                                throw new NotFound(NotFoundReason.not_context, n);
                            }
                        } else if (bt.value() == BindingType.nobject.value()) {
                            throw new NotFound(NotFoundReason.not_object, n);
                        }
                        impl.unbindImpl(n[0]);
                    }
                } else if (impl.resolveImpl(n[0], bth) != null) {
                    throw new AlreadyBound();
                }
                impl.bindImpl(n[0], obj, bt);
            }
        } else {
            NamingContext context = NamingContextImpl.resolveFirstAsContext(impl, n);
            NameComponent[] tail = new NameComponent[n.length - 1];
            System.arraycopy(n, 1, tail, 0, n.length - 1);
            switch (bt.value()) {
                case 0: {
                    if (rebind) {
                        context.rebind(tail, obj);
                        break;
                    }
                    context.bind(tail, obj);
                    break;
                }
                case 1: {
                    NamingContext objContext = (NamingContext)obj;
                    if (rebind) {
                        context.rebind_context(tail, objContext);
                        break;
                    }
                    context.bind_context(tail, objContext);
                    break;
                }
                default: {
                    throw wrapper.namingCtxBadBindingtype();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Naming
    public static Object doResolve(NamingContextDataStore impl, NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        BindingTypeHolder bth = new BindingTypeHolder();
        if (n.length < 1) {
            throw new InvalidName();
        }
        if (n.length == 1) {
            Object obj;
            NamingContextDataStore namingContextDataStore = impl;
            synchronized (namingContextDataStore) {
                obj = impl.resolveImpl(n[0], bth);
            }
            if (obj == null) {
                throw new NotFound(NotFoundReason.missing_node, n);
            }
            return obj;
        }
        if (n[1].id.length() == 0 && n[1].kind.length() == 0) {
            throw new InvalidName();
        }
        NamingContext context = NamingContextImpl.resolveFirstAsContext(impl, n);
        NameComponent[] tail = new NameComponent[n.length - 1];
        System.arraycopy(n, 1, tail, 0, n.length - 1);
        try {
            Servant servant = impl.getNSPOA().reference_to_servant((Object)context);
            return NamingContextImpl.doResolve((NamingContextDataStore)servant, tail);
        }
        catch (Exception e) {
            return context.resolve(tail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Naming
    public static void doUnbind(NamingContextDataStore impl, NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        if (n.length < 1) {
            throw new InvalidName();
        }
        if (n.length == 1) {
            Object objRef;
            if (n[0].id.length() == 0 && n[0].kind.length() == 0) {
                throw new InvalidName();
            }
            NamingContextDataStore namingContextDataStore = impl;
            synchronized (namingContextDataStore) {
                objRef = impl.unbindImpl(n[0]);
            }
            if (objRef == null) {
                throw new NotFound(NotFoundReason.missing_node, n);
            }
        } else {
            NamingContext context = NamingContextImpl.resolveFirstAsContext(impl, n);
            NameComponent[] tail = new NameComponent[n.length - 1];
            System.arraycopy(n, 1, tail, 0, n.length - 1);
            context.unbind(tail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Naming
    protected static NamingContext resolveFirstAsContext(NamingContextDataStore impl, NameComponent[] n) throws NotFound {
        NamingContext context;
        Object topRef;
        BindingTypeHolder bth = new BindingTypeHolder();
        NamingContextDataStore namingContextDataStore = impl;
        synchronized (namingContextDataStore) {
            topRef = impl.resolveImpl(n[0], bth);
            if (topRef == null) {
                throw new NotFound(NotFoundReason.missing_node, n);
            }
        }
        if (bth.value != BindingType.ncontext) {
            throw new NotFound(NotFoundReason.not_context, n);
        }
        try {
            context = NamingContextHelper.narrow((Object)topRef);
        }
        catch (BAD_PARAM ex) {
            throw new NotFound(NotFoundReason.not_context, n);
        }
        return context;
    }

    @Naming
    public String to_string(NameComponent[] n) throws InvalidName {
        if (n == null || n.length == 0) {
            throw new InvalidName();
        }
        String theStringifiedName = this.insImpl.convertToString(n);
        if (theStringifiedName == null) {
            throw new InvalidName();
        }
        return theStringifiedName;
    }

    @Naming
    public NameComponent[] to_name(String sn) throws InvalidName {
        if (sn == null || sn.length() == 0) {
            throw new InvalidName();
        }
        NameComponent[] theNameComponents = this.insImpl.convertToNameComponent(sn);
        if (theNameComponents == null || theNameComponents.length == 0) {
            throw new InvalidName();
        }
        for (NameComponent theNameComponent : theNameComponents) {
            if (theNameComponent.id != null && theNameComponent.id.length() != 0 || theNameComponent.kind != null && theNameComponent.kind.length() != 0) continue;
            throw new InvalidName();
        }
        return theNameComponents;
    }

    @Naming
    public String to_url(String addr, String sn) throws InvalidAddress, InvalidName {
        if (sn == null || sn.length() == 0) {
            throw new InvalidName();
        }
        if (addr == null) {
            throw new InvalidAddress();
        }
        String urlBasedAddress = this.insImpl.createURLBasedAddress(addr, sn);
        try {
            INSURLHandler.getINSURLHandler().parseURL(urlBasedAddress);
        }
        catch (BAD_PARAM e) {
            throw new InvalidAddress();
        }
        return urlBasedAddress;
    }

    @Naming
    public Object resolve_str(String sn) throws NotFound, CannotProceed, InvalidName {
        if (sn == null || sn.length() == 0) {
            throw new InvalidName();
        }
        NameComponent[] theNameComponents = this.insImpl.convertToNameComponent(sn);
        if (theNameComponents == null || theNameComponents.length == 0) {
            throw new InvalidName();
        }
        Object theObject = this.resolve(theNameComponents);
        return theObject;
    }
}

