#ifndef HPY_UNIVERSAL_HPYFUNC_TRAMPOLINES_H
#define HPY_UNIVERSAL_HPYFUNC_TRAMPOLINES_H

/* This file should be autogenerated */

typedef struct {
    cpy_PyObject *self;
    cpy_PyObject *const *args;
    HPy_ssize_t nargs;
    cpy_PyObject *result;
} _HPyFunc_args_VARARGS;

typedef struct {
    cpy_PyObject *self;
    cpy_PyObject *const *args;
    /* We also use HPyFunc_KEYWORDS for HPy_tp_call which will be called as
       vectorcall function from CPython. Therefore, 'nargsf' may also have bit
       'PY_VECTORCALL_ARGUMENTS_OFFSET' set. */
    size_t nargsf;
    cpy_PyObject *kwnames;
    cpy_PyObject *result;
} _HPyFunc_args_KEYWORDS;

typedef struct {
    cpy_PyObject *self;
    cpy_PyObject *args;
    cpy_PyObject *kw;
    int result;
} _HPyFunc_args_INITPROC;

typedef struct {
    cpy_PyObject *self;
    cpy_PyObject *args;
    cpy_PyObject *kw;
    cpy_PyObject *result;
} _HPyFunc_args_NEWFUNC;

typedef struct {
    cpy_PyObject *arg0;
    cpy_PyObject *arg1;
    HPy_RichCmpOp arg2;
    cpy_PyObject * result;
} _HPyFunc_args_RICHCMPFUNC;

#define _HPyFunc_TRAMPOLINE_HPyFunc_VARARGS(SYM, IMPL)                      \
    static cpy_PyObject *                                                   \
    SYM(cpy_PyObject *self, cpy_PyObject *const *args, HPy_ssize_t nargs)   \
    {                                                                       \
        _HPyFunc_args_VARARGS a = { self, args, nargs };                    \
        _HPy_CallRealFunctionFromTrampoline(                                \
            _ctx_for_trampolines, HPyFunc_VARARGS, (HPyCFunction)IMPL, &a); \
        return a.result;                                                    \
    }

#define _HPyFunc_TRAMPOLINE_HPyFunc_KEYWORDS(SYM, IMPL)                      \
    static cpy_PyObject *                                                    \
    SYM(cpy_PyObject *self, cpy_PyObject *const *args, size_t nargs,         \
            cpy_PyObject *kwnames)                                           \
    {                                                                        \
        _HPyFunc_args_KEYWORDS a = { self, args, nargs, kwnames };           \
        _HPy_CallRealFunctionFromTrampoline(                                 \
            _ctx_for_trampolines, HPyFunc_KEYWORDS, (HPyCFunction)IMPL, &a); \
        return a.result;                                                     \
    }

#define _HPyFunc_TRAMPOLINE_HPyFunc_INITPROC(SYM, IMPL)                      \
    static int                                                               \
    SYM(cpy_PyObject *self, cpy_PyObject *args, cpy_PyObject *kw)            \
    {                                                                        \
        _HPyFunc_args_INITPROC a = { self, args, kw };                       \
        _HPy_CallRealFunctionFromTrampoline(                                 \
            _ctx_for_trampolines, HPyFunc_INITPROC, (HPyCFunction)IMPL, &a); \
        return a.result;                                                     \
    }

#define _HPyFunc_TRAMPOLINE_HPyFunc_NEWFUNC(SYM, IMPL)                       \
    static cpy_PyObject *                                                    \
    SYM(cpy_PyObject *self, cpy_PyObject *args, cpy_PyObject *kw)            \
    {                                                                        \
        _HPyFunc_args_NEWFUNC a = { self, args, kw };                        \
        _HPy_CallRealFunctionFromTrampoline(                                 \
            _ctx_for_trampolines, HPyFunc_NEWFUNC, (HPyCFunction)IMPL, &a);  \
        return a.result;                                                     \
    }

/* special case: the HPy_tp_destroy slot doesn't map to any CPython slot.
   Instead, it is called from our own tp_dealloc: see also
   hpytype_dealloc(). */
#define _HPyFunc_TRAMPOLINE_HPyFunc_DESTROYFUNC(SYM, IMPL) \
    static void SYM(void) { abort(); }


/* this needs to be written manually because HPy has a different type for
   "op": HPy_RichCmpOp instead of int */
#define _HPyFunc_TRAMPOLINE_HPyFunc_RICHCMPFUNC(SYM, IMPL)                     \
    static cpy_PyObject *                                                      \
    SYM(cpy_PyObject *self, cpy_PyObject *obj, int op)                         \
    {                                                                          \
        _HPyFunc_args_RICHCMPFUNC a = { self, obj, (HPy_RichCmpOp)op };        \
        _HPy_CallRealFunctionFromTrampoline(                                   \
           _ctx_for_trampolines, HPyFunc_RICHCMPFUNC, (HPyCFunction)IMPL, &a); \
        return a.result;                                                       \
    }

typedef struct {
    cpy_PyObject *self;
    cpy_Py_buffer *view;
    int flags;
    int result;
} _HPyFunc_args_GETBUFFERPROC;

#define _HPyFunc_TRAMPOLINE_HPyFunc_GETBUFFERPROC(SYM, IMPL)                     \
    static int SYM(cpy_PyObject *self, cpy_Py_buffer *view, int flags)           \
    {                                                                            \
        _HPyFunc_args_GETBUFFERPROC a = {self, view, flags};                     \
        _HPy_CallRealFunctionFromTrampoline(                                     \
           _ctx_for_trampolines, HPyFunc_GETBUFFERPROC, (HPyCFunction)IMPL, &a); \
        return a.result;                                                         \
    }

typedef struct {
    cpy_PyObject *self;
    cpy_Py_buffer *view;
} _HPyFunc_args_RELEASEBUFFERPROC;

#define _HPyFunc_TRAMPOLINE_HPyFunc_RELEASEBUFFERPROC(SYM, IMPL) \
    static void SYM(cpy_PyObject *self, cpy_Py_buffer *view)     \
    {                                                            \
        _HPyFunc_args_RELEASEBUFFERPROC a = {self, view};        \
        _HPy_CallRealFunctionFromTrampoline(                     \
           _ctx_for_trampolines, HPyFunc_RELEASEBUFFERPROC,      \
           (HPyCFunction)IMPL, &a);                              \
        return;                                                  \
    }


typedef struct {
    cpy_PyObject *self;
    cpy_visitproc visit;
    void *arg;
    int result;
} _HPyFunc_args_TRAVERSEPROC;

#define _HPyFunc_TRAMPOLINE_HPyFunc_TRAVERSEPROC(SYM, IMPL)            \
    static int SYM(cpy_PyObject *self, cpy_visitproc visit, void *arg) \
    {                                                                  \
        _HPyFunc_args_TRAVERSEPROC a = { self, visit, arg };           \
        _HPy_CallRealFunctionFromTrampoline(                           \
           _ctx_for_trampolines, HPyFunc_TRAVERSEPROC,                 \
           (HPyCFunction)IMPL, &a);                                    \
        return a.result;                                               \
    }

#define HPyCapsule_DESTRUCTOR_TRAMPOLINE(SYM, IMPL)                       \
    static void SYM(cpy_PyObject *capsule)                                \
    {                                                                     \
        _HPy_CallRealFunctionFromTrampoline(_ctx_for_trampolines,         \
                HPyFunc_CAPSULE_DESTRUCTOR, (HPyCFunction)IMPL, capsule); \
    }

typedef struct {
    cpy_PyObject *spec;
    cpy_PyObject *result;
} _HPyFunc_args_MOD_CREATE;

#define _HPyFunc_TRAMPOLINE_HPyFunc_MOD_CREATE(SYM, IMPL)                     \
    static cpy_PyObject* SYM(cpy_PyObject *spec, cpy_PyModuleDef *def)        \
    {                                                                         \
        (void) def; /* avoid 'unused' warning */                              \
        _HPyFunc_args_UNARYFUNC a = { spec };                                 \
        _HPy_CallRealFunctionFromTrampoline(                                  \
           _ctx_for_trampolines, HPyFunc_MOD_CREATE, (HPyCFunction)IMPL, &a); \
        return a.result;                                                      \
    }


#endif // HPY_UNIVERSAL_HPYFUNC_TRAMPOLINES_H
