\name{ElastixImageFilter}
\alias{ElastixImageFilter}
\title{ElastixImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
The class that wraps the elastix registration library.
ElastixImageFilter}
\details{ElastixImageFilter}
%C++ includes: sitkElastixImageFilter.h
\section{Methods}{
\describe{
\item{void AddFixedImage(const Image &fixedImage):}{}
\item{Self AddFixedImage(const Image &fixedImage):}{
Adds an image to the end of the container of fixed images.
}
\item{void AddFixedMask(const Image &fixedMask):}{}
\item{Self AddFixedMask(const Image &fixedMask):}{
Adds an image to the end of the container of fixed masks.
}
\item{void AddMovingImage(const Image &movingImage):}{}
\item{Self AddMovingImage(const Image &movingImage):}{
Adds an image to the end of the container of moving images.
}
\item{void AddMovingMask(const Image &movingMask):}{}
\item{Self AddMovingMask(const Image &movingMask):}{
Adds an image to the end of the container of moving masks.
}
\item{void AddParameter(const std::string key, const std::string value):}{}
\item{Self AddParameter(const std::string key, const std::string value):}{
Adds a parameter specified by key, with the specified value to all parameter maps.
}
\item{void AddParameter(const std::string key, const std::vector< std::string > value):}{}
\item{Self AddParameter(const std::string key, const std::vector< std::string > value):}{
Adds a parameter specified by key, with the specified values to all parameter maps.
}
\item{void AddParameter(const unsigned int index, const std::string key, const std::string value):}{}
\item{Self AddParameter(const unsigned int index, const std::string key, const std::string value):}{
Adds a parameter specified by key, with the specified value to the parameter map at the specified
(zero-based) index.
}
\item{void AddParameter(const unsigned int index, const std::string key, const std::vector< std::string > value):}{}
\item{Self AddParameter(const unsigned int index, const std::string key, const std::vector< std::string > value):}{
Adds a parameter specified by key, with the specified values to the parameter map at the specified
(zero-based) index.
}
\item{void AddParameterMap(const std::map< std::string, std::vector< std::string > > parameterMap):}{}
\item{Self AddParameterMap(const std::map< std::string, std::vector< std::string > > parameterMap):}{
Adds a parameter map to the container of parameter maps.
}
\item{class TFixedImage DualExecuteInternal(void):}{}
\item{ ElastixImageFilter():}{
Default-constructor.
}
\item{ ElastixImageFilterImpl(void):}{}
\item{Image Execute():}{
Executes the registration, and returns the result image.
Before executing, the number of moving images must equal the number of
fixed images, the number of fixed masks must be either zero, or one,
or equal to the number of fixed images, and the number of moving masks
must be either zero, or one, or equal to the number of moving images
}
\item{Image Execute(void):}{}
\item{std::map< std::string, std::vector< std::string > > GetDefaultParameterMap(const std::string transformName, const unsigned int numberOfResolutions=4, const double finalGridSpacingInPhysicalUnits=10.0):}{}
\item{std::map< std::string, std::vector< std::string > > GetDefaultParameterMap(const std::string transformName, const unsigned int numberOfResolutions=4, const double finalGridSpacingInPhysicalUnits=10.0):}{
Returns the default parameter map for the specified function arguments
( transformName may be "translation", "rigid" , "affine", "nonrigid", or
"bspline").
}
\item{VectorOfImage GetFixedImage():}{
Retrieves a reference to the container of fixed images.
}
\item{Image GetFixedImage(const unsigned long index):}{}
\item{Image GetFixedImage(const unsigned long index):}{
Retrieves a reference to the fixed image at the specified (zero-based) index.
}
\item{VectorOfImage GetFixedImage(void):}{}
\item{VectorOfImage GetFixedMask():}{
Retrieves a reference to the container of fixed masks.
}
\item{Image GetFixedMask(const unsigned long index):}{}
\item{Image GetFixedMask(const unsigned long index):}{
Retrieves a reference to the fixed mask at the specified (zero-based) index.
}
\item{VectorOfImage GetFixedMask(void):}{}
\item{std::string GetFixedPointSetFileName():}{
Returns the name of the current point set file of points from the
fixed image.
}
\item{std::string GetFixedPointSetFileName(void):}{}
\item{std::string GetInitialTransformParameterFileName():}{
Returns the initial transform parameter file name.
}
\item{std::string GetInitialTransformParameterFileName(void):}{}
\item{std::string GetLogFileName():}{
Returns the name of the current log file.
}
\item{std::string GetLogFileName(void):}{}
\item{bool GetLogToConsole():}{
Returns whether logging to console is switched on.
}
\item{bool GetLogToConsole(void):}{}
\item{bool GetLogToFile():}{
Returns whether logging to file is switched on.
}
\item{bool GetLogToFile(void):}{}
\item{VectorOfImage GetMovingImage():}{
Retrieves a reference to the moving image at the specified (zero-
based) index.
}
\item{Image GetMovingImage(const unsigned long index):}{}
\item{Image GetMovingImage(const unsigned long index):}{
Retrieves a reference to the moving image at the specified (zero-
based) index.
}
\item{VectorOfImage GetMovingImage(void):}{}
\item{VectorOfImage GetMovingMask():}{
Retrieves a reference to the container of moving masks.
}
\item{Image GetMovingMask(const unsigned long index):}{}
\item{Image GetMovingMask(const unsigned long index):}{
Retrieves a reference to the moving mask at the specified (zero-based) index.
}
\item{VectorOfImage GetMovingMask(void):}{}
\item{std::string GetMovingPointSetFileName():}{
Returns the name of the current point set file of points from the
moving image.
}
\item{std::string GetMovingPointSetFileName(void):}{}
\item{std::string GetName() const:}{}
\item{std::string GetName(void) const:}{}
\item{unsigned int GetNumberOfFixedImages():}{}
\item{unsigned int GetNumberOfFixedImages():}{
Returns the number of fixed images.
}
\item{unsigned int GetNumberOfFixedMasks():}{}
\item{unsigned int GetNumberOfFixedMasks():}{
Returns the number of fixed masks.
}
\item{unsigned int GetNumberOfMovingImages():}{}
\item{unsigned int GetNumberOfMovingImages():}{
Returns the number of moving images.
}
\item{unsigned int GetNumberOfMovingMasks():}{}
\item{unsigned int GetNumberOfMovingMasks():}{
Returns the number of moving masks.
}
\item{unsigned int GetNumberOfParameterMaps():}{
Returns the number of parameter maps.
}
\item{unsigned int GetNumberOfParameterMaps(void):}{}
\item{int GetNumberOfThreads():}{
Returns the current maximum number of threads.
}
\item{int GetNumberOfThreads(void):}{}
\item{std::string GetOutputDirectory():}{
Returns the current output directory.
}
\item{std::string GetOutputDirectory(void):}{}
\item{std::vector< std::string > GetParameter(const std::string key):}{}
\item{std::vector< std::string > GetParameter(const std::string key):}{
Retrieves the values of the parameter specified by key, when there is only one parameter map.
}
\item{std::vector< std::string > GetParameter(const unsigned int index, const std::string key):}{}
\item{std::vector< std::string > GetParameter(const unsigned int index, const std::string key):}{
Retrieves the values of the parameter specified by key, from the parameter map at the specified (zero-based) index.
}
\item{std::vector< std::map< std::string, std::vector< std::string > > > GetParameterMap():}{
Returns a copy of the parameter maps.
}
\item{std::vector< std::map< std::string, std::vector< std::string > > > GetParameterMap(void):}{}
\item{Image GetResultImage():}{
Returns the result image.
}
\item{Image GetResultImage(void):}{}
\item{std::vector< std::map< std::string, std::vector< std::string > > > GetTransformParameterMap():}{
Returns all transform parameter maps.
}
\item{std::map< std::string, std::vector< std::string > > GetTransformParameterMap(const unsigned int index):}{}
\item{std::map< std::string, std::vector< std::string > > GetTransformParameterMap(const unsigned int index):}{
Returns the transform parameter map at the specified (zero-based) index.
}
\item{std::vector< std::map< std::string, std::vector< std::string > > > GetTransformParameterMap(void):}{}
\item{bool IsEmpty(const Image &image):}{}
\item{void LogToConsoleOff():}{}
\item{Self LogToConsoleOff():}{
Switches logging to console off.
}
\item{void LogToConsoleOn():}{}
\item{Self LogToConsoleOn():}{
Switches logging to console on.
}
\item{Self LogToFileOff():}{
Switches logging to file off.
}
\item{void LogToFileOff(void):}{}
\item{Self LogToFileOn():}{
Switches logging to file on.
}
\item{void LogToFileOn(void):}{}
\item{Self PrintParameterMap():}{
Prints all parameter maps to standard output.
}
\item{void PrintParameterMap(const ParameterMapType parameterMapVector):}{}
\item{Self PrintParameterMap(const ParameterMapType parameterMapVector):}{
Prints the specified parameter map to standard output.
}
\item{void PrintParameterMap(const ParameterMapVectorType parameterMapVector):}{}
\item{Self PrintParameterMap(const ParameterMapVectorType parameterMapVector):}{
Prints the specified parameter maps to standard output.
}
\item{void PrintParameterMap(void):}{}
\item{std::map< std::string, std::vector< std::string > > ReadParameterFile(const std::string filename):}{}
\item{std::map< std::string, std::vector< std::string > > ReadParameterFile(const std::string filename):}{
Reads the parameter file specified by filename, and returns its content as a parameter map.
}
\item{Self RemoveFixedImage():}{
Removes all fixed images.
}
\item{void RemoveFixedImage(const unsigned long index):}{}
\item{Self RemoveFixedImage(const unsigned long index):}{
Removes an image at the specified (zero-based) index from the container of fixed images.
}
\item{void RemoveFixedImage(void):}{}
\item{Self RemoveFixedMask():}{
Removes all fixed masks.
}
\item{void RemoveFixedMask(const unsigned long index):}{}
\item{Self RemoveFixedMask(const unsigned long index):}{
Removes an image at the specified (zero-based) index from the container of fixed masks.
}
\item{void RemoveFixedMask(void):}{}
\item{Self RemoveFixedPointSetFileName():}{
Clears the current point set file name of points from the fixed image.
}
\item{void RemoveFixedPointSetFileName(void):}{}
\item{Self RemoveInitialTransformParameterFileName():}{
Clears the initial transform parameter file name.
}
\item{void RemoveInitialTransformParameterFileName(void):}{}
\item{Self RemoveLogFileName():}{
Clears the name of the current log file.
}
\item{void RemoveLogFileName(void):}{}
\item{Self RemoveMovingImage():}{
Removes all moving images.
}
\item{void RemoveMovingImage(const unsigned long index):}{}
\item{Self RemoveMovingImage(const unsigned long index):}{
Removes an image at the specified (zero-based) index from the container of moving images.
}
\item{void RemoveMovingImage(void):}{}
\item{Self RemoveMovingMask():}{
Removes all moving masks.
}
\item{void RemoveMovingMask(const unsigned long index):}{}
\item{Self RemoveMovingMask(const unsigned long index):}{
Removes an image at the specified (zero-based) index from the container of moving masks.
}
\item{void RemoveMovingMask(void):}{}
\item{Self RemoveMovingPointSetFileName():}{
Clears the current point set file name of points from the moving
image.
}
\item{void RemoveMovingPointSetFileName(void):}{}
\item{Self RemoveOutputDirectory():}{
Clears the name of the current output directory. (Does not remove the
actual directory.)
}
\item{void RemoveOutputDirectory(void):}{}
\item{void RemoveParameter(const std::string key):}{}
\item{Self RemoveParameter(const std::string key):}{
Removes the parameter specified by key from all parameter maps.
}
\item{void RemoveParameter(const unsigned int index, const std::string key):}{}
\item{Self RemoveParameter(const unsigned int index, const std::string key):}{
Removes the parameter specified by key from the parameter map at the specified (zero-based) index.
}
\item{void SetFixedImage(const Image &fixedImage):}{}
\item{Self SetFixedImage(const Image &fixedImage):}{
Sets a fixed image. Stores the image into the container of fixed
images.
}
\item{void SetFixedImage(const VectorOfImage &fixedImages):}{}
\item{Self SetFixedImage(const VectorOfImage &fixedImages):}{
Sets multiple fixed images. Stores the images into the container of
fixed images.
}
\item{void SetFixedMask(const Image &fixedMask):}{}
\item{Self SetFixedMask(const Image &fixedMask):}{
Sets a fixed mask. Stores the image into the container of fixed masks.
}
\item{void SetFixedMask(const VectorOfImage &fixedMasks):}{}
\item{Self SetFixedMask(const VectorOfImage &fixedMasks):}{
Sets multiple fixed masks. Stores the images into the container of
fixed masks.
}
\item{Self SetFixedPointSetFileName(const std::string fixedPointSetFileName):}{
Specifies a set of points from the fixed image by a point set file, fixedPointSetFileName.
}
\item{void SetFixedPointSetFileName(const std::string movingPointSetFileName):}{}
\item{void SetInitialTransformParameterFileName(const std::string initialTransformParmaterFileName):}{}
\item{Self SetInitialTransformParameterFileName(const std::string initialTransformParmaterFileName):}{
Specifies the initial transformation by the specified transform
parameter file name.
}
\item{void SetLogFileName(const std::string logFileName):}{}
\item{Self SetLogFileName(const std::string logFileName):}{
Sets the name of the current log file.
}
\item{void SetLogToConsole(bool):}{}
\item{Self SetLogToConsole(bool):}{
Switches logging to console on ( true) or off ( false), as specified by its function argument.
}
\item{void SetLogToFile(const bool logToFile):}{}
\item{Self SetLogToFile(const bool logToFile):}{
Switches logging to file on ( true) or off ( false), as specified by its function argument.
}
\item{void SetMovingImage(const Image &movingImages):}{}
\item{Self SetMovingImage(const Image &movingImages):}{
Sets a moving image. Stores the image into the container of moving
images.
}
\item{void SetMovingImage(const VectorOfImage &movingImage):}{}
\item{Self SetMovingImage(const VectorOfImage &movingImage):}{
Sets multiple moving images. Stores the images into the container of
moving images.
}
\item{void SetMovingMask(const Image &movingMask):}{}
\item{Self SetMovingMask(const Image &movingMask):}{
Sets a moving mask. Stores the image into the container of moving
masks.
}
\item{void SetMovingMask(const VectorOfImage &movingMasks):}{}
\item{Self SetMovingMask(const VectorOfImage &movingMasks):}{
Sets multiple moving masks. Stores the images into the container of
moving masks.
}
\item{void SetMovingPointSetFileName(const std::string movingPointSetFileName):}{}
\item{Self SetMovingPointSetFileName(const std::string movingPointSetFileName):}{
Specifies a set of points from the moving image by a point set file, movingPointSetFileName.
}
\item{void SetNumberOfThreads(int n):}{}
\item{Self SetNumberOfThreads(int n):}{
Sets the maximum number of threads to the specified number n.
As a side effect, it may modify the global maximum number of threads, as it internally calls ITK's  MultiThreaderBase.SetGlobalMaximumNumberOfThreads.
}
\item{void SetOutputDirectory(const std::string outputDirectory):}{}
\item{Self SetOutputDirectory(const std::string outputDirectory):}{
Sets the output directory.
}
\item{void SetParameter(const std::string key, const std::string value):}{}
\item{Self SetParameter(const std::string key, const std::string value):}{
Sets the value of the parameter specified by key, in all parameter maps.
}
\item{void SetParameter(const std::string key, const std::vector< std::string > value):}{}
\item{Self SetParameter(const std::string key, const std::vector< std::string > value):}{
Sets the values of the parameter specified by key, in all parameter maps.
}
\item{void SetParameter(const unsigned int index, const std::string key, const std::string value):}{}
\item{Self SetParameter(const unsigned int index, const std::string key, const std::string value):}{
Sets the value of the parameter specified by key, in the parameter map at the specified (zero-based) index.
}
\item{void SetParameter(const unsigned int index, const std::string key, const std::vector< std::string > value):}{}
\item{Self SetParameter(const unsigned int index, const std::string key, const std::vector< std::string > value):}{
Sets the values of the parameter specified by key, in the parameter map at the specified (zero-based) index.
}
\item{void SetParameterMap(const std::map< std::string, std::vector< std::string > > parameterMap):}{}
\item{Self SetParameterMap(const std::map< std::string, std::vector< std::string > > parameterMap):}{
Specifies a single parameter map.
}
\item{void SetParameterMap(const std::string transformName, const unsigned int numberOfResolutions=4u, const double finalGridSpacingInPhysicalUnits=10.0):}{}
\item{Self SetParameterMap(const std::string transformName, const unsigned int numberOfResolutions=4u, const double finalGridSpacingInPhysicalUnits=10.0):}{
Specifies the parameter map by a transformName ("translation", "rigid" , "affine", "nonrigid", or
"bspline"), and optionally numberOfResolutions and finalGridSpacingInPhysicalUnits.
}
\item{void SetParameterMap(const std::vector< std::map< std::string, std::vector< std::string > > > parameterMapVector):}{}
\item{Self SetParameterMap(const std::vector< std::map< std::string, std::vector< std::string > > > parameterMapVector):}{
Specifies multiple parameter maps.
}
\item{void WriteParameterFile(const std::map< std::string, std::vector< std::string > > parameterMap, const std::string filename):}{}
\item{Self WriteParameterFile(const std::map< std::string, std::vector< std::string > > parameterMap, const std::string filename):}{
Writes a parameter map to the file, specified by filename.
}
\item{ ~ElastixImageFilter():}{
Destructor.
}
\item{ ~ElastixImageFilterImpl(void):}{}
}
}
