(defpackage :roswell.help.options
  (:use :cl)
  (:export :*options* :options))
(in-package :roswell.help.options)

(defvar *options*
  '((()              ("--version")             "Print version information and quit")
    (("-w" "CODE")   ("--wrap" "CODE")         "Run roswell with a shell wrapper CODE,")
    (("-m" "IMAGE")  ("--image" "IMAGE")       "continue from Lisp image IMAGE")
    (("-L" "NAME")   ("--lisp" "NAME")         "Run roswell with a lisp impl NAME[/VERSION].")
    (("-l" "FILE")   ("--load" "FILE")         "load lisp FILE while building")
    (("-S" "X")      ("--source-registry" "X") "override source registry of asdf systems")
    (("-s" "SYSTEM") ("--system" "SYSTEM")     "load asdf SYSTEM while building")
    (()              ("--load-system" "SYSTEM")"same as above (buildapp compatibility)")
    (("-p" "PACKAGE")("--package" "PACKAGE")   "change current package to PACKAGE")
    (("-sp" "SP")    ("--system-package" "SP") "combination of -s SP and -p SP")
    (("-e" "FORM")   ("--eval" "FORM")         "evaluate FORM while building")
    (()              ("--require" "MODULE")    "require MODULE while building")
    (("-q")          ("--quit")                "quit lisp here")
    (("-r" "FUNC")   ("--restart" "FUNC")      "restart from build by calling (FUNC)")
    (("-E" "FUNC")   ("--entry" "FUNC")        "restart from build by calling (FUNC argv)")
    (("-i" "FORM")   ("--init" "FORM")         "evaluate FORM after restart")
    (("-ip" "FORM")  ("--print" "FORM")        "evaluate and princ FORM after restart")
    (("-iw" "FORM")  ("--write" "FORM")        "evaluate and write FORM after restart")
    (("-F" "FORM")   ("--final" "FORM")        "evaluate FORM before dumping IMAGE")
    (("+R")          ("--no-rc")               "skip /etc/rosrc, ~/.roswell/init.lisp")
    (("-A")          ("--asdf")                "use new asdf")
    (("+Q")          ("--no-quicklisp")        "do not use quicklisp")
    (("-v")          ("--verbose")             "be quite noisy while building")
    (()              ("--quiet")               "be quite quiet while building (default)")
    (()              ("--test")                "for test purpose")))

(defun options (argv)
  (declare (ignorable argv))
  (let ((p 3)
        (w1 0)
        (w2 0)
        (stream *error-output*)
        (options *options*))
    (format stream "Options:~%")
    (loop for l in options
          maximize (length (second (first l))) into a
          maximize (+ (length (first (second l)))
                      (length (second (second l)))) into b
          finally (setf w1 (+ a 2)
                        w2 (+ b 2)))
    (loop for l in options
          do (format stream "~va~3a ~va~va~a~%"
                     p " " (or (first (first l))"") w1 (or (second (first l)) "")
                     w2 (format nil "~A ~A"(or (first (second l))"") (or (second (second l))""))
                     (third l)))))
