const visitSkip=Symbol()
const visit=(node,visitor,parentNode)=>{const callbacks=visitor[node.type]
if(callbacks?.enter){const symbol=callbacks.enter(node,parentNode)
if(symbol===visitSkip)return}if(node.type==="root")for(const child of node.children)visit(child,visitor,node)
if(node.type==="element"&&parentNode.children.includes(node))for(const child of node.children)visit(child,visitor,node)
callbacks?.exit&&callbacks.exit(node,parentNode)}
const invokePlugins=(ast,info,plugins,overrides,globalOverrides)=>{for(const plugin of plugins){const override=overrides?.[plugin.name]
if(override===false)continue
const params={...plugin.params,...globalOverrides,...override}
const visitor=plugin.fn(ast,params,info)
visitor!=null&&visit(ast,visitor)}}
const createPreset=({name:name,plugins:plugins})=>({name:name,isPreset:true,plugins:Object.freeze(plugins),fn:(ast,params,info)=>{const{floatPrecision:floatPrecision,overrides:overrides}=params
const globalOverrides={}
floatPrecision!=null&&(globalOverrides.floatPrecision=floatPrecision)
if(overrides){const pluginNames=plugins.map((({name:name})=>name))
for(const pluginName of Object.keys(overrides))pluginNames.includes(pluginName)||console.warn(`You are trying to configure ${pluginName} which is not part of ${name}.\nTry to put it before or after, for example\n\nplugins: [\n  {\n    name: '${name}',\n  },\n  '${pluginName}'\n]\n`)}invokePlugins(ast,info,plugins,overrides,globalOverrides)}})
var ElementType;(function(ElementType){ElementType["Root"]="root"
ElementType["Text"]="text"
ElementType["Directive"]="directive"
ElementType["Comment"]="comment"
ElementType["Script"]="script"
ElementType["Style"]="style"
ElementType["Tag"]="tag"
ElementType["CDATA"]="cdata"
ElementType["Doctype"]="doctype"})(ElementType||(ElementType={}))
function isTag$2(elem){return elem.type===ElementType.Tag||elem.type===ElementType.Script||elem.type===ElementType.Style}const Root=ElementType.Root
const Text=ElementType.Text
const Directive=ElementType.Directive
const Comment$4=ElementType.Comment
const Script=ElementType.Script
const Style=ElementType.Style
const Tag=ElementType.Tag
const CDATA=ElementType.CDATA
const Doctype=ElementType.Doctype
function isTag$1(node){return isTag$2(node)}function isCDATA(node){return node.type===ElementType.CDATA}function isText(node){return node.type===ElementType.Text}function isComment(node){return node.type===ElementType.Comment}function isDocument(node){return node.type===ElementType.Root}function hasChildren(node){return Object.prototype.hasOwnProperty.call(node,"children")}const xmlReplacer=/["&'<>$\x80-\uFFFF]/g
const xmlCodeMap=new Map([[34,"&quot;"],[38,"&amp;"],[39,"&apos;"],[60,"&lt;"],[62,"&gt;"]])
const getCodePoint=String.prototype.codePointAt!=null?(str,index)=>str.codePointAt(index):(c,index)=>(c.charCodeAt(index)&0xfc00)===0xd800?0x400*(c.charCodeAt(index)-0xd800)+c.charCodeAt(index+1)-0xdc00+0x10000:c.charCodeAt(index)
function encodeXML(str){let ret=""
let lastIdx=0
let match
while((match=xmlReplacer.exec(str))!==null){const i=match.index
const char=str.charCodeAt(i)
const next=xmlCodeMap.get(char)
if(next!==void 0){ret+=str.substring(lastIdx,i)+next
lastIdx=i+1}else{ret+=`${str.substring(lastIdx,i)}&#x${getCodePoint(str,i).toString(16)};`
lastIdx=xmlReplacer.lastIndex+=Number((char&0xfc00)===0xd800)}}return ret+str.substr(lastIdx)}function getEscaper(regex,map){return function escape(data){let match
let lastIdx=0
let result=""
while(match=regex.exec(data)){lastIdx!==match.index&&(result+=data.substring(lastIdx,match.index))
result+=map.get(match[0].charCodeAt(0))
lastIdx=match.index+1}return result+data.substring(lastIdx)}}const escapeAttribute=getEscaper(/["&\u00A0]/g,new Map([[34,"&quot;"],[38,"&amp;"],[160,"&nbsp;"]]))
const escapeText=getEscaper(/[&<>\u00A0]/g,new Map([[38,"&amp;"],[60,"&lt;"],[62,"&gt;"],[160,"&nbsp;"]]))
const elementNames=new Map(["altGlyph","altGlyphDef","altGlyphItem","animateColor","animateMotion","animateTransform","clipPath","feBlend","feColorMatrix","feComponentTransfer","feComposite","feConvolveMatrix","feDiffuseLighting","feDisplacementMap","feDistantLight","feDropShadow","feFlood","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feImage","feMerge","feMergeNode","feMorphology","feOffset","fePointLight","feSpecularLighting","feSpotLight","feTile","feTurbulence","foreignObject","glyphRef","linearGradient","radialGradient","textPath"].map((val=>[val.toLowerCase(),val])))
const attributeNames=new Map(["definitionURL","attributeName","attributeType","baseFrequency","baseProfile","calcMode","clipPathUnits","diffuseConstant","edgeMode","filterUnits","glyphRef","gradientTransform","gradientUnits","kernelMatrix","kernelUnitLength","keyPoints","keySplines","keyTimes","lengthAdjust","limitingConeAngle","markerHeight","markerUnits","markerWidth","maskContentUnits","maskUnits","numOctaves","pathLength","patternContentUnits","patternTransform","patternUnits","pointsAtX","pointsAtY","pointsAtZ","preserveAlpha","preserveAspectRatio","primitiveUnits","refX","refY","repeatCount","repeatDur","requiredExtensions","requiredFeatures","specularConstant","specularExponent","spreadMethod","startOffset","stdDeviation","stitchTiles","surfaceScale","systemLanguage","tableValues","targetX","targetY","textLength","viewBox","viewTarget","xChannelSelector","yChannelSelector","zoomAndPan"].map((val=>[val.toLowerCase(),val])))
const unencodedElements=new Set(["style","script","xmp","iframe","noembed","noframes","plaintext","noscript"])
function replaceQuotes(value){return value.replace(/"/g,"&quot;")}function formatAttributes(attributes,opts){var _a
if(!attributes)return
const encode=((_a=opts.encodeEntities)!==null&&_a!==void 0?_a:opts.decodeEntities)===false?replaceQuotes:opts.xmlMode||opts.encodeEntities!=="utf8"?encodeXML:escapeAttribute
return Object.keys(attributes).map((key=>{var _a,_b
const value=(_a=attributes[key])!==null&&_a!==void 0?_a:""
opts.xmlMode==="foreign"&&(key=(_b=attributeNames.get(key))!==null&&_b!==void 0?_b:key)
if(!opts.emptyAttrs&&!opts.xmlMode&&value==="")return key
return`${key}="${encode(value)}"`})).join(" ")}const singleTag=new Set(["area","base","basefont","br","col","command","embed","frame","hr","img","input","isindex","keygen","link","meta","param","source","track","wbr"])
function render(node,options={}){const nodes="length"in node?node:[node]
let output=""
for(let i=0;i<nodes.length;i++)output+=renderNode(nodes[i],options)
return output}function renderNode(node,options){switch(node.type){case Root:return render(node.children,options)
case Doctype:case Directive:return renderDirective(node)
case Comment$4:return renderComment(node)
case CDATA:return renderCdata(node)
case Script:case Style:case Tag:return renderTag(node,options)
case Text:return renderText(node,options)}}const foreignModeIntegrationPoints=new Set(["mi","mo","mn","ms","mtext","annotation-xml","foreignObject","desc","title"])
const foreignElements=new Set(["svg","math"])
function renderTag(elem,opts){var _a
if(opts.xmlMode==="foreign"){elem.name=(_a=elementNames.get(elem.name))!==null&&_a!==void 0?_a:elem.name
elem.parent&&foreignModeIntegrationPoints.has(elem.parent.name)&&(opts={...opts,xmlMode:false})}!opts.xmlMode&&foreignElements.has(elem.name)&&(opts={...opts,xmlMode:"foreign"})
let tag=`<${elem.name}`
const attribs=formatAttributes(elem.attribs,opts)
attribs&&(tag+=` ${attribs}`)
if(elem.children.length===0&&(opts.xmlMode?opts.selfClosingTags!==false:opts.selfClosingTags&&singleTag.has(elem.name))){opts.xmlMode||(tag+=" ")
tag+="/>"}else{tag+=">"
elem.children.length>0&&(tag+=render(elem.children,opts))
!opts.xmlMode&&singleTag.has(elem.name)||(tag+=`</${elem.name}>`)}return tag}function renderDirective(elem){return`<${elem.data}>`}function renderText(elem,opts){var _a
let data=elem.data||"";((_a=opts.encodeEntities)!==null&&_a!==void 0?_a:opts.decodeEntities)===false||!opts.xmlMode&&elem.parent&&unencodedElements.has(elem.parent.name)||(data=opts.xmlMode||opts.encodeEntities!=="utf8"?encodeXML(data):escapeText(data))
return data}function renderCdata(elem){return`<![CDATA[${elem.children[0].data}]]>`}function renderComment(elem){return`\x3c!--${elem.data}--\x3e`}function getOuterHTML(node,options){return render(node,options)}function getInnerHTML(node,options){return hasChildren(node)?node.children.map((node=>getOuterHTML(node,options))).join(""):""}function getText$1(node){if(Array.isArray(node))return node.map(getText$1).join("")
if(isTag$1(node))return node.name==="br"?"\n":getText$1(node.children)
if(isCDATA(node))return getText$1(node.children)
if(isText(node))return node.data
return""}function textContent(node){if(Array.isArray(node))return node.map(textContent).join("")
if(hasChildren(node)&&!isComment(node))return textContent(node.children)
if(isText(node))return node.data
return""}function innerText(node){if(Array.isArray(node))return node.map(innerText).join("")
if(hasChildren(node)&&(node.type===ElementType.Tag||isCDATA(node)))return innerText(node.children)
if(isText(node))return node.data
return""}function getChildren$1(elem){return hasChildren(elem)?elem.children:[]}function getParent(elem){return elem.parent||null}function getSiblings(elem){const parent=getParent(elem)
if(parent!=null)return getChildren$1(parent)
const siblings=[elem]
let{prev:prev,next:next}=elem
while(prev!=null){siblings.unshift(prev);({prev:prev}=prev)}while(next!=null){siblings.push(next);({next:next}=next)}return siblings}function getAttributeValue$1(elem,name){var _a
return(_a=elem.attribs)===null||_a===void 0?void 0:_a[name]}function hasAttrib$1(elem,name){return elem.attribs!=null&&Object.prototype.hasOwnProperty.call(elem.attribs,name)&&elem.attribs[name]!=null}function getName$1(elem){return elem.name}function nextElementSibling(elem){let{next:next}=elem
while(next!==null&&!isTag$1(next))({next:next}=next)
return next}function prevElementSibling(elem){let{prev:prev}=elem
while(prev!==null&&!isTag$1(prev))({prev:prev}=prev)
return prev}function removeElement(elem){elem.prev&&(elem.prev.next=elem.next)
elem.next&&(elem.next.prev=elem.prev)
if(elem.parent){const childs=elem.parent.children
const childsIndex=childs.lastIndexOf(elem)
childsIndex>=0&&childs.splice(childsIndex,1)}elem.next=null
elem.prev=null
elem.parent=null}function replaceElement(elem,replacement){const prev=replacement.prev=elem.prev
prev&&(prev.next=replacement)
const next=replacement.next=elem.next
next&&(next.prev=replacement)
const parent=replacement.parent=elem.parent
if(parent){const childs=parent.children
childs[childs.lastIndexOf(elem)]=replacement
elem.parent=null}}function appendChild(parent,child){removeElement(child)
child.next=null
child.parent=parent
if(parent.children.push(child)>1){const sibling=parent.children[parent.children.length-2]
sibling.next=child
child.prev=sibling}else child.prev=null}function append$1(elem,next){removeElement(next)
const{parent:parent}=elem
const currNext=elem.next
next.next=currNext
next.prev=elem
elem.next=next
next.parent=parent
if(currNext){currNext.prev=next
if(parent){const childs=parent.children
childs.splice(childs.lastIndexOf(currNext),0,next)}}else parent&&parent.children.push(next)}function prependChild(parent,child){removeElement(child)
child.parent=parent
child.prev=null
if(parent.children.unshift(child)!==1){const sibling=parent.children[1]
sibling.prev=child
child.next=sibling}else child.next=null}function prepend(elem,prev){removeElement(prev)
const{parent:parent}=elem
if(parent){const childs=parent.children
childs.splice(childs.indexOf(elem),0,prev)}elem.prev&&(elem.prev.next=prev)
prev.parent=parent
prev.prev=elem.prev
prev.next=elem
elem.prev=prev}function filter(test,node,recurse=true,limit=1/0){return find$3(test,Array.isArray(node)?node:[node],recurse,limit)}function find$3(test,nodes,recurse,limit){const result=[]
const nodeStack=[nodes]
const indexStack=[0]
for(;;){if(indexStack[0]>=nodeStack[0].length){if(indexStack.length===1)return result
nodeStack.shift()
indexStack.shift()
continue}const elem=nodeStack[0][indexStack[0]++]
if(test(elem)){result.push(elem)
if(--limit<=0)return result}if(recurse&&hasChildren(elem)&&elem.children.length>0){indexStack.unshift(0)
nodeStack.unshift(elem.children)}}}function findOneChild(test,nodes){return nodes.find(test)}function findOne$1(test,nodes,recurse=true){let elem=null
for(let i=0;i<nodes.length&&!elem;i++){const node=nodes[i]
if(!isTag$1(node))continue
test(node)?elem=node:recurse&&node.children.length>0&&(elem=findOne$1(test,node.children,true))}return elem}function existsOne$1(test,nodes){return nodes.some((checked=>isTag$1(checked)&&(test(checked)||existsOne$1(test,checked.children))))}function findAll$4(test,nodes){const result=[]
const nodeStack=[nodes]
const indexStack=[0]
for(;;){if(indexStack[0]>=nodeStack[0].length){if(nodeStack.length===1)return result
nodeStack.shift()
indexStack.shift()
continue}const elem=nodeStack[0][indexStack[0]++]
if(!isTag$1(elem))continue
test(elem)&&result.push(elem)
if(elem.children.length>0){indexStack.unshift(0)
nodeStack.unshift(elem.children)}}}const Checks={tag_name(name){if(typeof name==="function")return elem=>isTag$1(elem)&&name(elem.name)
if(name==="*")return isTag$1
return elem=>isTag$1(elem)&&elem.name===name},tag_type(type){if(typeof type==="function")return elem=>type(elem.type)
return elem=>elem.type===type},tag_contains(data){if(typeof data==="function")return elem=>isText(elem)&&data(elem.data)
return elem=>isText(elem)&&elem.data===data}}
function getAttribCheck(attrib,value){if(typeof value==="function")return elem=>isTag$1(elem)&&value(elem.attribs[attrib])
return elem=>isTag$1(elem)&&elem.attribs[attrib]===value}function combineFuncs(a,b){return elem=>a(elem)||b(elem)}function compileTest(options){const funcs=Object.keys(options).map((key=>{const value=options[key]
return Object.prototype.hasOwnProperty.call(Checks,key)?Checks[key](value):getAttribCheck(key,value)}))
return funcs.length===0?null:funcs.reduce(combineFuncs)}function testElement(options,node){const test=compileTest(options)
return!test||test(node)}function getElements(options,nodes,recurse,limit=1/0){const test=compileTest(options)
return test?filter(test,nodes,recurse,limit):[]}function getElementById(id,nodes,recurse=true){Array.isArray(nodes)||(nodes=[nodes])
return findOne$1(getAttribCheck("id",id),nodes,recurse)}function getElementsByTagName(tagName,nodes,recurse=true,limit=1/0){return filter(Checks["tag_name"](tagName),nodes,recurse,limit)}function getElementsByTagType(type,nodes,recurse=true,limit=1/0){return filter(Checks["tag_type"](type),nodes,recurse,limit)}function removeSubsets(nodes){let idx=nodes.length
while(--idx>=0){const node=nodes[idx]
if(idx>0&&nodes.lastIndexOf(node,idx-1)>=0){nodes.splice(idx,1)
continue}for(let ancestor=node.parent;ancestor;ancestor=ancestor.parent)if(nodes.includes(ancestor)){nodes.splice(idx,1)
break}}return nodes}var DocumentPosition;(function(DocumentPosition){DocumentPosition[DocumentPosition["DISCONNECTED"]=1]="DISCONNECTED"
DocumentPosition[DocumentPosition["PRECEDING"]=2]="PRECEDING"
DocumentPosition[DocumentPosition["FOLLOWING"]=4]="FOLLOWING"
DocumentPosition[DocumentPosition["CONTAINS"]=8]="CONTAINS"
DocumentPosition[DocumentPosition["CONTAINED_BY"]=16]="CONTAINED_BY"})(DocumentPosition||(DocumentPosition={}))
function compareDocumentPosition(nodeA,nodeB){const aParents=[]
const bParents=[]
if(nodeA===nodeB)return 0
let current=hasChildren(nodeA)?nodeA:nodeA.parent
while(current){aParents.unshift(current)
current=current.parent}current=hasChildren(nodeB)?nodeB:nodeB.parent
while(current){bParents.unshift(current)
current=current.parent}const maxIdx=Math.min(aParents.length,bParents.length)
let idx=0
while(idx<maxIdx&&aParents[idx]===bParents[idx])idx++
if(idx===0)return DocumentPosition.DISCONNECTED
const sharedParent=aParents[idx-1]
const siblings=sharedParent.children
const aSibling=aParents[idx]
const bSibling=bParents[idx]
if(siblings.indexOf(aSibling)>siblings.indexOf(bSibling)){if(sharedParent===nodeB)return DocumentPosition.FOLLOWING|DocumentPosition.CONTAINED_BY
return DocumentPosition.FOLLOWING}if(sharedParent===nodeA)return DocumentPosition.PRECEDING|DocumentPosition.CONTAINS
return DocumentPosition.PRECEDING}function uniqueSort(nodes){nodes=nodes.filter(((node,i,arr)=>!arr.includes(node,i+1)))
nodes.sort(((a,b)=>{const relative=compareDocumentPosition(a,b)
if(relative&DocumentPosition.PRECEDING)return-1
if(relative&DocumentPosition.FOLLOWING)return 1
return 0}))
return nodes}function getFeed(doc){const feedRoot=getOneElement(isValidFeed,doc)
return feedRoot?feedRoot.name==="feed"?getAtomFeed(feedRoot):getRssFeed(feedRoot):null}function getAtomFeed(feedRoot){var _a
const childs=feedRoot.children
const feed={type:"atom",items:getElementsByTagName("entry",childs).map((item=>{var _a
const{children:children}=item
const entry={media:getMediaElements(children)}
addConditionally(entry,"id","id",children)
addConditionally(entry,"title","title",children)
const href=(_a=getOneElement("link",children))===null||_a===void 0?void 0:_a.attribs["href"]
href&&(entry.link=href)
const description=fetch("summary",children)||fetch("content",children)
description&&(entry.description=description)
const pubDate=fetch("updated",children)
pubDate&&(entry.pubDate=new Date(pubDate))
return entry}))}
addConditionally(feed,"id","id",childs)
addConditionally(feed,"title","title",childs)
const href=(_a=getOneElement("link",childs))===null||_a===void 0?void 0:_a.attribs["href"]
href&&(feed.link=href)
addConditionally(feed,"description","subtitle",childs)
const updated=fetch("updated",childs)
updated&&(feed.updated=new Date(updated))
addConditionally(feed,"author","email",childs,true)
return feed}function getRssFeed(feedRoot){var _a,_b
const childs=(_b=(_a=getOneElement("channel",feedRoot.children))===null||_a===void 0?void 0:_a.children)!==null&&_b!==void 0?_b:[]
const feed={type:feedRoot.name.substr(0,3),id:"",items:getElementsByTagName("item",feedRoot.children).map((item=>{const{children:children}=item
const entry={media:getMediaElements(children)}
addConditionally(entry,"id","guid",children)
addConditionally(entry,"title","title",children)
addConditionally(entry,"link","link",children)
addConditionally(entry,"description","description",children)
const pubDate=fetch("pubDate",children)||fetch("dc:date",children)
pubDate&&(entry.pubDate=new Date(pubDate))
return entry}))}
addConditionally(feed,"title","title",childs)
addConditionally(feed,"link","link",childs)
addConditionally(feed,"description","description",childs)
const updated=fetch("lastBuildDate",childs)
updated&&(feed.updated=new Date(updated))
addConditionally(feed,"author","managingEditor",childs,true)
return feed}const MEDIA_KEYS_STRING=["url","type","lang"]
const MEDIA_KEYS_INT=["fileSize","bitrate","framerate","samplingrate","channels","duration","height","width"]
function getMediaElements(where){return getElementsByTagName("media:content",where).map((elem=>{const{attribs:attribs}=elem
const media={medium:attribs["medium"],isDefault:!!attribs["isDefault"]}
for(const attrib of MEDIA_KEYS_STRING)attribs[attrib]&&(media[attrib]=attribs[attrib])
for(const attrib of MEDIA_KEYS_INT)attribs[attrib]&&(media[attrib]=parseInt(attribs[attrib],10))
attribs["expression"]&&(media.expression=attribs["expression"])
return media}))}function getOneElement(tagName,node){return getElementsByTagName(tagName,node,true,1)[0]}function fetch(tagName,where,recurse=false){return textContent(getElementsByTagName(tagName,where,recurse,1)).trim()}function addConditionally(obj,prop,tagName,where,recurse=false){const val=fetch(tagName,where,recurse)
val&&(obj[prop]=val)}function isValidFeed(value){return value==="rss"||value==="feed"||value==="rdf:RDF"}var DomUtils=Object.freeze({__proto__:null,get DocumentPosition(){return DocumentPosition},append:append$1,appendChild:appendChild,compareDocumentPosition:compareDocumentPosition,existsOne:existsOne$1,filter:filter,find:find$3,findAll:findAll$4,findOne:findOne$1,findOneChild:findOneChild,getAttributeValue:getAttributeValue$1,getChildren:getChildren$1,getElementById:getElementById,getElements:getElements,getElementsByTagName:getElementsByTagName,getElementsByTagType:getElementsByTagType,getFeed:getFeed,getInnerHTML:getInnerHTML,getName:getName$1,getOuterHTML:getOuterHTML,getParent:getParent,getSiblings:getSiblings,getText:getText$1,hasAttrib:hasAttrib$1,hasChildren:hasChildren,innerText:innerText,isCDATA:isCDATA,isComment:isComment,isDocument:isDocument,isTag:isTag$1,isText:isText,nextElementSibling:nextElementSibling,prepend:prepend,prependChild:prependChild,prevElementSibling:prevElementSibling,removeElement:removeElement,removeSubsets:removeSubsets,replaceElement:replaceElement,testElement:testElement,textContent:textContent,uniqueSort:uniqueSort})
function getDefaultExportFromCjs(x){return x&&x.__esModule&&Object.prototype.hasOwnProperty.call(x,"default")?x["default"]:x}var boolbase={trueFunc:function trueFunc(){return true},falseFunc:function falseFunc(){return false}}
var boolbase$1=getDefaultExportFromCjs(boolbase)
var SelectorType;(function(SelectorType){SelectorType["Attribute"]="attribute"
SelectorType["Pseudo"]="pseudo"
SelectorType["PseudoElement"]="pseudo-element"
SelectorType["Tag"]="tag"
SelectorType["Universal"]="universal"
SelectorType["Adjacent"]="adjacent"
SelectorType["Child"]="child"
SelectorType["Descendant"]="descendant"
SelectorType["Parent"]="parent"
SelectorType["Sibling"]="sibling"
SelectorType["ColumnCombinator"]="column-combinator"})(SelectorType||(SelectorType={}))
var AttributeAction;(function(AttributeAction){AttributeAction["Any"]="any"
AttributeAction["Element"]="element"
AttributeAction["End"]="end"
AttributeAction["Equals"]="equals"
AttributeAction["Exists"]="exists"
AttributeAction["Hyphen"]="hyphen"
AttributeAction["Not"]="not"
AttributeAction["Start"]="start"})(AttributeAction||(AttributeAction={}))
const reName=/^[^\\#]?(?:\\(?:[\da-f]{1,6}\s?|.)|[\w\-\u00b0-\uFFFF])+/
const reEscape=/\\([\da-f]{1,6}\s?|(\s)|.)/gi
const actionTypes=new Map([[126,AttributeAction.Element],[94,AttributeAction.Start],[36,AttributeAction.End],[42,AttributeAction.Any],[33,AttributeAction.Not],[124,AttributeAction.Hyphen]])
const unpackPseudos=new Set(["has","not","matches","is","where","host","host-context"])
function isTraversal$1(selector){switch(selector.type){case SelectorType.Adjacent:case SelectorType.Child:case SelectorType.Descendant:case SelectorType.Parent:case SelectorType.Sibling:case SelectorType.ColumnCombinator:return true
default:return false}}const stripQuotesFromPseudos=new Set(["contains","icontains"])
function funescape(_,escaped,escapedWhitespace){const high=parseInt(escaped,16)-0x10000
return high!==high||escapedWhitespace?escaped:high<0?String.fromCharCode(high+0x10000):String.fromCharCode(high>>10|0xd800,high&0x3ff|0xdc00)}function unescapeCSS(str){return str.replace(reEscape,funescape)}function isQuote(c){return c===39||c===34}function isWhitespace(c){return c===32||c===9||c===10||c===12||c===13}function parse$1w(selector){const subselects=[]
const endIndex=parseSelector(subselects,`${selector}`,0)
if(endIndex<selector.length)throw new Error(`Unmatched selector: ${selector.slice(endIndex)}`)
return subselects}function parseSelector(subselects,selector,selectorIndex){let tokens=[]
function getName(offset){const match=selector.slice(selectorIndex+offset).match(reName)
if(!match)throw new Error(`Expected name, found ${selector.slice(selectorIndex)}`)
const[name]=match
selectorIndex+=offset+name.length
return unescapeCSS(name)}function stripWhitespace(offset){selectorIndex+=offset
while(selectorIndex<selector.length&&isWhitespace(selector.charCodeAt(selectorIndex)))selectorIndex++}function readValueWithParenthesis(){selectorIndex+=1
const start=selectorIndex
let counter=1
for(;counter>0&&selectorIndex<selector.length;selectorIndex++)selector.charCodeAt(selectorIndex)!==40||isEscaped(selectorIndex)?selector.charCodeAt(selectorIndex)!==41||isEscaped(selectorIndex)||counter--:counter++
if(counter)throw new Error("Parenthesis not matched")
return unescapeCSS(selector.slice(start,selectorIndex-1))}function isEscaped(pos){let slashCount=0
while(selector.charCodeAt(--pos)===92)slashCount++
return(slashCount&1)===1}function ensureNotTraversal(){if(tokens.length>0&&isTraversal$1(tokens[tokens.length-1]))throw new Error("Did not expect successive traversals.")}function addTraversal(type){if(tokens.length>0&&tokens[tokens.length-1].type===SelectorType.Descendant){tokens[tokens.length-1].type=type
return}ensureNotTraversal()
tokens.push({type:type})}function addSpecialAttribute(name,action){tokens.push({type:SelectorType.Attribute,name:name,action:action,value:getName(1),namespace:null,ignoreCase:"quirks"})}function finalizeSubselector(){tokens.length&&tokens[tokens.length-1].type===SelectorType.Descendant&&tokens.pop()
if(tokens.length===0)throw new Error("Empty sub-selector")
subselects.push(tokens)}stripWhitespace(0)
if(selector.length===selectorIndex)return selectorIndex
loop:while(selectorIndex<selector.length){const firstChar=selector.charCodeAt(selectorIndex)
switch(firstChar){case 32:case 9:case 10:case 12:case 13:if(tokens.length===0||tokens[0].type!==SelectorType.Descendant){ensureNotTraversal()
tokens.push({type:SelectorType.Descendant})}stripWhitespace(1)
break
case 62:addTraversal(SelectorType.Child)
stripWhitespace(1)
break
case 60:addTraversal(SelectorType.Parent)
stripWhitespace(1)
break
case 126:addTraversal(SelectorType.Sibling)
stripWhitespace(1)
break
case 43:addTraversal(SelectorType.Adjacent)
stripWhitespace(1)
break
case 46:addSpecialAttribute("class",AttributeAction.Element)
break
case 35:addSpecialAttribute("id",AttributeAction.Equals)
break
case 91:{stripWhitespace(1)
let name
let namespace=null
if(selector.charCodeAt(selectorIndex)===124)name=getName(1)
else if(selector.startsWith("*|",selectorIndex)){namespace="*"
name=getName(2)}else{name=getName(0)
if(selector.charCodeAt(selectorIndex)===124&&selector.charCodeAt(selectorIndex+1)!==61){namespace=name
name=getName(1)}}stripWhitespace(0)
let action=AttributeAction.Exists
const possibleAction=actionTypes.get(selector.charCodeAt(selectorIndex))
if(possibleAction){action=possibleAction
if(selector.charCodeAt(selectorIndex+1)!==61)throw new Error("Expected `=`")
stripWhitespace(2)}else if(selector.charCodeAt(selectorIndex)===61){action=AttributeAction.Equals
stripWhitespace(1)}let value=""
let ignoreCase=null
if(action!=="exists"){if(isQuote(selector.charCodeAt(selectorIndex))){const quote=selector.charCodeAt(selectorIndex)
let sectionEnd=selectorIndex+1
while(sectionEnd<selector.length&&(selector.charCodeAt(sectionEnd)!==quote||isEscaped(sectionEnd)))sectionEnd+=1
if(selector.charCodeAt(sectionEnd)!==quote)throw new Error("Attribute value didn't end")
value=unescapeCSS(selector.slice(selectorIndex+1,sectionEnd))
selectorIndex=sectionEnd+1}else{const valueStart=selectorIndex
while(selectorIndex<selector.length&&(!isWhitespace(selector.charCodeAt(selectorIndex))&&selector.charCodeAt(selectorIndex)!==93||isEscaped(selectorIndex)))selectorIndex+=1
value=unescapeCSS(selector.slice(valueStart,selectorIndex))}stripWhitespace(0)
const forceIgnore=selector.charCodeAt(selectorIndex)|0x20
if(forceIgnore===115){ignoreCase=false
stripWhitespace(1)}else if(forceIgnore===105){ignoreCase=true
stripWhitespace(1)}}if(selector.charCodeAt(selectorIndex)!==93)throw new Error("Attribute selector didn't terminate")
selectorIndex+=1
const attributeSelector={type:SelectorType.Attribute,name:name,action:action,value:value,namespace:namespace,ignoreCase:ignoreCase}
tokens.push(attributeSelector)
break}case 58:{if(selector.charCodeAt(selectorIndex+1)===58){tokens.push({type:SelectorType.PseudoElement,name:getName(2).toLowerCase(),data:selector.charCodeAt(selectorIndex)===40?readValueWithParenthesis():null})
continue}const name=getName(1).toLowerCase()
let data=null
if(selector.charCodeAt(selectorIndex)===40)if(unpackPseudos.has(name)){if(isQuote(selector.charCodeAt(selectorIndex+1)))throw new Error(`Pseudo-selector ${name} cannot be quoted`)
data=[]
selectorIndex=parseSelector(data,selector,selectorIndex+1)
if(selector.charCodeAt(selectorIndex)!==41)throw new Error(`Missing closing parenthesis in :${name} (${selector})`)
selectorIndex+=1}else{data=readValueWithParenthesis()
if(stripQuotesFromPseudos.has(name)){const quot=data.charCodeAt(0)
quot===data.charCodeAt(data.length-1)&&isQuote(quot)&&(data=data.slice(1,-1))}data=unescapeCSS(data)}tokens.push({type:SelectorType.Pseudo,name:name,data:data})
break}case 44:finalizeSubselector()
tokens=[]
stripWhitespace(1)
break
default:{if(selector.startsWith("/*",selectorIndex)){const endIndex=selector.indexOf("*/",selectorIndex+2)
if(endIndex<0)throw new Error("Comment was not terminated")
selectorIndex=endIndex+2
tokens.length===0&&stripWhitespace(0)
break}let namespace=null
let name
if(firstChar===42){selectorIndex+=1
name="*"}else if(firstChar===124){name=""
if(selector.charCodeAt(selectorIndex+1)===124){addTraversal(SelectorType.ColumnCombinator)
stripWhitespace(2)
break}}else{if(!reName.test(selector.slice(selectorIndex)))break loop
name=getName(0)}if(selector.charCodeAt(selectorIndex)===124&&selector.charCodeAt(selectorIndex+1)!==124){namespace=name
if(selector.charCodeAt(selectorIndex+1)===42){name="*"
selectorIndex+=2}else name=getName(1)}tokens.push(name==="*"?{type:SelectorType.Universal,namespace:namespace}:{type:SelectorType.Tag,name:name,namespace:namespace})}}}finalizeSubselector()
return selectorIndex}const procedure=new Map([[SelectorType.Universal,50],[SelectorType.Tag,30],[SelectorType.Attribute,1],[SelectorType.Pseudo,0]])
function isTraversal(token){return!procedure.has(token.type)}const attributes=new Map([[AttributeAction.Exists,10],[AttributeAction.Equals,8],[AttributeAction.Not,7],[AttributeAction.Start,6],[AttributeAction.End,6],[AttributeAction.Any,5]])
function sortByProcedure(arr){const procs=arr.map(getProcedure)
for(let i=1;i<arr.length;i++){const procNew=procs[i]
if(procNew<0)continue
for(let j=i-1;j>=0&&procNew<procs[j];j--){const token=arr[j+1]
arr[j+1]=arr[j]
arr[j]=token
procs[j+1]=procs[j]
procs[j]=procNew}}}function getProcedure(token){var _a,_b
let proc=(_a=procedure.get(token.type))!==null&&_a!==void 0?_a:-1
if(token.type===SelectorType.Attribute){proc=(_b=attributes.get(token.action))!==null&&_b!==void 0?_b:4
token.action===AttributeAction.Equals&&token.name==="id"&&(proc=9)
token.ignoreCase&&(proc>>=1)}else if(token.type===SelectorType.Pseudo)if(token.data)if(token.name==="has"||token.name==="contains")proc=0
else if(Array.isArray(token.data)){proc=Math.min(...token.data.map((d=>Math.min(...d.map(getProcedure)))))
proc<0&&(proc=0)}else proc=2
else proc=3
return proc}const reChars=/[-[\]{}()*+?.,\\^$|#\s]/g
function escapeRegex(value){return value.replace(reChars,"\\$&")}const caseInsensitiveAttributes=new Set(["accept","accept-charset","align","alink","axis","bgcolor","charset","checked","clear","codetype","color","compact","declare","defer","dir","direction","disabled","enctype","face","frame","hreflang","http-equiv","lang","language","link","media","method","multiple","nohref","noresize","noshade","nowrap","readonly","rel","rev","rules","scope","scrolling","selected","shape","target","text","type","valign","valuetype","vlink"])
function shouldIgnoreCase(selector,options){return typeof selector.ignoreCase==="boolean"?selector.ignoreCase:selector.ignoreCase==="quirks"?!!options.quirksMode:!options.xmlMode&&caseInsensitiveAttributes.has(selector.name)}const attributeRules={equals(next,data,options){const{adapter:adapter}=options
const{name:name}=data
let{value:value}=data
if(shouldIgnoreCase(data,options)){value=value.toLowerCase()
return elem=>{const attr=adapter.getAttributeValue(elem,name)
return attr!=null&&attr.length===value.length&&attr.toLowerCase()===value&&next(elem)}}return elem=>adapter.getAttributeValue(elem,name)===value&&next(elem)},hyphen(next,data,options){const{adapter:adapter}=options
const{name:name}=data
let{value:value}=data
const len=value.length
if(shouldIgnoreCase(data,options)){value=value.toLowerCase()
return function hyphenIC(elem){const attr=adapter.getAttributeValue(elem,name)
return attr!=null&&(attr.length===len||attr.charAt(len)==="-")&&attr.substr(0,len).toLowerCase()===value&&next(elem)}}return function hyphen(elem){const attr=adapter.getAttributeValue(elem,name)
return attr!=null&&(attr.length===len||attr.charAt(len)==="-")&&attr.substr(0,len)===value&&next(elem)}},element(next,data,options){const{adapter:adapter}=options
const{name:name,value:value}=data
if(/\s/.test(value))return boolbase$1.falseFunc
const regex=new RegExp(`(?:^|\\s)${escapeRegex(value)}(?:$|\\s)`,shouldIgnoreCase(data,options)?"i":"")
return function element(elem){const attr=adapter.getAttributeValue(elem,name)
return attr!=null&&attr.length>=value.length&&regex.test(attr)&&next(elem)}},exists:(next,{name:name},{adapter:adapter})=>elem=>adapter.hasAttrib(elem,name)&&next(elem),start(next,data,options){const{adapter:adapter}=options
const{name:name}=data
let{value:value}=data
const len=value.length
if(len===0)return boolbase$1.falseFunc
if(shouldIgnoreCase(data,options)){value=value.toLowerCase()
return elem=>{const attr=adapter.getAttributeValue(elem,name)
return attr!=null&&attr.length>=len&&attr.substr(0,len).toLowerCase()===value&&next(elem)}}return elem=>{var _a
return!!((_a=adapter.getAttributeValue(elem,name))===null||_a===void 0?void 0:_a.startsWith(value))&&next(elem)}},end(next,data,options){const{adapter:adapter}=options
const{name:name}=data
let{value:value}=data
const len=-value.length
if(len===0)return boolbase$1.falseFunc
if(shouldIgnoreCase(data,options)){value=value.toLowerCase()
return elem=>{var _a
return((_a=adapter.getAttributeValue(elem,name))===null||_a===void 0?void 0:_a.substr(len).toLowerCase())===value&&next(elem)}}return elem=>{var _a
return!!((_a=adapter.getAttributeValue(elem,name))===null||_a===void 0?void 0:_a.endsWith(value))&&next(elem)}},any(next,data,options){const{adapter:adapter}=options
const{name:name,value:value}=data
if(value==="")return boolbase$1.falseFunc
if(shouldIgnoreCase(data,options)){const regex=new RegExp(escapeRegex(value),"i")
return function anyIC(elem){const attr=adapter.getAttributeValue(elem,name)
return attr!=null&&attr.length>=value.length&&regex.test(attr)&&next(elem)}}return elem=>{var _a
return!!((_a=adapter.getAttributeValue(elem,name))===null||_a===void 0?void 0:_a.includes(value))&&next(elem)}},not(next,data,options){const{adapter:adapter}=options
const{name:name}=data
let{value:value}=data
if(value==="")return elem=>!!adapter.getAttributeValue(elem,name)&&next(elem)
if(shouldIgnoreCase(data,options)){value=value.toLowerCase()
return elem=>{const attr=adapter.getAttributeValue(elem,name)
return(attr==null||attr.length!==value.length||attr.toLowerCase()!==value)&&next(elem)}}return elem=>adapter.getAttributeValue(elem,name)!==value&&next(elem)}}
const whitespace=new Set([9,10,12,13,32])
const ZERO="0".charCodeAt(0)
const NINE="9".charCodeAt(0)
function parse$1v(formula){formula=formula.trim().toLowerCase()
if(formula==="even")return[2,0]
if(formula==="odd")return[2,1]
let idx=0
let a=0
let sign=readSign()
let number=readNumber()
if(idx<formula.length&&formula.charAt(idx)==="n"){idx++
a=sign*(number!==null&&number!==void 0?number:1)
skipWhitespace()
if(idx<formula.length){sign=readSign()
skipWhitespace()
number=readNumber()}else sign=number=0}if(number===null||idx<formula.length)throw new Error(`n-th rule couldn't be parsed ('${formula}')`)
return[a,sign*number]
function readSign(){if(formula.charAt(idx)==="-"){idx++
return-1}formula.charAt(idx)==="+"&&idx++
return 1}function readNumber(){const start=idx
let value=0
while(idx<formula.length&&formula.charCodeAt(idx)>=ZERO&&formula.charCodeAt(idx)<=NINE){value=value*10+(formula.charCodeAt(idx)-ZERO)
idx++}return idx===start?null:value}function skipWhitespace(){while(idx<formula.length&&whitespace.has(formula.charCodeAt(idx)))idx++}}function compile$1(parsed){const a=parsed[0]
const b=parsed[1]-1
if(b<0&&a<=0)return boolbase$1.falseFunc
if(a===-1)return index=>index<=b
if(a===0)return index=>index===b
if(a===1)return b<0?boolbase$1.trueFunc:index=>index>=b
const absA=Math.abs(a)
const bMod=(b%absA+absA)%absA
return a>1?index=>index>=b&&index%absA===bMod:index=>index<=b&&index%absA===bMod}function nthCheck(formula){return compile$1(parse$1v(formula))}function getChildFunc(next,adapter){return elem=>{const parent=adapter.getParent(elem)
return parent!=null&&adapter.isTag(parent)&&next(elem)}}const filters$1={contains:(next,text,{adapter:adapter})=>function contains(elem){return next(elem)&&adapter.getText(elem).includes(text)},icontains(next,text,{adapter:adapter}){const itext=text.toLowerCase()
return function icontains(elem){return next(elem)&&adapter.getText(elem).toLowerCase().includes(itext)}},"nth-child"(next,rule,{adapter:adapter,equals:equals}){const func=nthCheck(rule)
if(func===boolbase$1.falseFunc)return boolbase$1.falseFunc
if(func===boolbase$1.trueFunc)return getChildFunc(next,adapter)
return function nthChild(elem){const siblings=adapter.getSiblings(elem)
let pos=0
for(let i=0;i<siblings.length;i++){if(equals(elem,siblings[i]))break
adapter.isTag(siblings[i])&&pos++}return func(pos)&&next(elem)}},"nth-last-child"(next,rule,{adapter:adapter,equals:equals}){const func=nthCheck(rule)
if(func===boolbase$1.falseFunc)return boolbase$1.falseFunc
if(func===boolbase$1.trueFunc)return getChildFunc(next,adapter)
return function nthLastChild(elem){const siblings=adapter.getSiblings(elem)
let pos=0
for(let i=siblings.length-1;i>=0;i--){if(equals(elem,siblings[i]))break
adapter.isTag(siblings[i])&&pos++}return func(pos)&&next(elem)}},"nth-of-type"(next,rule,{adapter:adapter,equals:equals}){const func=nthCheck(rule)
if(func===boolbase$1.falseFunc)return boolbase$1.falseFunc
if(func===boolbase$1.trueFunc)return getChildFunc(next,adapter)
return function nthOfType(elem){const siblings=adapter.getSiblings(elem)
let pos=0
for(let i=0;i<siblings.length;i++){const currentSibling=siblings[i]
if(equals(elem,currentSibling))break
adapter.isTag(currentSibling)&&adapter.getName(currentSibling)===adapter.getName(elem)&&pos++}return func(pos)&&next(elem)}},"nth-last-of-type"(next,rule,{adapter:adapter,equals:equals}){const func=nthCheck(rule)
if(func===boolbase$1.falseFunc)return boolbase$1.falseFunc
if(func===boolbase$1.trueFunc)return getChildFunc(next,adapter)
return function nthLastOfType(elem){const siblings=adapter.getSiblings(elem)
let pos=0
for(let i=siblings.length-1;i>=0;i--){const currentSibling=siblings[i]
if(equals(elem,currentSibling))break
adapter.isTag(currentSibling)&&adapter.getName(currentSibling)===adapter.getName(elem)&&pos++}return func(pos)&&next(elem)}},root:(next,_rule,{adapter:adapter})=>elem=>{const parent=adapter.getParent(elem)
return(parent==null||!adapter.isTag(parent))&&next(elem)},scope(next,rule,options,context){const{equals:equals}=options
if(!context||context.length===0)return filters$1["root"](next,rule,options)
if(context.length===1)return elem=>equals(context[0],elem)&&next(elem)
return elem=>context.includes(elem)&&next(elem)},hover:dynamicStatePseudo("isHovered"),visited:dynamicStatePseudo("isVisited"),active:dynamicStatePseudo("isActive")}
function dynamicStatePseudo(name){return function dynamicPseudo(next,_rule,{adapter:adapter}){const func=adapter[name]
if(typeof func!=="function")return boolbase$1.falseFunc
return function active(elem){return func(elem)&&next(elem)}}}const pseudos={empty:(elem,{adapter:adapter})=>!adapter.getChildren(elem).some((elem=>adapter.isTag(elem)||adapter.getText(elem)!=="")),"first-child"(elem,{adapter:adapter,equals:equals}){if(adapter.prevElementSibling)return adapter.prevElementSibling(elem)==null
const firstChild=adapter.getSiblings(elem).find((elem=>adapter.isTag(elem)))
return firstChild!=null&&equals(elem,firstChild)},"last-child"(elem,{adapter:adapter,equals:equals}){const siblings=adapter.getSiblings(elem)
for(let i=siblings.length-1;i>=0;i--){if(equals(elem,siblings[i]))return true
if(adapter.isTag(siblings[i]))break}return false},"first-of-type"(elem,{adapter:adapter,equals:equals}){const siblings=adapter.getSiblings(elem)
const elemName=adapter.getName(elem)
for(let i=0;i<siblings.length;i++){const currentSibling=siblings[i]
if(equals(elem,currentSibling))return true
if(adapter.isTag(currentSibling)&&adapter.getName(currentSibling)===elemName)break}return false},"last-of-type"(elem,{adapter:adapter,equals:equals}){const siblings=adapter.getSiblings(elem)
const elemName=adapter.getName(elem)
for(let i=siblings.length-1;i>=0;i--){const currentSibling=siblings[i]
if(equals(elem,currentSibling))return true
if(adapter.isTag(currentSibling)&&adapter.getName(currentSibling)===elemName)break}return false},"only-of-type"(elem,{adapter:adapter,equals:equals}){const elemName=adapter.getName(elem)
return adapter.getSiblings(elem).every((sibling=>equals(elem,sibling)||!adapter.isTag(sibling)||adapter.getName(sibling)!==elemName))},"only-child":(elem,{adapter:adapter,equals:equals})=>adapter.getSiblings(elem).every((sibling=>equals(elem,sibling)||!adapter.isTag(sibling)))}
function verifyPseudoArgs(func,name,subselect,argIndex){if(subselect===null){if(func.length>argIndex)throw new Error(`Pseudo-class :${name} requires an argument`)}else if(func.length===argIndex)throw new Error(`Pseudo-class :${name} doesn't have any arguments`)}const aliases={"any-link":":is(a, area, link)[href]",link:":any-link:not(:visited)",disabled:":is(\n        :is(button, input, select, textarea, optgroup, option)[disabled],\n        optgroup[disabled] > option,\n        fieldset[disabled]:not(fieldset[disabled] legend:first-of-type *)\n    )",enabled:":not(:disabled)",checked:":is(:is(input[type=radio], input[type=checkbox])[checked], option:selected)",required:":is(input, select, textarea)[required]",optional:":is(input, select, textarea):not([required])",selected:"option:is([selected], select:not([multiple]):not(:has(> option[selected])) > :first-of-type)",checkbox:"[type=checkbox]",file:"[type=file]",password:"[type=password]",radio:"[type=radio]",reset:"[type=reset]",image:"[type=image]",submit:"[type=submit]",parent:":not(:empty)",header:":is(h1, h2, h3, h4, h5, h6)",button:":is(button, input[type=button])",input:":is(input, textarea, select, button)",text:"input:is(:not([type!='']), [type=text])"}
const PLACEHOLDER_ELEMENT={}
function ensureIsTag(next,adapter){if(next===boolbase$1.falseFunc)return boolbase$1.falseFunc
return elem=>adapter.isTag(elem)&&next(elem)}function getNextSiblings(elem,adapter){const siblings=adapter.getSiblings(elem)
if(siblings.length<=1)return[]
const elemIndex=siblings.indexOf(elem)
if(elemIndex<0||elemIndex===siblings.length-1)return[]
return siblings.slice(elemIndex+1).filter(adapter.isTag)}function copyOptions(options){return{xmlMode:!!options.xmlMode,lowerCaseAttributeNames:!!options.lowerCaseAttributeNames,lowerCaseTags:!!options.lowerCaseTags,quirksMode:!!options.quirksMode,cacheResults:!!options.cacheResults,pseudos:options.pseudos,adapter:options.adapter,equals:options.equals}}const is$1=(next,token,options,context,compileToken)=>{const func=compileToken(token,copyOptions(options),context)
return func===boolbase$1.trueFunc?next:func===boolbase$1.falseFunc?boolbase$1.falseFunc:elem=>func(elem)&&next(elem)}
const subselects={is:is$1,matches:is$1,where:is$1,not(next,token,options,context,compileToken){const func=compileToken(token,copyOptions(options),context)
return func===boolbase$1.falseFunc?next:func===boolbase$1.trueFunc?boolbase$1.falseFunc:elem=>!func(elem)&&next(elem)},has(next,subselect,options,_context,compileToken){const{adapter:adapter}=options
const opts=copyOptions(options)
opts.relativeSelector=true
const context=subselect.some((s=>s.some(isTraversal)))?[PLACEHOLDER_ELEMENT]:void 0
const compiled=compileToken(subselect,opts,context)
if(compiled===boolbase$1.falseFunc)return boolbase$1.falseFunc
const hasElement=ensureIsTag(compiled,adapter)
if(context&&compiled!==boolbase$1.trueFunc){const{shouldTestNextSiblings:shouldTestNextSiblings=false}=compiled
return elem=>{if(!next(elem))return false
context[0]=elem
const childs=adapter.getChildren(elem)
const nextElements=shouldTestNextSiblings?[...childs,...getNextSiblings(elem,adapter)]:childs
return adapter.existsOne(hasElement,nextElements)}}return elem=>next(elem)&&adapter.existsOne(hasElement,adapter.getChildren(elem))}}
function compilePseudoSelector(next,selector,options,context,compileToken){var _a
const{name:name,data:data}=selector
if(Array.isArray(data)){if(!(name in subselects))throw new Error(`Unknown pseudo-class :${name}(${data})`)
return subselects[name](next,data,options,context,compileToken)}const userPseudo=(_a=options.pseudos)===null||_a===void 0?void 0:_a[name]
const stringPseudo=typeof userPseudo==="string"?userPseudo:aliases[name]
if(typeof stringPseudo==="string"){if(data!=null)throw new Error(`Pseudo ${name} doesn't have any arguments`)
const alias=parse$1w(stringPseudo)
return subselects["is"](next,alias,options,context,compileToken)}if(typeof userPseudo==="function"){verifyPseudoArgs(userPseudo,name,data,1)
return elem=>userPseudo(elem,data)&&next(elem)}if(name in filters$1)return filters$1[name](next,data,options,context)
if(name in pseudos){const pseudo=pseudos[name]
verifyPseudoArgs(pseudo,name,data,2)
return elem=>pseudo(elem,options,data)&&next(elem)}throw new Error(`Unknown pseudo-class :${name}`)}function getElementParent(node,adapter){const parent=adapter.getParent(node)
if(parent&&adapter.isTag(parent))return parent
return null}function compileGeneralSelector(next,selector,options,context,compileToken){const{adapter:adapter,equals:equals}=options
switch(selector.type){case SelectorType.PseudoElement:throw new Error("Pseudo-elements are not supported by css-select")
case SelectorType.ColumnCombinator:throw new Error("Column combinators are not yet supported by css-select")
case SelectorType.Attribute:if(selector.namespace!=null)throw new Error("Namespaced attributes are not yet supported by css-select")
options.xmlMode&&!options.lowerCaseAttributeNames||(selector.name=selector.name.toLowerCase())
return attributeRules[selector.action](next,selector,options)
case SelectorType.Pseudo:return compilePseudoSelector(next,selector,options,context,compileToken)
case SelectorType.Tag:{if(selector.namespace!=null)throw new Error("Namespaced tag names are not yet supported by css-select")
let{name:name}=selector
options.xmlMode&&!options.lowerCaseTags||(name=name.toLowerCase())
return function tag(elem){return adapter.getName(elem)===name&&next(elem)}}case SelectorType.Descendant:{if(options.cacheResults===false||typeof WeakSet==="undefined")return function descendant(elem){let current=elem
while(current=getElementParent(current,adapter))if(next(current))return true
return false}
const isFalseCache=new WeakSet
return function cachedDescendant(elem){let current=elem
while(current=getElementParent(current,adapter))if(!isFalseCache.has(current)){if(adapter.isTag(current)&&next(current))return true
isFalseCache.add(current)}return false}}case"_flexibleDescendant":return function flexibleDescendant(elem){let current=elem
do{if(next(current))return true}while(current=getElementParent(current,adapter))
return false}
case SelectorType.Parent:return function parent(elem){return adapter.getChildren(elem).some((elem=>adapter.isTag(elem)&&next(elem)))}
case SelectorType.Child:return function child(elem){const parent=adapter.getParent(elem)
return parent!=null&&adapter.isTag(parent)&&next(parent)}
case SelectorType.Sibling:return function sibling(elem){const siblings=adapter.getSiblings(elem)
for(let i=0;i<siblings.length;i++){const currentSibling=siblings[i]
if(equals(elem,currentSibling))break
if(adapter.isTag(currentSibling)&&next(currentSibling))return true}return false}
case SelectorType.Adjacent:if(adapter.prevElementSibling)return function adjacent(elem){const previous=adapter.prevElementSibling(elem)
return previous!=null&&next(previous)}
return function adjacent(elem){const siblings=adapter.getSiblings(elem)
let lastElement
for(let i=0;i<siblings.length;i++){const currentSibling=siblings[i]
if(equals(elem,currentSibling))break
adapter.isTag(currentSibling)&&(lastElement=currentSibling)}return!!lastElement&&next(lastElement)}
case SelectorType.Universal:if(selector.namespace!=null&&selector.namespace!=="*")throw new Error("Namespaced universal selectors are not yet supported by css-select")
return next}}function compile(selector,options,context){const next=compileUnsafe(selector,options,context)
return ensureIsTag(next,options.adapter)}function compileUnsafe(selector,options,context){const token=typeof selector==="string"?parse$1w(selector):selector
return compileToken(token,options,context)}function includesScopePseudo(t){return t.type===SelectorType.Pseudo&&(t.name==="scope"||Array.isArray(t.data)&&t.data.some((data=>data.some(includesScopePseudo))))}const DESCENDANT_TOKEN={type:SelectorType.Descendant}
const FLEXIBLE_DESCENDANT_TOKEN={type:"_flexibleDescendant"}
const SCOPE_TOKEN={type:SelectorType.Pseudo,name:"scope",data:null}
function absolutize(token,{adapter:adapter},context){const hasContext=!!(context===null||context===void 0?void 0:context.every((e=>{const parent=adapter.isTag(e)&&adapter.getParent(e)
return e===PLACEHOLDER_ELEMENT||parent&&adapter.isTag(parent)})))
for(const t of token){if(t.length>0&&isTraversal(t[0])&&t[0].type!==SelectorType.Descendant);else{if(!hasContext||t.some(includesScopePseudo))continue
t.unshift(DESCENDANT_TOKEN)}t.unshift(SCOPE_TOKEN)}}function compileToken(token,options,context){var _a
token.forEach(sortByProcedure)
context=(_a=options.context)!==null&&_a!==void 0?_a:context
const isArrayContext=Array.isArray(context)
const finalContext=context&&(Array.isArray(context)?context:[context])
if(options.relativeSelector!==false)absolutize(token,options,finalContext)
else if(token.some((t=>t.length>0&&isTraversal(t[0]))))throw new Error("Relative selectors are not allowed when the `relativeSelector` option is disabled")
let shouldTestNextSiblings=false
const query=token.map((rules=>{if(rules.length>=2){const[first,second]=rules
first.type!==SelectorType.Pseudo||first.name!=="scope"||(isArrayContext&&second.type===SelectorType.Descendant?rules[1]=FLEXIBLE_DESCENDANT_TOKEN:second.type!==SelectorType.Adjacent&&second.type!==SelectorType.Sibling||(shouldTestNextSiblings=true))}return compileRules(rules,options,finalContext)})).reduce(reduceRules,boolbase$1.falseFunc)
query.shouldTestNextSiblings=shouldTestNextSiblings
return query}function compileRules(rules,options,context){var _a
return rules.reduce(((previous,rule)=>previous===boolbase$1.falseFunc?boolbase$1.falseFunc:compileGeneralSelector(previous,rule,options,context,compileToken)),(_a=options.rootFunc)!==null&&_a!==void 0?_a:boolbase$1.trueFunc)}function reduceRules(a,b){if(b===boolbase$1.falseFunc||a===boolbase$1.trueFunc)return a
if(a===boolbase$1.falseFunc||b===boolbase$1.trueFunc)return b
return function combine(elem){return a(elem)||b(elem)}}const defaultEquals=(a,b)=>a===b
const defaultOptions={adapter:DomUtils,equals:defaultEquals}
function convertOptionFormats(options){var _a,_b,_c,_d
const opts=options!==null&&options!==void 0?options:defaultOptions;(_a=opts.adapter)!==null&&_a!==void 0?_a:opts.adapter=DomUtils;(_b=opts.equals)!==null&&_b!==void 0?_b:opts.equals=(_d=(_c=opts.adapter)===null||_c===void 0?void 0:_c.equals)!==null&&_d!==void 0?_d:defaultEquals
return opts}function getSelectorFunc(searchFunc){return function select(query,elements,options){const opts=convertOptionFormats(options)
typeof query!=="function"&&(query=compileUnsafe(query,opts,elements))
const filteredElements=prepareContext(elements,opts.adapter,query.shouldTestNextSiblings)
return searchFunc(query,filteredElements,opts)}}function prepareContext(elems,adapter,shouldTestNextSiblings=false){shouldTestNextSiblings&&(elems=appendNextSiblings(elems,adapter))
return Array.isArray(elems)?adapter.removeSubsets(elems):adapter.getChildren(elems)}function appendNextSiblings(elem,adapter){const elems=Array.isArray(elem)?elem.slice(0):[elem]
const elemsLength=elems.length
for(let i=0;i<elemsLength;i++){const nextSiblings=getNextSiblings(elems[i],adapter)
elems.push(...nextSiblings)}return elems}const selectAll=getSelectorFunc(((query,elems,options)=>query!==boolbase$1.falseFunc&&elems&&elems.length!==0?options.adapter.findAll(query,elems):[]))
const selectOne=getSelectorFunc(((query,elems,options)=>query!==boolbase$1.falseFunc&&elems&&elems.length!==0?options.adapter.findOne(query,elems):null))
function is(elem,query,options){const opts=convertOptionFormats(options)
return(typeof query==="function"?query:compile(query,opts))(elem)}function mapNodesToParents(node){const parents=new Map
for(const child of node.children){parents.set(child,node)
visit(child,{element:{enter:(child,parent)=>{parents.set(child,parent)}}},node)}return parents}const isTag=node=>node.type==="element"
const existsOne=(test,elems)=>elems.some((elem=>isTag(elem)&&(test(elem)||existsOne(test,getChildren(elem)))))
const getAttributeValue=(elem,name)=>elem.attributes[name]
const getChildren=node=>node.children||[]
const getName=elemAst=>elemAst.name
const getText=node=>{if(node.children[0].type==="text"||node.children[0].type==="cdata")return node.children[0].value
return""}
const hasAttrib=(elem,name)=>elem.attributes[name]!==void 0
const findAll$3=(test,elems)=>{const result=[]
for(const elem of elems)if(isTag(elem)){test(elem)&&result.push(elem)
result.push(...findAll$3(test,getChildren(elem)))}return result}
const findOne=(test,elems)=>{for(const elem of elems)if(isTag(elem)){if(test(elem))return elem
const result=findOne(test,getChildren(elem))
if(result)return result}return null}
function createAdapter(relativeNode,parents){const getParent=node=>{parents||(parents=mapNodesToParents(relativeNode))
return parents.get(node)||null}
const getSiblings=elem=>{const parent=getParent(elem)
return parent?getChildren(parent):[]}
const removeSubsets=nodes=>{let idx=nodes.length
let node
let ancestor
let replace
while(--idx>-1){node=ancestor=nodes[idx]
nodes[idx]=null
replace=true
while(ancestor){if(nodes.includes(ancestor)){replace=false
nodes.splice(idx,1)
break}ancestor=getParent(ancestor)}replace&&(nodes[idx]=node)}return nodes}
return{isTag:isTag,existsOne:existsOne,getAttributeValue:getAttributeValue,getChildren:getChildren,getName:getName,getParent:getParent,getSiblings:getSiblings,getText:getText,hasAttrib:hasAttrib,removeSubsets:removeSubsets,findAll:findAll$3,findOne:findOne}}function createCssSelectOptions(relativeNode,parents){return{xmlMode:true,adapter:createAdapter(relativeNode,parents)}}const querySelectorAll=(node,selector,parents)=>selectAll(selector,node,createCssSelectOptions(node,parents))
const querySelector=(node,selector,parents)=>selectOne(selector,node,createCssSelectOptions(node,parents))
const matches=(node,selector,parents)=>is(node,selector,createCssSelectOptions(node,parents))
const detachNodeFromParent=(node,parentNode)=>{parentNode.children=parentNode.children.filter((child=>child!==node))}
const name$2d="removeDoctype"
const description$Q="removes doctype declaration"
const fn$Q=()=>({doctype:{enter:(node,parentNode)=>{detachNodeFromParent(node,parentNode)}}})
var removeDoctype=Object.freeze({__proto__:null,description:description$Q,fn:fn$Q,name:name$2d})
const name$2c="removeXMLProcInst"
const description$P="removes XML processing instructions"
const fn$P=()=>({instruction:{enter:(node,parentNode)=>{node.name==="xml"&&detachNodeFromParent(node,parentNode)}}})
var removeXMLProcInst=Object.freeze({__proto__:null,description:description$P,fn:fn$P,name:name$2c})
const name$2b="removeComments"
const description$O="removes comments"
const DEFAULT_PRESERVE_PATTERNS=[/^!/]
const fn$O=(_root,params)=>{const{preservePatterns:preservePatterns=DEFAULT_PRESERVE_PATTERNS}=params
return{comment:{enter:(node,parentNode)=>{if(preservePatterns){if(!Array.isArray(preservePatterns))throw Error(`Expected array in removeComments preservePatterns parameter but received ${preservePatterns}`)
const matches=preservePatterns.some((pattern=>new RegExp(pattern).test(node.value)))
if(matches)return}detachNodeFromParent(node,parentNode)}}}}
var removeComments=Object.freeze({__proto__:null,description:description$O,fn:fn$O,name:name$2b})
const elemsGroups={animation:new Set(["animate","animateColor","animateMotion","animateTransform","set"]),descriptive:new Set(["desc","metadata","title"]),shape:new Set(["circle","ellipse","line","path","polygon","polyline","rect"]),structural:new Set(["defs","g","svg","symbol","use"]),paintServer:new Set(["hatch","linearGradient","meshGradient","pattern","radialGradient","solidColor"]),nonRendering:new Set(["clipPath","filter","linearGradient","marker","mask","pattern","radialGradient","solidColor","symbol"]),container:new Set(["a","defs","foreignObject","g","marker","mask","missing-glyph","pattern","svg","switch","symbol"]),textContent:new Set(["a","altGlyph","altGlyphDef","altGlyphItem","glyph","glyphRef","text","textPath","tref","tspan"]),textContentChild:new Set(["altGlyph","textPath","tref","tspan"]),lightSource:new Set(["feDiffuseLighting","feDistantLight","fePointLight","feSpecularLighting","feSpotLight"]),filterPrimitive:new Set(["feBlend","feColorMatrix","feComponentTransfer","feComposite","feConvolveMatrix","feDiffuseLighting","feDisplacementMap","feDropShadow","feFlood","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feImage","feMerge","feMergeNode","feMorphology","feOffset","feSpecularLighting","feTile","feTurbulence"])}
const textElems=new Set([...elemsGroups.textContent,"pre","title"])
const pathElems=new Set(["glyph","missing-glyph","path"])
const attrsGroups={animationAddition:new Set(["additive","accumulate"]),animationAttributeTarget:new Set(["attributeType","attributeName"]),animationEvent:new Set(["onbegin","onend","onrepeat","onload"]),animationTiming:new Set(["begin","dur","end","fill","max","min","repeatCount","repeatDur","restart"]),animationValue:new Set(["by","calcMode","from","keySplines","keyTimes","to","values"]),conditionalProcessing:new Set(["requiredExtensions","requiredFeatures","systemLanguage"]),core:new Set(["id","tabindex","xml:base","xml:lang","xml:space"]),graphicalEvent:new Set(["onactivate","onclick","onfocusin","onfocusout","onload","onmousedown","onmousemove","onmouseout","onmouseover","onmouseup"]),presentation:new Set(["alignment-baseline","baseline-shift","clip-path","clip-rule","clip","color-interpolation-filters","color-interpolation","color-profile","color-rendering","color","cursor","direction","display","dominant-baseline","enable-background","fill-opacity","fill-rule","fill","filter","flood-color","flood-opacity","font-family","font-size-adjust","font-size","font-stretch","font-style","font-variant","font-weight","glyph-orientation-horizontal","glyph-orientation-vertical","image-rendering","letter-spacing","lighting-color","marker-end","marker-mid","marker-start","mask","opacity","overflow","paint-order","pointer-events","shape-rendering","stop-color","stop-opacity","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-opacity","stroke-width","stroke","text-anchor","text-decoration","text-overflow","text-rendering","transform-origin","transform","unicode-bidi","vector-effect","visibility","word-spacing","writing-mode"]),xlink:new Set(["xlink:actuate","xlink:arcrole","xlink:href","xlink:role","xlink:show","xlink:title","xlink:type"]),documentEvent:new Set(["onabort","onerror","onresize","onscroll","onunload","onzoom"]),documentElementEvent:new Set(["oncopy","oncut","onpaste"]),globalEvent:new Set(["oncancel","oncanplay","oncanplaythrough","onchange","onclick","onclose","oncuechange","ondblclick","ondrag","ondragend","ondragenter","ondragleave","ondragover","ondragstart","ondrop","ondurationchange","onemptied","onended","onerror","onfocus","oninput","oninvalid","onkeydown","onkeypress","onkeyup","onload","onloadeddata","onloadedmetadata","onloadstart","onmousedown","onmouseenter","onmouseleave","onmousemove","onmouseout","onmouseover","onmouseup","onmousewheel","onpause","onplay","onplaying","onprogress","onratechange","onreset","onresize","onscroll","onseeked","onseeking","onselect","onshow","onstalled","onsubmit","onsuspend","ontimeupdate","ontoggle","onvolumechange","onwaiting"]),filterPrimitive:new Set(["x","y","width","height","result"]),transferFunction:new Set(["amplitude","exponent","intercept","offset","slope","tableValues","type"])}
const attrsGroupsDefaults={core:{"xml:space":"default"},presentation:{clip:"auto","clip-path":"none","clip-rule":"nonzero",mask:"none",opacity:"1","stop-color":"#000","stop-opacity":"1","fill-opacity":"1","fill-rule":"nonzero",fill:"#000",stroke:"none","stroke-width":"1","stroke-linecap":"butt","stroke-linejoin":"miter","stroke-miterlimit":"4","stroke-dasharray":"none","stroke-dashoffset":"0","stroke-opacity":"1","paint-order":"normal","vector-effect":"none",display:"inline",visibility:"visible","marker-start":"none","marker-mid":"none","marker-end":"none","color-interpolation":"sRGB","color-interpolation-filters":"linearRGB","color-rendering":"auto","shape-rendering":"auto","text-rendering":"auto","image-rendering":"auto","font-style":"normal","font-variant":"normal","font-weight":"normal","font-stretch":"normal","font-size":"medium","font-size-adjust":"none",kerning:"auto","letter-spacing":"normal","word-spacing":"normal","text-decoration":"none","text-anchor":"start","text-overflow":"clip","writing-mode":"lr-tb","glyph-orientation-vertical":"auto","glyph-orientation-horizontal":"0deg",direction:"ltr","unicode-bidi":"normal","dominant-baseline":"auto","alignment-baseline":"baseline","baseline-shift":"baseline"},transferFunction:{slope:"1",intercept:"0",amplitude:"1",exponent:"1",offset:"0"}}
const attrsGroupsDeprecated={animationAttributeTarget:{unsafe:new Set(["attributeType"])},conditionalProcessing:{unsafe:new Set(["requiredFeatures"])},core:{unsafe:new Set(["xml:base","xml:lang","xml:space"])},presentation:{unsafe:new Set(["clip","color-profile","enable-background","glyph-orientation-horizontal","glyph-orientation-vertical","kerning"])}}
const elems={a:{attrsGroups:new Set(["conditionalProcessing","core","graphicalEvent","presentation","xlink"]),attrs:new Set(["class","externalResourcesRequired","style","target","transform"]),defaults:{target:"_self"},contentGroups:new Set(["animation","descriptive","paintServer","shape","structural"]),content:new Set(["a","altGlyphDef","clipPath","color-profile","cursor","filter","font-face","font","foreignObject","image","marker","mask","pattern","script","style","switch","text","view","tspan"])},altGlyph:{attrsGroups:new Set(["conditionalProcessing","core","graphicalEvent","presentation","xlink"]),attrs:new Set(["class","dx","dy","externalResourcesRequired","format","glyphRef","rotate","style","x","y"])},altGlyphDef:{attrsGroups:new Set(["core"]),content:new Set(["glyphRef"])},altGlyphItem:{attrsGroups:new Set(["core"]),content:new Set(["glyphRef","altGlyphItem"])},animate:{attrsGroups:new Set(["animationAddition","animationAttributeTarget","animationEvent","animationTiming","animationValue","conditionalProcessing","core","presentation","xlink"]),attrs:new Set(["externalResourcesRequired"]),contentGroups:new Set(["descriptive"])},animateColor:{attrsGroups:new Set(["animationAddition","animationAttributeTarget","animationEvent","animationTiming","animationValue","conditionalProcessing","core","presentation","xlink"]),attrs:new Set(["externalResourcesRequired"]),contentGroups:new Set(["descriptive"])},animateMotion:{attrsGroups:new Set(["animationAddition","animationEvent","animationTiming","animationValue","conditionalProcessing","core","xlink"]),attrs:new Set(["externalResourcesRequired","keyPoints","origin","path","rotate"]),defaults:{rotate:"0"},contentGroups:new Set(["descriptive"]),content:new Set(["mpath"])},animateTransform:{attrsGroups:new Set(["animationAddition","animationAttributeTarget","animationEvent","animationTiming","animationValue","conditionalProcessing","core","xlink"]),attrs:new Set(["externalResourcesRequired","type"]),contentGroups:new Set(["descriptive"])},circle:{attrsGroups:new Set(["conditionalProcessing","core","graphicalEvent","presentation"]),attrs:new Set(["class","cx","cy","externalResourcesRequired","r","style","transform"]),defaults:{cx:"0",cy:"0"},contentGroups:new Set(["animation","descriptive"])},clipPath:{attrsGroups:new Set(["conditionalProcessing","core","presentation"]),attrs:new Set(["class","clipPathUnits","externalResourcesRequired","style","transform"]),defaults:{clipPathUnits:"userSpaceOnUse"},contentGroups:new Set(["animation","descriptive","shape"]),content:new Set(["text","use"])},"color-profile":{attrsGroups:new Set(["core","xlink"]),attrs:new Set(["local","name","rendering-intent"]),defaults:{name:"sRGB","rendering-intent":"auto"},deprecated:{unsafe:new Set(["name"])},contentGroups:new Set(["descriptive"])},cursor:{attrsGroups:new Set(["core","conditionalProcessing","xlink"]),attrs:new Set(["externalResourcesRequired","x","y"]),defaults:{x:"0",y:"0"},contentGroups:new Set(["descriptive"])},defs:{attrsGroups:new Set(["conditionalProcessing","core","graphicalEvent","presentation"]),attrs:new Set(["class","externalResourcesRequired","style","transform"]),contentGroups:new Set(["animation","descriptive","paintServer","shape","structural"]),content:new Set(["a","altGlyphDef","clipPath","color-profile","cursor","filter","font-face","font","foreignObject","image","marker","mask","pattern","script","style","switch","text","view"])},desc:{attrsGroups:new Set(["core"]),attrs:new Set(["class","style"])},ellipse:{attrsGroups:new Set(["conditionalProcessing","core","graphicalEvent","presentation"]),attrs:new Set(["class","cx","cy","externalResourcesRequired","rx","ry","style","transform"]),defaults:{cx:"0",cy:"0"},contentGroups:new Set(["animation","descriptive"])},feBlend:{attrsGroups:new Set(["core","presentation","filterPrimitive"]),attrs:new Set(["class","style","in","in2","mode"]),defaults:{mode:"normal"},content:new Set(["animate","set"])},feColorMatrix:{attrsGroups:new Set(["core","presentation","filterPrimitive"]),attrs:new Set(["class","style","in","type","values"]),defaults:{type:"matrix"},content:new Set(["animate","set"])},feComponentTransfer:{attrsGroups:new Set(["core","presentation","filterPrimitive"]),attrs:new Set(["class","style","in"]),content:new Set(["feFuncA","feFuncB","feFuncG","feFuncR"])},feComposite:{attrsGroups:new Set(["core","presentation","filterPrimitive"]),attrs:new Set(["class","in","in2","k1","k2","k3","k4","operator","style"]),defaults:{operator:"over",k1:"0",k2:"0",k3:"0",k4:"0"},content:new Set(["animate","set"])},feConvolveMatrix:{attrsGroups:new Set(["core","presentation","filterPrimitive"]),attrs:new Set(["class","in","kernelMatrix","order","style","bias","divisor","edgeMode","targetX","targetY","kernelUnitLength","preserveAlpha"]),defaults:{order:"3",bias:"0",edgeMode:"duplicate",preserveAlpha:"false"},content:new Set(["animate","set"])},feDiffuseLighting:{attrsGroups:new Set(["core","presentation","filterPrimitive"]),attrs:new Set(["class","diffuseConstant","in","kernelUnitLength","style","surfaceScale"]),defaults:{surfaceScale:"1",diffuseConstant:"1"},contentGroups:new Set(["descriptive"]),content:new Set(["feDistantLight","fePointLight","feSpotLight"])},feDisplacementMap:{attrsGroups:new Set(["core","presentation","filterPrimitive"]),attrs:new Set(["class","in","in2","scale","style","xChannelSelector","yChannelSelector"]),defaults:{scale:"0",xChannelSelector:"A",yChannelSelector:"A"},content:new Set(["animate","set"])},feDistantLight:{attrsGroups:new Set(["core"]),attrs:new Set(["azimuth","elevation"]),defaults:{azimuth:"0",elevation:"0"},content:new Set(["animate","set"])},feFlood:{attrsGroups:new Set(["core","presentation","filterPrimitive"]),attrs:new Set(["class","style"]),content:new Set(["animate","animateColor","set"])},feFuncA:{attrsGroups:new Set(["core","transferFunction"]),content:new Set(["set","animate"])},feFuncB:{attrsGroups:new Set(["core","transferFunction"]),content:new Set(["set","animate"])},feFuncG:{attrsGroups:new Set(["core","transferFunction"]),content:new Set(["set","animate"])},feFuncR:{attrsGroups:new Set(["core","transferFunction"]),content:new Set(["set","animate"])},feGaussianBlur:{attrsGroups:new Set(["core","presentation","filterPrimitive"]),attrs:new Set(["class","style","in","stdDeviation"]),defaults:{stdDeviation:"0"},content:new Set(["set","animate"])},feImage:{attrsGroups:new Set(["core","presentation","filterPrimitive","xlink"]),attrs:new Set(["class","externalResourcesRequired","href","preserveAspectRatio","style","xlink:href"]),defaults:{preserveAspectRatio:"xMidYMid meet"},content:new Set(["animate","animateTransform","set"])},feMerge:{attrsGroups:new Set(["core","presentation","filterPrimitive"]),attrs:new Set(["class","style"]),content:new Set(["feMergeNode"])},feMergeNode:{attrsGroups:new Set(["core"]),attrs:new Set(["in"]),content:new Set(["animate","set"])},feMorphology:{attrsGroups:new Set(["core","presentation","filterPrimitive"]),attrs:new Set(["class","style","in","operator","radius"]),defaults:{operator:"erode",radius:"0"},content:new Set(["animate","set"])},feOffset:{attrsGroups:new Set(["core","presentation","filterPrimitive"]),attrs:new Set(["class","style","in","dx","dy"]),defaults:{dx:"0",dy:"0"},content:new Set(["animate","set"])},fePointLight:{attrsGroups:new Set(["core"]),attrs:new Set(["x","y","z"]),defaults:{x:"0",y:"0",z:"0"},content:new Set(["animate","set"])},feSpecularLighting:{attrsGroups:new Set(["core","presentation","filterPrimitive"]),attrs:new Set(["class","in","kernelUnitLength","specularConstant","specularExponent","style","surfaceScale"]),defaults:{surfaceScale:"1",specularConstant:"1",specularExponent:"1"},contentGroups:new Set(["descriptive","lightSource"])},feSpotLight:{attrsGroups:new Set(["core"]),attrs:new Set(["limitingConeAngle","pointsAtX","pointsAtY","pointsAtZ","specularExponent","x","y","z"]),defaults:{x:"0",y:"0",z:"0",pointsAtX:"0",pointsAtY:"0",pointsAtZ:"0",specularExponent:"1"},content:new Set(["animate","set"])},feTile:{attrsGroups:new Set(["core","presentation","filterPrimitive"]),attrs:new Set(["class","style","in"]),content:new Set(["animate","set"])},feTurbulence:{attrsGroups:new Set(["core","presentation","filterPrimitive"]),attrs:new Set(["baseFrequency","class","numOctaves","seed","stitchTiles","style","type"]),defaults:{baseFrequency:"0",numOctaves:"1",seed:"0",stitchTiles:"noStitch",type:"turbulence"},content:new Set(["animate","set"])},filter:{attrsGroups:new Set(["core","presentation","xlink"]),attrs:new Set(["class","externalResourcesRequired","filterRes","filterUnits","height","href","primitiveUnits","style","width","x","xlink:href","y"]),defaults:{primitiveUnits:"userSpaceOnUse",x:"-10%",y:"-10%",width:"120%",height:"120%"},deprecated:{unsafe:new Set(["filterRes"])},contentGroups:new Set(["descriptive","filterPrimitive"]),content:new Set(["animate","set"])},font:{attrsGroups:new Set(["core","presentation"]),attrs:new Set(["class","externalResourcesRequired","horiz-adv-x","horiz-origin-x","horiz-origin-y","style","vert-adv-y","vert-origin-x","vert-origin-y"]),defaults:{"horiz-origin-x":"0","horiz-origin-y":"0"},deprecated:{unsafe:new Set(["horiz-origin-x","horiz-origin-y","vert-adv-y","vert-origin-x","vert-origin-y"])},contentGroups:new Set(["descriptive"]),content:new Set(["font-face","glyph","hkern","missing-glyph","vkern"])},"font-face":{attrsGroups:new Set(["core"]),attrs:new Set(["font-family","font-style","font-variant","font-weight","font-stretch","font-size","unicode-range","units-per-em","panose-1","stemv","stemh","slope","cap-height","x-height","accent-height","ascent","descent","widths","bbox","ideographic","alphabetic","mathematical","hanging","v-ideographic","v-alphabetic","v-mathematical","v-hanging","underline-position","underline-thickness","strikethrough-position","strikethrough-thickness","overline-position","overline-thickness"]),defaults:{"font-style":"all","font-variant":"normal","font-weight":"all","font-stretch":"normal","unicode-range":"U+0-10FFFF","units-per-em":"1000","panose-1":"0 0 0 0 0 0 0 0 0 0",slope:"0"},deprecated:{unsafe:new Set(["accent-height","alphabetic","ascent","bbox","cap-height","descent","hanging","ideographic","mathematical","panose-1","slope","stemh","stemv","unicode-range","units-per-em","v-alphabetic","v-hanging","v-ideographic","v-mathematical","widths","x-height"])},contentGroups:new Set(["descriptive"]),content:new Set(["font-face-src"])},"font-face-format":{attrsGroups:new Set(["core"]),attrs:new Set(["string"]),deprecated:{unsafe:new Set(["string"])}},"font-face-name":{attrsGroups:new Set(["core"]),attrs:new Set(["name"]),deprecated:{unsafe:new Set(["name"])}},"font-face-src":{attrsGroups:new Set(["core"]),content:new Set(["font-face-name","font-face-uri"])},"font-face-uri":{attrsGroups:new Set(["core","xlink"]),attrs:new Set(["href","xlink:href"]),content:new Set(["font-face-format"])},foreignObject:{attrsGroups:new Set(["conditionalProcessing","core","graphicalEvent","presentation"]),attrs:new Set(["class","externalResourcesRequired","height","style","transform","width","x","y"]),defaults:{x:"0",y:"0"}},g:{attrsGroups:new Set(["conditionalProcessing","core","graphicalEvent","presentation"]),attrs:new Set(["class","externalResourcesRequired","style","transform"]),contentGroups:new Set(["animation","descriptive","paintServer","shape","structural"]),content:new Set(["a","altGlyphDef","clipPath","color-profile","cursor","filter","font-face","font","foreignObject","image","marker","mask","pattern","script","style","switch","text","view"])},glyph:{attrsGroups:new Set(["core","presentation"]),attrs:new Set(["arabic-form","class","d","glyph-name","horiz-adv-x","lang","orientation","style","unicode","vert-adv-y","vert-origin-x","vert-origin-y"]),defaults:{"arabic-form":"initial"},deprecated:{unsafe:new Set(["arabic-form","glyph-name","horiz-adv-x","orientation","unicode","vert-adv-y","vert-origin-x","vert-origin-y"])},contentGroups:new Set(["animation","descriptive","paintServer","shape","structural"]),content:new Set(["a","altGlyphDef","clipPath","color-profile","cursor","filter","font-face","font","foreignObject","image","marker","mask","pattern","script","style","switch","text","view"])},glyphRef:{attrsGroups:new Set(["core","presentation"]),attrs:new Set(["class","d","horiz-adv-x","style","vert-adv-y","vert-origin-x","vert-origin-y"]),deprecated:{unsafe:new Set(["horiz-adv-x","vert-adv-y","vert-origin-x","vert-origin-y"])},contentGroups:new Set(["animation","descriptive","paintServer","shape","structural"]),content:new Set(["a","altGlyphDef","clipPath","color-profile","cursor","filter","font-face","font","foreignObject","image","marker","mask","pattern","script","style","switch","text","view"])},hatch:{attrsGroups:new Set(["core","presentation","xlink"]),attrs:new Set(["class","hatchContentUnits","hatchUnits","pitch","rotate","style","transform","x","y"]),defaults:{hatchUnits:"objectBoundingBox",hatchContentUnits:"userSpaceOnUse",x:"0",y:"0",pitch:"0",rotate:"0"},contentGroups:new Set(["animation","descriptive"]),content:new Set(["hatchPath"])},hatchPath:{attrsGroups:new Set(["core","presentation","xlink"]),attrs:new Set(["class","style","d","offset"]),defaults:{offset:"0"},contentGroups:new Set(["animation","descriptive"])},hkern:{attrsGroups:new Set(["core"]),attrs:new Set(["u1","g1","u2","g2","k"]),deprecated:{unsafe:new Set(["g1","g2","k","u1","u2"])}},image:{attrsGroups:new Set(["conditionalProcessing","core","graphicalEvent","presentation","xlink"]),attrs:new Set(["class","externalResourcesRequired","height","href","preserveAspectRatio","style","transform","width","x","xlink:href","y"]),defaults:{x:"0",y:"0",preserveAspectRatio:"xMidYMid meet"},contentGroups:new Set(["animation","descriptive"])},line:{attrsGroups:new Set(["conditionalProcessing","core","graphicalEvent","presentation"]),attrs:new Set(["class","externalResourcesRequired","style","transform","x1","x2","y1","y2"]),defaults:{x1:"0",y1:"0",x2:"0",y2:"0"},contentGroups:new Set(["animation","descriptive"])},linearGradient:{attrsGroups:new Set(["core","presentation","xlink"]),attrs:new Set(["class","externalResourcesRequired","gradientTransform","gradientUnits","href","spreadMethod","style","x1","x2","xlink:href","y1","y2"]),defaults:{x1:"0",y1:"0",x2:"100%",y2:"0",spreadMethod:"pad"},contentGroups:new Set(["descriptive"]),content:new Set(["animate","animateTransform","set","stop"])},marker:{attrsGroups:new Set(["core","presentation"]),attrs:new Set(["class","externalResourcesRequired","markerHeight","markerUnits","markerWidth","orient","preserveAspectRatio","refX","refY","style","viewBox"]),defaults:{markerUnits:"strokeWidth",refX:"0",refY:"0",markerWidth:"3",markerHeight:"3"},contentGroups:new Set(["animation","descriptive","paintServer","shape","structural"]),content:new Set(["a","altGlyphDef","clipPath","color-profile","cursor","filter","font-face","font","foreignObject","image","marker","mask","pattern","script","style","switch","text","view"])},mask:{attrsGroups:new Set(["conditionalProcessing","core","presentation"]),attrs:new Set(["class","externalResourcesRequired","height","mask-type","maskContentUnits","maskUnits","style","width","x","y"]),defaults:{maskUnits:"objectBoundingBox",maskContentUnits:"userSpaceOnUse",x:"-10%",y:"-10%",width:"120%",height:"120%"},contentGroups:new Set(["animation","descriptive","paintServer","shape","structural"]),content:new Set(["a","altGlyphDef","clipPath","color-profile","cursor","filter","font-face","font","foreignObject","image","marker","mask","pattern","script","style","switch","text","view"])},metadata:{attrsGroups:new Set(["core"])},"missing-glyph":{attrsGroups:new Set(["core","presentation"]),attrs:new Set(["class","d","horiz-adv-x","style","vert-adv-y","vert-origin-x","vert-origin-y"]),deprecated:{unsafe:new Set(["horiz-adv-x","vert-adv-y","vert-origin-x","vert-origin-y"])},contentGroups:new Set(["animation","descriptive","paintServer","shape","structural"]),content:new Set(["a","altGlyphDef","clipPath","color-profile","cursor","filter","font-face","font","foreignObject","image","marker","mask","pattern","script","style","switch","text","view"])},mpath:{attrsGroups:new Set(["core","xlink"]),attrs:new Set(["externalResourcesRequired","href","xlink:href"]),contentGroups:new Set(["descriptive"])},path:{attrsGroups:new Set(["conditionalProcessing","core","graphicalEvent","presentation"]),attrs:new Set(["class","d","externalResourcesRequired","pathLength","style","transform"]),contentGroups:new Set(["animation","descriptive"])},pattern:{attrsGroups:new Set(["conditionalProcessing","core","presentation","xlink"]),attrs:new Set(["class","externalResourcesRequired","height","href","patternContentUnits","patternTransform","patternUnits","preserveAspectRatio","style","viewBox","width","x","xlink:href","y"]),defaults:{patternUnits:"objectBoundingBox",patternContentUnits:"userSpaceOnUse",x:"0",y:"0",width:"0",height:"0",preserveAspectRatio:"xMidYMid meet"},contentGroups:new Set(["animation","descriptive","paintServer","shape","structural"]),content:new Set(["a","altGlyphDef","clipPath","color-profile","cursor","filter","font-face","font","foreignObject","image","marker","mask","pattern","script","style","switch","text","view"])},polygon:{attrsGroups:new Set(["conditionalProcessing","core","graphicalEvent","presentation"]),attrs:new Set(["class","externalResourcesRequired","points","style","transform"]),contentGroups:new Set(["animation","descriptive"])},polyline:{attrsGroups:new Set(["conditionalProcessing","core","graphicalEvent","presentation"]),attrs:new Set(["class","externalResourcesRequired","points","style","transform"]),contentGroups:new Set(["animation","descriptive"])},radialGradient:{attrsGroups:new Set(["core","presentation","xlink"]),attrs:new Set(["class","cx","cy","externalResourcesRequired","fr","fx","fy","gradientTransform","gradientUnits","href","r","spreadMethod","style","xlink:href"]),defaults:{gradientUnits:"objectBoundingBox",cx:"50%",cy:"50%",r:"50%"},contentGroups:new Set(["descriptive"]),content:new Set(["animate","animateTransform","set","stop"])},meshGradient:{attrsGroups:new Set(["core","presentation","xlink"]),attrs:new Set(["class","style","x","y","gradientUnits","transform"]),contentGroups:new Set(["descriptive","paintServer","animation"]),content:new Set(["meshRow"])},meshRow:{attrsGroups:new Set(["core","presentation"]),attrs:new Set(["class","style"]),contentGroups:new Set(["descriptive"]),content:new Set(["meshPatch"])},meshPatch:{attrsGroups:new Set(["core","presentation"]),attrs:new Set(["class","style"]),contentGroups:new Set(["descriptive"]),content:new Set(["stop"])},rect:{attrsGroups:new Set(["conditionalProcessing","core","graphicalEvent","presentation"]),attrs:new Set(["class","externalResourcesRequired","height","rx","ry","style","transform","width","x","y"]),defaults:{x:"0",y:"0"},contentGroups:new Set(["animation","descriptive"])},script:{attrsGroups:new Set(["core","xlink"]),attrs:new Set(["externalResourcesRequired","type","href","xlink:href"])},set:{attrsGroups:new Set(["animation","animationAttributeTarget","animationTiming","conditionalProcessing","core","xlink"]),attrs:new Set(["externalResourcesRequired","to"]),contentGroups:new Set(["descriptive"])},solidColor:{attrsGroups:new Set(["core","presentation"]),attrs:new Set(["class","style"]),contentGroups:new Set(["paintServer"])},stop:{attrsGroups:new Set(["core","presentation"]),attrs:new Set(["class","style","offset","path"]),content:new Set(["animate","animateColor","set"])},style:{attrsGroups:new Set(["core"]),attrs:new Set(["type","media","title"]),defaults:{type:"text/css"}},svg:{attrsGroups:new Set(["conditionalProcessing","core","documentEvent","graphicalEvent","presentation"]),attrs:new Set(["baseProfile","class","contentScriptType","contentStyleType","height","preserveAspectRatio","style","version","viewBox","width","x","y","zoomAndPan"]),defaults:{x:"0",y:"0",width:"100%",height:"100%",preserveAspectRatio:"xMidYMid meet",zoomAndPan:"magnify",version:"1.1",baseProfile:"none",contentScriptType:"application/ecmascript",contentStyleType:"text/css"},deprecated:{safe:new Set(["version"]),unsafe:new Set(["baseProfile","contentScriptType","contentStyleType","zoomAndPan"])},contentGroups:new Set(["animation","descriptive","paintServer","shape","structural"]),content:new Set(["a","altGlyphDef","clipPath","color-profile","cursor","filter","font-face","font","foreignObject","image","marker","mask","pattern","script","style","switch","text","view"])},switch:{attrsGroups:new Set(["conditionalProcessing","core","graphicalEvent","presentation"]),attrs:new Set(["class","externalResourcesRequired","style","transform"]),contentGroups:new Set(["animation","descriptive","shape"]),content:new Set(["a","foreignObject","g","image","svg","switch","text","use"])},symbol:{attrsGroups:new Set(["core","graphicalEvent","presentation"]),attrs:new Set(["class","externalResourcesRequired","preserveAspectRatio","refX","refY","style","viewBox"]),defaults:{refX:"0",refY:"0"},contentGroups:new Set(["animation","descriptive","paintServer","shape","structural"]),content:new Set(["a","altGlyphDef","clipPath","color-profile","cursor","filter","font-face","font","foreignObject","image","marker","mask","pattern","script","style","switch","text","view"])},text:{attrsGroups:new Set(["conditionalProcessing","core","graphicalEvent","presentation"]),attrs:new Set(["class","dx","dy","externalResourcesRequired","lengthAdjust","rotate","style","textLength","transform","x","y"]),defaults:{x:"0",y:"0",lengthAdjust:"spacing"},contentGroups:new Set(["animation","descriptive","textContentChild"]),content:new Set(["a"])},textPath:{attrsGroups:new Set(["conditionalProcessing","core","graphicalEvent","presentation","xlink"]),attrs:new Set(["class","d","externalResourcesRequired","href","method","spacing","startOffset","style","xlink:href"]),defaults:{startOffset:"0",method:"align",spacing:"exact"},contentGroups:new Set(["descriptive"]),content:new Set(["a","altGlyph","animate","animateColor","set","tref","tspan"])},title:{attrsGroups:new Set(["core"]),attrs:new Set(["class","style"])},tref:{attrsGroups:new Set(["conditionalProcessing","core","graphicalEvent","presentation","xlink"]),attrs:new Set(["class","externalResourcesRequired","href","style","xlink:href"]),contentGroups:new Set(["descriptive"]),content:new Set(["animate","animateColor","set"])},tspan:{attrsGroups:new Set(["conditionalProcessing","core","graphicalEvent","presentation"]),attrs:new Set(["class","dx","dy","externalResourcesRequired","lengthAdjust","rotate","style","textLength","x","y"]),contentGroups:new Set(["descriptive"]),content:new Set(["a","altGlyph","animate","animateColor","set","tref","tspan"])},use:{attrsGroups:new Set(["conditionalProcessing","core","graphicalEvent","presentation","xlink"]),attrs:new Set(["class","externalResourcesRequired","height","href","style","transform","width","x","xlink:href","y"]),defaults:{x:"0",y:"0"},contentGroups:new Set(["animation","descriptive"])},view:{attrsGroups:new Set(["core"]),attrs:new Set(["externalResourcesRequired","preserveAspectRatio","viewBox","viewTarget","zoomAndPan"]),deprecated:{unsafe:new Set(["viewTarget","zoomAndPan"])},contentGroups:new Set(["descriptive"])},vkern:{attrsGroups:new Set(["core"]),attrs:new Set(["u1","g1","u2","g2","k"]),deprecated:{unsafe:new Set(["g1","g2","k","u1","u2"])}}}
const editorNamespaces=new Set(["http://creativecommons.org/ns#","http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd","http://krita.org/namespaces/svg/krita","http://ns.adobe.com/AdobeIllustrator/10.0/","http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/","http://ns.adobe.com/Extensibility/1.0/","http://ns.adobe.com/Flows/1.0/","http://ns.adobe.com/GenericCustomNamespace/1.0/","http://ns.adobe.com/Graphs/1.0/","http://ns.adobe.com/ImageReplacement/1.0/","http://ns.adobe.com/SaveForWeb/1.0/","http://ns.adobe.com/Variables/1.0/","http://ns.adobe.com/XPath/1.0/","http://purl.org/dc/elements/1.1/","http://schemas.microsoft.com/visio/2003/SVGExtensions/","http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd","http://taptrix.com/vectorillustrator/svg_extensions","http://www.bohemiancoding.com/sketch/ns","http://www.figma.com/figma/ns","http://www.inkscape.org/namespaces/inkscape","http://www.serif.com/","http://www.vector.evaxdesign.sk","http://www.w3.org/1999/02/22-rdf-syntax-ns#","https://boxy-svg.com"])
const referencesProps=new Set(["clip-path","color-profile","fill","filter","marker-end","marker-mid","marker-start","mask","stroke","style"])
const inheritableAttrs=new Set(["clip-rule","color-interpolation-filters","color-interpolation","color-profile","color-rendering","color","cursor","direction","dominant-baseline","fill-opacity","fill-rule","fill","font-family","font-size-adjust","font-size","font-stretch","font-style","font-variant","font-weight","font","glyph-orientation-horizontal","glyph-orientation-vertical","image-rendering","letter-spacing","marker-end","marker-mid","marker-start","marker","paint-order","pointer-events","shape-rendering","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-opacity","stroke-width","stroke","text-anchor","text-rendering","transform","visibility","word-spacing","writing-mode"])
const presentationNonInheritableGroupAttrs=new Set(["clip-path","display","filter","mask","opacity","text-decoration","transform","unicode-bidi"])
const colorsNames={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#0ff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000",blanchedalmond:"#ffebcd",blue:"#00f",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#0ff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkgrey:"#a9a9a9",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkslategrey:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dimgrey:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#f0f",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",grey:"#808080",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgray:"#d3d3d3",lightgreen:"#90ee90",lightgrey:"#d3d3d3",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#789",lightslategrey:"#789",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#0f0",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#f0f",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370db",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#db7093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",rebeccapurple:"#639",red:"#f00",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",slategrey:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#fff",whitesmoke:"#f5f5f5",yellow:"#ff0",yellowgreen:"#9acd32"}
const colorsShortNames={"#f0ffff":"azure","#f5f5dc":"beige","#ffe4c4":"bisque","#a52a2a":"brown","#ff7f50":"coral","#ffd700":"gold","#808080":"gray","#008000":"green","#4b0082":"indigo","#fffff0":"ivory","#f0e68c":"khaki","#faf0e6":"linen","#800000":"maroon","#000080":"navy","#808000":"olive","#ffa500":"orange","#da70d6":"orchid","#cd853f":"peru","#ffc0cb":"pink","#dda0dd":"plum","#800080":"purple","#f00":"red","#ff0000":"red","#fa8072":"salmon","#a0522d":"sienna","#c0c0c0":"silver","#fffafa":"snow","#d2b48c":"tan","#008080":"teal","#ff6347":"tomato","#ee82ee":"violet","#f5deb3":"wheat"}
const colorsProps=new Set(["color","fill","flood-color","lighting-color","stop-color","stroke"])
const pseudoClasses={displayState:new Set(["fullscreen","modal","picture-in-picture"]),input:new Set(["autofill","blank","checked","default","disabled","enabled","in-range","indeterminate","invalid","optional","out-of-range","placeholder-shown","read-only","read-write","required","user-invalid","valid"]),linguistic:new Set(["dir","lang"]),location:new Set(["any-link","link","local-link","scope","target-within","target","visited"]),resourceState:new Set(["playing","paused"]),timeDimensional:new Set(["current","past","future"]),treeStructural:new Set(["empty","first-child","first-of-type","last-child","last-of-type","nth-child","nth-last-child","nth-last-of-type","nth-of-type","only-child","only-of-type","root"]),userAction:new Set(["active","focus-visible","focus-within","focus","hover"]),functional:new Set(["is","not","where","has"])}
var _collections=Object.freeze({__proto__:null,attrsGroups:attrsGroups,attrsGroupsDefaults:attrsGroupsDefaults,attrsGroupsDeprecated:attrsGroupsDeprecated,colorsNames:colorsNames,colorsProps:colorsProps,colorsShortNames:colorsShortNames,editorNamespaces:editorNamespaces,elems:elems,elemsGroups:elemsGroups,inheritableAttrs:inheritableAttrs,pathElems:pathElems,presentationNonInheritableGroupAttrs:presentationNonInheritableGroupAttrs,pseudoClasses:pseudoClasses,referencesProps:referencesProps,textElems:textElems})
const EOF$3=0
const Ident$1=1
const Function$3=2
const AtKeyword$1=3
const Hash$3=4
const String$4=5
const BadString$1=6
const Url$4=7
const BadUrl$1=8
const Delim$1=9
const Number$5=10
const Percentage$3=11
const Dimension$3=12
const WhiteSpace$3=13
const CDO$3=14
const CDC$3=15
const Colon$1=16
const Semicolon$1=17
const Comma$1=18
const LeftSquareBracket$1=19
const RightSquareBracket$1=20
const LeftParenthesis$1=21
const RightParenthesis$1=22
const LeftCurlyBracket$1=23
const RightCurlyBracket$1=24
const Comment$3=25
const EOF$2=0
function isDigit$2(code){return code>=0x0030&&code<=0x0039}function isHexDigit$1(code){return isDigit$2(code)||code>=0x0041&&code<=0x0046||code>=0x0061&&code<=0x0066}function isUppercaseLetter$1(code){return code>=0x0041&&code<=0x005A}function isLowercaseLetter$1(code){return code>=0x0061&&code<=0x007A}function isLetter$1(code){return isUppercaseLetter$1(code)||isLowercaseLetter$1(code)}function isNonAscii$1(code){return code>=0x0080}function isNameStart$1(code){return isLetter$1(code)||isNonAscii$1(code)||code===0x005F}function isName$1(code){return isNameStart$1(code)||isDigit$2(code)||code===0x002D}function isNonPrintable$1(code){return code>=0x0000&&code<=0x0008||code===0x000B||code>=0x000E&&code<=0x001F||code===0x007F}function isNewline$1(code){return code===0x000A||code===0x000D||code===0x000C}function isWhiteSpace$2(code){return isNewline$1(code)||code===0x0020||code===0x0009}function isValidEscape$1(first,second){if(first!==0x005C)return false
if(isNewline$1(second)||second===EOF$2)return false
return true}function isIdentifierStart$1(first,second,third){if(first===0x002D)return isNameStart$1(second)||second===0x002D||isValidEscape$1(second,third)
if(isNameStart$1(first))return true
if(first===0x005C)return isValidEscape$1(first,second)
return false}function isNumberStart$1(first,second,third){if(first===0x002B||first===0x002D){if(isDigit$2(second))return 2
return second===0x002E&&isDigit$2(third)?3:0}if(first===0x002E)return isDigit$2(second)?2:0
if(isDigit$2(first))return 1
return 0}function isBOM$1(code){if(code===0xFEFF)return 1
if(code===0xFFFE)return 1
return 0}const CATEGORY$1=new Array(0x80)
const EofCategory$1=0x80
const WhiteSpaceCategory$1=0x82
const DigitCategory$1=0x83
const NameStartCategory$1=0x84
const NonPrintableCategory$1=0x85
for(let i=0;i<CATEGORY$1.length;i++)CATEGORY$1[i]=isWhiteSpace$2(i)&&WhiteSpaceCategory$1||isDigit$2(i)&&DigitCategory$1||isNameStart$1(i)&&NameStartCategory$1||isNonPrintable$1(i)&&NonPrintableCategory$1||i||EofCategory$1
function charCodeCategory$1(code){return code<0x80?CATEGORY$1[code]:NameStartCategory$1}function getCharCode$1(source,offset){return offset<source.length?source.charCodeAt(offset):0}function getNewlineLength$1(source,offset,code){if(code===13&&getCharCode$1(source,offset+1)===10)return 2
return 1}function cmpChar$1(testStr,offset,referenceCode){let code=testStr.charCodeAt(offset)
isUppercaseLetter$1(code)&&(code|=32)
return code===referenceCode}function cmpStr$1(testStr,start,end,referenceStr){if(end-start!==referenceStr.length)return false
if(start<0||end>testStr.length)return false
for(let i=start;i<end;i++){const referenceCode=referenceStr.charCodeAt(i-start)
let testCode=testStr.charCodeAt(i)
isUppercaseLetter$1(testCode)&&(testCode|=32)
if(testCode!==referenceCode)return false}return true}function findWhiteSpaceStart$1(source,offset){for(;offset>=0;offset--)if(!isWhiteSpace$2(source.charCodeAt(offset)))break
return offset+1}function findWhiteSpaceEnd$1(source,offset){for(;offset<source.length;offset++)if(!isWhiteSpace$2(source.charCodeAt(offset)))break
return offset}function findDecimalNumberEnd$1(source,offset){for(;offset<source.length;offset++)if(!isDigit$2(source.charCodeAt(offset)))break
return offset}function consumeEscaped$1(source,offset){offset+=2
if(isHexDigit$1(getCharCode$1(source,offset-1))){for(const maxOffset=Math.min(source.length,offset+5);offset<maxOffset;offset++)if(!isHexDigit$1(getCharCode$1(source,offset)))break
const code=getCharCode$1(source,offset)
isWhiteSpace$2(code)&&(offset+=getNewlineLength$1(source,offset,code))}return offset}function consumeName$1(source,offset){for(;offset<source.length;offset++){const code=source.charCodeAt(offset)
if(isName$1(code))continue
if(isValidEscape$1(code,getCharCode$1(source,offset+1))){offset=consumeEscaped$1(source,offset)-1
continue}break}return offset}function consumeNumber$2(source,offset){let code=source.charCodeAt(offset)
code!==0x002B&&code!==0x002D||(code=source.charCodeAt(offset+=1))
if(isDigit$2(code)){offset=findDecimalNumberEnd$1(source,offset+1)
code=source.charCodeAt(offset)}if(code===0x002E&&isDigit$2(source.charCodeAt(offset+1))){offset+=2
offset=findDecimalNumberEnd$1(source,offset)}if(cmpChar$1(source,offset,101)){let sign=0
code=source.charCodeAt(offset+1)
if(code===0x002D||code===0x002B){sign=1
code=source.charCodeAt(offset+2)}isDigit$2(code)&&(offset=findDecimalNumberEnd$1(source,offset+1+sign+1))}return offset}function consumeBadUrlRemnants$1(source,offset){for(;offset<source.length;offset++){const code=source.charCodeAt(offset)
if(code===0x0029){offset++
break}isValidEscape$1(code,getCharCode$1(source,offset+1))&&(offset=consumeEscaped$1(source,offset))}return offset}function decodeEscaped$1(escaped){if(escaped.length===1&&!isHexDigit$1(escaped.charCodeAt(0)))return escaped[0]
let code=parseInt(escaped,16);(code===0||code>=0xD800&&code<=0xDFFF||code>0x10FFFF)&&(code=0xFFFD)
return String.fromCodePoint(code)}var tokenNames$1=["EOF-token","ident-token","function-token","at-keyword-token","hash-token","string-token","bad-string-token","url-token","bad-url-token","delim-token","number-token","percentage-token","dimension-token","whitespace-token","CDO-token","CDC-token","colon-token","semicolon-token","comma-token","[-token","]-token","(-token",")-token","{-token","}-token","comment-token"]
const MIN_SIZE$1=16384
function adoptBuffer$1(buffer=null,size){if(buffer===null||buffer.length<size)return new Uint32Array(Math.max(size+1024,MIN_SIZE$1))
return buffer}const N$9=10
const F$5=12
const R$5=13
function computeLinesAndColumns$1(host){const source=host.source
const sourceLength=source.length
const startOffset=source.length>0?isBOM$1(source.charCodeAt(0)):0
const lines=adoptBuffer$1(host.lines,sourceLength)
const columns=adoptBuffer$1(host.columns,sourceLength)
let line=host.startLine
let column=host.startColumn
for(let i=startOffset;i<sourceLength;i++){const code=source.charCodeAt(i)
lines[i]=line
columns[i]=column++
if(code===N$9||code===R$5||code===F$5){if(code===R$5&&i+1<sourceLength&&source.charCodeAt(i+1)===N$9){i++
lines[i]=line
columns[i]=column}line++
column=1}}lines[sourceLength]=line
columns[sourceLength]=column
host.lines=lines
host.columns=columns
host.computed=true}let OffsetToLocation$1=class OffsetToLocation{constructor(){this.lines=null
this.columns=null
this.computed=false}setSource(source,startOffset=0,startLine=1,startColumn=1){this.source=source
this.startOffset=startOffset
this.startLine=startLine
this.startColumn=startColumn
this.computed=false}getLocation(offset,filename){this.computed||computeLinesAndColumns$1(this)
return{source:filename,offset:this.startOffset+offset,line:this.lines[offset],column:this.columns[offset]}}getLocationRange(start,end,filename){this.computed||computeLinesAndColumns$1(this)
return{source:filename,start:{offset:this.startOffset+start,line:this.lines[start],column:this.columns[start]},end:{offset:this.startOffset+end,line:this.lines[end],column:this.columns[end]}}}}
const OFFSET_MASK$1=0x00FFFFFF
const TYPE_SHIFT$1=24
const balancePair$3=new Map([[Function$3,RightParenthesis$1],[LeftParenthesis$1,RightParenthesis$1],[LeftSquareBracket$1,RightSquareBracket$1],[LeftCurlyBracket$1,RightCurlyBracket$1]])
let TokenStream$1=class TokenStream{constructor(source,tokenize){this.setSource(source,tokenize)}reset(){this.eof=false
this.tokenIndex=-1
this.tokenType=0
this.tokenStart=this.firstCharOffset
this.tokenEnd=this.firstCharOffset}setSource(source="",tokenize=(()=>{})){source=String(source||"")
const sourceLength=source.length
const offsetAndType=adoptBuffer$1(this.offsetAndType,source.length+1)
const balance=adoptBuffer$1(this.balance,source.length+1)
let tokenCount=0
let balanceCloseType=0
let balanceStart=0
let firstCharOffset=-1
this.offsetAndType=null
this.balance=null
tokenize(source,((type,start,end)=>{switch(type){default:balance[tokenCount]=sourceLength
break
case balanceCloseType:{let balancePrev=balanceStart&OFFSET_MASK$1
balanceStart=balance[balancePrev]
balanceCloseType=balanceStart>>TYPE_SHIFT$1
balance[tokenCount]=balancePrev
balance[balancePrev++]=tokenCount
for(;balancePrev<tokenCount;balancePrev++)balance[balancePrev]===sourceLength&&(balance[balancePrev]=tokenCount)
break}case LeftParenthesis$1:case Function$3:case LeftSquareBracket$1:case LeftCurlyBracket$1:balance[tokenCount]=balanceStart
balanceCloseType=balancePair$3.get(type)
balanceStart=balanceCloseType<<TYPE_SHIFT$1|tokenCount
break}offsetAndType[tokenCount++]=type<<TYPE_SHIFT$1|end
firstCharOffset===-1&&(firstCharOffset=start)}))
offsetAndType[tokenCount]=EOF$3<<TYPE_SHIFT$1|sourceLength
balance[tokenCount]=sourceLength
balance[sourceLength]=sourceLength
while(balanceStart!==0){const balancePrev=balanceStart&OFFSET_MASK$1
balanceStart=balance[balancePrev]
balance[balancePrev]=sourceLength}this.source=source
this.firstCharOffset=firstCharOffset===-1?0:firstCharOffset
this.tokenCount=tokenCount
this.offsetAndType=offsetAndType
this.balance=balance
this.reset()
this.next()}lookupType(offset){offset+=this.tokenIndex
if(offset<this.tokenCount)return this.offsetAndType[offset]>>TYPE_SHIFT$1
return EOF$3}lookupTypeNonSC(idx){for(let offset=this.tokenIndex;offset<this.tokenCount;offset++){const tokenType=this.offsetAndType[offset]>>TYPE_SHIFT$1
if(tokenType!==WhiteSpace$3&&tokenType!==Comment$3&&idx--===0)return tokenType}return EOF$3}lookupOffset(offset){offset+=this.tokenIndex
if(offset<this.tokenCount)return this.offsetAndType[offset-1]&OFFSET_MASK$1
return this.source.length}lookupOffsetNonSC(idx){for(let offset=this.tokenIndex;offset<this.tokenCount;offset++){const tokenType=this.offsetAndType[offset]>>TYPE_SHIFT$1
if(tokenType!==WhiteSpace$3&&tokenType!==Comment$3&&idx--===0)return offset-this.tokenIndex}return EOF$3}lookupValue(offset,referenceStr){offset+=this.tokenIndex
if(offset<this.tokenCount)return cmpStr$1(this.source,this.offsetAndType[offset-1]&OFFSET_MASK$1,this.offsetAndType[offset]&OFFSET_MASK$1,referenceStr)
return false}getTokenStart(tokenIndex){if(tokenIndex===this.tokenIndex)return this.tokenStart
if(tokenIndex>0)return tokenIndex<this.tokenCount?this.offsetAndType[tokenIndex-1]&OFFSET_MASK$1:this.offsetAndType[this.tokenCount]&OFFSET_MASK$1
return this.firstCharOffset}substrToCursor(start){return this.source.substring(start,this.tokenStart)}isBalanceEdge(pos){return this.balance[this.tokenIndex]<pos}isDelim(code,offset){if(offset)return this.lookupType(offset)===Delim$1&&this.source.charCodeAt(this.lookupOffset(offset))===code
return this.tokenType===Delim$1&&this.source.charCodeAt(this.tokenStart)===code}skip(tokenCount){let next=this.tokenIndex+tokenCount
if(next<this.tokenCount){this.tokenIndex=next
this.tokenStart=this.offsetAndType[next-1]&OFFSET_MASK$1
next=this.offsetAndType[next]
this.tokenType=next>>TYPE_SHIFT$1
this.tokenEnd=next&OFFSET_MASK$1}else{this.tokenIndex=this.tokenCount
this.next()}}next(){let next=this.tokenIndex+1
if(next<this.tokenCount){this.tokenIndex=next
this.tokenStart=this.tokenEnd
next=this.offsetAndType[next]
this.tokenType=next>>TYPE_SHIFT$1
this.tokenEnd=next&OFFSET_MASK$1}else{this.eof=true
this.tokenIndex=this.tokenCount
this.tokenType=EOF$3
this.tokenStart=this.tokenEnd=this.source.length}}skipSC(){while(this.tokenType===WhiteSpace$3||this.tokenType===Comment$3)this.next()}skipUntilBalanced(startToken,stopConsume){let cursor=startToken
let balanceEnd
let offset
loop:for(;cursor<this.tokenCount;cursor++){balanceEnd=this.balance[cursor]
if(balanceEnd<startToken)break loop
offset=cursor>0?this.offsetAndType[cursor-1]&OFFSET_MASK$1:this.firstCharOffset
switch(stopConsume(this.source.charCodeAt(offset))){case 1:break loop
case 2:cursor++
break loop
default:this.balance[balanceEnd]===cursor&&(cursor=balanceEnd)}}this.skip(cursor-this.tokenIndex)}forEachToken(fn){for(let i=0,offset=this.firstCharOffset;i<this.tokenCount;i++){const start=offset
const item=this.offsetAndType[i]
const end=item&OFFSET_MASK$1
const type=item>>TYPE_SHIFT$1
offset=end
fn(type,start,end,i)}}dump(){const tokens=new Array(this.tokenCount)
this.forEachToken(((type,start,end,index)=>{tokens[index]={idx:index,type:tokenNames$1[type],chunk:this.source.substring(start,end),balance:this.balance[index]}}))
return tokens}}
function tokenize$4(source,onToken){function getCharCode(offset){return offset<sourceLength?source.charCodeAt(offset):0}function consumeNumericToken(){offset=consumeNumber$2(source,offset)
if(isIdentifierStart$1(getCharCode(offset),getCharCode(offset+1),getCharCode(offset+2))){type=Dimension$3
offset=consumeName$1(source,offset)
return}if(getCharCode(offset)===0x0025){type=Percentage$3
offset++
return}type=Number$5}function consumeIdentLikeToken(){const nameStartOffset=offset
offset=consumeName$1(source,offset)
if(cmpStr$1(source,nameStartOffset,offset,"url")&&getCharCode(offset)===0x0028){offset=findWhiteSpaceEnd$1(source,offset+1)
if(getCharCode(offset)===0x0022||getCharCode(offset)===0x0027){type=Function$3
offset=nameStartOffset+4
return}consumeUrlToken()
return}if(getCharCode(offset)===0x0028){type=Function$3
offset++
return}type=Ident$1}function consumeStringToken(endingCodePoint){endingCodePoint||(endingCodePoint=getCharCode(offset++))
type=String$4
for(;offset<source.length;offset++){const code=source.charCodeAt(offset)
switch(charCodeCategory$1(code)){case endingCodePoint:offset++
return
case WhiteSpaceCategory$1:if(isNewline$1(code)){offset+=getNewlineLength$1(source,offset,code)
type=BadString$1
return}break
case 0x005C:if(offset===source.length-1)break
const nextCode=getCharCode(offset+1)
isNewline$1(nextCode)?offset+=getNewlineLength$1(source,offset+1,nextCode):isValidEscape$1(code,nextCode)&&(offset=consumeEscaped$1(source,offset)-1)
break}}}function consumeUrlToken(){type=Url$4
offset=findWhiteSpaceEnd$1(source,offset)
for(;offset<source.length;offset++){const code=source.charCodeAt(offset)
switch(charCodeCategory$1(code)){case 0x0029:offset++
return
case WhiteSpaceCategory$1:offset=findWhiteSpaceEnd$1(source,offset)
if(getCharCode(offset)===0x0029||offset>=source.length){offset<source.length&&offset++
return}offset=consumeBadUrlRemnants$1(source,offset)
type=BadUrl$1
return
case 0x0022:case 0x0027:case 0x0028:case NonPrintableCategory$1:offset=consumeBadUrlRemnants$1(source,offset)
type=BadUrl$1
return
case 0x005C:if(isValidEscape$1(code,getCharCode(offset+1))){offset=consumeEscaped$1(source,offset)-1
break}offset=consumeBadUrlRemnants$1(source,offset)
type=BadUrl$1
return}}}source=String(source||"")
const sourceLength=source.length
let start=isBOM$1(getCharCode(0))
let offset=start
let type
while(offset<sourceLength){const code=source.charCodeAt(offset)
switch(charCodeCategory$1(code)){case WhiteSpaceCategory$1:type=WhiteSpace$3
offset=findWhiteSpaceEnd$1(source,offset+1)
break
case 0x0022:consumeStringToken()
break
case 0x0023:if(isName$1(getCharCode(offset+1))||isValidEscape$1(getCharCode(offset+1),getCharCode(offset+2))){type=Hash$3
offset=consumeName$1(source,offset+1)}else{type=Delim$1
offset++}break
case 0x0027:consumeStringToken()
break
case 0x0028:type=LeftParenthesis$1
offset++
break
case 0x0029:type=RightParenthesis$1
offset++
break
case 0x002B:if(isNumberStart$1(code,getCharCode(offset+1),getCharCode(offset+2)))consumeNumericToken()
else{type=Delim$1
offset++}break
case 0x002C:type=Comma$1
offset++
break
case 0x002D:if(isNumberStart$1(code,getCharCode(offset+1),getCharCode(offset+2)))consumeNumericToken()
else if(getCharCode(offset+1)===0x002D&&getCharCode(offset+2)===0x003E){type=CDC$3
offset+=3}else if(isIdentifierStart$1(code,getCharCode(offset+1),getCharCode(offset+2)))consumeIdentLikeToken()
else{type=Delim$1
offset++}break
case 0x002E:if(isNumberStart$1(code,getCharCode(offset+1),getCharCode(offset+2)))consumeNumericToken()
else{type=Delim$1
offset++}break
case 0x002F:if(getCharCode(offset+1)===0x002A){type=Comment$3
offset=source.indexOf("*/",offset+2)
offset=offset===-1?source.length:offset+2}else{type=Delim$1
offset++}break
case 0x003A:type=Colon$1
offset++
break
case 0x003B:type=Semicolon$1
offset++
break
case 0x003C:if(getCharCode(offset+1)===0x0021&&getCharCode(offset+2)===0x002D&&getCharCode(offset+3)===0x002D){type=CDO$3
offset+=4}else{type=Delim$1
offset++}break
case 0x0040:if(isIdentifierStart$1(getCharCode(offset+1),getCharCode(offset+2),getCharCode(offset+3))){type=AtKeyword$1
offset=consumeName$1(source,offset+1)}else{type=Delim$1
offset++}break
case 0x005B:type=LeftSquareBracket$1
offset++
break
case 0x005C:if(isValidEscape$1(code,getCharCode(offset+1)))consumeIdentLikeToken()
else{type=Delim$1
offset++}break
case 0x005D:type=RightSquareBracket$1
offset++
break
case 0x007B:type=LeftCurlyBracket$1
offset++
break
case 0x007D:type=RightCurlyBracket$1
offset++
break
case DigitCategory$1:consumeNumericToken()
break
case NameStartCategory$1:consumeIdentLikeToken()
break
default:type=Delim$1
offset++}onToken(type,start,start=offset)}}let releasedCursors$1=null
let List$1=class List{static createItem(data){return{prev:null,next:null,data:data}}constructor(){this.head=null
this.tail=null
this.cursor=null}createItem(data){return List.createItem(data)}allocateCursor(prev,next){let cursor
if(releasedCursors$1!==null){cursor=releasedCursors$1
releasedCursors$1=releasedCursors$1.cursor
cursor.prev=prev
cursor.next=next
cursor.cursor=this.cursor}else cursor={prev:prev,next:next,cursor:this.cursor}
this.cursor=cursor
return cursor}releaseCursor(){const{cursor:cursor}=this
this.cursor=cursor.cursor
cursor.prev=null
cursor.next=null
cursor.cursor=releasedCursors$1
releasedCursors$1=cursor}updateCursors(prevOld,prevNew,nextOld,nextNew){let{cursor:cursor}=this
while(cursor!==null){cursor.prev===prevOld&&(cursor.prev=prevNew)
cursor.next===nextOld&&(cursor.next=nextNew)
cursor=cursor.cursor}}*[Symbol.iterator](){for(let cursor=this.head;cursor!==null;cursor=cursor.next)yield cursor.data}get size(){let size=0
for(let cursor=this.head;cursor!==null;cursor=cursor.next)size++
return size}get isEmpty(){return this.head===null}get first(){return this.head&&this.head.data}get last(){return this.tail&&this.tail.data}fromArray(array){let cursor=null
this.head=null
for(let data of array){const item=List.createItem(data)
cursor!==null?cursor.next=item:this.head=item
item.prev=cursor
cursor=item}this.tail=cursor
return this}toArray(){return[...this]}toJSON(){return[...this]}forEach(fn,thisArg=this){const cursor=this.allocateCursor(null,this.head)
while(cursor.next!==null){const item=cursor.next
cursor.next=item.next
fn.call(thisArg,item.data,item,this)}this.releaseCursor()}forEachRight(fn,thisArg=this){const cursor=this.allocateCursor(this.tail,null)
while(cursor.prev!==null){const item=cursor.prev
cursor.prev=item.prev
fn.call(thisArg,item.data,item,this)}this.releaseCursor()}reduce(fn,initialValue,thisArg=this){let cursor=this.allocateCursor(null,this.head)
let acc=initialValue
let item
while(cursor.next!==null){item=cursor.next
cursor.next=item.next
acc=fn.call(thisArg,acc,item.data,item,this)}this.releaseCursor()
return acc}reduceRight(fn,initialValue,thisArg=this){let cursor=this.allocateCursor(this.tail,null)
let acc=initialValue
let item
while(cursor.prev!==null){item=cursor.prev
cursor.prev=item.prev
acc=fn.call(thisArg,acc,item.data,item,this)}this.releaseCursor()
return acc}some(fn,thisArg=this){for(let cursor=this.head;cursor!==null;cursor=cursor.next)if(fn.call(thisArg,cursor.data,cursor,this))return true
return false}map(fn,thisArg=this){const result=new List
for(let cursor=this.head;cursor!==null;cursor=cursor.next)result.appendData(fn.call(thisArg,cursor.data,cursor,this))
return result}filter(fn,thisArg=this){const result=new List
for(let cursor=this.head;cursor!==null;cursor=cursor.next)fn.call(thisArg,cursor.data,cursor,this)&&result.appendData(cursor.data)
return result}nextUntil(start,fn,thisArg=this){if(start===null)return
const cursor=this.allocateCursor(null,start)
while(cursor.next!==null){const item=cursor.next
cursor.next=item.next
if(fn.call(thisArg,item.data,item,this))break}this.releaseCursor()}prevUntil(start,fn,thisArg=this){if(start===null)return
const cursor=this.allocateCursor(start,null)
while(cursor.prev!==null){const item=cursor.prev
cursor.prev=item.prev
if(fn.call(thisArg,item.data,item,this))break}this.releaseCursor()}clear(){this.head=null
this.tail=null}copy(){const result=new List
for(let data of this)result.appendData(data)
return result}prepend(item){this.updateCursors(null,item,this.head,item)
if(this.head!==null){this.head.prev=item
item.next=this.head}else this.tail=item
this.head=item
return this}prependData(data){return this.prepend(List.createItem(data))}append(item){return this.insert(item)}appendData(data){return this.insert(List.createItem(data))}insert(item,before=null){if(before!==null){this.updateCursors(before.prev,item,before,item)
if(before.prev===null){if(this.head!==before)throw new Error("before doesn't belong to list")
this.head=item
before.prev=item
item.next=before
this.updateCursors(null,item)}else{before.prev.next=item
item.prev=before.prev
before.prev=item
item.next=before}}else{this.updateCursors(this.tail,item,null,item)
if(this.tail!==null){this.tail.next=item
item.prev=this.tail}else this.head=item
this.tail=item}return this}insertData(data,before){return this.insert(List.createItem(data),before)}remove(item){this.updateCursors(item,item.prev,item,item.next)
if(item.prev!==null)item.prev.next=item.next
else{if(this.head!==item)throw new Error("item doesn't belong to list")
this.head=item.next}if(item.next!==null)item.next.prev=item.prev
else{if(this.tail!==item)throw new Error("item doesn't belong to list")
this.tail=item.prev}item.prev=null
item.next=null
return item}push(data){this.insert(List.createItem(data))}pop(){return this.tail!==null?this.remove(this.tail):null}unshift(data){this.prepend(List.createItem(data))}shift(){return this.head!==null?this.remove(this.head):null}prependList(list){return this.insertList(list,this.head)}appendList(list){return this.insertList(list)}insertList(list,before){if(list.head===null)return this
if(before!==void 0&&before!==null){this.updateCursors(before.prev,list.tail,before,list.head)
if(before.prev!==null){before.prev.next=list.head
list.head.prev=before.prev}else this.head=list.head
before.prev=list.tail
list.tail.next=before}else{this.updateCursors(this.tail,list.tail,null,list.head)
if(this.tail!==null){this.tail.next=list.head
list.head.prev=this.tail}else this.head=list.head
this.tail=list.tail}list.head=null
list.tail=null
return this}replace(oldItem,newItemOrList){"head"in newItemOrList?this.insertList(newItemOrList,oldItem):this.insert(newItemOrList,oldItem)
this.remove(oldItem)}}
function createCustomError$1(name,message){const error=Object.create(SyntaxError.prototype)
const errorStack=new Error
return Object.assign(error,{name:name,message:message,get stack(){return(errorStack.stack||"").replace(/^(.+\n){1,3}/,`${name}: ${message}\n`)}})}const MAX_LINE_LENGTH$1=100
const OFFSET_CORRECTION$1=60
const TAB_REPLACEMENT$1="    "
function sourceFragment$1({source:source,line:line,column:column,baseLine:baseLine,baseColumn:baseColumn},extraLines){function processLines(start,end){return lines.slice(start,end).map(((line,idx)=>String(start+idx+1).padStart(maxNumLength)+" |"+line)).join("\n")}const prelines="\n".repeat(Math.max(baseLine-1,0))
const precolumns=" ".repeat(Math.max(baseColumn-1,0))
const lines=(prelines+precolumns+source).split(/\r\n?|\n|\f/)
const startLine=Math.max(1,line-extraLines)-1
const endLine=Math.min(line+extraLines,lines.length+1)
const maxNumLength=Math.max(4,String(endLine).length)+1
let cutLeft=0
column+=(TAB_REPLACEMENT$1.length-1)*(lines[line-1].substr(0,column-1).match(/\t/g)||[]).length
if(column>MAX_LINE_LENGTH$1){cutLeft=column-OFFSET_CORRECTION$1+3
column=OFFSET_CORRECTION$1-2}for(let i=startLine;i<=endLine;i++)if(i>=0&&i<lines.length){lines[i]=lines[i].replace(/\t/g,TAB_REPLACEMENT$1)
lines[i]=(cutLeft>0&&lines[i].length>cutLeft?"…":"")+lines[i].substr(cutLeft,MAX_LINE_LENGTH$1-2)+(lines[i].length>cutLeft+MAX_LINE_LENGTH$1-1?"…":"")}return[processLines(startLine,line),new Array(column+maxNumLength+2).join("-")+"^",processLines(line,endLine)].filter(Boolean).join("\n").replace(/^(\s+\d+\s+\|\n)+/,"").replace(/\n(\s+\d+\s+\|)+$/,"")}function SyntaxError$4(message,source,offset,line,column,baseLine=1,baseColumn=1){const error=Object.assign(createCustomError$1("SyntaxError",message),{source:source,offset:offset,line:line,column:column,sourceFragment:extraLines=>sourceFragment$1({source:source,line:line,column:column,baseLine:baseLine,baseColumn:baseColumn},isNaN(extraLines)?0:extraLines),get formattedMessage(){return`Parse error: ${message}\n`+sourceFragment$1({source:source,line:line,column:column,baseLine:baseLine,baseColumn:baseColumn},2)}})
return error}function readSequence$2(recognizer){const children=this.createList()
let space=false
const context={recognizer:recognizer}
while(!this.eof){switch(this.tokenType){case Comment$3:this.next()
continue
case WhiteSpace$3:space=true
this.next()
continue}let child=recognizer.getNode.call(this,context)
if(child===void 0)break
if(space){recognizer.onWhiteSpace&&recognizer.onWhiteSpace.call(this,child,children,context)
space=false}children.push(child)}space&&recognizer.onWhiteSpace&&recognizer.onWhiteSpace.call(this,null,children,context)
return children}const NOOP$1=()=>{}
const EXCLAMATIONMARK$7=0x0021
const NUMBERSIGN$9=0x0023
const SEMICOLON$1=0x003B
const LEFTCURLYBRACKET$3=0x007B
const NULL$1=0
function createParseContext$1(name){return function(){return this[name]()}}function fetchParseValues$1(dict){const result=Object.create(null)
for(const name of Object.keys(dict)){const item=dict[name]
const fn=item.parse||item
fn&&(result[name]=fn)}return result}function processConfig$1(config){const parseConfig={context:Object.create(null),features:Object.assign(Object.create(null),config.features),scope:Object.assign(Object.create(null),config.scope),atrule:fetchParseValues$1(config.atrule),pseudo:fetchParseValues$1(config.pseudo),node:fetchParseValues$1(config.node)}
for(const[name,context]of Object.entries(config.parseContext))switch(typeof context){case"function":parseConfig.context[name]=context
break
case"string":parseConfig.context[name]=createParseContext$1(context)
break}return{config:parseConfig,...parseConfig,...parseConfig.node}}function createParser$1(config){let source=""
let filename="<unknown>"
let needPositions=false
let onParseError=NOOP$1
let onParseErrorThrow=false
const locationMap=new OffsetToLocation$1
const parser=Object.assign(new TokenStream$1,processConfig$1(config||{}),{parseAtrulePrelude:true,parseRulePrelude:true,parseValue:true,parseCustomProperty:false,readSequence:readSequence$2,consumeUntilBalanceEnd:()=>0,consumeUntilLeftCurlyBracket:code=>code===LEFTCURLYBRACKET$3?1:0,consumeUntilLeftCurlyBracketOrSemicolon:code=>code===LEFTCURLYBRACKET$3||code===SEMICOLON$1?1:0,consumeUntilExclamationMarkOrSemicolon:code=>code===EXCLAMATIONMARK$7||code===SEMICOLON$1?1:0,consumeUntilSemicolonIncluded:code=>code===SEMICOLON$1?2:0,createList:()=>new List$1,createSingleNodeList:node=>(new List$1).appendData(node),getFirstListNode:list=>list&&list.first,getLastListNode:list=>list&&list.last,parseWithFallback(consumer,fallback){const startIndex=this.tokenIndex
try{return consumer.call(this)}catch(e){if(onParseErrorThrow)throw e
this.skip(startIndex-this.tokenIndex)
const fallbackNode=fallback.call(this)
onParseErrorThrow=true
onParseError(e,fallbackNode)
onParseErrorThrow=false
return fallbackNode}},lookupNonWSType(offset){let type
do{type=this.lookupType(offset++)
if(type!==WhiteSpace$3&&type!==Comment$3)return type}while(type!==NULL$1)
return NULL$1},charCodeAt:offset=>offset>=0&&offset<source.length?source.charCodeAt(offset):0,substring:(offsetStart,offsetEnd)=>source.substring(offsetStart,offsetEnd),substrToCursor(start){return this.source.substring(start,this.tokenStart)},cmpChar:(offset,charCode)=>cmpChar$1(source,offset,charCode),cmpStr:(offsetStart,offsetEnd,str)=>cmpStr$1(source,offsetStart,offsetEnd,str),consume(tokenType){const start=this.tokenStart
this.eat(tokenType)
return this.substrToCursor(start)},consumeFunctionName(){const name=source.substring(this.tokenStart,this.tokenEnd-1)
this.eat(Function$3)
return name},consumeNumber(type){const number=source.substring(this.tokenStart,consumeNumber$2(source,this.tokenStart))
this.eat(type)
return number},eat(tokenType){if(this.tokenType!==tokenType){const tokenName=tokenNames$1[tokenType].slice(0,-6).replace(/-/g," ").replace(/^./,(m=>m.toUpperCase()))
let message=`${/[[\](){}]/.test(tokenName)?`"${tokenName}"`:tokenName} is expected`
let offset=this.tokenStart
switch(tokenType){case Ident$1:if(this.tokenType===Function$3||this.tokenType===Url$4){offset=this.tokenEnd-1
message="Identifier is expected but function found"}else message="Identifier is expected"
break
case Hash$3:if(this.isDelim(NUMBERSIGN$9)){this.next()
offset++
message="Name is expected"}break
case Percentage$3:if(this.tokenType===Number$5){offset=this.tokenEnd
message="Percent sign is expected"}break}this.error(message,offset)}this.next()},eatIdent(name){this.tokenType===Ident$1&&this.lookupValue(0,name)!==false||this.error(`Identifier "${name}" is expected`)
this.next()},eatDelim(code){this.isDelim(code)||this.error(`Delim "${String.fromCharCode(code)}" is expected`)
this.next()},getLocation(start,end){if(needPositions)return locationMap.getLocationRange(start,end,filename)
return null},getLocationFromList(list){if(needPositions){const head=this.getFirstListNode(list)
const tail=this.getLastListNode(list)
return locationMap.getLocationRange(head!==null?head.loc.start.offset-locationMap.startOffset:this.tokenStart,tail!==null?tail.loc.end.offset-locationMap.startOffset:this.tokenStart,filename)}return null},error(message,offset){const location=typeof offset!=="undefined"&&offset<source.length?locationMap.getLocation(offset):this.eof?locationMap.getLocation(findWhiteSpaceStart$1(source,source.length-1)):locationMap.getLocation(this.tokenStart)
throw new SyntaxError$4(message||"Unexpected input",source,location.offset,location.line,location.column,locationMap.startLine,locationMap.startColumn)}})
const parse=function(source_,options){source=source_
options=options||{}
parser.setSource(source,tokenize$4)
locationMap.setSource(source,options.offset,options.line,options.column)
filename=options.filename||"<unknown>"
needPositions=Boolean(options.positions)
onParseError=typeof options.onParseError==="function"?options.onParseError:NOOP$1
onParseErrorThrow=false
parser.parseAtrulePrelude=!("parseAtrulePrelude"in options)||Boolean(options.parseAtrulePrelude)
parser.parseRulePrelude=!("parseRulePrelude"in options)||Boolean(options.parseRulePrelude)
parser.parseValue=!("parseValue"in options)||Boolean(options.parseValue)
parser.parseCustomProperty="parseCustomProperty"in options&&Boolean(options.parseCustomProperty)
const{context:context="default",onComment:onComment}=options
if(context in parser.context===false)throw new Error("Unknown context `"+context+"`")
typeof onComment==="function"&&parser.forEachToken(((type,start,end)=>{if(type===Comment$3){const loc=parser.getLocation(start,end)
const value=cmpStr$1(source,end-2,end,"*/")?source.slice(start+2,end-2):source.slice(start+2,end)
onComment(value,loc)}}))
const ast=parser.context[context].call(parser,options)
parser.eof||parser.error()
return ast}
return Object.assign(parse,{SyntaxError:SyntaxError$4,config:parser.config})}var base64Vlq={}
var base64$1={}
var intToCharMap="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".split("")
base64$1.encode=function(number){if(0<=number&&number<intToCharMap.length)return intToCharMap[number]
throw new TypeError("Must be between 0 and 63: "+number)}
base64$1.decode=function(charCode){var bigA=65
var bigZ=90
var littleA=97
var littleZ=122
var zero=48
var nine=57
var plus=43
var slash=47
var littleOffset=26
var numberOffset=52
if(bigA<=charCode&&charCode<=bigZ)return charCode-bigA
if(littleA<=charCode&&charCode<=littleZ)return charCode-littleA+littleOffset
if(zero<=charCode&&charCode<=nine)return charCode-zero+numberOffset
if(charCode==plus)return 62
if(charCode==slash)return 63
return-1}
var base64=base64$1
var VLQ_BASE_SHIFT=5
var VLQ_BASE=1<<VLQ_BASE_SHIFT
var VLQ_BASE_MASK=VLQ_BASE-1
var VLQ_CONTINUATION_BIT=VLQ_BASE
function toVLQSigned(aValue){return aValue<0?1+(-aValue<<1):0+(aValue<<1)}function fromVLQSigned(aValue){var isNegative=(aValue&1)===1
var shifted=aValue>>1
return isNegative?-shifted:shifted}base64Vlq.encode=function base64VLQ_encode(aValue){var encoded=""
var digit
var vlq=toVLQSigned(aValue)
do{digit=vlq&VLQ_BASE_MASK
vlq>>>=VLQ_BASE_SHIFT
vlq>0&&(digit|=VLQ_CONTINUATION_BIT)
encoded+=base64.encode(digit)}while(vlq>0)
return encoded}
base64Vlq.decode=function base64VLQ_decode(aStr,aIndex,aOutParam){var strLen=aStr.length
var result=0
var shift=0
var continuation,digit
do{if(aIndex>=strLen)throw new Error("Expected more digits in base 64 VLQ value.")
digit=base64.decode(aStr.charCodeAt(aIndex++))
if(digit===-1)throw new Error("Invalid base64 digit: "+aStr.charAt(aIndex-1))
continuation=!!(digit&VLQ_CONTINUATION_BIT)
digit&=VLQ_BASE_MASK
result+=digit<<shift
shift+=VLQ_BASE_SHIFT}while(continuation)
aOutParam.value=fromVLQSigned(result)
aOutParam.rest=aIndex}
var util$3={};(function(exports){function getArg(aArgs,aName,aDefaultValue){if(aName in aArgs)return aArgs[aName]
if(arguments.length===3)return aDefaultValue
throw new Error('"'+aName+'" is a required argument.')}exports.getArg=getArg
var urlRegexp=/^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.-]*)(?::(\d+))?(.*)$/
var dataUrlRegexp=/^data:.+\,.+$/
function urlParse(aUrl){var match=aUrl.match(urlRegexp)
if(!match)return null
return{scheme:match[1],auth:match[2],host:match[3],port:match[4],path:match[5]}}exports.urlParse=urlParse
function urlGenerate(aParsedUrl){var url=""
aParsedUrl.scheme&&(url+=aParsedUrl.scheme+":")
url+="//"
aParsedUrl.auth&&(url+=aParsedUrl.auth+"@")
aParsedUrl.host&&(url+=aParsedUrl.host)
aParsedUrl.port&&(url+=":"+aParsedUrl.port)
aParsedUrl.path&&(url+=aParsedUrl.path)
return url}exports.urlGenerate=urlGenerate
var MAX_CACHED_INPUTS=32
function lruMemoize(f){var cache=[]
return function(input){for(var i=0;i<cache.length;i++)if(cache[i].input===input){var temp=cache[0]
cache[0]=cache[i]
cache[i]=temp
return cache[0].result}var result=f(input)
cache.unshift({input:input,result:result})
cache.length>MAX_CACHED_INPUTS&&cache.pop()
return result}}var normalize=lruMemoize((function normalize(aPath){var path=aPath
var url=urlParse(aPath)
if(url){if(!url.path)return aPath
path=url.path}var isAbsolute=exports.isAbsolute(path)
var parts=[]
var start=0
var i=0
while(true){start=i
i=path.indexOf("/",start)
if(i===-1){parts.push(path.slice(start))
break}parts.push(path.slice(start,i))
while(i<path.length&&path[i]==="/")i++}for(var part,up=0,i=parts.length-1;i>=0;i--){part=parts[i]
if(part===".")parts.splice(i,1)
else if(part==="..")up++
else if(up>0)if(part===""){parts.splice(i+1,up)
up=0}else{parts.splice(i,2)
up--}}path=parts.join("/")
path===""&&(path=isAbsolute?"/":".")
if(url){url.path=path
return urlGenerate(url)}return path}))
exports.normalize=normalize
function join(aRoot,aPath){aRoot===""&&(aRoot=".")
aPath===""&&(aPath=".")
var aPathUrl=urlParse(aPath)
var aRootUrl=urlParse(aRoot)
aRootUrl&&(aRoot=aRootUrl.path||"/")
if(aPathUrl&&!aPathUrl.scheme){aRootUrl&&(aPathUrl.scheme=aRootUrl.scheme)
return urlGenerate(aPathUrl)}if(aPathUrl||aPath.match(dataUrlRegexp))return aPath
if(aRootUrl&&!aRootUrl.host&&!aRootUrl.path){aRootUrl.host=aPath
return urlGenerate(aRootUrl)}var joined=aPath.charAt(0)==="/"?aPath:normalize(aRoot.replace(/\/+$/,"")+"/"+aPath)
if(aRootUrl){aRootUrl.path=joined
return urlGenerate(aRootUrl)}return joined}exports.join=join
exports.isAbsolute=function(aPath){return aPath.charAt(0)==="/"||urlRegexp.test(aPath)}
function relative(aRoot,aPath){aRoot===""&&(aRoot=".")
aRoot=aRoot.replace(/\/$/,"")
var level=0
while(aPath.indexOf(aRoot+"/")!==0){var index=aRoot.lastIndexOf("/")
if(index<0)return aPath
aRoot=aRoot.slice(0,index)
if(aRoot.match(/^([^\/]+:\/)?\/*$/))return aPath;++level}return Array(level+1).join("../")+aPath.substr(aRoot.length+1)}exports.relative=relative
var supportsNullProto=function(){var obj=Object.create(null)
return!("__proto__"in obj)}()
function identity(s){return s}function toSetString(aStr){if(isProtoString(aStr))return"$"+aStr
return aStr}exports.toSetString=supportsNullProto?identity:toSetString
function fromSetString(aStr){if(isProtoString(aStr))return aStr.slice(1)
return aStr}exports.fromSetString=supportsNullProto?identity:fromSetString
function isProtoString(s){if(!s)return false
var length=s.length
if(length<9)return false
if(s.charCodeAt(length-1)!==95||s.charCodeAt(length-2)!==95||s.charCodeAt(length-3)!==111||s.charCodeAt(length-4)!==116||s.charCodeAt(length-5)!==111||s.charCodeAt(length-6)!==114||s.charCodeAt(length-7)!==112||s.charCodeAt(length-8)!==95||s.charCodeAt(length-9)!==95)return false
for(var i=length-10;i>=0;i--)if(s.charCodeAt(i)!==36)return false
return true}function compareByOriginalPositions(mappingA,mappingB,onlyCompareOriginal){var cmp=strcmp(mappingA.source,mappingB.source)
if(cmp!==0)return cmp
cmp=mappingA.originalLine-mappingB.originalLine
if(cmp!==0)return cmp
cmp=mappingA.originalColumn-mappingB.originalColumn
if(cmp!==0||onlyCompareOriginal)return cmp
cmp=mappingA.generatedColumn-mappingB.generatedColumn
if(cmp!==0)return cmp
cmp=mappingA.generatedLine-mappingB.generatedLine
if(cmp!==0)return cmp
return strcmp(mappingA.name,mappingB.name)}exports.compareByOriginalPositions=compareByOriginalPositions
function compareByOriginalPositionsNoSource(mappingA,mappingB,onlyCompareOriginal){var cmp
cmp=mappingA.originalLine-mappingB.originalLine
if(cmp!==0)return cmp
cmp=mappingA.originalColumn-mappingB.originalColumn
if(cmp!==0||onlyCompareOriginal)return cmp
cmp=mappingA.generatedColumn-mappingB.generatedColumn
if(cmp!==0)return cmp
cmp=mappingA.generatedLine-mappingB.generatedLine
if(cmp!==0)return cmp
return strcmp(mappingA.name,mappingB.name)}exports.compareByOriginalPositionsNoSource=compareByOriginalPositionsNoSource
function compareByGeneratedPositionsDeflated(mappingA,mappingB,onlyCompareGenerated){var cmp=mappingA.generatedLine-mappingB.generatedLine
if(cmp!==0)return cmp
cmp=mappingA.generatedColumn-mappingB.generatedColumn
if(cmp!==0||onlyCompareGenerated)return cmp
cmp=strcmp(mappingA.source,mappingB.source)
if(cmp!==0)return cmp
cmp=mappingA.originalLine-mappingB.originalLine
if(cmp!==0)return cmp
cmp=mappingA.originalColumn-mappingB.originalColumn
if(cmp!==0)return cmp
return strcmp(mappingA.name,mappingB.name)}exports.compareByGeneratedPositionsDeflated=compareByGeneratedPositionsDeflated
function compareByGeneratedPositionsDeflatedNoLine(mappingA,mappingB,onlyCompareGenerated){var cmp=mappingA.generatedColumn-mappingB.generatedColumn
if(cmp!==0||onlyCompareGenerated)return cmp
cmp=strcmp(mappingA.source,mappingB.source)
if(cmp!==0)return cmp
cmp=mappingA.originalLine-mappingB.originalLine
if(cmp!==0)return cmp
cmp=mappingA.originalColumn-mappingB.originalColumn
if(cmp!==0)return cmp
return strcmp(mappingA.name,mappingB.name)}exports.compareByGeneratedPositionsDeflatedNoLine=compareByGeneratedPositionsDeflatedNoLine
function strcmp(aStr1,aStr2){if(aStr1===aStr2)return 0
if(aStr1===null)return 1
if(aStr2===null)return-1
if(aStr1>aStr2)return 1
return-1}function compareByGeneratedPositionsInflated(mappingA,mappingB){var cmp=mappingA.generatedLine-mappingB.generatedLine
if(cmp!==0)return cmp
cmp=mappingA.generatedColumn-mappingB.generatedColumn
if(cmp!==0)return cmp
cmp=strcmp(mappingA.source,mappingB.source)
if(cmp!==0)return cmp
cmp=mappingA.originalLine-mappingB.originalLine
if(cmp!==0)return cmp
cmp=mappingA.originalColumn-mappingB.originalColumn
if(cmp!==0)return cmp
return strcmp(mappingA.name,mappingB.name)}exports.compareByGeneratedPositionsInflated=compareByGeneratedPositionsInflated
function parseSourceMapInput(str){return JSON.parse(str.replace(/^\)]}'[^\n]*\n/,""))}exports.parseSourceMapInput=parseSourceMapInput
function computeSourceURL(sourceRoot,sourceURL,sourceMapURL){sourceURL=sourceURL||""
if(sourceRoot){sourceRoot[sourceRoot.length-1]!=="/"&&sourceURL[0]!=="/"&&(sourceRoot+="/")
sourceURL=sourceRoot+sourceURL}if(sourceMapURL){var parsed=urlParse(sourceMapURL)
if(!parsed)throw new Error("sourceMapURL could not be parsed")
if(parsed.path){var index=parsed.path.lastIndexOf("/")
index>=0&&(parsed.path=parsed.path.substring(0,index+1))}sourceURL=join(urlGenerate(parsed),sourceURL)}return normalize(sourceURL)}exports.computeSourceURL=computeSourceURL})(util$3)
var arraySet={}
var util$2=util$3
var has=Object.prototype.hasOwnProperty
var hasNativeMap=typeof Map!=="undefined"
function ArraySet$1(){this._array=[]
this._set=hasNativeMap?new Map:Object.create(null)}ArraySet$1.fromArray=function ArraySet_fromArray(aArray,aAllowDuplicates){var set=new ArraySet$1
for(var i=0,len=aArray.length;i<len;i++)set.add(aArray[i],aAllowDuplicates)
return set}
ArraySet$1.prototype.size=function ArraySet_size(){return hasNativeMap?this._set.size:Object.getOwnPropertyNames(this._set).length}
ArraySet$1.prototype.add=function ArraySet_add(aStr,aAllowDuplicates){var sStr=hasNativeMap?aStr:util$2.toSetString(aStr)
var isDuplicate=hasNativeMap?this.has(aStr):has.call(this._set,sStr)
var idx=this._array.length
isDuplicate&&!aAllowDuplicates||this._array.push(aStr)
isDuplicate||(hasNativeMap?this._set.set(aStr,idx):this._set[sStr]=idx)}
ArraySet$1.prototype.has=function ArraySet_has(aStr){if(hasNativeMap)return this._set.has(aStr)
var sStr=util$2.toSetString(aStr)
return has.call(this._set,sStr)}
ArraySet$1.prototype.indexOf=function ArraySet_indexOf(aStr){if(hasNativeMap){var idx=this._set.get(aStr)
if(idx>=0)return idx}else{var sStr=util$2.toSetString(aStr)
if(has.call(this._set,sStr))return this._set[sStr]}throw new Error('"'+aStr+'" is not in the set.')}
ArraySet$1.prototype.at=function ArraySet_at(aIdx){if(aIdx>=0&&aIdx<this._array.length)return this._array[aIdx]
throw new Error("No element indexed by "+aIdx)}
ArraySet$1.prototype.toArray=function ArraySet_toArray(){return this._array.slice()}
arraySet.ArraySet=ArraySet$1
var mappingList={}
var util$1=util$3
function generatedPositionAfter(mappingA,mappingB){var lineA=mappingA.generatedLine
var lineB=mappingB.generatedLine
var columnA=mappingA.generatedColumn
var columnB=mappingB.generatedColumn
return lineB>lineA||lineB==lineA&&columnB>=columnA||util$1.compareByGeneratedPositionsInflated(mappingA,mappingB)<=0}function MappingList$1(){this._array=[]
this._sorted=true
this._last={generatedLine:-1,generatedColumn:0}}MappingList$1.prototype.unsortedForEach=function MappingList_forEach(aCallback,aThisArg){this._array.forEach(aCallback,aThisArg)}
MappingList$1.prototype.add=function MappingList_add(aMapping){if(generatedPositionAfter(this._last,aMapping)){this._last=aMapping
this._array.push(aMapping)}else{this._sorted=false
this._array.push(aMapping)}}
MappingList$1.prototype.toArray=function MappingList_toArray(){if(!this._sorted){this._array.sort(util$1.compareByGeneratedPositionsInflated)
this._sorted=true}return this._array}
mappingList.MappingList=MappingList$1
var base64VLQ=base64Vlq
var util=util$3
var ArraySet=arraySet.ArraySet
var MappingList=mappingList.MappingList
function SourceMapGenerator(aArgs){aArgs||(aArgs={})
this._file=util.getArg(aArgs,"file",null)
this._sourceRoot=util.getArg(aArgs,"sourceRoot",null)
this._skipValidation=util.getArg(aArgs,"skipValidation",false)
this._ignoreInvalidMapping=util.getArg(aArgs,"ignoreInvalidMapping",false)
this._sources=new ArraySet
this._names=new ArraySet
this._mappings=new MappingList
this._sourcesContents=null}SourceMapGenerator.prototype._version=3
SourceMapGenerator.fromSourceMap=function SourceMapGenerator_fromSourceMap(aSourceMapConsumer,generatorOps){var sourceRoot=aSourceMapConsumer.sourceRoot
var generator=new SourceMapGenerator(Object.assign(generatorOps||{},{file:aSourceMapConsumer.file,sourceRoot:sourceRoot}))
aSourceMapConsumer.eachMapping((function(mapping){var newMapping={generated:{line:mapping.generatedLine,column:mapping.generatedColumn}}
if(mapping.source!=null){newMapping.source=mapping.source
sourceRoot!=null&&(newMapping.source=util.relative(sourceRoot,newMapping.source))
newMapping.original={line:mapping.originalLine,column:mapping.originalColumn}
mapping.name!=null&&(newMapping.name=mapping.name)}generator.addMapping(newMapping)}))
aSourceMapConsumer.sources.forEach((function(sourceFile){var sourceRelative=sourceFile
sourceRoot!==null&&(sourceRelative=util.relative(sourceRoot,sourceFile))
generator._sources.has(sourceRelative)||generator._sources.add(sourceRelative)
var content=aSourceMapConsumer.sourceContentFor(sourceFile)
content!=null&&generator.setSourceContent(sourceFile,content)}))
return generator}
SourceMapGenerator.prototype.addMapping=function SourceMapGenerator_addMapping(aArgs){var generated=util.getArg(aArgs,"generated")
var original=util.getArg(aArgs,"original",null)
var source=util.getArg(aArgs,"source",null)
var name=util.getArg(aArgs,"name",null)
if(!this._skipValidation&&this._validateMapping(generated,original,source,name)===false)return
if(source!=null){source=String(source)
this._sources.has(source)||this._sources.add(source)}if(name!=null){name=String(name)
this._names.has(name)||this._names.add(name)}this._mappings.add({generatedLine:generated.line,generatedColumn:generated.column,originalLine:original!=null&&original.line,originalColumn:original!=null&&original.column,source:source,name:name})}
SourceMapGenerator.prototype.setSourceContent=function SourceMapGenerator_setSourceContent(aSourceFile,aSourceContent){var source=aSourceFile
this._sourceRoot!=null&&(source=util.relative(this._sourceRoot,source))
if(aSourceContent!=null){this._sourcesContents||(this._sourcesContents=Object.create(null))
this._sourcesContents[util.toSetString(source)]=aSourceContent}else if(this._sourcesContents){delete this._sourcesContents[util.toSetString(source)]
Object.keys(this._sourcesContents).length===0&&(this._sourcesContents=null)}}
SourceMapGenerator.prototype.applySourceMap=function SourceMapGenerator_applySourceMap(aSourceMapConsumer,aSourceFile,aSourceMapPath){var sourceFile=aSourceFile
if(aSourceFile==null){if(aSourceMapConsumer.file==null)throw new Error('SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, or the source map\'s "file" property. Both were omitted.')
sourceFile=aSourceMapConsumer.file}var sourceRoot=this._sourceRoot
sourceRoot!=null&&(sourceFile=util.relative(sourceRoot,sourceFile))
var newSources=new ArraySet
var newNames=new ArraySet
this._mappings.unsortedForEach((function(mapping){if(mapping.source===sourceFile&&mapping.originalLine!=null){var original=aSourceMapConsumer.originalPositionFor({line:mapping.originalLine,column:mapping.originalColumn})
if(original.source!=null){mapping.source=original.source
aSourceMapPath!=null&&(mapping.source=util.join(aSourceMapPath,mapping.source))
sourceRoot!=null&&(mapping.source=util.relative(sourceRoot,mapping.source))
mapping.originalLine=original.line
mapping.originalColumn=original.column
original.name!=null&&(mapping.name=original.name)}}var source=mapping.source
source==null||newSources.has(source)||newSources.add(source)
var name=mapping.name
name==null||newNames.has(name)||newNames.add(name)}),this)
this._sources=newSources
this._names=newNames
aSourceMapConsumer.sources.forEach((function(sourceFile){var content=aSourceMapConsumer.sourceContentFor(sourceFile)
if(content!=null){aSourceMapPath!=null&&(sourceFile=util.join(aSourceMapPath,sourceFile))
sourceRoot!=null&&(sourceFile=util.relative(sourceRoot,sourceFile))
this.setSourceContent(sourceFile,content)}}),this)}
SourceMapGenerator.prototype._validateMapping=function SourceMapGenerator_validateMapping(aGenerated,aOriginal,aSource,aName){if(aOriginal&&typeof aOriginal.line!=="number"&&typeof aOriginal.column!=="number"){var message="original.line and original.column are not numbers -- you probably meant to omit the original mapping entirely and only map the generated position. If so, pass null for the original mapping instead of an object with empty or null values."
if(this._ignoreInvalidMapping){typeof console!=="undefined"&&console.warn&&console.warn(message)
return false}throw new Error(message)}if(aGenerated&&"line"in aGenerated&&"column"in aGenerated&&aGenerated.line>0&&aGenerated.column>=0&&!aOriginal&&!aSource&&!aName)return
if(aGenerated&&"line"in aGenerated&&"column"in aGenerated&&aOriginal&&"line"in aOriginal&&"column"in aOriginal&&aGenerated.line>0&&aGenerated.column>=0&&aOriginal.line>0&&aOriginal.column>=0&&aSource)return
var message="Invalid mapping: "+JSON.stringify({generated:aGenerated,source:aSource,original:aOriginal,name:aName})
if(this._ignoreInvalidMapping){typeof console!=="undefined"&&console.warn&&console.warn(message)
return false}throw new Error(message)}
SourceMapGenerator.prototype._serializeMappings=function SourceMapGenerator_serializeMappings(){var previousGeneratedColumn=0
var previousGeneratedLine=1
var previousOriginalColumn=0
var previousOriginalLine=0
var previousName=0
var previousSource=0
var result=""
var next
var mapping
var nameIdx
var sourceIdx
var mappings=this._mappings.toArray()
for(var i=0,len=mappings.length;i<len;i++){mapping=mappings[i]
next=""
if(mapping.generatedLine!==previousGeneratedLine){previousGeneratedColumn=0
while(mapping.generatedLine!==previousGeneratedLine){next+=";"
previousGeneratedLine++}}else if(i>0){if(!util.compareByGeneratedPositionsInflated(mapping,mappings[i-1]))continue
next+=","}next+=base64VLQ.encode(mapping.generatedColumn-previousGeneratedColumn)
previousGeneratedColumn=mapping.generatedColumn
if(mapping.source!=null){sourceIdx=this._sources.indexOf(mapping.source)
next+=base64VLQ.encode(sourceIdx-previousSource)
previousSource=sourceIdx
next+=base64VLQ.encode(mapping.originalLine-1-previousOriginalLine)
previousOriginalLine=mapping.originalLine-1
next+=base64VLQ.encode(mapping.originalColumn-previousOriginalColumn)
previousOriginalColumn=mapping.originalColumn
if(mapping.name!=null){nameIdx=this._names.indexOf(mapping.name)
next+=base64VLQ.encode(nameIdx-previousName)
previousName=nameIdx}}result+=next}return result}
SourceMapGenerator.prototype._generateSourcesContent=function SourceMapGenerator_generateSourcesContent(aSources,aSourceRoot){return aSources.map((function(source){if(!this._sourcesContents)return null
aSourceRoot!=null&&(source=util.relative(aSourceRoot,source))
var key=util.toSetString(source)
return Object.prototype.hasOwnProperty.call(this._sourcesContents,key)?this._sourcesContents[key]:null}),this)}
SourceMapGenerator.prototype.toJSON=function SourceMapGenerator_toJSON(){var map={version:this._version,sources:this._sources.toArray(),names:this._names.toArray(),mappings:this._serializeMappings()}
this._file!=null&&(map.file=this._file)
this._sourceRoot!=null&&(map.sourceRoot=this._sourceRoot)
this._sourcesContents&&(map.sourcesContent=this._generateSourcesContent(map.sources,map.sourceRoot))
return map}
SourceMapGenerator.prototype.toString=function SourceMapGenerator_toString(){return JSON.stringify(this.toJSON())}
var SourceMapGenerator_1=SourceMapGenerator
const trackNodes$1=new Set(["Atrule","Selector","Declaration"])
function generateSourceMap$1(handlers){const map=new SourceMapGenerator_1
const generated={line:1,column:0}
const original={line:0,column:0}
const activatedGenerated={line:1,column:0}
const activatedMapping={generated:activatedGenerated}
let line=1
let column=0
let sourceMappingActive=false
const origHandlersNode=handlers.node
handlers.node=function(node){if(node.loc&&node.loc.start&&trackNodes$1.has(node.type)){const nodeLine=node.loc.start.line
const nodeColumn=node.loc.start.column-1
if(original.line!==nodeLine||original.column!==nodeColumn){original.line=nodeLine
original.column=nodeColumn
generated.line=line
generated.column=column
if(sourceMappingActive){sourceMappingActive=false
generated.line===activatedGenerated.line&&generated.column===activatedGenerated.column||map.addMapping(activatedMapping)}sourceMappingActive=true
map.addMapping({source:node.loc.source,original:original,generated:generated})}}origHandlersNode.call(this,node)
if(sourceMappingActive&&trackNodes$1.has(node.type)){activatedGenerated.line=line
activatedGenerated.column=column}}
const origHandlersEmit=handlers.emit
handlers.emit=function(value,type,auto){for(let i=0;i<value.length;i++)if(value.charCodeAt(i)===10){line++
column=0}else column++
origHandlersEmit(value,type,auto)}
const origHandlersResult=handlers.result
handlers.result=function(){sourceMappingActive&&map.addMapping(activatedMapping)
return{css:origHandlersResult(),map:map}}
return handlers}const PLUSSIGN$j=0x002B
const HYPHENMINUS$d=0x002D
const code$1=(type,value)=>{type===Delim$1&&(type=value)
if(typeof type==="string"){const charCode=type.charCodeAt(0)
return charCode>0x7F?0x8000:charCode<<8}return type}
const specPairs$1=[[Ident$1,Ident$1],[Ident$1,Function$3],[Ident$1,Url$4],[Ident$1,BadUrl$1],[Ident$1,"-"],[Ident$1,Number$5],[Ident$1,Percentage$3],[Ident$1,Dimension$3],[Ident$1,CDC$3],[Ident$1,LeftParenthesis$1],[AtKeyword$1,Ident$1],[AtKeyword$1,Function$3],[AtKeyword$1,Url$4],[AtKeyword$1,BadUrl$1],[AtKeyword$1,"-"],[AtKeyword$1,Number$5],[AtKeyword$1,Percentage$3],[AtKeyword$1,Dimension$3],[AtKeyword$1,CDC$3],[Hash$3,Ident$1],[Hash$3,Function$3],[Hash$3,Url$4],[Hash$3,BadUrl$1],[Hash$3,"-"],[Hash$3,Number$5],[Hash$3,Percentage$3],[Hash$3,Dimension$3],[Hash$3,CDC$3],[Dimension$3,Ident$1],[Dimension$3,Function$3],[Dimension$3,Url$4],[Dimension$3,BadUrl$1],[Dimension$3,"-"],[Dimension$3,Number$5],[Dimension$3,Percentage$3],[Dimension$3,Dimension$3],[Dimension$3,CDC$3],["#",Ident$1],["#",Function$3],["#",Url$4],["#",BadUrl$1],["#","-"],["#",Number$5],["#",Percentage$3],["#",Dimension$3],["#",CDC$3],["-",Ident$1],["-",Function$3],["-",Url$4],["-",BadUrl$1],["-","-"],["-",Number$5],["-",Percentage$3],["-",Dimension$3],["-",CDC$3],[Number$5,Ident$1],[Number$5,Function$3],[Number$5,Url$4],[Number$5,BadUrl$1],[Number$5,Number$5],[Number$5,Percentage$3],[Number$5,Dimension$3],[Number$5,"%"],[Number$5,CDC$3],["@",Ident$1],["@",Function$3],["@",Url$4],["@",BadUrl$1],["@","-"],["@",CDC$3],[".",Number$5],[".",Percentage$3],[".",Dimension$3],["+",Number$5],["+",Percentage$3],["+",Dimension$3],["/","*"]]
const safePairs$1=specPairs$1.concat([[Ident$1,Hash$3],[Dimension$3,Hash$3],[Hash$3,Hash$3],[AtKeyword$1,LeftParenthesis$1],[AtKeyword$1,String$4],[AtKeyword$1,Colon$1],[Percentage$3,Percentage$3],[Percentage$3,Dimension$3],[Percentage$3,Function$3],[Percentage$3,"-"],[RightParenthesis$1,Ident$1],[RightParenthesis$1,Function$3],[RightParenthesis$1,Percentage$3],[RightParenthesis$1,Dimension$3],[RightParenthesis$1,Hash$3],[RightParenthesis$1,"-"]])
function createMap$1(pairs){const isWhiteSpaceRequired=new Set(pairs.map((([prev,next])=>code$1(prev)<<16|code$1(next))))
return function(prevCode,type,value){const nextCode=code$1(type,value)
const nextCharCode=value.charCodeAt(0)
const emitWs=nextCharCode===HYPHENMINUS$d&&type!==Ident$1&&type!==Function$3&&type!==CDC$3||nextCharCode===PLUSSIGN$j?isWhiteSpaceRequired.has(prevCode<<16|nextCharCode<<8):isWhiteSpaceRequired.has(prevCode<<16|nextCode)
emitWs&&this.emit(" ",WhiteSpace$3,true)
return nextCode}}const spec$1=createMap$1(specPairs$1)
const safe$1=createMap$1(safePairs$1)
var tokenBefore$1=Object.freeze({__proto__:null,safe:safe$1,spec:spec$1})
const REVERSESOLIDUS$1=0x005c
function processChildren$1(node,delimeter){if(typeof delimeter==="function"){let prev=null
node.children.forEach((node=>{prev!==null&&delimeter.call(this,prev)
this.node(node)
prev=node}))
return}node.children.forEach(this.node,this)}function processChunk$1(chunk){tokenize$4(chunk,((type,start,end)=>{this.token(type,chunk.slice(start,end))}))}function createGenerator$1(config){const types=new Map
for(let[name,item]of Object.entries(config.node)){const fn=item.generate||item
typeof fn==="function"&&types.set(name,item.generate||item)}return function(node,options){let buffer=""
let prevCode=0
let handlers={node(node){if(!types.has(node.type))throw new Error("Unknown node type: "+node.type)
types.get(node.type).call(publicApi,node)},tokenBefore:safe$1,token(type,value){prevCode=this.tokenBefore(prevCode,type,value)
this.emit(value,type,false)
type===Delim$1&&value.charCodeAt(0)===REVERSESOLIDUS$1&&this.emit("\n",WhiteSpace$3,true)},emit(value){buffer+=value},result:()=>buffer}
if(options){typeof options.decorator==="function"&&(handlers=options.decorator(handlers))
options.sourceMap&&(handlers=generateSourceMap$1(handlers))
options.mode in tokenBefore$1&&(handlers.tokenBefore=tokenBefore$1[options.mode])}const publicApi={node:node=>handlers.node(node),children:processChildren$1,token:(type,value)=>handlers.token(type,value),tokenize:processChunk$1}
handlers.node(node)
return handlers.result()}}function createConvertor$1(walk){return{fromPlainObject(ast){walk(ast,{enter(node){node.children&&node.children instanceof List$1===false&&(node.children=(new List$1).fromArray(node.children))}})
return ast},toPlainObject(ast){walk(ast,{leave(node){node.children&&node.children instanceof List$1&&(node.children=node.children.toArray())}})
return ast}}}const{hasOwnProperty:hasOwnProperty$b}=Object.prototype
const noop$5=function(){}
function ensureFunction$3(value){return typeof value==="function"?value:noop$5}function invokeForType$1(fn,type){return function(node,item,list){node.type===type&&fn.call(this,node,item,list)}}function getWalkersFromStructure$1(name,nodeType){const structure=nodeType.structure
const walkers=[]
for(const key in structure){if(hasOwnProperty$b.call(structure,key)===false)continue
let fieldTypes=structure[key]
const walker={name:key,type:false,nullable:false}
Array.isArray(fieldTypes)||(fieldTypes=[fieldTypes])
for(const fieldType of fieldTypes)fieldType===null?walker.nullable=true:typeof fieldType==="string"?walker.type="node":Array.isArray(fieldType)&&(walker.type="list")
walker.type&&walkers.push(walker)}if(walkers.length)return{context:nodeType.walkContext,fields:walkers}
return null}function getTypesFromConfig$1(config){const types={}
for(const name in config.node)if(hasOwnProperty$b.call(config.node,name)){const nodeType=config.node[name]
if(!nodeType.structure)throw new Error("Missed `structure` field in `"+name+"` node type definition")
types[name]=getWalkersFromStructure$1(name,nodeType)}return types}function createTypeIterator$1(config,reverse){const fields=config.fields.slice()
const contextName=config.context
const useContext=typeof contextName==="string"
reverse&&fields.reverse()
return function(node,context,walk,walkReducer){let prevContextValue
if(useContext){prevContextValue=context[contextName]
context[contextName]=node}for(const field of fields){const ref=node[field.name]
if(!field.nullable||ref)if(field.type==="list"){const breakWalk=reverse?ref.reduceRight(walkReducer,false):ref.reduce(walkReducer,false)
if(breakWalk)return true}else if(walk(ref))return true}useContext&&(context[contextName]=prevContextValue)}}function createFastTraveralMap$1({StyleSheet:StyleSheet,Atrule:Atrule,Rule:Rule,Block:Block,DeclarationList:DeclarationList}){return{Atrule:{StyleSheet:StyleSheet,Atrule:Atrule,Rule:Rule,Block:Block},Rule:{StyleSheet:StyleSheet,Atrule:Atrule,Rule:Rule,Block:Block},Declaration:{StyleSheet:StyleSheet,Atrule:Atrule,Rule:Rule,Block:Block,DeclarationList:DeclarationList}}}function createWalker$1(config){const types=getTypesFromConfig$1(config)
const iteratorsNatural={}
const iteratorsReverse={}
const breakWalk=Symbol("break-walk")
const skipNode=Symbol("skip-node")
for(const name in types)if(hasOwnProperty$b.call(types,name)&&types[name]!==null){iteratorsNatural[name]=createTypeIterator$1(types[name],false)
iteratorsReverse[name]=createTypeIterator$1(types[name],true)}const fastTraversalIteratorsNatural=createFastTraveralMap$1(iteratorsNatural)
const fastTraversalIteratorsReverse=createFastTraveralMap$1(iteratorsReverse)
const walk=function(root,options){function walkNode(node,item,list){const enterRet=enter.call(context,node,item,list)
if(enterRet===breakWalk)return true
if(enterRet===skipNode)return false
if(iterators.hasOwnProperty(node.type)&&iterators[node.type](node,context,walkNode,walkReducer))return true
if(leave.call(context,node,item,list)===breakWalk)return true
return false}let enter=noop$5
let leave=noop$5
let iterators=iteratorsNatural
let walkReducer=(ret,data,item,list)=>ret||walkNode(data,item,list)
const context={break:breakWalk,skip:skipNode,root:root,stylesheet:null,atrule:null,atrulePrelude:null,rule:null,selector:null,block:null,declaration:null,function:null}
if(typeof options==="function")enter=options
else if(options){enter=ensureFunction$3(options.enter)
leave=ensureFunction$3(options.leave)
options.reverse&&(iterators=iteratorsReverse)
if(options.visit){if(fastTraversalIteratorsNatural.hasOwnProperty(options.visit))iterators=options.reverse?fastTraversalIteratorsReverse[options.visit]:fastTraversalIteratorsNatural[options.visit]
else if(!types.hasOwnProperty(options.visit))throw new Error("Bad value `"+options.visit+"` for `visit` option (should be: "+Object.keys(types).sort().join(", ")+")")
enter=invokeForType$1(enter,options.visit)
leave=invokeForType$1(leave,options.visit)}}if(enter===noop$5&&leave===noop$5)throw new Error("Neither `enter` nor `leave` walker handler is set or both aren't a function")
walkNode(root)}
walk.break=breakWalk
walk.skip=skipNode
walk.find=function(ast,fn){let found=null
walk(ast,(function(node,item,list){if(fn.call(this,node,item,list)){found=node
return breakWalk}}))
return found}
walk.findLast=function(ast,fn){let found=null
walk(ast,{reverse:true,enter(node,item,list){if(fn.call(this,node,item,list)){found=node
return breakWalk}}})
return found}
walk.findAll=function(ast,fn){const found=[]
walk(ast,(function(node,item,list){fn.call(this,node,item,list)&&found.push(node)}))
return found}
return walk}function noop$4(value){return value}function generateMultiplier$1(multiplier){const{min:min,max:max,comma:comma}=multiplier
if(min===0&&max===0)return comma?"#?":"*"
if(min===0&&max===1)return"?"
if(min===1&&max===0)return comma?"#":"+"
if(min===1&&max===1)return""
return(comma?"#":"")+(min===max?"{"+min+"}":"{"+min+","+(max!==0?max:"")+"}")}function generateTypeOpts$1(node){switch(node.type){case"Range":return" ["+(node.min===null?"-∞":node.min)+","+(node.max===null?"∞":node.max)+"]"
default:throw new Error("Unknown node type `"+node.type+"`")}}function generateSequence$1(node,decorate,forceBraces,compact){const combinator=node.combinator===" "||compact?node.combinator:" "+node.combinator+" "
const result=node.terms.map((term=>internalGenerate$1(term,decorate,forceBraces,compact))).join(combinator)
if(node.explicit||forceBraces)return(compact||result[0]===","?"[":"[ ")+result+(compact?"]":" ]")
return result}function internalGenerate$1(node,decorate,forceBraces,compact){let result
switch(node.type){case"Group":result=generateSequence$1(node,decorate,forceBraces,compact)+(node.disallowEmpty?"!":"")
break
case"Multiplier":return internalGenerate$1(node.term,decorate,forceBraces,compact)+decorate(generateMultiplier$1(node),node)
case"Type":result="<"+node.name+(node.opts?decorate(generateTypeOpts$1(node.opts),node.opts):"")+">"
break
case"Property":result="<'"+node.name+"'>"
break
case"Keyword":result=node.name
break
case"AtKeyword":result="@"+node.name
break
case"Function":result=node.name+"("
break
case"String":case"Token":result=node.value
break
case"Comma":result=","
break
default:throw new Error("Unknown node type `"+node.type+"`")}return decorate(result,node)}function generate$1u(node,options){let decorate=noop$4
let forceBraces=false
let compact=false
if(typeof options==="function")decorate=options
else if(options){forceBraces=Boolean(options.forceBraces)
compact=Boolean(options.compact)
typeof options.decorate==="function"&&(decorate=options.decorate)}return internalGenerate$1(node,decorate,forceBraces,compact)}const defaultLoc$1={offset:0,line:1,column:1}
function locateMismatch$1(matchResult,node){const tokens=matchResult.tokens
const longestMatch=matchResult.longestMatch
const mismatchNode=longestMatch<tokens.length&&tokens[longestMatch].node||null
const badNode=mismatchNode!==node?mismatchNode:null
let mismatchOffset=0
let mismatchLength=0
let entries=0
let css=""
let start
let end
for(let i=0;i<tokens.length;i++){const token=tokens[i].value
if(i===longestMatch){mismatchLength=token.length
mismatchOffset=css.length}badNode!==null&&tokens[i].node===badNode&&(i<=longestMatch?entries++:entries=0)
css+=token}if(longestMatch===tokens.length||entries>1){start=fromLoc$1(badNode||node,"end")||buildLoc$1(defaultLoc$1,css)
end=buildLoc$1(start)}else{start=fromLoc$1(badNode,"start")||buildLoc$1(fromLoc$1(node,"start")||defaultLoc$1,css.slice(0,mismatchOffset))
end=fromLoc$1(badNode,"end")||buildLoc$1(start,css.substr(mismatchOffset,mismatchLength))}return{css:css,mismatchOffset:mismatchOffset,mismatchLength:mismatchLength,start:start,end:end}}function fromLoc$1(node,point){const value=node&&node.loc&&node.loc[point]
if(value)return"line"in value?buildLoc$1(value):value
return null}function buildLoc$1({offset:offset,line:line,column:column},extra){const loc={offset:offset,line:line,column:column}
if(extra){const lines=extra.split(/\n|\r\n?|\f/)
loc.offset+=extra.length
loc.line+=lines.length-1
loc.column=lines.length===1?loc.column+extra.length:lines.pop().length+1}return loc}const SyntaxReferenceError$1=function(type,referenceName){const error=createCustomError$1("SyntaxReferenceError",type+(referenceName?" `"+referenceName+"`":""))
error.reference=referenceName
return error}
const SyntaxMatchError$1=function(message,syntax,node,matchResult){const error=createCustomError$1("SyntaxMatchError",message)
const{css:css,mismatchOffset:mismatchOffset,mismatchLength:mismatchLength,start:start,end:end}=locateMismatch$1(matchResult,node)
error.rawMessage=message
error.syntax=syntax?generate$1u(syntax):"<generic>"
error.css=css
error.mismatchOffset=mismatchOffset
error.mismatchLength=mismatchLength
error.message=message+"\n  syntax: "+error.syntax+"\n   value: "+(css||"<empty string>")+"\n  --------"+new Array(error.mismatchOffset+1).join("-")+"^"
Object.assign(error,start)
error.loc={source:node&&node.loc&&node.loc.source||"<unknown>",start:start,end:end}
return error}
const keywords$1=new Map
const properties$1=new Map
const HYPHENMINUS$c=45
const keyword$1=getKeywordDescriptor$1
const property$1=getPropertyDescriptor$1
function isCustomProperty$1(str,offset){offset=offset||0
return str.length-offset>=2&&str.charCodeAt(offset)===HYPHENMINUS$c&&str.charCodeAt(offset+1)===HYPHENMINUS$c}function getVendorPrefix$1(str,offset){offset=offset||0
if(str.length-offset>=3&&str.charCodeAt(offset)===HYPHENMINUS$c&&str.charCodeAt(offset+1)!==HYPHENMINUS$c){const secondDashIndex=str.indexOf("-",offset+2)
if(secondDashIndex!==-1)return str.substring(offset,secondDashIndex+1)}return""}function getKeywordDescriptor$1(keyword){if(keywords$1.has(keyword))return keywords$1.get(keyword)
const name=keyword.toLowerCase()
let descriptor=keywords$1.get(name)
if(descriptor===void 0){const custom=isCustomProperty$1(name,0)
const vendor=custom?"":getVendorPrefix$1(name,0)
descriptor=Object.freeze({basename:name.substr(vendor.length),name:name,prefix:vendor,vendor:vendor,custom:custom})}keywords$1.set(keyword,descriptor)
return descriptor}function getPropertyDescriptor$1(property){if(properties$1.has(property))return properties$1.get(property)
let name=property
let hack=property[0]
hack==="/"?hack=property[1]==="/"?"//":"/":hack!=="_"&&hack!=="*"&&hack!=="$"&&hack!=="#"&&hack!=="+"&&hack!=="&"&&(hack="")
const custom=isCustomProperty$1(name,hack.length)
if(!custom){name=name.toLowerCase()
if(properties$1.has(name)){const descriptor=properties$1.get(name)
properties$1.set(property,descriptor)
return descriptor}}const vendor=custom?"":getVendorPrefix$1(name,hack.length)
const prefix=name.substr(0,hack.length+vendor.length)
const descriptor=Object.freeze({basename:name.substr(prefix.length),name:name.substr(hack.length),hack:hack,vendor:vendor,prefix:prefix,custom:custom})
properties$1.set(property,descriptor)
return descriptor}const cssWideKeywords$1=["initial","inherit","unset","revert","revert-layer"]
const PLUSSIGN$i=0x002B
const HYPHENMINUS$b=0x002D
const N$8=0x006E
const DISALLOW_SIGN$3=true
const ALLOW_SIGN$3=false
function isDelim$3(token,code){return token!==null&&token.type===Delim$1&&token.value.charCodeAt(0)===code}function skipSC$1(token,offset,getNextToken){while(token!==null&&(token.type===WhiteSpace$3||token.type===Comment$3))token=getNextToken(++offset)
return offset}function checkInteger$3(token,valueOffset,disallowSign,offset){if(!token)return 0
const code=token.value.charCodeAt(valueOffset)
if(code===PLUSSIGN$i||code===HYPHENMINUS$b){if(disallowSign)return 0
valueOffset++}for(;valueOffset<token.value.length;valueOffset++)if(!isDigit$2(token.value.charCodeAt(valueOffset)))return 0
return offset+1}function consumeB$3(token,offset_,getNextToken){let sign=false
let offset=skipSC$1(token,offset_,getNextToken)
token=getNextToken(offset)
if(token===null)return offset_
if(token.type!==Number$5){if(!isDelim$3(token,PLUSSIGN$i)&&!isDelim$3(token,HYPHENMINUS$b))return offset_
sign=true
offset=skipSC$1(getNextToken(++offset),offset,getNextToken)
token=getNextToken(offset)
if(token===null||token.type!==Number$5)return 0}if(!sign){const code=token.value.charCodeAt(0)
if(code!==PLUSSIGN$i&&code!==HYPHENMINUS$b)return 0}return checkInteger$3(token,sign?0:1,sign,offset)}function anPlusB$1(token,getNextToken){let offset=0
if(!token)return 0
if(token.type===Number$5)return checkInteger$3(token,0,ALLOW_SIGN$3,offset)
if(token.type===Ident$1&&token.value.charCodeAt(0)===HYPHENMINUS$b){if(!cmpChar$1(token.value,1,N$8))return 0
switch(token.value.length){case 2:return consumeB$3(getNextToken(++offset),offset,getNextToken)
case 3:if(token.value.charCodeAt(2)!==HYPHENMINUS$b)return 0
offset=skipSC$1(getNextToken(++offset),offset,getNextToken)
token=getNextToken(offset)
return checkInteger$3(token,0,DISALLOW_SIGN$3,offset)
default:if(token.value.charCodeAt(2)!==HYPHENMINUS$b)return 0
return checkInteger$3(token,3,DISALLOW_SIGN$3,offset)}}else if(token.type===Ident$1||isDelim$3(token,PLUSSIGN$i)&&getNextToken(offset+1).type===Ident$1){token.type!==Ident$1&&(token=getNextToken(++offset))
if(token===null||!cmpChar$1(token.value,0,N$8))return 0
switch(token.value.length){case 1:return consumeB$3(getNextToken(++offset),offset,getNextToken)
case 2:if(token.value.charCodeAt(1)!==HYPHENMINUS$b)return 0
offset=skipSC$1(getNextToken(++offset),offset,getNextToken)
token=getNextToken(offset)
return checkInteger$3(token,0,DISALLOW_SIGN$3,offset)
default:if(token.value.charCodeAt(1)!==HYPHENMINUS$b)return 0
return checkInteger$3(token,2,DISALLOW_SIGN$3,offset)}}else if(token.type===Dimension$3){let code=token.value.charCodeAt(0)
let sign=code===PLUSSIGN$i||code===HYPHENMINUS$b?1:0
let i=sign
for(;i<token.value.length;i++)if(!isDigit$2(token.value.charCodeAt(i)))break
if(i===sign)return 0
if(!cmpChar$1(token.value,i,N$8))return 0
if(i+1===token.value.length)return consumeB$3(getNextToken(++offset),offset,getNextToken)
if(token.value.charCodeAt(i+1)!==HYPHENMINUS$b)return 0
if(i+2===token.value.length){offset=skipSC$1(getNextToken(++offset),offset,getNextToken)
token=getNextToken(offset)
return checkInteger$3(token,0,DISALLOW_SIGN$3,offset)}return checkInteger$3(token,i+2,DISALLOW_SIGN$3,offset)}return 0}const PLUSSIGN$h=0x002B
const HYPHENMINUS$a=0x002D
const QUESTIONMARK$5=0x003F
const U$3=0x0075
function isDelim$2(token,code){return token!==null&&token.type===Delim$1&&token.value.charCodeAt(0)===code}function startsWith$3(token,code){return token.value.charCodeAt(0)===code}function hexSequence$1(token,offset,allowDash){let hexlen=0
for(let pos=offset;pos<token.value.length;pos++){const code=token.value.charCodeAt(pos)
if(code===HYPHENMINUS$a&&allowDash&&hexlen!==0){hexSequence$1(token,offset+hexlen+1,false)
return 6}if(!isHexDigit$1(code))return 0
if(++hexlen>6)return 0}return hexlen}function withQuestionMarkSequence$1(consumed,length,getNextToken){if(!consumed)return 0
while(isDelim$2(getNextToken(length),QUESTIONMARK$5)){if(++consumed>6)return 0
length++}return length}function urange$1(token,getNextToken){let length=0
if(token===null||token.type!==Ident$1||!cmpChar$1(token.value,0,U$3))return 0
token=getNextToken(++length)
if(token===null)return 0
if(isDelim$2(token,PLUSSIGN$h)){token=getNextToken(++length)
if(token===null)return 0
if(token.type===Ident$1)return withQuestionMarkSequence$1(hexSequence$1(token,0,true),++length,getNextToken)
if(isDelim$2(token,QUESTIONMARK$5))return withQuestionMarkSequence$1(1,++length,getNextToken)
return 0}if(token.type===Number$5){const consumedHexLength=hexSequence$1(token,1,true)
if(consumedHexLength===0)return 0
token=getNextToken(++length)
if(token===null)return length
if(token.type===Dimension$3||token.type===Number$5){if(!startsWith$3(token,HYPHENMINUS$a)||!hexSequence$1(token,1,false))return 0
return length+1}return withQuestionMarkSequence$1(consumedHexLength,length,getNextToken)}if(token.type===Dimension$3)return withQuestionMarkSequence$1(hexSequence$1(token,1,true),++length,getNextToken)
return 0}const calcFunctionNames$1=["calc(","-moz-calc(","-webkit-calc("]
const balancePair$2=new Map([[Function$3,RightParenthesis$1],[LeftParenthesis$1,RightParenthesis$1],[LeftSquareBracket$1,RightSquareBracket$1],[LeftCurlyBracket$1,RightCurlyBracket$1]])
function charCodeAt$1(str,index){return index<str.length?str.charCodeAt(index):0}function eqStr$1(actual,expected){return cmpStr$1(actual,0,actual.length,expected)}function eqStrAny$1(actual,expected){for(let i=0;i<expected.length;i++)if(eqStr$1(actual,expected[i]))return true
return false}function isPostfixIeHack$1(str,offset){if(offset!==str.length-2)return false
return charCodeAt$1(str,offset)===0x005C&&isDigit$2(charCodeAt$1(str,offset+1))}function outOfRange$1(opts,value,numEnd){if(opts&&opts.type==="Range"){const num=Number(numEnd!==void 0&&numEnd!==value.length?value.substr(0,numEnd):value)
if(isNaN(num))return true
if(opts.min!==null&&num<opts.min&&typeof opts.min!=="string")return true
if(opts.max!==null&&num>opts.max&&typeof opts.max!=="string")return true}return false}function consumeFunction$1(token,getNextToken){let balanceCloseType=0
let balanceStash=[]
let length=0
scan:do{switch(token.type){case RightCurlyBracket$1:case RightParenthesis$1:case RightSquareBracket$1:if(token.type!==balanceCloseType)break scan
balanceCloseType=balanceStash.pop()
if(balanceStash.length===0){length++
break scan}break
case Function$3:case LeftParenthesis$1:case LeftSquareBracket$1:case LeftCurlyBracket$1:balanceStash.push(balanceCloseType)
balanceCloseType=balancePair$2.get(token.type)
break}length++}while(token=getNextToken(length))
return length}function calc$1(next){return function(token,getNextToken,opts){if(token===null)return 0
if(token.type===Function$3&&eqStrAny$1(token.value,calcFunctionNames$1))return consumeFunction$1(token,getNextToken)
return next(token,getNextToken,opts)}}function tokenType$1(expectedTokenType){return function(token){if(token===null||token.type!==expectedTokenType)return 0
return 1}}function customIdent$1(token){if(token===null||token.type!==Ident$1)return 0
const name=token.value.toLowerCase()
if(eqStrAny$1(name,cssWideKeywords$1))return 0
if(eqStr$1(name,"default"))return 0
return 1}function dashedIdent(token){if(token===null||token.type!==Ident$1)return 0
if(charCodeAt$1(token.value,0)!==0x002D||charCodeAt$1(token.value,1)!==0x002D)return 0
return 1}function customPropertyName$1(token){if(!dashedIdent(token))return 0
if(token.value==="--")return 0
return 1}function hexColor$1(token){if(token===null||token.type!==Hash$3)return 0
const length=token.value.length
if(length!==4&&length!==5&&length!==7&&length!==9)return 0
for(let i=1;i<length;i++)if(!isHexDigit$1(charCodeAt$1(token.value,i)))return 0
return 1}function idSelector$1(token){if(token===null||token.type!==Hash$3)return 0
if(!isIdentifierStart$1(charCodeAt$1(token.value,1),charCodeAt$1(token.value,2),charCodeAt$1(token.value,3)))return 0
return 1}function declarationValue$1(token,getNextToken){if(!token)return 0
let balanceCloseType=0
let balanceStash=[]
let length=0
scan:do{switch(token.type){case BadString$1:case BadUrl$1:break scan
case RightCurlyBracket$1:case RightParenthesis$1:case RightSquareBracket$1:if(token.type!==balanceCloseType)break scan
balanceCloseType=balanceStash.pop()
break
case Semicolon$1:if(balanceCloseType===0)break scan
break
case Delim$1:if(balanceCloseType===0&&token.value==="!")break scan
break
case Function$3:case LeftParenthesis$1:case LeftSquareBracket$1:case LeftCurlyBracket$1:balanceStash.push(balanceCloseType)
balanceCloseType=balancePair$2.get(token.type)
break}length++}while(token=getNextToken(length))
return length}function anyValue$1(token,getNextToken){if(!token)return 0
let balanceCloseType=0
let balanceStash=[]
let length=0
scan:do{switch(token.type){case BadString$1:case BadUrl$1:break scan
case RightCurlyBracket$1:case RightParenthesis$1:case RightSquareBracket$1:if(token.type!==balanceCloseType)break scan
balanceCloseType=balanceStash.pop()
break
case Function$3:case LeftParenthesis$1:case LeftSquareBracket$1:case LeftCurlyBracket$1:balanceStash.push(balanceCloseType)
balanceCloseType=balancePair$2.get(token.type)
break}length++}while(token=getNextToken(length))
return length}function dimension$1(type){type&&(type=new Set(type))
return function(token,getNextToken,opts){if(token===null||token.type!==Dimension$3)return 0
const numberEnd=consumeNumber$2(token.value,0)
if(type!==null){const reverseSolidusOffset=token.value.indexOf("\\",numberEnd)
const unit=reverseSolidusOffset!==-1&&isPostfixIeHack$1(token.value,reverseSolidusOffset)?token.value.substring(numberEnd,reverseSolidusOffset):token.value.substr(numberEnd)
if(type.has(unit.toLowerCase())===false)return 0}if(outOfRange$1(opts,token.value,numberEnd))return 0
return 1}}function percentage$1(token,getNextToken,opts){if(token===null||token.type!==Percentage$3)return 0
if(outOfRange$1(opts,token.value,token.value.length-1))return 0
return 1}function zero$1(next){typeof next!=="function"&&(next=function(){return 0})
return function(token,getNextToken,opts){if(token!==null&&token.type===Number$5&&Number(token.value)===0)return 1
return next(token,getNextToken,opts)}}function number$1(token,getNextToken,opts){if(token===null)return 0
const numberEnd=consumeNumber$2(token.value,0)
const isNumber=numberEnd===token.value.length
if(!isNumber&&!isPostfixIeHack$1(token.value,numberEnd))return 0
if(outOfRange$1(opts,token.value,numberEnd))return 0
return 1}function integer$1(token,getNextToken,opts){if(token===null||token.type!==Number$5)return 0
let i=charCodeAt$1(token.value,0)===0x002B||charCodeAt$1(token.value,0)===0x002D?1:0
for(;i<token.value.length;i++)if(!isDigit$2(charCodeAt$1(token.value,i)))return 0
if(outOfRange$1(opts,token.value,i))return 0
return 1}const tokenTypes={"ident-token":tokenType$1(Ident$1),"function-token":tokenType$1(Function$3),"at-keyword-token":tokenType$1(AtKeyword$1),"hash-token":tokenType$1(Hash$3),"string-token":tokenType$1(String$4),"bad-string-token":tokenType$1(BadString$1),"url-token":tokenType$1(Url$4),"bad-url-token":tokenType$1(BadUrl$1),"delim-token":tokenType$1(Delim$1),"number-token":tokenType$1(Number$5),"percentage-token":tokenType$1(Percentage$3),"dimension-token":tokenType$1(Dimension$3),"whitespace-token":tokenType$1(WhiteSpace$3),"CDO-token":tokenType$1(CDO$3),"CDC-token":tokenType$1(CDC$3),"colon-token":tokenType$1(Colon$1),"semicolon-token":tokenType$1(Semicolon$1),"comma-token":tokenType$1(Comma$1),"[-token":tokenType$1(LeftSquareBracket$1),"]-token":tokenType$1(RightSquareBracket$1),"(-token":tokenType$1(LeftParenthesis$1),")-token":tokenType$1(RightParenthesis$1),"{-token":tokenType$1(LeftCurlyBracket$1),"}-token":tokenType$1(RightCurlyBracket$1)}
const productionTypes={string:tokenType$1(String$4),ident:tokenType$1(Ident$1),percentage:calc$1(percentage$1),zero:zero$1(),number:calc$1(number$1),integer:calc$1(integer$1),"custom-ident":customIdent$1,"dashed-ident":dashedIdent,"custom-property-name":customPropertyName$1,"hex-color":hexColor$1,"id-selector":idSelector$1,"an-plus-b":anPlusB$1,urange:urange$1,"declaration-value":declarationValue$1,"any-value":anyValue$1}
function createDemensionTypes(units){const{angle:angle,decibel:decibel,frequency:frequency,flex:flex,length:length,resolution:resolution,semitones:semitones,time:time}=units||{}
return{dimension:calc$1(dimension$1(null)),angle:calc$1(dimension$1(angle)),decibel:calc$1(dimension$1(decibel)),frequency:calc$1(dimension$1(frequency)),flex:calc$1(dimension$1(flex)),length:calc$1(zero$1(dimension$1(length))),resolution:calc$1(dimension$1(resolution)),semitones:calc$1(dimension$1(semitones)),time:calc$1(dimension$1(time))}}function createGenericTypes(units){return{...tokenTypes,...productionTypes,...createDemensionTypes(units)}}const length=["cm","mm","q","in","pt","pc","px","em","rem","ex","rex","cap","rcap","ch","rch","ic","ric","lh","rlh","vw","svw","lvw","dvw","vh","svh","lvh","dvh","vi","svi","lvi","dvi","vb","svb","lvb","dvb","vmin","svmin","lvmin","dvmin","vmax","svmax","lvmax","dvmax","cqw","cqh","cqi","cqb","cqmin","cqmax"]
const angle=["deg","grad","rad","turn"]
const time=["s","ms"]
const frequency=["hz","khz"]
const resolution=["dpi","dpcm","dppx","x"]
const flex=["fr"]
const decibel=["db"]
const semitones=["st"]
var units=Object.freeze({__proto__:null,angle:angle,decibel:decibel,flex:flex,frequency:frequency,length:length,resolution:resolution,semitones:semitones,time:time})
function SyntaxError$3(message,input,offset){return Object.assign(createCustomError$1("SyntaxError",message),{input:input,offset:offset,rawMessage:message,message:message+"\n  "+input+"\n--"+new Array((offset||input.length)+1).join("-")+"^"})}const TAB$3=9
const N$7=10
const F$4=12
const R$4=13
const SPACE$7=32
let Tokenizer$1=class Tokenizer{constructor(str){this.str=str
this.pos=0}charCodeAt(pos){return pos<this.str.length?this.str.charCodeAt(pos):0}charCode(){return this.charCodeAt(this.pos)}nextCharCode(){return this.charCodeAt(this.pos+1)}nextNonWsCode(pos){return this.charCodeAt(this.findWsEnd(pos))}skipWs(){this.pos=this.findWsEnd(this.pos)}findWsEnd(pos){for(;pos<this.str.length;pos++){const code=this.str.charCodeAt(pos)
if(code!==R$4&&code!==N$7&&code!==F$4&&code!==SPACE$7&&code!==TAB$3)break}return pos}substringToPos(end){return this.str.substring(this.pos,this.pos=end)}eat(code){this.charCode()!==code&&this.error("Expect `"+String.fromCharCode(code)+"`")
this.pos++}peek(){return this.pos<this.str.length?this.str.charAt(this.pos++):""}error(message){throw new SyntaxError$3(message,this.str,this.pos)}}
const TAB$2=9
const N$6=10
const F$3=12
const R$3=13
const SPACE$6=32
const EXCLAMATIONMARK$6=33
const NUMBERSIGN$8=35
const AMPERSAND$7=38
const APOSTROPHE$5=39
const LEFTPARENTHESIS$5=40
const RIGHTPARENTHESIS$5=41
const ASTERISK$d=42
const PLUSSIGN$g=43
const COMMA$1=44
const HYPERMINUS$1=45
const LESSTHANSIGN$2=60
const GREATERTHANSIGN$6=62
const QUESTIONMARK$4=63
const COMMERCIALAT$1=64
const LEFTSQUAREBRACKET$1=91
const RIGHTSQUAREBRACKET$1=93
const LEFTCURLYBRACKET$2=123
const VERTICALLINE$7=124
const RIGHTCURLYBRACKET$1=125
const INFINITY$1=8734
const NAME_CHAR$1=new Uint8Array(128).map(((_,idx)=>/[a-zA-Z0-9\-]/.test(String.fromCharCode(idx))?1:0))
const COMBINATOR_PRECEDENCE$1={" ":1,"&&":2,"||":3,"|":4}
function scanSpaces$1(tokenizer){return tokenizer.substringToPos(tokenizer.findWsEnd(tokenizer.pos))}function scanWord$1(tokenizer){let end=tokenizer.pos
for(;end<tokenizer.str.length;end++){const code=tokenizer.str.charCodeAt(end)
if(code>=128||NAME_CHAR$1[code]===0)break}tokenizer.pos===end&&tokenizer.error("Expect a keyword")
return tokenizer.substringToPos(end)}function scanNumber$1(tokenizer){let end=tokenizer.pos
for(;end<tokenizer.str.length;end++){const code=tokenizer.str.charCodeAt(end)
if(code<48||code>57)break}tokenizer.pos===end&&tokenizer.error("Expect a number")
return tokenizer.substringToPos(end)}function scanString$1(tokenizer){const end=tokenizer.str.indexOf("'",tokenizer.pos+1)
if(end===-1){tokenizer.pos=tokenizer.str.length
tokenizer.error("Expect an apostrophe")}return tokenizer.substringToPos(end+1)}function readMultiplierRange$1(tokenizer){let min=null
let max=null
tokenizer.eat(LEFTCURLYBRACKET$2)
tokenizer.skipWs()
min=scanNumber$1(tokenizer)
tokenizer.skipWs()
if(tokenizer.charCode()===COMMA$1){tokenizer.pos++
tokenizer.skipWs()
if(tokenizer.charCode()!==RIGHTCURLYBRACKET$1){max=scanNumber$1(tokenizer)
tokenizer.skipWs()}}else max=min
tokenizer.eat(RIGHTCURLYBRACKET$1)
return{min:Number(min),max:max?Number(max):0}}function readMultiplier$1(tokenizer){let range=null
let comma=false
switch(tokenizer.charCode()){case ASTERISK$d:tokenizer.pos++
range={min:0,max:0}
break
case PLUSSIGN$g:tokenizer.pos++
range={min:1,max:0}
break
case QUESTIONMARK$4:tokenizer.pos++
range={min:0,max:1}
break
case NUMBERSIGN$8:tokenizer.pos++
comma=true
if(tokenizer.charCode()===LEFTCURLYBRACKET$2)range=readMultiplierRange$1(tokenizer)
else if(tokenizer.charCode()===QUESTIONMARK$4){tokenizer.pos++
range={min:0,max:0}}else range={min:1,max:0}
break
case LEFTCURLYBRACKET$2:range=readMultiplierRange$1(tokenizer)
break
default:return null}return{type:"Multiplier",comma:comma,min:range.min,max:range.max,term:null}}function maybeMultiplied$1(tokenizer,node){const multiplier=readMultiplier$1(tokenizer)
if(multiplier!==null){multiplier.term=node
if(tokenizer.charCode()===NUMBERSIGN$8&&tokenizer.charCodeAt(tokenizer.pos-1)===PLUSSIGN$g)return maybeMultiplied$1(tokenizer,multiplier)
return multiplier}return node}function maybeToken$1(tokenizer){const ch=tokenizer.peek()
if(ch==="")return null
return{type:"Token",value:ch}}function readProperty$3(tokenizer){let name
tokenizer.eat(LESSTHANSIGN$2)
tokenizer.eat(APOSTROPHE$5)
name=scanWord$1(tokenizer)
tokenizer.eat(APOSTROPHE$5)
tokenizer.eat(GREATERTHANSIGN$6)
return maybeMultiplied$1(tokenizer,{type:"Property",name:name})}function readTypeRange$1(tokenizer){let min=null
let max=null
let sign=1
tokenizer.eat(LEFTSQUAREBRACKET$1)
if(tokenizer.charCode()===HYPERMINUS$1){tokenizer.peek()
sign=-1}if(sign==-1&&tokenizer.charCode()===INFINITY$1)tokenizer.peek()
else{min=sign*Number(scanNumber$1(tokenizer))
NAME_CHAR$1[tokenizer.charCode()]!==0&&(min+=scanWord$1(tokenizer))}scanSpaces$1(tokenizer)
tokenizer.eat(COMMA$1)
scanSpaces$1(tokenizer)
if(tokenizer.charCode()===INFINITY$1)tokenizer.peek()
else{sign=1
if(tokenizer.charCode()===HYPERMINUS$1){tokenizer.peek()
sign=-1}max=sign*Number(scanNumber$1(tokenizer))
NAME_CHAR$1[tokenizer.charCode()]!==0&&(max+=scanWord$1(tokenizer))}tokenizer.eat(RIGHTSQUAREBRACKET$1)
return{type:"Range",min:min,max:max}}function readType$1(tokenizer){let name
let opts=null
tokenizer.eat(LESSTHANSIGN$2)
name=scanWord$1(tokenizer)
if(tokenizer.charCode()===LEFTPARENTHESIS$5&&tokenizer.nextCharCode()===RIGHTPARENTHESIS$5){tokenizer.pos+=2
name+="()"}if(tokenizer.charCodeAt(tokenizer.findWsEnd(tokenizer.pos))===LEFTSQUAREBRACKET$1){scanSpaces$1(tokenizer)
opts=readTypeRange$1(tokenizer)}tokenizer.eat(GREATERTHANSIGN$6)
return maybeMultiplied$1(tokenizer,{type:"Type",name:name,opts:opts})}function readKeywordOrFunction$1(tokenizer){const name=scanWord$1(tokenizer)
if(tokenizer.charCode()===LEFTPARENTHESIS$5){tokenizer.pos++
return{type:"Function",name:name}}return maybeMultiplied$1(tokenizer,{type:"Keyword",name:name})}function regroupTerms$1(terms,combinators){function createGroup(terms,combinator){return{type:"Group",terms:terms,combinator:combinator,disallowEmpty:false,explicit:false}}let combinator
combinators=Object.keys(combinators).sort(((a,b)=>COMBINATOR_PRECEDENCE$1[a]-COMBINATOR_PRECEDENCE$1[b]))
while(combinators.length>0){combinator=combinators.shift()
let i=0
let subgroupStart=0
for(;i<terms.length;i++){const term=terms[i]
if(term.type==="Combinator")if(term.value===combinator){subgroupStart===-1&&(subgroupStart=i-1)
terms.splice(i,1)
i--}else{if(subgroupStart!==-1&&i-subgroupStart>1){terms.splice(subgroupStart,i-subgroupStart,createGroup(terms.slice(subgroupStart,i),combinator))
i=subgroupStart+1}subgroupStart=-1}}subgroupStart!==-1&&combinators.length&&terms.splice(subgroupStart,i-subgroupStart,createGroup(terms.slice(subgroupStart,i),combinator))}return combinator}function readImplicitGroup$1(tokenizer){const terms=[]
const combinators={}
let token
let prevToken=null
let prevTokenPos=tokenizer.pos
while(token=peek$1(tokenizer))if(token.type!=="Spaces"){if(token.type==="Combinator"){if(prevToken===null||prevToken.type==="Combinator"){tokenizer.pos=prevTokenPos
tokenizer.error("Unexpected combinator")}combinators[token.value]=true}else if(prevToken!==null&&prevToken.type!=="Combinator"){combinators[" "]=true
terms.push({type:"Combinator",value:" "})}terms.push(token)
prevToken=token
prevTokenPos=tokenizer.pos}if(prevToken!==null&&prevToken.type==="Combinator"){tokenizer.pos-=prevTokenPos
tokenizer.error("Unexpected combinator")}return{type:"Group",terms:terms,combinator:regroupTerms$1(terms,combinators)||" ",disallowEmpty:false,explicit:false}}function readGroup$1(tokenizer){let result
tokenizer.eat(LEFTSQUAREBRACKET$1)
result=readImplicitGroup$1(tokenizer)
tokenizer.eat(RIGHTSQUAREBRACKET$1)
result.explicit=true
if(tokenizer.charCode()===EXCLAMATIONMARK$6){tokenizer.pos++
result.disallowEmpty=true}return result}function peek$1(tokenizer){let code=tokenizer.charCode()
if(code<128&&NAME_CHAR$1[code]===1)return readKeywordOrFunction$1(tokenizer)
switch(code){case RIGHTSQUAREBRACKET$1:break
case LEFTSQUAREBRACKET$1:return maybeMultiplied$1(tokenizer,readGroup$1(tokenizer))
case LESSTHANSIGN$2:return tokenizer.nextCharCode()===APOSTROPHE$5?readProperty$3(tokenizer):readType$1(tokenizer)
case VERTICALLINE$7:return{type:"Combinator",value:tokenizer.substringToPos(tokenizer.pos+(tokenizer.nextCharCode()===VERTICALLINE$7?2:1))}
case AMPERSAND$7:tokenizer.pos++
tokenizer.eat(AMPERSAND$7)
return{type:"Combinator",value:"&&"}
case COMMA$1:tokenizer.pos++
return{type:"Comma"}
case APOSTROPHE$5:return maybeMultiplied$1(tokenizer,{type:"String",value:scanString$1(tokenizer)})
case SPACE$6:case TAB$2:case N$6:case R$3:case F$3:return{type:"Spaces",value:scanSpaces$1(tokenizer)}
case COMMERCIALAT$1:code=tokenizer.nextCharCode()
if(code<128&&NAME_CHAR$1[code]===1){tokenizer.pos++
return{type:"AtKeyword",name:scanWord$1(tokenizer)}}return maybeToken$1(tokenizer)
case ASTERISK$d:case PLUSSIGN$g:case QUESTIONMARK$4:case NUMBERSIGN$8:case EXCLAMATIONMARK$6:break
case LEFTCURLYBRACKET$2:code=tokenizer.nextCharCode()
if(code<48||code>57)return maybeToken$1(tokenizer)
break
default:return maybeToken$1(tokenizer)}}function parse$1u(source){const tokenizer=new Tokenizer$1(source)
const result=readImplicitGroup$1(tokenizer)
tokenizer.pos!==source.length&&tokenizer.error("Unexpected input")
if(result.terms.length===1&&result.terms[0].type==="Group")return result.terms[0]
return result}const noop$3=function(){}
function ensureFunction$2(value){return typeof value==="function"?value:noop$3}function walk$4(node,options,context){function walk(node){enter.call(context,node)
switch(node.type){case"Group":node.terms.forEach(walk)
break
case"Multiplier":walk(node.term)
break
case"Type":case"Property":case"Keyword":case"AtKeyword":case"Function":case"String":case"Token":case"Comma":break
default:throw new Error("Unknown type: "+node.type)}leave.call(context,node)}let enter=noop$3
let leave=noop$3
if(typeof options==="function")enter=options
else if(options){enter=ensureFunction$2(options.enter)
leave=ensureFunction$2(options.leave)}if(enter===noop$3&&leave===noop$3)throw new Error("Neither `enter` nor `leave` walker handler is set or both aren't a function")
walk(node)}const astToTokens$1={decorator(handlers){const tokens=[]
let curNode=null
return{...handlers,node(node){const tmp=curNode
curNode=node
handlers.node.call(this,node)
curNode=tmp},emit(value,type,auto){tokens.push({type:type,value:value,node:auto?null:curNode})},result:()=>tokens}}}
function stringToTokens$1(str){const tokens=[]
tokenize$4(str,((type,start,end)=>tokens.push({type:type,value:str.slice(start,end),node:null})))
return tokens}function prepareTokens$1(value,syntax){if(typeof value==="string")return stringToTokens$1(value)
return syntax.generate(value,astToTokens$1)}const MATCH$1={type:"Match"}
const MISMATCH$1={type:"Mismatch"}
const DISALLOW_EMPTY$1={type:"DisallowEmpty"}
const LEFTPARENTHESIS$4=40
const RIGHTPARENTHESIS$4=41
function createCondition$1(match,thenBranch,elseBranch){if(thenBranch===MATCH$1&&elseBranch===MISMATCH$1)return match
if(match===MATCH$1&&thenBranch===MATCH$1&&elseBranch===MATCH$1)return match
if(match.type==="If"&&match.else===MISMATCH$1&&thenBranch===MATCH$1){thenBranch=match.then
match=match.match}return{type:"If",match:match,then:thenBranch,else:elseBranch}}function isFunctionType$1(name){return name.length>2&&name.charCodeAt(name.length-2)===LEFTPARENTHESIS$4&&name.charCodeAt(name.length-1)===RIGHTPARENTHESIS$4}function isEnumCapatible$1(term){return term.type==="Keyword"||term.type==="AtKeyword"||term.type==="Function"||term.type==="Type"&&isFunctionType$1(term.name)}function buildGroupMatchGraph$1(combinator,terms,atLeastOneTermMatched){switch(combinator){case" ":{let result=MATCH$1
for(let i=terms.length-1;i>=0;i--){const term=terms[i]
result=createCondition$1(term,result,MISMATCH$1)}return result}case"|":{let result=MISMATCH$1
let map=null
for(let i=terms.length-1;i>=0;i--){let term=terms[i]
if(isEnumCapatible$1(term)){if(map===null&&i>0&&isEnumCapatible$1(terms[i-1])){map=Object.create(null)
result=createCondition$1({type:"Enum",map:map},MATCH$1,result)}if(map!==null){const key=(isFunctionType$1(term.name)?term.name.slice(0,-1):term.name).toLowerCase()
if(key in map===false){map[key]=term
continue}}}map=null
result=createCondition$1(term,MATCH$1,result)}return result}case"&&":{if(terms.length>5)return{type:"MatchOnce",terms:terms,all:true}
let result=MISMATCH$1
for(let i=terms.length-1;i>=0;i--){const term=terms[i]
let thenClause
thenClause=terms.length>1?buildGroupMatchGraph$1(combinator,terms.filter((function(newGroupTerm){return newGroupTerm!==term})),false):MATCH$1
result=createCondition$1(term,thenClause,result)}return result}case"||":{if(terms.length>5)return{type:"MatchOnce",terms:terms,all:false}
let result=atLeastOneTermMatched?MATCH$1:MISMATCH$1
for(let i=terms.length-1;i>=0;i--){const term=terms[i]
let thenClause
thenClause=terms.length>1?buildGroupMatchGraph$1(combinator,terms.filter((function(newGroupTerm){return newGroupTerm!==term})),true):MATCH$1
result=createCondition$1(term,thenClause,result)}return result}}}function buildMultiplierMatchGraph$1(node){let result=MATCH$1
let matchTerm=buildMatchGraphInternal$1(node.term)
if(node.max===0){matchTerm=createCondition$1(matchTerm,DISALLOW_EMPTY$1,MISMATCH$1)
result=createCondition$1(matchTerm,null,MISMATCH$1)
result.then=createCondition$1(MATCH$1,MATCH$1,result)
node.comma&&(result.then.else=createCondition$1({type:"Comma",syntax:node},result,MISMATCH$1))}else for(let i=node.min||1;i<=node.max;i++){node.comma&&result!==MATCH$1&&(result=createCondition$1({type:"Comma",syntax:node},result,MISMATCH$1))
result=createCondition$1(matchTerm,createCondition$1(MATCH$1,MATCH$1,result),MISMATCH$1)}if(node.min===0)result=createCondition$1(MATCH$1,MATCH$1,result)
else for(let i=0;i<node.min-1;i++){node.comma&&result!==MATCH$1&&(result=createCondition$1({type:"Comma",syntax:node},result,MISMATCH$1))
result=createCondition$1(matchTerm,result,MISMATCH$1)}return result}function buildMatchGraphInternal$1(node){if(typeof node==="function")return{type:"Generic",fn:node}
switch(node.type){case"Group":{let result=buildGroupMatchGraph$1(node.combinator,node.terms.map(buildMatchGraphInternal$1),false)
node.disallowEmpty&&(result=createCondition$1(result,DISALLOW_EMPTY$1,MISMATCH$1))
return result}case"Multiplier":return buildMultiplierMatchGraph$1(node)
case"Type":case"Property":return{type:node.type,name:node.name,syntax:node}
case"Keyword":return{type:node.type,name:node.name.toLowerCase(),syntax:node}
case"AtKeyword":return{type:node.type,name:"@"+node.name.toLowerCase(),syntax:node}
case"Function":return{type:node.type,name:node.name.toLowerCase()+"(",syntax:node}
case"String":if(node.value.length===3)return{type:"Token",value:node.value.charAt(1),syntax:node}
return{type:node.type,value:node.value.substr(1,node.value.length-2).replace(/\\'/g,"'"),syntax:node}
case"Token":return{type:node.type,value:node.value,syntax:node}
case"Comma":return{type:node.type,syntax:node}
default:throw new Error("Unknown node type:",node.type)}}function buildMatchGraph$1(syntaxTree,ref){typeof syntaxTree==="string"&&(syntaxTree=parse$1u(syntaxTree))
return{type:"MatchGraph",match:buildMatchGraphInternal$1(syntaxTree),syntax:ref||null,source:syntaxTree}}const{hasOwnProperty:hasOwnProperty$a}=Object.prototype
const STUB$1=0
const TOKEN$1=1
const OPEN_SYNTAX$1=2
const CLOSE_SYNTAX$1=3
const EXIT_REASON_MATCH$1="Match"
const EXIT_REASON_MISMATCH$1="Mismatch"
const EXIT_REASON_ITERATION_LIMIT$1="Maximum iteration number exceeded (please fill an issue on https://github.com/csstree/csstree/issues)"
const ITERATION_LIMIT$1=15000
function reverseList$1(list){let prev=null
let next=null
let item=list
while(item!==null){next=item.prev
item.prev=prev
prev=item
item=next}return prev}function areStringsEqualCaseInsensitive$1(testStr,referenceStr){if(testStr.length!==referenceStr.length)return false
for(let i=0;i<testStr.length;i++){const referenceCode=referenceStr.charCodeAt(i)
let testCode=testStr.charCodeAt(i)
testCode>=0x0041&&testCode<=0x005A&&(testCode|=32)
if(testCode!==referenceCode)return false}return true}function isContextEdgeDelim$1(token){if(token.type!==Delim$1)return false
return token.value!=="?"}function isCommaContextStart$1(token){if(token===null)return true
return token.type===Comma$1||token.type===Function$3||token.type===LeftParenthesis$1||token.type===LeftSquareBracket$1||token.type===LeftCurlyBracket$1||isContextEdgeDelim$1(token)}function isCommaContextEnd$1(token){if(token===null)return true
return token.type===RightParenthesis$1||token.type===RightSquareBracket$1||token.type===RightCurlyBracket$1||token.type===Delim$1&&token.value==="/"}function internalMatch$1(tokens,state,syntaxes){function moveToNextToken(){do{tokenIndex++
token=tokenIndex<tokens.length?tokens[tokenIndex]:null}while(token!==null&&(token.type===WhiteSpace$3||token.type===Comment$3))}function getNextToken(offset){const nextIndex=tokenIndex+offset
return nextIndex<tokens.length?tokens[nextIndex]:null}function stateSnapshotFromSyntax(nextState,prev){return{nextState:nextState,matchStack:matchStack,syntaxStack:syntaxStack,thenStack:thenStack,tokenIndex:tokenIndex,prev:prev}}function pushThenStack(nextState){thenStack={nextState:nextState,matchStack:matchStack,syntaxStack:syntaxStack,prev:thenStack}}function pushElseStack(nextState){elseStack=stateSnapshotFromSyntax(nextState,elseStack)}function addTokenToMatch(){matchStack={type:TOKEN$1,syntax:state.syntax,token:token,prev:matchStack}
moveToNextToken()
syntaxStash=null
tokenIndex>longestMatch&&(longestMatch=tokenIndex)}function openSyntax(){syntaxStack={syntax:state.syntax,opts:state.syntax.opts||syntaxStack!==null&&syntaxStack.opts||null,prev:syntaxStack}
matchStack={type:OPEN_SYNTAX$1,syntax:state.syntax,token:matchStack.token,prev:matchStack}}function closeSyntax(){matchStack=matchStack.type===OPEN_SYNTAX$1?matchStack.prev:{type:CLOSE_SYNTAX$1,syntax:syntaxStack.syntax,token:matchStack.token,prev:matchStack}
syntaxStack=syntaxStack.prev}let syntaxStack=null
let thenStack=null
let elseStack=null
let syntaxStash=null
let iterationCount=0
let exitReason=null
let token=null
let tokenIndex=-1
let longestMatch=0
let matchStack={type:STUB$1,syntax:null,token:null,prev:null}
moveToNextToken()
while(exitReason===null&&++iterationCount<ITERATION_LIMIT$1)switch(state.type){case"Match":if(thenStack===null){if(token!==null&&(tokenIndex!==tokens.length-1||token.value!=="\\0"&&token.value!=="\\9")){state=MISMATCH$1
break}exitReason=EXIT_REASON_MATCH$1
break}state=thenStack.nextState
if(state===DISALLOW_EMPTY$1){if(thenStack.matchStack===matchStack){state=MISMATCH$1
break}state=MATCH$1}while(thenStack.syntaxStack!==syntaxStack)closeSyntax()
thenStack=thenStack.prev
break
case"Mismatch":if(syntaxStash!==null&&syntaxStash!==false){if(elseStack===null||tokenIndex>elseStack.tokenIndex){elseStack=syntaxStash
syntaxStash=false}}else if(elseStack===null){exitReason=EXIT_REASON_MISMATCH$1
break}state=elseStack.nextState
thenStack=elseStack.thenStack
syntaxStack=elseStack.syntaxStack
matchStack=elseStack.matchStack
tokenIndex=elseStack.tokenIndex
token=tokenIndex<tokens.length?tokens[tokenIndex]:null
elseStack=elseStack.prev
break
case"MatchGraph":state=state.match
break
case"If":state.else!==MISMATCH$1&&pushElseStack(state.else)
state.then!==MATCH$1&&pushThenStack(state.then)
state=state.match
break
case"MatchOnce":state={type:"MatchOnceBuffer",syntax:state,index:0,mask:0}
break
case"MatchOnceBuffer":{const terms=state.syntax.terms
if(state.index===terms.length){if(state.mask===0||state.syntax.all){state=MISMATCH$1
break}state=MATCH$1
break}if(state.mask===(1<<terms.length)-1){state=MATCH$1
break}for(;state.index<terms.length;state.index++){const matchFlag=1<<state.index
if((state.mask&matchFlag)===0){pushElseStack(state)
pushThenStack({type:"AddMatchOnce",syntax:state.syntax,mask:state.mask|matchFlag})
state=terms[state.index++]
break}}break}case"AddMatchOnce":state={type:"MatchOnceBuffer",syntax:state.syntax,index:0,mask:state.mask}
break
case"Enum":if(token!==null){let name=token.value.toLowerCase()
name.indexOf("\\")!==-1&&(name=name.replace(/\\[09].*$/,""))
if(hasOwnProperty$a.call(state.map,name)){state=state.map[name]
break}}state=MISMATCH$1
break
case"Generic":{const opts=syntaxStack!==null?syntaxStack.opts:null
const lastTokenIndex=tokenIndex+Math.floor(state.fn(token,getNextToken,opts))
if(!isNaN(lastTokenIndex)&&lastTokenIndex>tokenIndex){while(tokenIndex<lastTokenIndex)addTokenToMatch()
state=MATCH$1}else state=MISMATCH$1
break}case"Type":case"Property":{const syntaxDict=state.type==="Type"?"types":"properties"
const dictSyntax=hasOwnProperty$a.call(syntaxes,syntaxDict)?syntaxes[syntaxDict][state.name]:null
if(!dictSyntax||!dictSyntax.match)throw new Error("Bad syntax reference: "+(state.type==="Type"?"<"+state.name+">":"<'"+state.name+"'>"))
if(syntaxStash!==false&&token!==null&&state.type==="Type"){const lowPriorityMatching=state.name==="custom-ident"&&token.type===Ident$1||state.name==="length"&&token.value==="0"
if(lowPriorityMatching){syntaxStash===null&&(syntaxStash=stateSnapshotFromSyntax(state,elseStack))
state=MISMATCH$1
break}}openSyntax()
state=dictSyntax.matchRef||dictSyntax.match
break}case"Keyword":{const name=state.name
if(token!==null){let keywordName=token.value
keywordName.indexOf("\\")!==-1&&(keywordName=keywordName.replace(/\\[09].*$/,""))
if(areStringsEqualCaseInsensitive$1(keywordName,name)){addTokenToMatch()
state=MATCH$1
break}}state=MISMATCH$1
break}case"AtKeyword":case"Function":if(token!==null&&areStringsEqualCaseInsensitive$1(token.value,state.name)){addTokenToMatch()
state=MATCH$1
break}state=MISMATCH$1
break
case"Token":if(token!==null&&token.value===state.value){addTokenToMatch()
state=MATCH$1
break}state=MISMATCH$1
break
case"Comma":if(token!==null&&token.type===Comma$1)if(isCommaContextStart$1(matchStack.token))state=MISMATCH$1
else{addTokenToMatch()
state=isCommaContextEnd$1(token)?MISMATCH$1:MATCH$1}else state=isCommaContextStart$1(matchStack.token)||isCommaContextEnd$1(token)?MATCH$1:MISMATCH$1
break
case"String":let string=""
let lastTokenIndex=tokenIndex
for(;lastTokenIndex<tokens.length&&string.length<state.value.length;lastTokenIndex++)string+=tokens[lastTokenIndex].value
if(areStringsEqualCaseInsensitive$1(string,state.value)){while(tokenIndex<lastTokenIndex)addTokenToMatch()
state=MATCH$1}else state=MISMATCH$1
break
default:throw new Error("Unknown node type: "+state.type)}switch(exitReason){case null:console.warn("[csstree-match] BREAK after "+ITERATION_LIMIT$1+" iterations")
exitReason=EXIT_REASON_ITERATION_LIMIT$1
matchStack=null
break
case EXIT_REASON_MATCH$1:while(syntaxStack!==null)closeSyntax()
break
default:matchStack=null}return{tokens:tokens,reason:exitReason,iterations:iterationCount,match:matchStack,longestMatch:longestMatch}}function matchAsTree$1(tokens,matchGraph,syntaxes){const matchResult=internalMatch$1(tokens,matchGraph,syntaxes||{})
if(matchResult.match===null)return matchResult
let item=matchResult.match
let host=matchResult.match={syntax:matchGraph.syntax||null,match:[]}
const hostStack=[host]
item=reverseList$1(item).prev
while(item!==null){switch(item.type){case OPEN_SYNTAX$1:host.match.push(host={syntax:item.syntax,match:[]})
hostStack.push(host)
break
case CLOSE_SYNTAX$1:hostStack.pop()
host=hostStack[hostStack.length-1]
break
default:host.match.push({syntax:item.syntax||null,token:item.token.value,node:item.token.node})}item=item.prev}return matchResult}function getTrace$1(node){function shouldPutToTrace(syntax){if(syntax===null)return false
return syntax.type==="Type"||syntax.type==="Property"||syntax.type==="Keyword"}function hasMatch(matchNode){if(Array.isArray(matchNode.match)){for(let i=0;i<matchNode.match.length;i++)if(hasMatch(matchNode.match[i])){shouldPutToTrace(matchNode.syntax)&&result.unshift(matchNode.syntax)
return true}}else if(matchNode.node===node){result=shouldPutToTrace(matchNode.syntax)?[matchNode.syntax]:[]
return true}return false}let result=null
this.matched!==null&&hasMatch(this.matched)
return result}function isType$1(node,type){return testNode$1(this,node,(match=>match.type==="Type"&&match.name===type))}function isProperty$1(node,property){return testNode$1(this,node,(match=>match.type==="Property"&&match.name===property))}function isKeyword$1(node){return testNode$1(this,node,(match=>match.type==="Keyword"))}function testNode$1(match,node,fn){const trace=getTrace$1.call(match,node)
if(trace===null)return false
return trace.some(fn)}var trace$1=Object.freeze({__proto__:null,getTrace:getTrace$1,isKeyword:isKeyword$1,isProperty:isProperty$1,isType:isType$1})
function getFirstMatchNode$1(matchNode){if("node"in matchNode)return matchNode.node
return getFirstMatchNode$1(matchNode.match[0])}function getLastMatchNode$1(matchNode){if("node"in matchNode)return matchNode.node
return getLastMatchNode$1(matchNode.match[matchNode.match.length-1])}function matchFragments$1(lexer,ast,match,type,name){function findFragments(matchNode){if(matchNode.syntax!==null&&matchNode.syntax.type===type&&matchNode.syntax.name===name){const start=getFirstMatchNode$1(matchNode)
const end=getLastMatchNode$1(matchNode)
lexer.syntax.walk(ast,(function(node,item,list){if(node===start){const nodes=new List$1
do{nodes.appendData(item.data)
if(item.data===end)break
item=item.next}while(item!==null)
fragments.push({parent:list,nodes:nodes})}}))}Array.isArray(matchNode.match)&&matchNode.match.forEach(findFragments)}const fragments=[]
match.matched!==null&&findFragments(match.matched)
return fragments}const{hasOwnProperty:hasOwnProperty$9}=Object.prototype
function isValidNumber$1(value){return typeof value==="number"&&isFinite(value)&&Math.floor(value)===value&&value>=0}function isValidLocation$1(loc){return Boolean(loc)&&isValidNumber$1(loc.offset)&&isValidNumber$1(loc.line)&&isValidNumber$1(loc.column)}function createNodeStructureChecker$1(type,fields){return function checkNode(node,warn){if(!node||node.constructor!==Object)return warn(node,"Type of node should be an Object")
for(let key in node){let valid=true
if(hasOwnProperty$9.call(node,key)===false)continue
if(key==="type")node.type!==type&&warn(node,"Wrong node type `"+node.type+"`, expected `"+type+"`")
else if(key==="loc"){if(node.loc===null)continue
if(node.loc&&node.loc.constructor===Object)if(typeof node.loc.source!=="string")key+=".source"
else if(isValidLocation$1(node.loc.start)){if(isValidLocation$1(node.loc.end))continue
key+=".end"}else key+=".start"
valid=false}else if(fields.hasOwnProperty(key)){valid=false
for(let i=0;!valid&&i<fields[key].length;i++){const fieldType=fields[key][i]
switch(fieldType){case String:valid=typeof node[key]==="string"
break
case Boolean:valid=typeof node[key]==="boolean"
break
case null:valid=node[key]===null
break
default:typeof fieldType==="string"?valid=node[key]&&node[key].type===fieldType:Array.isArray(fieldType)&&(valid=node[key]instanceof List$1)}}}else warn(node,"Unknown field `"+key+"` for "+type+" node type")
valid||warn(node,"Bad value for `"+type+"."+key+"`")}for(const key in fields)hasOwnProperty$9.call(fields,key)&&hasOwnProperty$9.call(node,key)===false&&warn(node,"Field `"+type+"."+key+"` is missed")}}function genTypesList(fieldTypes,path){const docsTypes=[]
for(let i=0;i<fieldTypes.length;i++){const fieldType=fieldTypes[i]
if(fieldType===String||fieldType===Boolean)docsTypes.push(fieldType.name.toLowerCase())
else if(fieldType===null)docsTypes.push("null")
else if(typeof fieldType==="string")docsTypes.push(fieldType)
else{if(!Array.isArray(fieldType))throw new Error("Wrong value `"+fieldType+"` in `"+path+"` structure definition")
docsTypes.push("List<"+(genTypesList(fieldType,path)||"any")+">")}}return docsTypes.join(" | ")}function processStructure$1(name,nodeType){const structure=nodeType.structure
const fields={type:String,loc:true}
const docs={type:'"'+name+'"'}
for(const key in structure){if(hasOwnProperty$9.call(structure,key)===false)continue
const fieldTypes=fields[key]=Array.isArray(structure[key])?structure[key].slice():[structure[key]]
docs[key]=genTypesList(fieldTypes,name+"."+key)}return{docs:docs,check:createNodeStructureChecker$1(name,fields)}}function getStructureFromConfig$1(config){const structure={}
if(config.node)for(const name in config.node)if(hasOwnProperty$9.call(config.node,name)){const nodeType=config.node[name]
if(!nodeType.structure)throw new Error("Missed `structure` field in `"+name+"` node type definition")
structure[name]=processStructure$1(name,nodeType)}return structure}function dumpMapSyntax$1(map,compact,syntaxAsAst){const result={}
for(const name in map)map[name].syntax&&(result[name]=syntaxAsAst?map[name].syntax:generate$1u(map[name].syntax,{compact:compact}))
return result}function dumpAtruleMapSyntax$1(map,compact,syntaxAsAst){const result={}
for(const[name,atrule]of Object.entries(map))result[name]={prelude:atrule.prelude&&(syntaxAsAst?atrule.prelude.syntax:generate$1u(atrule.prelude.syntax,{compact:compact})),descriptors:atrule.descriptors&&dumpMapSyntax$1(atrule.descriptors,compact,syntaxAsAst)}
return result}function valueHasVar$1(tokens){for(let i=0;i<tokens.length;i++)if(tokens[i].value.toLowerCase()==="var(")return true
return false}function syntaxHasTopLevelCommaMultiplier(syntax){const singleTerm=syntax.terms[0]
return syntax.explicit===false&&syntax.terms.length===1&&singleTerm.type==="Multiplier"&&singleTerm.comma===true}function buildMatchResult$1(matched,error,iterations){return{matched:matched,iterations:iterations,error:error,...trace$1}}function matchSyntax$1(lexer,syntax,value,useCssWideKeywords){const tokens=prepareTokens$1(value,lexer.syntax)
let result
if(valueHasVar$1(tokens))return buildMatchResult$1(null,new Error("Matching for a tree with var() is not supported"))
useCssWideKeywords&&(result=matchAsTree$1(tokens,lexer.cssWideKeywordsSyntax,lexer))
if(!useCssWideKeywords||!result.match){result=matchAsTree$1(tokens,syntax.match,lexer)
if(!result.match)return buildMatchResult$1(null,new SyntaxMatchError$1(result.reason,syntax.syntax,value,result),result.iterations)}return buildMatchResult$1(result.match,null,result.iterations)}let Lexer$1=class Lexer{constructor(config,syntax,structure){this.cssWideKeywords=cssWideKeywords$1
this.syntax=syntax
this.generic=false
this.units={...units}
this.atrules=Object.create(null)
this.properties=Object.create(null)
this.types=Object.create(null)
this.structure=structure||getStructureFromConfig$1(config)
if(config){config.cssWideKeywords&&(this.cssWideKeywords=config.cssWideKeywords)
if(config.units)for(const group of Object.keys(units))Array.isArray(config.units[group])&&(this.units[group]=config.units[group])
if(config.types)for(const[name,type]of Object.entries(config.types))this.addType_(name,type)
if(config.generic){this.generic=true
for(const[name,value]of Object.entries(createGenericTypes(this.units)))this.addType_(name,value)}if(config.atrules)for(const[name,atrule]of Object.entries(config.atrules))this.addAtrule_(name,atrule)
if(config.properties)for(const[name,property]of Object.entries(config.properties))this.addProperty_(name,property)}this.cssWideKeywordsSyntax=buildMatchGraph$1(this.cssWideKeywords.join(" |  "))}checkStructure(ast){function collectWarning(node,message){warns.push({node:node,message:message})}const structure=this.structure
const warns=[]
this.syntax.walk(ast,(function(node){structure.hasOwnProperty(node.type)?structure[node.type].check(node,collectWarning):collectWarning(node,"Unknown node type `"+node.type+"`")}))
return!!warns.length&&warns}createDescriptor(syntax,type,name,parent=null){const ref={type:type,name:name}
const descriptor={type:type,name:name,parent:parent,serializable:typeof syntax==="string"||syntax&&typeof syntax.type==="string",syntax:null,match:null,matchRef:null}
if(typeof syntax==="function")descriptor.match=buildMatchGraph$1(syntax,ref)
else{typeof syntax==="string"?Object.defineProperty(descriptor,"syntax",{get(){Object.defineProperty(descriptor,"syntax",{value:parse$1u(syntax)})
return descriptor.syntax}}):descriptor.syntax=syntax
Object.defineProperty(descriptor,"match",{get(){Object.defineProperty(descriptor,"match",{value:buildMatchGraph$1(descriptor.syntax,ref)})
return descriptor.match}})
type==="Property"&&Object.defineProperty(descriptor,"matchRef",{get(){const syntax=descriptor.syntax
const value=syntaxHasTopLevelCommaMultiplier(syntax)?buildMatchGraph$1({...syntax,terms:[syntax.terms[0].term]},ref):null
Object.defineProperty(descriptor,"matchRef",{value:value})
return value}})}return descriptor}addAtrule_(name,syntax){if(!syntax)return
this.atrules[name]={type:"Atrule",name:name,prelude:syntax.prelude?this.createDescriptor(syntax.prelude,"AtrulePrelude",name):null,descriptors:syntax.descriptors?Object.keys(syntax.descriptors).reduce(((map,descName)=>{map[descName]=this.createDescriptor(syntax.descriptors[descName],"AtruleDescriptor",descName,name)
return map}),Object.create(null)):null}}addProperty_(name,syntax){if(!syntax)return
this.properties[name]=this.createDescriptor(syntax,"Property",name)}addType_(name,syntax){if(!syntax)return
this.types[name]=this.createDescriptor(syntax,"Type",name)}checkAtruleName(atruleName){if(!this.getAtrule(atruleName))return new SyntaxReferenceError$1("Unknown at-rule","@"+atruleName)}checkAtrulePrelude(atruleName,prelude){const error=this.checkAtruleName(atruleName)
if(error)return error
const atrule=this.getAtrule(atruleName)
if(!atrule.prelude&&prelude)return new SyntaxError("At-rule `@"+atruleName+"` should not contain a prelude")
if(atrule.prelude&&!prelude&&!matchSyntax$1(this,atrule.prelude,"",false).matched)return new SyntaxError("At-rule `@"+atruleName+"` should contain a prelude")}checkAtruleDescriptorName(atruleName,descriptorName){const error=this.checkAtruleName(atruleName)
if(error)return error
const atrule=this.getAtrule(atruleName)
const descriptor=keyword$1(descriptorName)
if(!atrule.descriptors)return new SyntaxError("At-rule `@"+atruleName+"` has no known descriptors")
if(!atrule.descriptors[descriptor.name]&&!atrule.descriptors[descriptor.basename])return new SyntaxReferenceError$1("Unknown at-rule descriptor",descriptorName)}checkPropertyName(propertyName){if(!this.getProperty(propertyName))return new SyntaxReferenceError$1("Unknown property",propertyName)}matchAtrulePrelude(atruleName,prelude){const error=this.checkAtrulePrelude(atruleName,prelude)
if(error)return buildMatchResult$1(null,error)
const atrule=this.getAtrule(atruleName)
if(!atrule.prelude)return buildMatchResult$1(null,null)
return matchSyntax$1(this,atrule.prelude,prelude||"",false)}matchAtruleDescriptor(atruleName,descriptorName,value){const error=this.checkAtruleDescriptorName(atruleName,descriptorName)
if(error)return buildMatchResult$1(null,error)
const atrule=this.getAtrule(atruleName)
const descriptor=keyword$1(descriptorName)
return matchSyntax$1(this,atrule.descriptors[descriptor.name]||atrule.descriptors[descriptor.basename],value,false)}matchDeclaration(node){if(node.type!=="Declaration")return buildMatchResult$1(null,new Error("Not a Declaration node"))
return this.matchProperty(node.property,node.value)}matchProperty(propertyName,value){if(property$1(propertyName).custom)return buildMatchResult$1(null,new Error("Lexer matching doesn't applicable for custom properties"))
const error=this.checkPropertyName(propertyName)
if(error)return buildMatchResult$1(null,error)
return matchSyntax$1(this,this.getProperty(propertyName),value,true)}matchType(typeName,value){const typeSyntax=this.getType(typeName)
if(!typeSyntax)return buildMatchResult$1(null,new SyntaxReferenceError$1("Unknown type",typeName))
return matchSyntax$1(this,typeSyntax,value,false)}match(syntax,value){if(typeof syntax!=="string"&&(!syntax||!syntax.type))return buildMatchResult$1(null,new SyntaxReferenceError$1("Bad syntax"))
typeof syntax!=="string"&&syntax.match||(syntax=this.createDescriptor(syntax,"Type","anonymous"))
return matchSyntax$1(this,syntax,value,false)}findValueFragments(propertyName,value,type,name){return matchFragments$1(this,value,this.matchProperty(propertyName,value),type,name)}findDeclarationValueFragments(declaration,type,name){return matchFragments$1(this,declaration.value,this.matchDeclaration(declaration),type,name)}findAllFragments(ast,type,name){const result=[]
this.syntax.walk(ast,{visit:"Declaration",enter:declaration=>{result.push.apply(result,this.findDeclarationValueFragments(declaration,type,name))}})
return result}getAtrule(atruleName,fallbackBasename=true){const atrule=keyword$1(atruleName)
const atruleEntry=atrule.vendor&&fallbackBasename?this.atrules[atrule.name]||this.atrules[atrule.basename]:this.atrules[atrule.name]
return atruleEntry||null}getAtrulePrelude(atruleName,fallbackBasename=true){const atrule=this.getAtrule(atruleName,fallbackBasename)
return atrule&&atrule.prelude||null}getAtruleDescriptor(atruleName,name){return this.atrules.hasOwnProperty(atruleName)&&this.atrules.declarators&&this.atrules[atruleName].declarators[name]||null}getProperty(propertyName,fallbackBasename=true){const property=property$1(propertyName)
const propertyEntry=property.vendor&&fallbackBasename?this.properties[property.name]||this.properties[property.basename]:this.properties[property.name]
return propertyEntry||null}getType(name){return hasOwnProperty.call(this.types,name)?this.types[name]:null}validate(){function syntaxRef(name,isType){return isType?`<${name}>`:`<'${name}'>`}function validate(syntax,name,broken,descriptor){if(broken.has(name))return broken.get(name)
broken.set(name,false)
descriptor.syntax!==null&&walk$4(descriptor.syntax,(function(node){if(node.type!=="Type"&&node.type!=="Property")return
const map=node.type==="Type"?syntax.types:syntax.properties
const brokenMap=node.type==="Type"?brokenTypes:brokenProperties
if(hasOwnProperty.call(map,node.name)){if(validate(syntax,node.name,brokenMap,map[node.name])){errors.push(`${syntaxRef(name,broken===brokenTypes)} used broken syntax definition ${syntaxRef(node.name,node.type==="Type")}`)
broken.set(name,true)}}else{errors.push(`${syntaxRef(name,broken===brokenTypes)} used missed syntax definition ${syntaxRef(node.name,node.type==="Type")}`)
broken.set(name,true)}}),this)}const errors=[]
let brokenTypes=new Map
let brokenProperties=new Map
for(const key in this.types)validate(this,key,brokenTypes,this.types[key])
for(const key in this.properties)validate(this,key,brokenProperties,this.properties[key])
const brokenTypesArray=[...brokenTypes.keys()].filter((name=>brokenTypes.get(name)))
const brokenPropertiesArray=[...brokenProperties.keys()].filter((name=>brokenProperties.get(name)))
if(brokenTypesArray.length||brokenPropertiesArray.length)return{errors:errors,types:brokenTypesArray,properties:brokenPropertiesArray}
return null}dump(syntaxAsAst,pretty){return{generic:this.generic,cssWideKeywords:this.cssWideKeywords,units:this.units,types:dumpMapSyntax$1(this.types,!pretty,syntaxAsAst),properties:dumpMapSyntax$1(this.properties,!pretty,syntaxAsAst),atrules:dumpAtruleMapSyntax$1(this.atrules,!pretty,syntaxAsAst)}}toString(){return JSON.stringify(this.dump())}}
function appendOrSet(a,b){if(typeof b==="string"&&/^\s*\|/.test(b))return typeof a==="string"?a+b:b.replace(/^\s*\|\s*/,"")
return b||null}function sliceProps(obj,props){const result=Object.create(null)
for(const[key,value]of Object.entries(obj))if(value){result[key]={}
for(const prop of Object.keys(value))props.includes(prop)&&(result[key][prop]=value[prop])}return result}function mix$2(dest,src){const result={...dest}
for(const[prop,value]of Object.entries(src))switch(prop){case"generic":result[prop]=Boolean(value)
break
case"cssWideKeywords":result[prop]=dest[prop]?[...dest[prop],...value]:value||[]
break
case"units":result[prop]={...dest[prop]}
for(const[name,patch]of Object.entries(value))result[prop][name]=Array.isArray(patch)?patch:[]
break
case"atrules":result[prop]={...dest[prop]}
for(const[name,atrule]of Object.entries(value)){const exists=result[prop][name]||{}
const current=result[prop][name]={prelude:exists.prelude||null,descriptors:{...exists.descriptors}}
if(!atrule)continue
current.prelude=atrule.prelude?appendOrSet(current.prelude,atrule.prelude):current.prelude||null
for(const[descriptorName,descriptorValue]of Object.entries(atrule.descriptors||{}))current.descriptors[descriptorName]=descriptorValue?appendOrSet(current.descriptors[descriptorName],descriptorValue):null
Object.keys(current.descriptors).length||(current.descriptors=null)}break
case"types":case"properties":result[prop]={...dest[prop]}
for(const[name,syntax]of Object.entries(value))result[prop][name]=appendOrSet(result[prop][name],syntax)
break
case"scope":case"features":result[prop]={...dest[prop]}
for(const[name,props]of Object.entries(value))result[prop][name]={...result[prop][name],...props}
break
case"parseContext":result[prop]={...dest[prop],...value}
break
case"atrule":case"pseudo":result[prop]={...dest[prop],...sliceProps(value,["parse"])}
break
case"node":result[prop]={...dest[prop],...sliceProps(value,["name","structure","parse","generate","walkContext"])}
break}return result}function createSyntax$2(config){const parse=createParser$1(config)
const walk=createWalker$1(config)
const generate=createGenerator$1(config)
const{fromPlainObject:fromPlainObject,toPlainObject:toPlainObject}=createConvertor$1(walk)
const syntax={lexer:null,createLexer:config=>new Lexer$1(config,syntax,syntax.lexer.structure),tokenize:tokenize$4,parse:parse,generate:generate,walk:walk,find:walk.find,findLast:walk.findLast,findAll:walk.findAll,fromPlainObject:fromPlainObject,toPlainObject:toPlainObject,fork(extension){const base=mix$2({},config)
return createSyntax$2(typeof extension==="function"?extension(base):mix$2(base,extension))}}
syntax.lexer=new Lexer$1({generic:config.generic,cssWideKeywords:config.cssWideKeywords,units:config.units,types:config.types,atrules:config.atrules,properties:config.properties,node:config.node},syntax)
return syntax}var createSyntax$3=config=>createSyntax$2(mix$2({},config))
var definitions$1={generic:true,cssWideKeywords:["initial","inherit","unset","revert","revert-layer"],units:{angle:["deg","grad","rad","turn"],decibel:["db"],flex:["fr"],frequency:["hz","khz"],length:["cm","mm","q","in","pt","pc","px","em","rem","ex","rex","cap","rcap","ch","rch","ic","ric","lh","rlh","vw","svw","lvw","dvw","vh","svh","lvh","dvh","vi","svi","lvi","dvi","vb","svb","lvb","dvb","vmin","svmin","lvmin","dvmin","vmax","svmax","lvmax","dvmax","cqw","cqh","cqi","cqb","cqmin","cqmax"],resolution:["dpi","dpcm","dppx","x"],semitones:["st"],time:["s","ms"]},types:{"abs()":"abs( <calc-sum> )","absolute-size":"xx-small|x-small|small|medium|large|x-large|xx-large|xxx-large","acos()":"acos( <calc-sum> )","alpha-value":"<number>|<percentage>","angle-percentage":"<angle>|<percentage>","angular-color-hint":"<angle-percentage>","angular-color-stop":"<color>&&<color-stop-angle>?","angular-color-stop-list":"[<angular-color-stop> [, <angular-color-hint>]?]# , <angular-color-stop>","animateable-feature":"scroll-position|contents|<custom-ident>","asin()":"asin( <calc-sum> )","atan()":"atan( <calc-sum> )","atan2()":"atan2( <calc-sum> , <calc-sum> )",attachment:"scroll|fixed|local","attr()":"attr( <attr-name> <type-or-unit>? [, <attr-fallback>]? )","attr-matcher":"['~'|'|'|'^'|'$'|'*']? '='","attr-modifier":"i|s","attribute-selector":"'[' <wq-name> ']'|'[' <wq-name> <attr-matcher> [<string-token>|<ident-token>] <attr-modifier>? ']'","auto-repeat":"repeat( [auto-fill|auto-fit] , [<line-names>? <fixed-size>]+ <line-names>? )","auto-track-list":"[<line-names>? [<fixed-size>|<fixed-repeat>]]* <line-names>? <auto-repeat> [<line-names>? [<fixed-size>|<fixed-repeat>]]* <line-names>?",axis:"block|inline|vertical|horizontal","baseline-position":"[first|last]? baseline","basic-shape":"<inset()>|<xywh()>|<rect()>|<circle()>|<ellipse()>|<polygon()>|<path()>","bg-image":"none|<image>","bg-layer":"<bg-image>||<bg-position> [/ <bg-size>]?||<repeat-style>||<attachment>||<box>||<box>","bg-position":"[[left|center|right|top|bottom|<length-percentage>]|[left|center|right|<length-percentage>] [top|center|bottom|<length-percentage>]|[center|[left|right] <length-percentage>?]&&[center|[top|bottom] <length-percentage>?]]","bg-size":"[<length-percentage>|auto]{1,2}|cover|contain","blur()":"blur( <length> )","blend-mode":"normal|multiply|screen|overlay|darken|lighten|color-dodge|color-burn|hard-light|soft-light|difference|exclusion|hue|saturation|color|luminosity",box:"border-box|padding-box|content-box","brightness()":"brightness( <number-percentage> )","calc()":"calc( <calc-sum> )","calc-sum":"<calc-product> [['+'|'-'] <calc-product>]*","calc-product":"<calc-value> ['*' <calc-value>|'/' <number>]*","calc-value":"<number>|<dimension>|<percentage>|<calc-constant>|( <calc-sum> )","calc-constant":"e|pi|infinity|-infinity|NaN","cf-final-image":"<image>|<color>","cf-mixing-image":"<percentage>?&&<image>","circle()":"circle( [<shape-radius>]? [at <position>]? )","clamp()":"clamp( <calc-sum>#{3} )","class-selector":"'.' <ident-token>","clip-source":"<url>",color:"<color-base>|currentColor|<system-color>|<device-cmyk()>|<light-dark()>|<-non-standard-color>","color-stop":"<color-stop-length>|<color-stop-angle>","color-stop-angle":"<angle-percentage>{1,2}","color-stop-length":"<length-percentage>{1,2}","color-stop-list":"[<linear-color-stop> [, <linear-color-hint>]?]# , <linear-color-stop>","color-interpolation-method":"in [<rectangular-color-space>|<polar-color-space> <hue-interpolation-method>?|<custom-color-space>]",combinator:"'>'|'+'|'~'|['|' '|']","common-lig-values":"[common-ligatures|no-common-ligatures]","compat-auto":"searchfield|textarea|push-button|slider-horizontal|checkbox|radio|square-button|menulist|listbox|meter|progress-bar|button","composite-style":"clear|copy|source-over|source-in|source-out|source-atop|destination-over|destination-in|destination-out|destination-atop|xor","compositing-operator":"add|subtract|intersect|exclude","compound-selector":"[<type-selector>? <subclass-selector>*]!","compound-selector-list":"<compound-selector>#","complex-selector":"<complex-selector-unit> [<combinator>? <complex-selector-unit>]*","complex-selector-list":"<complex-selector>#","conic-gradient()":"conic-gradient( [from <angle>]? [at <position>]? , <angular-color-stop-list> )","contextual-alt-values":"[contextual|no-contextual]","content-distribution":"space-between|space-around|space-evenly|stretch","content-list":"[<string>|contents|<image>|<counter>|<quote>|<target>|<leader()>|<attr()>]+","content-position":"center|start|end|flex-start|flex-end","content-replacement":"<image>","contrast()":"contrast( [<number-percentage>] )","cos()":"cos( <calc-sum> )",counter:"<counter()>|<counters()>","counter()":"counter( <counter-name> , <counter-style>? )","counter-name":"<custom-ident>","counter-style":"<counter-style-name>|symbols( )","counter-style-name":"<custom-ident>","counters()":"counters( <counter-name> , <string> , <counter-style>? )","cross-fade()":"cross-fade( <cf-mixing-image> , <cf-final-image>? )","cubic-bezier-timing-function":"ease|ease-in|ease-out|ease-in-out|cubic-bezier( <number [0,1]> , <number> , <number [0,1]> , <number> )","deprecated-system-color":"ActiveBorder|ActiveCaption|AppWorkspace|Background|ButtonFace|ButtonHighlight|ButtonShadow|ButtonText|CaptionText|GrayText|Highlight|HighlightText|InactiveBorder|InactiveCaption|InactiveCaptionText|InfoBackground|InfoText|Menu|MenuText|Scrollbar|ThreeDDarkShadow|ThreeDFace|ThreeDHighlight|ThreeDLightShadow|ThreeDShadow|Window|WindowFrame|WindowText","discretionary-lig-values":"[discretionary-ligatures|no-discretionary-ligatures]","display-box":"contents|none","display-inside":"flow|flow-root|table|flex|grid|ruby","display-internal":"table-row-group|table-header-group|table-footer-group|table-row|table-cell|table-column-group|table-column|table-caption|ruby-base|ruby-text|ruby-base-container|ruby-text-container","display-legacy":"inline-block|inline-list-item|inline-table|inline-flex|inline-grid","display-listitem":"<display-outside>?&&[flow|flow-root]?&&list-item","display-outside":"block|inline|run-in","drop-shadow()":"drop-shadow( <length>{2,3} <color>? )","east-asian-variant-values":"[jis78|jis83|jis90|jis04|simplified|traditional]","east-asian-width-values":"[full-width|proportional-width]","element()":"element( <custom-ident> , [first|start|last|first-except]? )|element( <id-selector> )","ellipse()":"ellipse( [<shape-radius>{2}]? [at <position>]? )","ending-shape":"circle|ellipse","env()":"env( <custom-ident> , <declaration-value>? )","exp()":"exp( <calc-sum> )","explicit-track-list":"[<line-names>? <track-size>]+ <line-names>?","family-name":"<string>|<custom-ident>+","feature-tag-value":"<string> [<integer>|on|off]?","feature-type":"@stylistic|@historical-forms|@styleset|@character-variant|@swash|@ornaments|@annotation","feature-value-block":"<feature-type> '{' <feature-value-declaration-list> '}'","feature-value-block-list":"<feature-value-block>+","feature-value-declaration":"<custom-ident> : <integer>+ ;","feature-value-declaration-list":"<feature-value-declaration>","feature-value-name":"<custom-ident>","fill-rule":"nonzero|evenodd","filter-function":"<blur()>|<brightness()>|<contrast()>|<drop-shadow()>|<grayscale()>|<hue-rotate()>|<invert()>|<opacity()>|<saturate()>|<sepia()>","filter-function-list":"[<filter-function>|<url>]+","final-bg-layer":"<'background-color'>||<bg-image>||<bg-position> [/ <bg-size>]?||<repeat-style>||<attachment>||<box>||<box>","fixed-breadth":"<length-percentage>","fixed-repeat":"repeat( [<integer [1,∞]>] , [<line-names>? <fixed-size>]+ <line-names>? )","fixed-size":"<fixed-breadth>|minmax( <fixed-breadth> , <track-breadth> )|minmax( <inflexible-breadth> , <fixed-breadth> )","font-stretch-absolute":"normal|ultra-condensed|extra-condensed|condensed|semi-condensed|semi-expanded|expanded|extra-expanded|ultra-expanded|<percentage>","font-variant-css21":"[normal|small-caps]","font-weight-absolute":"normal|bold|<number [1,1000]>","frequency-percentage":"<frequency>|<percentage>","general-enclosed":"[<function-token> <any-value>? )]|[( <any-value>? )]","generic-family":"<generic-script-specific>|<generic-complete>|<generic-incomplete>|<-non-standard-generic-family>","generic-name":"serif|sans-serif|cursive|fantasy|monospace","geometry-box":"<shape-box>|fill-box|stroke-box|view-box",gradient:"<linear-gradient()>|<repeating-linear-gradient()>|<radial-gradient()>|<repeating-radial-gradient()>|<conic-gradient()>|<repeating-conic-gradient()>|<-legacy-gradient>","grayscale()":"grayscale( <number-percentage> )","grid-line":"auto|<custom-ident>|[<integer>&&<custom-ident>?]|[span&&[<integer>||<custom-ident>]]","historical-lig-values":"[historical-ligatures|no-historical-ligatures]","hsl()":"hsl( <hue> <percentage> <percentage> [/ <alpha-value>]? )|hsl( <hue> , <percentage> , <percentage> , <alpha-value>? )","hsla()":"hsla( <hue> <percentage> <percentage> [/ <alpha-value>]? )|hsla( <hue> , <percentage> , <percentage> , <alpha-value>? )",hue:"<number>|<angle>","hue-rotate()":"hue-rotate( <angle> )","hue-interpolation-method":"[shorter|longer|increasing|decreasing] hue","hwb()":"hwb( [<hue>|none] [<percentage>|none] [<percentage>|none] [/ [<alpha-value>|none]]? )","hypot()":"hypot( <calc-sum># )",image:"<url>|<image()>|<image-set()>|<element()>|<paint()>|<cross-fade()>|<gradient>","image()":"image( <image-tags>? [<image-src>? , <color>?]! )","image-set()":"image-set( <image-set-option># )","image-set-option":"[<image>|<string>] [<resolution>||type( <string> )]","image-src":"<url>|<string>","image-tags":"ltr|rtl","inflexible-breadth":"<length-percentage>|min-content|max-content|auto","inset()":"inset( <length-percentage>{1,4} [round <'border-radius'>]? )","invert()":"invert( <number-percentage> )","keyframes-name":"<custom-ident>|<string>","keyframe-block":"<keyframe-selector># { <declaration-list> }","keyframe-block-list":"<keyframe-block>+","keyframe-selector":"from|to|<percentage>|<timeline-range-name> <percentage>","lab()":"lab( [<percentage>|<number>|none] [<percentage>|<number>|none] [<percentage>|<number>|none] [/ [<alpha-value>|none]]? )","layer()":"layer( <layer-name> )","layer-name":"<ident> ['.' <ident>]*","lch()":"lch( [<percentage>|<number>|none] [<percentage>|<number>|none] [<hue>|none] [/ [<alpha-value>|none]]? )","leader()":"leader( <leader-type> )","leader-type":"dotted|solid|space|<string>","length-percentage":"<length>|<percentage>","light-dark()":"light-dark( <color> , <color> )","line-names":"'[' <custom-ident>* ']'","line-name-list":"[<line-names>|<name-repeat>]+","line-style":"none|hidden|dotted|dashed|solid|double|groove|ridge|inset|outset","line-width":"<length>|thin|medium|thick","linear-color-hint":"<length-percentage>","linear-color-stop":"<color> <color-stop-length>?","linear-gradient()":"linear-gradient( [[<angle>|to <side-or-corner>]||<color-interpolation-method>]? , <color-stop-list> )","log()":"log( <calc-sum> , <calc-sum>? )","mask-layer":"<mask-reference>||<position> [/ <bg-size>]?||<repeat-style>||<geometry-box>||[<geometry-box>|no-clip]||<compositing-operator>||<masking-mode>","mask-position":"[<length-percentage>|left|center|right] [<length-percentage>|top|center|bottom]?","mask-reference":"none|<image>|<mask-source>","mask-source":"<url>","masking-mode":"alpha|luminance|match-source","matrix()":"matrix( <number>#{6} )","matrix3d()":"matrix3d( <number>#{16} )","max()":"max( <calc-sum># )","media-and":"<media-in-parens> [and <media-in-parens>]+","media-condition":"<media-not>|<media-and>|<media-or>|<media-in-parens>","media-condition-without-or":"<media-not>|<media-and>|<media-in-parens>","media-feature":"( [<mf-plain>|<mf-boolean>|<mf-range>] )","media-in-parens":"( <media-condition> )|<media-feature>|<general-enclosed>","media-not":"not <media-in-parens>","media-or":"<media-in-parens> [or <media-in-parens>]+","media-query":"<media-condition>|[not|only]? <media-type> [and <media-condition-without-or>]?","media-query-list":"<media-query>#","media-type":"<ident>","mf-boolean":"<mf-name>","mf-name":"<ident>","mf-plain":"<mf-name> : <mf-value>","mf-range":"<mf-name> ['<'|'>']? '='? <mf-value>|<mf-value> ['<'|'>']? '='? <mf-name>|<mf-value> '<' '='? <mf-name> '<' '='? <mf-value>|<mf-value> '>' '='? <mf-name> '>' '='? <mf-value>","mf-value":"<number>|<dimension>|<ident>|<ratio>","min()":"min( <calc-sum># )","minmax()":"minmax( [<length-percentage>|min-content|max-content|auto] , [<length-percentage>|<flex>|min-content|max-content|auto] )","mod()":"mod( <calc-sum> , <calc-sum> )","name-repeat":"repeat( [<integer [1,∞]>|auto-fill] , <line-names>+ )","named-color":"transparent|aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgreen|darkgrey|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkslategrey|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dimgrey|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|green|greenyellow|grey|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgray|lightgreen|lightgrey|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightslategrey|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|rebeccapurple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silver|skyblue|slateblue|slategray|slategrey|snow|springgreen|steelblue|tan|teal|thistle|tomato|turquoise|violet|wheat|white|whitesmoke|yellow|yellowgreen","namespace-prefix":"<ident>","ns-prefix":"[<ident-token>|'*']? '|'","number-percentage":"<number>|<percentage>","numeric-figure-values":"[lining-nums|oldstyle-nums]","numeric-fraction-values":"[diagonal-fractions|stacked-fractions]","numeric-spacing-values":"[proportional-nums|tabular-nums]",nth:"<an-plus-b>|even|odd","opacity()":"opacity( [<number-percentage>] )","overflow-position":"unsafe|safe","outline-radius":"<length>|<percentage>","page-body":"<declaration>? [; <page-body>]?|<page-margin-box> <page-body>","page-margin-box":"<page-margin-box-type> '{' <declaration-list> '}'","page-margin-box-type":"@top-left-corner|@top-left|@top-center|@top-right|@top-right-corner|@bottom-left-corner|@bottom-left|@bottom-center|@bottom-right|@bottom-right-corner|@left-top|@left-middle|@left-bottom|@right-top|@right-middle|@right-bottom","page-selector-list":"[<page-selector>#]?","page-selector":"<pseudo-page>+|<ident> <pseudo-page>*","page-size":"A5|A4|A3|B5|B4|JIS-B5|JIS-B4|letter|legal|ledger","path()":"path( [<fill-rule> ,]? <string> )","paint()":"paint( <ident> , <declaration-value>? )","perspective()":"perspective( [<length [0,∞]>|none] )","polygon()":"polygon( <fill-rule>? , [<length-percentage> <length-percentage>]# )","polar-color-space":"hsl|hwb|lch|oklch",position:"[[left|center|right]||[top|center|bottom]|[left|center|right|<length-percentage>] [top|center|bottom|<length-percentage>]?|[[left|right] <length-percentage>]&&[[top|bottom] <length-percentage>]]","pow()":"pow( <calc-sum> , <calc-sum> )","pseudo-class-selector":"':' <ident-token>|':' <function-token> <any-value> ')'","pseudo-element-selector":"':' <pseudo-class-selector>|<legacy-pseudo-element-selector>","pseudo-page":": [left|right|first|blank]",quote:"open-quote|close-quote|no-open-quote|no-close-quote","radial-gradient()":"radial-gradient( [<ending-shape>||<size>]? [at <position>]? , <color-stop-list> )",ratio:"<number [0,∞]> [/ <number [0,∞]>]?","ray()":"ray( <angle>&&<ray-size>?&&contain?&&[at <position>]? )","ray-size":"closest-side|closest-corner|farthest-side|farthest-corner|sides","rectangular-color-space":"srgb|srgb-linear|display-p3|a98-rgb|prophoto-rgb|rec2020|lab|oklab|xyz|xyz-d50|xyz-d65","relative-selector":"<combinator>? <complex-selector>","relative-selector-list":"<relative-selector>#","relative-size":"larger|smaller","rem()":"rem( <calc-sum> , <calc-sum> )","repeat-style":"repeat-x|repeat-y|[repeat|space|round|no-repeat]{1,2}","repeating-conic-gradient()":"repeating-conic-gradient( [from <angle>]? [at <position>]? , <angular-color-stop-list> )","repeating-linear-gradient()":"repeating-linear-gradient( [<angle>|to <side-or-corner>]? , <color-stop-list> )","repeating-radial-gradient()":"repeating-radial-gradient( [<ending-shape>||<size>]? [at <position>]? , <color-stop-list> )","reversed-counter-name":"reversed( <counter-name> )","rgb()":"rgb( <percentage>{3} [/ <alpha-value>]? )|rgb( <number>{3} [/ <alpha-value>]? )|rgb( <percentage>#{3} , <alpha-value>? )|rgb( <number>#{3} , <alpha-value>? )","rgba()":"rgba( <percentage>{3} [/ <alpha-value>]? )|rgba( <number>{3} [/ <alpha-value>]? )|rgba( <percentage>#{3} , <alpha-value>? )|rgba( <number>#{3} , <alpha-value>? )","rotate()":"rotate( [<angle>|<zero>] )","rotate3d()":"rotate3d( <number> , <number> , <number> , [<angle>|<zero>] )","rotateX()":"rotateX( [<angle>|<zero>] )","rotateY()":"rotateY( [<angle>|<zero>] )","rotateZ()":"rotateZ( [<angle>|<zero>] )","round()":"round( <rounding-strategy>? , <calc-sum> , <calc-sum> )","rounding-strategy":"nearest|up|down|to-zero","saturate()":"saturate( <number-percentage> )","scale()":"scale( [<number>|<percentage>]#{1,2} )","scale3d()":"scale3d( [<number>|<percentage>]#{3} )","scaleX()":"scaleX( [<number>|<percentage>] )","scaleY()":"scaleY( [<number>|<percentage>] )","scaleZ()":"scaleZ( [<number>|<percentage>] )","scroll()":"scroll( [<axis>||<scroller>]? )",scroller:"root|nearest","self-position":"center|start|end|self-start|self-end|flex-start|flex-end","shape-radius":"<length-percentage>|closest-side|farthest-side","sign()":"sign( <calc-sum> )","skew()":"skew( [<angle>|<zero>] , [<angle>|<zero>]? )","skewX()":"skewX( [<angle>|<zero>] )","skewY()":"skewY( [<angle>|<zero>] )","sepia()":"sepia( <number-percentage> )",shadow:"inset?&&<length>{2,4}&&<color>?","shadow-t":"[<length>{2,3}&&<color>?]",shape:"rect( <top> , <right> , <bottom> , <left> )|rect( <top> <right> <bottom> <left> )","shape-box":"<box>|margin-box","side-or-corner":"[left|right]||[top|bottom]","sin()":"sin( <calc-sum> )","single-animation":"<'animation-duration'>||<easing-function>||<'animation-delay'>||<single-animation-iteration-count>||<single-animation-direction>||<single-animation-fill-mode>||<single-animation-play-state>||[none|<keyframes-name>]||<single-animation-timeline>","single-animation-direction":"normal|reverse|alternate|alternate-reverse","single-animation-fill-mode":"none|forwards|backwards|both","single-animation-iteration-count":"infinite|<number>","single-animation-play-state":"running|paused","single-animation-timeline":"auto|none|<dashed-ident>|<scroll()>|<view()>","single-transition":"[none|<single-transition-property>]||<time>||<easing-function>||<time>||<transition-behavior-value>","single-transition-property":"all|<custom-ident>",size:"closest-side|farthest-side|closest-corner|farthest-corner|<length>|<length-percentage>{2}","sqrt()":"sqrt( <calc-sum> )","step-position":"jump-start|jump-end|jump-none|jump-both|start|end","step-timing-function":"step-start|step-end|steps( <integer> [, <step-position>]? )","subclass-selector":"<id-selector>|<class-selector>|<attribute-selector>|<pseudo-class-selector>","supports-condition":"not <supports-in-parens>|<supports-in-parens> [and <supports-in-parens>]*|<supports-in-parens> [or <supports-in-parens>]*","supports-in-parens":"( <supports-condition> )|<supports-feature>|<general-enclosed>","supports-feature":"<supports-decl>|<supports-selector-fn>","supports-decl":"( <declaration> )","supports-selector-fn":"selector( <complex-selector> )",symbol:"<string>|<image>|<custom-ident>","tan()":"tan( <calc-sum> )",target:"<target-counter()>|<target-counters()>|<target-text()>","target-counter()":"target-counter( [<string>|<url>] , <custom-ident> , <counter-style>? )","target-counters()":"target-counters( [<string>|<url>] , <custom-ident> , <string> , <counter-style>? )","target-text()":"target-text( [<string>|<url>] , [content|before|after|first-letter]? )","time-percentage":"<time>|<percentage>","timeline-range-name":"cover|contain|entry|exit|entry-crossing|exit-crossing","easing-function":"linear|<cubic-bezier-timing-function>|<step-timing-function>","track-breadth":"<length-percentage>|<flex>|min-content|max-content|auto","track-list":"[<line-names>? [<track-size>|<track-repeat>]]+ <line-names>?","track-repeat":"repeat( [<integer [1,∞]>] , [<line-names>? <track-size>]+ <line-names>? )","track-size":"<track-breadth>|minmax( <inflexible-breadth> , <track-breadth> )|fit-content( <length-percentage> )","transform-function":"<matrix()>|<translate()>|<translateX()>|<translateY()>|<scale()>|<scaleX()>|<scaleY()>|<rotate()>|<skew()>|<skewX()>|<skewY()>|<matrix3d()>|<translate3d()>|<translateZ()>|<scale3d()>|<scaleZ()>|<rotate3d()>|<rotateX()>|<rotateY()>|<rotateZ()>|<perspective()>","transform-list":"<transform-function>+","transition-behavior-value":"normal|allow-discrete","translate()":"translate( <length-percentage> , <length-percentage>? )","translate3d()":"translate3d( <length-percentage> , <length-percentage> , <length> )","translateX()":"translateX( <length-percentage> )","translateY()":"translateY( <length-percentage> )","translateZ()":"translateZ( <length> )","type-or-unit":"string|color|url|integer|number|length|angle|time|frequency|cap|ch|em|ex|ic|lh|rlh|rem|vb|vi|vw|vh|vmin|vmax|mm|Q|cm|in|pt|pc|px|deg|grad|rad|turn|ms|s|Hz|kHz|%","type-selector":"<wq-name>|<ns-prefix>? '*'","var()":"var( <custom-property-name> , <declaration-value>? )","view()":"view( [<axis>||<'view-timeline-inset'>]? )","viewport-length":"auto|<length-percentage>","visual-box":"content-box|padding-box|border-box","wq-name":"<ns-prefix>? <ident-token>","-legacy-gradient":"<-webkit-gradient()>|<-legacy-linear-gradient>|<-legacy-repeating-linear-gradient>|<-legacy-radial-gradient>|<-legacy-repeating-radial-gradient>","-legacy-linear-gradient":"-moz-linear-gradient( <-legacy-linear-gradient-arguments> )|-webkit-linear-gradient( <-legacy-linear-gradient-arguments> )|-o-linear-gradient( <-legacy-linear-gradient-arguments> )","-legacy-repeating-linear-gradient":"-moz-repeating-linear-gradient( <-legacy-linear-gradient-arguments> )|-webkit-repeating-linear-gradient( <-legacy-linear-gradient-arguments> )|-o-repeating-linear-gradient( <-legacy-linear-gradient-arguments> )","-legacy-linear-gradient-arguments":"[<angle>|<side-or-corner>]? , <color-stop-list>","-legacy-radial-gradient":"-moz-radial-gradient( <-legacy-radial-gradient-arguments> )|-webkit-radial-gradient( <-legacy-radial-gradient-arguments> )|-o-radial-gradient( <-legacy-radial-gradient-arguments> )","-legacy-repeating-radial-gradient":"-moz-repeating-radial-gradient( <-legacy-radial-gradient-arguments> )|-webkit-repeating-radial-gradient( <-legacy-radial-gradient-arguments> )|-o-repeating-radial-gradient( <-legacy-radial-gradient-arguments> )","-legacy-radial-gradient-arguments":"[<position> ,]? [[[<-legacy-radial-gradient-shape>||<-legacy-radial-gradient-size>]|[<length>|<percentage>]{2}] ,]? <color-stop-list>","-legacy-radial-gradient-size":"closest-side|closest-corner|farthest-side|farthest-corner|contain|cover","-legacy-radial-gradient-shape":"circle|ellipse","-non-standard-font":"-apple-system-body|-apple-system-headline|-apple-system-subheadline|-apple-system-caption1|-apple-system-caption2|-apple-system-footnote|-apple-system-short-body|-apple-system-short-headline|-apple-system-short-subheadline|-apple-system-short-caption1|-apple-system-short-footnote|-apple-system-tall-body","-non-standard-color":"-moz-ButtonDefault|-moz-ButtonHoverFace|-moz-ButtonHoverText|-moz-CellHighlight|-moz-CellHighlightText|-moz-Combobox|-moz-ComboboxText|-moz-Dialog|-moz-DialogText|-moz-dragtargetzone|-moz-EvenTreeRow|-moz-Field|-moz-FieldText|-moz-html-CellHighlight|-moz-html-CellHighlightText|-moz-mac-accentdarkestshadow|-moz-mac-accentdarkshadow|-moz-mac-accentface|-moz-mac-accentlightesthighlight|-moz-mac-accentlightshadow|-moz-mac-accentregularhighlight|-moz-mac-accentregularshadow|-moz-mac-chrome-active|-moz-mac-chrome-inactive|-moz-mac-focusring|-moz-mac-menuselect|-moz-mac-menushadow|-moz-mac-menutextselect|-moz-MenuHover|-moz-MenuHoverText|-moz-MenuBarText|-moz-MenuBarHoverText|-moz-nativehyperlinktext|-moz-OddTreeRow|-moz-win-communicationstext|-moz-win-mediatext|-moz-activehyperlinktext|-moz-default-background-color|-moz-default-color|-moz-hyperlinktext|-moz-visitedhyperlinktext|-webkit-activelink|-webkit-focus-ring-color|-webkit-link|-webkit-text","-non-standard-image-rendering":"optimize-contrast|-moz-crisp-edges|-o-crisp-edges|-webkit-optimize-contrast","-non-standard-overflow":"overlay|-moz-scrollbars-none|-moz-scrollbars-horizontal|-moz-scrollbars-vertical|-moz-hidden-unscrollable","-non-standard-size":"intrinsic|min-intrinsic|-webkit-fill-available|-webkit-fit-content|-webkit-min-content|-webkit-max-content|-moz-available|-moz-fit-content|-moz-min-content|-moz-max-content","-webkit-gradient()":"-webkit-gradient( <-webkit-gradient-type> , <-webkit-gradient-point> [, <-webkit-gradient-point>|, <-webkit-gradient-radius> , <-webkit-gradient-point>] [, <-webkit-gradient-radius>]? [, <-webkit-gradient-color-stop>]* )","-webkit-gradient-color-stop":"from( <color> )|color-stop( [<number-zero-one>|<percentage>] , <color> )|to( <color> )","-webkit-gradient-point":"[left|center|right|<length-percentage>] [top|center|bottom|<length-percentage>]","-webkit-gradient-radius":"<length>|<percentage>","-webkit-gradient-type":"linear|radial","-webkit-mask-box-repeat":"repeat|stretch|round","-ms-filter-function-list":"<-ms-filter-function>+","-ms-filter-function":"<-ms-filter-function-progid>|<-ms-filter-function-legacy>","-ms-filter-function-progid":"'progid:' [<ident-token> '.']* [<ident-token>|<function-token> <any-value>? )]","-ms-filter-function-legacy":"<ident-token>|<function-token> <any-value>? )","absolute-color-base":"<hex-color>|<absolute-color-function>|<named-color>|transparent","absolute-color-function":"<rgb()>|<rgba()>|<hsl()>|<hsla()>|<hwb()>|<lab()>|<lch()>|<oklab()>|<oklch()>|<color()>",age:"child|young|old","anchor-name":"<dashed-ident>","attr-name":"<wq-name>","attr-fallback":"<any-value>","bg-clip":"<box>|border|text",bottom:"<length>|auto","container-name":"<custom-ident>","container-condition":"not <query-in-parens>|<query-in-parens> [[and <query-in-parens>]*|[or <query-in-parens>]*]","coord-box":"content-box|padding-box|border-box|fill-box|stroke-box|view-box","generic-voice":"[<age>? <gender> <integer>?]",gender:"male|female|neutral","generic-script-specific":"generic( kai )|generic( fangsong )|generic( nastaliq )","generic-complete":"serif|sans-serif|system-ui|cursive|fantasy|math|monospace","generic-incomplete":"ui-serif|ui-sans-serif|ui-monospace|ui-rounded","-non-standard-generic-family":"-apple-system|BlinkMacSystemFont",left:"<length>|auto","color-base":"<hex-color>|<color-function>|<named-color>|<color-mix()>|transparent","color-function":"<rgb()>|<rgba()>|<hsl()>|<hsla()>|<hwb()>|<lab()>|<lch()>|<oklab()>|<oklch()>|<color()>","system-color":"AccentColor|AccentColorText|ActiveText|ButtonBorder|ButtonFace|ButtonText|Canvas|CanvasText|Field|FieldText|GrayText|Highlight|HighlightText|LinkText|Mark|MarkText|SelectedItem|SelectedItemText|VisitedText","device-cmyk()":"<legacy-device-cmyk-syntax>|<modern-device-cmyk-syntax>","legacy-device-cmyk-syntax":"device-cmyk( <number>#{4} )","modern-device-cmyk-syntax":"device-cmyk( <cmyk-component>{4} [/ [<alpha-value>|none]]? )","cmyk-component":"<number>|<percentage>|none","color-mix()":"color-mix( <color-interpolation-method> , [<color>&&<percentage [0,100]>?]#{2} )","color-space":"<rectangular-color-space>|<polar-color-space>|<custom-color-space>","custom-color-space":"<dashed-ident>",paint:"none|<color>|<url> [none|<color>]?|context-fill|context-stroke","palette-identifier":"<dashed-ident>",right:"<length>|auto","scope-start":"<forgiving-selector-list>","scope-end":"<forgiving-selector-list>","forgiving-selector-list":"<complex-real-selector-list>","forgiving-relative-selector-list":"<relative-real-selector-list>","selector-list":"<complex-selector-list>","complex-real-selector-list":"<complex-real-selector>#","simple-selector-list":"<simple-selector>#","relative-real-selector-list":"<relative-real-selector>#","complex-selector-unit":"[<compound-selector>? <pseudo-compound-selector>*]!","complex-real-selector":"<compound-selector> [<combinator>? <compound-selector>]*","relative-real-selector":"<combinator>? <complex-real-selector>","pseudo-compound-selector":"<pseudo-element-selector> <pseudo-class-selector>*","simple-selector":"<type-selector>|<subclass-selector>","legacy-pseudo-element-selector":"':' [before|after|first-line|first-letter]","single-animation-composition":"replace|add|accumulate","svg-length":"<percentage>|<length>|<number>","svg-writing-mode":"lr-tb|rl-tb|tb-rl|lr|rl|tb",top:"<length>|auto",x:"<number>",y:"<number>",declaration:"<ident-token> : <declaration-value>? ['!' important]?","declaration-list":"[<declaration>? ';']* <declaration>?",url:"url( <string> <url-modifier>* )|<url-token>","url-modifier":"<ident>|<function-token> <any-value> )","number-zero-one":"<number [0,1]>","number-one-or-greater":"<number [1,∞]>","color()":"color( <colorspace-params> [/ [<alpha-value>|none]]? )","colorspace-params":"[<predefined-rgb-params>|<xyz-params>]","predefined-rgb-params":"<predefined-rgb> [<number>|<percentage>|none]{3}","predefined-rgb":"srgb|srgb-linear|display-p3|a98-rgb|prophoto-rgb|rec2020","xyz-params":"<xyz-space> [<number>|<percentage>|none]{3}","xyz-space":"xyz|xyz-d50|xyz-d65","oklab()":"oklab( [<percentage>|<number>|none] [<percentage>|<number>|none] [<percentage>|<number>|none] [/ [<alpha-value>|none]]? )","oklch()":"oklch( [<percentage>|<number>|none] [<percentage>|<number>|none] [<hue>|none] [/ [<alpha-value>|none]]? )","offset-path":"<ray()>|<url>|<basic-shape>","rect()":"rect( [<length-percentage>|auto]{4} [round <'border-radius'>]? )","xywh()":"xywh( <length-percentage>{2} <length-percentage [0,∞]>{2} [round <'border-radius'>]? )","query-in-parens":"( <container-condition> )|( <size-feature> )|style( <style-query> )|<general-enclosed>","size-feature":"<mf-plain>|<mf-boolean>|<mf-range>","style-feature":"<declaration>","style-query":"<style-condition>|<style-feature>","style-condition":"not <style-in-parens>|<style-in-parens> [[and <style-in-parens>]*|[or <style-in-parens>]*]","style-in-parens":"( <style-condition> )|( <style-feature> )|<general-enclosed>","-non-standard-display":"-ms-inline-flexbox|-ms-grid|-ms-inline-grid|-webkit-flex|-webkit-inline-flex|-webkit-box|-webkit-inline-box|-moz-inline-stack|-moz-box|-moz-inline-box","inset-area":"[[left|center|right|span-left|span-right|x-start|x-end|span-x-start|span-x-end|x-self-start|x-self-end|span-x-self-start|span-x-self-end|span-all]||[top|center|bottom|span-top|span-bottom|y-start|y-end|span-y-start|span-y-end|y-self-start|y-self-end|span-y-self-start|span-y-self-end|span-all]|[block-start|center|block-end|span-block-start|span-block-end|span-all]||[inline-start|center|inline-end|span-inline-start|span-inline-end|span-all]|[self-block-start|self-block-end|span-self-block-start|span-self-block-end|span-all]||[self-inline-start|self-inline-end|span-self-inline-start|span-self-inline-end|span-all]|[start|center|end|span-start|span-end|span-all]{1,2}|[self-start|center|self-end|span-self-start|span-self-end|span-all]{1,2}]","position-area":"[[left|center|right|span-left|span-right|x-start|x-end|span-x-start|span-x-end|x-self-start|x-self-end|span-x-self-start|span-x-self-end|span-all]||[top|center|bottom|span-top|span-bottom|y-start|y-end|span-y-start|span-y-end|y-self-start|y-self-end|span-y-self-start|span-y-self-end|span-all]|[block-start|center|block-end|span-block-start|span-block-end|span-all]||[inline-start|center|inline-end|span-inline-start|span-inline-end|span-all]|[self-block-start|center|self-block-end|span-self-block-start|span-self-block-end|span-all]||[self-inline-start|center|self-inline-end|span-self-inline-start|span-self-inline-end|span-all]|[start|center|end|span-start|span-end|span-all]{1,2}|[self-start|center|self-end|span-self-start|span-self-end|span-all]{1,2}]","anchor()":"anchor( <anchor-element>?&&<anchor-side> , <length-percentage>? )","anchor-side":"inside|outside|top|left|right|bottom|start|end|self-start|self-end|<percentage>|center","anchor-size()":"anchor-size( [<anchor-element>||<anchor-size>]? , <length-percentage>? )","anchor-size":"width|height|block|inline|self-block|self-inline","anchor-element":"<dashed-ident>","try-size":"most-width|most-height|most-block-size|most-inline-size","try-tactic":"flip-block||flip-inline||flip-start","font-variant-css2":"normal|small-caps","font-width-css3":"normal|ultra-condensed|extra-condensed|condensed|semi-condensed|semi-expanded|expanded|extra-expanded|ultra-expanded","system-family-name":"caption|icon|menu|message-box|small-caption|status-bar"},properties:{"--*":"<declaration-value>","-ms-accelerator":"false|true","-ms-block-progression":"tb|rl|bt|lr","-ms-content-zoom-chaining":"none|chained","-ms-content-zooming":"none|zoom","-ms-content-zoom-limit":"<'-ms-content-zoom-limit-min'> <'-ms-content-zoom-limit-max'>","-ms-content-zoom-limit-max":"<percentage>","-ms-content-zoom-limit-min":"<percentage>","-ms-content-zoom-snap":"<'-ms-content-zoom-snap-type'>||<'-ms-content-zoom-snap-points'>","-ms-content-zoom-snap-points":"snapInterval( <percentage> , <percentage> )|snapList( <percentage># )","-ms-content-zoom-snap-type":"none|proximity|mandatory","-ms-filter":"<string>","-ms-flow-from":"[none|<custom-ident>]#","-ms-flow-into":"[none|<custom-ident>]#","-ms-grid-columns":"none|<track-list>|<auto-track-list>","-ms-grid-rows":"none|<track-list>|<auto-track-list>","-ms-high-contrast-adjust":"auto|none","-ms-hyphenate-limit-chars":"auto|<integer>{1,3}","-ms-hyphenate-limit-lines":"no-limit|<integer>","-ms-hyphenate-limit-zone":"<percentage>|<length>","-ms-ime-align":"auto|after","-ms-overflow-style":"auto|none|scrollbar|-ms-autohiding-scrollbar","-ms-scrollbar-3dlight-color":"<color>","-ms-scrollbar-arrow-color":"<color>","-ms-scrollbar-base-color":"<color>","-ms-scrollbar-darkshadow-color":"<color>","-ms-scrollbar-face-color":"<color>","-ms-scrollbar-highlight-color":"<color>","-ms-scrollbar-shadow-color":"<color>","-ms-scrollbar-track-color":"<color>","-ms-scroll-chaining":"chained|none","-ms-scroll-limit":"<'-ms-scroll-limit-x-min'> <'-ms-scroll-limit-y-min'> <'-ms-scroll-limit-x-max'> <'-ms-scroll-limit-y-max'>","-ms-scroll-limit-x-max":"auto|<length>","-ms-scroll-limit-x-min":"<length>","-ms-scroll-limit-y-max":"auto|<length>","-ms-scroll-limit-y-min":"<length>","-ms-scroll-rails":"none|railed","-ms-scroll-snap-points-x":"snapInterval( <length-percentage> , <length-percentage> )|snapList( <length-percentage># )","-ms-scroll-snap-points-y":"snapInterval( <length-percentage> , <length-percentage> )|snapList( <length-percentage># )","-ms-scroll-snap-type":"none|proximity|mandatory","-ms-scroll-snap-x":"<'-ms-scroll-snap-type'> <'-ms-scroll-snap-points-x'>","-ms-scroll-snap-y":"<'-ms-scroll-snap-type'> <'-ms-scroll-snap-points-y'>","-ms-scroll-translation":"none|vertical-to-horizontal","-ms-text-autospace":"none|ideograph-alpha|ideograph-numeric|ideograph-parenthesis|ideograph-space","-ms-touch-select":"grippers|none","-ms-user-select":"none|element|text","-ms-wrap-flow":"auto|both|start|end|maximum|clear","-ms-wrap-margin":"<length>","-ms-wrap-through":"wrap|none","-moz-appearance":"none|button|button-arrow-down|button-arrow-next|button-arrow-previous|button-arrow-up|button-bevel|button-focus|caret|checkbox|checkbox-container|checkbox-label|checkmenuitem|dualbutton|groupbox|listbox|listitem|menuarrow|menubar|menucheckbox|menuimage|menuitem|menuitemtext|menulist|menulist-button|menulist-text|menulist-textfield|menupopup|menuradio|menuseparator|meterbar|meterchunk|progressbar|progressbar-vertical|progresschunk|progresschunk-vertical|radio|radio-container|radio-label|radiomenuitem|range|range-thumb|resizer|resizerpanel|scale-horizontal|scalethumbend|scalethumb-horizontal|scalethumbstart|scalethumbtick|scalethumb-vertical|scale-vertical|scrollbarbutton-down|scrollbarbutton-left|scrollbarbutton-right|scrollbarbutton-up|scrollbarthumb-horizontal|scrollbarthumb-vertical|scrollbartrack-horizontal|scrollbartrack-vertical|searchfield|separator|sheet|spinner|spinner-downbutton|spinner-textfield|spinner-upbutton|splitter|statusbar|statusbarpanel|tab|tabpanel|tabpanels|tab-scroll-arrow-back|tab-scroll-arrow-forward|textfield|textfield-multiline|toolbar|toolbarbutton|toolbarbutton-dropdown|toolbargripper|toolbox|tooltip|treeheader|treeheadercell|treeheadersortarrow|treeitem|treeline|treetwisty|treetwistyopen|treeview|-moz-mac-unified-toolbar|-moz-win-borderless-glass|-moz-win-browsertabbar-toolbox|-moz-win-communicationstext|-moz-win-communications-toolbox|-moz-win-exclude-glass|-moz-win-glass|-moz-win-mediatext|-moz-win-media-toolbox|-moz-window-button-box|-moz-window-button-box-maximized|-moz-window-button-close|-moz-window-button-maximize|-moz-window-button-minimize|-moz-window-button-restore|-moz-window-frame-bottom|-moz-window-frame-left|-moz-window-frame-right|-moz-window-titlebar|-moz-window-titlebar-maximized","-moz-binding":"<url>|none","-moz-border-bottom-colors":"<color>+|none","-moz-border-left-colors":"<color>+|none","-moz-border-right-colors":"<color>+|none","-moz-border-top-colors":"<color>+|none","-moz-context-properties":"none|[fill|fill-opacity|stroke|stroke-opacity]#","-moz-float-edge":"border-box|content-box|margin-box|padding-box","-moz-force-broken-image-icon":"0|1","-moz-image-region":"<shape>|auto","-moz-orient":"inline|block|horizontal|vertical","-moz-outline-radius":"<outline-radius>{1,4} [/ <outline-radius>{1,4}]?","-moz-outline-radius-bottomleft":"<outline-radius>","-moz-outline-radius-bottomright":"<outline-radius>","-moz-outline-radius-topleft":"<outline-radius>","-moz-outline-radius-topright":"<outline-radius>","-moz-stack-sizing":"ignore|stretch-to-fit","-moz-text-blink":"none|blink","-moz-user-focus":"ignore|normal|select-after|select-before|select-menu|select-same|select-all|none","-moz-user-input":"auto|none|enabled|disabled","-moz-user-modify":"read-only|read-write|write-only","-moz-window-dragging":"drag|no-drag","-moz-window-shadow":"default|menu|tooltip|sheet|none","-webkit-appearance":"none|button|button-bevel|caps-lock-indicator|caret|checkbox|default-button|inner-spin-button|listbox|listitem|media-controls-background|media-controls-fullscreen-background|media-current-time-display|media-enter-fullscreen-button|media-exit-fullscreen-button|media-fullscreen-button|media-mute-button|media-overlay-play-button|media-play-button|media-seek-back-button|media-seek-forward-button|media-slider|media-sliderthumb|media-time-remaining-display|media-toggle-closed-captions-button|media-volume-slider|media-volume-slider-container|media-volume-sliderthumb|menulist|menulist-button|menulist-text|menulist-textfield|meter|progress-bar|progress-bar-value|push-button|radio|scrollbarbutton-down|scrollbarbutton-left|scrollbarbutton-right|scrollbarbutton-up|scrollbargripper-horizontal|scrollbargripper-vertical|scrollbarthumb-horizontal|scrollbarthumb-vertical|scrollbartrack-horizontal|scrollbartrack-vertical|searchfield|searchfield-cancel-button|searchfield-decoration|searchfield-results-button|searchfield-results-decoration|slider-horizontal|slider-vertical|sliderthumb-horizontal|sliderthumb-vertical|square-button|textarea|textfield|-apple-pay-button","-webkit-border-before":"<'border-width'>||<'border-style'>||<color>","-webkit-border-before-color":"<color>","-webkit-border-before-style":"<'border-style'>","-webkit-border-before-width":"<'border-width'>","-webkit-box-reflect":"[above|below|right|left]? <length>? <image>?","-webkit-line-clamp":"none|<integer>","-webkit-mask":"[<mask-reference>||<position> [/ <bg-size>]?||<repeat-style>||[<box>|border|padding|content|text]||[<box>|border|padding|content]]#","-webkit-mask-attachment":"<attachment>#","-webkit-mask-clip":"[<box>|border|padding|content|text]#","-webkit-mask-composite":"<composite-style>#","-webkit-mask-image":"<mask-reference>#","-webkit-mask-origin":"[<box>|border|padding|content]#","-webkit-mask-position":"<position>#","-webkit-mask-position-x":"[<length-percentage>|left|center|right]#","-webkit-mask-position-y":"[<length-percentage>|top|center|bottom]#","-webkit-mask-repeat":"<repeat-style>#","-webkit-mask-repeat-x":"repeat|no-repeat|space|round","-webkit-mask-repeat-y":"repeat|no-repeat|space|round","-webkit-mask-size":"<bg-size>#","-webkit-overflow-scrolling":"auto|touch","-webkit-tap-highlight-color":"<color>","-webkit-text-fill-color":"<color>","-webkit-text-stroke":"<length>||<color>","-webkit-text-stroke-color":"<color>","-webkit-text-stroke-width":"<length>","-webkit-touch-callout":"default|none","-webkit-user-modify":"read-only|read-write|read-write-plaintext-only","accent-color":"auto|<color>","align-content":"normal|<baseline-position>|<content-distribution>|<overflow-position>? <content-position>","align-items":"normal|stretch|<baseline-position>|[<overflow-position>? <self-position>]","align-self":"auto|normal|stretch|<baseline-position>|<overflow-position>? <self-position>","align-tracks":"[normal|<baseline-position>|<content-distribution>|<overflow-position>? <content-position>]#",all:"initial|inherit|unset|revert|revert-layer","anchor-name":"none|<dashed-ident>#","anchor-scope":"none|all|<dashed-ident>#",animation:"<single-animation>#","animation-composition":"<single-animation-composition>#","animation-delay":"<time>#","animation-direction":"<single-animation-direction>#","animation-duration":"<time>#","animation-fill-mode":"<single-animation-fill-mode>#","animation-iteration-count":"<single-animation-iteration-count>#","animation-name":"[none|<keyframes-name>]#","animation-play-state":"<single-animation-play-state>#","animation-range":"[<'animation-range-start'> <'animation-range-end'>?]#","animation-range-end":"[normal|<length-percentage>|<timeline-range-name> <length-percentage>?]#","animation-range-start":"[normal|<length-percentage>|<timeline-range-name> <length-percentage>?]#","animation-timing-function":"<easing-function>#","animation-timeline":"<single-animation-timeline>#",appearance:"none|auto|textfield|menulist-button|<compat-auto>","aspect-ratio":"auto||<ratio>",azimuth:"<angle>|[[left-side|far-left|left|center-left|center|center-right|right|far-right|right-side]||behind]|leftwards|rightwards","backdrop-filter":"none|<filter-function-list>","backface-visibility":"visible|hidden",background:"[<bg-layer> ,]* <final-bg-layer>","background-attachment":"<attachment>#","background-blend-mode":"<blend-mode>#","background-clip":"<bg-clip>#","background-color":"<color>","background-image":"<bg-image>#","background-origin":"<box>#","background-position":"<bg-position>#","background-position-x":"[center|[[left|right|x-start|x-end]? <length-percentage>?]!]#","background-position-y":"[center|[[top|bottom|y-start|y-end]? <length-percentage>?]!]#","background-repeat":"<repeat-style>#","background-size":"<bg-size>#","block-size":"<'width'>",border:"<line-width>||<line-style>||<color>","border-block":"<'border-top-width'>||<'border-top-style'>||<color>","border-block-color":"<'border-top-color'>{1,2}","border-block-style":"<'border-top-style'>","border-block-width":"<'border-top-width'>","border-block-end":"<'border-top-width'>||<'border-top-style'>||<color>","border-block-end-color":"<'border-top-color'>","border-block-end-style":"<'border-top-style'>","border-block-end-width":"<'border-top-width'>","border-block-start":"<'border-top-width'>||<'border-top-style'>||<color>","border-block-start-color":"<'border-top-color'>","border-block-start-style":"<'border-top-style'>","border-block-start-width":"<'border-top-width'>","border-bottom":"<line-width>||<line-style>||<color>","border-bottom-color":"<'border-top-color'>","border-bottom-left-radius":"<length-percentage>{1,2}","border-bottom-right-radius":"<length-percentage>{1,2}","border-bottom-style":"<line-style>","border-bottom-width":"<line-width>","border-collapse":"collapse|separate","border-color":"<color>{1,4}","border-end-end-radius":"<length-percentage>{1,2}","border-end-start-radius":"<length-percentage>{1,2}","border-image":"<'border-image-source'>||<'border-image-slice'> [/ <'border-image-width'>|/ <'border-image-width'>? / <'border-image-outset'>]?||<'border-image-repeat'>","border-image-outset":"[<length>|<number>]{1,4}","border-image-repeat":"[stretch|repeat|round|space]{1,2}","border-image-slice":"<number-percentage>{1,4}&&fill?","border-image-source":"none|<image>","border-image-width":"[<length-percentage>|<number>|auto]{1,4}","border-inline":"<'border-top-width'>||<'border-top-style'>||<color>","border-inline-end":"<'border-top-width'>||<'border-top-style'>||<color>","border-inline-color":"<'border-top-color'>{1,2}","border-inline-style":"<'border-top-style'>","border-inline-width":"<'border-top-width'>","border-inline-end-color":"<'border-top-color'>","border-inline-end-style":"<'border-top-style'>","border-inline-end-width":"<'border-top-width'>","border-inline-start":"<'border-top-width'>||<'border-top-style'>||<color>","border-inline-start-color":"<'border-top-color'>","border-inline-start-style":"<'border-top-style'>","border-inline-start-width":"<'border-top-width'>","border-left":"<line-width>||<line-style>||<color>","border-left-color":"<color>","border-left-style":"<line-style>","border-left-width":"<line-width>","border-radius":"<length-percentage>{1,4} [/ <length-percentage>{1,4}]?","border-right":"<line-width>||<line-style>||<color>","border-right-color":"<color>","border-right-style":"<line-style>","border-right-width":"<line-width>","border-spacing":"<length> <length>?","border-start-end-radius":"<length-percentage>{1,2}","border-start-start-radius":"<length-percentage>{1,2}","border-style":"<line-style>{1,4}","border-top":"<line-width>||<line-style>||<color>","border-top-color":"<color>","border-top-left-radius":"<length-percentage>{1,2}","border-top-right-radius":"<length-percentage>{1,2}","border-top-style":"<line-style>","border-top-width":"<line-width>","border-width":"<line-width>{1,4}",bottom:"<length>|<percentage>|auto","box-align":"start|center|end|baseline|stretch","box-decoration-break":"slice|clone","box-direction":"normal|reverse|inherit","box-flex":"<number>","box-flex-group":"<integer>","box-lines":"single|multiple","box-ordinal-group":"<integer>","box-orient":"horizontal|vertical|inline-axis|block-axis|inherit","box-pack":"start|center|end|justify","box-shadow":"none|<shadow>#","box-sizing":"content-box|border-box","break-after":"auto|avoid|always|all|avoid-page|page|left|right|recto|verso|avoid-column|column|avoid-region|region","break-before":"auto|avoid|always|all|avoid-page|page|left|right|recto|verso|avoid-column|column|avoid-region|region","break-inside":"auto|avoid|avoid-page|avoid-column|avoid-region","caption-side":"top|bottom|block-start|block-end|inline-start|inline-end",caret:"<'caret-color'>||<'caret-shape'>","caret-color":"auto|<color>","caret-shape":"auto|bar|block|underscore",clear:"none|left|right|both|inline-start|inline-end",clip:"<shape>|auto","clip-path":"<clip-source>|[<basic-shape>||<geometry-box>]|none","clip-rule":"nonzero|evenodd",color:"<color>","color-interpolation-filters":"auto|sRGB|linearRGB","color-scheme":"normal|[light|dark|<custom-ident>]+&&only?","column-count":"<integer>|auto","column-fill":"auto|balance","column-gap":"normal|<length-percentage>","column-rule":"<'column-rule-width'>||<'column-rule-style'>||<'column-rule-color'>","column-rule-color":"<color>","column-rule-style":"<'border-style'>","column-rule-width":"<'border-width'>","column-span":"none|all","column-width":"<length>|auto",columns:"<'column-width'>||<'column-count'>",contain:"none|strict|content|[[size||inline-size]||layout||style||paint]","contain-intrinsic-size":"[auto? [none|<length>]]{1,2}","contain-intrinsic-block-size":"auto? [none|<length>]","contain-intrinsic-height":"auto? [none|<length>]","contain-intrinsic-inline-size":"auto? [none|<length>]","contain-intrinsic-width":"auto? [none|<length>]",container:"<'container-name'> [/ <'container-type'>]?","container-name":"none|<custom-ident>+","container-type":"normal||[size|inline-size]",content:"normal|none|[<content-replacement>|<content-list>] [/ [<string>|<counter>]+]?","content-visibility":"visible|auto|hidden","counter-increment":"[<counter-name> <integer>?]+|none","counter-reset":"[<counter-name> <integer>?|<reversed-counter-name> <integer>?]+|none","counter-set":"[<counter-name> <integer>?]+|none",cursor:"[[<url> [<x> <y>]? ,]* [auto|default|none|context-menu|help|pointer|progress|wait|cell|crosshair|text|vertical-text|alias|copy|move|no-drop|not-allowed|e-resize|n-resize|ne-resize|nw-resize|s-resize|se-resize|sw-resize|w-resize|ew-resize|ns-resize|nesw-resize|nwse-resize|col-resize|row-resize|all-scroll|zoom-in|zoom-out|grab|grabbing|hand|-webkit-grab|-webkit-grabbing|-webkit-zoom-in|-webkit-zoom-out|-moz-grab|-moz-grabbing|-moz-zoom-in|-moz-zoom-out]]",d:"none|path( <string> )",cx:"<length>|<percentage>",cy:"<length>|<percentage>",direction:"ltr|rtl",display:"[<display-outside>||<display-inside>]|<display-listitem>|<display-internal>|<display-box>|<display-legacy>|<-non-standard-display>","dominant-baseline":"auto|use-script|no-change|reset-size|ideographic|alphabetic|hanging|mathematical|central|middle|text-after-edge|text-before-edge","empty-cells":"show|hide","field-sizing":"content|fixed",fill:"<paint>","fill-opacity":"<number-zero-one>","fill-rule":"nonzero|evenodd",filter:"none|<filter-function-list>|<-ms-filter-function-list>",flex:"none|[<'flex-grow'> <'flex-shrink'>?||<'flex-basis'>]","flex-basis":"content|<'width'>","flex-direction":"row|row-reverse|column|column-reverse","flex-flow":"<'flex-direction'>||<'flex-wrap'>","flex-grow":"<number>","flex-shrink":"<number>","flex-wrap":"nowrap|wrap|wrap-reverse",float:"left|right|none|inline-start|inline-end",font:"[[<'font-style'>||<font-variant-css2>||<'font-weight'>||<font-width-css3>]? <'font-size'> [/ <'line-height'>]? <'font-family'>#]|<system-family-name>|<-non-standard-font>","font-family":"[<family-name>|<generic-family>]#","font-feature-settings":"normal|<feature-tag-value>#","font-kerning":"auto|normal|none","font-language-override":"normal|<string>","font-optical-sizing":"auto|none","font-palette":"normal|light|dark|<palette-identifier>","font-variation-settings":"normal|[<string> <number>]#","font-size":"<absolute-size>|<relative-size>|<length-percentage>","font-size-adjust":"none|[ex-height|cap-height|ch-width|ic-width|ic-height]? [from-font|<number>]","font-smooth":"auto|never|always|<absolute-size>|<length>","font-stretch":"<font-stretch-absolute>","font-style":"normal|italic|oblique <angle>?","font-synthesis":"none|[weight||style||small-caps||position]","font-synthesis-position":"auto|none","font-synthesis-small-caps":"auto|none","font-synthesis-style":"auto|none","font-synthesis-weight":"auto|none","font-variant":"normal|none|[<common-lig-values>||<discretionary-lig-values>||<historical-lig-values>||<contextual-alt-values>||stylistic( <feature-value-name> )||historical-forms||styleset( <feature-value-name># )||character-variant( <feature-value-name># )||swash( <feature-value-name> )||ornaments( <feature-value-name> )||annotation( <feature-value-name> )||[small-caps|all-small-caps|petite-caps|all-petite-caps|unicase|titling-caps]||<numeric-figure-values>||<numeric-spacing-values>||<numeric-fraction-values>||ordinal||slashed-zero||<east-asian-variant-values>||<east-asian-width-values>||ruby]","font-variant-alternates":"normal|[stylistic( <feature-value-name> )||historical-forms||styleset( <feature-value-name># )||character-variant( <feature-value-name># )||swash( <feature-value-name> )||ornaments( <feature-value-name> )||annotation( <feature-value-name> )]","font-variant-caps":"normal|small-caps|all-small-caps|petite-caps|all-petite-caps|unicase|titling-caps","font-variant-east-asian":"normal|[<east-asian-variant-values>||<east-asian-width-values>||ruby]","font-variant-emoji":"normal|text|emoji|unicode","font-variant-ligatures":"normal|none|[<common-lig-values>||<discretionary-lig-values>||<historical-lig-values>||<contextual-alt-values>]","font-variant-numeric":"normal|[<numeric-figure-values>||<numeric-spacing-values>||<numeric-fraction-values>||ordinal||slashed-zero]","font-variant-position":"normal|sub|super","font-weight":"<font-weight-absolute>|bolder|lighter","forced-color-adjust":"auto|none",gap:"<'row-gap'> <'column-gap'>?",grid:"<'grid-template'>|<'grid-template-rows'> / [auto-flow&&dense?] <'grid-auto-columns'>?|[auto-flow&&dense?] <'grid-auto-rows'>? / <'grid-template-columns'>","grid-area":"<grid-line> [/ <grid-line>]{0,3}","grid-auto-columns":"<track-size>+","grid-auto-flow":"[row|column]||dense","grid-auto-rows":"<track-size>+","grid-column":"<grid-line> [/ <grid-line>]?","grid-column-end":"<grid-line>","grid-column-gap":"<length-percentage>","grid-column-start":"<grid-line>","grid-gap":"<'grid-row-gap'> <'grid-column-gap'>?","grid-row":"<grid-line> [/ <grid-line>]?","grid-row-end":"<grid-line>","grid-row-gap":"<length-percentage>","grid-row-start":"<grid-line>","grid-template":"none|[<'grid-template-rows'> / <'grid-template-columns'>]|[<line-names>? <string> <track-size>? <line-names>?]+ [/ <explicit-track-list>]?","grid-template-areas":"none|<string>+","grid-template-columns":"none|<track-list>|<auto-track-list>|subgrid <line-name-list>?","grid-template-rows":"none|<track-list>|<auto-track-list>|subgrid <line-name-list>?","hanging-punctuation":"none|[first||[force-end|allow-end]||last]",height:"auto|<length>|<percentage>|min-content|max-content|fit-content|fit-content( <length-percentage> )|stretch|<-non-standard-size>","hyphenate-character":"auto|<string>","hyphenate-limit-chars":"[auto|<integer>]{1,3}",hyphens:"none|manual|auto","image-orientation":"from-image|<angle>|[<angle>? flip]","image-rendering":"auto|crisp-edges|pixelated|optimizeSpeed|optimizeQuality|<-non-standard-image-rendering>","image-resolution":"[from-image||<resolution>]&&snap?","ime-mode":"auto|normal|active|inactive|disabled","initial-letter":"normal|[<number> <integer>?]","initial-letter-align":"[auto|alphabetic|hanging|ideographic]","inline-size":"<'width'>","input-security":"auto|none",inset:"<'top'>{1,4}","inset-block":"<'top'>{1,2}","inset-block-end":"<'top'>","inset-block-start":"<'top'>","inset-inline":"<'top'>{1,2}","inset-inline-end":"<'top'>","inset-inline-start":"<'top'>","interpolate-size":"numeric-only|allow-keywords",isolation:"auto|isolate","justify-content":"normal|<content-distribution>|<overflow-position>? [<content-position>|left|right]","justify-items":"normal|stretch|<baseline-position>|<overflow-position>? [<self-position>|left|right]|legacy|legacy&&[left|right|center]","justify-self":"auto|normal|stretch|<baseline-position>|<overflow-position>? [<self-position>|left|right]","justify-tracks":"[normal|<content-distribution>|<overflow-position>? [<content-position>|left|right]]#",left:"<length>|<percentage>|auto","letter-spacing":"normal|<length-percentage>","line-break":"auto|loose|normal|strict|anywhere","line-clamp":"none|<integer>","line-height":"normal|<number>|<length>|<percentage>","line-height-step":"<length>","list-style":"<'list-style-type'>||<'list-style-position'>||<'list-style-image'>","list-style-image":"<image>|none","list-style-position":"inside|outside","list-style-type":"<counter-style>|<string>|none",margin:"[<length>|<percentage>|auto]{1,4}","margin-block":"<'margin-left'>{1,2}","margin-block-end":"<'margin-left'>","margin-block-start":"<'margin-left'>","margin-bottom":"<length>|<percentage>|auto","margin-inline":"<'margin-left'>{1,2}","margin-inline-end":"<'margin-left'>","margin-inline-start":"<'margin-left'>","margin-left":"<length>|<percentage>|auto","margin-right":"<length>|<percentage>|auto","margin-top":"<length>|<percentage>|auto","margin-trim":"none|in-flow|all",marker:"none|<url>","marker-end":"none|<url>","marker-mid":"none|<url>","marker-start":"none|<url>",mask:"<mask-layer>#","mask-border":"<'mask-border-source'>||<'mask-border-slice'> [/ <'mask-border-width'>? [/ <'mask-border-outset'>]?]?||<'mask-border-repeat'>||<'mask-border-mode'>","mask-border-mode":"luminance|alpha","mask-border-outset":"[<length>|<number>]{1,4}","mask-border-repeat":"[stretch|repeat|round|space]{1,2}","mask-border-slice":"<number-percentage>{1,4} fill?","mask-border-source":"none|<image>","mask-border-width":"[<length-percentage>|<number>|auto]{1,4}","mask-clip":"[<geometry-box>|no-clip]#","mask-composite":"<compositing-operator>#","mask-image":"<mask-reference>#","mask-mode":"<masking-mode>#","mask-origin":"<geometry-box>#","mask-position":"<position>#","mask-repeat":"<repeat-style>#","mask-size":"<bg-size>#","mask-type":"luminance|alpha","masonry-auto-flow":"[pack|next]||[definite-first|ordered]","math-depth":"auto-add|add( <integer> )|<integer>","math-shift":"normal|compact","math-style":"normal|compact","max-block-size":"<'max-width'>","max-height":"none|<length-percentage>|min-content|max-content|fit-content|fit-content( <length-percentage> )|stretch|<-non-standard-size>","max-inline-size":"<'max-width'>","max-lines":"none|<integer>","max-width":"none|<length-percentage>|min-content|max-content|fit-content|fit-content( <length-percentage> )|stretch|<-non-standard-size>","min-block-size":"<'min-width'>","min-height":"auto|<length>|<percentage>|min-content|max-content|fit-content|fit-content( <length-percentage> )|stretch|<-non-standard-size>","min-inline-size":"<'min-width'>","min-width":"auto|<length>|<percentage>|min-content|max-content|fit-content|fit-content( <length-percentage> )|stretch|<-non-standard-size>","mix-blend-mode":"<blend-mode>|plus-lighter","object-fit":"fill|contain|cover|none|scale-down","object-position":"<position>",offset:"[<'offset-position'>? [<'offset-path'> [<'offset-distance'>||<'offset-rotate'>]?]?]! [/ <'offset-anchor'>]?","offset-anchor":"auto|<position>","offset-distance":"<length-percentage>","offset-path":"none|<offset-path>||<coord-box>","offset-position":"normal|auto|<position>","offset-rotate":"[auto|reverse]||<angle>",opacity:"<alpha-value>",order:"<integer>",orphans:"<integer>",outline:"[<'outline-width'>||<'outline-style'>||<'outline-color'>]","outline-color":"auto|<color>","outline-offset":"<length>","outline-style":"auto|<'border-style'>","outline-width":"<line-width>",overflow:"[visible|hidden|clip|scroll|auto]{1,2}|<-non-standard-overflow>","overflow-anchor":"auto|none","overflow-block":"visible|hidden|clip|scroll|auto","overflow-clip-box":"padding-box|content-box","overflow-clip-margin":"<visual-box>||<length [0,∞]>","overflow-inline":"visible|hidden|clip|scroll|auto","overflow-wrap":"normal|break-word|anywhere","overflow-x":"visible|hidden|clip|scroll|auto","overflow-y":"visible|hidden|clip|scroll|auto",overlay:"none|auto","overscroll-behavior":"[contain|none|auto]{1,2}","overscroll-behavior-block":"contain|none|auto","overscroll-behavior-inline":"contain|none|auto","overscroll-behavior-x":"contain|none|auto","overscroll-behavior-y":"contain|none|auto",padding:"[<length>|<percentage>]{1,4}","padding-block":"<'padding-left'>{1,2}","padding-block-end":"<'padding-left'>","padding-block-start":"<'padding-left'>","padding-bottom":"<length>|<percentage>","padding-inline":"<'padding-left'>{1,2}","padding-inline-end":"<'padding-left'>","padding-inline-start":"<'padding-left'>","padding-left":"<length>|<percentage>","padding-right":"<length>|<percentage>","padding-top":"<length>|<percentage>",page:"auto|<custom-ident>","page-break-after":"auto|always|avoid|left|right|recto|verso","page-break-before":"auto|always|avoid|left|right|recto|verso","page-break-inside":"auto|avoid","paint-order":"normal|[fill||stroke||markers]",perspective:"none|<length>","perspective-origin":"<position>","place-content":"<'align-content'> <'justify-content'>?","place-items":"<'align-items'> <'justify-items'>?","place-self":"<'align-self'> <'justify-self'>?","pointer-events":"auto|none|visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|inherit",position:"static|relative|absolute|sticky|fixed|-webkit-sticky","position-anchor":"auto|<anchor-name>","position-area":"none|<position-area>","position-try":"<'position-try-order'>? <'position-try-fallbacks'>","position-try-fallbacks":"none|[[<dashed-ident>||<try-tactic>]|<'position-area'>]#","position-try-order":"normal|<try-size>","position-visibility":"always|[anchors-valid||anchors-visible||no-overflow]","print-color-adjust":"economy|exact",quotes:"none|auto|[<string> <string>]+",r:"<length>|<percentage>",resize:"none|both|horizontal|vertical|block|inline",right:"<length>|<percentage>|auto",rotate:"none|<angle>|[x|y|z|<number>{3}]&&<angle>","row-gap":"normal|<length-percentage>","ruby-align":"start|center|space-between|space-around","ruby-merge":"separate|collapse|auto","ruby-position":"[alternate||[over|under]]|inter-character",rx:"<length>|<percentage>",ry:"<length>|<percentage>",scale:"none|<number>{1,3}","scrollbar-color":"auto|<color>{2}","scrollbar-gutter":"auto|stable&&both-edges?","scrollbar-width":"auto|thin|none","scroll-behavior":"auto|smooth","scroll-margin":"<length>{1,4}","scroll-margin-block":"<length>{1,2}","scroll-margin-block-start":"<length>","scroll-margin-block-end":"<length>","scroll-margin-bottom":"<length>","scroll-margin-inline":"<length>{1,2}","scroll-margin-inline-start":"<length>","scroll-margin-inline-end":"<length>","scroll-margin-left":"<length>","scroll-margin-right":"<length>","scroll-margin-top":"<length>","scroll-padding":"[auto|<length-percentage>]{1,4}","scroll-padding-block":"[auto|<length-percentage>]{1,2}","scroll-padding-block-start":"auto|<length-percentage>","scroll-padding-block-end":"auto|<length-percentage>","scroll-padding-bottom":"auto|<length-percentage>","scroll-padding-inline":"[auto|<length-percentage>]{1,2}","scroll-padding-inline-start":"auto|<length-percentage>","scroll-padding-inline-end":"auto|<length-percentage>","scroll-padding-left":"auto|<length-percentage>","scroll-padding-right":"auto|<length-percentage>","scroll-padding-top":"auto|<length-percentage>","scroll-snap-align":"[none|start|end|center]{1,2}","scroll-snap-coordinate":"none|<position>#","scroll-snap-destination":"<position>","scroll-snap-points-x":"none|repeat( <length-percentage> )","scroll-snap-points-y":"none|repeat( <length-percentage> )","scroll-snap-stop":"normal|always","scroll-snap-type":"none|[x|y|block|inline|both] [mandatory|proximity]?","scroll-snap-type-x":"none|mandatory|proximity","scroll-snap-type-y":"none|mandatory|proximity","scroll-timeline":"[<'scroll-timeline-name'>||<'scroll-timeline-axis'>]#","scroll-timeline-axis":"[block|inline|x|y]#","scroll-timeline-name":"[none|<dashed-ident>]#","shape-image-threshold":"<alpha-value>","shape-margin":"<length-percentage>","shape-outside":"none|[<shape-box>||<basic-shape>]|<image>","shape-rendering":"auto|optimizeSpeed|crispEdges|geometricPrecision",stroke:"<paint>","stroke-dasharray":"none|[<svg-length>+]#","stroke-dashoffset":"<svg-length>","stroke-linecap":"butt|round|square","stroke-linejoin":"miter|round|bevel","stroke-miterlimit":"<number-one-or-greater>","stroke-opacity":"<'opacity'>","stroke-width":"<svg-length>","tab-size":"<integer>|<length>","table-layout":"auto|fixed","text-align":"start|end|left|right|center|justify|match-parent","text-align-last":"auto|start|end|left|right|center|justify","text-anchor":"start|middle|end","text-combine-upright":"none|all|[digits <integer>?]","text-decoration":"<'text-decoration-line'>||<'text-decoration-style'>||<'text-decoration-color'>||<'text-decoration-thickness'>","text-decoration-color":"<color>","text-decoration-line":"none|[underline||overline||line-through||blink]|spelling-error|grammar-error","text-decoration-skip":"none|[objects||[spaces|[leading-spaces||trailing-spaces]]||edges||box-decoration]","text-decoration-skip-ink":"auto|all|none","text-decoration-style":"solid|double|dotted|dashed|wavy","text-decoration-thickness":"auto|from-font|<length>|<percentage>","text-emphasis":"<'text-emphasis-style'>||<'text-emphasis-color'>","text-emphasis-color":"<color>","text-emphasis-position":"auto|[over|under]&&[right|left]?","text-emphasis-style":"none|[[filled|open]||[dot|circle|double-circle|triangle|sesame]]|<string>","text-indent":"<length-percentage>&&hanging?&&each-line?","text-justify":"auto|inter-character|inter-word|none","text-orientation":"mixed|upright|sideways","text-overflow":"[clip|ellipsis|<string>]{1,2}","text-rendering":"auto|optimizeSpeed|optimizeLegibility|geometricPrecision","text-shadow":"none|<shadow-t>#","text-size-adjust":"none|auto|<percentage>","text-spacing-trim":"space-all|normal|space-first|trim-start|trim-both|trim-all|auto","text-transform":"none|capitalize|uppercase|lowercase|full-width|full-size-kana","text-underline-offset":"auto|<length>|<percentage>","text-underline-position":"auto|from-font|[under||[left|right]]","text-wrap":"<'text-wrap-mode'>||<'text-wrap-style'>","text-wrap-mode":"auto|wrap|nowrap","text-wrap-style":"auto|balance|stable|pretty","timeline-scope":"none|<dashed-ident>#",top:"<length>|<percentage>|auto","touch-action":"auto|none|[[pan-x|pan-left|pan-right]||[pan-y|pan-up|pan-down]||pinch-zoom]|manipulation",transform:"none|<transform-list>","transform-box":"content-box|border-box|fill-box|stroke-box|view-box","transform-origin":"[<length-percentage>|left|center|right|top|bottom]|[[<length-percentage>|left|center|right]&&[<length-percentage>|top|center|bottom]] <length>?","transform-style":"flat|preserve-3d",transition:"<single-transition>#","transition-behavior":"<transition-behavior-value>#","transition-delay":"<time>#","transition-duration":"<time>#","transition-property":"none|<single-transition-property>#","transition-timing-function":"<easing-function>#",translate:"none|<length-percentage> [<length-percentage> <length>?]?","unicode-bidi":"normal|embed|isolate|bidi-override|isolate-override|plaintext|-moz-isolate|-moz-isolate-override|-moz-plaintext|-webkit-isolate|-webkit-isolate-override|-webkit-plaintext","user-select":"auto|text|none|contain|all","vector-effect":"none|non-scaling-stroke|non-scaling-size|non-rotation|fixed-position","vertical-align":"baseline|sub|super|text-top|text-bottom|middle|top|bottom|<percentage>|<length>","view-timeline":"[<'view-timeline-name'> <'view-timeline-axis'>?]#","view-timeline-axis":"[block|inline|x|y]#","view-timeline-inset":"[[auto|<length-percentage>]{1,2}]#","view-timeline-name":"none|<dashed-ident>#","view-transition-name":"none|<custom-ident>",visibility:"visible|hidden|collapse","white-space":"normal|pre|nowrap|pre-wrap|pre-line|break-spaces|[<'white-space-collapse'>||<'text-wrap'>||<'white-space-trim'>]","white-space-collapse":"collapse|discard|preserve|preserve-breaks|preserve-spaces|break-spaces",widows:"<integer>",width:"auto|<length>|<percentage>|min-content|max-content|fit-content|fit-content( <length-percentage> )|stretch|<-non-standard-size>","will-change":"auto|<animateable-feature>#","word-break":"normal|break-all|keep-all|break-word|auto-phrase","word-spacing":"normal|<length>","word-wrap":"normal|break-word","writing-mode":"horizontal-tb|vertical-rl|vertical-lr|sideways-rl|sideways-lr|<svg-writing-mode>",x:"<length>|<percentage>",y:"<length>|<percentage>","z-index":"auto|<integer>",zoom:"normal|reset|<number>|<percentage>","-moz-background-clip":"padding|border","-moz-border-radius-bottomleft":"<'border-bottom-left-radius'>","-moz-border-radius-bottomright":"<'border-bottom-right-radius'>","-moz-border-radius-topleft":"<'border-top-left-radius'>","-moz-border-radius-topright":"<'border-bottom-right-radius'>","-moz-control-character-visibility":"visible|hidden","-moz-osx-font-smoothing":"auto|grayscale","-moz-user-select":"none|text|all|-moz-none","-ms-flex-align":"start|end|center|baseline|stretch","-ms-flex-item-align":"auto|start|end|center|baseline|stretch","-ms-flex-line-pack":"start|end|center|justify|distribute|stretch","-ms-flex-negative":"<'flex-shrink'>","-ms-flex-pack":"start|end|center|justify|distribute","-ms-flex-order":"<integer>","-ms-flex-positive":"<'flex-grow'>","-ms-flex-preferred-size":"<'flex-basis'>","-ms-interpolation-mode":"nearest-neighbor|bicubic","-ms-grid-column-align":"start|end|center|stretch","-ms-grid-row-align":"start|end|center|stretch","-ms-hyphenate-limit-last":"none|always|column|page|spread","-webkit-background-clip":"[<box>|border|padding|content|text]#","-webkit-column-break-after":"always|auto|avoid","-webkit-column-break-before":"always|auto|avoid","-webkit-column-break-inside":"always|auto|avoid","-webkit-font-smoothing":"auto|none|antialiased|subpixel-antialiased","-webkit-mask-box-image":"[<url>|<gradient>|none] [<length-percentage>{4} <-webkit-mask-box-repeat>{2}]?","-webkit-print-color-adjust":"economy|exact","-webkit-text-security":"none|circle|disc|square","-webkit-user-drag":"none|element|auto","-webkit-user-select":"auto|none|text|all","alignment-baseline":"auto|baseline|before-edge|text-before-edge|middle|central|after-edge|text-after-edge|ideographic|alphabetic|hanging|mathematical","baseline-shift":"baseline|sub|super|<svg-length>",behavior:"<url>+",cue:"<'cue-before'> <'cue-after'>?","cue-after":"<url> <decibel>?|none","cue-before":"<url> <decibel>?|none","glyph-orientation-horizontal":"<angle>","glyph-orientation-vertical":"<angle>",kerning:"auto|<svg-length>",pause:"<'pause-before'> <'pause-after'>?","pause-after":"<time>|none|x-weak|weak|medium|strong|x-strong","pause-before":"<time>|none|x-weak|weak|medium|strong|x-strong",rest:"<'rest-before'> <'rest-after'>?","rest-after":"<time>|none|x-weak|weak|medium|strong|x-strong","rest-before":"<time>|none|x-weak|weak|medium|strong|x-strong",src:"[<url> [format( <string># )]?|local( <family-name> )]#",speak:"auto|never|always","speak-as":"normal|spell-out||digits||[literal-punctuation|no-punctuation]","unicode-range":"<urange>#","voice-balance":"<number>|left|center|right|leftwards|rightwards","voice-duration":"auto|<time>","voice-family":"[[<family-name>|<generic-voice>] ,]* [<family-name>|<generic-voice>]|preserve","voice-pitch":"<frequency>&&absolute|[[x-low|low|medium|high|x-high]||[<frequency>|<semitones>|<percentage>]]","voice-range":"<frequency>&&absolute|[[x-low|low|medium|high|x-high]||[<frequency>|<semitones>|<percentage>]]","voice-rate":"[normal|x-slow|slow|medium|fast|x-fast]||<percentage>","voice-stress":"normal|strong|moderate|none|reduced","voice-volume":"silent|[[x-soft|soft|medium|loud|x-loud]||<decibel>]","white-space-trim":"none|discard-before||discard-after||discard-inner"},atrules:{charset:{prelude:"<string>",descriptors:null},"counter-style":{prelude:"<counter-style-name>",descriptors:{"additive-symbols":"[<integer>&&<symbol>]#",fallback:"<counter-style-name>",negative:"<symbol> <symbol>?",pad:"<integer>&&<symbol>",prefix:"<symbol>",range:"[[<integer>|infinite]{2}]#|auto","speak-as":"auto|bullets|numbers|words|spell-out|<counter-style-name>",suffix:"<symbol>",symbols:"<symbol>+",system:"cyclic|numeric|alphabetic|symbolic|additive|[fixed <integer>?]|[extends <counter-style-name>]"}},document:{prelude:"[<url>|url-prefix( <string> )|domain( <string> )|media-document( <string> )|regexp( <string> )]#",descriptors:null},"font-palette-values":{prelude:"<dashed-ident>",descriptors:{"base-palette":"light|dark|<integer [0,∞]>","font-family":"<family-name>#","override-colors":"[<integer [0,∞]> <absolute-color-base>]#"}},"font-face":{prelude:null,descriptors:{"ascent-override":"normal|<percentage>","descent-override":"normal|<percentage>","font-display":"[auto|block|swap|fallback|optional]","font-family":"<family-name>","font-feature-settings":"normal|<feature-tag-value>#","font-variation-settings":"normal|[<string> <number>]#","font-stretch":"<font-stretch-absolute>{1,2}","font-style":"normal|italic|oblique <angle>{0,2}","font-weight":"<font-weight-absolute>{1,2}","line-gap-override":"normal|<percentage>","size-adjust":"<percentage>",src:"[<url> [format( <string># )]?|local( <family-name> )]#","unicode-range":"<urange>#"}},"font-feature-values":{prelude:"<family-name>#",descriptors:null},import:{prelude:"[<string>|<url>] [layer|layer( <layer-name> )]? [supports( [<supports-condition>|<declaration>] )]? <media-query-list>?",descriptors:null},keyframes:{prelude:"<keyframes-name>",descriptors:null},layer:{prelude:"[<layer-name>#|<layer-name>?]",descriptors:null},media:{prelude:"<media-query-list>",descriptors:null},namespace:{prelude:"<namespace-prefix>? [<string>|<url>]",descriptors:null},page:{prelude:"<page-selector-list>",descriptors:{bleed:"auto|<length>",marks:"none|[crop||cross]","page-orientation":"upright|rotate-left|rotate-right",size:"<length>{1,2}|auto|[<page-size>||[portrait|landscape]]"}},"position-try":{prelude:"<dashed-ident>",descriptors:{top:"<'top'>",left:"<'left'>",bottom:"<'bottom'>",right:"<'right'>","inset-block-start":"<'inset-block-start'>","inset-block-end":"<'inset-block-end'>","inset-inline-start":"<'inset-inline-start'>","inset-inline-end":"<'inset-inline-end'>","inset-block":"<'inset-block'>","inset-inline":"<'inset-inline'>",inset:"<'inset'>","margin-top":"<'margin-top'>","margin-left":"<'margin-left'>","margin-bottom":"<'margin-bottom'>","margin-right":"<'margin-right'>","margin-block-start":"<'margin-block-start'>","margin-block-end":"<'margin-block-end'>","margin-inline-start":"<'margin-inline-start'>","margin-inline-end":"<'margin-inline-end'>",margin:"<'margin'>","margin-block":"<'margin-block'>","margin-inline":"<'margin-inline'>",width:"<'width'>",height:"<'height'>","min-width":"<'min-width'>","min-height":"<'min-height'>","max-width":"<'max-width'>","max-height":"<'max-height'>","block-size":"<'block-size'>","inline-size":"<'inline-size'>","min-block-size":"<'min-block-size'>","min-inline-size":"<'min-inline-size'>","max-block-size":"<'max-block-size'>","max-inline-size":"<'max-inline-size'>","align-self":"<'align-self'>|anchor-center","justify-self":"<'justify-self'>|anchor-center"}},property:{prelude:"<custom-property-name>",descriptors:{syntax:"<string>",inherits:"true|false","initial-value":"<declaration-value>?"}},scope:{prelude:"[( <scope-start> )]? [to ( <scope-end> )]?",descriptors:null},"starting-style":{prelude:null,descriptors:null},supports:{prelude:"<supports-condition>",descriptors:null},container:{prelude:"[<container-name>]? <container-condition>",descriptors:null},nest:{prelude:"<complex-selector-list>",descriptors:null}}}
const PLUSSIGN$f=0x002B
const HYPHENMINUS$9=0x002D
const N$5=0x006E
const DISALLOW_SIGN$2=true
const ALLOW_SIGN$2=false
function checkInteger$2(offset,disallowSign){let pos=this.tokenStart+offset
const code=this.charCodeAt(pos)
if(code===PLUSSIGN$f||code===HYPHENMINUS$9){disallowSign&&this.error("Number sign is not allowed")
pos++}for(;pos<this.tokenEnd;pos++)isDigit$2(this.charCodeAt(pos))||this.error("Integer is expected",pos)}function checkTokenIsInteger$1(disallowSign){return checkInteger$2.call(this,0,disallowSign)}function expectCharCode$1(offset,code){if(!this.cmpChar(this.tokenStart+offset,code)){let msg=""
switch(code){case N$5:msg="N is expected"
break
case HYPHENMINUS$9:msg="HyphenMinus is expected"
break}this.error(msg,this.tokenStart+offset)}}function consumeB$2(){let offset=0
let sign=0
let type=this.tokenType
while(type===WhiteSpace$3||type===Comment$3)type=this.lookupType(++offset)
if(type!==Number$5){if(!this.isDelim(PLUSSIGN$f,offset)&&!this.isDelim(HYPHENMINUS$9,offset))return null
sign=this.isDelim(PLUSSIGN$f,offset)?PLUSSIGN$f:HYPHENMINUS$9
do{type=this.lookupType(++offset)}while(type===WhiteSpace$3||type===Comment$3)
if(type!==Number$5){this.skip(offset)
checkTokenIsInteger$1.call(this,DISALLOW_SIGN$2)}}offset>0&&this.skip(offset)
if(sign===0){type=this.charCodeAt(this.tokenStart)
type!==PLUSSIGN$f&&type!==HYPHENMINUS$9&&this.error("Number sign is expected")}checkTokenIsInteger$1.call(this,sign!==0)
return sign===HYPHENMINUS$9?"-"+this.consume(Number$5):this.consume(Number$5)}const name$2a="AnPlusB"
const structure$1o={a:[String,null],b:[String,null]}
function parse$1t(){const start=this.tokenStart
let a=null
let b=null
if(this.tokenType===Number$5){checkTokenIsInteger$1.call(this,ALLOW_SIGN$2)
b=this.consume(Number$5)}else if(this.tokenType===Ident$1&&this.cmpChar(this.tokenStart,HYPHENMINUS$9)){a="-1"
expectCharCode$1.call(this,1,N$5)
switch(this.tokenEnd-this.tokenStart){case 2:this.next()
b=consumeB$2.call(this)
break
case 3:expectCharCode$1.call(this,2,HYPHENMINUS$9)
this.next()
this.skipSC()
checkTokenIsInteger$1.call(this,DISALLOW_SIGN$2)
b="-"+this.consume(Number$5)
break
default:expectCharCode$1.call(this,2,HYPHENMINUS$9)
checkInteger$2.call(this,3,DISALLOW_SIGN$2)
this.next()
b=this.substrToCursor(start+2)}}else if(this.tokenType===Ident$1||this.isDelim(PLUSSIGN$f)&&this.lookupType(1)===Ident$1){let sign=0
a="1"
if(this.isDelim(PLUSSIGN$f)){sign=1
this.next()}expectCharCode$1.call(this,0,N$5)
switch(this.tokenEnd-this.tokenStart){case 1:this.next()
b=consumeB$2.call(this)
break
case 2:expectCharCode$1.call(this,1,HYPHENMINUS$9)
this.next()
this.skipSC()
checkTokenIsInteger$1.call(this,DISALLOW_SIGN$2)
b="-"+this.consume(Number$5)
break
default:expectCharCode$1.call(this,1,HYPHENMINUS$9)
checkInteger$2.call(this,2,DISALLOW_SIGN$2)
this.next()
b=this.substrToCursor(start+sign+1)}}else if(this.tokenType===Dimension$3){const code=this.charCodeAt(this.tokenStart)
const sign=code===PLUSSIGN$f||code===HYPHENMINUS$9
let i=this.tokenStart+sign
for(;i<this.tokenEnd;i++)if(!isDigit$2(this.charCodeAt(i)))break
i===this.tokenStart+sign&&this.error("Integer is expected",this.tokenStart+sign)
expectCharCode$1.call(this,i-this.tokenStart,N$5)
a=this.substring(start,i)
if(i+1===this.tokenEnd){this.next()
b=consumeB$2.call(this)}else{expectCharCode$1.call(this,i-this.tokenStart+1,HYPHENMINUS$9)
if(i+2===this.tokenEnd){this.next()
this.skipSC()
checkTokenIsInteger$1.call(this,DISALLOW_SIGN$2)
b="-"+this.consume(Number$5)}else{checkInteger$2.call(this,i-this.tokenStart+2,DISALLOW_SIGN$2)
this.next()
b=this.substrToCursor(i+1)}}}else this.error()
a!==null&&a.charCodeAt(0)===PLUSSIGN$f&&(a=a.substr(1))
b!==null&&b.charCodeAt(0)===PLUSSIGN$f&&(b=b.substr(1))
return{type:"AnPlusB",loc:this.getLocation(start,this.tokenStart),a:a,b:b}}function generate$1t(node){if(node.a){const a=(node.a==="+1"||node.a==="1"?"n":node.a==="-1"&&"-n")||node.a+"n"
if(node.b){const b=node.b[0]==="-"||node.b[0]==="+"?node.b:"+"+node.b
this.tokenize(a+b)}else this.tokenize(a)}else this.tokenize(node.b)}var AnPlusB$1=Object.freeze({__proto__:null,generate:generate$1t,name:name$2a,parse:parse$1t,structure:structure$1o})
function consumeRaw$a(){return this.Raw(this.consumeUntilLeftCurlyBracketOrSemicolon,true)}function isDeclarationBlockAtrule$1(){for(let offset=1,type;type=this.lookupType(offset);offset++){if(type===RightCurlyBracket$1)return true
if(type===LeftCurlyBracket$1||type===AtKeyword$1)return false}return false}const name$29="Atrule"
const walkContext$j="atrule"
const structure$1n={name:String,prelude:["AtrulePrelude","Raw",null],block:["Block",null]}
function parse$1s(isDeclaration=false){const start=this.tokenStart
let name
let nameLowerCase
let prelude=null
let block=null
this.eat(AtKeyword$1)
name=this.substrToCursor(start+1)
nameLowerCase=name.toLowerCase()
this.skipSC()
if(this.eof===false&&this.tokenType!==LeftCurlyBracket$1&&this.tokenType!==Semicolon$1){prelude=this.parseAtrulePrelude?this.parseWithFallback(this.AtrulePrelude.bind(this,name,isDeclaration),consumeRaw$a):consumeRaw$a.call(this,this.tokenIndex)
this.skipSC()}switch(this.tokenType){case Semicolon$1:this.next()
break
case LeftCurlyBracket$1:block=hasOwnProperty.call(this.atrule,nameLowerCase)&&typeof this.atrule[nameLowerCase].block==="function"?this.atrule[nameLowerCase].block.call(this,isDeclaration):this.Block(isDeclarationBlockAtrule$1.call(this))
break}return{type:"Atrule",loc:this.getLocation(start,this.tokenStart),name:name,prelude:prelude,block:block}}function generate$1s(node){this.token(AtKeyword$1,"@"+node.name)
node.prelude!==null&&this.node(node.prelude)
node.block?this.node(node.block):this.token(Semicolon$1,";")}var Atrule$2=Object.freeze({__proto__:null,generate:generate$1s,name:name$29,parse:parse$1s,structure:structure$1n,walkContext:walkContext$j})
const name$28="AtrulePrelude"
const walkContext$i="atrulePrelude"
const structure$1m={children:[[]]}
function parse$1r(name){let children=null
name!==null&&(name=name.toLowerCase())
this.skipSC()
children=hasOwnProperty.call(this.atrule,name)&&typeof this.atrule[name].prelude==="function"?this.atrule[name].prelude.call(this):this.readSequence(this.scope.AtrulePrelude)
this.skipSC()
this.eof!==true&&this.tokenType!==LeftCurlyBracket$1&&this.tokenType!==Semicolon$1&&this.error("Semicolon or block is expected")
return{type:"AtrulePrelude",loc:this.getLocationFromList(children),children:children}}function generate$1r(node){this.children(node)}var AtrulePrelude$1=Object.freeze({__proto__:null,generate:generate$1r,name:name$28,parse:parse$1r,structure:structure$1m,walkContext:walkContext$i})
const DOLLARSIGN$3=0x0024
const ASTERISK$c=0x002A
const EQUALSSIGN$2=0x003D
const CIRCUMFLEXACCENT$1=0x005E
const VERTICALLINE$6=0x007C
const TILDE$5=0x007E
function getAttributeName$1(){this.eof&&this.error("Unexpected end of input")
const start=this.tokenStart
let expectIdent=false
if(this.isDelim(ASTERISK$c)){expectIdent=true
this.next()}else this.isDelim(VERTICALLINE$6)||this.eat(Ident$1)
if(this.isDelim(VERTICALLINE$6))if(this.charCodeAt(this.tokenStart+1)!==EQUALSSIGN$2){this.next()
this.eat(Ident$1)}else expectIdent&&this.error("Identifier is expected",this.tokenEnd)
else expectIdent&&this.error("Vertical line is expected")
return{type:"Identifier",loc:this.getLocation(start,this.tokenStart),name:this.substrToCursor(start)}}function getOperator$1(){const start=this.tokenStart
const code=this.charCodeAt(start)
code!==EQUALSSIGN$2&&code!==TILDE$5&&code!==CIRCUMFLEXACCENT$1&&code!==DOLLARSIGN$3&&code!==ASTERISK$c&&code!==VERTICALLINE$6&&this.error("Attribute selector (=, ~=, ^=, $=, *=, |=) is expected")
this.next()
if(code!==EQUALSSIGN$2){this.isDelim(EQUALSSIGN$2)||this.error("Equal sign is expected")
this.next()}return this.substrToCursor(start)}const name$27="AttributeSelector"
const structure$1l={name:"Identifier",matcher:[String,null],value:["String","Identifier",null],flags:[String,null]}
function parse$1q(){const start=this.tokenStart
let name
let matcher=null
let value=null
let flags=null
this.eat(LeftSquareBracket$1)
this.skipSC()
name=getAttributeName$1.call(this)
this.skipSC()
if(this.tokenType!==RightSquareBracket$1){if(this.tokenType!==Ident$1){matcher=getOperator$1.call(this)
this.skipSC()
value=this.tokenType===String$4?this.String():this.Identifier()
this.skipSC()}if(this.tokenType===Ident$1){flags=this.consume(Ident$1)
this.skipSC()}}this.eat(RightSquareBracket$1)
return{type:"AttributeSelector",loc:this.getLocation(start,this.tokenStart),name:name,matcher:matcher,value:value,flags:flags}}function generate$1q(node){this.token(Delim$1,"[")
this.node(node.name)
if(node.matcher!==null){this.tokenize(node.matcher)
this.node(node.value)}node.flags!==null&&this.token(Ident$1,node.flags)
this.token(Delim$1,"]")}var AttributeSelector$2=Object.freeze({__proto__:null,generate:generate$1q,name:name$27,parse:parse$1q,structure:structure$1l})
const AMPERSAND$6=0x0026
function consumeRaw$9(){return this.Raw(null,true)}function consumeRule$1(){return this.parseWithFallback(this.Rule,consumeRaw$9)}function consumeRawDeclaration$1(){return this.Raw(this.consumeUntilSemicolonIncluded,true)}function consumeDeclaration$1(){if(this.tokenType===Semicolon$1)return consumeRawDeclaration$1.call(this,this.tokenIndex)
const node=this.parseWithFallback(this.Declaration,consumeRawDeclaration$1)
this.tokenType===Semicolon$1&&this.next()
return node}const name$26="Block"
const walkContext$h="block"
const structure$1k={children:[["Atrule","Rule","Declaration"]]}
function parse$1p(isStyleBlock){const consumer=isStyleBlock?consumeDeclaration$1:consumeRule$1
const start=this.tokenStart
let children=this.createList()
this.eat(LeftCurlyBracket$1)
scan:while(!this.eof)switch(this.tokenType){case RightCurlyBracket$1:break scan
case WhiteSpace$3:case Comment$3:this.next()
break
case AtKeyword$1:children.push(this.parseWithFallback(this.Atrule.bind(this,isStyleBlock),consumeRaw$9))
break
default:isStyleBlock&&this.isDelim(AMPERSAND$6)?children.push(consumeRule$1.call(this)):children.push(consumer.call(this))}this.eof||this.eat(RightCurlyBracket$1)
return{type:"Block",loc:this.getLocation(start,this.tokenStart),children:children}}function generate$1p(node){this.token(LeftCurlyBracket$1,"{")
this.children(node,(prev=>{prev.type==="Declaration"&&this.token(Semicolon$1,";")}))
this.token(RightCurlyBracket$1,"}")}var Block$1=Object.freeze({__proto__:null,generate:generate$1p,name:name$26,parse:parse$1p,structure:structure$1k,walkContext:walkContext$h})
const name$25="Brackets"
const structure$1j={children:[[]]}
function parse$1o(readSequence,recognizer){const start=this.tokenStart
let children=null
this.eat(LeftSquareBracket$1)
children=readSequence.call(this,recognizer)
this.eof||this.eat(RightSquareBracket$1)
return{type:"Brackets",loc:this.getLocation(start,this.tokenStart),children:children}}function generate$1o(node){this.token(Delim$1,"[")
this.children(node)
this.token(Delim$1,"]")}var Brackets$1=Object.freeze({__proto__:null,generate:generate$1o,name:name$25,parse:parse$1o,structure:structure$1j})
const name$24="CDC"
const structure$1i=[]
function parse$1n(){const start=this.tokenStart
this.eat(CDC$3)
return{type:"CDC",loc:this.getLocation(start,this.tokenStart)}}function generate$1n(){this.token(CDC$3,"--\x3e")}var CDC$2=Object.freeze({__proto__:null,generate:generate$1n,name:name$24,parse:parse$1n,structure:structure$1i})
const name$23="CDO"
const structure$1h=[]
function parse$1m(){const start=this.tokenStart
this.eat(CDO$3)
return{type:"CDO",loc:this.getLocation(start,this.tokenStart)}}function generate$1m(){this.token(CDO$3,"\x3c!--")}var CDO$2=Object.freeze({__proto__:null,generate:generate$1m,name:name$23,parse:parse$1m,structure:structure$1h})
const FULLSTOP$5=0x002E
const name$22="ClassSelector"
const structure$1g={name:String}
function parse$1l(){this.eatDelim(FULLSTOP$5)
return{type:"ClassSelector",loc:this.getLocation(this.tokenStart-1,this.tokenEnd),name:this.consume(Ident$1)}}function generate$1l(node){this.token(Delim$1,".")
this.token(Ident$1,node.name)}var ClassSelector$1=Object.freeze({__proto__:null,generate:generate$1l,name:name$22,parse:parse$1l,structure:structure$1g})
const PLUSSIGN$e=0x002B
const SOLIDUS$d=0x002F
const GREATERTHANSIGN$5=0x003E
const TILDE$4=0x007E
const name$21="Combinator"
const structure$1f={name:String}
function parse$1k(){const start=this.tokenStart
let name
switch(this.tokenType){case WhiteSpace$3:name=" "
break
case Delim$1:switch(this.charCodeAt(this.tokenStart)){case GREATERTHANSIGN$5:case PLUSSIGN$e:case TILDE$4:this.next()
break
case SOLIDUS$d:this.next()
this.eatIdent("deep")
this.eatDelim(SOLIDUS$d)
break
default:this.error("Combinator is expected")}name=this.substrToCursor(start)
break}return{type:"Combinator",loc:this.getLocation(start,this.tokenStart),name:name}}function generate$1k(node){this.tokenize(node.name)}var Combinator$1=Object.freeze({__proto__:null,generate:generate$1k,name:name$21,parse:parse$1k,structure:structure$1f})
const ASTERISK$b=0x002A
const SOLIDUS$c=0x002F
const name$20="Comment"
const structure$1e={value:String}
function parse$1j(){const start=this.tokenStart
let end=this.tokenEnd
this.eat(Comment$3)
end-start+2>=2&&this.charCodeAt(end-2)===ASTERISK$b&&this.charCodeAt(end-1)===SOLIDUS$c&&(end-=2)
return{type:"Comment",loc:this.getLocation(start,this.tokenStart),value:this.substring(start+2,end)}}function generate$1j(node){this.token(Comment$3,"/*"+node.value+"*/")}var Comment$2=Object.freeze({__proto__:null,generate:generate$1j,name:name$20,parse:parse$1j,structure:structure$1e})
const likelyFeatureToken=new Set([Colon$1,RightParenthesis$1,EOF$3])
const name$1$="Condition"
const structure$1d={kind:String,children:[["Identifier","Feature","FeatureFunction","FeatureRange","SupportsDeclaration"]]}
function featureOrRange(kind){if(this.lookupTypeNonSC(1)===Ident$1&&likelyFeatureToken.has(this.lookupTypeNonSC(2)))return this.Feature(kind)
return this.FeatureRange(kind)}const parentheses$1={media:featureOrRange,container:featureOrRange,supports(){return this.SupportsDeclaration()}}
function parse$1i(kind="media"){const children=this.createList()
scan:while(!this.eof)switch(this.tokenType){case Comment$3:case WhiteSpace$3:this.next()
continue
case Ident$1:children.push(this.Identifier())
break
case LeftParenthesis$1:{let term=this.parseWithFallback((()=>parentheses$1[kind].call(this,kind)),(()=>null))
term||(term=this.parseWithFallback((()=>{this.eat(LeftParenthesis$1)
const res=this.Condition(kind)
this.eat(RightParenthesis$1)
return res}),(()=>this.GeneralEnclosed(kind))))
children.push(term)
break}case Function$3:{let term=this.parseWithFallback((()=>this.FeatureFunction(kind)),(()=>null))
term||(term=this.GeneralEnclosed(kind))
children.push(term)
break}default:break scan}children.isEmpty&&this.error("Condition is expected")
return{type:"Condition",loc:this.getLocationFromList(children),kind:kind,children:children}}function generate$1i(node){node.children.forEach((child=>{if(child.type==="Condition"){this.token(LeftParenthesis$1,"(")
this.node(child)
this.token(RightParenthesis$1,")")}else this.node(child)}))}var Condition=Object.freeze({__proto__:null,generate:generate$1i,name:name$1$,parse:parse$1i,structure:structure$1d})
const EXCLAMATIONMARK$5=0x0021
const NUMBERSIGN$7=0x0023
const DOLLARSIGN$2=0x0024
const AMPERSAND$5=0x0026
const ASTERISK$a=0x002A
const PLUSSIGN$d=0x002B
const SOLIDUS$b=0x002F
function consumeValueRaw$1(){return this.Raw(this.consumeUntilExclamationMarkOrSemicolon,true)}function consumeCustomPropertyRaw$1(){return this.Raw(this.consumeUntilExclamationMarkOrSemicolon,false)}function consumeValue$1(){const startValueToken=this.tokenIndex
const value=this.Value()
value.type!=="Raw"&&this.eof===false&&this.tokenType!==Semicolon$1&&this.isDelim(EXCLAMATIONMARK$5)===false&&this.isBalanceEdge(startValueToken)===false&&this.error()
return value}const name$1_="Declaration"
const walkContext$g="declaration"
const structure$1c={important:[Boolean,String],property:String,value:["Value","Raw"]}
function parse$1h(){const start=this.tokenStart
const startToken=this.tokenIndex
const property=readProperty$2.call(this)
const customProperty=isCustomProperty$1(property)
const parseValue=customProperty?this.parseCustomProperty:this.parseValue
const consumeRaw=customProperty?consumeCustomPropertyRaw$1:consumeValueRaw$1
let important=false
let value
this.skipSC()
this.eat(Colon$1)
const valueStart=this.tokenIndex
customProperty||this.skipSC()
value=parseValue?this.parseWithFallback(consumeValue$1,consumeRaw):consumeRaw.call(this,this.tokenIndex)
if(customProperty&&value.type==="Value"&&value.children.isEmpty)for(let offset=valueStart-this.tokenIndex;offset<=0;offset++)if(this.lookupType(offset)===WhiteSpace$3){value.children.appendData({type:"WhiteSpace",loc:null,value:" "})
break}if(this.isDelim(EXCLAMATIONMARK$5)){important=getImportant$1.call(this)
this.skipSC()}this.eof===false&&this.tokenType!==Semicolon$1&&this.isBalanceEdge(startToken)===false&&this.error()
return{type:"Declaration",loc:this.getLocation(start,this.tokenStart),important:important,property:property,value:value}}function generate$1h(node){this.token(Ident$1,node.property)
this.token(Colon$1,":")
this.node(node.value)
if(node.important){this.token(Delim$1,"!")
this.token(Ident$1,node.important===true?"important":node.important)}}function readProperty$2(){const start=this.tokenStart
if(this.tokenType===Delim$1)switch(this.charCodeAt(this.tokenStart)){case ASTERISK$a:case DOLLARSIGN$2:case PLUSSIGN$d:case NUMBERSIGN$7:case AMPERSAND$5:this.next()
break
case SOLIDUS$b:this.next()
this.isDelim(SOLIDUS$b)&&this.next()
break}this.tokenType===Hash$3?this.eat(Hash$3):this.eat(Ident$1)
return this.substrToCursor(start)}function getImportant$1(){this.eat(Delim$1)
this.skipSC()
const important=this.consume(Ident$1)
return important==="important"||important}var Declaration$1=Object.freeze({__proto__:null,generate:generate$1h,name:name$1_,parse:parse$1h,structure:structure$1c,walkContext:walkContext$g})
const AMPERSAND$4=0x0026
function consumeRaw$8(){return this.Raw(this.consumeUntilSemicolonIncluded,true)}const name$1Z="DeclarationList"
const structure$1b={children:[["Declaration","Atrule","Rule"]]}
function parse$1g(){const children=this.createList()
while(!this.eof)switch(this.tokenType){case WhiteSpace$3:case Comment$3:case Semicolon$1:this.next()
break
case AtKeyword$1:children.push(this.parseWithFallback(this.Atrule.bind(this,true),consumeRaw$8))
break
default:this.isDelim(AMPERSAND$4)?children.push(this.parseWithFallback(this.Rule,consumeRaw$8)):children.push(this.parseWithFallback(this.Declaration,consumeRaw$8))}return{type:"DeclarationList",loc:this.getLocationFromList(children),children:children}}function generate$1g(node){this.children(node,(prev=>{prev.type==="Declaration"&&this.token(Semicolon$1,";")}))}var DeclarationList$1=Object.freeze({__proto__:null,generate:generate$1g,name:name$1Z,parse:parse$1g,structure:structure$1b})
const name$1Y="Dimension"
const structure$1a={value:String,unit:String}
function parse$1f(){const start=this.tokenStart
const value=this.consumeNumber(Dimension$3)
return{type:"Dimension",loc:this.getLocation(start,this.tokenStart),value:value,unit:this.substring(start+value.length,this.tokenStart)}}function generate$1f(node){this.token(Dimension$3,node.value+node.unit)}var Dimension$2=Object.freeze({__proto__:null,generate:generate$1f,name:name$1Y,parse:parse$1f,structure:structure$1a})
const SOLIDUS$a=0x002F
const name$1X="Feature"
const structure$19={kind:String,name:String,value:["Identifier","Number","Dimension","Ratio","Function",null]}
function parse$1e(kind){const start=this.tokenStart
let name
let value=null
this.eat(LeftParenthesis$1)
this.skipSC()
name=this.consume(Ident$1)
this.skipSC()
if(this.tokenType!==RightParenthesis$1){this.eat(Colon$1)
this.skipSC()
switch(this.tokenType){case Number$5:value=this.lookupNonWSType(1)===Delim$1?this.Ratio():this.Number()
break
case Dimension$3:value=this.Dimension()
break
case Ident$1:value=this.Identifier()
break
case Function$3:value=this.parseWithFallback((()=>{const res=this.Function(this.readSequence,this.scope.Value)
this.skipSC()
this.isDelim(SOLIDUS$a)&&this.error()
return res}),(()=>this.Ratio()))
break
default:this.error("Number, dimension, ratio or identifier is expected")}this.skipSC()}this.eof||this.eat(RightParenthesis$1)
return{type:"Feature",loc:this.getLocation(start,this.tokenStart),kind:kind,name:name,value:value}}function generate$1e(node){this.token(LeftParenthesis$1,"(")
this.token(Ident$1,node.name)
if(node.value!==null){this.token(Colon$1,":")
this.node(node.value)}this.token(RightParenthesis$1,")")}var Feature=Object.freeze({__proto__:null,generate:generate$1e,name:name$1X,parse:parse$1e,structure:structure$19})
const name$1W="FeatureFunction"
const structure$18={kind:String,feature:String,value:["Declaration","Selector"]}
function getFeatureParser(kind,name){const featuresOfKind=this.features[kind]||{}
const parser=featuresOfKind[name]
typeof parser!=="function"&&this.error(`Unknown feature ${name}()`)
return parser}function parse$1d(kind="unknown"){const start=this.tokenStart
const functionName=this.consumeFunctionName()
const valueParser=getFeatureParser.call(this,kind,functionName.toLowerCase())
this.skipSC()
const value=this.parseWithFallback((()=>{const startValueToken=this.tokenIndex
const value=valueParser.call(this)
this.eof===false&&this.isBalanceEdge(startValueToken)===false&&this.error()
return value}),(()=>this.Raw(null,false)))
this.eof||this.eat(RightParenthesis$1)
return{type:"FeatureFunction",loc:this.getLocation(start,this.tokenStart),kind:kind,feature:functionName,value:value}}function generate$1d(node){this.token(Function$3,node.feature+"(")
this.node(node.value)
this.token(RightParenthesis$1,")")}var FeatureFunction=Object.freeze({__proto__:null,generate:generate$1d,name:name$1W,parse:parse$1d,structure:structure$18})
const SOLIDUS$9=0x002F
const LESSTHANSIGN$1=0x003C
const EQUALSSIGN$1=0x003D
const GREATERTHANSIGN$4=0x003E
const name$1V="FeatureRange"
const structure$17={kind:String,left:["Identifier","Number","Dimension","Ratio","Function"],leftComparison:String,middle:["Identifier","Number","Dimension","Ratio","Function"],rightComparison:[String,null],right:["Identifier","Number","Dimension","Ratio","Function",null]}
function readTerm(){this.skipSC()
switch(this.tokenType){case Number$5:return this.isDelim(SOLIDUS$9,this.lookupOffsetNonSC(1))?this.Ratio():this.Number()
case Dimension$3:return this.Dimension()
case Ident$1:return this.Identifier()
case Function$3:return this.parseWithFallback((()=>{const res=this.Function(this.readSequence,this.scope.Value)
this.skipSC()
this.isDelim(SOLIDUS$9)&&this.error()
return res}),(()=>this.Ratio()))
default:this.error("Number, dimension, ratio or identifier is expected")}}function readComparison(expectColon){this.skipSC()
if(this.isDelim(LESSTHANSIGN$1)||this.isDelim(GREATERTHANSIGN$4)){const value=this.source[this.tokenStart]
this.next()
if(this.isDelim(EQUALSSIGN$1)){this.next()
return value+"="}return value}if(this.isDelim(EQUALSSIGN$1))return"="
this.error(`Expected ${expectColon?'":", ':""}"<", ">", "=" or ")"`)}function parse$1c(kind="unknown"){const start=this.tokenStart
this.skipSC()
this.eat(LeftParenthesis$1)
const left=readTerm.call(this)
const leftComparison=readComparison.call(this,left.type==="Identifier")
const middle=readTerm.call(this)
let rightComparison=null
let right=null
if(this.lookupNonWSType(0)!==RightParenthesis$1){rightComparison=readComparison.call(this)
right=readTerm.call(this)}this.skipSC()
this.eat(RightParenthesis$1)
return{type:"FeatureRange",loc:this.getLocation(start,this.tokenStart),kind:kind,left:left,leftComparison:leftComparison,middle:middle,rightComparison:rightComparison,right:right}}function generate$1c(node){this.token(LeftParenthesis$1,"(")
this.node(node.left)
this.tokenize(node.leftComparison)
this.node(node.middle)
if(node.right){this.tokenize(node.rightComparison)
this.node(node.right)}this.token(RightParenthesis$1,")")}var FeatureRange=Object.freeze({__proto__:null,generate:generate$1c,name:name$1V,parse:parse$1c,structure:structure$17})
const name$1U="Function"
const walkContext$f="function"
const structure$16={name:String,children:[[]]}
function parse$1b(readSequence,recognizer){const start=this.tokenStart
const name=this.consumeFunctionName()
const nameLowerCase=name.toLowerCase()
let children
children=recognizer.hasOwnProperty(nameLowerCase)?recognizer[nameLowerCase].call(this,recognizer):readSequence.call(this,recognizer)
this.eof||this.eat(RightParenthesis$1)
return{type:"Function",loc:this.getLocation(start,this.tokenStart),name:name,children:children}}function generate$1b(node){this.token(Function$3,node.name+"(")
this.children(node)
this.token(RightParenthesis$1,")")}var Function$2=Object.freeze({__proto__:null,generate:generate$1b,name:name$1U,parse:parse$1b,structure:structure$16,walkContext:walkContext$f})
const name$1T="GeneralEnclosed"
const structure$15={kind:String,function:[String,null],children:[[]]}
function parse$1a(kind){const start=this.tokenStart
let functionName=null
this.tokenType===Function$3?functionName=this.consumeFunctionName():this.eat(LeftParenthesis$1)
const children=this.parseWithFallback((()=>{const startValueToken=this.tokenIndex
const children=this.readSequence(this.scope.Value)
this.eof===false&&this.isBalanceEdge(startValueToken)===false&&this.error()
return children}),(()=>this.createSingleNodeList(this.Raw(null,false))))
this.eof||this.eat(RightParenthesis$1)
return{type:"GeneralEnclosed",loc:this.getLocation(start,this.tokenStart),kind:kind,function:functionName,children:children}}function generate$1a(node){node.function?this.token(Function$3,node.function+"("):this.token(LeftParenthesis$1,"(")
this.children(node)
this.token(RightParenthesis$1,")")}var GeneralEnclosed=Object.freeze({__proto__:null,generate:generate$1a,name:name$1T,parse:parse$1a,structure:structure$15})
const xxx$1="XXX"
const name$1S="Hash"
const structure$14={value:String}
function parse$19(){const start=this.tokenStart
this.eat(Hash$3)
return{type:"Hash",loc:this.getLocation(start,this.tokenStart),value:this.substrToCursor(start+1)}}function generate$19(node){this.token(Hash$3,"#"+node.value)}var Hash$2=Object.freeze({__proto__:null,generate:generate$19,name:name$1S,parse:parse$19,structure:structure$14,xxx:xxx$1})
const name$1R="Identifier"
const structure$13={name:String}
function parse$18(){return{type:"Identifier",loc:this.getLocation(this.tokenStart,this.tokenEnd),name:this.consume(Ident$1)}}function generate$18(node){this.token(Ident$1,node.name)}var Identifier$1=Object.freeze({__proto__:null,generate:generate$18,name:name$1R,parse:parse$18,structure:structure$13})
const name$1Q="IdSelector"
const structure$12={name:String}
function parse$17(){const start=this.tokenStart
this.eat(Hash$3)
return{type:"IdSelector",loc:this.getLocation(start,this.tokenStart),name:this.substrToCursor(start+1)}}function generate$17(node){this.token(Delim$1,"#"+node.name)}var IdSelector$1=Object.freeze({__proto__:null,generate:generate$17,name:name$1Q,parse:parse$17,structure:structure$12})
const FULLSTOP$4=0x002E
const name$1P="Layer"
const structure$11={name:String}
function parse$16(){let name=this.consume(Ident$1)
while(this.isDelim(FULLSTOP$4)){this.eat(Delim$1)
name+="."+this.consume(Ident$1)}return{type:"Layer",loc:this.getLocation(this.tokenStart,this.tokenEnd),name:name}}function generate$16(node){this.tokenize(node.name)}var Layer=Object.freeze({__proto__:null,generate:generate$16,name:name$1P,parse:parse$16,structure:structure$11})
const name$1O="LayerList"
const structure$10={children:[["Layer"]]}
function parse$15(){const children=this.createList()
this.skipSC()
while(!this.eof){children.push(this.Layer())
if(this.lookupTypeNonSC(0)!==Comma$1)break
this.skipSC()
this.next()
this.skipSC()}return{type:"LayerList",loc:this.getLocationFromList(children),children:children}}function generate$15(node){this.children(node,(()=>this.token(Comma$1,",")))}var LayerList=Object.freeze({__proto__:null,generate:generate$15,name:name$1O,parse:parse$15,structure:structure$10})
const name$1N="MediaQuery"
const structure$$={modifier:[String,null],mediaType:[String,null],condition:["Condition",null]}
function parse$14(){const start=this.tokenStart
let modifier=null
let mediaType=null
let condition=null
this.skipSC()
if(this.tokenType===Ident$1&&this.lookupTypeNonSC(1)!==LeftParenthesis$1){const ident=this.consume(Ident$1)
const identLowerCase=ident.toLowerCase()
if(identLowerCase==="not"||identLowerCase==="only"){this.skipSC()
modifier=identLowerCase
mediaType=this.consume(Ident$1)}else mediaType=ident
switch(this.lookupTypeNonSC(0)){case Ident$1:this.skipSC()
this.eatIdent("and")
condition=this.Condition("media")
break
case LeftCurlyBracket$1:case Semicolon$1:case Comma$1:case EOF$3:break
default:this.error("Identifier or parenthesis is expected")}}else switch(this.tokenType){case Ident$1:case LeftParenthesis$1:case Function$3:condition=this.Condition("media")
break
case LeftCurlyBracket$1:case Semicolon$1:case EOF$3:break
default:this.error("Identifier or parenthesis is expected")}return{type:"MediaQuery",loc:this.getLocation(start,this.tokenStart),modifier:modifier,mediaType:mediaType,condition:condition}}function generate$14(node){if(node.mediaType){node.modifier&&this.token(Ident$1,node.modifier)
this.token(Ident$1,node.mediaType)
if(node.condition){this.token(Ident$1,"and")
this.node(node.condition)}}else node.condition&&this.node(node.condition)}var MediaQuery$1=Object.freeze({__proto__:null,generate:generate$14,name:name$1N,parse:parse$14,structure:structure$$})
const name$1M="MediaQueryList"
const structure$_={children:[["MediaQuery"]]}
function parse$13(){const children=this.createList()
this.skipSC()
while(!this.eof){children.push(this.MediaQuery())
if(this.tokenType!==Comma$1)break
this.next()}return{type:"MediaQueryList",loc:this.getLocationFromList(children),children:children}}function generate$13(node){this.children(node,(()=>this.token(Comma$1,",")))}var MediaQueryList$1=Object.freeze({__proto__:null,generate:generate$13,name:name$1M,parse:parse$13,structure:structure$_})
const AMPERSAND$3=0x0026
const name$1L="NestingSelector"
const structure$Z={}
function parse$12(){const start=this.tokenStart
this.eatDelim(AMPERSAND$3)
return{type:"NestingSelector",loc:this.getLocation(start,this.tokenStart)}}function generate$12(){this.token(Delim$1,"&")}var NestingSelector=Object.freeze({__proto__:null,generate:generate$12,name:name$1L,parse:parse$12,structure:structure$Z})
const name$1K="Nth"
const structure$Y={nth:["AnPlusB","Identifier"],selector:["SelectorList",null]}
function parse$11(){this.skipSC()
const start=this.tokenStart
let end=start
let selector=null
let nth
nth=this.lookupValue(0,"odd")||this.lookupValue(0,"even")?this.Identifier():this.AnPlusB()
end=this.tokenStart
this.skipSC()
if(this.lookupValue(0,"of")){this.next()
selector=this.SelectorList()
end=this.tokenStart}return{type:"Nth",loc:this.getLocation(start,end),nth:nth,selector:selector}}function generate$11(node){this.node(node.nth)
if(node.selector!==null){this.token(Ident$1,"of")
this.node(node.selector)}}var Nth$1=Object.freeze({__proto__:null,generate:generate$11,name:name$1K,parse:parse$11,structure:structure$Y})
const name$1J="Number"
const structure$X={value:String}
function parse$10(){return{type:"Number",loc:this.getLocation(this.tokenStart,this.tokenEnd),value:this.consume(Number$5)}}function generate$10(node){this.token(Number$5,node.value)}var Number$4=Object.freeze({__proto__:null,generate:generate$10,name:name$1J,parse:parse$10,structure:structure$X})
const name$1I="Operator"
const structure$W={value:String}
function parse$$(){const start=this.tokenStart
this.next()
return{type:"Operator",loc:this.getLocation(start,this.tokenStart),value:this.substrToCursor(start)}}function generate$$(node){this.tokenize(node.value)}var Operator$1=Object.freeze({__proto__:null,generate:generate$$,name:name$1I,parse:parse$$,structure:structure$W})
const name$1H="Parentheses"
const structure$V={children:[[]]}
function parse$_(readSequence,recognizer){const start=this.tokenStart
let children=null
this.eat(LeftParenthesis$1)
children=readSequence.call(this,recognizer)
this.eof||this.eat(RightParenthesis$1)
return{type:"Parentheses",loc:this.getLocation(start,this.tokenStart),children:children}}function generate$_(node){this.token(LeftParenthesis$1,"(")
this.children(node)
this.token(RightParenthesis$1,")")}var Parentheses$1=Object.freeze({__proto__:null,generate:generate$_,name:name$1H,parse:parse$_,structure:structure$V})
const name$1G="Percentage"
const structure$U={value:String}
function parse$Z(){return{type:"Percentage",loc:this.getLocation(this.tokenStart,this.tokenEnd),value:this.consumeNumber(Percentage$3)}}function generate$Z(node){this.token(Percentage$3,node.value+"%")}var Percentage$2=Object.freeze({__proto__:null,generate:generate$Z,name:name$1G,parse:parse$Z,structure:structure$U})
const name$1F="PseudoClassSelector"
const walkContext$e="function"
const structure$T={name:String,children:[["Raw"],null]}
function parse$Y(){const start=this.tokenStart
let children=null
let name
let nameLowerCase
this.eat(Colon$1)
if(this.tokenType===Function$3){name=this.consumeFunctionName()
nameLowerCase=name.toLowerCase()
if(this.lookupNonWSType(0)==RightParenthesis$1)children=this.createList()
else if(hasOwnProperty.call(this.pseudo,nameLowerCase)){this.skipSC()
children=this.pseudo[nameLowerCase].call(this)
this.skipSC()}else{children=this.createList()
children.push(this.Raw(null,false))}this.eat(RightParenthesis$1)}else name=this.consume(Ident$1)
return{type:"PseudoClassSelector",loc:this.getLocation(start,this.tokenStart),name:name,children:children}}function generate$Y(node){this.token(Colon$1,":")
if(node.children===null)this.token(Ident$1,node.name)
else{this.token(Function$3,node.name+"(")
this.children(node)
this.token(RightParenthesis$1,")")}}var PseudoClassSelector$1=Object.freeze({__proto__:null,generate:generate$Y,name:name$1F,parse:parse$Y,structure:structure$T,walkContext:walkContext$e})
const name$1E="PseudoElementSelector"
const walkContext$d="function"
const structure$S={name:String,children:[["Raw"],null]}
function parse$X(){const start=this.tokenStart
let children=null
let name
let nameLowerCase
this.eat(Colon$1)
this.eat(Colon$1)
if(this.tokenType===Function$3){name=this.consumeFunctionName()
nameLowerCase=name.toLowerCase()
if(this.lookupNonWSType(0)==RightParenthesis$1)children=this.createList()
else if(hasOwnProperty.call(this.pseudo,nameLowerCase)){this.skipSC()
children=this.pseudo[nameLowerCase].call(this)
this.skipSC()}else{children=this.createList()
children.push(this.Raw(null,false))}this.eat(RightParenthesis$1)}else name=this.consume(Ident$1)
return{type:"PseudoElementSelector",loc:this.getLocation(start,this.tokenStart),name:name,children:children}}function generate$X(node){this.token(Colon$1,":")
this.token(Colon$1,":")
if(node.children===null)this.token(Ident$1,node.name)
else{this.token(Function$3,node.name+"(")
this.children(node)
this.token(RightParenthesis$1,")")}}var PseudoElementSelector$1=Object.freeze({__proto__:null,generate:generate$X,name:name$1E,parse:parse$X,structure:structure$S,walkContext:walkContext$d})
const SOLIDUS$8=0x002F
function consumeTerm(){this.skipSC()
switch(this.tokenType){case Number$5:return this.Number()
case Function$3:return this.Function(this.readSequence,this.scope.Value)
default:this.error("Number of function is expected")}}const name$1D="Ratio"
const structure$R={left:["Number","Function"],right:["Number","Function",null]}
function parse$W(){const start=this.tokenStart
const left=consumeTerm.call(this)
let right=null
this.skipSC()
if(this.isDelim(SOLIDUS$8)){this.eatDelim(SOLIDUS$8)
right=consumeTerm.call(this)}return{type:"Ratio",loc:this.getLocation(start,this.tokenStart),left:left,right:right}}function generate$W(node){this.node(node.left)
this.token(Delim$1,"/")
node.right?this.node(node.right):this.node(Number$5,1)}var Ratio$1=Object.freeze({__proto__:null,generate:generate$W,name:name$1D,parse:parse$W,structure:structure$R})
function getOffsetExcludeWS$1(){if(this.tokenIndex>0&&this.lookupType(-1)===WhiteSpace$3)return this.tokenIndex>1?this.getTokenStart(this.tokenIndex-1):this.firstCharOffset
return this.tokenStart}const name$1C="Raw"
const structure$Q={value:String}
function parse$V(consumeUntil,excludeWhiteSpace){const startOffset=this.getTokenStart(this.tokenIndex)
let endOffset
this.skipUntilBalanced(this.tokenIndex,consumeUntil||this.consumeUntilBalanceEnd)
endOffset=excludeWhiteSpace&&this.tokenStart>startOffset?getOffsetExcludeWS$1.call(this):this.tokenStart
return{type:"Raw",loc:this.getLocation(startOffset,endOffset),value:this.substring(startOffset,endOffset)}}function generate$V(node){this.tokenize(node.value)}var Raw$1=Object.freeze({__proto__:null,generate:generate$V,name:name$1C,parse:parse$V,structure:structure$Q})
function consumeRaw$7(){return this.Raw(this.consumeUntilLeftCurlyBracket,true)}function consumePrelude$1(){const prelude=this.SelectorList()
prelude.type!=="Raw"&&this.eof===false&&this.tokenType!==LeftCurlyBracket$1&&this.error()
return prelude}const name$1B="Rule"
const walkContext$c="rule"
const structure$P={prelude:["SelectorList","Raw"],block:["Block"]}
function parse$U(){const startToken=this.tokenIndex
const startOffset=this.tokenStart
let prelude
let block
prelude=this.parseRulePrelude?this.parseWithFallback(consumePrelude$1,consumeRaw$7):consumeRaw$7.call(this,startToken)
block=this.Block(true)
return{type:"Rule",loc:this.getLocation(startOffset,this.tokenStart),prelude:prelude,block:block}}function generate$U(node){this.node(node.prelude)
this.node(node.block)}var Rule$1=Object.freeze({__proto__:null,generate:generate$U,name:name$1B,parse:parse$U,structure:structure$P,walkContext:walkContext$c})
const name$1A="Scope"
const structure$O={root:["SelectorList","Raw",null],limit:["SelectorList","Raw",null]}
function parse$T(){let root=null
let limit=null
this.skipSC()
const startOffset=this.tokenStart
if(this.tokenType===LeftParenthesis$1){this.next()
this.skipSC()
root=this.parseWithFallback(this.SelectorList,(()=>this.Raw(false,true)))
this.skipSC()
this.eat(RightParenthesis$1)}if(this.lookupNonWSType(0)===Ident$1){this.skipSC()
this.eatIdent("to")
this.skipSC()
this.eat(LeftParenthesis$1)
this.skipSC()
limit=this.parseWithFallback(this.SelectorList,(()=>this.Raw(false,true)))
this.skipSC()
this.eat(RightParenthesis$1)}return{type:"Scope",loc:this.getLocation(startOffset,this.tokenStart),root:root,limit:limit}}function generate$T(node){if(node.root){this.token(LeftParenthesis$1,"(")
this.node(node.root)
this.token(RightParenthesis$1,")")}if(node.limit){this.token(Ident$1,"to")
this.token(LeftParenthesis$1,"(")
this.node(node.limit)
this.token(RightParenthesis$1,")")}}var Scope=Object.freeze({__proto__:null,generate:generate$T,name:name$1A,parse:parse$T,structure:structure$O})
const name$1z="Selector"
const structure$N={children:[["TypeSelector","IdSelector","ClassSelector","AttributeSelector","PseudoClassSelector","PseudoElementSelector","Combinator"]]}
function parse$S(){const children=this.readSequence(this.scope.Selector)
this.getFirstListNode(children)===null&&this.error("Selector is expected")
return{type:"Selector",loc:this.getLocationFromList(children),children:children}}function generate$S(node){this.children(node)}var Selector$1=Object.freeze({__proto__:null,generate:generate$S,name:name$1z,parse:parse$S,structure:structure$N})
const name$1y="SelectorList"
const walkContext$b="selector"
const structure$M={children:[["Selector","Raw"]]}
function parse$R(){const children=this.createList()
while(!this.eof){children.push(this.Selector())
if(this.tokenType===Comma$1){this.next()
continue}break}return{type:"SelectorList",loc:this.getLocationFromList(children),children:children}}function generate$R(node){this.children(node,(()=>this.token(Comma$1,",")))}var SelectorList$1=Object.freeze({__proto__:null,generate:generate$R,name:name$1y,parse:parse$R,structure:structure$M,walkContext:walkContext$b})
const REVERSE_SOLIDUS$3=0x005c
const QUOTATION_MARK$3=0x0022
const APOSTROPHE$4=0x0027
function decode$3(str){const len=str.length
const firstChar=str.charCodeAt(0)
const start=firstChar===QUOTATION_MARK$3||firstChar===APOSTROPHE$4?1:0
const end=start===1&&len>1&&str.charCodeAt(len-1)===firstChar?len-2:len-1
let decoded=""
for(let i=start;i<=end;i++){let code=str.charCodeAt(i)
if(code===REVERSE_SOLIDUS$3){if(i===end){i!==len-1&&(decoded=str.substr(i+1))
break}code=str.charCodeAt(++i)
if(isValidEscape$1(REVERSE_SOLIDUS$3,code)){const escapeStart=i-1
const escapeEnd=consumeEscaped$1(str,escapeStart)
i=escapeEnd-1
decoded+=decodeEscaped$1(str.substring(escapeStart+1,escapeEnd))}else code===0x000d&&str.charCodeAt(i+1)===0x000a&&i++}else decoded+=str[i]}return decoded}function encode$3(str,apostrophe){const quote='"'
const quoteCode=QUOTATION_MARK$3
let encoded=""
let wsBeforeHexIsNeeded=false
for(let i=0;i<str.length;i++){const code=str.charCodeAt(i)
if(code===0x0000){encoded+="�"
continue}if(code<=0x001f||code===0x007F){encoded+="\\"+code.toString(16)
wsBeforeHexIsNeeded=true
continue}if(code===quoteCode||code===REVERSE_SOLIDUS$3){encoded+="\\"+str.charAt(i)
wsBeforeHexIsNeeded=false}else{wsBeforeHexIsNeeded&&(isHexDigit$1(code)||isWhiteSpace$2(code))&&(encoded+=" ")
encoded+=str.charAt(i)
wsBeforeHexIsNeeded=false}}return quote+encoded+quote}const name$1x="String"
const structure$L={value:String}
function parse$Q(){return{type:"String",loc:this.getLocation(this.tokenStart,this.tokenEnd),value:decode$3(this.consume(String$4))}}function generate$Q(node){this.token(String$4,encode$3(node.value))}var String$3=Object.freeze({__proto__:null,generate:generate$Q,name:name$1x,parse:parse$Q,structure:structure$L})
const EXCLAMATIONMARK$4=0x0021
function consumeRaw$6(){return this.Raw(null,false)}const name$1w="StyleSheet"
const walkContext$a="stylesheet"
const structure$K={children:[["Comment","CDO","CDC","Atrule","Rule","Raw"]]}
function parse$P(){const start=this.tokenStart
const children=this.createList()
let child
while(!this.eof){switch(this.tokenType){case WhiteSpace$3:this.next()
continue
case Comment$3:if(this.charCodeAt(this.tokenStart+2)!==EXCLAMATIONMARK$4){this.next()
continue}child=this.Comment()
break
case CDO$3:child=this.CDO()
break
case CDC$3:child=this.CDC()
break
case AtKeyword$1:child=this.parseWithFallback(this.Atrule,consumeRaw$6)
break
default:child=this.parseWithFallback(this.Rule,consumeRaw$6)}children.push(child)}return{type:"StyleSheet",loc:this.getLocation(start,this.tokenStart),children:children}}function generate$P(node){this.children(node)}var StyleSheet$1=Object.freeze({__proto__:null,generate:generate$P,name:name$1w,parse:parse$P,structure:structure$K,walkContext:walkContext$a})
const name$1v="SupportsDeclaration"
const structure$J={declaration:"Declaration"}
function parse$O(){const start=this.tokenStart
this.eat(LeftParenthesis$1)
this.skipSC()
const declaration=this.Declaration()
this.eof||this.eat(RightParenthesis$1)
return{type:"SupportsDeclaration",loc:this.getLocation(start,this.tokenStart),declaration:declaration}}function generate$O(node){this.token(LeftParenthesis$1,"(")
this.node(node.declaration)
this.token(RightParenthesis$1,")")}var SupportsDeclaration=Object.freeze({__proto__:null,generate:generate$O,name:name$1v,parse:parse$O,structure:structure$J})
const ASTERISK$9=0x002A
const VERTICALLINE$5=0x007C
function eatIdentifierOrAsterisk$1(){this.tokenType!==Ident$1&&this.isDelim(ASTERISK$9)===false&&this.error("Identifier or asterisk is expected")
this.next()}const name$1u="TypeSelector"
const structure$I={name:String}
function parse$N(){const start=this.tokenStart
if(this.isDelim(VERTICALLINE$5)){this.next()
eatIdentifierOrAsterisk$1.call(this)}else{eatIdentifierOrAsterisk$1.call(this)
if(this.isDelim(VERTICALLINE$5)){this.next()
eatIdentifierOrAsterisk$1.call(this)}}return{type:"TypeSelector",loc:this.getLocation(start,this.tokenStart),name:this.substrToCursor(start)}}function generate$N(node){this.tokenize(node.name)}var TypeSelector$1=Object.freeze({__proto__:null,generate:generate$N,name:name$1u,parse:parse$N,structure:structure$I})
const PLUSSIGN$c=0x002B
const HYPHENMINUS$8=0x002D
const QUESTIONMARK$3=0x003F
function eatHexSequence$1(offset,allowDash){let len=0
for(let pos=this.tokenStart+offset;pos<this.tokenEnd;pos++){const code=this.charCodeAt(pos)
if(code===HYPHENMINUS$8&&allowDash&&len!==0){eatHexSequence$1.call(this,offset+len+1,false)
return-1}isHexDigit$1(code)||this.error(allowDash&&len!==0?"Hyphen minus"+(len<6?" or hex digit":"")+" is expected":len<6?"Hex digit is expected":"Unexpected input",pos);++len>6&&this.error("Too many hex digits",pos)}this.next()
return len}function eatQuestionMarkSequence$1(max){let count=0
while(this.isDelim(QUESTIONMARK$3)){++count>max&&this.error("Too many question marks")
this.next()}}function startsWith$2(code){this.charCodeAt(this.tokenStart)!==code&&this.error((code===PLUSSIGN$c?"Plus sign":"Hyphen minus")+" is expected")}function scanUnicodeRange$1(){let hexLength=0
switch(this.tokenType){case Number$5:hexLength=eatHexSequence$1.call(this,1,true)
if(this.isDelim(QUESTIONMARK$3)){eatQuestionMarkSequence$1.call(this,6-hexLength)
break}if(this.tokenType===Dimension$3||this.tokenType===Number$5){startsWith$2.call(this,HYPHENMINUS$8)
eatHexSequence$1.call(this,1,false)
break}break
case Dimension$3:hexLength=eatHexSequence$1.call(this,1,true)
hexLength>0&&eatQuestionMarkSequence$1.call(this,6-hexLength)
break
default:this.eatDelim(PLUSSIGN$c)
if(this.tokenType===Ident$1){hexLength=eatHexSequence$1.call(this,0,true)
hexLength>0&&eatQuestionMarkSequence$1.call(this,6-hexLength)
break}if(this.isDelim(QUESTIONMARK$3)){this.next()
eatQuestionMarkSequence$1.call(this,5)
break}this.error("Hex digit or question mark is expected")}}const name$1t="UnicodeRange"
const structure$H={value:String}
function parse$M(){const start=this.tokenStart
this.eatIdent("u")
scanUnicodeRange$1.call(this)
return{type:"UnicodeRange",loc:this.getLocation(start,this.tokenStart),value:this.substrToCursor(start)}}function generate$M(node){this.tokenize(node.value)}var UnicodeRange$1=Object.freeze({__proto__:null,generate:generate$M,name:name$1t,parse:parse$M,structure:structure$H})
const SPACE$5=0x0020
const REVERSE_SOLIDUS$2=0x005c
const QUOTATION_MARK$2=0x0022
const APOSTROPHE$3=0x0027
const LEFTPARENTHESIS$3=0x0028
const RIGHTPARENTHESIS$3=0x0029
function decode$2(str){const len=str.length
let start=4
let end=str.charCodeAt(len-1)===RIGHTPARENTHESIS$3?len-2:len-1
let decoded=""
while(start<end&&isWhiteSpace$2(str.charCodeAt(start)))start++
while(start<end&&isWhiteSpace$2(str.charCodeAt(end)))end--
for(let i=start;i<=end;i++){let code=str.charCodeAt(i)
if(code===REVERSE_SOLIDUS$2){if(i===end){i!==len-1&&(decoded=str.substr(i+1))
break}code=str.charCodeAt(++i)
if(isValidEscape$1(REVERSE_SOLIDUS$2,code)){const escapeStart=i-1
const escapeEnd=consumeEscaped$1(str,escapeStart)
i=escapeEnd-1
decoded+=decodeEscaped$1(str.substring(escapeStart+1,escapeEnd))}else code===0x000d&&str.charCodeAt(i+1)===0x000a&&i++}else decoded+=str[i]}return decoded}function encode$2(str){let encoded=""
let wsBeforeHexIsNeeded=false
for(let i=0;i<str.length;i++){const code=str.charCodeAt(i)
if(code===0x0000){encoded+="�"
continue}if(code<=0x001f||code===0x007F){encoded+="\\"+code.toString(16)
wsBeforeHexIsNeeded=true
continue}if(code===SPACE$5||code===REVERSE_SOLIDUS$2||code===QUOTATION_MARK$2||code===APOSTROPHE$3||code===LEFTPARENTHESIS$3||code===RIGHTPARENTHESIS$3){encoded+="\\"+str.charAt(i)
wsBeforeHexIsNeeded=false}else{wsBeforeHexIsNeeded&&isHexDigit$1(code)&&(encoded+=" ")
encoded+=str.charAt(i)
wsBeforeHexIsNeeded=false}}return"url("+encoded+")"}const name$1s="Url"
const structure$G={value:String}
function parse$L(){const start=this.tokenStart
let value
switch(this.tokenType){case Url$4:value=decode$2(this.consume(Url$4))
break
case Function$3:this.cmpStr(this.tokenStart,this.tokenEnd,"url(")||this.error("Function name must be `url`")
this.eat(Function$3)
this.skipSC()
value=decode$3(this.consume(String$4))
this.skipSC()
this.eof||this.eat(RightParenthesis$1)
break
default:this.error("Url or Function is expected")}return{type:"Url",loc:this.getLocation(start,this.tokenStart),value:value}}function generate$L(node){this.token(Url$4,encode$2(node.value))}var Url$3=Object.freeze({__proto__:null,generate:generate$L,name:name$1s,parse:parse$L,structure:structure$G})
const name$1r="Value"
const structure$F={children:[[]]}
function parse$K(){const start=this.tokenStart
const children=this.readSequence(this.scope.Value)
return{type:"Value",loc:this.getLocation(start,this.tokenStart),children:children}}function generate$K(node){this.children(node)}var Value$1=Object.freeze({__proto__:null,generate:generate$K,name:name$1r,parse:parse$K,structure:structure$F})
const SPACE$4=Object.freeze({type:"WhiteSpace",loc:null,value:" "})
const name$1q="WhiteSpace"
const structure$E={value:String}
function parse$J(){this.eat(WhiteSpace$3)
return SPACE$4}function generate$J(node){this.token(WhiteSpace$3,node.value)}var WhiteSpace$2=Object.freeze({__proto__:null,generate:generate$J,name:name$1q,parse:parse$J,structure:structure$E})
var node$3=Object.freeze({__proto__:null,AnPlusB:AnPlusB$1,Atrule:Atrule$2,AtrulePrelude:AtrulePrelude$1,AttributeSelector:AttributeSelector$2,Block:Block$1,Brackets:Brackets$1,CDC:CDC$2,CDO:CDO$2,ClassSelector:ClassSelector$1,Combinator:Combinator$1,Comment:Comment$2,Condition:Condition,Declaration:Declaration$1,DeclarationList:DeclarationList$1,Dimension:Dimension$2,Feature:Feature,FeatureFunction:FeatureFunction,FeatureRange:FeatureRange,Function:Function$2,GeneralEnclosed:GeneralEnclosed,Hash:Hash$2,IdSelector:IdSelector$1,Identifier:Identifier$1,Layer:Layer,LayerList:LayerList,MediaQuery:MediaQuery$1,MediaQueryList:MediaQueryList$1,NestingSelector:NestingSelector,Nth:Nth$1,Number:Number$4,Operator:Operator$1,Parentheses:Parentheses$1,Percentage:Percentage$2,PseudoClassSelector:PseudoClassSelector$1,PseudoElementSelector:PseudoElementSelector$1,Ratio:Ratio$1,Raw:Raw$1,Rule:Rule$1,Scope:Scope,Selector:Selector$1,SelectorList:SelectorList$1,String:String$3,StyleSheet:StyleSheet$1,SupportsDeclaration:SupportsDeclaration,TypeSelector:TypeSelector$1,UnicodeRange:UnicodeRange$1,Url:Url$3,Value:Value$1,WhiteSpace:WhiteSpace$2})
var lexerConfig$1={generic:true,cssWideKeywords:cssWideKeywords$1,...definitions$1,node:node$3}
const NUMBERSIGN$6=0x0023
const ASTERISK$8=0x002A
const PLUSSIGN$b=0x002B
const HYPHENMINUS$7=0x002D
const SOLIDUS$7=0x002F
const U$2=0x0075
function defaultRecognizer$1(context){switch(this.tokenType){case Hash$3:return this.Hash()
case Comma$1:return this.Operator()
case LeftParenthesis$1:return this.Parentheses(this.readSequence,context.recognizer)
case LeftSquareBracket$1:return this.Brackets(this.readSequence,context.recognizer)
case String$4:return this.String()
case Dimension$3:return this.Dimension()
case Percentage$3:return this.Percentage()
case Number$5:return this.Number()
case Function$3:return this.cmpStr(this.tokenStart,this.tokenEnd,"url(")?this.Url():this.Function(this.readSequence,context.recognizer)
case Url$4:return this.Url()
case Ident$1:return this.cmpChar(this.tokenStart,U$2)&&this.cmpChar(this.tokenStart+1,PLUSSIGN$b)?this.UnicodeRange():this.Identifier()
case Delim$1:{const code=this.charCodeAt(this.tokenStart)
if(code===SOLIDUS$7||code===ASTERISK$8||code===PLUSSIGN$b||code===HYPHENMINUS$7)return this.Operator()
code===NUMBERSIGN$6&&this.error("Hex or identifier is expected",this.tokenStart+1)
break}}}var atrulePrelude$1={getNode:defaultRecognizer$1}
const NUMBERSIGN$5=0x0023
const AMPERSAND$2=0x0026
const ASTERISK$7=0x002A
const PLUSSIGN$a=0x002B
const SOLIDUS$6=0x002F
const FULLSTOP$3=0x002E
const GREATERTHANSIGN$3=0x003E
const VERTICALLINE$4=0x007C
const TILDE$3=0x007E
function onWhiteSpace$1(next,children){children.last!==null&&children.last.type!=="Combinator"&&next!==null&&next.type!=="Combinator"&&children.push({type:"Combinator",loc:null,name:" "})}function getNode$1(){switch(this.tokenType){case LeftSquareBracket$1:return this.AttributeSelector()
case Hash$3:return this.IdSelector()
case Colon$1:return this.lookupType(1)===Colon$1?this.PseudoElementSelector():this.PseudoClassSelector()
case Ident$1:return this.TypeSelector()
case Number$5:case Percentage$3:return this.Percentage()
case Dimension$3:this.charCodeAt(this.tokenStart)===FULLSTOP$3&&this.error("Identifier is expected",this.tokenStart+1)
break
case Delim$1:{const code=this.charCodeAt(this.tokenStart)
switch(code){case PLUSSIGN$a:case GREATERTHANSIGN$3:case TILDE$3:case SOLIDUS$6:return this.Combinator()
case FULLSTOP$3:return this.ClassSelector()
case ASTERISK$7:case VERTICALLINE$4:return this.TypeSelector()
case NUMBERSIGN$5:return this.IdSelector()
case AMPERSAND$2:return this.NestingSelector()}break}}}var selector$3={onWhiteSpace:onWhiteSpace$1,getNode:getNode$1}
function expressionFn$1(){return this.createSingleNodeList(this.Raw(null,false))}function varFn$1(){const children=this.createList()
this.skipSC()
children.push(this.Identifier())
this.skipSC()
if(this.tokenType===Comma$1){children.push(this.Operator())
const startIndex=this.tokenIndex
const value=this.parseCustomProperty?this.Value(null):this.Raw(this.consumeUntilExclamationMarkOrSemicolon,false)
if(value.type==="Value"&&value.children.isEmpty)for(let offset=startIndex-this.tokenIndex;offset<=0;offset++)if(this.lookupType(offset)===WhiteSpace$3){value.children.appendData({type:"WhiteSpace",loc:null,value:" "})
break}children.push(value)}return children}function isPlusMinusOperator$1(node){return node!==null&&node.type==="Operator"&&(node.value[node.value.length-1]==="-"||node.value[node.value.length-1]==="+")}var value$1={getNode:defaultRecognizer$1,onWhiteSpace(next,children){isPlusMinusOperator$1(next)&&(next.value=" "+next.value)
isPlusMinusOperator$1(children.last)&&(children.last.value+=" ")},expression:expressionFn$1,var:varFn$1}
var scope$2=Object.freeze({__proto__:null,AtrulePrelude:atrulePrelude$1,Selector:selector$3,Value:value$1})
const nonContainerNameKeywords=new Set(["none","and","not","or"])
var container={parse:{prelude(){const children=this.createList()
if(this.tokenType===Ident$1){const name=this.substring(this.tokenStart,this.tokenEnd)
nonContainerNameKeywords.has(name.toLowerCase())||children.push(this.Identifier())}children.push(this.Condition("container"))
return children},block(nested=false){return this.Block(nested)}}}
var fontFace$1={parse:{prelude:null,block(){return this.Block(true)}}}
function parseWithFallback(parse,fallback){return this.parseWithFallback((()=>{try{return parse.call(this)}finally{this.skipSC()
this.lookupNonWSType(0)!==RightParenthesis$1&&this.error()}}),fallback||(()=>this.Raw(null,true)))}const parseFunctions={layer(){this.skipSC()
const children=this.createList()
const node=parseWithFallback.call(this,this.Layer)
node.type==="Raw"&&node.value===""||children.push(node)
return children},supports(){this.skipSC()
const children=this.createList()
const node=parseWithFallback.call(this,this.Declaration,(()=>parseWithFallback.call(this,(()=>this.Condition("supports")))))
node.type==="Raw"&&node.value===""||children.push(node)
return children}}
var importAtrule$1={parse:{prelude(){const children=this.createList()
switch(this.tokenType){case String$4:children.push(this.String())
break
case Url$4:case Function$3:children.push(this.Url())
break
default:this.error("String or url() is expected")}this.skipSC()
this.tokenType===Ident$1&&this.cmpStr(this.tokenStart,this.tokenEnd,"layer")?children.push(this.Identifier()):this.tokenType===Function$3&&this.cmpStr(this.tokenStart,this.tokenEnd,"layer(")&&children.push(this.Function(null,parseFunctions))
this.skipSC()
this.tokenType===Function$3&&this.cmpStr(this.tokenStart,this.tokenEnd,"supports(")&&children.push(this.Function(null,parseFunctions))
this.lookupNonWSType(0)!==Ident$1&&this.lookupNonWSType(0)!==LeftParenthesis$1||children.push(this.MediaQueryList())
return children},block:null}}
var layer={parse:{prelude(){return this.createSingleNodeList(this.LayerList())},block(){return this.Block(false)}}}
var media$1={parse:{prelude(){return this.createSingleNodeList(this.MediaQueryList())},block(nested=false){return this.Block(nested)}}}
var nest={parse:{prelude(){return this.createSingleNodeList(this.SelectorList())},block(){return this.Block(true)}}}
var page$1={parse:{prelude(){return this.createSingleNodeList(this.SelectorList())},block(){return this.Block(true)}}}
var scope$1={parse:{prelude(){return this.createSingleNodeList(this.Scope())},block(nested=false){return this.Block(nested)}}}
var startingStyle={parse:{prelude:null,block(nested=false){return this.Block(nested)}}}
var supports$1={parse:{prelude(){return this.createSingleNodeList(this.Condition("supports"))},block(nested=false){return this.Block(nested)}}}
var atrule$1={container:container,"font-face":fontFace$1,import:importAtrule$1,layer:layer,media:media$1,nest:nest,page:page$1,scope:scope$1,"starting-style":startingStyle,supports:supports$1}
function parseLanguageRangeList(){const children=this.createList()
this.skipSC()
loop:while(!this.eof){switch(this.tokenType){case Ident$1:children.push(this.Identifier())
break
case String$4:children.push(this.String())
break
case Comma$1:children.push(this.Operator())
break
case RightParenthesis$1:break loop
default:this.error("Identifier, string or comma is expected")}this.skipSC()}return children}const selectorList$1={parse(){return this.createSingleNodeList(this.SelectorList())}}
const selector$2={parse(){return this.createSingleNodeList(this.Selector())}}
const identList$1={parse(){return this.createSingleNodeList(this.Identifier())}}
const langList={parse:parseLanguageRangeList}
const nth$1={parse(){return this.createSingleNodeList(this.Nth())}}
var pseudo$1={dir:identList$1,has:selectorList$1,lang:langList,matches:selectorList$1,is:selectorList$1,"-moz-any":selectorList$1,"-webkit-any":selectorList$1,where:selectorList$1,not:selectorList$1,"nth-child":nth$1,"nth-last-child":nth$1,"nth-last-of-type":nth$1,"nth-of-type":nth$1,slotted:selector$2,host:selector$2,"host-context":selector$2}
var node$2=Object.freeze({__proto__:null,AnPlusB:parse$1t,Atrule:parse$1s,AtrulePrelude:parse$1r,AttributeSelector:parse$1q,Block:parse$1p,Brackets:parse$1o,CDC:parse$1n,CDO:parse$1m,ClassSelector:parse$1l,Combinator:parse$1k,Comment:parse$1j,Condition:parse$1i,Declaration:parse$1h,DeclarationList:parse$1g,Dimension:parse$1f,Feature:parse$1e,FeatureFunction:parse$1d,FeatureRange:parse$1c,Function:parse$1b,GeneralEnclosed:parse$1a,Hash:parse$19,IdSelector:parse$17,Identifier:parse$18,Layer:parse$16,LayerList:parse$15,MediaQuery:parse$14,MediaQueryList:parse$13,NestingSelector:parse$12,Nth:parse$11,Number:parse$10,Operator:parse$$,Parentheses:parse$_,Percentage:parse$Z,PseudoClassSelector:parse$Y,PseudoElementSelector:parse$X,Ratio:parse$W,Raw:parse$V,Rule:parse$U,Scope:parse$T,Selector:parse$S,SelectorList:parse$R,String:parse$Q,StyleSheet:parse$P,SupportsDeclaration:parse$O,TypeSelector:parse$N,UnicodeRange:parse$M,Url:parse$L,Value:parse$K,WhiteSpace:parse$J})
var parserConfig$1={parseContext:{default:"StyleSheet",stylesheet:"StyleSheet",atrule:"Atrule",atrulePrelude(options){return this.AtrulePrelude(options.atrule?String(options.atrule):null)},mediaQueryList:"MediaQueryList",mediaQuery:"MediaQuery",condition(options){return this.Condition(options.kind)},rule:"Rule",selectorList:"SelectorList",selector:"Selector",block(){return this.Block(true)},declarationList:"DeclarationList",declaration:"Declaration",value:"Value"},features:{supports:{selector(){return this.Selector()}},container:{style(){return this.Declaration()}}},scope:scope$2,atrule:atrule$1,pseudo:pseudo$1,node:node$2}
var walkerConfig$1={node:node$3}
var syntax$2=createSyntax$3({...lexerConfig$1,...parserConfig$1,...walkerConfig$1})
function clone$1(node){const result={}
for(const key of Object.keys(node)){let value=node[key]
value&&(Array.isArray(value)||value instanceof List$1?value=value.map(clone$1):value.constructor===Object&&(value=clone$1(value)))
result[key]=value}return result}const{tokenize:tokenize$3,parse:parse$I,generate:generate$I,lexer:lexer$2,createLexer:createLexer$1,walk:walk$3,find:find$2,findLast:findLast$2,findAll:findAll$2,toPlainObject:toPlainObject$2,fromPlainObject:fromPlainObject$2,fork:fork$1}=syntax$2
const EOF$1=0
const Ident=1
const Function$1=2
const AtKeyword=3
const Hash$1=4
const String$2=5
const BadString=6
const Url$2=7
const BadUrl=8
const Delim=9
const Number$3=10
const Percentage$1=11
const Dimension$1=12
const WhiteSpace$1=13
const CDO$1=14
const CDC$1=15
const Colon=16
const Semicolon=17
const Comma=18
const LeftSquareBracket=19
const RightSquareBracket=20
const LeftParenthesis=21
const RightParenthesis=22
const LeftCurlyBracket=23
const RightCurlyBracket=24
const Comment$1=25
const EOF=0
function isDigit$1(code){return code>=0x0030&&code<=0x0039}function isHexDigit(code){return isDigit$1(code)||code>=0x0041&&code<=0x0046||code>=0x0061&&code<=0x0066}function isUppercaseLetter(code){return code>=0x0041&&code<=0x005A}function isLowercaseLetter(code){return code>=0x0061&&code<=0x007A}function isLetter(code){return isUppercaseLetter(code)||isLowercaseLetter(code)}function isNonAscii(code){return code>=0x0080}function isNameStart(code){return isLetter(code)||isNonAscii(code)||code===0x005F}function isName(code){return isNameStart(code)||isDigit$1(code)||code===0x002D}function isNonPrintable(code){return code>=0x0000&&code<=0x0008||code===0x000B||code>=0x000E&&code<=0x001F||code===0x007F}function isNewline(code){return code===0x000A||code===0x000D||code===0x000C}function isWhiteSpace$1(code){return isNewline(code)||code===0x0020||code===0x0009}function isValidEscape(first,second){if(first!==0x005C)return false
if(isNewline(second)||second===EOF)return false
return true}function isIdentifierStart(first,second,third){if(first===0x002D)return isNameStart(second)||second===0x002D||isValidEscape(second,third)
if(isNameStart(first))return true
if(first===0x005C)return isValidEscape(first,second)
return false}function isNumberStart(first,second,third){if(first===0x002B||first===0x002D){if(isDigit$1(second))return 2
return second===0x002E&&isDigit$1(third)?3:0}if(first===0x002E)return isDigit$1(second)?2:0
if(isDigit$1(first))return 1
return 0}function isBOM(code){if(code===0xFEFF)return 1
if(code===0xFFFE)return 1
return 0}const CATEGORY=new Array(0x80)
const EofCategory=0x80
const WhiteSpaceCategory=0x82
const DigitCategory=0x83
const NameStartCategory=0x84
const NonPrintableCategory=0x85
for(let i=0;i<CATEGORY.length;i++)CATEGORY[i]=isWhiteSpace$1(i)&&WhiteSpaceCategory||isDigit$1(i)&&DigitCategory||isNameStart(i)&&NameStartCategory||isNonPrintable(i)&&NonPrintableCategory||i||EofCategory
function charCodeCategory(code){return code<0x80?CATEGORY[code]:NameStartCategory}function getCharCode(source,offset){return offset<source.length?source.charCodeAt(offset):0}function getNewlineLength(source,offset,code){if(code===13&&getCharCode(source,offset+1)===10)return 2
return 1}function cmpChar(testStr,offset,referenceCode){let code=testStr.charCodeAt(offset)
isUppercaseLetter(code)&&(code|=32)
return code===referenceCode}function cmpStr(testStr,start,end,referenceStr){if(end-start!==referenceStr.length)return false
if(start<0||end>testStr.length)return false
for(let i=start;i<end;i++){const referenceCode=referenceStr.charCodeAt(i-start)
let testCode=testStr.charCodeAt(i)
isUppercaseLetter(testCode)&&(testCode|=32)
if(testCode!==referenceCode)return false}return true}function findWhiteSpaceStart(source,offset){for(;offset>=0;offset--)if(!isWhiteSpace$1(source.charCodeAt(offset)))break
return offset+1}function findWhiteSpaceEnd(source,offset){for(;offset<source.length;offset++)if(!isWhiteSpace$1(source.charCodeAt(offset)))break
return offset}function findDecimalNumberEnd(source,offset){for(;offset<source.length;offset++)if(!isDigit$1(source.charCodeAt(offset)))break
return offset}function consumeEscaped(source,offset){offset+=2
if(isHexDigit(getCharCode(source,offset-1))){for(const maxOffset=Math.min(source.length,offset+5);offset<maxOffset;offset++)if(!isHexDigit(getCharCode(source,offset)))break
const code=getCharCode(source,offset)
isWhiteSpace$1(code)&&(offset+=getNewlineLength(source,offset,code))}return offset}function consumeName(source,offset){for(;offset<source.length;offset++){const code=source.charCodeAt(offset)
if(isName(code))continue
if(isValidEscape(code,getCharCode(source,offset+1))){offset=consumeEscaped(source,offset)-1
continue}break}return offset}function consumeNumber$1(source,offset){let code=source.charCodeAt(offset)
code!==0x002B&&code!==0x002D||(code=source.charCodeAt(offset+=1))
if(isDigit$1(code)){offset=findDecimalNumberEnd(source,offset+1)
code=source.charCodeAt(offset)}if(code===0x002E&&isDigit$1(source.charCodeAt(offset+1))){offset+=2
offset=findDecimalNumberEnd(source,offset)}if(cmpChar(source,offset,101)){let sign=0
code=source.charCodeAt(offset+1)
if(code===0x002D||code===0x002B){sign=1
code=source.charCodeAt(offset+2)}isDigit$1(code)&&(offset=findDecimalNumberEnd(source,offset+1+sign+1))}return offset}function consumeBadUrlRemnants(source,offset){for(;offset<source.length;offset++){const code=source.charCodeAt(offset)
if(code===0x0029){offset++
break}isValidEscape(code,getCharCode(source,offset+1))&&(offset=consumeEscaped(source,offset))}return offset}function decodeEscaped(escaped){if(escaped.length===1&&!isHexDigit(escaped.charCodeAt(0)))return escaped[0]
let code=parseInt(escaped,16);(code===0||code>=0xD800&&code<=0xDFFF||code>0x10FFFF)&&(code=0xFFFD)
return String.fromCodePoint(code)}var tokenNames=["EOF-token","ident-token","function-token","at-keyword-token","hash-token","string-token","bad-string-token","url-token","bad-url-token","delim-token","number-token","percentage-token","dimension-token","whitespace-token","CDO-token","CDC-token","colon-token","semicolon-token","comma-token","[-token","]-token","(-token",")-token","{-token","}-token"]
const MIN_SIZE=16384
function adoptBuffer(buffer=null,size){if(buffer===null||buffer.length<size)return new Uint32Array(Math.max(size+1024,MIN_SIZE))
return buffer}const N$4=10
const F$2=12
const R$2=13
function computeLinesAndColumns(host){const source=host.source
const sourceLength=source.length
const startOffset=source.length>0?isBOM(source.charCodeAt(0)):0
const lines=adoptBuffer(host.lines,sourceLength)
const columns=adoptBuffer(host.columns,sourceLength)
let line=host.startLine
let column=host.startColumn
for(let i=startOffset;i<sourceLength;i++){const code=source.charCodeAt(i)
lines[i]=line
columns[i]=column++
if(code===N$4||code===R$2||code===F$2){if(code===R$2&&i+1<sourceLength&&source.charCodeAt(i+1)===N$4){i++
lines[i]=line
columns[i]=column}line++
column=1}}lines[sourceLength]=line
columns[sourceLength]=column
host.lines=lines
host.columns=columns
host.computed=true}class OffsetToLocation{constructor(){this.lines=null
this.columns=null
this.computed=false}setSource(source,startOffset=0,startLine=1,startColumn=1){this.source=source
this.startOffset=startOffset
this.startLine=startLine
this.startColumn=startColumn
this.computed=false}getLocation(offset,filename){this.computed||computeLinesAndColumns(this)
return{source:filename,offset:this.startOffset+offset,line:this.lines[offset],column:this.columns[offset]}}getLocationRange(start,end,filename){this.computed||computeLinesAndColumns(this)
return{source:filename,start:{offset:this.startOffset+start,line:this.lines[start],column:this.columns[start]},end:{offset:this.startOffset+end,line:this.lines[end],column:this.columns[end]}}}}const OFFSET_MASK=0x00FFFFFF
const TYPE_SHIFT=24
const balancePair$1=new Map([[Function$1,RightParenthesis],[LeftParenthesis,RightParenthesis],[LeftSquareBracket,RightSquareBracket],[LeftCurlyBracket,RightCurlyBracket]])
class TokenStream{constructor(source,tokenize){this.setSource(source,tokenize)}reset(){this.eof=false
this.tokenIndex=-1
this.tokenType=0
this.tokenStart=this.firstCharOffset
this.tokenEnd=this.firstCharOffset}setSource(source="",tokenize=(()=>{})){source=String(source||"")
const sourceLength=source.length
const offsetAndType=adoptBuffer(this.offsetAndType,source.length+1)
const balance=adoptBuffer(this.balance,source.length+1)
let tokenCount=0
let balanceCloseType=0
let balanceStart=0
let firstCharOffset=-1
this.offsetAndType=null
this.balance=null
tokenize(source,((type,start,end)=>{switch(type){default:balance[tokenCount]=sourceLength
break
case balanceCloseType:{let balancePrev=balanceStart&OFFSET_MASK
balanceStart=balance[balancePrev]
balanceCloseType=balanceStart>>TYPE_SHIFT
balance[tokenCount]=balancePrev
balance[balancePrev++]=tokenCount
for(;balancePrev<tokenCount;balancePrev++)balance[balancePrev]===sourceLength&&(balance[balancePrev]=tokenCount)
break}case LeftParenthesis:case Function$1:case LeftSquareBracket:case LeftCurlyBracket:balance[tokenCount]=balanceStart
balanceCloseType=balancePair$1.get(type)
balanceStart=balanceCloseType<<TYPE_SHIFT|tokenCount
break}offsetAndType[tokenCount++]=type<<TYPE_SHIFT|end
firstCharOffset===-1&&(firstCharOffset=start)}))
offsetAndType[tokenCount]=EOF$1<<TYPE_SHIFT|sourceLength
balance[tokenCount]=sourceLength
balance[sourceLength]=sourceLength
while(balanceStart!==0){const balancePrev=balanceStart&OFFSET_MASK
balanceStart=balance[balancePrev]
balance[balancePrev]=sourceLength}this.source=source
this.firstCharOffset=firstCharOffset===-1?0:firstCharOffset
this.tokenCount=tokenCount
this.offsetAndType=offsetAndType
this.balance=balance
this.reset()
this.next()}lookupType(offset){offset+=this.tokenIndex
if(offset<this.tokenCount)return this.offsetAndType[offset]>>TYPE_SHIFT
return EOF$1}lookupOffset(offset){offset+=this.tokenIndex
if(offset<this.tokenCount)return this.offsetAndType[offset-1]&OFFSET_MASK
return this.source.length}lookupValue(offset,referenceStr){offset+=this.tokenIndex
if(offset<this.tokenCount)return cmpStr(this.source,this.offsetAndType[offset-1]&OFFSET_MASK,this.offsetAndType[offset]&OFFSET_MASK,referenceStr)
return false}getTokenStart(tokenIndex){if(tokenIndex===this.tokenIndex)return this.tokenStart
if(tokenIndex>0)return tokenIndex<this.tokenCount?this.offsetAndType[tokenIndex-1]&OFFSET_MASK:this.offsetAndType[this.tokenCount]&OFFSET_MASK
return this.firstCharOffset}substrToCursor(start){return this.source.substring(start,this.tokenStart)}isBalanceEdge(pos){return this.balance[this.tokenIndex]<pos}isDelim(code,offset){if(offset)return this.lookupType(offset)===Delim&&this.source.charCodeAt(this.lookupOffset(offset))===code
return this.tokenType===Delim&&this.source.charCodeAt(this.tokenStart)===code}skip(tokenCount){let next=this.tokenIndex+tokenCount
if(next<this.tokenCount){this.tokenIndex=next
this.tokenStart=this.offsetAndType[next-1]&OFFSET_MASK
next=this.offsetAndType[next]
this.tokenType=next>>TYPE_SHIFT
this.tokenEnd=next&OFFSET_MASK}else{this.tokenIndex=this.tokenCount
this.next()}}next(){let next=this.tokenIndex+1
if(next<this.tokenCount){this.tokenIndex=next
this.tokenStart=this.tokenEnd
next=this.offsetAndType[next]
this.tokenType=next>>TYPE_SHIFT
this.tokenEnd=next&OFFSET_MASK}else{this.eof=true
this.tokenIndex=this.tokenCount
this.tokenType=EOF$1
this.tokenStart=this.tokenEnd=this.source.length}}skipSC(){while(this.tokenType===WhiteSpace$1||this.tokenType===Comment$1)this.next()}skipUntilBalanced(startToken,stopConsume){let cursor=startToken
let balanceEnd
let offset
loop:for(;cursor<this.tokenCount;cursor++){balanceEnd=this.balance[cursor]
if(balanceEnd<startToken)break loop
offset=cursor>0?this.offsetAndType[cursor-1]&OFFSET_MASK:this.firstCharOffset
switch(stopConsume(this.source.charCodeAt(offset))){case 1:break loop
case 2:cursor++
break loop
default:this.balance[balanceEnd]===cursor&&(cursor=balanceEnd)}}this.skip(cursor-this.tokenIndex)}forEachToken(fn){for(let i=0,offset=this.firstCharOffset;i<this.tokenCount;i++){const start=offset
const item=this.offsetAndType[i]
const end=item&OFFSET_MASK
const type=item>>TYPE_SHIFT
offset=end
fn(type,start,end,i)}}dump(){const tokens=new Array(this.tokenCount)
this.forEachToken(((type,start,end,index)=>{tokens[index]={idx:index,type:tokenNames[type],chunk:this.source.substring(start,end),balance:this.balance[index]}}))
return tokens}}function tokenize$2(source,onToken){function getCharCode(offset){return offset<sourceLength?source.charCodeAt(offset):0}function consumeNumericToken(){offset=consumeNumber$1(source,offset)
if(isIdentifierStart(getCharCode(offset),getCharCode(offset+1),getCharCode(offset+2))){type=Dimension$1
offset=consumeName(source,offset)
return}if(getCharCode(offset)===0x0025){type=Percentage$1
offset++
return}type=Number$3}function consumeIdentLikeToken(){const nameStartOffset=offset
offset=consumeName(source,offset)
if(cmpStr(source,nameStartOffset,offset,"url")&&getCharCode(offset)===0x0028){offset=findWhiteSpaceEnd(source,offset+1)
if(getCharCode(offset)===0x0022||getCharCode(offset)===0x0027){type=Function$1
offset=nameStartOffset+4
return}consumeUrlToken()
return}if(getCharCode(offset)===0x0028){type=Function$1
offset++
return}type=Ident}function consumeStringToken(endingCodePoint){endingCodePoint||(endingCodePoint=getCharCode(offset++))
type=String$2
for(;offset<source.length;offset++){const code=source.charCodeAt(offset)
switch(charCodeCategory(code)){case endingCodePoint:offset++
return
case WhiteSpaceCategory:if(isNewline(code)){offset+=getNewlineLength(source,offset,code)
type=BadString
return}break
case 0x005C:if(offset===source.length-1)break
const nextCode=getCharCode(offset+1)
isNewline(nextCode)?offset+=getNewlineLength(source,offset+1,nextCode):isValidEscape(code,nextCode)&&(offset=consumeEscaped(source,offset)-1)
break}}}function consumeUrlToken(){type=Url$2
offset=findWhiteSpaceEnd(source,offset)
for(;offset<source.length;offset++){const code=source.charCodeAt(offset)
switch(charCodeCategory(code)){case 0x0029:offset++
return
case WhiteSpaceCategory:offset=findWhiteSpaceEnd(source,offset)
if(getCharCode(offset)===0x0029||offset>=source.length){offset<source.length&&offset++
return}offset=consumeBadUrlRemnants(source,offset)
type=BadUrl
return
case 0x0022:case 0x0027:case 0x0028:case NonPrintableCategory:offset=consumeBadUrlRemnants(source,offset)
type=BadUrl
return
case 0x005C:if(isValidEscape(code,getCharCode(offset+1))){offset=consumeEscaped(source,offset)-1
break}offset=consumeBadUrlRemnants(source,offset)
type=BadUrl
return}}}source=String(source||"")
const sourceLength=source.length
let start=isBOM(getCharCode(0))
let offset=start
let type
while(offset<sourceLength){const code=source.charCodeAt(offset)
switch(charCodeCategory(code)){case WhiteSpaceCategory:type=WhiteSpace$1
offset=findWhiteSpaceEnd(source,offset+1)
break
case 0x0022:consumeStringToken()
break
case 0x0023:if(isName(getCharCode(offset+1))||isValidEscape(getCharCode(offset+1),getCharCode(offset+2))){type=Hash$1
offset=consumeName(source,offset+1)}else{type=Delim
offset++}break
case 0x0027:consumeStringToken()
break
case 0x0028:type=LeftParenthesis
offset++
break
case 0x0029:type=RightParenthesis
offset++
break
case 0x002B:if(isNumberStart(code,getCharCode(offset+1),getCharCode(offset+2)))consumeNumericToken()
else{type=Delim
offset++}break
case 0x002C:type=Comma
offset++
break
case 0x002D:if(isNumberStart(code,getCharCode(offset+1),getCharCode(offset+2)))consumeNumericToken()
else if(getCharCode(offset+1)===0x002D&&getCharCode(offset+2)===0x003E){type=CDC$1
offset+=3}else if(isIdentifierStart(code,getCharCode(offset+1),getCharCode(offset+2)))consumeIdentLikeToken()
else{type=Delim
offset++}break
case 0x002E:if(isNumberStart(code,getCharCode(offset+1),getCharCode(offset+2)))consumeNumericToken()
else{type=Delim
offset++}break
case 0x002F:if(getCharCode(offset+1)===0x002A){type=Comment$1
offset=source.indexOf("*/",offset+2)
offset=offset===-1?source.length:offset+2}else{type=Delim
offset++}break
case 0x003A:type=Colon
offset++
break
case 0x003B:type=Semicolon
offset++
break
case 0x003C:if(getCharCode(offset+1)===0x0021&&getCharCode(offset+2)===0x002D&&getCharCode(offset+3)===0x002D){type=CDO$1
offset+=4}else{type=Delim
offset++}break
case 0x0040:if(isIdentifierStart(getCharCode(offset+1),getCharCode(offset+2),getCharCode(offset+3))){type=AtKeyword
offset=consumeName(source,offset+1)}else{type=Delim
offset++}break
case 0x005B:type=LeftSquareBracket
offset++
break
case 0x005C:if(isValidEscape(code,getCharCode(offset+1)))consumeIdentLikeToken()
else{type=Delim
offset++}break
case 0x005D:type=RightSquareBracket
offset++
break
case 0x007B:type=LeftCurlyBracket
offset++
break
case 0x007D:type=RightCurlyBracket
offset++
break
case DigitCategory:consumeNumericToken()
break
case NameStartCategory:consumeIdentLikeToken()
break
default:type=Delim
offset++}onToken(type,start,start=offset)}}let releasedCursors=null
class List{static createItem(data){return{prev:null,next:null,data:data}}constructor(){this.head=null
this.tail=null
this.cursor=null}createItem(data){return List.createItem(data)}allocateCursor(prev,next){let cursor
if(releasedCursors!==null){cursor=releasedCursors
releasedCursors=releasedCursors.cursor
cursor.prev=prev
cursor.next=next
cursor.cursor=this.cursor}else cursor={prev:prev,next:next,cursor:this.cursor}
this.cursor=cursor
return cursor}releaseCursor(){const{cursor:cursor}=this
this.cursor=cursor.cursor
cursor.prev=null
cursor.next=null
cursor.cursor=releasedCursors
releasedCursors=cursor}updateCursors(prevOld,prevNew,nextOld,nextNew){let{cursor:cursor}=this
while(cursor!==null){cursor.prev===prevOld&&(cursor.prev=prevNew)
cursor.next===nextOld&&(cursor.next=nextNew)
cursor=cursor.cursor}}*[Symbol.iterator](){for(let cursor=this.head;cursor!==null;cursor=cursor.next)yield cursor.data}get size(){let size=0
for(let cursor=this.head;cursor!==null;cursor=cursor.next)size++
return size}get isEmpty(){return this.head===null}get first(){return this.head&&this.head.data}get last(){return this.tail&&this.tail.data}fromArray(array){let cursor=null
this.head=null
for(let data of array){const item=List.createItem(data)
cursor!==null?cursor.next=item:this.head=item
item.prev=cursor
cursor=item}this.tail=cursor
return this}toArray(){return[...this]}toJSON(){return[...this]}forEach(fn,thisArg=this){const cursor=this.allocateCursor(null,this.head)
while(cursor.next!==null){const item=cursor.next
cursor.next=item.next
fn.call(thisArg,item.data,item,this)}this.releaseCursor()}forEachRight(fn,thisArg=this){const cursor=this.allocateCursor(this.tail,null)
while(cursor.prev!==null){const item=cursor.prev
cursor.prev=item.prev
fn.call(thisArg,item.data,item,this)}this.releaseCursor()}reduce(fn,initialValue,thisArg=this){let cursor=this.allocateCursor(null,this.head)
let acc=initialValue
let item
while(cursor.next!==null){item=cursor.next
cursor.next=item.next
acc=fn.call(thisArg,acc,item.data,item,this)}this.releaseCursor()
return acc}reduceRight(fn,initialValue,thisArg=this){let cursor=this.allocateCursor(this.tail,null)
let acc=initialValue
let item
while(cursor.prev!==null){item=cursor.prev
cursor.prev=item.prev
acc=fn.call(thisArg,acc,item.data,item,this)}this.releaseCursor()
return acc}some(fn,thisArg=this){for(let cursor=this.head;cursor!==null;cursor=cursor.next)if(fn.call(thisArg,cursor.data,cursor,this))return true
return false}map(fn,thisArg=this){const result=new List
for(let cursor=this.head;cursor!==null;cursor=cursor.next)result.appendData(fn.call(thisArg,cursor.data,cursor,this))
return result}filter(fn,thisArg=this){const result=new List
for(let cursor=this.head;cursor!==null;cursor=cursor.next)fn.call(thisArg,cursor.data,cursor,this)&&result.appendData(cursor.data)
return result}nextUntil(start,fn,thisArg=this){if(start===null)return
const cursor=this.allocateCursor(null,start)
while(cursor.next!==null){const item=cursor.next
cursor.next=item.next
if(fn.call(thisArg,item.data,item,this))break}this.releaseCursor()}prevUntil(start,fn,thisArg=this){if(start===null)return
const cursor=this.allocateCursor(start,null)
while(cursor.prev!==null){const item=cursor.prev
cursor.prev=item.prev
if(fn.call(thisArg,item.data,item,this))break}this.releaseCursor()}clear(){this.head=null
this.tail=null}copy(){const result=new List
for(let data of this)result.appendData(data)
return result}prepend(item){this.updateCursors(null,item,this.head,item)
if(this.head!==null){this.head.prev=item
item.next=this.head}else this.tail=item
this.head=item
return this}prependData(data){return this.prepend(List.createItem(data))}append(item){return this.insert(item)}appendData(data){return this.insert(List.createItem(data))}insert(item,before=null){if(before!==null){this.updateCursors(before.prev,item,before,item)
if(before.prev===null){if(this.head!==before)throw new Error("before doesn't belong to list")
this.head=item
before.prev=item
item.next=before
this.updateCursors(null,item)}else{before.prev.next=item
item.prev=before.prev
before.prev=item
item.next=before}}else{this.updateCursors(this.tail,item,null,item)
if(this.tail!==null){this.tail.next=item
item.prev=this.tail}else this.head=item
this.tail=item}return this}insertData(data,before){return this.insert(List.createItem(data),before)}remove(item){this.updateCursors(item,item.prev,item,item.next)
if(item.prev!==null)item.prev.next=item.next
else{if(this.head!==item)throw new Error("item doesn't belong to list")
this.head=item.next}if(item.next!==null)item.next.prev=item.prev
else{if(this.tail!==item)throw new Error("item doesn't belong to list")
this.tail=item.prev}item.prev=null
item.next=null
return item}push(data){this.insert(List.createItem(data))}pop(){return this.tail!==null?this.remove(this.tail):null}unshift(data){this.prepend(List.createItem(data))}shift(){return this.head!==null?this.remove(this.head):null}prependList(list){return this.insertList(list,this.head)}appendList(list){return this.insertList(list)}insertList(list,before){if(list.head===null)return this
if(before!==void 0&&before!==null){this.updateCursors(before.prev,list.tail,before,list.head)
if(before.prev!==null){before.prev.next=list.head
list.head.prev=before.prev}else this.head=list.head
before.prev=list.tail
list.tail.next=before}else{this.updateCursors(this.tail,list.tail,null,list.head)
if(this.tail!==null){this.tail.next=list.head
list.head.prev=this.tail}else this.head=list.head
this.tail=list.tail}list.head=null
list.tail=null
return this}replace(oldItem,newItemOrList){"head"in newItemOrList?this.insertList(newItemOrList,oldItem):this.insert(newItemOrList,oldItem)
this.remove(oldItem)}}function createCustomError(name,message){const error=Object.create(SyntaxError.prototype)
const errorStack=new Error
return Object.assign(error,{name:name,message:message,get stack(){return(errorStack.stack||"").replace(/^(.+\n){1,3}/,`${name}: ${message}\n`)}})}const MAX_LINE_LENGTH=100
const OFFSET_CORRECTION=60
const TAB_REPLACEMENT="    "
function sourceFragment({source:source,line:line,column:column},extraLines){function processLines(start,end){return lines.slice(start,end).map(((line,idx)=>String(start+idx+1).padStart(maxNumLength)+" |"+line)).join("\n")}const lines=source.split(/\r\n?|\n|\f/)
const startLine=Math.max(1,line-extraLines)-1
const endLine=Math.min(line+extraLines,lines.length+1)
const maxNumLength=Math.max(4,String(endLine).length)+1
let cutLeft=0
column+=(TAB_REPLACEMENT.length-1)*(lines[line-1].substr(0,column-1).match(/\t/g)||[]).length
if(column>MAX_LINE_LENGTH){cutLeft=column-OFFSET_CORRECTION+3
column=OFFSET_CORRECTION-2}for(let i=startLine;i<=endLine;i++)if(i>=0&&i<lines.length){lines[i]=lines[i].replace(/\t/g,TAB_REPLACEMENT)
lines[i]=(cutLeft>0&&lines[i].length>cutLeft?"…":"")+lines[i].substr(cutLeft,MAX_LINE_LENGTH-2)+(lines[i].length>cutLeft+MAX_LINE_LENGTH-1?"…":"")}return[processLines(startLine,line),new Array(column+maxNumLength+2).join("-")+"^",processLines(line,endLine)].filter(Boolean).join("\n")}function SyntaxError$2(message,source,offset,line,column){const error=Object.assign(createCustomError("SyntaxError",message),{source:source,offset:offset,line:line,column:column,sourceFragment:extraLines=>sourceFragment({source:source,line:line,column:column},isNaN(extraLines)?0:extraLines),get formattedMessage(){return`Parse error: ${message}\n`+sourceFragment({source:source,line:line,column:column},2)}})
return error}function readSequence$1(recognizer){const children=this.createList()
let space=false
const context={recognizer:recognizer}
while(!this.eof){switch(this.tokenType){case Comment$1:this.next()
continue
case WhiteSpace$1:space=true
this.next()
continue}let child=recognizer.getNode.call(this,context)
if(child===void 0)break
if(space){recognizer.onWhiteSpace&&recognizer.onWhiteSpace.call(this,child,children,context)
space=false}children.push(child)}space&&recognizer.onWhiteSpace&&recognizer.onWhiteSpace.call(this,null,children,context)
return children}const NOOP=()=>{}
const EXCLAMATIONMARK$3=0x0021
const NUMBERSIGN$4=0x0023
const SEMICOLON=0x003B
const LEFTCURLYBRACKET$1=0x007B
const NULL=0
function createParseContext(name){return function(){return this[name]()}}function fetchParseValues(dict){const result=Object.create(null)
for(const name in dict){const item=dict[name]
const fn=item.parse||item
fn&&(result[name]=fn)}return result}function processConfig(config){const parseConfig={context:Object.create(null),scope:Object.assign(Object.create(null),config.scope),atrule:fetchParseValues(config.atrule),pseudo:fetchParseValues(config.pseudo),node:fetchParseValues(config.node)}
for(const name in config.parseContext)switch(typeof config.parseContext[name]){case"function":parseConfig.context[name]=config.parseContext[name]
break
case"string":parseConfig.context[name]=createParseContext(config.parseContext[name])
break}return{config:parseConfig,...parseConfig,...parseConfig.node}}function createParser(config){let source=""
let filename="<unknown>"
let needPositions=false
let onParseError=NOOP
let onParseErrorThrow=false
const locationMap=new OffsetToLocation
const parser=Object.assign(new TokenStream,processConfig(config||{}),{parseAtrulePrelude:true,parseRulePrelude:true,parseValue:true,parseCustomProperty:false,readSequence:readSequence$1,consumeUntilBalanceEnd:()=>0,consumeUntilLeftCurlyBracket:code=>code===LEFTCURLYBRACKET$1?1:0,consumeUntilLeftCurlyBracketOrSemicolon:code=>code===LEFTCURLYBRACKET$1||code===SEMICOLON?1:0,consumeUntilExclamationMarkOrSemicolon:code=>code===EXCLAMATIONMARK$3||code===SEMICOLON?1:0,consumeUntilSemicolonIncluded:code=>code===SEMICOLON?2:0,createList:()=>new List,createSingleNodeList:node=>(new List).appendData(node),getFirstListNode:list=>list&&list.first,getLastListNode:list=>list&&list.last,parseWithFallback(consumer,fallback){const startToken=this.tokenIndex
try{return consumer.call(this)}catch(e){if(onParseErrorThrow)throw e
const fallbackNode=fallback.call(this,startToken)
onParseErrorThrow=true
onParseError(e,fallbackNode)
onParseErrorThrow=false
return fallbackNode}},lookupNonWSType(offset){let type
do{type=this.lookupType(offset++)
if(type!==WhiteSpace$1)return type}while(type!==NULL)
return NULL},charCodeAt:offset=>offset>=0&&offset<source.length?source.charCodeAt(offset):0,substring:(offsetStart,offsetEnd)=>source.substring(offsetStart,offsetEnd),substrToCursor(start){return this.source.substring(start,this.tokenStart)},cmpChar:(offset,charCode)=>cmpChar(source,offset,charCode),cmpStr:(offsetStart,offsetEnd,str)=>cmpStr(source,offsetStart,offsetEnd,str),consume(tokenType){const start=this.tokenStart
this.eat(tokenType)
return this.substrToCursor(start)},consumeFunctionName(){const name=source.substring(this.tokenStart,this.tokenEnd-1)
this.eat(Function$1)
return name},consumeNumber(type){const number=source.substring(this.tokenStart,consumeNumber$1(source,this.tokenStart))
this.eat(type)
return number},eat(tokenType){if(this.tokenType!==tokenType){const tokenName=tokenNames[tokenType].slice(0,-6).replace(/-/g," ").replace(/^./,(m=>m.toUpperCase()))
let message=`${/[[\](){}]/.test(tokenName)?`"${tokenName}"`:tokenName} is expected`
let offset=this.tokenStart
switch(tokenType){case Ident:if(this.tokenType===Function$1||this.tokenType===Url$2){offset=this.tokenEnd-1
message="Identifier is expected but function found"}else message="Identifier is expected"
break
case Hash$1:if(this.isDelim(NUMBERSIGN$4)){this.next()
offset++
message="Name is expected"}break
case Percentage$1:if(this.tokenType===Number$3){offset=this.tokenEnd
message="Percent sign is expected"}break}this.error(message,offset)}this.next()},eatIdent(name){this.tokenType===Ident&&this.lookupValue(0,name)!==false||this.error(`Identifier "${name}" is expected`)
this.next()},eatDelim(code){this.isDelim(code)||this.error(`Delim "${String.fromCharCode(code)}" is expected`)
this.next()},getLocation(start,end){if(needPositions)return locationMap.getLocationRange(start,end,filename)
return null},getLocationFromList(list){if(needPositions){const head=this.getFirstListNode(list)
const tail=this.getLastListNode(list)
return locationMap.getLocationRange(head!==null?head.loc.start.offset-locationMap.startOffset:this.tokenStart,tail!==null?tail.loc.end.offset-locationMap.startOffset:this.tokenStart,filename)}return null},error(message,offset){const location=typeof offset!=="undefined"&&offset<source.length?locationMap.getLocation(offset):this.eof?locationMap.getLocation(findWhiteSpaceStart(source,source.length-1)):locationMap.getLocation(this.tokenStart)
throw new SyntaxError$2(message||"Unexpected input",source,location.offset,location.line,location.column)}})
const parse=function(source_,options){source=source_
options=options||{}
parser.setSource(source,tokenize$2)
locationMap.setSource(source,options.offset,options.line,options.column)
filename=options.filename||"<unknown>"
needPositions=Boolean(options.positions)
onParseError=typeof options.onParseError==="function"?options.onParseError:NOOP
onParseErrorThrow=false
parser.parseAtrulePrelude=!("parseAtrulePrelude"in options)||Boolean(options.parseAtrulePrelude)
parser.parseRulePrelude=!("parseRulePrelude"in options)||Boolean(options.parseRulePrelude)
parser.parseValue=!("parseValue"in options)||Boolean(options.parseValue)
parser.parseCustomProperty="parseCustomProperty"in options&&Boolean(options.parseCustomProperty)
const{context:context="default",onComment:onComment}=options
if(context in parser.context===false)throw new Error("Unknown context `"+context+"`")
typeof onComment==="function"&&parser.forEachToken(((type,start,end)=>{if(type===Comment$1){const loc=parser.getLocation(start,end)
const value=cmpStr(source,end-2,end,"*/")?source.slice(start+2,end-2):source.slice(start+2,end)
onComment(value,loc)}}))
const ast=parser.context[context].call(parser,options)
parser.eof||parser.error()
return ast}
return Object.assign(parse,{SyntaxError:SyntaxError$2,config:parser.config})}const trackNodes=new Set(["Atrule","Selector","Declaration"])
function generateSourceMap(handlers){const map=new SourceMapGenerator_1
const generated={line:1,column:0}
const original={line:0,column:0}
const activatedGenerated={line:1,column:0}
const activatedMapping={generated:activatedGenerated}
let line=1
let column=0
let sourceMappingActive=false
const origHandlersNode=handlers.node
handlers.node=function(node){if(node.loc&&node.loc.start&&trackNodes.has(node.type)){const nodeLine=node.loc.start.line
const nodeColumn=node.loc.start.column-1
if(original.line!==nodeLine||original.column!==nodeColumn){original.line=nodeLine
original.column=nodeColumn
generated.line=line
generated.column=column
if(sourceMappingActive){sourceMappingActive=false
generated.line===activatedGenerated.line&&generated.column===activatedGenerated.column||map.addMapping(activatedMapping)}sourceMappingActive=true
map.addMapping({source:node.loc.source,original:original,generated:generated})}}origHandlersNode.call(this,node)
if(sourceMappingActive&&trackNodes.has(node.type)){activatedGenerated.line=line
activatedGenerated.column=column}}
const origHandlersEmit=handlers.emit
handlers.emit=function(value,type,auto){for(let i=0;i<value.length;i++)if(value.charCodeAt(i)===10){line++
column=0}else column++
origHandlersEmit(value,type,auto)}
const origHandlersResult=handlers.result
handlers.result=function(){sourceMappingActive&&map.addMapping(activatedMapping)
return{css:origHandlersResult(),map:map}}
return handlers}const PLUSSIGN$9=0x002B
const HYPHENMINUS$6=0x002D
const code=(type,value)=>{type===Delim&&(type=value)
if(typeof type==="string"){const charCode=type.charCodeAt(0)
return charCode>0x7F?0x8000:charCode<<8}return type}
const specPairs=[[Ident,Ident],[Ident,Function$1],[Ident,Url$2],[Ident,BadUrl],[Ident,"-"],[Ident,Number$3],[Ident,Percentage$1],[Ident,Dimension$1],[Ident,CDC$1],[Ident,LeftParenthesis],[AtKeyword,Ident],[AtKeyword,Function$1],[AtKeyword,Url$2],[AtKeyword,BadUrl],[AtKeyword,"-"],[AtKeyword,Number$3],[AtKeyword,Percentage$1],[AtKeyword,Dimension$1],[AtKeyword,CDC$1],[Hash$1,Ident],[Hash$1,Function$1],[Hash$1,Url$2],[Hash$1,BadUrl],[Hash$1,"-"],[Hash$1,Number$3],[Hash$1,Percentage$1],[Hash$1,Dimension$1],[Hash$1,CDC$1],[Dimension$1,Ident],[Dimension$1,Function$1],[Dimension$1,Url$2],[Dimension$1,BadUrl],[Dimension$1,"-"],[Dimension$1,Number$3],[Dimension$1,Percentage$1],[Dimension$1,Dimension$1],[Dimension$1,CDC$1],["#",Ident],["#",Function$1],["#",Url$2],["#",BadUrl],["#","-"],["#",Number$3],["#",Percentage$1],["#",Dimension$1],["#",CDC$1],["-",Ident],["-",Function$1],["-",Url$2],["-",BadUrl],["-","-"],["-",Number$3],["-",Percentage$1],["-",Dimension$1],["-",CDC$1],[Number$3,Ident],[Number$3,Function$1],[Number$3,Url$2],[Number$3,BadUrl],[Number$3,Number$3],[Number$3,Percentage$1],[Number$3,Dimension$1],[Number$3,"%"],[Number$3,CDC$1],["@",Ident],["@",Function$1],["@",Url$2],["@",BadUrl],["@","-"],["@",CDC$1],[".",Number$3],[".",Percentage$1],[".",Dimension$1],["+",Number$3],["+",Percentage$1],["+",Dimension$1],["/","*"]]
const safePairs=specPairs.concat([[Ident,Hash$1],[Dimension$1,Hash$1],[Hash$1,Hash$1],[AtKeyword,LeftParenthesis],[AtKeyword,String$2],[AtKeyword,Colon],[Percentage$1,Percentage$1],[Percentage$1,Dimension$1],[Percentage$1,Function$1],[Percentage$1,"-"],[RightParenthesis,Ident],[RightParenthesis,Function$1],[RightParenthesis,Percentage$1],[RightParenthesis,Dimension$1],[RightParenthesis,Hash$1],[RightParenthesis,"-"]])
function createMap(pairs){const isWhiteSpaceRequired=new Set(pairs.map((([prev,next])=>code(prev)<<16|code(next))))
return function(prevCode,type,value){const nextCode=code(type,value)
const nextCharCode=value.charCodeAt(0)
const emitWs=nextCharCode===HYPHENMINUS$6&&type!==Ident&&type!==Function$1&&type!==CDC$1||nextCharCode===PLUSSIGN$9?isWhiteSpaceRequired.has(prevCode<<16|nextCharCode<<8):isWhiteSpaceRequired.has(prevCode<<16|nextCode)
emitWs&&this.emit(" ",WhiteSpace$1,true)
return nextCode}}const spec=createMap(specPairs)
const safe=createMap(safePairs)
var tokenBefore=Object.freeze({__proto__:null,safe:safe,spec:spec})
const REVERSESOLIDUS=0x005c
function processChildren(node,delimeter){if(typeof delimeter==="function"){let prev=null
node.children.forEach((node=>{prev!==null&&delimeter.call(this,prev)
this.node(node)
prev=node}))
return}node.children.forEach(this.node,this)}function processChunk(chunk){tokenize$2(chunk,((type,start,end)=>{this.token(type,chunk.slice(start,end))}))}function createGenerator(config){const types=new Map
for(let name in config.node){const item=config.node[name]
const fn=item.generate||item
typeof fn==="function"&&types.set(name,item.generate||item)}return function(node,options){let buffer=""
let prevCode=0
let handlers={node(node){if(!types.has(node.type))throw new Error("Unknown node type: "+node.type)
types.get(node.type).call(publicApi,node)},tokenBefore:safe,token(type,value){prevCode=this.tokenBefore(prevCode,type,value)
this.emit(value,type,false)
type===Delim&&value.charCodeAt(0)===REVERSESOLIDUS&&this.emit("\n",WhiteSpace$1,true)},emit(value){buffer+=value},result:()=>buffer}
if(options){typeof options.decorator==="function"&&(handlers=options.decorator(handlers))
options.sourceMap&&(handlers=generateSourceMap(handlers))
options.mode in tokenBefore&&(handlers.tokenBefore=tokenBefore[options.mode])}const publicApi={node:node=>handlers.node(node),children:processChildren,token:(type,value)=>handlers.token(type,value),tokenize:processChunk}
handlers.node(node)
return handlers.result()}}function createConvertor(walk){return{fromPlainObject(ast){walk(ast,{enter(node){node.children&&node.children instanceof List===false&&(node.children=(new List).fromArray(node.children))}})
return ast},toPlainObject(ast){walk(ast,{leave(node){node.children&&node.children instanceof List&&(node.children=node.children.toArray())}})
return ast}}}const{hasOwnProperty:hasOwnProperty$8}=Object.prototype
const noop$2=function(){}
function ensureFunction$1(value){return typeof value==="function"?value:noop$2}function invokeForType(fn,type){return function(node,item,list){node.type===type&&fn.call(this,node,item,list)}}function getWalkersFromStructure(name,nodeType){const structure=nodeType.structure
const walkers=[]
for(const key in structure){if(hasOwnProperty$8.call(structure,key)===false)continue
let fieldTypes=structure[key]
const walker={name:key,type:false,nullable:false}
Array.isArray(fieldTypes)||(fieldTypes=[fieldTypes])
for(const fieldType of fieldTypes)fieldType===null?walker.nullable=true:typeof fieldType==="string"?walker.type="node":Array.isArray(fieldType)&&(walker.type="list")
walker.type&&walkers.push(walker)}if(walkers.length)return{context:nodeType.walkContext,fields:walkers}
return null}function getTypesFromConfig(config){const types={}
for(const name in config.node)if(hasOwnProperty$8.call(config.node,name)){const nodeType=config.node[name]
if(!nodeType.structure)throw new Error("Missed `structure` field in `"+name+"` node type definition")
types[name]=getWalkersFromStructure(name,nodeType)}return types}function createTypeIterator(config,reverse){const fields=config.fields.slice()
const contextName=config.context
const useContext=typeof contextName==="string"
reverse&&fields.reverse()
return function(node,context,walk,walkReducer){let prevContextValue
if(useContext){prevContextValue=context[contextName]
context[contextName]=node}for(const field of fields){const ref=node[field.name]
if(!field.nullable||ref)if(field.type==="list"){const breakWalk=reverse?ref.reduceRight(walkReducer,false):ref.reduce(walkReducer,false)
if(breakWalk)return true}else if(walk(ref))return true}useContext&&(context[contextName]=prevContextValue)}}function createFastTraveralMap({StyleSheet:StyleSheet,Atrule:Atrule,Rule:Rule,Block:Block,DeclarationList:DeclarationList}){return{Atrule:{StyleSheet:StyleSheet,Atrule:Atrule,Rule:Rule,Block:Block},Rule:{StyleSheet:StyleSheet,Atrule:Atrule,Rule:Rule,Block:Block},Declaration:{StyleSheet:StyleSheet,Atrule:Atrule,Rule:Rule,Block:Block,DeclarationList:DeclarationList}}}function createWalker(config){const types=getTypesFromConfig(config)
const iteratorsNatural={}
const iteratorsReverse={}
const breakWalk=Symbol("break-walk")
const skipNode=Symbol("skip-node")
for(const name in types)if(hasOwnProperty$8.call(types,name)&&types[name]!==null){iteratorsNatural[name]=createTypeIterator(types[name],false)
iteratorsReverse[name]=createTypeIterator(types[name],true)}const fastTraversalIteratorsNatural=createFastTraveralMap(iteratorsNatural)
const fastTraversalIteratorsReverse=createFastTraveralMap(iteratorsReverse)
const walk=function(root,options){function walkNode(node,item,list){const enterRet=enter.call(context,node,item,list)
if(enterRet===breakWalk)return true
if(enterRet===skipNode)return false
if(iterators.hasOwnProperty(node.type)&&iterators[node.type](node,context,walkNode,walkReducer))return true
if(leave.call(context,node,item,list)===breakWalk)return true
return false}let enter=noop$2
let leave=noop$2
let iterators=iteratorsNatural
let walkReducer=(ret,data,item,list)=>ret||walkNode(data,item,list)
const context={break:breakWalk,skip:skipNode,root:root,stylesheet:null,atrule:null,atrulePrelude:null,rule:null,selector:null,block:null,declaration:null,function:null}
if(typeof options==="function")enter=options
else if(options){enter=ensureFunction$1(options.enter)
leave=ensureFunction$1(options.leave)
options.reverse&&(iterators=iteratorsReverse)
if(options.visit){if(fastTraversalIteratorsNatural.hasOwnProperty(options.visit))iterators=options.reverse?fastTraversalIteratorsReverse[options.visit]:fastTraversalIteratorsNatural[options.visit]
else if(!types.hasOwnProperty(options.visit))throw new Error("Bad value `"+options.visit+"` for `visit` option (should be: "+Object.keys(types).sort().join(", ")+")")
enter=invokeForType(enter,options.visit)
leave=invokeForType(leave,options.visit)}}if(enter===noop$2&&leave===noop$2)throw new Error("Neither `enter` nor `leave` walker handler is set or both aren't a function")
walkNode(root)}
walk.break=breakWalk
walk.skip=skipNode
walk.find=function(ast,fn){let found=null
walk(ast,(function(node,item,list){if(fn.call(this,node,item,list)){found=node
return breakWalk}}))
return found}
walk.findLast=function(ast,fn){let found=null
walk(ast,{reverse:true,enter(node,item,list){if(fn.call(this,node,item,list)){found=node
return breakWalk}}})
return found}
walk.findAll=function(ast,fn){const found=[]
walk(ast,(function(node,item,list){fn.call(this,node,item,list)&&found.push(node)}))
return found}
return walk}function noop$1(value){return value}function generateMultiplier(multiplier){const{min:min,max:max,comma:comma}=multiplier
if(min===0&&max===0)return comma?"#?":"*"
if(min===0&&max===1)return"?"
if(min===1&&max===0)return comma?"#":"+"
if(min===1&&max===1)return""
return(comma?"#":"")+(min===max?"{"+min+"}":"{"+min+","+(max!==0?max:"")+"}")}function generateTypeOpts(node){switch(node.type){case"Range":return" ["+(node.min===null?"-∞":node.min)+","+(node.max===null?"∞":node.max)+"]"
default:throw new Error("Unknown node type `"+node.type+"`")}}function generateSequence(node,decorate,forceBraces,compact){const combinator=node.combinator===" "||compact?node.combinator:" "+node.combinator+" "
const result=node.terms.map((term=>internalGenerate(term,decorate,forceBraces,compact))).join(combinator)
if(node.explicit||forceBraces)return(compact||result[0]===","?"[":"[ ")+result+(compact?"]":" ]")
return result}function internalGenerate(node,decorate,forceBraces,compact){let result
switch(node.type){case"Group":result=generateSequence(node,decorate,forceBraces,compact)+(node.disallowEmpty?"!":"")
break
case"Multiplier":return internalGenerate(node.term,decorate,forceBraces,compact)+decorate(generateMultiplier(node),node)
case"Type":result="<"+node.name+(node.opts?decorate(generateTypeOpts(node.opts),node.opts):"")+">"
break
case"Property":result="<'"+node.name+"'>"
break
case"Keyword":result=node.name
break
case"AtKeyword":result="@"+node.name
break
case"Function":result=node.name+"("
break
case"String":case"Token":result=node.value
break
case"Comma":result=","
break
default:throw new Error("Unknown node type `"+node.type+"`")}return decorate(result,node)}function generate$H(node,options){let decorate=noop$1
let forceBraces=false
let compact=false
if(typeof options==="function")decorate=options
else if(options){forceBraces=Boolean(options.forceBraces)
compact=Boolean(options.compact)
typeof options.decorate==="function"&&(decorate=options.decorate)}return internalGenerate(node,decorate,forceBraces,compact)}const defaultLoc={offset:0,line:1,column:1}
function locateMismatch(matchResult,node){const tokens=matchResult.tokens
const longestMatch=matchResult.longestMatch
const mismatchNode=longestMatch<tokens.length&&tokens[longestMatch].node||null
const badNode=mismatchNode!==node?mismatchNode:null
let mismatchOffset=0
let mismatchLength=0
let entries=0
let css=""
let start
let end
for(let i=0;i<tokens.length;i++){const token=tokens[i].value
if(i===longestMatch){mismatchLength=token.length
mismatchOffset=css.length}badNode!==null&&tokens[i].node===badNode&&(i<=longestMatch?entries++:entries=0)
css+=token}if(longestMatch===tokens.length||entries>1){start=fromLoc(badNode||node,"end")||buildLoc(defaultLoc,css)
end=buildLoc(start)}else{start=fromLoc(badNode,"start")||buildLoc(fromLoc(node,"start")||defaultLoc,css.slice(0,mismatchOffset))
end=fromLoc(badNode,"end")||buildLoc(start,css.substr(mismatchOffset,mismatchLength))}return{css:css,mismatchOffset:mismatchOffset,mismatchLength:mismatchLength,start:start,end:end}}function fromLoc(node,point){const value=node&&node.loc&&node.loc[point]
if(value)return"line"in value?buildLoc(value):value
return null}function buildLoc({offset:offset,line:line,column:column},extra){const loc={offset:offset,line:line,column:column}
if(extra){const lines=extra.split(/\n|\r\n?|\f/)
loc.offset+=extra.length
loc.line+=lines.length-1
loc.column=lines.length===1?loc.column+extra.length:lines.pop().length+1}return loc}const SyntaxReferenceError=function(type,referenceName){const error=createCustomError("SyntaxReferenceError",type+(referenceName?" `"+referenceName+"`":""))
error.reference=referenceName
return error}
const SyntaxMatchError=function(message,syntax,node,matchResult){const error=createCustomError("SyntaxMatchError",message)
const{css:css,mismatchOffset:mismatchOffset,mismatchLength:mismatchLength,start:start,end:end}=locateMismatch(matchResult,node)
error.rawMessage=message
error.syntax=syntax?generate$H(syntax):"<generic>"
error.css=css
error.mismatchOffset=mismatchOffset
error.mismatchLength=mismatchLength
error.message=message+"\n  syntax: "+error.syntax+"\n   value: "+(css||"<empty string>")+"\n  --------"+new Array(error.mismatchOffset+1).join("-")+"^"
Object.assign(error,start)
error.loc={source:node&&node.loc&&node.loc.source||"<unknown>",start:start,end:end}
return error}
const keywords=new Map
const properties=new Map
const HYPHENMINUS$5=45
const keyword=getKeywordDescriptor
const property=getPropertyDescriptor
function isCustomProperty(str,offset){offset=offset||0
return str.length-offset>=2&&str.charCodeAt(offset)===HYPHENMINUS$5&&str.charCodeAt(offset+1)===HYPHENMINUS$5}function getVendorPrefix(str,offset){offset=offset||0
if(str.length-offset>=3&&str.charCodeAt(offset)===HYPHENMINUS$5&&str.charCodeAt(offset+1)!==HYPHENMINUS$5){const secondDashIndex=str.indexOf("-",offset+2)
if(secondDashIndex!==-1)return str.substring(offset,secondDashIndex+1)}return""}function getKeywordDescriptor(keyword){if(keywords.has(keyword))return keywords.get(keyword)
const name=keyword.toLowerCase()
let descriptor=keywords.get(name)
if(descriptor===void 0){const custom=isCustomProperty(name,0)
const vendor=custom?"":getVendorPrefix(name,0)
descriptor=Object.freeze({basename:name.substr(vendor.length),name:name,prefix:vendor,vendor:vendor,custom:custom})}keywords.set(keyword,descriptor)
return descriptor}function getPropertyDescriptor(property){if(properties.has(property))return properties.get(property)
let name=property
let hack=property[0]
hack==="/"?hack=property[1]==="/"?"//":"/":hack!=="_"&&hack!=="*"&&hack!=="$"&&hack!=="#"&&hack!=="+"&&hack!=="&"&&(hack="")
const custom=isCustomProperty(name,hack.length)
if(!custom){name=name.toLowerCase()
if(properties.has(name)){const descriptor=properties.get(name)
properties.set(property,descriptor)
return descriptor}}const vendor=custom?"":getVendorPrefix(name,hack.length)
const prefix=name.substr(0,hack.length+vendor.length)
const descriptor=Object.freeze({basename:name.substr(prefix.length),name:name.substr(hack.length),hack:hack,vendor:vendor,prefix:prefix,custom:custom})
properties.set(property,descriptor)
return descriptor}const cssWideKeywords=["initial","inherit","unset","revert","revert-layer"]
const PLUSSIGN$8=0x002B
const HYPHENMINUS$4=0x002D
const N$3=0x006E
const DISALLOW_SIGN$1=true
const ALLOW_SIGN$1=false
function isDelim$1(token,code){return token!==null&&token.type===Delim&&token.value.charCodeAt(0)===code}function skipSC(token,offset,getNextToken){while(token!==null&&(token.type===WhiteSpace$1||token.type===Comment$1))token=getNextToken(++offset)
return offset}function checkInteger$1(token,valueOffset,disallowSign,offset){if(!token)return 0
const code=token.value.charCodeAt(valueOffset)
if(code===PLUSSIGN$8||code===HYPHENMINUS$4){if(disallowSign)return 0
valueOffset++}for(;valueOffset<token.value.length;valueOffset++)if(!isDigit$1(token.value.charCodeAt(valueOffset)))return 0
return offset+1}function consumeB$1(token,offset_,getNextToken){let sign=false
let offset=skipSC(token,offset_,getNextToken)
token=getNextToken(offset)
if(token===null)return offset_
if(token.type!==Number$3){if(!isDelim$1(token,PLUSSIGN$8)&&!isDelim$1(token,HYPHENMINUS$4))return offset_
sign=true
offset=skipSC(getNextToken(++offset),offset,getNextToken)
token=getNextToken(offset)
if(token===null||token.type!==Number$3)return 0}if(!sign){const code=token.value.charCodeAt(0)
if(code!==PLUSSIGN$8&&code!==HYPHENMINUS$4)return 0}return checkInteger$1(token,sign?0:1,sign,offset)}function anPlusB(token,getNextToken){let offset=0
if(!token)return 0
if(token.type===Number$3)return checkInteger$1(token,0,ALLOW_SIGN$1,offset)
if(token.type===Ident&&token.value.charCodeAt(0)===HYPHENMINUS$4){if(!cmpChar(token.value,1,N$3))return 0
switch(token.value.length){case 2:return consumeB$1(getNextToken(++offset),offset,getNextToken)
case 3:if(token.value.charCodeAt(2)!==HYPHENMINUS$4)return 0
offset=skipSC(getNextToken(++offset),offset,getNextToken)
token=getNextToken(offset)
return checkInteger$1(token,0,DISALLOW_SIGN$1,offset)
default:if(token.value.charCodeAt(2)!==HYPHENMINUS$4)return 0
return checkInteger$1(token,3,DISALLOW_SIGN$1,offset)}}else if(token.type===Ident||isDelim$1(token,PLUSSIGN$8)&&getNextToken(offset+1).type===Ident){token.type!==Ident&&(token=getNextToken(++offset))
if(token===null||!cmpChar(token.value,0,N$3))return 0
switch(token.value.length){case 1:return consumeB$1(getNextToken(++offset),offset,getNextToken)
case 2:if(token.value.charCodeAt(1)!==HYPHENMINUS$4)return 0
offset=skipSC(getNextToken(++offset),offset,getNextToken)
token=getNextToken(offset)
return checkInteger$1(token,0,DISALLOW_SIGN$1,offset)
default:if(token.value.charCodeAt(1)!==HYPHENMINUS$4)return 0
return checkInteger$1(token,2,DISALLOW_SIGN$1,offset)}}else if(token.type===Dimension$1){let code=token.value.charCodeAt(0)
let sign=code===PLUSSIGN$8||code===HYPHENMINUS$4?1:0
let i=sign
for(;i<token.value.length;i++)if(!isDigit$1(token.value.charCodeAt(i)))break
if(i===sign)return 0
if(!cmpChar(token.value,i,N$3))return 0
if(i+1===token.value.length)return consumeB$1(getNextToken(++offset),offset,getNextToken)
if(token.value.charCodeAt(i+1)!==HYPHENMINUS$4)return 0
if(i+2===token.value.length){offset=skipSC(getNextToken(++offset),offset,getNextToken)
token=getNextToken(offset)
return checkInteger$1(token,0,DISALLOW_SIGN$1,offset)}return checkInteger$1(token,i+2,DISALLOW_SIGN$1,offset)}return 0}const PLUSSIGN$7=0x002B
const HYPHENMINUS$3=0x002D
const QUESTIONMARK$2=0x003F
const U$1=0x0075
function isDelim(token,code){return token!==null&&token.type===Delim&&token.value.charCodeAt(0)===code}function startsWith$1(token,code){return token.value.charCodeAt(0)===code}function hexSequence(token,offset,allowDash){let hexlen=0
for(let pos=offset;pos<token.value.length;pos++){const code=token.value.charCodeAt(pos)
if(code===HYPHENMINUS$3&&allowDash&&hexlen!==0){hexSequence(token,offset+hexlen+1,false)
return 6}if(!isHexDigit(code))return 0
if(++hexlen>6)return 0}return hexlen}function withQuestionMarkSequence(consumed,length,getNextToken){if(!consumed)return 0
while(isDelim(getNextToken(length),QUESTIONMARK$2)){if(++consumed>6)return 0
length++}return length}function urange(token,getNextToken){let length=0
if(token===null||token.type!==Ident||!cmpChar(token.value,0,U$1))return 0
token=getNextToken(++length)
if(token===null)return 0
if(isDelim(token,PLUSSIGN$7)){token=getNextToken(++length)
if(token===null)return 0
if(token.type===Ident)return withQuestionMarkSequence(hexSequence(token,0,true),++length,getNextToken)
if(isDelim(token,QUESTIONMARK$2))return withQuestionMarkSequence(1,++length,getNextToken)
return 0}if(token.type===Number$3){const consumedHexLength=hexSequence(token,1,true)
if(consumedHexLength===0)return 0
token=getNextToken(++length)
if(token===null)return length
if(token.type===Dimension$1||token.type===Number$3){if(!startsWith$1(token,HYPHENMINUS$3)||!hexSequence(token,1,false))return 0
return length+1}return withQuestionMarkSequence(consumedHexLength,length,getNextToken)}if(token.type===Dimension$1)return withQuestionMarkSequence(hexSequence(token,1,true),++length,getNextToken)
return 0}const calcFunctionNames=["calc(","-moz-calc(","-webkit-calc("]
const balancePair=new Map([[Function$1,RightParenthesis],[LeftParenthesis,RightParenthesis],[LeftSquareBracket,RightSquareBracket],[LeftCurlyBracket,RightCurlyBracket]])
const LENGTH=["cm","mm","q","in","pt","pc","px","em","rem","ex","rex","cap","rcap","ch","rch","ic","ric","lh","rlh","vw","svw","lvw","dvw","vh","svh","lvh","dvh","vi","svi","lvi","dvi","vb","svb","lvb","dvb","vmin","svmin","lvmin","dvmin","vmax","svmax","lvmax","dvmax","cqw","cqh","cqi","cqb","cqmin","cqmax"]
const ANGLE=["deg","grad","rad","turn"]
const TIME=["s","ms"]
const FREQUENCY=["hz","khz"]
const RESOLUTION=["dpi","dpcm","dppx","x"]
const FLEX=["fr"]
const DECIBEL=["db"]
const SEMITONES=["st"]
function charCodeAt(str,index){return index<str.length?str.charCodeAt(index):0}function eqStr(actual,expected){return cmpStr(actual,0,actual.length,expected)}function eqStrAny(actual,expected){for(let i=0;i<expected.length;i++)if(eqStr(actual,expected[i]))return true
return false}function isPostfixIeHack(str,offset){if(offset!==str.length-2)return false
return charCodeAt(str,offset)===0x005C&&isDigit$1(charCodeAt(str,offset+1))}function outOfRange(opts,value,numEnd){if(opts&&opts.type==="Range"){const num=Number(numEnd!==void 0&&numEnd!==value.length?value.substr(0,numEnd):value)
if(isNaN(num))return true
if(opts.min!==null&&num<opts.min&&typeof opts.min!=="string")return true
if(opts.max!==null&&num>opts.max&&typeof opts.max!=="string")return true}return false}function consumeFunction(token,getNextToken){let balanceCloseType=0
let balanceStash=[]
let length=0
scan:do{switch(token.type){case RightCurlyBracket:case RightParenthesis:case RightSquareBracket:if(token.type!==balanceCloseType)break scan
balanceCloseType=balanceStash.pop()
if(balanceStash.length===0){length++
break scan}break
case Function$1:case LeftParenthesis:case LeftSquareBracket:case LeftCurlyBracket:balanceStash.push(balanceCloseType)
balanceCloseType=balancePair.get(token.type)
break}length++}while(token=getNextToken(length))
return length}function calc(next){return function(token,getNextToken,opts){if(token===null)return 0
if(token.type===Function$1&&eqStrAny(token.value,calcFunctionNames))return consumeFunction(token,getNextToken)
return next(token,getNextToken,opts)}}function tokenType(expectedTokenType){return function(token){if(token===null||token.type!==expectedTokenType)return 0
return 1}}function customIdent(token){if(token===null||token.type!==Ident)return 0
const name=token.value.toLowerCase()
if(eqStrAny(name,cssWideKeywords))return 0
if(eqStr(name,"default"))return 0
return 1}function customPropertyName(token){if(token===null||token.type!==Ident)return 0
if(charCodeAt(token.value,0)!==0x002D||charCodeAt(token.value,1)!==0x002D)return 0
return 1}function hexColor(token){if(token===null||token.type!==Hash$1)return 0
const length=token.value.length
if(length!==4&&length!==5&&length!==7&&length!==9)return 0
for(let i=1;i<length;i++)if(!isHexDigit(charCodeAt(token.value,i)))return 0
return 1}function idSelector(token){if(token===null||token.type!==Hash$1)return 0
if(!isIdentifierStart(charCodeAt(token.value,1),charCodeAt(token.value,2),charCodeAt(token.value,3)))return 0
return 1}function declarationValue(token,getNextToken){if(!token)return 0
let balanceCloseType=0
let balanceStash=[]
let length=0
scan:do{switch(token.type){case BadString:case BadUrl:break scan
case RightCurlyBracket:case RightParenthesis:case RightSquareBracket:if(token.type!==balanceCloseType)break scan
balanceCloseType=balanceStash.pop()
break
case Semicolon:if(balanceCloseType===0)break scan
break
case Delim:if(balanceCloseType===0&&token.value==="!")break scan
break
case Function$1:case LeftParenthesis:case LeftSquareBracket:case LeftCurlyBracket:balanceStash.push(balanceCloseType)
balanceCloseType=balancePair.get(token.type)
break}length++}while(token=getNextToken(length))
return length}function anyValue(token,getNextToken){if(!token)return 0
let balanceCloseType=0
let balanceStash=[]
let length=0
scan:do{switch(token.type){case BadString:case BadUrl:break scan
case RightCurlyBracket:case RightParenthesis:case RightSquareBracket:if(token.type!==balanceCloseType)break scan
balanceCloseType=balanceStash.pop()
break
case Function$1:case LeftParenthesis:case LeftSquareBracket:case LeftCurlyBracket:balanceStash.push(balanceCloseType)
balanceCloseType=balancePair.get(token.type)
break}length++}while(token=getNextToken(length))
return length}function dimension(type){type&&(type=new Set(type))
return function(token,getNextToken,opts){if(token===null||token.type!==Dimension$1)return 0
const numberEnd=consumeNumber$1(token.value,0)
if(type!==null){const reverseSolidusOffset=token.value.indexOf("\\",numberEnd)
const unit=reverseSolidusOffset!==-1&&isPostfixIeHack(token.value,reverseSolidusOffset)?token.value.substring(numberEnd,reverseSolidusOffset):token.value.substr(numberEnd)
if(type.has(unit.toLowerCase())===false)return 0}if(outOfRange(opts,token.value,numberEnd))return 0
return 1}}function percentage(token,getNextToken,opts){if(token===null||token.type!==Percentage$1)return 0
if(outOfRange(opts,token.value,token.value.length-1))return 0
return 1}function zero(next){typeof next!=="function"&&(next=function(){return 0})
return function(token,getNextToken,opts){if(token!==null&&token.type===Number$3&&Number(token.value)===0)return 1
return next(token,getNextToken,opts)}}function number(token,getNextToken,opts){if(token===null)return 0
const numberEnd=consumeNumber$1(token.value,0)
const isNumber=numberEnd===token.value.length
if(!isNumber&&!isPostfixIeHack(token.value,numberEnd))return 0
if(outOfRange(opts,token.value,numberEnd))return 0
return 1}function integer(token,getNextToken,opts){if(token===null||token.type!==Number$3)return 0
let i=charCodeAt(token.value,0)===0x002B||charCodeAt(token.value,0)===0x002D?1:0
for(;i<token.value.length;i++)if(!isDigit$1(charCodeAt(token.value,i)))return 0
if(outOfRange(opts,token.value,i))return 0
return 1}var generic={"ident-token":tokenType(Ident),"function-token":tokenType(Function$1),"at-keyword-token":tokenType(AtKeyword),"hash-token":tokenType(Hash$1),"string-token":tokenType(String$2),"bad-string-token":tokenType(BadString),"url-token":tokenType(Url$2),"bad-url-token":tokenType(BadUrl),"delim-token":tokenType(Delim),"number-token":tokenType(Number$3),"percentage-token":tokenType(Percentage$1),"dimension-token":tokenType(Dimension$1),"whitespace-token":tokenType(WhiteSpace$1),"CDO-token":tokenType(CDO$1),"CDC-token":tokenType(CDC$1),"colon-token":tokenType(Colon),"semicolon-token":tokenType(Semicolon),"comma-token":tokenType(Comma),"[-token":tokenType(LeftSquareBracket),"]-token":tokenType(RightSquareBracket),"(-token":tokenType(LeftParenthesis),")-token":tokenType(RightParenthesis),"{-token":tokenType(LeftCurlyBracket),"}-token":tokenType(RightCurlyBracket),string:tokenType(String$2),ident:tokenType(Ident),"custom-ident":customIdent,"custom-property-name":customPropertyName,"hex-color":hexColor,"id-selector":idSelector,"an-plus-b":anPlusB,urange:urange,"declaration-value":declarationValue,"any-value":anyValue,dimension:calc(dimension(null)),angle:calc(dimension(ANGLE)),decibel:calc(dimension(DECIBEL)),frequency:calc(dimension(FREQUENCY)),flex:calc(dimension(FLEX)),length:calc(zero(dimension(LENGTH))),resolution:calc(dimension(RESOLUTION)),semitones:calc(dimension(SEMITONES)),time:calc(dimension(TIME)),percentage:calc(percentage),zero:zero(),number:calc(number),integer:calc(integer)}
function SyntaxError$1(message,input,offset){return Object.assign(createCustomError("SyntaxError",message),{input:input,offset:offset,rawMessage:message,message:message+"\n  "+input+"\n--"+new Array((offset||input.length)+1).join("-")+"^"})}const TAB$1=9
const N$2=10
const F$1=12
const R$1=13
const SPACE$3=32
class Tokenizer{constructor(str){this.str=str
this.pos=0}charCodeAt(pos){return pos<this.str.length?this.str.charCodeAt(pos):0}charCode(){return this.charCodeAt(this.pos)}nextCharCode(){return this.charCodeAt(this.pos+1)}nextNonWsCode(pos){return this.charCodeAt(this.findWsEnd(pos))}findWsEnd(pos){for(;pos<this.str.length;pos++){const code=this.str.charCodeAt(pos)
if(code!==R$1&&code!==N$2&&code!==F$1&&code!==SPACE$3&&code!==TAB$1)break}return pos}substringToPos(end){return this.str.substring(this.pos,this.pos=end)}eat(code){this.charCode()!==code&&this.error("Expect `"+String.fromCharCode(code)+"`")
this.pos++}peek(){return this.pos<this.str.length?this.str.charAt(this.pos++):""}error(message){throw new SyntaxError$1(message,this.str,this.pos)}}const TAB=9
const N$1=10
const F=12
const R=13
const SPACE$2=32
const EXCLAMATIONMARK$2=33
const NUMBERSIGN$3=35
const AMPERSAND$1=38
const APOSTROPHE$2=39
const LEFTPARENTHESIS$2=40
const RIGHTPARENTHESIS$2=41
const ASTERISK$6=42
const PLUSSIGN$6=43
const COMMA=44
const HYPERMINUS=45
const LESSTHANSIGN=60
const GREATERTHANSIGN$2=62
const QUESTIONMARK$1=63
const COMMERCIALAT=64
const LEFTSQUAREBRACKET=91
const RIGHTSQUAREBRACKET=93
const LEFTCURLYBRACKET=123
const VERTICALLINE$3=124
const RIGHTCURLYBRACKET=125
const INFINITY=8734
const NAME_CHAR=new Uint8Array(128).map(((_,idx)=>/[a-zA-Z0-9\-]/.test(String.fromCharCode(idx))?1:0))
const COMBINATOR_PRECEDENCE={" ":1,"&&":2,"||":3,"|":4}
function scanSpaces(tokenizer){return tokenizer.substringToPos(tokenizer.findWsEnd(tokenizer.pos))}function scanWord(tokenizer){let end=tokenizer.pos
for(;end<tokenizer.str.length;end++){const code=tokenizer.str.charCodeAt(end)
if(code>=128||NAME_CHAR[code]===0)break}tokenizer.pos===end&&tokenizer.error("Expect a keyword")
return tokenizer.substringToPos(end)}function scanNumber(tokenizer){let end=tokenizer.pos
for(;end<tokenizer.str.length;end++){const code=tokenizer.str.charCodeAt(end)
if(code<48||code>57)break}tokenizer.pos===end&&tokenizer.error("Expect a number")
return tokenizer.substringToPos(end)}function scanString(tokenizer){const end=tokenizer.str.indexOf("'",tokenizer.pos+1)
if(end===-1){tokenizer.pos=tokenizer.str.length
tokenizer.error("Expect an apostrophe")}return tokenizer.substringToPos(end+1)}function readMultiplierRange(tokenizer){let min=null
let max=null
tokenizer.eat(LEFTCURLYBRACKET)
min=scanNumber(tokenizer)
if(tokenizer.charCode()===COMMA){tokenizer.pos++
tokenizer.charCode()!==RIGHTCURLYBRACKET&&(max=scanNumber(tokenizer))}else max=min
tokenizer.eat(RIGHTCURLYBRACKET)
return{min:Number(min),max:max?Number(max):0}}function readMultiplier(tokenizer){let range=null
let comma=false
switch(tokenizer.charCode()){case ASTERISK$6:tokenizer.pos++
range={min:0,max:0}
break
case PLUSSIGN$6:tokenizer.pos++
range={min:1,max:0}
break
case QUESTIONMARK$1:tokenizer.pos++
range={min:0,max:1}
break
case NUMBERSIGN$3:tokenizer.pos++
comma=true
if(tokenizer.charCode()===LEFTCURLYBRACKET)range=readMultiplierRange(tokenizer)
else if(tokenizer.charCode()===QUESTIONMARK$1){tokenizer.pos++
range={min:0,max:0}}else range={min:1,max:0}
break
case LEFTCURLYBRACKET:range=readMultiplierRange(tokenizer)
break
default:return null}return{type:"Multiplier",comma:comma,min:range.min,max:range.max,term:null}}function maybeMultiplied(tokenizer,node){const multiplier=readMultiplier(tokenizer)
if(multiplier!==null){multiplier.term=node
if(tokenizer.charCode()===NUMBERSIGN$3&&tokenizer.charCodeAt(tokenizer.pos-1)===PLUSSIGN$6)return maybeMultiplied(tokenizer,multiplier)
return multiplier}return node}function maybeToken(tokenizer){const ch=tokenizer.peek()
if(ch==="")return null
return{type:"Token",value:ch}}function readProperty$1(tokenizer){let name
tokenizer.eat(LESSTHANSIGN)
tokenizer.eat(APOSTROPHE$2)
name=scanWord(tokenizer)
tokenizer.eat(APOSTROPHE$2)
tokenizer.eat(GREATERTHANSIGN$2)
return maybeMultiplied(tokenizer,{type:"Property",name:name})}function readTypeRange(tokenizer){let min=null
let max=null
let sign=1
tokenizer.eat(LEFTSQUAREBRACKET)
if(tokenizer.charCode()===HYPERMINUS){tokenizer.peek()
sign=-1}if(sign==-1&&tokenizer.charCode()===INFINITY)tokenizer.peek()
else{min=sign*Number(scanNumber(tokenizer))
NAME_CHAR[tokenizer.charCode()]!==0&&(min+=scanWord(tokenizer))}scanSpaces(tokenizer)
tokenizer.eat(COMMA)
scanSpaces(tokenizer)
if(tokenizer.charCode()===INFINITY)tokenizer.peek()
else{sign=1
if(tokenizer.charCode()===HYPERMINUS){tokenizer.peek()
sign=-1}max=sign*Number(scanNumber(tokenizer))
NAME_CHAR[tokenizer.charCode()]!==0&&(max+=scanWord(tokenizer))}tokenizer.eat(RIGHTSQUAREBRACKET)
return{type:"Range",min:min,max:max}}function readType(tokenizer){let name
let opts=null
tokenizer.eat(LESSTHANSIGN)
name=scanWord(tokenizer)
if(tokenizer.charCode()===LEFTPARENTHESIS$2&&tokenizer.nextCharCode()===RIGHTPARENTHESIS$2){tokenizer.pos+=2
name+="()"}if(tokenizer.charCodeAt(tokenizer.findWsEnd(tokenizer.pos))===LEFTSQUAREBRACKET){scanSpaces(tokenizer)
opts=readTypeRange(tokenizer)}tokenizer.eat(GREATERTHANSIGN$2)
return maybeMultiplied(tokenizer,{type:"Type",name:name,opts:opts})}function readKeywordOrFunction(tokenizer){const name=scanWord(tokenizer)
if(tokenizer.charCode()===LEFTPARENTHESIS$2){tokenizer.pos++
return{type:"Function",name:name}}return maybeMultiplied(tokenizer,{type:"Keyword",name:name})}function regroupTerms(terms,combinators){function createGroup(terms,combinator){return{type:"Group",terms:terms,combinator:combinator,disallowEmpty:false,explicit:false}}let combinator
combinators=Object.keys(combinators).sort(((a,b)=>COMBINATOR_PRECEDENCE[a]-COMBINATOR_PRECEDENCE[b]))
while(combinators.length>0){combinator=combinators.shift()
let i=0
let subgroupStart=0
for(;i<terms.length;i++){const term=terms[i]
if(term.type==="Combinator")if(term.value===combinator){subgroupStart===-1&&(subgroupStart=i-1)
terms.splice(i,1)
i--}else{if(subgroupStart!==-1&&i-subgroupStart>1){terms.splice(subgroupStart,i-subgroupStart,createGroup(terms.slice(subgroupStart,i),combinator))
i=subgroupStart+1}subgroupStart=-1}}subgroupStart!==-1&&combinators.length&&terms.splice(subgroupStart,i-subgroupStart,createGroup(terms.slice(subgroupStart,i),combinator))}return combinator}function readImplicitGroup(tokenizer){const terms=[]
const combinators={}
let token
let prevToken=null
let prevTokenPos=tokenizer.pos
while(token=peek(tokenizer))if(token.type!=="Spaces"){if(token.type==="Combinator"){if(prevToken===null||prevToken.type==="Combinator"){tokenizer.pos=prevTokenPos
tokenizer.error("Unexpected combinator")}combinators[token.value]=true}else if(prevToken!==null&&prevToken.type!=="Combinator"){combinators[" "]=true
terms.push({type:"Combinator",value:" "})}terms.push(token)
prevToken=token
prevTokenPos=tokenizer.pos}if(prevToken!==null&&prevToken.type==="Combinator"){tokenizer.pos-=prevTokenPos
tokenizer.error("Unexpected combinator")}return{type:"Group",terms:terms,combinator:regroupTerms(terms,combinators)||" ",disallowEmpty:false,explicit:false}}function readGroup(tokenizer){let result
tokenizer.eat(LEFTSQUAREBRACKET)
result=readImplicitGroup(tokenizer)
tokenizer.eat(RIGHTSQUAREBRACKET)
result.explicit=true
if(tokenizer.charCode()===EXCLAMATIONMARK$2){tokenizer.pos++
result.disallowEmpty=true}return result}function peek(tokenizer){let code=tokenizer.charCode()
if(code<128&&NAME_CHAR[code]===1)return readKeywordOrFunction(tokenizer)
switch(code){case RIGHTSQUAREBRACKET:break
case LEFTSQUAREBRACKET:return maybeMultiplied(tokenizer,readGroup(tokenizer))
case LESSTHANSIGN:return tokenizer.nextCharCode()===APOSTROPHE$2?readProperty$1(tokenizer):readType(tokenizer)
case VERTICALLINE$3:return{type:"Combinator",value:tokenizer.substringToPos(tokenizer.pos+(tokenizer.nextCharCode()===VERTICALLINE$3?2:1))}
case AMPERSAND$1:tokenizer.pos++
tokenizer.eat(AMPERSAND$1)
return{type:"Combinator",value:"&&"}
case COMMA:tokenizer.pos++
return{type:"Comma"}
case APOSTROPHE$2:return maybeMultiplied(tokenizer,{type:"String",value:scanString(tokenizer)})
case SPACE$2:case TAB:case N$1:case R:case F:return{type:"Spaces",value:scanSpaces(tokenizer)}
case COMMERCIALAT:code=tokenizer.nextCharCode()
if(code<128&&NAME_CHAR[code]===1){tokenizer.pos++
return{type:"AtKeyword",name:scanWord(tokenizer)}}return maybeToken(tokenizer)
case ASTERISK$6:case PLUSSIGN$6:case QUESTIONMARK$1:case NUMBERSIGN$3:case EXCLAMATIONMARK$2:break
case LEFTCURLYBRACKET:code=tokenizer.nextCharCode()
if(code<48||code>57)return maybeToken(tokenizer)
break
default:return maybeToken(tokenizer)}}function parse$H(source){const tokenizer=new Tokenizer(source)
const result=readImplicitGroup(tokenizer)
tokenizer.pos!==source.length&&tokenizer.error("Unexpected input")
if(result.terms.length===1&&result.terms[0].type==="Group")return result.terms[0]
return result}const noop=function(){}
function ensureFunction(value){return typeof value==="function"?value:noop}function walk$2(node,options,context){function walk(node){enter.call(context,node)
switch(node.type){case"Group":node.terms.forEach(walk)
break
case"Multiplier":walk(node.term)
break
case"Type":case"Property":case"Keyword":case"AtKeyword":case"Function":case"String":case"Token":case"Comma":break
default:throw new Error("Unknown type: "+node.type)}leave.call(context,node)}let enter=noop
let leave=noop
if(typeof options==="function")enter=options
else if(options){enter=ensureFunction(options.enter)
leave=ensureFunction(options.leave)}if(enter===noop&&leave===noop)throw new Error("Neither `enter` nor `leave` walker handler is set or both aren't a function")
walk(node)}const astToTokens={decorator(handlers){const tokens=[]
let curNode=null
return{...handlers,node(node){const tmp=curNode
curNode=node
handlers.node.call(this,node)
curNode=tmp},emit(value,type,auto){tokens.push({type:type,value:value,node:auto?null:curNode})},result:()=>tokens}}}
function stringToTokens(str){const tokens=[]
tokenize$2(str,((type,start,end)=>tokens.push({type:type,value:str.slice(start,end),node:null})))
return tokens}function prepareTokens(value,syntax){if(typeof value==="string")return stringToTokens(value)
return syntax.generate(value,astToTokens)}const MATCH={type:"Match"}
const MISMATCH={type:"Mismatch"}
const DISALLOW_EMPTY={type:"DisallowEmpty"}
const LEFTPARENTHESIS$1=40
const RIGHTPARENTHESIS$1=41
function createCondition(match,thenBranch,elseBranch){if(thenBranch===MATCH&&elseBranch===MISMATCH)return match
if(match===MATCH&&thenBranch===MATCH&&elseBranch===MATCH)return match
if(match.type==="If"&&match.else===MISMATCH&&thenBranch===MATCH){thenBranch=match.then
match=match.match}return{type:"If",match:match,then:thenBranch,else:elseBranch}}function isFunctionType(name){return name.length>2&&name.charCodeAt(name.length-2)===LEFTPARENTHESIS$1&&name.charCodeAt(name.length-1)===RIGHTPARENTHESIS$1}function isEnumCapatible(term){return term.type==="Keyword"||term.type==="AtKeyword"||term.type==="Function"||term.type==="Type"&&isFunctionType(term.name)}function buildGroupMatchGraph(combinator,terms,atLeastOneTermMatched){switch(combinator){case" ":{let result=MATCH
for(let i=terms.length-1;i>=0;i--){const term=terms[i]
result=createCondition(term,result,MISMATCH)}return result}case"|":{let result=MISMATCH
let map=null
for(let i=terms.length-1;i>=0;i--){let term=terms[i]
if(isEnumCapatible(term)){if(map===null&&i>0&&isEnumCapatible(terms[i-1])){map=Object.create(null)
result=createCondition({type:"Enum",map:map},MATCH,result)}if(map!==null){const key=(isFunctionType(term.name)?term.name.slice(0,-1):term.name).toLowerCase()
if(key in map===false){map[key]=term
continue}}}map=null
result=createCondition(term,MATCH,result)}return result}case"&&":{if(terms.length>5)return{type:"MatchOnce",terms:terms,all:true}
let result=MISMATCH
for(let i=terms.length-1;i>=0;i--){const term=terms[i]
let thenClause
thenClause=terms.length>1?buildGroupMatchGraph(combinator,terms.filter((function(newGroupTerm){return newGroupTerm!==term})),false):MATCH
result=createCondition(term,thenClause,result)}return result}case"||":{if(terms.length>5)return{type:"MatchOnce",terms:terms,all:false}
let result=atLeastOneTermMatched?MATCH:MISMATCH
for(let i=terms.length-1;i>=0;i--){const term=terms[i]
let thenClause
thenClause=terms.length>1?buildGroupMatchGraph(combinator,terms.filter((function(newGroupTerm){return newGroupTerm!==term})),true):MATCH
result=createCondition(term,thenClause,result)}return result}}}function buildMultiplierMatchGraph(node){let result=MATCH
let matchTerm=buildMatchGraphInternal(node.term)
if(node.max===0){matchTerm=createCondition(matchTerm,DISALLOW_EMPTY,MISMATCH)
result=createCondition(matchTerm,null,MISMATCH)
result.then=createCondition(MATCH,MATCH,result)
node.comma&&(result.then.else=createCondition({type:"Comma",syntax:node},result,MISMATCH))}else for(let i=node.min||1;i<=node.max;i++){node.comma&&result!==MATCH&&(result=createCondition({type:"Comma",syntax:node},result,MISMATCH))
result=createCondition(matchTerm,createCondition(MATCH,MATCH,result),MISMATCH)}if(node.min===0)result=createCondition(MATCH,MATCH,result)
else for(let i=0;i<node.min-1;i++){node.comma&&result!==MATCH&&(result=createCondition({type:"Comma",syntax:node},result,MISMATCH))
result=createCondition(matchTerm,result,MISMATCH)}return result}function buildMatchGraphInternal(node){if(typeof node==="function")return{type:"Generic",fn:node}
switch(node.type){case"Group":{let result=buildGroupMatchGraph(node.combinator,node.terms.map(buildMatchGraphInternal),false)
node.disallowEmpty&&(result=createCondition(result,DISALLOW_EMPTY,MISMATCH))
return result}case"Multiplier":return buildMultiplierMatchGraph(node)
case"Type":case"Property":return{type:node.type,name:node.name,syntax:node}
case"Keyword":return{type:node.type,name:node.name.toLowerCase(),syntax:node}
case"AtKeyword":return{type:node.type,name:"@"+node.name.toLowerCase(),syntax:node}
case"Function":return{type:node.type,name:node.name.toLowerCase()+"(",syntax:node}
case"String":if(node.value.length===3)return{type:"Token",value:node.value.charAt(1),syntax:node}
return{type:node.type,value:node.value.substr(1,node.value.length-2).replace(/\\'/g,"'"),syntax:node}
case"Token":return{type:node.type,value:node.value,syntax:node}
case"Comma":return{type:node.type,syntax:node}
default:throw new Error("Unknown node type:",node.type)}}function buildMatchGraph(syntaxTree,ref){typeof syntaxTree==="string"&&(syntaxTree=parse$H(syntaxTree))
return{type:"MatchGraph",match:buildMatchGraphInternal(syntaxTree),syntax:ref||null,source:syntaxTree}}const{hasOwnProperty:hasOwnProperty$7}=Object.prototype
const STUB=0
const TOKEN=1
const OPEN_SYNTAX=2
const CLOSE_SYNTAX=3
const EXIT_REASON_MATCH="Match"
const EXIT_REASON_MISMATCH="Mismatch"
const EXIT_REASON_ITERATION_LIMIT="Maximum iteration number exceeded (please fill an issue on https://github.com/csstree/csstree/issues)"
const ITERATION_LIMIT=15000
function reverseList(list){let prev=null
let next=null
let item=list
while(item!==null){next=item.prev
item.prev=prev
prev=item
item=next}return prev}function areStringsEqualCaseInsensitive(testStr,referenceStr){if(testStr.length!==referenceStr.length)return false
for(let i=0;i<testStr.length;i++){const referenceCode=referenceStr.charCodeAt(i)
let testCode=testStr.charCodeAt(i)
testCode>=0x0041&&testCode<=0x005A&&(testCode|=32)
if(testCode!==referenceCode)return false}return true}function isContextEdgeDelim(token){if(token.type!==Delim)return false
return token.value!=="?"}function isCommaContextStart(token){if(token===null)return true
return token.type===Comma||token.type===Function$1||token.type===LeftParenthesis||token.type===LeftSquareBracket||token.type===LeftCurlyBracket||isContextEdgeDelim(token)}function isCommaContextEnd(token){if(token===null)return true
return token.type===RightParenthesis||token.type===RightSquareBracket||token.type===RightCurlyBracket||token.type===Delim&&token.value==="/"}function internalMatch(tokens,state,syntaxes){function moveToNextToken(){do{tokenIndex++
token=tokenIndex<tokens.length?tokens[tokenIndex]:null}while(token!==null&&(token.type===WhiteSpace$1||token.type===Comment$1))}function getNextToken(offset){const nextIndex=tokenIndex+offset
return nextIndex<tokens.length?tokens[nextIndex]:null}function stateSnapshotFromSyntax(nextState,prev){return{nextState:nextState,matchStack:matchStack,syntaxStack:syntaxStack,thenStack:thenStack,tokenIndex:tokenIndex,prev:prev}}function pushThenStack(nextState){thenStack={nextState:nextState,matchStack:matchStack,syntaxStack:syntaxStack,prev:thenStack}}function pushElseStack(nextState){elseStack=stateSnapshotFromSyntax(nextState,elseStack)}function addTokenToMatch(){matchStack={type:TOKEN,syntax:state.syntax,token:token,prev:matchStack}
moveToNextToken()
syntaxStash=null
tokenIndex>longestMatch&&(longestMatch=tokenIndex)}function openSyntax(){syntaxStack={syntax:state.syntax,opts:state.syntax.opts||syntaxStack!==null&&syntaxStack.opts||null,prev:syntaxStack}
matchStack={type:OPEN_SYNTAX,syntax:state.syntax,token:matchStack.token,prev:matchStack}}function closeSyntax(){matchStack=matchStack.type===OPEN_SYNTAX?matchStack.prev:{type:CLOSE_SYNTAX,syntax:syntaxStack.syntax,token:matchStack.token,prev:matchStack}
syntaxStack=syntaxStack.prev}let syntaxStack=null
let thenStack=null
let elseStack=null
let syntaxStash=null
let iterationCount=0
let exitReason=null
let token=null
let tokenIndex=-1
let longestMatch=0
let matchStack={type:STUB,syntax:null,token:null,prev:null}
moveToNextToken()
while(exitReason===null&&++iterationCount<ITERATION_LIMIT)switch(state.type){case"Match":if(thenStack===null){if(token!==null&&(tokenIndex!==tokens.length-1||token.value!=="\\0"&&token.value!=="\\9")){state=MISMATCH
break}exitReason=EXIT_REASON_MATCH
break}state=thenStack.nextState
if(state===DISALLOW_EMPTY){if(thenStack.matchStack===matchStack){state=MISMATCH
break}state=MATCH}while(thenStack.syntaxStack!==syntaxStack)closeSyntax()
thenStack=thenStack.prev
break
case"Mismatch":if(syntaxStash!==null&&syntaxStash!==false){if(elseStack===null||tokenIndex>elseStack.tokenIndex){elseStack=syntaxStash
syntaxStash=false}}else if(elseStack===null){exitReason=EXIT_REASON_MISMATCH
break}state=elseStack.nextState
thenStack=elseStack.thenStack
syntaxStack=elseStack.syntaxStack
matchStack=elseStack.matchStack
tokenIndex=elseStack.tokenIndex
token=tokenIndex<tokens.length?tokens[tokenIndex]:null
elseStack=elseStack.prev
break
case"MatchGraph":state=state.match
break
case"If":state.else!==MISMATCH&&pushElseStack(state.else)
state.then!==MATCH&&pushThenStack(state.then)
state=state.match
break
case"MatchOnce":state={type:"MatchOnceBuffer",syntax:state,index:0,mask:0}
break
case"MatchOnceBuffer":{const terms=state.syntax.terms
if(state.index===terms.length){if(state.mask===0||state.syntax.all){state=MISMATCH
break}state=MATCH
break}if(state.mask===(1<<terms.length)-1){state=MATCH
break}for(;state.index<terms.length;state.index++){const matchFlag=1<<state.index
if((state.mask&matchFlag)===0){pushElseStack(state)
pushThenStack({type:"AddMatchOnce",syntax:state.syntax,mask:state.mask|matchFlag})
state=terms[state.index++]
break}}break}case"AddMatchOnce":state={type:"MatchOnceBuffer",syntax:state.syntax,index:0,mask:state.mask}
break
case"Enum":if(token!==null){let name=token.value.toLowerCase()
name.indexOf("\\")!==-1&&(name=name.replace(/\\[09].*$/,""))
if(hasOwnProperty$7.call(state.map,name)){state=state.map[name]
break}}state=MISMATCH
break
case"Generic":{const opts=syntaxStack!==null?syntaxStack.opts:null
const lastTokenIndex=tokenIndex+Math.floor(state.fn(token,getNextToken,opts))
if(!isNaN(lastTokenIndex)&&lastTokenIndex>tokenIndex){while(tokenIndex<lastTokenIndex)addTokenToMatch()
state=MATCH}else state=MISMATCH
break}case"Type":case"Property":{const syntaxDict=state.type==="Type"?"types":"properties"
const dictSyntax=hasOwnProperty$7.call(syntaxes,syntaxDict)?syntaxes[syntaxDict][state.name]:null
if(!dictSyntax||!dictSyntax.match)throw new Error("Bad syntax reference: "+(state.type==="Type"?"<"+state.name+">":"<'"+state.name+"'>"))
if(syntaxStash!==false&&token!==null&&state.type==="Type"){const lowPriorityMatching=state.name==="custom-ident"&&token.type===Ident||state.name==="length"&&token.value==="0"
if(lowPriorityMatching){syntaxStash===null&&(syntaxStash=stateSnapshotFromSyntax(state,elseStack))
state=MISMATCH
break}}openSyntax()
state=dictSyntax.match
break}case"Keyword":{const name=state.name
if(token!==null){let keywordName=token.value
keywordName.indexOf("\\")!==-1&&(keywordName=keywordName.replace(/\\[09].*$/,""))
if(areStringsEqualCaseInsensitive(keywordName,name)){addTokenToMatch()
state=MATCH
break}}state=MISMATCH
break}case"AtKeyword":case"Function":if(token!==null&&areStringsEqualCaseInsensitive(token.value,state.name)){addTokenToMatch()
state=MATCH
break}state=MISMATCH
break
case"Token":if(token!==null&&token.value===state.value){addTokenToMatch()
state=MATCH
break}state=MISMATCH
break
case"Comma":if(token!==null&&token.type===Comma)if(isCommaContextStart(matchStack.token))state=MISMATCH
else{addTokenToMatch()
state=isCommaContextEnd(token)?MISMATCH:MATCH}else state=isCommaContextStart(matchStack.token)||isCommaContextEnd(token)?MATCH:MISMATCH
break
case"String":let string=""
let lastTokenIndex=tokenIndex
for(;lastTokenIndex<tokens.length&&string.length<state.value.length;lastTokenIndex++)string+=tokens[lastTokenIndex].value
if(areStringsEqualCaseInsensitive(string,state.value)){while(tokenIndex<lastTokenIndex)addTokenToMatch()
state=MATCH}else state=MISMATCH
break
default:throw new Error("Unknown node type: "+state.type)}switch(exitReason){case null:console.warn("[csstree-match] BREAK after "+ITERATION_LIMIT+" iterations")
exitReason=EXIT_REASON_ITERATION_LIMIT
matchStack=null
break
case EXIT_REASON_MATCH:while(syntaxStack!==null)closeSyntax()
break
default:matchStack=null}return{tokens:tokens,reason:exitReason,iterations:iterationCount,match:matchStack,longestMatch:longestMatch}}function matchAsTree(tokens,matchGraph,syntaxes){const matchResult=internalMatch(tokens,matchGraph,syntaxes||{})
if(matchResult.match===null)return matchResult
let item=matchResult.match
let host=matchResult.match={syntax:matchGraph.syntax||null,match:[]}
const hostStack=[host]
item=reverseList(item).prev
while(item!==null){switch(item.type){case OPEN_SYNTAX:host.match.push(host={syntax:item.syntax,match:[]})
hostStack.push(host)
break
case CLOSE_SYNTAX:hostStack.pop()
host=hostStack[hostStack.length-1]
break
default:host.match.push({syntax:item.syntax||null,token:item.token.value,node:item.token.node})}item=item.prev}return matchResult}function getTrace(node){function shouldPutToTrace(syntax){if(syntax===null)return false
return syntax.type==="Type"||syntax.type==="Property"||syntax.type==="Keyword"}function hasMatch(matchNode){if(Array.isArray(matchNode.match)){for(let i=0;i<matchNode.match.length;i++)if(hasMatch(matchNode.match[i])){shouldPutToTrace(matchNode.syntax)&&result.unshift(matchNode.syntax)
return true}}else if(matchNode.node===node){result=shouldPutToTrace(matchNode.syntax)?[matchNode.syntax]:[]
return true}return false}let result=null
this.matched!==null&&hasMatch(this.matched)
return result}function isType(node,type){return testNode(this,node,(match=>match.type==="Type"&&match.name===type))}function isProperty(node,property){return testNode(this,node,(match=>match.type==="Property"&&match.name===property))}function isKeyword(node){return testNode(this,node,(match=>match.type==="Keyword"))}function testNode(match,node,fn){const trace=getTrace.call(match,node)
if(trace===null)return false
return trace.some(fn)}var trace=Object.freeze({__proto__:null,getTrace:getTrace,isKeyword:isKeyword,isProperty:isProperty,isType:isType})
function getFirstMatchNode(matchNode){if("node"in matchNode)return matchNode.node
return getFirstMatchNode(matchNode.match[0])}function getLastMatchNode(matchNode){if("node"in matchNode)return matchNode.node
return getLastMatchNode(matchNode.match[matchNode.match.length-1])}function matchFragments(lexer,ast,match,type,name){function findFragments(matchNode){if(matchNode.syntax!==null&&matchNode.syntax.type===type&&matchNode.syntax.name===name){const start=getFirstMatchNode(matchNode)
const end=getLastMatchNode(matchNode)
lexer.syntax.walk(ast,(function(node,item,list){if(node===start){const nodes=new List
do{nodes.appendData(item.data)
if(item.data===end)break
item=item.next}while(item!==null)
fragments.push({parent:list,nodes:nodes})}}))}Array.isArray(matchNode.match)&&matchNode.match.forEach(findFragments)}const fragments=[]
match.matched!==null&&findFragments(match.matched)
return fragments}const{hasOwnProperty:hasOwnProperty$6}=Object.prototype
function isValidNumber(value){return typeof value==="number"&&isFinite(value)&&Math.floor(value)===value&&value>=0}function isValidLocation(loc){return Boolean(loc)&&isValidNumber(loc.offset)&&isValidNumber(loc.line)&&isValidNumber(loc.column)}function createNodeStructureChecker(type,fields){return function checkNode(node,warn){if(!node||node.constructor!==Object)return warn(node,"Type of node should be an Object")
for(let key in node){let valid=true
if(hasOwnProperty$6.call(node,key)===false)continue
if(key==="type")node.type!==type&&warn(node,"Wrong node type `"+node.type+"`, expected `"+type+"`")
else if(key==="loc"){if(node.loc===null)continue
if(node.loc&&node.loc.constructor===Object)if(typeof node.loc.source!=="string")key+=".source"
else if(isValidLocation(node.loc.start)){if(isValidLocation(node.loc.end))continue
key+=".end"}else key+=".start"
valid=false}else if(fields.hasOwnProperty(key)){valid=false
for(let i=0;!valid&&i<fields[key].length;i++){const fieldType=fields[key][i]
switch(fieldType){case String:valid=typeof node[key]==="string"
break
case Boolean:valid=typeof node[key]==="boolean"
break
case null:valid=node[key]===null
break
default:typeof fieldType==="string"?valid=node[key]&&node[key].type===fieldType:Array.isArray(fieldType)&&(valid=node[key]instanceof List)}}}else warn(node,"Unknown field `"+key+"` for "+type+" node type")
valid||warn(node,"Bad value for `"+type+"."+key+"`")}for(const key in fields)hasOwnProperty$6.call(fields,key)&&hasOwnProperty$6.call(node,key)===false&&warn(node,"Field `"+type+"."+key+"` is missed")}}function processStructure(name,nodeType){const structure=nodeType.structure
const fields={type:String,loc:true}
const docs={type:'"'+name+'"'}
for(const key in structure){if(hasOwnProperty$6.call(structure,key)===false)continue
const docsTypes=[]
const fieldTypes=fields[key]=Array.isArray(structure[key])?structure[key].slice():[structure[key]]
for(let i=0;i<fieldTypes.length;i++){const fieldType=fieldTypes[i]
if(fieldType===String||fieldType===Boolean)docsTypes.push(fieldType.name)
else if(fieldType===null)docsTypes.push("null")
else if(typeof fieldType==="string")docsTypes.push("<"+fieldType+">")
else{if(!Array.isArray(fieldType))throw new Error("Wrong value `"+fieldType+"` in `"+name+"."+key+"` structure definition")
docsTypes.push("List")}}docs[key]=docsTypes.join(" | ")}return{docs:docs,check:createNodeStructureChecker(name,fields)}}function getStructureFromConfig(config){const structure={}
if(config.node)for(const name in config.node)if(hasOwnProperty$6.call(config.node,name)){const nodeType=config.node[name]
if(!nodeType.structure)throw new Error("Missed `structure` field in `"+name+"` node type definition")
structure[name]=processStructure(name,nodeType)}return structure}const cssWideKeywordsSyntax=buildMatchGraph(cssWideKeywords.join(" | "))
function dumpMapSyntax(map,compact,syntaxAsAst){const result={}
for(const name in map)map[name].syntax&&(result[name]=syntaxAsAst?map[name].syntax:generate$H(map[name].syntax,{compact:compact}))
return result}function dumpAtruleMapSyntax(map,compact,syntaxAsAst){const result={}
for(const[name,atrule]of Object.entries(map))result[name]={prelude:atrule.prelude&&(syntaxAsAst?atrule.prelude.syntax:generate$H(atrule.prelude.syntax,{compact:compact})),descriptors:atrule.descriptors&&dumpMapSyntax(atrule.descriptors,compact,syntaxAsAst)}
return result}function valueHasVar(tokens){for(let i=0;i<tokens.length;i++)if(tokens[i].value.toLowerCase()==="var(")return true
return false}function buildMatchResult(matched,error,iterations){return{matched:matched,iterations:iterations,error:error,...trace}}function matchSyntax(lexer,syntax,value,useCssWideKeywords){const tokens=prepareTokens(value,lexer.syntax)
let result
if(valueHasVar(tokens))return buildMatchResult(null,new Error("Matching for a tree with var() is not supported"))
useCssWideKeywords&&(result=matchAsTree(tokens,lexer.cssWideKeywordsSyntax,lexer))
if(!useCssWideKeywords||!result.match){result=matchAsTree(tokens,syntax.match,lexer)
if(!result.match)return buildMatchResult(null,new SyntaxMatchError(result.reason,syntax.syntax,value,result),result.iterations)}return buildMatchResult(result.match,null,result.iterations)}class Lexer{constructor(config,syntax,structure){this.cssWideKeywordsSyntax=cssWideKeywordsSyntax
this.syntax=syntax
this.generic=false
this.atrules=Object.create(null)
this.properties=Object.create(null)
this.types=Object.create(null)
this.structure=structure||getStructureFromConfig(config)
if(config){if(config.types)for(const name in config.types)this.addType_(name,config.types[name])
if(config.generic){this.generic=true
for(const name in generic)this.addType_(name,generic[name])}if(config.atrules)for(const name in config.atrules)this.addAtrule_(name,config.atrules[name])
if(config.properties)for(const name in config.properties)this.addProperty_(name,config.properties[name])}}checkStructure(ast){function collectWarning(node,message){warns.push({node:node,message:message})}const structure=this.structure
const warns=[]
this.syntax.walk(ast,(function(node){structure.hasOwnProperty(node.type)?structure[node.type].check(node,collectWarning):collectWarning(node,"Unknown node type `"+node.type+"`")}))
return!!warns.length&&warns}createDescriptor(syntax,type,name,parent=null){const ref={type:type,name:name}
const descriptor={type:type,name:name,parent:parent,serializable:typeof syntax==="string"||syntax&&typeof syntax.type==="string",syntax:null,match:null}
if(typeof syntax==="function")descriptor.match=buildMatchGraph(syntax,ref)
else{typeof syntax==="string"?Object.defineProperty(descriptor,"syntax",{get(){Object.defineProperty(descriptor,"syntax",{value:parse$H(syntax)})
return descriptor.syntax}}):descriptor.syntax=syntax
Object.defineProperty(descriptor,"match",{get(){Object.defineProperty(descriptor,"match",{value:buildMatchGraph(descriptor.syntax,ref)})
return descriptor.match}})}return descriptor}addAtrule_(name,syntax){if(!syntax)return
this.atrules[name]={type:"Atrule",name:name,prelude:syntax.prelude?this.createDescriptor(syntax.prelude,"AtrulePrelude",name):null,descriptors:syntax.descriptors?Object.keys(syntax.descriptors).reduce(((map,descName)=>{map[descName]=this.createDescriptor(syntax.descriptors[descName],"AtruleDescriptor",descName,name)
return map}),Object.create(null)):null}}addProperty_(name,syntax){if(!syntax)return
this.properties[name]=this.createDescriptor(syntax,"Property",name)}addType_(name,syntax){if(!syntax)return
this.types[name]=this.createDescriptor(syntax,"Type",name)}checkAtruleName(atruleName){if(!this.getAtrule(atruleName))return new SyntaxReferenceError("Unknown at-rule","@"+atruleName)}checkAtrulePrelude(atruleName,prelude){const error=this.checkAtruleName(atruleName)
if(error)return error
const atrule=this.getAtrule(atruleName)
if(!atrule.prelude&&prelude)return new SyntaxError("At-rule `@"+atruleName+"` should not contain a prelude")
if(atrule.prelude&&!prelude&&!matchSyntax(this,atrule.prelude,"",false).matched)return new SyntaxError("At-rule `@"+atruleName+"` should contain a prelude")}checkAtruleDescriptorName(atruleName,descriptorName){const error=this.checkAtruleName(atruleName)
if(error)return error
const atrule=this.getAtrule(atruleName)
const descriptor=keyword(descriptorName)
if(!atrule.descriptors)return new SyntaxError("At-rule `@"+atruleName+"` has no known descriptors")
if(!atrule.descriptors[descriptor.name]&&!atrule.descriptors[descriptor.basename])return new SyntaxReferenceError("Unknown at-rule descriptor",descriptorName)}checkPropertyName(propertyName){if(!this.getProperty(propertyName))return new SyntaxReferenceError("Unknown property",propertyName)}matchAtrulePrelude(atruleName,prelude){const error=this.checkAtrulePrelude(atruleName,prelude)
if(error)return buildMatchResult(null,error)
const atrule=this.getAtrule(atruleName)
if(!atrule.prelude)return buildMatchResult(null,null)
return matchSyntax(this,atrule.prelude,prelude||"",false)}matchAtruleDescriptor(atruleName,descriptorName,value){const error=this.checkAtruleDescriptorName(atruleName,descriptorName)
if(error)return buildMatchResult(null,error)
const atrule=this.getAtrule(atruleName)
const descriptor=keyword(descriptorName)
return matchSyntax(this,atrule.descriptors[descriptor.name]||atrule.descriptors[descriptor.basename],value,false)}matchDeclaration(node){if(node.type!=="Declaration")return buildMatchResult(null,new Error("Not a Declaration node"))
return this.matchProperty(node.property,node.value)}matchProperty(propertyName,value){if(property(propertyName).custom)return buildMatchResult(null,new Error("Lexer matching doesn't applicable for custom properties"))
const error=this.checkPropertyName(propertyName)
if(error)return buildMatchResult(null,error)
return matchSyntax(this,this.getProperty(propertyName),value,true)}matchType(typeName,value){const typeSyntax=this.getType(typeName)
if(!typeSyntax)return buildMatchResult(null,new SyntaxReferenceError("Unknown type",typeName))
return matchSyntax(this,typeSyntax,value,false)}match(syntax,value){if(typeof syntax!=="string"&&(!syntax||!syntax.type))return buildMatchResult(null,new SyntaxReferenceError("Bad syntax"))
typeof syntax!=="string"&&syntax.match||(syntax=this.createDescriptor(syntax,"Type","anonymous"))
return matchSyntax(this,syntax,value,false)}findValueFragments(propertyName,value,type,name){return matchFragments(this,value,this.matchProperty(propertyName,value),type,name)}findDeclarationValueFragments(declaration,type,name){return matchFragments(this,declaration.value,this.matchDeclaration(declaration),type,name)}findAllFragments(ast,type,name){const result=[]
this.syntax.walk(ast,{visit:"Declaration",enter:declaration=>{result.push.apply(result,this.findDeclarationValueFragments(declaration,type,name))}})
return result}getAtrule(atruleName,fallbackBasename=true){const atrule=keyword(atruleName)
const atruleEntry=atrule.vendor&&fallbackBasename?this.atrules[atrule.name]||this.atrules[atrule.basename]:this.atrules[atrule.name]
return atruleEntry||null}getAtrulePrelude(atruleName,fallbackBasename=true){const atrule=this.getAtrule(atruleName,fallbackBasename)
return atrule&&atrule.prelude||null}getAtruleDescriptor(atruleName,name){return this.atrules.hasOwnProperty(atruleName)&&this.atrules.declarators&&this.atrules[atruleName].declarators[name]||null}getProperty(propertyName,fallbackBasename=true){const property$1=property(propertyName)
const propertyEntry=property$1.vendor&&fallbackBasename?this.properties[property$1.name]||this.properties[property$1.basename]:this.properties[property$1.name]
return propertyEntry||null}getType(name){return hasOwnProperty.call(this.types,name)?this.types[name]:null}validate(){function validate(syntax,name,broken,descriptor){if(broken.has(name))return broken.get(name)
broken.set(name,false)
descriptor.syntax!==null&&walk$2(descriptor.syntax,(function(node){if(node.type!=="Type"&&node.type!=="Property")return
const map=node.type==="Type"?syntax.types:syntax.properties
const brokenMap=node.type==="Type"?brokenTypes:brokenProperties
hasOwnProperty.call(map,node.name)&&!validate(syntax,node.name,brokenMap,map[node.name])||broken.set(name,true)}),this)}let brokenTypes=new Map
let brokenProperties=new Map
for(const key in this.types)validate(this,key,brokenTypes,this.types[key])
for(const key in this.properties)validate(this,key,brokenProperties,this.properties[key])
brokenTypes=[...brokenTypes.keys()].filter((name=>brokenTypes.get(name)))
brokenProperties=[...brokenProperties.keys()].filter((name=>brokenProperties.get(name)))
if(brokenTypes.length||brokenProperties.length)return{types:brokenTypes,properties:brokenProperties}
return null}dump(syntaxAsAst,pretty){return{generic:this.generic,types:dumpMapSyntax(this.types,!pretty,syntaxAsAst),properties:dumpMapSyntax(this.properties,!pretty,syntaxAsAst),atrules:dumpAtruleMapSyntax(this.atrules,!pretty,syntaxAsAst)}}toString(){return JSON.stringify(this.dump())}}const{hasOwnProperty:hasOwnProperty$5}=Object.prototype
const shape={generic:true,types:appendOrAssign,atrules:{prelude:appendOrAssignOrNull,descriptors:appendOrAssignOrNull},properties:appendOrAssign,parseContext:assign,scope:deepAssign,atrule:["parse"],pseudo:["parse"],node:["name","structure","parse","generate","walkContext"]}
function isObject(value){return value&&value.constructor===Object}function copy(value){return isObject(value)?{...value}:value}function assign(dest,src){return Object.assign(dest,src)}function deepAssign(dest,src){for(const key in src)hasOwnProperty$5.call(src,key)&&(isObject(dest[key])?deepAssign(dest[key],src[key]):dest[key]=copy(src[key]))
return dest}function append(a,b){if(typeof b==="string"&&/^\s*\|/.test(b))return typeof a==="string"?a+b:b.replace(/^\s*\|\s*/,"")
return b||null}function appendOrAssign(a,b){if(typeof b==="string")return append(a,b)
const result={...a}
for(let key in b)hasOwnProperty$5.call(b,key)&&(result[key]=append(hasOwnProperty$5.call(a,key)?a[key]:void 0,b[key]))
return result}function appendOrAssignOrNull(a,b){const result=appendOrAssign(a,b)
return!isObject(result)||Object.keys(result).length?result:null}function mix(dest,src,shape){for(const key in shape){if(hasOwnProperty$5.call(shape,key)===false)continue
if(shape[key]===true)hasOwnProperty$5.call(src,key)&&(dest[key]=copy(src[key]))
else if(shape[key])if(typeof shape[key]==="function"){const fn=shape[key]
dest[key]=fn({},dest[key])
dest[key]=fn(dest[key]||{},src[key])}else if(isObject(shape[key])){const result={}
for(let name in dest[key])result[name]=mix({},dest[key][name],shape[key])
for(let name in src[key])result[name]=mix(result[name]||{},src[key][name],shape[key])
dest[key]=result}else if(Array.isArray(shape[key])){const res={}
const innerShape=shape[key].reduce((function(s,k){s[k]=true
return s}),{})
for(const[name,value]of Object.entries(dest[key]||{})){res[name]={}
value&&mix(res[name],value,innerShape)}for(const name in src[key])if(hasOwnProperty$5.call(src[key],name)){res[name]||(res[name]={})
src[key]&&src[key][name]&&mix(res[name],src[key][name],innerShape)}dest[key]=res}}return dest}var mix$1=(dest,src)=>mix(dest,src,shape)
function createSyntax(config){const parse=createParser(config)
const walk=createWalker(config)
const generate=createGenerator(config)
const{fromPlainObject:fromPlainObject,toPlainObject:toPlainObject}=createConvertor(walk)
const syntax={lexer:null,createLexer:config=>new Lexer(config,syntax,syntax.lexer.structure),tokenize:tokenize$2,parse:parse,generate:generate,walk:walk,find:walk.find,findLast:walk.findLast,findAll:walk.findAll,fromPlainObject:fromPlainObject,toPlainObject:toPlainObject,fork(extension){const base=mix$1({},config)
return createSyntax(typeof extension==="function"?extension(base,Object.assign):mix$1(base,extension))}}
syntax.lexer=new Lexer({generic:true,types:config.types,atrules:config.atrules,properties:config.properties,node:config.node},syntax)
return syntax}var createSyntax$1=config=>createSyntax(mix$1({},config))
var definitions={generic:true,types:{"absolute-size":"xx-small|x-small|small|medium|large|x-large|xx-large|xxx-large","alpha-value":"<number>|<percentage>","angle-percentage":"<angle>|<percentage>","angular-color-hint":"<angle-percentage>","angular-color-stop":"<color>&&<color-stop-angle>?","angular-color-stop-list":"[<angular-color-stop> [, <angular-color-hint>]?]# , <angular-color-stop>","animateable-feature":"scroll-position|contents|<custom-ident>",attachment:"scroll|fixed|local","attr()":"attr( <attr-name> <type-or-unit>? [, <attr-fallback>]? )","attr-matcher":"['~'|'|'|'^'|'$'|'*']? '='","attr-modifier":"i|s","attribute-selector":"'[' <wq-name> ']'|'[' <wq-name> <attr-matcher> [<string-token>|<ident-token>] <attr-modifier>? ']'","auto-repeat":"repeat( [auto-fill|auto-fit] , [<line-names>? <fixed-size>]+ <line-names>? )","auto-track-list":"[<line-names>? [<fixed-size>|<fixed-repeat>]]* <line-names>? <auto-repeat> [<line-names>? [<fixed-size>|<fixed-repeat>]]* <line-names>?","baseline-position":"[first|last]? baseline","basic-shape":"<inset()>|<circle()>|<ellipse()>|<polygon()>|<path()>","bg-image":"none|<image>","bg-layer":"<bg-image>||<bg-position> [/ <bg-size>]?||<repeat-style>||<attachment>||<box>||<box>","bg-position":"[[left|center|right|top|bottom|<length-percentage>]|[left|center|right|<length-percentage>] [top|center|bottom|<length-percentage>]|[center|[left|right] <length-percentage>?]&&[center|[top|bottom] <length-percentage>?]]","bg-size":"[<length-percentage>|auto]{1,2}|cover|contain","blur()":"blur( <length> )","blend-mode":"normal|multiply|screen|overlay|darken|lighten|color-dodge|color-burn|hard-light|soft-light|difference|exclusion|hue|saturation|color|luminosity",box:"border-box|padding-box|content-box","brightness()":"brightness( <number-percentage> )","calc()":"calc( <calc-sum> )","calc-sum":"<calc-product> [['+'|'-'] <calc-product>]*","calc-product":"<calc-value> ['*' <calc-value>|'/' <number>]*","calc-value":"<number>|<dimension>|<percentage>|( <calc-sum> )","cf-final-image":"<image>|<color>","cf-mixing-image":"<percentage>?&&<image>","circle()":"circle( [<shape-radius>]? [at <position>]? )","clamp()":"clamp( <calc-sum>#{3} )","class-selector":"'.' <ident-token>","clip-source":"<url>",color:"<rgb()>|<rgba()>|<hsl()>|<hsla()>|<hwb()>|<lab()>|<lch()>|<hex-color>|<named-color>|currentcolor|<deprecated-system-color>","color-stop":"<color-stop-length>|<color-stop-angle>","color-stop-angle":"<angle-percentage>{1,2}","color-stop-length":"<length-percentage>{1,2}","color-stop-list":"[<linear-color-stop> [, <linear-color-hint>]?]# , <linear-color-stop>",combinator:"'>'|'+'|'~'|['||']","common-lig-values":"[common-ligatures|no-common-ligatures]","compat-auto":"searchfield|textarea|push-button|slider-horizontal|checkbox|radio|square-button|menulist|listbox|meter|progress-bar|button","composite-style":"clear|copy|source-over|source-in|source-out|source-atop|destination-over|destination-in|destination-out|destination-atop|xor","compositing-operator":"add|subtract|intersect|exclude","compound-selector":"[<type-selector>? <subclass-selector>* [<pseudo-element-selector> <pseudo-class-selector>*]*]!","compound-selector-list":"<compound-selector>#","complex-selector":"<compound-selector> [<combinator>? <compound-selector>]*","complex-selector-list":"<complex-selector>#","conic-gradient()":"conic-gradient( [from <angle>]? [at <position>]? , <angular-color-stop-list> )","contextual-alt-values":"[contextual|no-contextual]","content-distribution":"space-between|space-around|space-evenly|stretch","content-list":"[<string>|contents|<image>|<counter>|<quote>|<target>|<leader()>|<attr()>]+","content-position":"center|start|end|flex-start|flex-end","content-replacement":"<image>","contrast()":"contrast( [<number-percentage>] )",counter:"<counter()>|<counters()>","counter()":"counter( <counter-name> , <counter-style>? )","counter-name":"<custom-ident>","counter-style":"<counter-style-name>|symbols( )","counter-style-name":"<custom-ident>","counters()":"counters( <counter-name> , <string> , <counter-style>? )","cross-fade()":"cross-fade( <cf-mixing-image> , <cf-final-image>? )","cubic-bezier-timing-function":"ease|ease-in|ease-out|ease-in-out|cubic-bezier( <number [0,1]> , <number> , <number [0,1]> , <number> )","deprecated-system-color":"ActiveBorder|ActiveCaption|AppWorkspace|Background|ButtonFace|ButtonHighlight|ButtonShadow|ButtonText|CaptionText|GrayText|Highlight|HighlightText|InactiveBorder|InactiveCaption|InactiveCaptionText|InfoBackground|InfoText|Menu|MenuText|Scrollbar|ThreeDDarkShadow|ThreeDFace|ThreeDHighlight|ThreeDLightShadow|ThreeDShadow|Window|WindowFrame|WindowText","discretionary-lig-values":"[discretionary-ligatures|no-discretionary-ligatures]","display-box":"contents|none","display-inside":"flow|flow-root|table|flex|grid|ruby","display-internal":"table-row-group|table-header-group|table-footer-group|table-row|table-cell|table-column-group|table-column|table-caption|ruby-base|ruby-text|ruby-base-container|ruby-text-container","display-legacy":"inline-block|inline-list-item|inline-table|inline-flex|inline-grid","display-listitem":"<display-outside>?&&[flow|flow-root]?&&list-item","display-outside":"block|inline|run-in","drop-shadow()":"drop-shadow( <length>{2,3} <color>? )","east-asian-variant-values":"[jis78|jis83|jis90|jis04|simplified|traditional]","east-asian-width-values":"[full-width|proportional-width]","element()":"element( <custom-ident> , [first|start|last|first-except]? )|element( <id-selector> )","ellipse()":"ellipse( [<shape-radius>{2}]? [at <position>]? )","ending-shape":"circle|ellipse","env()":"env( <custom-ident> , <declaration-value>? )","explicit-track-list":"[<line-names>? <track-size>]+ <line-names>?","family-name":"<string>|<custom-ident>+","feature-tag-value":"<string> [<integer>|on|off]?","feature-type":"@stylistic|@historical-forms|@styleset|@character-variant|@swash|@ornaments|@annotation","feature-value-block":"<feature-type> '{' <feature-value-declaration-list> '}'","feature-value-block-list":"<feature-value-block>+","feature-value-declaration":"<custom-ident> : <integer>+ ;","feature-value-declaration-list":"<feature-value-declaration>","feature-value-name":"<custom-ident>","fill-rule":"nonzero|evenodd","filter-function":"<blur()>|<brightness()>|<contrast()>|<drop-shadow()>|<grayscale()>|<hue-rotate()>|<invert()>|<opacity()>|<saturate()>|<sepia()>","filter-function-list":"[<filter-function>|<url>]+","final-bg-layer":"<'background-color'>||<bg-image>||<bg-position> [/ <bg-size>]?||<repeat-style>||<attachment>||<box>||<box>","fit-content()":"fit-content( [<length>|<percentage>] )","fixed-breadth":"<length-percentage>","fixed-repeat":"repeat( [<integer [1,∞]>] , [<line-names>? <fixed-size>]+ <line-names>? )","fixed-size":"<fixed-breadth>|minmax( <fixed-breadth> , <track-breadth> )|minmax( <inflexible-breadth> , <fixed-breadth> )","font-stretch-absolute":"normal|ultra-condensed|extra-condensed|condensed|semi-condensed|semi-expanded|expanded|extra-expanded|ultra-expanded|<percentage>","font-variant-css21":"[normal|small-caps]","font-weight-absolute":"normal|bold|<number [1,1000]>","frequency-percentage":"<frequency>|<percentage>","general-enclosed":"[<function-token> <any-value> )]|( <ident> <any-value> )","generic-family":"serif|sans-serif|cursive|fantasy|monospace|-apple-system","generic-name":"serif|sans-serif|cursive|fantasy|monospace","geometry-box":"<shape-box>|fill-box|stroke-box|view-box",gradient:"<linear-gradient()>|<repeating-linear-gradient()>|<radial-gradient()>|<repeating-radial-gradient()>|<conic-gradient()>|<repeating-conic-gradient()>|<-legacy-gradient>","grayscale()":"grayscale( <number-percentage> )","grid-line":"auto|<custom-ident>|[<integer>&&<custom-ident>?]|[span&&[<integer>||<custom-ident>]]","historical-lig-values":"[historical-ligatures|no-historical-ligatures]","hsl()":"hsl( <hue> <percentage> <percentage> [/ <alpha-value>]? )|hsl( <hue> , <percentage> , <percentage> , <alpha-value>? )","hsla()":"hsla( <hue> <percentage> <percentage> [/ <alpha-value>]? )|hsla( <hue> , <percentage> , <percentage> , <alpha-value>? )",hue:"<number>|<angle>","hue-rotate()":"hue-rotate( <angle> )","hwb()":"hwb( [<hue>|none] [<percentage>|none] [<percentage>|none] [/ [<alpha-value>|none]]? )",image:"<url>|<image()>|<image-set()>|<element()>|<paint()>|<cross-fade()>|<gradient>","image()":"image( <image-tags>? [<image-src>? , <color>?]! )","image-set()":"image-set( <image-set-option># )","image-set-option":"[<image>|<string>] [<resolution>||type( <string> )]","image-src":"<url>|<string>","image-tags":"ltr|rtl","inflexible-breadth":"<length>|<percentage>|min-content|max-content|auto","inset()":"inset( <length-percentage>{1,4} [round <'border-radius'>]? )","invert()":"invert( <number-percentage> )","keyframes-name":"<custom-ident>|<string>","keyframe-block":"<keyframe-selector># { <declaration-list> }","keyframe-block-list":"<keyframe-block>+","keyframe-selector":"from|to|<percentage>","layer()":"layer( <layer-name> )","layer-name":"<ident> ['.' <ident>]*","leader()":"leader( <leader-type> )","leader-type":"dotted|solid|space|<string>","length-percentage":"<length>|<percentage>","line-names":"'[' <custom-ident>* ']'","line-name-list":"[<line-names>|<name-repeat>]+","line-style":"none|hidden|dotted|dashed|solid|double|groove|ridge|inset|outset","line-width":"<length>|thin|medium|thick","linear-color-hint":"<length-percentage>","linear-color-stop":"<color> <color-stop-length>?","linear-gradient()":"linear-gradient( [<angle>|to <side-or-corner>]? , <color-stop-list> )","mask-layer":"<mask-reference>||<position> [/ <bg-size>]?||<repeat-style>||<geometry-box>||[<geometry-box>|no-clip]||<compositing-operator>||<masking-mode>","mask-position":"[<length-percentage>|left|center|right] [<length-percentage>|top|center|bottom]?","mask-reference":"none|<image>|<mask-source>","mask-source":"<url>","masking-mode":"alpha|luminance|match-source","matrix()":"matrix( <number>#{6} )","matrix3d()":"matrix3d( <number>#{16} )","max()":"max( <calc-sum># )","media-and":"<media-in-parens> [and <media-in-parens>]+","media-condition":"<media-not>|<media-and>|<media-or>|<media-in-parens>","media-condition-without-or":"<media-not>|<media-and>|<media-in-parens>","media-feature":"( [<mf-plain>|<mf-boolean>|<mf-range>] )","media-in-parens":"( <media-condition> )|<media-feature>|<general-enclosed>","media-not":"not <media-in-parens>","media-or":"<media-in-parens> [or <media-in-parens>]+","media-query":"<media-condition>|[not|only]? <media-type> [and <media-condition-without-or>]?","media-query-list":"<media-query>#","media-type":"<ident>","mf-boolean":"<mf-name>","mf-name":"<ident>","mf-plain":"<mf-name> : <mf-value>","mf-range":"<mf-name> ['<'|'>']? '='? <mf-value>|<mf-value> ['<'|'>']? '='? <mf-name>|<mf-value> '<' '='? <mf-name> '<' '='? <mf-value>|<mf-value> '>' '='? <mf-name> '>' '='? <mf-value>","mf-value":"<number>|<dimension>|<ident>|<ratio>","min()":"min( <calc-sum># )","minmax()":"minmax( [<length>|<percentage>|min-content|max-content|auto] , [<length>|<percentage>|<flex>|min-content|max-content|auto] )","name-repeat":"repeat( [<integer [1,∞]>|auto-fill] , <line-names>+ )","named-color":"transparent|aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgreen|darkgrey|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkslategrey|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dimgrey|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|green|greenyellow|grey|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgray|lightgreen|lightgrey|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightslategrey|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|rebeccapurple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silver|skyblue|slateblue|slategray|slategrey|snow|springgreen|steelblue|tan|teal|thistle|tomato|turquoise|violet|wheat|white|whitesmoke|yellow|yellowgreen|<-non-standard-color>","namespace-prefix":"<ident>","ns-prefix":"[<ident-token>|'*']? '|'","number-percentage":"<number>|<percentage>","numeric-figure-values":"[lining-nums|oldstyle-nums]","numeric-fraction-values":"[diagonal-fractions|stacked-fractions]","numeric-spacing-values":"[proportional-nums|tabular-nums]",nth:"<an-plus-b>|even|odd","opacity()":"opacity( [<number-percentage>] )","overflow-position":"unsafe|safe","outline-radius":"<length>|<percentage>","page-body":"<declaration>? [; <page-body>]?|<page-margin-box> <page-body>","page-margin-box":"<page-margin-box-type> '{' <declaration-list> '}'","page-margin-box-type":"@top-left-corner|@top-left|@top-center|@top-right|@top-right-corner|@bottom-left-corner|@bottom-left|@bottom-center|@bottom-right|@bottom-right-corner|@left-top|@left-middle|@left-bottom|@right-top|@right-middle|@right-bottom","page-selector-list":"[<page-selector>#]?","page-selector":"<pseudo-page>+|<ident> <pseudo-page>*","page-size":"A5|A4|A3|B5|B4|JIS-B5|JIS-B4|letter|legal|ledger","path()":"path( [<fill-rule> ,]? <string> )","paint()":"paint( <ident> , <declaration-value>? )","perspective()":"perspective( <length> )","polygon()":"polygon( <fill-rule>? , [<length-percentage> <length-percentage>]# )",position:"[[left|center|right]||[top|center|bottom]|[left|center|right|<length-percentage>] [top|center|bottom|<length-percentage>]?|[[left|right] <length-percentage>]&&[[top|bottom] <length-percentage>]]","pseudo-class-selector":"':' <ident-token>|':' <function-token> <any-value> ')'","pseudo-element-selector":"':' <pseudo-class-selector>","pseudo-page":": [left|right|first|blank]",quote:"open-quote|close-quote|no-open-quote|no-close-quote","radial-gradient()":"radial-gradient( [<ending-shape>||<size>]? [at <position>]? , <color-stop-list> )","relative-selector":"<combinator>? <complex-selector>","relative-selector-list":"<relative-selector>#","relative-size":"larger|smaller","repeat-style":"repeat-x|repeat-y|[repeat|space|round|no-repeat]{1,2}","repeating-conic-gradient()":"repeating-conic-gradient( [from <angle>]? [at <position>]? , <angular-color-stop-list> )","repeating-linear-gradient()":"repeating-linear-gradient( [<angle>|to <side-or-corner>]? , <color-stop-list> )","repeating-radial-gradient()":"repeating-radial-gradient( [<ending-shape>||<size>]? [at <position>]? , <color-stop-list> )","rgb()":"rgb( <percentage>{3} [/ <alpha-value>]? )|rgb( <number>{3} [/ <alpha-value>]? )|rgb( <percentage>#{3} , <alpha-value>? )|rgb( <number>#{3} , <alpha-value>? )","rgba()":"rgba( <percentage>{3} [/ <alpha-value>]? )|rgba( <number>{3} [/ <alpha-value>]? )|rgba( <percentage>#{3} , <alpha-value>? )|rgba( <number>#{3} , <alpha-value>? )","rotate()":"rotate( [<angle>|<zero>] )","rotate3d()":"rotate3d( <number> , <number> , <number> , [<angle>|<zero>] )","rotateX()":"rotateX( [<angle>|<zero>] )","rotateY()":"rotateY( [<angle>|<zero>] )","rotateZ()":"rotateZ( [<angle>|<zero>] )","saturate()":"saturate( <number-percentage> )","scale()":"scale( <number> , <number>? )","scale3d()":"scale3d( <number> , <number> , <number> )","scaleX()":"scaleX( <number> )","scaleY()":"scaleY( <number> )","scaleZ()":"scaleZ( <number> )","self-position":"center|start|end|self-start|self-end|flex-start|flex-end","shape-radius":"<length-percentage>|closest-side|farthest-side","skew()":"skew( [<angle>|<zero>] , [<angle>|<zero>]? )","skewX()":"skewX( [<angle>|<zero>] )","skewY()":"skewY( [<angle>|<zero>] )","sepia()":"sepia( <number-percentage> )",shadow:"inset?&&<length>{2,4}&&<color>?","shadow-t":"[<length>{2,3}&&<color>?]",shape:"rect( <top> , <right> , <bottom> , <left> )|rect( <top> <right> <bottom> <left> )","shape-box":"<box>|margin-box","side-or-corner":"[left|right]||[top|bottom]","single-animation":"<time>||<easing-function>||<time>||<single-animation-iteration-count>||<single-animation-direction>||<single-animation-fill-mode>||<single-animation-play-state>||[none|<keyframes-name>]","single-animation-direction":"normal|reverse|alternate|alternate-reverse","single-animation-fill-mode":"none|forwards|backwards|both","single-animation-iteration-count":"infinite|<number>","single-animation-play-state":"running|paused","single-animation-timeline":"auto|none|<timeline-name>","single-transition":"[none|<single-transition-property>]||<time>||<easing-function>||<time>","single-transition-property":"all|<custom-ident>",size:"closest-side|farthest-side|closest-corner|farthest-corner|<length>|<length-percentage>{2}","step-position":"jump-start|jump-end|jump-none|jump-both|start|end","step-timing-function":"step-start|step-end|steps( <integer> [, <step-position>]? )","subclass-selector":"<id-selector>|<class-selector>|<attribute-selector>|<pseudo-class-selector>","supports-condition":"not <supports-in-parens>|<supports-in-parens> [and <supports-in-parens>]*|<supports-in-parens> [or <supports-in-parens>]*","supports-in-parens":"( <supports-condition> )|<supports-feature>|<general-enclosed>","supports-feature":"<supports-decl>|<supports-selector-fn>","supports-decl":"( <declaration> )","supports-selector-fn":"selector( <complex-selector> )",symbol:"<string>|<image>|<custom-ident>",target:"<target-counter()>|<target-counters()>|<target-text()>","target-counter()":"target-counter( [<string>|<url>] , <custom-ident> , <counter-style>? )","target-counters()":"target-counters( [<string>|<url>] , <custom-ident> , <string> , <counter-style>? )","target-text()":"target-text( [<string>|<url>] , [content|before|after|first-letter]? )","time-percentage":"<time>|<percentage>","timeline-name":"<custom-ident>|<string>","easing-function":"linear|<cubic-bezier-timing-function>|<step-timing-function>","track-breadth":"<length-percentage>|<flex>|min-content|max-content|auto","track-list":"[<line-names>? [<track-size>|<track-repeat>]]+ <line-names>?","track-repeat":"repeat( [<integer [1,∞]>] , [<line-names>? <track-size>]+ <line-names>? )","track-size":"<track-breadth>|minmax( <inflexible-breadth> , <track-breadth> )|fit-content( [<length>|<percentage>] )","transform-function":"<matrix()>|<translate()>|<translateX()>|<translateY()>|<scale()>|<scaleX()>|<scaleY()>|<rotate()>|<skew()>|<skewX()>|<skewY()>|<matrix3d()>|<translate3d()>|<translateZ()>|<scale3d()>|<scaleZ()>|<rotate3d()>|<rotateX()>|<rotateY()>|<rotateZ()>|<perspective()>","transform-list":"<transform-function>+","translate()":"translate( <length-percentage> , <length-percentage>? )","translate3d()":"translate3d( <length-percentage> , <length-percentage> , <length> )","translateX()":"translateX( <length-percentage> )","translateY()":"translateY( <length-percentage> )","translateZ()":"translateZ( <length> )","type-or-unit":"string|color|url|integer|number|length|angle|time|frequency|cap|ch|em|ex|ic|lh|rlh|rem|vb|vi|vw|vh|vmin|vmax|mm|Q|cm|in|pt|pc|px|deg|grad|rad|turn|ms|s|Hz|kHz|%","type-selector":"<wq-name>|<ns-prefix>? '*'","var()":"var( <custom-property-name> , <declaration-value>? )","viewport-length":"auto|<length-percentage>","visual-box":"content-box|padding-box|border-box","wq-name":"<ns-prefix>? <ident-token>","-legacy-gradient":"<-webkit-gradient()>|<-legacy-linear-gradient>|<-legacy-repeating-linear-gradient>|<-legacy-radial-gradient>|<-legacy-repeating-radial-gradient>","-legacy-linear-gradient":"-moz-linear-gradient( <-legacy-linear-gradient-arguments> )|-webkit-linear-gradient( <-legacy-linear-gradient-arguments> )|-o-linear-gradient( <-legacy-linear-gradient-arguments> )","-legacy-repeating-linear-gradient":"-moz-repeating-linear-gradient( <-legacy-linear-gradient-arguments> )|-webkit-repeating-linear-gradient( <-legacy-linear-gradient-arguments> )|-o-repeating-linear-gradient( <-legacy-linear-gradient-arguments> )","-legacy-linear-gradient-arguments":"[<angle>|<side-or-corner>]? , <color-stop-list>","-legacy-radial-gradient":"-moz-radial-gradient( <-legacy-radial-gradient-arguments> )|-webkit-radial-gradient( <-legacy-radial-gradient-arguments> )|-o-radial-gradient( <-legacy-radial-gradient-arguments> )","-legacy-repeating-radial-gradient":"-moz-repeating-radial-gradient( <-legacy-radial-gradient-arguments> )|-webkit-repeating-radial-gradient( <-legacy-radial-gradient-arguments> )|-o-repeating-radial-gradient( <-legacy-radial-gradient-arguments> )","-legacy-radial-gradient-arguments":"[<position> ,]? [[[<-legacy-radial-gradient-shape>||<-legacy-radial-gradient-size>]|[<length>|<percentage>]{2}] ,]? <color-stop-list>","-legacy-radial-gradient-size":"closest-side|closest-corner|farthest-side|farthest-corner|contain|cover","-legacy-radial-gradient-shape":"circle|ellipse","-non-standard-font":"-apple-system-body|-apple-system-headline|-apple-system-subheadline|-apple-system-caption1|-apple-system-caption2|-apple-system-footnote|-apple-system-short-body|-apple-system-short-headline|-apple-system-short-subheadline|-apple-system-short-caption1|-apple-system-short-footnote|-apple-system-tall-body","-non-standard-color":"-moz-ButtonDefault|-moz-ButtonHoverFace|-moz-ButtonHoverText|-moz-CellHighlight|-moz-CellHighlightText|-moz-Combobox|-moz-ComboboxText|-moz-Dialog|-moz-DialogText|-moz-dragtargetzone|-moz-EvenTreeRow|-moz-Field|-moz-FieldText|-moz-html-CellHighlight|-moz-html-CellHighlightText|-moz-mac-accentdarkestshadow|-moz-mac-accentdarkshadow|-moz-mac-accentface|-moz-mac-accentlightesthighlight|-moz-mac-accentlightshadow|-moz-mac-accentregularhighlight|-moz-mac-accentregularshadow|-moz-mac-chrome-active|-moz-mac-chrome-inactive|-moz-mac-focusring|-moz-mac-menuselect|-moz-mac-menushadow|-moz-mac-menutextselect|-moz-MenuHover|-moz-MenuHoverText|-moz-MenuBarText|-moz-MenuBarHoverText|-moz-nativehyperlinktext|-moz-OddTreeRow|-moz-win-communicationstext|-moz-win-mediatext|-moz-activehyperlinktext|-moz-default-background-color|-moz-default-color|-moz-hyperlinktext|-moz-visitedhyperlinktext|-webkit-activelink|-webkit-focus-ring-color|-webkit-link|-webkit-text","-non-standard-image-rendering":"optimize-contrast|-moz-crisp-edges|-o-crisp-edges|-webkit-optimize-contrast","-non-standard-overflow":"-moz-scrollbars-none|-moz-scrollbars-horizontal|-moz-scrollbars-vertical|-moz-hidden-unscrollable","-non-standard-width":"fill-available|min-intrinsic|intrinsic|-moz-available|-moz-fit-content|-moz-min-content|-moz-max-content|-webkit-min-content|-webkit-max-content","-webkit-gradient()":"-webkit-gradient( <-webkit-gradient-type> , <-webkit-gradient-point> [, <-webkit-gradient-point>|, <-webkit-gradient-radius> , <-webkit-gradient-point>] [, <-webkit-gradient-radius>]? [, <-webkit-gradient-color-stop>]* )","-webkit-gradient-color-stop":"from( <color> )|color-stop( [<number-zero-one>|<percentage>] , <color> )|to( <color> )","-webkit-gradient-point":"[left|center|right|<length-percentage>] [top|center|bottom|<length-percentage>]","-webkit-gradient-radius":"<length>|<percentage>","-webkit-gradient-type":"linear|radial","-webkit-mask-box-repeat":"repeat|stretch|round","-webkit-mask-clip-style":"border|border-box|padding|padding-box|content|content-box|text","-ms-filter-function-list":"<-ms-filter-function>+","-ms-filter-function":"<-ms-filter-function-progid>|<-ms-filter-function-legacy>","-ms-filter-function-progid":"'progid:' [<ident-token> '.']* [<ident-token>|<function-token> <any-value>? )]","-ms-filter-function-legacy":"<ident-token>|<function-token> <any-value>? )","-ms-filter":"<string>",age:"child|young|old","attr-name":"<wq-name>","attr-fallback":"<any-value>","bg-clip":"<box>|border|text","border-radius":"<length-percentage>{1,2}",bottom:"<length>|auto","generic-voice":"[<age>? <gender> <integer>?]",gender:"male|female|neutral","lab()":"lab( [<percentage>|<number>|none] [<percentage>|<number>|none] [<percentage>|<number>|none] [/ [<alpha-value>|none]]? )","lch()":"lch( [<percentage>|<number>|none] [<percentage>|<number>|none] [<hue>|none] [/ [<alpha-value>|none]]? )",left:"<length>|auto","mask-image":"<mask-reference>#",paint:"none|<color>|<url> [none|<color>]?|context-fill|context-stroke",ratio:"<number [0,∞]> [/ <number [0,∞]>]?","reversed-counter-name":"reversed( <counter-name> )",right:"<length>|auto","svg-length":"<percentage>|<length>|<number>","svg-writing-mode":"lr-tb|rl-tb|tb-rl|lr|rl|tb",top:"<length>|auto","track-group":"'(' [<string>* <track-minmax> <string>*]+ ')' ['[' <positive-integer> ']']?|<track-minmax>","track-list-v0":"[<string>* <track-group> <string>*]+|none","track-minmax":"minmax( <track-breadth> , <track-breadth> )|auto|<track-breadth>|fit-content",x:"<number>",y:"<number>",declaration:"<ident-token> : <declaration-value>? ['!' important]?","declaration-list":"[<declaration>? ';']* <declaration>?",url:"url( <string> <url-modifier>* )|<url-token>","url-modifier":"<ident>|<function-token> <any-value> )","number-zero-one":"<number [0,1]>","number-one-or-greater":"<number [1,∞]>","positive-integer":"<integer [0,∞]>","-non-standard-display":"-ms-inline-flexbox|-ms-grid|-ms-inline-grid|-webkit-flex|-webkit-inline-flex|-webkit-box|-webkit-inline-box|-moz-inline-stack|-moz-box|-moz-inline-box"},properties:{"--*":"<declaration-value>","-ms-accelerator":"false|true","-ms-block-progression":"tb|rl|bt|lr","-ms-content-zoom-chaining":"none|chained","-ms-content-zooming":"none|zoom","-ms-content-zoom-limit":"<'-ms-content-zoom-limit-min'> <'-ms-content-zoom-limit-max'>","-ms-content-zoom-limit-max":"<percentage>","-ms-content-zoom-limit-min":"<percentage>","-ms-content-zoom-snap":"<'-ms-content-zoom-snap-type'>||<'-ms-content-zoom-snap-points'>","-ms-content-zoom-snap-points":"snapInterval( <percentage> , <percentage> )|snapList( <percentage># )","-ms-content-zoom-snap-type":"none|proximity|mandatory","-ms-filter":"<string>","-ms-flow-from":"[none|<custom-ident>]#","-ms-flow-into":"[none|<custom-ident>]#","-ms-grid-columns":"none|<track-list>|<auto-track-list>","-ms-grid-rows":"none|<track-list>|<auto-track-list>","-ms-high-contrast-adjust":"auto|none","-ms-hyphenate-limit-chars":"auto|<integer>{1,3}","-ms-hyphenate-limit-lines":"no-limit|<integer>","-ms-hyphenate-limit-zone":"<percentage>|<length>","-ms-ime-align":"auto|after","-ms-overflow-style":"auto|none|scrollbar|-ms-autohiding-scrollbar","-ms-scrollbar-3dlight-color":"<color>","-ms-scrollbar-arrow-color":"<color>","-ms-scrollbar-base-color":"<color>","-ms-scrollbar-darkshadow-color":"<color>","-ms-scrollbar-face-color":"<color>","-ms-scrollbar-highlight-color":"<color>","-ms-scrollbar-shadow-color":"<color>","-ms-scrollbar-track-color":"<color>","-ms-scroll-chaining":"chained|none","-ms-scroll-limit":"<'-ms-scroll-limit-x-min'> <'-ms-scroll-limit-y-min'> <'-ms-scroll-limit-x-max'> <'-ms-scroll-limit-y-max'>","-ms-scroll-limit-x-max":"auto|<length>","-ms-scroll-limit-x-min":"<length>","-ms-scroll-limit-y-max":"auto|<length>","-ms-scroll-limit-y-min":"<length>","-ms-scroll-rails":"none|railed","-ms-scroll-snap-points-x":"snapInterval( <length-percentage> , <length-percentage> )|snapList( <length-percentage># )","-ms-scroll-snap-points-y":"snapInterval( <length-percentage> , <length-percentage> )|snapList( <length-percentage># )","-ms-scroll-snap-type":"none|proximity|mandatory","-ms-scroll-snap-x":"<'-ms-scroll-snap-type'> <'-ms-scroll-snap-points-x'>","-ms-scroll-snap-y":"<'-ms-scroll-snap-type'> <'-ms-scroll-snap-points-y'>","-ms-scroll-translation":"none|vertical-to-horizontal","-ms-text-autospace":"none|ideograph-alpha|ideograph-numeric|ideograph-parenthesis|ideograph-space","-ms-touch-select":"grippers|none","-ms-user-select":"none|element|text","-ms-wrap-flow":"auto|both|start|end|maximum|clear","-ms-wrap-margin":"<length>","-ms-wrap-through":"wrap|none","-moz-appearance":"none|button|button-arrow-down|button-arrow-next|button-arrow-previous|button-arrow-up|button-bevel|button-focus|caret|checkbox|checkbox-container|checkbox-label|checkmenuitem|dualbutton|groupbox|listbox|listitem|menuarrow|menubar|menucheckbox|menuimage|menuitem|menuitemtext|menulist|menulist-button|menulist-text|menulist-textfield|menupopup|menuradio|menuseparator|meterbar|meterchunk|progressbar|progressbar-vertical|progresschunk|progresschunk-vertical|radio|radio-container|radio-label|radiomenuitem|range|range-thumb|resizer|resizerpanel|scale-horizontal|scalethumbend|scalethumb-horizontal|scalethumbstart|scalethumbtick|scalethumb-vertical|scale-vertical|scrollbarbutton-down|scrollbarbutton-left|scrollbarbutton-right|scrollbarbutton-up|scrollbarthumb-horizontal|scrollbarthumb-vertical|scrollbartrack-horizontal|scrollbartrack-vertical|searchfield|separator|sheet|spinner|spinner-downbutton|spinner-textfield|spinner-upbutton|splitter|statusbar|statusbarpanel|tab|tabpanel|tabpanels|tab-scroll-arrow-back|tab-scroll-arrow-forward|textfield|textfield-multiline|toolbar|toolbarbutton|toolbarbutton-dropdown|toolbargripper|toolbox|tooltip|treeheader|treeheadercell|treeheadersortarrow|treeitem|treeline|treetwisty|treetwistyopen|treeview|-moz-mac-unified-toolbar|-moz-win-borderless-glass|-moz-win-browsertabbar-toolbox|-moz-win-communicationstext|-moz-win-communications-toolbox|-moz-win-exclude-glass|-moz-win-glass|-moz-win-mediatext|-moz-win-media-toolbox|-moz-window-button-box|-moz-window-button-box-maximized|-moz-window-button-close|-moz-window-button-maximize|-moz-window-button-minimize|-moz-window-button-restore|-moz-window-frame-bottom|-moz-window-frame-left|-moz-window-frame-right|-moz-window-titlebar|-moz-window-titlebar-maximized","-moz-binding":"<url>|none","-moz-border-bottom-colors":"<color>+|none","-moz-border-left-colors":"<color>+|none","-moz-border-right-colors":"<color>+|none","-moz-border-top-colors":"<color>+|none","-moz-context-properties":"none|[fill|fill-opacity|stroke|stroke-opacity]#","-moz-float-edge":"border-box|content-box|margin-box|padding-box","-moz-force-broken-image-icon":"0|1","-moz-image-region":"<shape>|auto","-moz-orient":"inline|block|horizontal|vertical","-moz-outline-radius":"<outline-radius>{1,4} [/ <outline-radius>{1,4}]?","-moz-outline-radius-bottomleft":"<outline-radius>","-moz-outline-radius-bottomright":"<outline-radius>","-moz-outline-radius-topleft":"<outline-radius>","-moz-outline-radius-topright":"<outline-radius>","-moz-stack-sizing":"ignore|stretch-to-fit","-moz-text-blink":"none|blink","-moz-user-focus":"ignore|normal|select-after|select-before|select-menu|select-same|select-all|none","-moz-user-input":"auto|none|enabled|disabled","-moz-user-modify":"read-only|read-write|write-only","-moz-window-dragging":"drag|no-drag","-moz-window-shadow":"default|menu|tooltip|sheet|none","-webkit-appearance":"none|button|button-bevel|caps-lock-indicator|caret|checkbox|default-button|inner-spin-button|listbox|listitem|media-controls-background|media-controls-fullscreen-background|media-current-time-display|media-enter-fullscreen-button|media-exit-fullscreen-button|media-fullscreen-button|media-mute-button|media-overlay-play-button|media-play-button|media-seek-back-button|media-seek-forward-button|media-slider|media-sliderthumb|media-time-remaining-display|media-toggle-closed-captions-button|media-volume-slider|media-volume-slider-container|media-volume-sliderthumb|menulist|menulist-button|menulist-text|menulist-textfield|meter|progress-bar|progress-bar-value|push-button|radio|scrollbarbutton-down|scrollbarbutton-left|scrollbarbutton-right|scrollbarbutton-up|scrollbargripper-horizontal|scrollbargripper-vertical|scrollbarthumb-horizontal|scrollbarthumb-vertical|scrollbartrack-horizontal|scrollbartrack-vertical|searchfield|searchfield-cancel-button|searchfield-decoration|searchfield-results-button|searchfield-results-decoration|slider-horizontal|slider-vertical|sliderthumb-horizontal|sliderthumb-vertical|square-button|textarea|textfield|-apple-pay-button","-webkit-border-before":"<'border-width'>||<'border-style'>||<color>","-webkit-border-before-color":"<color>","-webkit-border-before-style":"<'border-style'>","-webkit-border-before-width":"<'border-width'>","-webkit-box-reflect":"[above|below|right|left]? <length>? <image>?","-webkit-line-clamp":"none|<integer>","-webkit-mask":"[<mask-reference>||<position> [/ <bg-size>]?||<repeat-style>||[<box>|border|padding|content|text]||[<box>|border|padding|content]]#","-webkit-mask-attachment":"<attachment>#","-webkit-mask-clip":"[<box>|border|padding|content|text]#","-webkit-mask-composite":"<composite-style>#","-webkit-mask-image":"<mask-reference>#","-webkit-mask-origin":"[<box>|border|padding|content]#","-webkit-mask-position":"<position>#","-webkit-mask-position-x":"[<length-percentage>|left|center|right]#","-webkit-mask-position-y":"[<length-percentage>|top|center|bottom]#","-webkit-mask-repeat":"<repeat-style>#","-webkit-mask-repeat-x":"repeat|no-repeat|space|round","-webkit-mask-repeat-y":"repeat|no-repeat|space|round","-webkit-mask-size":"<bg-size>#","-webkit-overflow-scrolling":"auto|touch","-webkit-tap-highlight-color":"<color>","-webkit-text-fill-color":"<color>","-webkit-text-stroke":"<length>||<color>","-webkit-text-stroke-color":"<color>","-webkit-text-stroke-width":"<length>","-webkit-touch-callout":"default|none","-webkit-user-modify":"read-only|read-write|read-write-plaintext-only","accent-color":"auto|<color>","align-content":"normal|<baseline-position>|<content-distribution>|<overflow-position>? <content-position>","align-items":"normal|stretch|<baseline-position>|[<overflow-position>? <self-position>]","align-self":"auto|normal|stretch|<baseline-position>|<overflow-position>? <self-position>","align-tracks":"[normal|<baseline-position>|<content-distribution>|<overflow-position>? <content-position>]#",all:"initial|inherit|unset|revert|revert-layer",animation:"<single-animation>#","animation-delay":"<time>#","animation-direction":"<single-animation-direction>#","animation-duration":"<time>#","animation-fill-mode":"<single-animation-fill-mode>#","animation-iteration-count":"<single-animation-iteration-count>#","animation-name":"[none|<keyframes-name>]#","animation-play-state":"<single-animation-play-state>#","animation-timing-function":"<easing-function>#","animation-timeline":"<single-animation-timeline>#",appearance:"none|auto|textfield|menulist-button|<compat-auto>","aspect-ratio":"auto|<ratio>",azimuth:"<angle>|[[left-side|far-left|left|center-left|center|center-right|right|far-right|right-side]||behind]|leftwards|rightwards","backdrop-filter":"none|<filter-function-list>","backface-visibility":"visible|hidden",background:"[<bg-layer> ,]* <final-bg-layer>","background-attachment":"<attachment>#","background-blend-mode":"<blend-mode>#","background-clip":"<bg-clip>#","background-color":"<color>","background-image":"<bg-image>#","background-origin":"<box>#","background-position":"<bg-position>#","background-position-x":"[center|[[left|right|x-start|x-end]? <length-percentage>?]!]#","background-position-y":"[center|[[top|bottom|y-start|y-end]? <length-percentage>?]!]#","background-repeat":"<repeat-style>#","background-size":"<bg-size>#","block-overflow":"clip|ellipsis|<string>","block-size":"<'width'>",border:"<line-width>||<line-style>||<color>","border-block":"<'border-top-width'>||<'border-top-style'>||<color>","border-block-color":"<'border-top-color'>{1,2}","border-block-style":"<'border-top-style'>","border-block-width":"<'border-top-width'>","border-block-end":"<'border-top-width'>||<'border-top-style'>||<color>","border-block-end-color":"<'border-top-color'>","border-block-end-style":"<'border-top-style'>","border-block-end-width":"<'border-top-width'>","border-block-start":"<'border-top-width'>||<'border-top-style'>||<color>","border-block-start-color":"<'border-top-color'>","border-block-start-style":"<'border-top-style'>","border-block-start-width":"<'border-top-width'>","border-bottom":"<line-width>||<line-style>||<color>","border-bottom-color":"<'border-top-color'>","border-bottom-left-radius":"<length-percentage>{1,2}","border-bottom-right-radius":"<length-percentage>{1,2}","border-bottom-style":"<line-style>","border-bottom-width":"<line-width>","border-collapse":"collapse|separate","border-color":"<color>{1,4}","border-end-end-radius":"<length-percentage>{1,2}","border-end-start-radius":"<length-percentage>{1,2}","border-image":"<'border-image-source'>||<'border-image-slice'> [/ <'border-image-width'>|/ <'border-image-width'>? / <'border-image-outset'>]?||<'border-image-repeat'>","border-image-outset":"[<length>|<number>]{1,4}","border-image-repeat":"[stretch|repeat|round|space]{1,2}","border-image-slice":"<number-percentage>{1,4}&&fill?","border-image-source":"none|<image>","border-image-width":"[<length-percentage>|<number>|auto]{1,4}","border-inline":"<'border-top-width'>||<'border-top-style'>||<color>","border-inline-end":"<'border-top-width'>||<'border-top-style'>||<color>","border-inline-color":"<'border-top-color'>{1,2}","border-inline-style":"<'border-top-style'>","border-inline-width":"<'border-top-width'>","border-inline-end-color":"<'border-top-color'>","border-inline-end-style":"<'border-top-style'>","border-inline-end-width":"<'border-top-width'>","border-inline-start":"<'border-top-width'>||<'border-top-style'>||<color>","border-inline-start-color":"<'border-top-color'>","border-inline-start-style":"<'border-top-style'>","border-inline-start-width":"<'border-top-width'>","border-left":"<line-width>||<line-style>||<color>","border-left-color":"<color>","border-left-style":"<line-style>","border-left-width":"<line-width>","border-radius":"<length-percentage>{1,4} [/ <length-percentage>{1,4}]?","border-right":"<line-width>||<line-style>||<color>","border-right-color":"<color>","border-right-style":"<line-style>","border-right-width":"<line-width>","border-spacing":"<length> <length>?","border-start-end-radius":"<length-percentage>{1,2}","border-start-start-radius":"<length-percentage>{1,2}","border-style":"<line-style>{1,4}","border-top":"<line-width>||<line-style>||<color>","border-top-color":"<color>","border-top-left-radius":"<length-percentage>{1,2}","border-top-right-radius":"<length-percentage>{1,2}","border-top-style":"<line-style>","border-top-width":"<line-width>","border-width":"<line-width>{1,4}",bottom:"<length>|<percentage>|auto","box-align":"start|center|end|baseline|stretch","box-decoration-break":"slice|clone","box-direction":"normal|reverse|inherit","box-flex":"<number>","box-flex-group":"<integer>","box-lines":"single|multiple","box-ordinal-group":"<integer>","box-orient":"horizontal|vertical|inline-axis|block-axis|inherit","box-pack":"start|center|end|justify","box-shadow":"none|<shadow>#","box-sizing":"content-box|border-box","break-after":"auto|avoid|always|all|avoid-page|page|left|right|recto|verso|avoid-column|column|avoid-region|region","break-before":"auto|avoid|always|all|avoid-page|page|left|right|recto|verso|avoid-column|column|avoid-region|region","break-inside":"auto|avoid|avoid-page|avoid-column|avoid-region","caption-side":"top|bottom|block-start|block-end|inline-start|inline-end","caret-color":"auto|<color>",clear:"none|left|right|both|inline-start|inline-end",clip:"<shape>|auto","clip-path":"<clip-source>|[<basic-shape>||<geometry-box>]|none",color:"<color>","print-color-adjust":"economy|exact","color-scheme":"normal|[light|dark|<custom-ident>]+&&only?","column-count":"<integer>|auto","column-fill":"auto|balance|balance-all","column-gap":"normal|<length-percentage>","column-rule":"<'column-rule-width'>||<'column-rule-style'>||<'column-rule-color'>","column-rule-color":"<color>","column-rule-style":"<'border-style'>","column-rule-width":"<'border-width'>","column-span":"none|all","column-width":"<length>|auto",columns:"<'column-width'>||<'column-count'>",contain:"none|strict|content|[size||layout||style||paint]",content:"normal|none|[<content-replacement>|<content-list>] [/ [<string>|<counter>]+]?","content-visibility":"visible|auto|hidden","counter-increment":"[<counter-name> <integer>?]+|none","counter-reset":"[<counter-name> <integer>?|<reversed-counter-name> <integer>?]+|none","counter-set":"[<counter-name> <integer>?]+|none",cursor:"[[<url> [<x> <y>]? ,]* [auto|default|none|context-menu|help|pointer|progress|wait|cell|crosshair|text|vertical-text|alias|copy|move|no-drop|not-allowed|e-resize|n-resize|ne-resize|nw-resize|s-resize|se-resize|sw-resize|w-resize|ew-resize|ns-resize|nesw-resize|nwse-resize|col-resize|row-resize|all-scroll|zoom-in|zoom-out|grab|grabbing|hand|-webkit-grab|-webkit-grabbing|-webkit-zoom-in|-webkit-zoom-out|-moz-grab|-moz-grabbing|-moz-zoom-in|-moz-zoom-out]]",direction:"ltr|rtl",display:"[<display-outside>||<display-inside>]|<display-listitem>|<display-internal>|<display-box>|<display-legacy>|<-non-standard-display>","empty-cells":"show|hide",filter:"none|<filter-function-list>|<-ms-filter-function-list>",flex:"none|[<'flex-grow'> <'flex-shrink'>?||<'flex-basis'>]","flex-basis":"content|<'width'>","flex-direction":"row|row-reverse|column|column-reverse","flex-flow":"<'flex-direction'>||<'flex-wrap'>","flex-grow":"<number>","flex-shrink":"<number>","flex-wrap":"nowrap|wrap|wrap-reverse",float:"left|right|none|inline-start|inline-end",font:"[[<'font-style'>||<font-variant-css21>||<'font-weight'>||<'font-stretch'>]? <'font-size'> [/ <'line-height'>]? <'font-family'>]|caption|icon|menu|message-box|small-caption|status-bar","font-family":"[<family-name>|<generic-family>]#","font-feature-settings":"normal|<feature-tag-value>#","font-kerning":"auto|normal|none","font-language-override":"normal|<string>","font-optical-sizing":"auto|none","font-variation-settings":"normal|[<string> <number>]#","font-size":"<absolute-size>|<relative-size>|<length-percentage>","font-size-adjust":"none|[ex-height|cap-height|ch-width|ic-width|ic-height]? [from-font|<number>]","font-smooth":"auto|never|always|<absolute-size>|<length>","font-stretch":"<font-stretch-absolute>","font-style":"normal|italic|oblique <angle>?","font-synthesis":"none|[weight||style||small-caps]","font-variant":"normal|none|[<common-lig-values>||<discretionary-lig-values>||<historical-lig-values>||<contextual-alt-values>||stylistic( <feature-value-name> )||historical-forms||styleset( <feature-value-name># )||character-variant( <feature-value-name># )||swash( <feature-value-name> )||ornaments( <feature-value-name> )||annotation( <feature-value-name> )||[small-caps|all-small-caps|petite-caps|all-petite-caps|unicase|titling-caps]||<numeric-figure-values>||<numeric-spacing-values>||<numeric-fraction-values>||ordinal||slashed-zero||<east-asian-variant-values>||<east-asian-width-values>||ruby]","font-variant-alternates":"normal|[stylistic( <feature-value-name> )||historical-forms||styleset( <feature-value-name># )||character-variant( <feature-value-name># )||swash( <feature-value-name> )||ornaments( <feature-value-name> )||annotation( <feature-value-name> )]","font-variant-caps":"normal|small-caps|all-small-caps|petite-caps|all-petite-caps|unicase|titling-caps","font-variant-east-asian":"normal|[<east-asian-variant-values>||<east-asian-width-values>||ruby]","font-variant-ligatures":"normal|none|[<common-lig-values>||<discretionary-lig-values>||<historical-lig-values>||<contextual-alt-values>]","font-variant-numeric":"normal|[<numeric-figure-values>||<numeric-spacing-values>||<numeric-fraction-values>||ordinal||slashed-zero]","font-variant-position":"normal|sub|super","font-weight":"<font-weight-absolute>|bolder|lighter","forced-color-adjust":"auto|none",gap:"<'row-gap'> <'column-gap'>?",grid:"<'grid-template'>|<'grid-template-rows'> / [auto-flow&&dense?] <'grid-auto-columns'>?|[auto-flow&&dense?] <'grid-auto-rows'>? / <'grid-template-columns'>","grid-area":"<grid-line> [/ <grid-line>]{0,3}","grid-auto-columns":"<track-size>+","grid-auto-flow":"[row|column]||dense","grid-auto-rows":"<track-size>+","grid-column":"<grid-line> [/ <grid-line>]?","grid-column-end":"<grid-line>","grid-column-gap":"<length-percentage>","grid-column-start":"<grid-line>","grid-gap":"<'grid-row-gap'> <'grid-column-gap'>?","grid-row":"<grid-line> [/ <grid-line>]?","grid-row-end":"<grid-line>","grid-row-gap":"<length-percentage>","grid-row-start":"<grid-line>","grid-template":"none|[<'grid-template-rows'> / <'grid-template-columns'>]|[<line-names>? <string> <track-size>? <line-names>?]+ [/ <explicit-track-list>]?","grid-template-areas":"none|<string>+","grid-template-columns":"none|<track-list>|<auto-track-list>|subgrid <line-name-list>?","grid-template-rows":"none|<track-list>|<auto-track-list>|subgrid <line-name-list>?","hanging-punctuation":"none|[first||[force-end|allow-end]||last]",height:"auto|<length>|<percentage>|min-content|max-content|fit-content|fit-content( <length-percentage> )","hyphenate-character":"auto|<string>",hyphens:"none|manual|auto","image-orientation":"from-image|<angle>|[<angle>? flip]","image-rendering":"auto|crisp-edges|pixelated|optimizeSpeed|optimizeQuality|<-non-standard-image-rendering>","image-resolution":"[from-image||<resolution>]&&snap?","ime-mode":"auto|normal|active|inactive|disabled","initial-letter":"normal|[<number> <integer>?]","initial-letter-align":"[auto|alphabetic|hanging|ideographic]","inline-size":"<'width'>","input-security":"auto|none",inset:"<'top'>{1,4}","inset-block":"<'top'>{1,2}","inset-block-end":"<'top'>","inset-block-start":"<'top'>","inset-inline":"<'top'>{1,2}","inset-inline-end":"<'top'>","inset-inline-start":"<'top'>",isolation:"auto|isolate","justify-content":"normal|<content-distribution>|<overflow-position>? [<content-position>|left|right]","justify-items":"normal|stretch|<baseline-position>|<overflow-position>? [<self-position>|left|right]|legacy|legacy&&[left|right|center]","justify-self":"auto|normal|stretch|<baseline-position>|<overflow-position>? [<self-position>|left|right]","justify-tracks":"[normal|<content-distribution>|<overflow-position>? [<content-position>|left|right]]#",left:"<length>|<percentage>|auto","letter-spacing":"normal|<length-percentage>","line-break":"auto|loose|normal|strict|anywhere","line-clamp":"none|<integer>","line-height":"normal|<number>|<length>|<percentage>","line-height-step":"<length>","list-style":"<'list-style-type'>||<'list-style-position'>||<'list-style-image'>","list-style-image":"<image>|none","list-style-position":"inside|outside","list-style-type":"<counter-style>|<string>|none",margin:"[<length>|<percentage>|auto]{1,4}","margin-block":"<'margin-left'>{1,2}","margin-block-end":"<'margin-left'>","margin-block-start":"<'margin-left'>","margin-bottom":"<length>|<percentage>|auto","margin-inline":"<'margin-left'>{1,2}","margin-inline-end":"<'margin-left'>","margin-inline-start":"<'margin-left'>","margin-left":"<length>|<percentage>|auto","margin-right":"<length>|<percentage>|auto","margin-top":"<length>|<percentage>|auto","margin-trim":"none|in-flow|all",mask:"<mask-layer>#","mask-border":"<'mask-border-source'>||<'mask-border-slice'> [/ <'mask-border-width'>? [/ <'mask-border-outset'>]?]?||<'mask-border-repeat'>||<'mask-border-mode'>","mask-border-mode":"luminance|alpha","mask-border-outset":"[<length>|<number>]{1,4}","mask-border-repeat":"[stretch|repeat|round|space]{1,2}","mask-border-slice":"<number-percentage>{1,4} fill?","mask-border-source":"none|<image>","mask-border-width":"[<length-percentage>|<number>|auto]{1,4}","mask-clip":"[<geometry-box>|no-clip]#","mask-composite":"<compositing-operator>#","mask-image":"<mask-reference>#","mask-mode":"<masking-mode>#","mask-origin":"<geometry-box>#","mask-position":"<position>#","mask-repeat":"<repeat-style>#","mask-size":"<bg-size>#","mask-type":"luminance|alpha","masonry-auto-flow":"[pack|next]||[definite-first|ordered]","math-style":"normal|compact","max-block-size":"<'max-width'>","max-height":"none|<length-percentage>|min-content|max-content|fit-content|fit-content( <length-percentage> )","max-inline-size":"<'max-width'>","max-lines":"none|<integer>","max-width":"none|<length-percentage>|min-content|max-content|fit-content|fit-content( <length-percentage> )|<-non-standard-width>","min-block-size":"<'min-width'>","min-height":"auto|<length>|<percentage>|min-content|max-content|fit-content|fit-content( <length-percentage> )","min-inline-size":"<'min-width'>","min-width":"auto|<length>|<percentage>|min-content|max-content|fit-content|fit-content( <length-percentage> )|<-non-standard-width>","mix-blend-mode":"<blend-mode>|plus-lighter","object-fit":"fill|contain|cover|none|scale-down","object-position":"<position>",offset:"[<'offset-position'>? [<'offset-path'> [<'offset-distance'>||<'offset-rotate'>]?]?]! [/ <'offset-anchor'>]?","offset-anchor":"auto|<position>","offset-distance":"<length-percentage>","offset-path":"none|ray( [<angle>&&<size>&&contain?] )|<path()>|<url>|[<basic-shape>||<geometry-box>]","offset-position":"auto|<position>","offset-rotate":"[auto|reverse]||<angle>",opacity:"<alpha-value>",order:"<integer>",orphans:"<integer>",outline:"[<'outline-color'>||<'outline-style'>||<'outline-width'>]","outline-color":"<color>|invert","outline-offset":"<length>","outline-style":"auto|<'border-style'>","outline-width":"<line-width>",overflow:"[visible|hidden|clip|scroll|auto]{1,2}|<-non-standard-overflow>","overflow-anchor":"auto|none","overflow-block":"visible|hidden|clip|scroll|auto","overflow-clip-box":"padding-box|content-box","overflow-clip-margin":"<visual-box>||<length [0,∞]>","overflow-inline":"visible|hidden|clip|scroll|auto","overflow-wrap":"normal|break-word|anywhere","overflow-x":"visible|hidden|clip|scroll|auto","overflow-y":"visible|hidden|clip|scroll|auto","overscroll-behavior":"[contain|none|auto]{1,2}","overscroll-behavior-block":"contain|none|auto","overscroll-behavior-inline":"contain|none|auto","overscroll-behavior-x":"contain|none|auto","overscroll-behavior-y":"contain|none|auto",padding:"[<length>|<percentage>]{1,4}","padding-block":"<'padding-left'>{1,2}","padding-block-end":"<'padding-left'>","padding-block-start":"<'padding-left'>","padding-bottom":"<length>|<percentage>","padding-inline":"<'padding-left'>{1,2}","padding-inline-end":"<'padding-left'>","padding-inline-start":"<'padding-left'>","padding-left":"<length>|<percentage>","padding-right":"<length>|<percentage>","padding-top":"<length>|<percentage>","page-break-after":"auto|always|avoid|left|right|recto|verso","page-break-before":"auto|always|avoid|left|right|recto|verso","page-break-inside":"auto|avoid","paint-order":"normal|[fill||stroke||markers]",perspective:"none|<length>","perspective-origin":"<position>","place-content":"<'align-content'> <'justify-content'>?","place-items":"<'align-items'> <'justify-items'>?","place-self":"<'align-self'> <'justify-self'>?","pointer-events":"auto|none|visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|inherit",position:"static|relative|absolute|sticky|fixed|-webkit-sticky",quotes:"none|auto|[<string> <string>]+",resize:"none|both|horizontal|vertical|block|inline",right:"<length>|<percentage>|auto",rotate:"none|<angle>|[x|y|z|<number>{3}]&&<angle>","row-gap":"normal|<length-percentage>","ruby-align":"start|center|space-between|space-around","ruby-merge":"separate|collapse|auto","ruby-position":"[alternate||[over|under]]|inter-character",scale:"none|<number>{1,3}","scrollbar-color":"auto|<color>{2}","scrollbar-gutter":"auto|stable&&both-edges?","scrollbar-width":"auto|thin|none","scroll-behavior":"auto|smooth","scroll-margin":"<length>{1,4}","scroll-margin-block":"<length>{1,2}","scroll-margin-block-start":"<length>","scroll-margin-block-end":"<length>","scroll-margin-bottom":"<length>","scroll-margin-inline":"<length>{1,2}","scroll-margin-inline-start":"<length>","scroll-margin-inline-end":"<length>","scroll-margin-left":"<length>","scroll-margin-right":"<length>","scroll-margin-top":"<length>","scroll-padding":"[auto|<length-percentage>]{1,4}","scroll-padding-block":"[auto|<length-percentage>]{1,2}","scroll-padding-block-start":"auto|<length-percentage>","scroll-padding-block-end":"auto|<length-percentage>","scroll-padding-bottom":"auto|<length-percentage>","scroll-padding-inline":"[auto|<length-percentage>]{1,2}","scroll-padding-inline-start":"auto|<length-percentage>","scroll-padding-inline-end":"auto|<length-percentage>","scroll-padding-left":"auto|<length-percentage>","scroll-padding-right":"auto|<length-percentage>","scroll-padding-top":"auto|<length-percentage>","scroll-snap-align":"[none|start|end|center]{1,2}","scroll-snap-coordinate":"none|<position>#","scroll-snap-destination":"<position>","scroll-snap-points-x":"none|repeat( <length-percentage> )","scroll-snap-points-y":"none|repeat( <length-percentage> )","scroll-snap-stop":"normal|always","scroll-snap-type":"none|[x|y|block|inline|both] [mandatory|proximity]?","scroll-snap-type-x":"none|mandatory|proximity","scroll-snap-type-y":"none|mandatory|proximity","shape-image-threshold":"<alpha-value>","shape-margin":"<length-percentage>","shape-outside":"none|[<shape-box>||<basic-shape>]|<image>","tab-size":"<integer>|<length>","table-layout":"auto|fixed","text-align":"start|end|left|right|center|justify|match-parent","text-align-last":"auto|start|end|left|right|center|justify","text-combine-upright":"none|all|[digits <integer>?]","text-decoration":"<'text-decoration-line'>||<'text-decoration-style'>||<'text-decoration-color'>||<'text-decoration-thickness'>","text-decoration-color":"<color>","text-decoration-line":"none|[underline||overline||line-through||blink]|spelling-error|grammar-error","text-decoration-skip":"none|[objects||[spaces|[leading-spaces||trailing-spaces]]||edges||box-decoration]","text-decoration-skip-ink":"auto|all|none","text-decoration-style":"solid|double|dotted|dashed|wavy","text-decoration-thickness":"auto|from-font|<length>|<percentage>","text-emphasis":"<'text-emphasis-style'>||<'text-emphasis-color'>","text-emphasis-color":"<color>","text-emphasis-position":"[over|under]&&[right|left]","text-emphasis-style":"none|[[filled|open]||[dot|circle|double-circle|triangle|sesame]]|<string>","text-indent":"<length-percentage>&&hanging?&&each-line?","text-justify":"auto|inter-character|inter-word|none","text-orientation":"mixed|upright|sideways","text-overflow":"[clip|ellipsis|<string>]{1,2}","text-rendering":"auto|optimizeSpeed|optimizeLegibility|geometricPrecision","text-shadow":"none|<shadow-t>#","text-size-adjust":"none|auto|<percentage>","text-transform":"none|capitalize|uppercase|lowercase|full-width|full-size-kana","text-underline-offset":"auto|<length>|<percentage>","text-underline-position":"auto|from-font|[under||[left|right]]",top:"<length>|<percentage>|auto","touch-action":"auto|none|[[pan-x|pan-left|pan-right]||[pan-y|pan-up|pan-down]||pinch-zoom]|manipulation",transform:"none|<transform-list>","transform-box":"content-box|border-box|fill-box|stroke-box|view-box","transform-origin":"[<length-percentage>|left|center|right|top|bottom]|[[<length-percentage>|left|center|right]&&[<length-percentage>|top|center|bottom]] <length>?","transform-style":"flat|preserve-3d",transition:"<single-transition>#","transition-delay":"<time>#","transition-duration":"<time>#","transition-property":"none|<single-transition-property>#","transition-timing-function":"<easing-function>#",translate:"none|<length-percentage> [<length-percentage> <length>?]?","unicode-bidi":"normal|embed|isolate|bidi-override|isolate-override|plaintext|-moz-isolate|-moz-isolate-override|-moz-plaintext|-webkit-isolate|-webkit-isolate-override|-webkit-plaintext","user-select":"auto|text|none|contain|all","vertical-align":"baseline|sub|super|text-top|text-bottom|middle|top|bottom|<percentage>|<length>",visibility:"visible|hidden|collapse","white-space":"normal|pre|nowrap|pre-wrap|pre-line|break-spaces",widows:"<integer>",width:"auto|<length>|<percentage>|min-content|max-content|fit-content|fit-content( <length-percentage> )|fill|stretch|intrinsic|-moz-max-content|-webkit-max-content|-moz-fit-content|-webkit-fit-content","will-change":"auto|<animateable-feature>#","word-break":"normal|break-all|keep-all|break-word","word-spacing":"normal|<length>","word-wrap":"normal|break-word","writing-mode":"horizontal-tb|vertical-rl|vertical-lr|sideways-rl|sideways-lr|<svg-writing-mode>","z-index":"auto|<integer>",zoom:"normal|reset|<number>|<percentage>","-moz-background-clip":"padding|border","-moz-border-radius-bottomleft":"<'border-bottom-left-radius'>","-moz-border-radius-bottomright":"<'border-bottom-right-radius'>","-moz-border-radius-topleft":"<'border-top-left-radius'>","-moz-border-radius-topright":"<'border-bottom-right-radius'>","-moz-control-character-visibility":"visible|hidden","-moz-osx-font-smoothing":"auto|grayscale","-moz-user-select":"none|text|all|-moz-none","-ms-flex-align":"start|end|center|baseline|stretch","-ms-flex-item-align":"auto|start|end|center|baseline|stretch","-ms-flex-line-pack":"start|end|center|justify|distribute|stretch","-ms-flex-negative":"<'flex-shrink'>","-ms-flex-pack":"start|end|center|justify|distribute","-ms-flex-order":"<integer>","-ms-flex-positive":"<'flex-grow'>","-ms-flex-preferred-size":"<'flex-basis'>","-ms-interpolation-mode":"nearest-neighbor|bicubic","-ms-grid-column-align":"start|end|center|stretch","-ms-grid-row-align":"start|end|center|stretch","-ms-hyphenate-limit-last":"none|always|column|page|spread","-webkit-background-clip":"[<box>|border|padding|content|text]#","-webkit-column-break-after":"always|auto|avoid","-webkit-column-break-before":"always|auto|avoid","-webkit-column-break-inside":"always|auto|avoid","-webkit-font-smoothing":"auto|none|antialiased|subpixel-antialiased","-webkit-mask-box-image":"[<url>|<gradient>|none] [<length-percentage>{4} <-webkit-mask-box-repeat>{2}]?","-webkit-print-color-adjust":"economy|exact","-webkit-text-security":"none|circle|disc|square","-webkit-user-drag":"none|element|auto","-webkit-user-select":"auto|none|text|all","alignment-baseline":"auto|baseline|before-edge|text-before-edge|middle|central|after-edge|text-after-edge|ideographic|alphabetic|hanging|mathematical","baseline-shift":"baseline|sub|super|<svg-length>",behavior:"<url>+","clip-rule":"nonzero|evenodd",cue:"<'cue-before'> <'cue-after'>?","cue-after":"<url> <decibel>?|none","cue-before":"<url> <decibel>?|none","dominant-baseline":"auto|use-script|no-change|reset-size|ideographic|alphabetic|hanging|mathematical|central|middle|text-after-edge|text-before-edge",fill:"<paint>","fill-opacity":"<number-zero-one>","fill-rule":"nonzero|evenodd","glyph-orientation-horizontal":"<angle>","glyph-orientation-vertical":"<angle>",kerning:"auto|<svg-length>",marker:"none|<url>","marker-end":"none|<url>","marker-mid":"none|<url>","marker-start":"none|<url>",pause:"<'pause-before'> <'pause-after'>?","pause-after":"<time>|none|x-weak|weak|medium|strong|x-strong","pause-before":"<time>|none|x-weak|weak|medium|strong|x-strong",rest:"<'rest-before'> <'rest-after'>?","rest-after":"<time>|none|x-weak|weak|medium|strong|x-strong","rest-before":"<time>|none|x-weak|weak|medium|strong|x-strong","shape-rendering":"auto|optimizeSpeed|crispEdges|geometricPrecision",src:"[<url> [format( <string># )]?|local( <family-name> )]#",speak:"auto|none|normal","speak-as":"normal|spell-out||digits||[literal-punctuation|no-punctuation]",stroke:"<paint>","stroke-dasharray":"none|[<svg-length>+]#","stroke-dashoffset":"<svg-length>","stroke-linecap":"butt|round|square","stroke-linejoin":"miter|round|bevel","stroke-miterlimit":"<number-one-or-greater>","stroke-opacity":"<number-zero-one>","stroke-width":"<svg-length>","text-anchor":"start|middle|end","unicode-range":"<urange>#","voice-balance":"<number>|left|center|right|leftwards|rightwards","voice-duration":"auto|<time>","voice-family":"[[<family-name>|<generic-voice>] ,]* [<family-name>|<generic-voice>]|preserve","voice-pitch":"<frequency>&&absolute|[[x-low|low|medium|high|x-high]||[<frequency>|<semitones>|<percentage>]]","voice-range":"<frequency>&&absolute|[[x-low|low|medium|high|x-high]||[<frequency>|<semitones>|<percentage>]]","voice-rate":"[normal|x-slow|slow|medium|fast|x-fast]||<percentage>","voice-stress":"normal|strong|moderate|none|reduced","voice-volume":"silent|[[x-soft|soft|medium|loud|x-loud]||<decibel>]"},atrules:{charset:{prelude:"<string>",descriptors:null},"counter-style":{prelude:"<counter-style-name>",descriptors:{"additive-symbols":"[<integer>&&<symbol>]#",fallback:"<counter-style-name>",negative:"<symbol> <symbol>?",pad:"<integer>&&<symbol>",prefix:"<symbol>",range:"[[<integer>|infinite]{2}]#|auto","speak-as":"auto|bullets|numbers|words|spell-out|<counter-style-name>",suffix:"<symbol>",symbols:"<symbol>+",system:"cyclic|numeric|alphabetic|symbolic|additive|[fixed <integer>?]|[extends <counter-style-name>]"}},document:{prelude:"[<url>|url-prefix( <string> )|domain( <string> )|media-document( <string> )|regexp( <string> )]#",descriptors:null},"font-face":{prelude:null,descriptors:{"ascent-override":"normal|<percentage>","descent-override":"normal|<percentage>","font-display":"[auto|block|swap|fallback|optional]","font-family":"<family-name>","font-feature-settings":"normal|<feature-tag-value>#","font-variation-settings":"normal|[<string> <number>]#","font-stretch":"<font-stretch-absolute>{1,2}","font-style":"normal|italic|oblique <angle>{0,2}","font-weight":"<font-weight-absolute>{1,2}","font-variant":"normal|none|[<common-lig-values>||<discretionary-lig-values>||<historical-lig-values>||<contextual-alt-values>||stylistic( <feature-value-name> )||historical-forms||styleset( <feature-value-name># )||character-variant( <feature-value-name># )||swash( <feature-value-name> )||ornaments( <feature-value-name> )||annotation( <feature-value-name> )||[small-caps|all-small-caps|petite-caps|all-petite-caps|unicase|titling-caps]||<numeric-figure-values>||<numeric-spacing-values>||<numeric-fraction-values>||ordinal||slashed-zero||<east-asian-variant-values>||<east-asian-width-values>||ruby]","line-gap-override":"normal|<percentage>","size-adjust":"<percentage>",src:"[<url> [format( <string># )]?|local( <family-name> )]#","unicode-range":"<urange>#"}},"font-feature-values":{prelude:"<family-name>#",descriptors:null},import:{prelude:"[<string>|<url>] [layer|layer( <layer-name> )]? [supports( [<supports-condition>|<declaration>] )]? <media-query-list>?",descriptors:null},keyframes:{prelude:"<keyframes-name>",descriptors:null},layer:{prelude:"[<layer-name>#|<layer-name>?]",descriptors:null},media:{prelude:"<media-query-list>",descriptors:null},namespace:{prelude:"<namespace-prefix>? [<string>|<url>]",descriptors:null},page:{prelude:"<page-selector-list>",descriptors:{bleed:"auto|<length>",marks:"none|[crop||cross]",size:"<length>{1,2}|auto|[<page-size>||[portrait|landscape]]"}},property:{prelude:"<custom-property-name>",descriptors:{syntax:"<string>",inherits:"true|false","initial-value":"<string>"}},"scroll-timeline":{prelude:"<timeline-name>",descriptors:null},supports:{prelude:"<supports-condition>",descriptors:null},viewport:{prelude:null,descriptors:{height:"<viewport-length>{1,2}","max-height":"<viewport-length>","max-width":"<viewport-length>","max-zoom":"auto|<number>|<percentage>","min-height":"<viewport-length>","min-width":"<viewport-length>","min-zoom":"auto|<number>|<percentage>",orientation:"auto|portrait|landscape","user-zoom":"zoom|fixed","viewport-fit":"auto|contain|cover",width:"<viewport-length>{1,2}",zoom:"auto|<number>|<percentage>"}}}}
const PLUSSIGN$5=0x002B
const HYPHENMINUS$2=0x002D
const N=0x006E
const DISALLOW_SIGN=true
const ALLOW_SIGN=false
function checkInteger(offset,disallowSign){let pos=this.tokenStart+offset
const code=this.charCodeAt(pos)
if(code===PLUSSIGN$5||code===HYPHENMINUS$2){disallowSign&&this.error("Number sign is not allowed")
pos++}for(;pos<this.tokenEnd;pos++)isDigit$1(this.charCodeAt(pos))||this.error("Integer is expected",pos)}function checkTokenIsInteger(disallowSign){return checkInteger.call(this,0,disallowSign)}function expectCharCode(offset,code){if(!this.cmpChar(this.tokenStart+offset,code)){let msg=""
switch(code){case N:msg="N is expected"
break
case HYPHENMINUS$2:msg="HyphenMinus is expected"
break}this.error(msg,this.tokenStart+offset)}}function consumeB(){let offset=0
let sign=0
let type=this.tokenType
while(type===WhiteSpace$1||type===Comment$1)type=this.lookupType(++offset)
if(type!==Number$3){if(!this.isDelim(PLUSSIGN$5,offset)&&!this.isDelim(HYPHENMINUS$2,offset))return null
sign=this.isDelim(PLUSSIGN$5,offset)?PLUSSIGN$5:HYPHENMINUS$2
do{type=this.lookupType(++offset)}while(type===WhiteSpace$1||type===Comment$1)
if(type!==Number$3){this.skip(offset)
checkTokenIsInteger.call(this,DISALLOW_SIGN)}}offset>0&&this.skip(offset)
if(sign===0){type=this.charCodeAt(this.tokenStart)
type!==PLUSSIGN$5&&type!==HYPHENMINUS$2&&this.error("Number sign is expected")}checkTokenIsInteger.call(this,sign!==0)
return sign===HYPHENMINUS$2?"-"+this.consume(Number$3):this.consume(Number$3)}const name$1p="AnPlusB"
const structure$D={a:[String,null],b:[String,null]}
function parse$G(){const start=this.tokenStart
let a=null
let b=null
if(this.tokenType===Number$3){checkTokenIsInteger.call(this,ALLOW_SIGN)
b=this.consume(Number$3)}else if(this.tokenType===Ident&&this.cmpChar(this.tokenStart,HYPHENMINUS$2)){a="-1"
expectCharCode.call(this,1,N)
switch(this.tokenEnd-this.tokenStart){case 2:this.next()
b=consumeB.call(this)
break
case 3:expectCharCode.call(this,2,HYPHENMINUS$2)
this.next()
this.skipSC()
checkTokenIsInteger.call(this,DISALLOW_SIGN)
b="-"+this.consume(Number$3)
break
default:expectCharCode.call(this,2,HYPHENMINUS$2)
checkInteger.call(this,3,DISALLOW_SIGN)
this.next()
b=this.substrToCursor(start+2)}}else if(this.tokenType===Ident||this.isDelim(PLUSSIGN$5)&&this.lookupType(1)===Ident){let sign=0
a="1"
if(this.isDelim(PLUSSIGN$5)){sign=1
this.next()}expectCharCode.call(this,0,N)
switch(this.tokenEnd-this.tokenStart){case 1:this.next()
b=consumeB.call(this)
break
case 2:expectCharCode.call(this,1,HYPHENMINUS$2)
this.next()
this.skipSC()
checkTokenIsInteger.call(this,DISALLOW_SIGN)
b="-"+this.consume(Number$3)
break
default:expectCharCode.call(this,1,HYPHENMINUS$2)
checkInteger.call(this,2,DISALLOW_SIGN)
this.next()
b=this.substrToCursor(start+sign+1)}}else if(this.tokenType===Dimension$1){const code=this.charCodeAt(this.tokenStart)
const sign=code===PLUSSIGN$5||code===HYPHENMINUS$2
let i=this.tokenStart+sign
for(;i<this.tokenEnd;i++)if(!isDigit$1(this.charCodeAt(i)))break
i===this.tokenStart+sign&&this.error("Integer is expected",this.tokenStart+sign)
expectCharCode.call(this,i-this.tokenStart,N)
a=this.substring(start,i)
if(i+1===this.tokenEnd){this.next()
b=consumeB.call(this)}else{expectCharCode.call(this,i-this.tokenStart+1,HYPHENMINUS$2)
if(i+2===this.tokenEnd){this.next()
this.skipSC()
checkTokenIsInteger.call(this,DISALLOW_SIGN)
b="-"+this.consume(Number$3)}else{checkInteger.call(this,i-this.tokenStart+2,DISALLOW_SIGN)
this.next()
b=this.substrToCursor(i+1)}}}else this.error()
a!==null&&a.charCodeAt(0)===PLUSSIGN$5&&(a=a.substr(1))
b!==null&&b.charCodeAt(0)===PLUSSIGN$5&&(b=b.substr(1))
return{type:"AnPlusB",loc:this.getLocation(start,this.tokenStart),a:a,b:b}}function generate$G(node){if(node.a){const a=(node.a==="+1"||node.a==="1"?"n":node.a==="-1"&&"-n")||node.a+"n"
if(node.b){const b=node.b[0]==="-"||node.b[0]==="+"?node.b:"+"+node.b
this.tokenize(a+b)}else this.tokenize(a)}else this.tokenize(node.b)}var AnPlusB=Object.freeze({__proto__:null,generate:generate$G,name:name$1p,parse:parse$G,structure:structure$D})
function consumeRaw$5(startToken){return this.Raw(startToken,this.consumeUntilLeftCurlyBracketOrSemicolon,true)}function isDeclarationBlockAtrule(){for(let offset=1,type;type=this.lookupType(offset);offset++){if(type===RightCurlyBracket)return true
if(type===LeftCurlyBracket||type===AtKeyword)return false}return false}const name$1o="Atrule"
const walkContext$9="atrule"
const structure$C={name:String,prelude:["AtrulePrelude","Raw",null],block:["Block",null]}
function parse$F(){const start=this.tokenStart
let name
let nameLowerCase
let prelude=null
let block=null
this.eat(AtKeyword)
name=this.substrToCursor(start+1)
nameLowerCase=name.toLowerCase()
this.skipSC()
if(this.eof===false&&this.tokenType!==LeftCurlyBracket&&this.tokenType!==Semicolon){prelude=this.parseAtrulePrelude?this.parseWithFallback(this.AtrulePrelude.bind(this,name),consumeRaw$5):consumeRaw$5.call(this,this.tokenIndex)
this.skipSC()}switch(this.tokenType){case Semicolon:this.next()
break
case LeftCurlyBracket:block=hasOwnProperty.call(this.atrule,nameLowerCase)&&typeof this.atrule[nameLowerCase].block==="function"?this.atrule[nameLowerCase].block.call(this):this.Block(isDeclarationBlockAtrule.call(this))
break}return{type:"Atrule",loc:this.getLocation(start,this.tokenStart),name:name,prelude:prelude,block:block}}function generate$F(node){this.token(AtKeyword,"@"+node.name)
node.prelude!==null&&this.node(node.prelude)
node.block?this.node(node.block):this.token(Semicolon,";")}var Atrule$1=Object.freeze({__proto__:null,generate:generate$F,name:name$1o,parse:parse$F,structure:structure$C,walkContext:walkContext$9})
const name$1n="AtrulePrelude"
const walkContext$8="atrulePrelude"
const structure$B={children:[[]]}
function parse$E(name){let children=null
name!==null&&(name=name.toLowerCase())
this.skipSC()
children=hasOwnProperty.call(this.atrule,name)&&typeof this.atrule[name].prelude==="function"?this.atrule[name].prelude.call(this):this.readSequence(this.scope.AtrulePrelude)
this.skipSC()
this.eof!==true&&this.tokenType!==LeftCurlyBracket&&this.tokenType!==Semicolon&&this.error("Semicolon or block is expected")
return{type:"AtrulePrelude",loc:this.getLocationFromList(children),children:children}}function generate$E(node){this.children(node)}var AtrulePrelude=Object.freeze({__proto__:null,generate:generate$E,name:name$1n,parse:parse$E,structure:structure$B,walkContext:walkContext$8})
const DOLLARSIGN$1=0x0024
const ASTERISK$5=0x002A
const EQUALSSIGN=0x003D
const CIRCUMFLEXACCENT=0x005E
const VERTICALLINE$2=0x007C
const TILDE$2=0x007E
function getAttributeName(){this.eof&&this.error("Unexpected end of input")
const start=this.tokenStart
let expectIdent=false
if(this.isDelim(ASTERISK$5)){expectIdent=true
this.next()}else this.isDelim(VERTICALLINE$2)||this.eat(Ident)
if(this.isDelim(VERTICALLINE$2))if(this.charCodeAt(this.tokenStart+1)!==EQUALSSIGN){this.next()
this.eat(Ident)}else expectIdent&&this.error("Identifier is expected",this.tokenEnd)
else expectIdent&&this.error("Vertical line is expected")
return{type:"Identifier",loc:this.getLocation(start,this.tokenStart),name:this.substrToCursor(start)}}function getOperator(){const start=this.tokenStart
const code=this.charCodeAt(start)
code!==EQUALSSIGN&&code!==TILDE$2&&code!==CIRCUMFLEXACCENT&&code!==DOLLARSIGN$1&&code!==ASTERISK$5&&code!==VERTICALLINE$2&&this.error("Attribute selector (=, ~=, ^=, $=, *=, |=) is expected")
this.next()
if(code!==EQUALSSIGN){this.isDelim(EQUALSSIGN)||this.error("Equal sign is expected")
this.next()}return this.substrToCursor(start)}const name$1m="AttributeSelector"
const structure$A={name:"Identifier",matcher:[String,null],value:["String","Identifier",null],flags:[String,null]}
function parse$D(){const start=this.tokenStart
let name
let matcher=null
let value=null
let flags=null
this.eat(LeftSquareBracket)
this.skipSC()
name=getAttributeName.call(this)
this.skipSC()
if(this.tokenType!==RightSquareBracket){if(this.tokenType!==Ident){matcher=getOperator.call(this)
this.skipSC()
value=this.tokenType===String$2?this.String():this.Identifier()
this.skipSC()}if(this.tokenType===Ident){flags=this.consume(Ident)
this.skipSC()}}this.eat(RightSquareBracket)
return{type:"AttributeSelector",loc:this.getLocation(start,this.tokenStart),name:name,matcher:matcher,value:value,flags:flags}}function generate$D(node){this.token(Delim,"[")
this.node(node.name)
if(node.matcher!==null){this.tokenize(node.matcher)
this.node(node.value)}node.flags!==null&&this.token(Ident,node.flags)
this.token(Delim,"]")}var AttributeSelector$1=Object.freeze({__proto__:null,generate:generate$D,name:name$1m,parse:parse$D,structure:structure$A})
function consumeRaw$4(startToken){return this.Raw(startToken,null,true)}function consumeRule(){return this.parseWithFallback(this.Rule,consumeRaw$4)}function consumeRawDeclaration(startToken){return this.Raw(startToken,this.consumeUntilSemicolonIncluded,true)}function consumeDeclaration(){if(this.tokenType===Semicolon)return consumeRawDeclaration.call(this,this.tokenIndex)
const node=this.parseWithFallback(this.Declaration,consumeRawDeclaration)
this.tokenType===Semicolon&&this.next()
return node}const name$1l="Block"
const walkContext$7="block"
const structure$z={children:[["Atrule","Rule","Declaration"]]}
function parse$C(isDeclaration){const consumer=isDeclaration?consumeDeclaration:consumeRule
const start=this.tokenStart
let children=this.createList()
this.eat(LeftCurlyBracket)
scan:while(!this.eof)switch(this.tokenType){case RightCurlyBracket:break scan
case WhiteSpace$1:case Comment$1:this.next()
break
case AtKeyword:children.push(this.parseWithFallback(this.Atrule,consumeRaw$4))
break
default:children.push(consumer.call(this))}this.eof||this.eat(RightCurlyBracket)
return{type:"Block",loc:this.getLocation(start,this.tokenStart),children:children}}function generate$C(node){this.token(LeftCurlyBracket,"{")
this.children(node,(prev=>{prev.type==="Declaration"&&this.token(Semicolon,";")}))
this.token(RightCurlyBracket,"}")}var Block=Object.freeze({__proto__:null,generate:generate$C,name:name$1l,parse:parse$C,structure:structure$z,walkContext:walkContext$7})
const name$1k="Brackets"
const structure$y={children:[[]]}
function parse$B(readSequence,recognizer){const start=this.tokenStart
let children=null
this.eat(LeftSquareBracket)
children=readSequence.call(this,recognizer)
this.eof||this.eat(RightSquareBracket)
return{type:"Brackets",loc:this.getLocation(start,this.tokenStart),children:children}}function generate$B(node){this.token(Delim,"[")
this.children(node)
this.token(Delim,"]")}var Brackets=Object.freeze({__proto__:null,generate:generate$B,name:name$1k,parse:parse$B,structure:structure$y})
const name$1j="CDC"
const structure$x=[]
function parse$A(){const start=this.tokenStart
this.eat(CDC$1)
return{type:"CDC",loc:this.getLocation(start,this.tokenStart)}}function generate$A(){this.token(CDC$1,"--\x3e")}var CDC=Object.freeze({__proto__:null,generate:generate$A,name:name$1j,parse:parse$A,structure:structure$x})
const name$1i="CDO"
const structure$w=[]
function parse$z(){const start=this.tokenStart
this.eat(CDO$1)
return{type:"CDO",loc:this.getLocation(start,this.tokenStart)}}function generate$z(){this.token(CDO$1,"\x3c!--")}var CDO=Object.freeze({__proto__:null,generate:generate$z,name:name$1i,parse:parse$z,structure:structure$w})
const FULLSTOP$2=0x002E
const name$1h="ClassSelector"
const structure$v={name:String}
function parse$y(){this.eatDelim(FULLSTOP$2)
return{type:"ClassSelector",loc:this.getLocation(this.tokenStart-1,this.tokenEnd),name:this.consume(Ident)}}function generate$y(node){this.token(Delim,".")
this.token(Ident,node.name)}var ClassSelector=Object.freeze({__proto__:null,generate:generate$y,name:name$1h,parse:parse$y,structure:structure$v})
const PLUSSIGN$4=0x002B
const SOLIDUS$5=0x002F
const GREATERTHANSIGN$1=0x003E
const TILDE$1=0x007E
const name$1g="Combinator"
const structure$u={name:String}
function parse$x(){const start=this.tokenStart
let name
switch(this.tokenType){case WhiteSpace$1:name=" "
break
case Delim:switch(this.charCodeAt(this.tokenStart)){case GREATERTHANSIGN$1:case PLUSSIGN$4:case TILDE$1:this.next()
break
case SOLIDUS$5:this.next()
this.eatIdent("deep")
this.eatDelim(SOLIDUS$5)
break
default:this.error("Combinator is expected")}name=this.substrToCursor(start)
break}return{type:"Combinator",loc:this.getLocation(start,this.tokenStart),name:name}}function generate$x(node){this.tokenize(node.name)}var Combinator=Object.freeze({__proto__:null,generate:generate$x,name:name$1g,parse:parse$x,structure:structure$u})
const ASTERISK$4=0x002A
const SOLIDUS$4=0x002F
const name$1f="Comment"
const structure$t={value:String}
function parse$w(){const start=this.tokenStart
let end=this.tokenEnd
this.eat(Comment$1)
end-start+2>=2&&this.charCodeAt(end-2)===ASTERISK$4&&this.charCodeAt(end-1)===SOLIDUS$4&&(end-=2)
return{type:"Comment",loc:this.getLocation(start,this.tokenStart),value:this.substring(start+2,end)}}function generate$w(node){this.token(Comment$1,"/*"+node.value+"*/")}var Comment=Object.freeze({__proto__:null,generate:generate$w,name:name$1f,parse:parse$w,structure:structure$t})
const EXCLAMATIONMARK$1=0x0021
const NUMBERSIGN$2=0x0023
const DOLLARSIGN=0x0024
const AMPERSAND=0x0026
const ASTERISK$3=0x002A
const PLUSSIGN$3=0x002B
const SOLIDUS$3=0x002F
function consumeValueRaw(startToken){return this.Raw(startToken,this.consumeUntilExclamationMarkOrSemicolon,true)}function consumeCustomPropertyRaw(startToken){return this.Raw(startToken,this.consumeUntilExclamationMarkOrSemicolon,false)}function consumeValue(){const startValueToken=this.tokenIndex
const value=this.Value()
value.type!=="Raw"&&this.eof===false&&this.tokenType!==Semicolon&&this.isDelim(EXCLAMATIONMARK$1)===false&&this.isBalanceEdge(startValueToken)===false&&this.error()
return value}const name$1e="Declaration"
const walkContext$6="declaration"
const structure$s={important:[Boolean,String],property:String,value:["Value","Raw"]}
function parse$v(){const start=this.tokenStart
const startToken=this.tokenIndex
const property=readProperty.call(this)
const customProperty=isCustomProperty(property)
const parseValue=customProperty?this.parseCustomProperty:this.parseValue
const consumeRaw=customProperty?consumeCustomPropertyRaw:consumeValueRaw
let important=false
let value
this.skipSC()
this.eat(Colon)
const valueStart=this.tokenIndex
customProperty||this.skipSC()
value=parseValue?this.parseWithFallback(consumeValue,consumeRaw):consumeRaw.call(this,this.tokenIndex)
if(customProperty&&value.type==="Value"&&value.children.isEmpty)for(let offset=valueStart-this.tokenIndex;offset<=0;offset++)if(this.lookupType(offset)===WhiteSpace$1){value.children.appendData({type:"WhiteSpace",loc:null,value:" "})
break}if(this.isDelim(EXCLAMATIONMARK$1)){important=getImportant.call(this)
this.skipSC()}this.eof===false&&this.tokenType!==Semicolon&&this.isBalanceEdge(startToken)===false&&this.error()
return{type:"Declaration",loc:this.getLocation(start,this.tokenStart),important:important,property:property,value:value}}function generate$v(node){this.token(Ident,node.property)
this.token(Colon,":")
this.node(node.value)
if(node.important){this.token(Delim,"!")
this.token(Ident,node.important===true?"important":node.important)}}function readProperty(){const start=this.tokenStart
if(this.tokenType===Delim)switch(this.charCodeAt(this.tokenStart)){case ASTERISK$3:case DOLLARSIGN:case PLUSSIGN$3:case NUMBERSIGN$2:case AMPERSAND:this.next()
break
case SOLIDUS$3:this.next()
this.isDelim(SOLIDUS$3)&&this.next()
break}this.tokenType===Hash$1?this.eat(Hash$1):this.eat(Ident)
return this.substrToCursor(start)}function getImportant(){this.eat(Delim)
this.skipSC()
const important=this.consume(Ident)
return important==="important"||important}var Declaration=Object.freeze({__proto__:null,generate:generate$v,name:name$1e,parse:parse$v,structure:structure$s,walkContext:walkContext$6})
function consumeRaw$3(startToken){return this.Raw(startToken,this.consumeUntilSemicolonIncluded,true)}const name$1d="DeclarationList"
const structure$r={children:[["Declaration"]]}
function parse$u(){const children=this.createList()
while(!this.eof)switch(this.tokenType){case WhiteSpace$1:case Comment$1:case Semicolon:this.next()
break
default:children.push(this.parseWithFallback(this.Declaration,consumeRaw$3))}return{type:"DeclarationList",loc:this.getLocationFromList(children),children:children}}function generate$u(node){this.children(node,(prev=>{prev.type==="Declaration"&&this.token(Semicolon,";")}))}var DeclarationList=Object.freeze({__proto__:null,generate:generate$u,name:name$1d,parse:parse$u,structure:structure$r})
const name$1c="Dimension"
const structure$q={value:String,unit:String}
function parse$t(){const start=this.tokenStart
const value=this.consumeNumber(Dimension$1)
return{type:"Dimension",loc:this.getLocation(start,this.tokenStart),value:value,unit:this.substring(start+value.length,this.tokenStart)}}function generate$t(node){this.token(Dimension$1,node.value+node.unit)}var Dimension=Object.freeze({__proto__:null,generate:generate$t,name:name$1c,parse:parse$t,structure:structure$q})
const name$1b="Function"
const walkContext$5="function"
const structure$p={name:String,children:[[]]}
function parse$s(readSequence,recognizer){const start=this.tokenStart
const name=this.consumeFunctionName()
const nameLowerCase=name.toLowerCase()
let children
children=recognizer.hasOwnProperty(nameLowerCase)?recognizer[nameLowerCase].call(this,recognizer):readSequence.call(this,recognizer)
this.eof||this.eat(RightParenthesis)
return{type:"Function",loc:this.getLocation(start,this.tokenStart),name:name,children:children}}function generate$s(node){this.token(Function$1,node.name+"(")
this.children(node)
this.token(RightParenthesis,")")}var Function=Object.freeze({__proto__:null,generate:generate$s,name:name$1b,parse:parse$s,structure:structure$p,walkContext:walkContext$5})
const xxx="XXX"
const name$1a="Hash"
const structure$o={value:String}
function parse$r(){const start=this.tokenStart
this.eat(Hash$1)
return{type:"Hash",loc:this.getLocation(start,this.tokenStart),value:this.substrToCursor(start+1)}}function generate$r(node){this.token(Hash$1,"#"+node.value)}var Hash=Object.freeze({__proto__:null,generate:generate$r,name:name$1a,parse:parse$r,structure:structure$o,xxx:xxx})
const name$19="Identifier"
const structure$n={name:String}
function parse$q(){return{type:"Identifier",loc:this.getLocation(this.tokenStart,this.tokenEnd),name:this.consume(Ident)}}function generate$q(node){this.token(Ident,node.name)}var Identifier=Object.freeze({__proto__:null,generate:generate$q,name:name$19,parse:parse$q,structure:structure$n})
const name$18="IdSelector"
const structure$m={name:String}
function parse$p(){const start=this.tokenStart
this.eat(Hash$1)
return{type:"IdSelector",loc:this.getLocation(start,this.tokenStart),name:this.substrToCursor(start+1)}}function generate$p(node){this.token(Delim,"#"+node.name)}var IdSelector=Object.freeze({__proto__:null,generate:generate$p,name:name$18,parse:parse$p,structure:structure$m})
const name$17="MediaFeature"
const structure$l={name:String,value:["Identifier","Number","Dimension","Ratio",null]}
function parse$o(){const start=this.tokenStart
let name
let value=null
this.eat(LeftParenthesis)
this.skipSC()
name=this.consume(Ident)
this.skipSC()
if(this.tokenType!==RightParenthesis){this.eat(Colon)
this.skipSC()
switch(this.tokenType){case Number$3:value=this.lookupNonWSType(1)===Delim?this.Ratio():this.Number()
break
case Dimension$1:value=this.Dimension()
break
case Ident:value=this.Identifier()
break
default:this.error("Number, dimension, ratio or identifier is expected")}this.skipSC()}this.eat(RightParenthesis)
return{type:"MediaFeature",loc:this.getLocation(start,this.tokenStart),name:name,value:value}}function generate$o(node){this.token(LeftParenthesis,"(")
this.token(Ident,node.name)
if(node.value!==null){this.token(Colon,":")
this.node(node.value)}this.token(RightParenthesis,")")}var MediaFeature=Object.freeze({__proto__:null,generate:generate$o,name:name$17,parse:parse$o,structure:structure$l})
const name$16="MediaQuery"
const structure$k={children:[["Identifier","MediaFeature","WhiteSpace"]]}
function parse$n(){const children=this.createList()
let child=null
this.skipSC()
scan:while(!this.eof){switch(this.tokenType){case Comment$1:case WhiteSpace$1:this.next()
continue
case Ident:child=this.Identifier()
break
case LeftParenthesis:child=this.MediaFeature()
break
default:break scan}children.push(child)}child===null&&this.error("Identifier or parenthesis is expected")
return{type:"MediaQuery",loc:this.getLocationFromList(children),children:children}}function generate$n(node){this.children(node)}var MediaQuery=Object.freeze({__proto__:null,generate:generate$n,name:name$16,parse:parse$n,structure:structure$k})
const name$15="MediaQueryList"
const structure$j={children:[["MediaQuery"]]}
function parse$m(){const children=this.createList()
this.skipSC()
while(!this.eof){children.push(this.MediaQuery())
if(this.tokenType!==Comma)break
this.next()}return{type:"MediaQueryList",loc:this.getLocationFromList(children),children:children}}function generate$m(node){this.children(node,(()=>this.token(Comma,",")))}var MediaQueryList=Object.freeze({__proto__:null,generate:generate$m,name:name$15,parse:parse$m,structure:structure$j})
const name$14="Nth"
const structure$i={nth:["AnPlusB","Identifier"],selector:["SelectorList",null]}
function parse$l(){this.skipSC()
const start=this.tokenStart
let end=start
let selector=null
let nth
nth=this.lookupValue(0,"odd")||this.lookupValue(0,"even")?this.Identifier():this.AnPlusB()
end=this.tokenStart
this.skipSC()
if(this.lookupValue(0,"of")){this.next()
selector=this.SelectorList()
end=this.tokenStart}return{type:"Nth",loc:this.getLocation(start,end),nth:nth,selector:selector}}function generate$l(node){this.node(node.nth)
if(node.selector!==null){this.token(Ident,"of")
this.node(node.selector)}}var Nth=Object.freeze({__proto__:null,generate:generate$l,name:name$14,parse:parse$l,structure:structure$i})
const name$13="Number"
const structure$h={value:String}
function parse$k(){return{type:"Number",loc:this.getLocation(this.tokenStart,this.tokenEnd),value:this.consume(Number$3)}}function generate$k(node){this.token(Number$3,node.value)}var Number$2=Object.freeze({__proto__:null,generate:generate$k,name:name$13,parse:parse$k,structure:structure$h})
const name$12="Operator"
const structure$g={value:String}
function parse$j(){const start=this.tokenStart
this.next()
return{type:"Operator",loc:this.getLocation(start,this.tokenStart),value:this.substrToCursor(start)}}function generate$j(node){this.tokenize(node.value)}var Operator=Object.freeze({__proto__:null,generate:generate$j,name:name$12,parse:parse$j,structure:structure$g})
const name$11="Parentheses"
const structure$f={children:[[]]}
function parse$i(readSequence,recognizer){const start=this.tokenStart
let children=null
this.eat(LeftParenthesis)
children=readSequence.call(this,recognizer)
this.eof||this.eat(RightParenthesis)
return{type:"Parentheses",loc:this.getLocation(start,this.tokenStart),children:children}}function generate$i(node){this.token(LeftParenthesis,"(")
this.children(node)
this.token(RightParenthesis,")")}var Parentheses=Object.freeze({__proto__:null,generate:generate$i,name:name$11,parse:parse$i,structure:structure$f})
const name$10="Percentage"
const structure$e={value:String}
function parse$h(){return{type:"Percentage",loc:this.getLocation(this.tokenStart,this.tokenEnd),value:this.consumeNumber(Percentage$1)}}function generate$h(node){this.token(Percentage$1,node.value+"%")}var Percentage=Object.freeze({__proto__:null,generate:generate$h,name:name$10,parse:parse$h,structure:structure$e})
const name$$="PseudoClassSelector"
const walkContext$4="function"
const structure$d={name:String,children:[["Raw"],null]}
function parse$g(){const start=this.tokenStart
let children=null
let name
let nameLowerCase
this.eat(Colon)
if(this.tokenType===Function$1){name=this.consumeFunctionName()
nameLowerCase=name.toLowerCase()
if(hasOwnProperty.call(this.pseudo,nameLowerCase)){this.skipSC()
children=this.pseudo[nameLowerCase].call(this)
this.skipSC()}else{children=this.createList()
children.push(this.Raw(this.tokenIndex,null,false))}this.eat(RightParenthesis)}else name=this.consume(Ident)
return{type:"PseudoClassSelector",loc:this.getLocation(start,this.tokenStart),name:name,children:children}}function generate$g(node){this.token(Colon,":")
if(node.children===null)this.token(Ident,node.name)
else{this.token(Function$1,node.name+"(")
this.children(node)
this.token(RightParenthesis,")")}}var PseudoClassSelector=Object.freeze({__proto__:null,generate:generate$g,name:name$$,parse:parse$g,structure:structure$d,walkContext:walkContext$4})
const name$_="PseudoElementSelector"
const walkContext$3="function"
const structure$c={name:String,children:[["Raw"],null]}
function parse$f(){const start=this.tokenStart
let children=null
let name
let nameLowerCase
this.eat(Colon)
this.eat(Colon)
if(this.tokenType===Function$1){name=this.consumeFunctionName()
nameLowerCase=name.toLowerCase()
if(hasOwnProperty.call(this.pseudo,nameLowerCase)){this.skipSC()
children=this.pseudo[nameLowerCase].call(this)
this.skipSC()}else{children=this.createList()
children.push(this.Raw(this.tokenIndex,null,false))}this.eat(RightParenthesis)}else name=this.consume(Ident)
return{type:"PseudoElementSelector",loc:this.getLocation(start,this.tokenStart),name:name,children:children}}function generate$f(node){this.token(Colon,":")
this.token(Colon,":")
if(node.children===null)this.token(Ident,node.name)
else{this.token(Function$1,node.name+"(")
this.children(node)
this.token(RightParenthesis,")")}}var PseudoElementSelector=Object.freeze({__proto__:null,generate:generate$f,name:name$_,parse:parse$f,structure:structure$c,walkContext:walkContext$3})
const SOLIDUS$2=0x002F
const FULLSTOP$1=0x002E
function consumeNumber(){this.skipSC()
const value=this.consume(Number$3)
for(let i=0;i<value.length;i++){const code=value.charCodeAt(i)
isDigit$1(code)||code===FULLSTOP$1||this.error("Unsigned number is expected",this.tokenStart-value.length+i)}Number(value)===0&&this.error("Zero number is not allowed",this.tokenStart-value.length)
return value}const name$Z="Ratio"
const structure$b={left:String,right:String}
function parse$e(){const start=this.tokenStart
const left=consumeNumber.call(this)
let right
this.skipSC()
this.eatDelim(SOLIDUS$2)
right=consumeNumber.call(this)
return{type:"Ratio",loc:this.getLocation(start,this.tokenStart),left:left,right:right}}function generate$e(node){this.token(Number$3,node.left)
this.token(Delim,"/")
this.token(Number$3,node.right)}var Ratio=Object.freeze({__proto__:null,generate:generate$e,name:name$Z,parse:parse$e,structure:structure$b})
function getOffsetExcludeWS(){if(this.tokenIndex>0&&this.lookupType(-1)===WhiteSpace$1)return this.tokenIndex>1?this.getTokenStart(this.tokenIndex-1):this.firstCharOffset
return this.tokenStart}const name$Y="Raw"
const structure$a={value:String}
function parse$d(startToken,consumeUntil,excludeWhiteSpace){const startOffset=this.getTokenStart(startToken)
let endOffset
this.skipUntilBalanced(startToken,consumeUntil||this.consumeUntilBalanceEnd)
endOffset=excludeWhiteSpace&&this.tokenStart>startOffset?getOffsetExcludeWS.call(this):this.tokenStart
return{type:"Raw",loc:this.getLocation(startOffset,endOffset),value:this.substring(startOffset,endOffset)}}function generate$d(node){this.tokenize(node.value)}var Raw=Object.freeze({__proto__:null,generate:generate$d,name:name$Y,parse:parse$d,structure:structure$a})
function consumeRaw$2(startToken){return this.Raw(startToken,this.consumeUntilLeftCurlyBracket,true)}function consumePrelude(){const prelude=this.SelectorList()
prelude.type!=="Raw"&&this.eof===false&&this.tokenType!==LeftCurlyBracket&&this.error()
return prelude}const name$X="Rule"
const walkContext$2="rule"
const structure$9={prelude:["SelectorList","Raw"],block:["Block"]}
function parse$c(){const startToken=this.tokenIndex
const startOffset=this.tokenStart
let prelude
let block
prelude=this.parseRulePrelude?this.parseWithFallback(consumePrelude,consumeRaw$2):consumeRaw$2.call(this,startToken)
block=this.Block(true)
return{type:"Rule",loc:this.getLocation(startOffset,this.tokenStart),prelude:prelude,block:block}}function generate$c(node){this.node(node.prelude)
this.node(node.block)}var Rule=Object.freeze({__proto__:null,generate:generate$c,name:name$X,parse:parse$c,structure:structure$9,walkContext:walkContext$2})
const name$W="Selector"
const structure$8={children:[["TypeSelector","IdSelector","ClassSelector","AttributeSelector","PseudoClassSelector","PseudoElementSelector","Combinator","WhiteSpace"]]}
function parse$b(){const children=this.readSequence(this.scope.Selector)
this.getFirstListNode(children)===null&&this.error("Selector is expected")
return{type:"Selector",loc:this.getLocationFromList(children),children:children}}function generate$b(node){this.children(node)}var Selector=Object.freeze({__proto__:null,generate:generate$b,name:name$W,parse:parse$b,structure:structure$8})
const name$V="SelectorList"
const walkContext$1="selector"
const structure$7={children:[["Selector","Raw"]]}
function parse$a(){const children=this.createList()
while(!this.eof){children.push(this.Selector())
if(this.tokenType===Comma){this.next()
continue}break}return{type:"SelectorList",loc:this.getLocationFromList(children),children:children}}function generate$a(node){this.children(node,(()=>this.token(Comma,",")))}var SelectorList=Object.freeze({__proto__:null,generate:generate$a,name:name$V,parse:parse$a,structure:structure$7,walkContext:walkContext$1})
const REVERSE_SOLIDUS$1=0x005c
const QUOTATION_MARK$1=0x0022
const APOSTROPHE$1=0x0027
function decode$1(str){const len=str.length
const firstChar=str.charCodeAt(0)
const start=firstChar===QUOTATION_MARK$1||firstChar===APOSTROPHE$1?1:0
const end=start===1&&len>1&&str.charCodeAt(len-1)===firstChar?len-2:len-1
let decoded=""
for(let i=start;i<=end;i++){let code=str.charCodeAt(i)
if(code===REVERSE_SOLIDUS$1){if(i===end){i!==len-1&&(decoded=str.substr(i+1))
break}code=str.charCodeAt(++i)
if(isValidEscape(REVERSE_SOLIDUS$1,code)){const escapeStart=i-1
const escapeEnd=consumeEscaped(str,escapeStart)
i=escapeEnd-1
decoded+=decodeEscaped(str.substring(escapeStart+1,escapeEnd))}else code===0x000d&&str.charCodeAt(i+1)===0x000a&&i++}else decoded+=str[i]}return decoded}function encode$1(str,apostrophe){const quote=apostrophe?"'":'"'
const quoteCode=apostrophe?APOSTROPHE$1:QUOTATION_MARK$1
let encoded=""
let wsBeforeHexIsNeeded=false
for(let i=0;i<str.length;i++){const code=str.charCodeAt(i)
if(code===0x0000){encoded+="�"
continue}if(code<=0x001f||code===0x007F){encoded+="\\"+code.toString(16)
wsBeforeHexIsNeeded=true
continue}if(code===quoteCode||code===REVERSE_SOLIDUS$1){encoded+="\\"+str.charAt(i)
wsBeforeHexIsNeeded=false}else{wsBeforeHexIsNeeded&&(isHexDigit(code)||isWhiteSpace$1(code))&&(encoded+=" ")
encoded+=str.charAt(i)
wsBeforeHexIsNeeded=false}}return quote+encoded+quote}const name$U="String"
const structure$6={value:String}
function parse$9(){return{type:"String",loc:this.getLocation(this.tokenStart,this.tokenEnd),value:decode$1(this.consume(String$2))}}function generate$9(node){this.token(String$2,encode$1(node.value))}var String$1=Object.freeze({__proto__:null,generate:generate$9,name:name$U,parse:parse$9,structure:structure$6})
const EXCLAMATIONMARK=0x0021
function consumeRaw$1(startToken){return this.Raw(startToken,null,false)}const name$T="StyleSheet"
const walkContext="stylesheet"
const structure$5={children:[["Comment","CDO","CDC","Atrule","Rule","Raw"]]}
function parse$8(){const start=this.tokenStart
const children=this.createList()
let child
while(!this.eof){switch(this.tokenType){case WhiteSpace$1:this.next()
continue
case Comment$1:if(this.charCodeAt(this.tokenStart+2)!==EXCLAMATIONMARK){this.next()
continue}child=this.Comment()
break
case CDO$1:child=this.CDO()
break
case CDC$1:child=this.CDC()
break
case AtKeyword:child=this.parseWithFallback(this.Atrule,consumeRaw$1)
break
default:child=this.parseWithFallback(this.Rule,consumeRaw$1)}children.push(child)}return{type:"StyleSheet",loc:this.getLocation(start,this.tokenStart),children:children}}function generate$8(node){this.children(node)}var StyleSheet=Object.freeze({__proto__:null,generate:generate$8,name:name$T,parse:parse$8,structure:structure$5,walkContext:walkContext})
const ASTERISK$2=0x002A
const VERTICALLINE$1=0x007C
function eatIdentifierOrAsterisk(){this.tokenType!==Ident&&this.isDelim(ASTERISK$2)===false&&this.error("Identifier or asterisk is expected")
this.next()}const name$S="TypeSelector"
const structure$4={name:String}
function parse$7(){const start=this.tokenStart
if(this.isDelim(VERTICALLINE$1)){this.next()
eatIdentifierOrAsterisk.call(this)}else{eatIdentifierOrAsterisk.call(this)
if(this.isDelim(VERTICALLINE$1)){this.next()
eatIdentifierOrAsterisk.call(this)}}return{type:"TypeSelector",loc:this.getLocation(start,this.tokenStart),name:this.substrToCursor(start)}}function generate$7(node){this.tokenize(node.name)}var TypeSelector=Object.freeze({__proto__:null,generate:generate$7,name:name$S,parse:parse$7,structure:structure$4})
const PLUSSIGN$2=0x002B
const HYPHENMINUS$1=0x002D
const QUESTIONMARK=0x003F
function eatHexSequence(offset,allowDash){let len=0
for(let pos=this.tokenStart+offset;pos<this.tokenEnd;pos++){const code=this.charCodeAt(pos)
if(code===HYPHENMINUS$1&&allowDash&&len!==0){eatHexSequence.call(this,offset+len+1,false)
return-1}isHexDigit(code)||this.error(allowDash&&len!==0?"Hyphen minus"+(len<6?" or hex digit":"")+" is expected":len<6?"Hex digit is expected":"Unexpected input",pos);++len>6&&this.error("Too many hex digits",pos)}this.next()
return len}function eatQuestionMarkSequence(max){let count=0
while(this.isDelim(QUESTIONMARK)){++count>max&&this.error("Too many question marks")
this.next()}}function startsWith(code){this.charCodeAt(this.tokenStart)!==code&&this.error((code===PLUSSIGN$2?"Plus sign":"Hyphen minus")+" is expected")}function scanUnicodeRange(){let hexLength=0
switch(this.tokenType){case Number$3:hexLength=eatHexSequence.call(this,1,true)
if(this.isDelim(QUESTIONMARK)){eatQuestionMarkSequence.call(this,6-hexLength)
break}if(this.tokenType===Dimension$1||this.tokenType===Number$3){startsWith.call(this,HYPHENMINUS$1)
eatHexSequence.call(this,1,false)
break}break
case Dimension$1:hexLength=eatHexSequence.call(this,1,true)
hexLength>0&&eatQuestionMarkSequence.call(this,6-hexLength)
break
default:this.eatDelim(PLUSSIGN$2)
if(this.tokenType===Ident){hexLength=eatHexSequence.call(this,0,true)
hexLength>0&&eatQuestionMarkSequence.call(this,6-hexLength)
break}if(this.isDelim(QUESTIONMARK)){this.next()
eatQuestionMarkSequence.call(this,5)
break}this.error("Hex digit or question mark is expected")}}const name$R="UnicodeRange"
const structure$3={value:String}
function parse$6(){const start=this.tokenStart
this.eatIdent("u")
scanUnicodeRange.call(this)
return{type:"UnicodeRange",loc:this.getLocation(start,this.tokenStart),value:this.substrToCursor(start)}}function generate$6(node){this.tokenize(node.value)}var UnicodeRange=Object.freeze({__proto__:null,generate:generate$6,name:name$R,parse:parse$6,structure:structure$3})
const SPACE$1=0x0020
const REVERSE_SOLIDUS=0x005c
const QUOTATION_MARK=0x0022
const APOSTROPHE=0x0027
const LEFTPARENTHESIS=0x0028
const RIGHTPARENTHESIS=0x0029
function decode(str){const len=str.length
let start=4
let end=str.charCodeAt(len-1)===RIGHTPARENTHESIS?len-2:len-1
let decoded=""
while(start<end&&isWhiteSpace$1(str.charCodeAt(start)))start++
while(start<end&&isWhiteSpace$1(str.charCodeAt(end)))end--
for(let i=start;i<=end;i++){let code=str.charCodeAt(i)
if(code===REVERSE_SOLIDUS){if(i===end){i!==len-1&&(decoded=str.substr(i+1))
break}code=str.charCodeAt(++i)
if(isValidEscape(REVERSE_SOLIDUS,code)){const escapeStart=i-1
const escapeEnd=consumeEscaped(str,escapeStart)
i=escapeEnd-1
decoded+=decodeEscaped(str.substring(escapeStart+1,escapeEnd))}else code===0x000d&&str.charCodeAt(i+1)===0x000a&&i++}else decoded+=str[i]}return decoded}function encode(str){let encoded=""
let wsBeforeHexIsNeeded=false
for(let i=0;i<str.length;i++){const code=str.charCodeAt(i)
if(code===0x0000){encoded+="�"
continue}if(code<=0x001f||code===0x007F){encoded+="\\"+code.toString(16)
wsBeforeHexIsNeeded=true
continue}if(code===SPACE$1||code===REVERSE_SOLIDUS||code===QUOTATION_MARK||code===APOSTROPHE||code===LEFTPARENTHESIS||code===RIGHTPARENTHESIS){encoded+="\\"+str.charAt(i)
wsBeforeHexIsNeeded=false}else{wsBeforeHexIsNeeded&&isHexDigit(code)&&(encoded+=" ")
encoded+=str.charAt(i)
wsBeforeHexIsNeeded=false}}return"url("+encoded+")"}const name$Q="Url"
const structure$2={value:String}
function parse$5(){const start=this.tokenStart
let value
switch(this.tokenType){case Url$2:value=decode(this.consume(Url$2))
break
case Function$1:this.cmpStr(this.tokenStart,this.tokenEnd,"url(")||this.error("Function name must be `url`")
this.eat(Function$1)
this.skipSC()
value=decode$1(this.consume(String$2))
this.skipSC()
this.eof||this.eat(RightParenthesis)
break
default:this.error("Url or Function is expected")}return{type:"Url",loc:this.getLocation(start,this.tokenStart),value:value}}function generate$5(node){this.token(Url$2,encode(node.value))}var Url$1=Object.freeze({__proto__:null,generate:generate$5,name:name$Q,parse:parse$5,structure:structure$2})
const name$P="Value"
const structure$1={children:[[]]}
function parse$4(){const start=this.tokenStart
const children=this.readSequence(this.scope.Value)
return{type:"Value",loc:this.getLocation(start,this.tokenStart),children:children}}function generate$4(node){this.children(node)}var Value=Object.freeze({__proto__:null,generate:generate$4,name:name$P,parse:parse$4,structure:structure$1})
const SPACE=Object.freeze({type:"WhiteSpace",loc:null,value:" "})
const name$O="WhiteSpace"
const structure={value:String}
function parse$3(){this.eat(WhiteSpace$1)
return SPACE}function generate$3(node){this.token(WhiteSpace$1,node.value)}var WhiteSpace=Object.freeze({__proto__:null,generate:generate$3,name:name$O,parse:parse$3,structure:structure})
var node$1=Object.freeze({__proto__:null,AnPlusB:AnPlusB,Atrule:Atrule$1,AtrulePrelude:AtrulePrelude,AttributeSelector:AttributeSelector$1,Block:Block,Brackets:Brackets,CDC:CDC,CDO:CDO,ClassSelector:ClassSelector,Combinator:Combinator,Comment:Comment,Declaration:Declaration,DeclarationList:DeclarationList,Dimension:Dimension,Function:Function,Hash:Hash,IdSelector:IdSelector,Identifier:Identifier,MediaFeature:MediaFeature,MediaQuery:MediaQuery,MediaQueryList:MediaQueryList,Nth:Nth,Number:Number$2,Operator:Operator,Parentheses:Parentheses,Percentage:Percentage,PseudoClassSelector:PseudoClassSelector,PseudoElementSelector:PseudoElementSelector,Ratio:Ratio,Raw:Raw,Rule:Rule,Selector:Selector,SelectorList:SelectorList,String:String$1,StyleSheet:StyleSheet,TypeSelector:TypeSelector,UnicodeRange:UnicodeRange,Url:Url$1,Value:Value,WhiteSpace:WhiteSpace})
var lexerConfig={generic:true,...definitions,node:node$1}
const NUMBERSIGN$1=0x0023
const ASTERISK$1=0x002A
const PLUSSIGN$1=0x002B
const HYPHENMINUS=0x002D
const SOLIDUS$1=0x002F
const U=0x0075
function defaultRecognizer(context){switch(this.tokenType){case Hash$1:return this.Hash()
case Comma:return this.Operator()
case LeftParenthesis:return this.Parentheses(this.readSequence,context.recognizer)
case LeftSquareBracket:return this.Brackets(this.readSequence,context.recognizer)
case String$2:return this.String()
case Dimension$1:return this.Dimension()
case Percentage$1:return this.Percentage()
case Number$3:return this.Number()
case Function$1:return this.cmpStr(this.tokenStart,this.tokenEnd,"url(")?this.Url():this.Function(this.readSequence,context.recognizer)
case Url$2:return this.Url()
case Ident:return this.cmpChar(this.tokenStart,U)&&this.cmpChar(this.tokenStart+1,PLUSSIGN$1)?this.UnicodeRange():this.Identifier()
case Delim:{const code=this.charCodeAt(this.tokenStart)
if(code===SOLIDUS$1||code===ASTERISK$1||code===PLUSSIGN$1||code===HYPHENMINUS)return this.Operator()
code===NUMBERSIGN$1&&this.error("Hex or identifier is expected",this.tokenStart+1)
break}}}var atrulePrelude={getNode:defaultRecognizer}
const NUMBERSIGN=0x0023
const ASTERISK=0x002A
const PLUSSIGN=0x002B
const SOLIDUS=0x002F
const FULLSTOP=0x002E
const GREATERTHANSIGN=0x003E
const VERTICALLINE=0x007C
const TILDE=0x007E
function onWhiteSpace(next,children){children.last!==null&&children.last.type!=="Combinator"&&next!==null&&next.type!=="Combinator"&&children.push({type:"Combinator",loc:null,name:" "})}function getNode(){switch(this.tokenType){case LeftSquareBracket:return this.AttributeSelector()
case Hash$1:return this.IdSelector()
case Colon:return this.lookupType(1)===Colon?this.PseudoElementSelector():this.PseudoClassSelector()
case Ident:return this.TypeSelector()
case Number$3:case Percentage$1:return this.Percentage()
case Dimension$1:this.charCodeAt(this.tokenStart)===FULLSTOP&&this.error("Identifier is expected",this.tokenStart+1)
break
case Delim:{const code=this.charCodeAt(this.tokenStart)
switch(code){case PLUSSIGN:case GREATERTHANSIGN:case TILDE:case SOLIDUS:return this.Combinator()
case FULLSTOP:return this.ClassSelector()
case ASTERISK:case VERTICALLINE:return this.TypeSelector()
case NUMBERSIGN:return this.IdSelector()}break}}}var selector$1={onWhiteSpace:onWhiteSpace,getNode:getNode}
function expressionFn(){return this.createSingleNodeList(this.Raw(this.tokenIndex,null,false))}function varFn(){const children=this.createList()
this.skipSC()
children.push(this.Identifier())
this.skipSC()
if(this.tokenType===Comma){children.push(this.Operator())
const startIndex=this.tokenIndex
const value=this.parseCustomProperty?this.Value(null):this.Raw(this.tokenIndex,this.consumeUntilExclamationMarkOrSemicolon,false)
if(value.type==="Value"&&value.children.isEmpty)for(let offset=startIndex-this.tokenIndex;offset<=0;offset++)if(this.lookupType(offset)===WhiteSpace$1){value.children.appendData({type:"WhiteSpace",loc:null,value:" "})
break}children.push(value)}return children}function isPlusMinusOperator(node){return node!==null&&node.type==="Operator"&&(node.value[node.value.length-1]==="-"||node.value[node.value.length-1]==="+")}var value={getNode:defaultRecognizer,onWhiteSpace(next,children){isPlusMinusOperator(next)&&(next.value=" "+next.value)
isPlusMinusOperator(children.last)&&(children.last.value+=" ")},expression:expressionFn,var:varFn}
var scope=Object.freeze({__proto__:null,AtrulePrelude:atrulePrelude,Selector:selector$1,Value:value})
var fontFace={parse:{prelude:null,block(){return this.Block(true)}}}
var importAtrule={parse:{prelude(){const children=this.createList()
this.skipSC()
switch(this.tokenType){case String$2:children.push(this.String())
break
case Url$2:case Function$1:children.push(this.Url())
break
default:this.error("String or url() is expected")}this.lookupNonWSType(0)!==Ident&&this.lookupNonWSType(0)!==LeftParenthesis||children.push(this.MediaQueryList())
return children},block:null}}
var media={parse:{prelude(){return this.createSingleNodeList(this.MediaQueryList())},block(){return this.Block(false)}}}
var page={parse:{prelude(){return this.createSingleNodeList(this.SelectorList())},block(){return this.Block(true)}}}
function consumeRaw(){return this.createSingleNodeList(this.Raw(this.tokenIndex,null,false))}function parentheses(){this.skipSC()
if(this.tokenType===Ident&&this.lookupNonWSType(1)===Colon)return this.createSingleNodeList(this.Declaration())
return readSequence.call(this)}function readSequence(){const children=this.createList()
let child
this.skipSC()
scan:while(!this.eof){switch(this.tokenType){case Comment$1:case WhiteSpace$1:this.next()
continue
case Function$1:child=this.Function(consumeRaw,this.scope.AtrulePrelude)
break
case Ident:child=this.Identifier()
break
case LeftParenthesis:child=this.Parentheses(parentheses,this.scope.AtrulePrelude)
break
default:break scan}children.push(child)}return children}var supports={parse:{prelude(){const children=readSequence.call(this)
this.getFirstListNode(children)===null&&this.error("Condition is expected")
return children},block(){return this.Block(false)}}}
var atrule={"font-face":fontFace,import:importAtrule,media:media,page:page,supports:supports}
const selectorList={parse(){return this.createSingleNodeList(this.SelectorList())}}
const selector={parse(){return this.createSingleNodeList(this.Selector())}}
const identList={parse(){return this.createSingleNodeList(this.Identifier())}}
const nth={parse(){return this.createSingleNodeList(this.Nth())}}
var pseudo={dir:identList,has:selectorList,lang:identList,matches:selectorList,is:selectorList,"-moz-any":selectorList,"-webkit-any":selectorList,where:selectorList,not:selectorList,"nth-child":nth,"nth-last-child":nth,"nth-last-of-type":nth,"nth-of-type":nth,slotted:selector}
var node=Object.freeze({__proto__:null,AnPlusB:parse$G,Atrule:parse$F,AtrulePrelude:parse$E,AttributeSelector:parse$D,Block:parse$C,Brackets:parse$B,CDC:parse$A,CDO:parse$z,ClassSelector:parse$y,Combinator:parse$x,Comment:parse$w,Declaration:parse$v,DeclarationList:parse$u,Dimension:parse$t,Function:parse$s,Hash:parse$r,IdSelector:parse$p,Identifier:parse$q,MediaFeature:parse$o,MediaQuery:parse$n,MediaQueryList:parse$m,Nth:parse$l,Number:parse$k,Operator:parse$j,Parentheses:parse$i,Percentage:parse$h,PseudoClassSelector:parse$g,PseudoElementSelector:parse$f,Ratio:parse$e,Raw:parse$d,Rule:parse$c,Selector:parse$b,SelectorList:parse$a,String:parse$9,StyleSheet:parse$8,TypeSelector:parse$7,UnicodeRange:parse$6,Url:parse$5,Value:parse$4,WhiteSpace:parse$3})
var parserConfig={parseContext:{default:"StyleSheet",stylesheet:"StyleSheet",atrule:"Atrule",atrulePrelude(options){return this.AtrulePrelude(options.atrule?String(options.atrule):null)},mediaQueryList:"MediaQueryList",mediaQuery:"MediaQuery",rule:"Rule",selectorList:"SelectorList",selector:"Selector",block(){return this.Block(true)},declarationList:"DeclarationList",declaration:"Declaration",value:"Value"},scope:scope,atrule:atrule,pseudo:pseudo,node:node}
var walkerConfig={node:node$1}
var syntax$1=createSyntax$1({...lexerConfig,...parserConfig,...walkerConfig})
function clone(node){const result={}
for(const key in node){let value=node[key]
value&&(Array.isArray(value)||value instanceof List?value=value.map(clone):value.constructor===Object&&(value=clone(value)))
result[key]=value}return result}const{tokenize:tokenize$1,parse:parse$2,generate:generate$2,lexer:lexer$1,createLexer:createLexer,walk:walk$1,find:find$1,findLast:findLast$1,findAll:findAll$1,toPlainObject:toPlainObject$1,fromPlainObject:fromPlainObject$1,fork:fork}=syntax$1
const{hasOwnProperty:hasOwnProperty$4}=Object.prototype
function buildMap(list,caseInsensitive){const map=Object.create(null)
if(!Array.isArray(list))return null
for(let name of list){caseInsensitive&&(name=name.toLowerCase())
map[name]=true}return map}function buildList(data){if(!data)return null
const tags=buildMap(data.tags,true)
const ids=buildMap(data.ids)
const classes=buildMap(data.classes)
if(tags===null&&ids===null&&classes===null)return null
return{tags:tags,ids:ids,classes:classes}}function buildIndex(data){let scopes=false
if(data.scopes&&Array.isArray(data.scopes)){scopes=Object.create(null)
for(let i=0;i<data.scopes.length;i++){const list=data.scopes[i]
if(!list||!Array.isArray(list))throw new Error("Wrong usage format")
for(const name of list){if(hasOwnProperty$4.call(scopes,name))throw new Error(`Class can't be used for several scopes: ${name}`)
scopes[name]=i+1}}}return{whitelist:buildList(data),blacklist:buildList(data.blacklist),scopes:scopes}}function hasNoChildren(node){return!node||!node.children||node.children.isEmpty}function isNodeChildrenList(node,list){return node!==null&&node.children===list}function cleanAtrule(node,item,list){if(node.block){this.stylesheet!==null&&(this.stylesheet.firstAtrulesAllowed=false)
if(hasNoChildren(node.block)){list.remove(item)
return}}switch(node.name){case"charset":if(hasNoChildren(node.prelude)){list.remove(item)
return}if(item.prev){list.remove(item)
return}break
case"import":if(this.stylesheet===null||!this.stylesheet.firstAtrulesAllowed){list.remove(item)
return}list.prevUntil(item.prev,(function(rule){if(rule.type==="Atrule"&&(rule.name==="import"||rule.name==="charset"))return
this.root.firstAtrulesAllowed=false
list.remove(item)
return true}),this)
break
default:{const name=keyword(node.name).basename
name!=="keyframes"&&name!=="media"&&name!=="supports"||(hasNoChildren(node.prelude)||hasNoChildren(node.block))&&list.remove(item)}}}function cleanComment(data,item,list){list.remove(item)}function cleanDeclartion(node,item,list){if(node.value.children&&node.value.children.isEmpty){list.remove(item)
return}property(node.property).custom&&/\S/.test(node.value.value)&&(node.value.value=node.value.value.trim())}function cleanRaw(node,item,list){(isNodeChildrenList(this.stylesheet,list)||isNodeChildrenList(this.block,list))&&list.remove(item)}const{hasOwnProperty:hasOwnProperty$3}=Object.prototype
const skipUsageFilteringAtrule=new Set(["keyframes"])
function cleanUnused(selectorList,usageData){selectorList.children.forEach(((selector,item,list)=>{let shouldRemove=false
walk$1(selector,(function(node){if(this.selector===null||this.selector===selectorList)switch(node.type){case"SelectorList":this.function!==null&&this.function.name.toLowerCase()==="not"||cleanUnused(node,usageData)&&(shouldRemove=true)
break
case"ClassSelector":usageData.whitelist===null||usageData.whitelist.classes===null||hasOwnProperty$3.call(usageData.whitelist.classes,node.name)||(shouldRemove=true)
usageData.blacklist!==null&&usageData.blacklist.classes!==null&&hasOwnProperty$3.call(usageData.blacklist.classes,node.name)&&(shouldRemove=true)
break
case"IdSelector":usageData.whitelist===null||usageData.whitelist.ids===null||hasOwnProperty$3.call(usageData.whitelist.ids,node.name)||(shouldRemove=true)
usageData.blacklist!==null&&usageData.blacklist.ids!==null&&hasOwnProperty$3.call(usageData.blacklist.ids,node.name)&&(shouldRemove=true)
break
case"TypeSelector":if(node.name.charAt(node.name.length-1)!=="*"){usageData.whitelist===null||usageData.whitelist.tags===null||hasOwnProperty$3.call(usageData.whitelist.tags,node.name.toLowerCase())||(shouldRemove=true)
usageData.blacklist!==null&&usageData.blacklist.tags!==null&&hasOwnProperty$3.call(usageData.blacklist.tags,node.name.toLowerCase())&&(shouldRemove=true)}break}}))
shouldRemove&&list.remove(item)}))
return selectorList.children.isEmpty}function cleanRule(node,item,list,options){if(hasNoChildren(node.prelude)||hasNoChildren(node.block)){list.remove(item)
return}if(this.atrule&&skipUsageFilteringAtrule.has(keyword(this.atrule.name).basename))return
const{usage:usage}=options
if(usage&&(usage.whitelist!==null||usage.blacklist!==null)){cleanUnused(node.prelude,usage)
if(hasNoChildren(node.prelude)){list.remove(item)
return}}}function cleanTypeSelector(node,item,list){const name=item.data.name
if(name!=="*")return
const nextType=item.next&&item.next.data.type
nextType!=="IdSelector"&&nextType!=="ClassSelector"&&nextType!=="AttributeSelector"&&nextType!=="PseudoClassSelector"&&nextType!=="PseudoElementSelector"||list.remove(item)}function cleanWhitespace(node,item,list){list.remove(item)}const handlers$2={Atrule:cleanAtrule,Comment:cleanComment,Declaration:cleanDeclartion,Raw:cleanRaw,Rule:cleanRule,TypeSelector:cleanTypeSelector,WhiteSpace:cleanWhitespace}
function clean(ast,options){walk$1(ast,{leave(node,item,list){handlers$2.hasOwnProperty(node.type)&&handlers$2[node.type].call(this,node,item,list,options)}})}function compressKeyframes(node){node.block.children.forEach((rule=>{rule.prelude.children.forEach((simpleselector=>{simpleselector.children.forEach(((data,item)=>{data.type==="Percentage"&&data.value==="100"?item.data={type:"TypeSelector",loc:data.loc,name:"to"}:data.type==="TypeSelector"&&data.name==="from"&&(item.data={type:"Percentage",loc:data.loc,value:"0"})}))}))}))}function Atrule(node){keyword(node.name).basename==="keyframes"&&compressKeyframes(node)}const blockUnquoteRx=/^(-?\d|--)|[\u0000-\u002c\u002e\u002f\u003A-\u0040\u005B-\u005E\u0060\u007B-\u009f]/
function canUnquote(value){if(value===""||value==="-")return false
return!blockUnquoteRx.test(value)}function AttributeSelector(node){const attrValue=node.value
if(!attrValue||attrValue.type!=="String")return
canUnquote(attrValue.value)&&(node.value={type:"Identifier",loc:attrValue.loc,name:attrValue.value})}function compressFont(node){const list=node.children
list.forEachRight((function(node,item){if(node.type==="Identifier")if(node.name==="bold")item.data={type:"Number",loc:node.loc,value:"700"}
else if(node.name==="normal"){const prev=item.prev
prev&&prev.data.type==="Operator"&&prev.data.value==="/"&&this.remove(prev)
this.remove(item)}}))
list.isEmpty&&list.insert(list.createItem({type:"Identifier",name:"normal"}))}function compressFontWeight(node){const value=node.children.head.data
if(value.type==="Identifier")switch(value.name){case"normal":node.children.head.data={type:"Number",loc:value.loc,value:"400"}
break
case"bold":node.children.head.data={type:"Number",loc:value.loc,value:"700"}
break}}function compressBackground(node){function flush(){buffer.length||buffer.unshift({type:"Number",loc:null,value:"0"},{type:"Number",loc:null,value:"0"})
newValue.push.apply(newValue,buffer)
buffer=[]}let newValue=[]
let buffer=[]
node.children.forEach((node=>{if(node.type==="Operator"&&node.value===","){flush()
newValue.push(node)
return}if(node.type==="Identifier"&&(node.name==="transparent"||node.name==="none"||node.name==="repeat"||node.name==="scroll"))return
buffer.push(node)}))
flush()
node.children=(new List).fromArray(newValue)}function compressBorder(node){node.children.forEach(((node,item,list)=>{node.type==="Identifier"&&node.name.toLowerCase()==="none"&&(list.head===list.tail?item.data={type:"Number",loc:node.loc,value:"0"}:list.remove(item))}))}const handlers$1={font:compressFont,"font-weight":compressFontWeight,background:compressBackground,border:compressBorder,outline:compressBorder}
function compressValue(node){if(!this.declaration)return
const property$1=property(this.declaration.property)
handlers$1.hasOwnProperty(property$1.basename)&&handlers$1[property$1.basename](node)}const OMIT_PLUSSIGN=/^(?:\+|(-))?0*(\d*)(?:\.0*|(\.\d*?)0*)?$/
function packNumber(value,item){const regexp=OMIT_PLUSSIGN
value=String(value).replace(regexp,"$1$2$3")
value!==""&&value!=="-"||(value="0")
return value}function Number$1(node){node.value=packNumber(node.value)}const MATH_FUNCTIONS=new Set(["calc","min","max","clamp"])
const LENGTH_UNIT=new Set(["px","mm","cm","in","pt","pc","em","ex","ch","rem","vh","vw","vmin","vmax","vm"])
function compressDimension(node,item){const value=packNumber(node.value)
node.value=value
if(value==="0"&&this.declaration!==null&&this.atrulePrelude===null){const unit=node.unit.toLowerCase()
if(!LENGTH_UNIT.has(unit))return
if(this.declaration.property==="-ms-flex"||this.declaration.property==="flex")return
if(this.function&&MATH_FUNCTIONS.has(this.function.name))return
item.data={type:"Number",loc:node.loc,value:value}}}const blacklist=new Set(["width","min-width","max-width","height","min-height","max-height","flex","-ms-flex"])
function compressPercentage(node,item){node.value=packNumber(node.value)
if(node.value==="0"&&this.declaration&&!blacklist.has(this.declaration.property)){item.data={type:"Number",loc:node.loc,value:node.value}
lexer$1.matchDeclaration(this.declaration).isType(item.data,"length")||(item.data=node)}}function Url(node){node.value=node.value.replace(/\\/g,"/")}const NAME_TO_HEX={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"0ff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000",blanchedalmond:"ffebcd",blue:"00f",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"0ff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgrey:"a9a9a9",darkgreen:"006400",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkslategrey:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dimgrey:"696969",dodgerblue:"1e90ff",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"f0f",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",grey:"808080",green:"008000",greenyellow:"adff2f",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgray:"d3d3d3",lightgrey:"d3d3d3",lightgreen:"90ee90",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslategray:"789",lightslategrey:"789",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"0f0",limegreen:"32cd32",linen:"faf0e6",magenta:"f0f",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370db",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"db7093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",rebeccapurple:"639",red:"f00",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",slategrey:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",wheat:"f5deb3",white:"fff",whitesmoke:"f5f5f5",yellow:"ff0",yellowgreen:"9acd32"}
const HEX_TO_NAME={800000:"maroon",800080:"purple",808000:"olive",808080:"gray","00ffff":"cyan",f0ffff:"azure",f5f5dc:"beige",ffe4c4:"bisque","000000":"black","0000ff":"blue",a52a2a:"brown",ff7f50:"coral",ffd700:"gold","008000":"green","4b0082":"indigo",fffff0:"ivory",f0e68c:"khaki","00ff00":"lime",faf0e6:"linen","000080":"navy",ffa500:"orange",da70d6:"orchid",cd853f:"peru",ffc0cb:"pink",dda0dd:"plum",f00:"red",ff0000:"red",fa8072:"salmon",a0522d:"sienna",c0c0c0:"silver",fffafa:"snow",d2b48c:"tan","008080":"teal",ff6347:"tomato",ee82ee:"violet",f5deb3:"wheat",ffffff:"white",ffff00:"yellow"}
function hueToRgb(p,q,t){t<0&&(t+=1)
t>1&&(t-=1)
if(t<1/6)return p+6*(q-p)*t
if(t<.5)return q
if(t<2/3)return p+(q-p)*(2/3-t)*6
return p}function hslToRgb(h,s,l,a){let r
let g
let b
if(s===0)r=g=b=l
else{const q=l<0.5?l*(1+s):l+s-l*s
const p=2*l-q
r=hueToRgb(p,q,h+1/3)
g=hueToRgb(p,q,h)
b=hueToRgb(p,q,h-1/3)}return[Math.round(r*255),Math.round(g*255),Math.round(b*255),a]}function toHex(value){value=value.toString(16)
return value.length===1?"0"+value:value}function parseFunctionArgs(functionArgs,count,rgb){let cursor=functionArgs.head
let args=[]
let wasValue=false
while(cursor!==null){const{type:type,value:value}=cursor.data
switch(type){case"Number":case"Percentage":if(wasValue)return
wasValue=true
args.push({type:type,value:Number(value)})
break
case"Operator":if(value===","){if(!wasValue)return
wasValue=false}else if(wasValue||value!=="+")return
break
default:return}cursor=cursor.next}if(args.length!==count)return
if(args.length===4){if(args[3].type!=="Number")return
args[3].type="Alpha"}if(rgb){if(args[0].type!==args[1].type||args[0].type!==args[2].type)return}else{if(args[0].type!=="Number"||args[1].type!=="Percentage"||args[2].type!=="Percentage")return
args[0].type="Angle"}return args.map((function(arg){let value=Math.max(0,arg.value)
switch(arg.type){case"Number":value=Math.min(value,255)
break
case"Percentage":value=Math.min(value,100)/100
if(!rgb)return value
value*=255
break
case"Angle":return(value%360+360)%360/360
case"Alpha":return Math.min(value,1)}return Math.round(value)}))}function compressFunction(node,item){let functionName=node.name
let args
if(functionName==="rgba"||functionName==="hsla"){args=parseFunctionArgs(node.children,4,functionName==="rgba")
if(!args)return
if(functionName==="hsla"){args=hslToRgb(...args)
node.name="rgba"}if(args[3]===0){const scopeFunctionName=this.function&&this.function.name
if(args[0]===0&&args[1]===0&&args[2]===0||!/^(?:to|from|color-stop)$|gradient$/i.test(scopeFunctionName)){item.data={type:"Identifier",loc:node.loc,name:"transparent"}
return}}if(args[3]!==1){node.children.forEach(((node,item,list)=>{if(node.type==="Operator"){node.value!==","&&list.remove(item)
return}item.data={type:"Number",loc:node.loc,value:packNumber(args.shift())}}))
return}functionName="rgb"}if(functionName==="hsl"){args=args||parseFunctionArgs(node.children,3,false)
if(!args)return
args=hslToRgb(...args)
functionName="rgb"}if(functionName==="rgb"){args=args||parseFunctionArgs(node.children,3,true)
if(!args)return
item.data={type:"Hash",loc:node.loc,value:toHex(args[0])+toHex(args[1])+toHex(args[2])}
compressHex(item.data,item)}}function compressIdent(node,item){if(this.declaration===null)return
let color=node.name.toLowerCase()
if(NAME_TO_HEX.hasOwnProperty(color)&&lexer$1.matchDeclaration(this.declaration).isType(node,"color")){const hex=NAME_TO_HEX[color]
if(hex.length+1<=color.length)item.data={type:"Hash",loc:node.loc,value:hex}
else{color==="grey"&&(color="gray")
node.name=color}}}function compressHex(node,item){let color=node.value.toLowerCase()
color.length===6&&color[0]===color[1]&&color[2]===color[3]&&color[4]===color[5]&&(color=color[0]+color[2]+color[4])
HEX_TO_NAME[color]?item.data={type:"Identifier",loc:node.loc,name:HEX_TO_NAME[color]}:node.value=color}const handlers={Atrule:Atrule,AttributeSelector:AttributeSelector,Value:compressValue,Dimension:compressDimension,Percentage:compressPercentage,Number:Number$1,Url:Url,Hash:compressHex,Identifier:compressIdent,Function:compressFunction}
function replace(ast){walk$1(ast,{leave(node,item,list){handlers.hasOwnProperty(node.type)&&handlers[node.type].call(this,node,item,list)}})}class Index{constructor(){this.map=new Map}resolve(str){let index=this.map.get(str)
if(index===void 0){index=this.map.size+1
this.map.set(str,index)}return index}}function createDeclarationIndexer(){const ids=new Index
return function markDeclaration(node){const id=generate$2(node)
node.id=ids.resolve(id)
node.length=id.length
node.fingerprint=null
return node}}function ensureSelectorList(node){if(node.type==="Raw")return parse$2(node.value,{context:"selectorList"})
return node}function maxSpecificity(a,b){for(let i=0;i<3;i++)if(a[i]!==b[i])return a[i]>b[i]?a:b
return a}function maxSelectorListSpecificity(selectorList){return ensureSelectorList(selectorList).children.reduce(((result,node)=>maxSpecificity(specificity(node),result)),[0,0,0])}function specificity(simpleSelector){let A=0
let B=0
let C=0
simpleSelector.children.forEach((node=>{switch(node.type){case"IdSelector":A++
break
case"ClassSelector":case"AttributeSelector":B++
break
case"PseudoClassSelector":switch(node.name.toLowerCase()){case"not":case"has":case"is":case"matches":case"-webkit-any":case"-moz-any":{const[a,b,c]=maxSelectorListSpecificity(node.children.first)
A+=a
B+=b
C+=c
break}case"nth-child":case"nth-last-child":{const arg=node.children.first
if(arg.type==="Nth"&&arg.selector){const[a,b,c]=maxSelectorListSpecificity(arg.selector)
A+=a
B+=b+1
C+=c}else B++
break}case"where":break
case"before":case"after":case"first-line":case"first-letter":C++
break
default:B++}break
case"TypeSelector":node.name.endsWith("*")||C++
break
case"PseudoElementSelector":C++
break}}))
return[A,B,C]}const nonFreezePseudoElements=new Set(["first-letter","first-line","after","before"])
const nonFreezePseudoClasses=new Set(["link","visited","hover","active","first-letter","first-line","after","before"])
function processSelector(node,usageData){const pseudos=new Set
node.prelude.children.forEach((function(simpleSelector){let tagName="*"
let scope=0
simpleSelector.children.forEach((function(node){switch(node.type){case"ClassSelector":if(usageData&&usageData.scopes){const classScope=usageData.scopes[node.name]||0
if(scope!==0&&classScope!==scope)throw new Error("Selector can't has classes from different scopes: "+generate$2(simpleSelector))
scope=classScope}break
case"PseudoClassSelector":{const name=node.name.toLowerCase()
nonFreezePseudoClasses.has(name)||pseudos.add(`:${name}`)
break}case"PseudoElementSelector":{const name=node.name.toLowerCase()
nonFreezePseudoElements.has(name)||pseudos.add(`::${name}`)
break}case"TypeSelector":tagName=node.name.toLowerCase()
break
case"AttributeSelector":node.flags&&pseudos.add(`[${node.flags.toLowerCase()}]`)
break
case"Combinator":tagName="*"
break}}))
simpleSelector.compareMarker=specificity(simpleSelector).toString()
simpleSelector.id=null
simpleSelector.id=generate$2(simpleSelector)
scope&&(simpleSelector.compareMarker+=":"+scope)
tagName!=="*"&&(simpleSelector.compareMarker+=","+tagName)}))
node.pseudoSignature=pseudos.size>0&&[...pseudos].sort().join(",")}function prepare(ast,options){const markDeclaration=createDeclarationIndexer()
walk$1(ast,{visit:"Rule",enter(node){node.block.children.forEach(markDeclaration)
processSelector(node,options.usage)}})
walk$1(ast,{visit:"Atrule",enter(node){if(node.prelude){node.prelude.id=null
node.prelude.id=generate$2(node.prelude)}if(keyword(node.name).basename==="keyframes"){node.block.avoidRulesMerge=true
node.block.children.forEach((function(rule){rule.prelude.children.forEach((function(simpleselector){simpleselector.compareMarker=simpleselector.id}))}))}}})
return{declaration:markDeclaration}}const{hasOwnProperty:hasOwnProperty$2}=Object.prototype
function addRuleToMap(map,item,list,single){const node=item.data
const name=keyword(node.name).basename
const id=node.name.toLowerCase()+"/"+(node.prelude?node.prelude.id:null)
hasOwnProperty$2.call(map,name)||(map[name]=Object.create(null))
single&&delete map[name][id]
hasOwnProperty$2.call(map[name],id)||(map[name][id]=new List)
map[name][id].append(list.remove(item))}function relocateAtrules(ast,options){const collected=Object.create(null)
let topInjectPoint=null
ast.children.forEach((function(node,item,list){if(node.type==="Atrule"){const name=keyword(node.name).basename
switch(name){case"keyframes":addRuleToMap(collected,item,list,true)
return
case"media":if(options.forceMediaMerge){addRuleToMap(collected,item,list,false)
return}break}topInjectPoint===null&&name!=="charset"&&name!=="import"&&(topInjectPoint=item)}else topInjectPoint===null&&(topInjectPoint=item)}))
for(const atrule in collected)for(const id in collected[atrule])ast.children.insertList(collected[atrule][id],atrule==="media"?null:topInjectPoint)}function isMediaRule(node){return node.type==="Atrule"&&node.name==="media"}function processAtrule(node,item,list){if(!isMediaRule(node))return
const prev=item.prev&&item.prev.data
if(!prev||!isMediaRule(prev))return
if(node.prelude&&prev.prelude&&node.prelude.id===prev.prelude.id){prev.block.children.appendList(node.block.children)
list.remove(item)}}function rejoinAtrule(ast,options){relocateAtrules(ast,options)
walk$1(ast,{visit:"Atrule",reverse:true,enter:processAtrule})}const{hasOwnProperty:hasOwnProperty$1}=Object.prototype
function isEqualSelectors(a,b){let cursor1=a.head
let cursor2=b.head
while(cursor1!==null&&cursor2!==null&&cursor1.data.id===cursor2.data.id){cursor1=cursor1.next
cursor2=cursor2.next}return cursor1===null&&cursor2===null}function isEqualDeclarations(a,b){let cursor1=a.head
let cursor2=b.head
while(cursor1!==null&&cursor2!==null&&cursor1.data.id===cursor2.data.id){cursor1=cursor1.next
cursor2=cursor2.next}return cursor1===null&&cursor2===null}function compareDeclarations(declarations1,declarations2){const result={eq:[],ne1:[],ne2:[],ne2overrided:[]}
const fingerprints=Object.create(null)
const declarations2hash=Object.create(null)
for(let cursor=declarations2.head;cursor;cursor=cursor.next)declarations2hash[cursor.data.id]=true
for(let cursor=declarations1.head;cursor;cursor=cursor.next){const data=cursor.data
data.fingerprint&&(fingerprints[data.fingerprint]=data.important)
if(declarations2hash[data.id]){declarations2hash[data.id]=false
result.eq.push(data)}else result.ne1.push(data)}for(let cursor=declarations2.head;cursor;cursor=cursor.next){const data=cursor.data
if(declarations2hash[data.id]){(!hasOwnProperty$1.call(fingerprints,data.fingerprint)||!fingerprints[data.fingerprint]&&data.important)&&result.ne2.push(data)
result.ne2overrided.push(data)}}return result}function addSelectors(dest,source){source.forEach((sourceData=>{const newStr=sourceData.id
let cursor=dest.head
while(cursor){const nextStr=cursor.data.id
if(nextStr===newStr)return
if(nextStr>newStr)break
cursor=cursor.next}dest.insert(dest.createItem(sourceData),cursor)}))
return dest}function hasSimilarSelectors(selectors1,selectors2){let cursor1=selectors1.head
while(cursor1!==null){let cursor2=selectors2.head
while(cursor2!==null){if(cursor1.data.compareMarker===cursor2.data.compareMarker)return true
cursor2=cursor2.next}cursor1=cursor1.next}return false}function unsafeToSkipNode(node){switch(node.type){case"Rule":return hasSimilarSelectors(node.prelude.children,this)
case"Atrule":if(node.block)return node.block.children.some(unsafeToSkipNode,this)
break
case"Declaration":return false}return true}function processRule$5(node,item,list){const selectors=node.prelude.children
const declarations=node.block.children
list.prevUntil(item.prev,(function(prev){if(prev.type!=="Rule")return unsafeToSkipNode.call(selectors,prev)
const prevSelectors=prev.prelude.children
const prevDeclarations=prev.block.children
if(node.pseudoSignature===prev.pseudoSignature){if(isEqualSelectors(prevSelectors,selectors)){prevDeclarations.appendList(declarations)
list.remove(item)
return true}if(isEqualDeclarations(declarations,prevDeclarations)){addSelectors(prevSelectors,selectors)
list.remove(item)
return true}}return hasSimilarSelectors(selectors,prevSelectors)}))}function initialMergeRule(ast){walk$1(ast,{visit:"Rule",enter:processRule$5})}function processRule$4(node,item,list){const selectors=node.prelude.children
while(selectors.head!==selectors.tail){const newSelectors=new List
newSelectors.insert(selectors.remove(selectors.head))
list.insert(list.createItem({type:"Rule",loc:node.loc,prelude:{type:"SelectorList",loc:node.prelude.loc,children:newSelectors},block:{type:"Block",loc:node.block.loc,children:node.block.children.copy()},pseudoSignature:node.pseudoSignature}),item)}}function disjoinRule(ast){walk$1(ast,{visit:"Rule",reverse:true,enter:processRule$4})}const REPLACE=1
const REMOVE=2
const TOP=0
const RIGHT=1
const BOTTOM=2
const LEFT=3
const SIDES=["top","right","bottom","left"]
const SIDE={"margin-top":"top","margin-right":"right","margin-bottom":"bottom","margin-left":"left","padding-top":"top","padding-right":"right","padding-bottom":"bottom","padding-left":"left","border-top-color":"top","border-right-color":"right","border-bottom-color":"bottom","border-left-color":"left","border-top-width":"top","border-right-width":"right","border-bottom-width":"bottom","border-left-width":"left","border-top-style":"top","border-right-style":"right","border-bottom-style":"bottom","border-left-style":"left"}
const MAIN_PROPERTY={margin:"margin","margin-top":"margin","margin-right":"margin","margin-bottom":"margin","margin-left":"margin",padding:"padding","padding-top":"padding","padding-right":"padding","padding-bottom":"padding","padding-left":"padding","border-color":"border-color","border-top-color":"border-color","border-right-color":"border-color","border-bottom-color":"border-color","border-left-color":"border-color","border-width":"border-width","border-top-width":"border-width","border-right-width":"border-width","border-bottom-width":"border-width","border-left-width":"border-width","border-style":"border-style","border-top-style":"border-style","border-right-style":"border-style","border-bottom-style":"border-style","border-left-style":"border-style"}
class TRBL{constructor(name){this.name=name
this.loc=null
this.iehack=void 0
this.sides={top:null,right:null,bottom:null,left:null}}getValueSequence(declaration,count){const values=[]
let iehack=""
const hasBadValues=declaration.value.type!=="Value"||declaration.value.children.some((function(child){let special=false
switch(child.type){case"Identifier":switch(child.name){case"\\0":case"\\9":iehack=child.name
return
case"inherit":case"initial":case"unset":case"revert":special=child.name
break}break
case"Dimension":switch(child.unit){case"rem":case"vw":case"vh":case"vmin":case"vmax":case"vm":special=child.unit
break}break
case"Hash":case"Number":case"Percentage":break
case"Function":if(child.name==="var")return true
special=child.name
break
default:return true}values.push({node:child,special:special,important:declaration.important})}))
if(hasBadValues||values.length>count)return false
if(typeof this.iehack==="string"&&this.iehack!==iehack)return false
this.iehack=iehack
return values}canOverride(side,value){const currentValue=this.sides[side]
return!currentValue||value.important&&!currentValue.important}add(name,declaration){function attemptToAdd(){const sides=this.sides
const side=SIDE[name]
if(side){if(side in sides===false)return false
const values=this.getValueSequence(declaration,1)
if(!values||!values.length)return false
for(const key in sides)if(sides[key]!==null&&sides[key].special!==values[0].special)return false
if(!this.canOverride(side,values[0]))return true
sides[side]=values[0]
return true}if(name===this.name){const values=this.getValueSequence(declaration,4)
if(!values||!values.length)return false
switch(values.length){case 1:values[RIGHT]=values[TOP]
values[BOTTOM]=values[TOP]
values[LEFT]=values[TOP]
break
case 2:values[BOTTOM]=values[TOP]
values[LEFT]=values[RIGHT]
break
case 3:values[LEFT]=values[RIGHT]
break}for(let i=0;i<4;i++)for(const key in sides)if(sides[key]!==null&&sides[key].special!==values[i].special)return false
for(let i=0;i<4;i++)this.canOverride(SIDES[i],values[i])&&(sides[SIDES[i]]=values[i])
return true}}if(!attemptToAdd.call(this))return false
this.loc||(this.loc=declaration.loc)
return true}isOkToMinimize(){const top=this.sides.top
const right=this.sides.right
const bottom=this.sides.bottom
const left=this.sides.left
if(top&&right&&bottom&&left){const important=top.important+right.important+bottom.important+left.important
return important===0||important===4}return false}getValue(){const result=new List
const sides=this.sides
const values=[sides.top,sides.right,sides.bottom,sides.left]
const stringValues=[generate$2(sides.top.node),generate$2(sides.right.node),generate$2(sides.bottom.node),generate$2(sides.left.node)]
if(stringValues[LEFT]===stringValues[RIGHT]){values.pop()
if(stringValues[BOTTOM]===stringValues[TOP]){values.pop()
stringValues[RIGHT]===stringValues[TOP]&&values.pop()}}for(let i=0;i<values.length;i++)result.appendData(values[i].node)
this.iehack&&result.appendData({type:"Identifier",loc:null,name:this.iehack})
return{type:"Value",loc:null,children:result}}getDeclaration(){return{type:"Declaration",loc:this.loc,important:this.sides.top.important,property:this.name,value:this.getValue()}}}function processRule$3(rule,shorts,shortDeclarations,lastShortSelector){const declarations=rule.block.children
const selector=rule.prelude.children.first.id
rule.block.children.forEachRight((function(declaration,item){const property=declaration.property
if(!MAIN_PROPERTY.hasOwnProperty(property))return
const key=MAIN_PROPERTY[property]
let shorthand
let operation
if((!lastShortSelector||selector===lastShortSelector)&&key in shorts){operation=REMOVE
shorthand=shorts[key]}if(!shorthand||!shorthand.add(property,declaration)){operation=REPLACE
shorthand=new TRBL(key)
if(!shorthand.add(property,declaration)){lastShortSelector=null
return}}shorts[key]=shorthand
shortDeclarations.push({operation:operation,block:declarations,item:item,shorthand:shorthand})
lastShortSelector=selector}))
return lastShortSelector}function processShorthands(shortDeclarations,markDeclaration){shortDeclarations.forEach((function(item){const shorthand=item.shorthand
if(!shorthand.isOkToMinimize())return
item.operation===REPLACE?item.item.data=markDeclaration(shorthand.getDeclaration()):item.block.remove(item.item)}))}function restructBlock$1(ast,indexer){const stylesheetMap={}
const shortDeclarations=[]
walk$1(ast,{visit:"Rule",reverse:true,enter(node){const stylesheet=this.block||this.stylesheet
const ruleId=(node.pseudoSignature||"")+"|"+node.prelude.children.first.id
let ruleMap
let shorts
if(stylesheetMap.hasOwnProperty(stylesheet.id))ruleMap=stylesheetMap[stylesheet.id]
else{ruleMap={lastShortSelector:null}
stylesheetMap[stylesheet.id]=ruleMap}if(ruleMap.hasOwnProperty(ruleId))shorts=ruleMap[ruleId]
else{shorts={}
ruleMap[ruleId]=shorts}ruleMap.lastShortSelector=processRule$3.call(this,node,shorts,shortDeclarations,ruleMap.lastShortSelector)}})
processShorthands(shortDeclarations,indexer.declaration)}let fingerprintId=1
const dontRestructure=new Set(["src"])
const DONT_MIX_VALUE={display:/table|ruby|flex|-(flex)?box$|grid|contents|run-in/i,"text-align":/^(start|end|match-parent|justify-all)$/i}
const SAFE_VALUES={cursor:["auto","crosshair","default","move","text","wait","help","n-resize","e-resize","s-resize","w-resize","ne-resize","nw-resize","se-resize","sw-resize","pointer","progress","not-allowed","no-drop","vertical-text","all-scroll","col-resize","row-resize"],overflow:["hidden","visible","scroll","auto"],position:["static","relative","absolute","fixed"]}
const NEEDLESS_TABLE={"border-width":["border"],"border-style":["border"],"border-color":["border"],"border-top":["border"],"border-right":["border"],"border-bottom":["border"],"border-left":["border"],"border-top-width":["border-top","border-width","border"],"border-right-width":["border-right","border-width","border"],"border-bottom-width":["border-bottom","border-width","border"],"border-left-width":["border-left","border-width","border"],"border-top-style":["border-top","border-style","border"],"border-right-style":["border-right","border-style","border"],"border-bottom-style":["border-bottom","border-style","border"],"border-left-style":["border-left","border-style","border"],"border-top-color":["border-top","border-color","border"],"border-right-color":["border-right","border-color","border"],"border-bottom-color":["border-bottom","border-color","border"],"border-left-color":["border-left","border-color","border"],"margin-top":["margin"],"margin-right":["margin"],"margin-bottom":["margin"],"margin-left":["margin"],"padding-top":["padding"],"padding-right":["padding"],"padding-bottom":["padding"],"padding-left":["padding"],"font-style":["font"],"font-variant":["font"],"font-weight":["font"],"font-size":["font"],"font-family":["font"],"list-style-type":["list-style"],"list-style-position":["list-style"],"list-style-image":["list-style"]}
function getPropertyFingerprint(propertyName,declaration,fingerprints){const realName=property(propertyName).basename
if(realName==="background")return propertyName+":"+generate$2(declaration.value)
const declarationId=declaration.id
let fingerprint=fingerprints[declarationId]
if(!fingerprint){switch(declaration.value.type){case"Value":const special={}
let vendorId=""
let iehack=""
let raw=false
declaration.value.children.forEach((function walk(node){switch(node.type){case"Value":case"Brackets":case"Parentheses":node.children.forEach(walk)
break
case"Raw":raw=true
break
case"Identifier":{const{name:name}=node
vendorId||(vendorId=keyword(name).vendor);/\\[09]/.test(name)&&(iehack=RegExp.lastMatch)
SAFE_VALUES.hasOwnProperty(realName)?SAFE_VALUES[realName].indexOf(name)===-1&&(special[name]=true):DONT_MIX_VALUE.hasOwnProperty(realName)&&DONT_MIX_VALUE[realName].test(name)&&(special[name]=true)
break}case"Function":{let{name:name}=node
vendorId||(vendorId=keyword(name).vendor)
if(name==="rect"){const hasComma=node.children.some((node=>node.type==="Operator"&&node.value===","))
hasComma||(name="rect-backward")}special[name+"()"]=true
node.children.forEach(walk)
break}case"Dimension":{const{unit:unit}=node;/\\[09]/.test(unit)&&(iehack=RegExp.lastMatch)
switch(unit){case"rem":case"vw":case"vh":case"vmin":case"vmax":case"vm":special[unit]=true
break}break}}}))
fingerprint=raw?"!"+fingerprintId++:"!"+Object.keys(special).sort()+"|"+iehack+vendorId
break
case"Raw":fingerprint="!"+declaration.value.value
break
default:fingerprint=generate$2(declaration.value)}fingerprints[declarationId]=fingerprint}return propertyName+fingerprint}function needless(props,declaration,fingerprints){const property$1=property(declaration.property)
if(NEEDLESS_TABLE.hasOwnProperty(property$1.basename)){const table=NEEDLESS_TABLE[property$1.basename]
for(const entry of table){const ppre=getPropertyFingerprint(property$1.prefix+entry,declaration,fingerprints)
const prev=props.hasOwnProperty(ppre)?props[ppre]:null
if(prev&&(!declaration.important||prev.item.data.important))return prev}}}function processRule$2(rule,item,list,props,fingerprints){const declarations=rule.block.children
declarations.forEachRight((function(declaration,declarationItem){const{property:property}=declaration
const fingerprint=getPropertyFingerprint(property,declaration,fingerprints)
const prev=props[fingerprint]
if(prev&&!dontRestructure.has(property))if(declaration.important&&!prev.item.data.important){props[fingerprint]={block:declarations,item:declarationItem}
prev.block.remove(prev.item)}else declarations.remove(declarationItem)
else{const prev=needless(props,declaration,fingerprints)
if(prev)declarations.remove(declarationItem)
else{declaration.fingerprint=fingerprint
props[fingerprint]={block:declarations,item:declarationItem}}}}))
declarations.isEmpty&&list.remove(item)}function restructBlock(ast){const stylesheetMap={}
const fingerprints=Object.create(null)
walk$1(ast,{visit:"Rule",reverse:true,enter(node,item,list){const stylesheet=this.block||this.stylesheet
const ruleId=(node.pseudoSignature||"")+"|"+node.prelude.children.first.id
let ruleMap
let props
if(stylesheetMap.hasOwnProperty(stylesheet.id))ruleMap=stylesheetMap[stylesheet.id]
else{ruleMap={}
stylesheetMap[stylesheet.id]=ruleMap}if(ruleMap.hasOwnProperty(ruleId))props=ruleMap[ruleId]
else{props={}
ruleMap[ruleId]=props}processRule$2.call(this,node,item,list,props,fingerprints)}})}function processRule$1(node,item,list){const selectors=node.prelude.children
const declarations=node.block.children
const nodeCompareMarker=selectors.first.compareMarker
const skippedCompareMarkers={}
list.nextUntil(item.next,(function(next,nextItem){if(next.type!=="Rule")return unsafeToSkipNode.call(selectors,next)
if(node.pseudoSignature!==next.pseudoSignature)return true
const nextFirstSelector=next.prelude.children.head
const nextDeclarations=next.block.children
const nextCompareMarker=nextFirstSelector.data.compareMarker
if(nextCompareMarker in skippedCompareMarkers)return true
if(selectors.head===selectors.tail&&selectors.first.id===nextFirstSelector.data.id){declarations.appendList(nextDeclarations)
list.remove(nextItem)
return}if(isEqualDeclarations(declarations,nextDeclarations)){const nextStr=nextFirstSelector.data.id
selectors.some(((data,item)=>{const curStr=data.id
if(nextStr<curStr){selectors.insert(nextFirstSelector,item)
return true}if(!item.next){selectors.insert(nextFirstSelector)
return true}}))
list.remove(nextItem)
return}if(nextCompareMarker===nodeCompareMarker)return true
skippedCompareMarkers[nextCompareMarker]=true}))}function mergeRule(ast){walk$1(ast,{visit:"Rule",enter:processRule$1})}function calcSelectorLength(list){return list.reduce(((res,data)=>res+data.id.length+1),0)-1}function calcDeclarationsLength(tokens){let length=0
for(const token of tokens)length+=token.length
return length+tokens.length-1}function processRule(node,item,list){const avoidRulesMerge=this.block!==null&&this.block.avoidRulesMerge
const selectors=node.prelude.children
const block=node.block
const disallowDownMarkers=Object.create(null)
let allowMergeUp=true
let allowMergeDown=true
list.prevUntil(item.prev,(function(prev,prevItem){const prevBlock=prev.block
const prevType=prev.type
if(prevType!=="Rule"){const unsafe=unsafeToSkipNode.call(selectors,prev)
!unsafe&&prevType==="Atrule"&&prevBlock&&walk$1(prevBlock,{visit:"Rule",enter(node){node.prelude.children.forEach((data=>{disallowDownMarkers[data.compareMarker]=true}))}})
return unsafe}if(node.pseudoSignature!==prev.pseudoSignature)return true
const prevSelectors=prev.prelude.children
allowMergeDown=!prevSelectors.some((selector=>selector.compareMarker in disallowDownMarkers))
if(!allowMergeDown&&!allowMergeUp)return true
if(allowMergeUp&&isEqualSelectors(prevSelectors,selectors)){prevBlock.children.appendList(block.children)
list.remove(item)
return true}const diff=compareDeclarations(block.children,prevBlock.children)
if(diff.eq.length){if(!diff.ne1.length&&!diff.ne2.length){if(allowMergeDown){addSelectors(selectors,prevSelectors)
list.remove(prevItem)}return true}if(!avoidRulesMerge)if(diff.ne1.length&&!diff.ne2.length){const selectorLength=calcSelectorLength(selectors)
const blockLength=calcDeclarationsLength(diff.eq)
if(allowMergeUp&&selectorLength<blockLength){addSelectors(prevSelectors,selectors)
block.children.fromArray(diff.ne1)}}else if(!diff.ne1.length&&diff.ne2.length){const selectorLength=calcSelectorLength(prevSelectors)
const blockLength=calcDeclarationsLength(diff.eq)
if(allowMergeDown&&selectorLength<blockLength){addSelectors(selectors,prevSelectors)
prevBlock.children.fromArray(diff.ne2)}}else{const newSelector={type:"SelectorList",loc:null,children:addSelectors(prevSelectors.copy(),selectors)}
const newBlockLength=calcSelectorLength(newSelector.children)+2
const blockLength=calcDeclarationsLength(diff.eq)
if(blockLength>=newBlockLength){const newItem=list.createItem({type:"Rule",loc:null,prelude:newSelector,block:{type:"Block",loc:null,children:(new List).fromArray(diff.eq)},pseudoSignature:node.pseudoSignature})
block.children.fromArray(diff.ne1)
prevBlock.children.fromArray(diff.ne2overrided)
allowMergeUp?list.insert(newItem,prevItem):list.insert(newItem,item)
return true}}}allowMergeUp&&(allowMergeUp=!prevSelectors.some((prevSelector=>selectors.some((selector=>selector.compareMarker===prevSelector.compareMarker)))))
prevSelectors.forEach((data=>{disallowDownMarkers[data.compareMarker]=true}))}))}function restructRule(ast){walk$1(ast,{visit:"Rule",reverse:true,enter:processRule})}function restructure(ast,options){const indexer=prepare(ast,options)
options.logger("prepare",ast)
rejoinAtrule(ast,options)
options.logger("mergeAtrule",ast)
initialMergeRule(ast)
options.logger("initialMergeRuleset",ast)
disjoinRule(ast)
options.logger("disjoinRuleset",ast)
restructBlock$1(ast,indexer)
options.logger("restructShorthand",ast)
restructBlock(ast)
options.logger("restructBlock",ast)
mergeRule(ast)
options.logger("mergeRuleset",ast)
restructRule(ast)
options.logger("restructRuleset",ast)}function readChunk(input,specialComments){const children=new List
let nonSpaceTokenInBuffer=false
let protectedComment
input.nextUntil(input.head,((node,item,list)=>{if(node.type==="Comment"){if(!specialComments||node.value.charAt(0)!=="!"){list.remove(item)
return}if(nonSpaceTokenInBuffer||protectedComment)return true
list.remove(item)
protectedComment=node
return}node.type!=="WhiteSpace"&&(nonSpaceTokenInBuffer=true)
children.insert(list.remove(item))}))
return{comment:protectedComment,stylesheet:{type:"StyleSheet",loc:null,children:children}}}function compressChunk(ast,firstAtrulesAllowed,num,options){options.logger(`Compress block #${num}`,null,true)
let seed=1
if(ast.type==="StyleSheet"){ast.firstAtrulesAllowed=firstAtrulesAllowed
ast.id=seed++}walk$1(ast,{visit:"Atrule",enter(node){node.block!==null&&(node.block.id=seed++)}})
options.logger("init",ast)
clean(ast,options)
options.logger("clean",ast)
replace(ast)
options.logger("replace",ast)
options.restructuring&&restructure(ast,options)
return ast}function getCommentsOption(options){let comments="comments"in options?options.comments:"exclamation"
typeof comments==="boolean"?comments=!!comments&&"exclamation":comments!=="exclamation"&&comments!=="first-exclamation"&&(comments=false)
return comments}function getRestructureOption(options){if("restructure"in options)return options.restructure
return!("restructuring"in options)||options.restructuring}function wrapBlock(block){return(new List).appendData({type:"Rule",loc:null,prelude:{type:"SelectorList",loc:null,children:(new List).appendData({type:"Selector",loc:null,children:(new List).appendData({type:"TypeSelector",loc:null,name:"x"})})},block:block})}function compress$1(ast,options){ast=ast||{type:"StyleSheet",loc:null,children:new List}
options=options||{}
const compressOptions={logger:typeof options.logger==="function"?options.logger:function(){},restructuring:getRestructureOption(options),forceMediaMerge:Boolean(options.forceMediaMerge),usage:!!options.usage&&buildIndex(options.usage)}
const output=new List
let specialComments=getCommentsOption(options)
let firstAtrulesAllowed=true
let input
let chunk
let chunkNum=1
let chunkChildren
options.clone&&(ast=clone(ast))
if(ast.type==="StyleSheet"){input=ast.children
ast.children=output}else input=wrapBlock(ast)
do{chunk=readChunk(input,Boolean(specialComments))
compressChunk(chunk.stylesheet,firstAtrulesAllowed,chunkNum++,compressOptions)
chunkChildren=chunk.stylesheet.children
if(chunk.comment){output.isEmpty||output.insert(List.createItem({type:"Raw",value:"\n"}))
output.insert(List.createItem(chunk.comment))
chunkChildren.isEmpty||output.insert(List.createItem({type:"Raw",value:"\n"}))}if(firstAtrulesAllowed&&!chunkChildren.isEmpty){const lastRule=chunkChildren.last;(lastRule.type!=="Atrule"||lastRule.name!=="import"&&lastRule.name!=="charset")&&(firstAtrulesAllowed=false)}specialComments!=="exclamation"&&(specialComments=false)
output.appendList(chunkChildren)}while(!input.isEmpty)
return{ast:ast}}function encodeString(value){const stringApostrophe=encode$1(value,true)
const stringQuote=encode$1(value)
return stringApostrophe.length<stringQuote.length?stringApostrophe:stringQuote}const{lexer:lexer,tokenize:tokenize,parse:parse$1,generate:generate$1,walk:walk,find:find,findLast:findLast,findAll:findAll,fromPlainObject:fromPlainObject,toPlainObject:toPlainObject}=fork({node:{String:{generate(node){this.token(String$2,encodeString(node.value))}},Url:{generate(node){const encodedUrl=encode(node.value)
const string=encodeString(node.value)
this.token(Url$2,encodedUrl.length<=string.length+5?encodedUrl:"url("+string+")")}}}})
var syntax=Object.freeze({__proto__:null,compress:compress$1,find:find,findAll:findAll,findLast:findLast,fromPlainObject:fromPlainObject,generate:generate$1,lexer:lexer,parse:parse$1,specificity:specificity,toPlainObject:toPlainObject,tokenize:tokenize,walk:walk})
const{parse:parse,generate:generate,compress:compress}=syntax
function debugOutput(name,options,startTime,data){options.debug&&console.error(`## ${name} done in %d ms\n`,Date.now()-startTime)
return data}function createDefaultLogger(level){let lastDebug
return function logger(title,ast){let line=title
ast&&(line=`[${((Date.now()-lastDebug)/1000).toFixed(3)}s] ${line}`)
if(level>1&&ast){let css=generate(ast)
level===2&&css.length>256&&(css=css.substr(0,256)+"...")
line+=`\n  ${css}\n`}console.error(line)
lastDebug=Date.now()}}function buildCompressOptions(options){options={...options}
typeof options.logger!=="function"&&options.debug&&(options.logger=createDefaultLogger(options.debug))
return options}function runHandler(ast,options,handlers){Array.isArray(handlers)||(handlers=[handlers])
handlers.forEach((fn=>fn(ast,options)))}function minify(context,source,options){options=options||{}
const filename=options.filename||"<unknown>"
let result
const ast=debugOutput("parsing",options,Date.now(),parse(source,{context:context,filename:filename,positions:Boolean(options.sourceMap)}))
options.beforeCompress&&debugOutput("beforeCompress",options,Date.now(),runHandler(ast,options,options.beforeCompress))
const compressResult=debugOutput("compress",options,Date.now(),compress(ast,buildCompressOptions(options)))
options.afterCompress&&debugOutput("afterCompress",options,Date.now(),runHandler(compressResult,options,options.afterCompress))
result=options.sourceMap?debugOutput("generate(sourceMap: true)",options,Date.now(),(()=>{const tmp=generate(compressResult.ast,{sourceMap:true})
tmp.map._file=filename
tmp.map.setSourceContent(filename,source)
return tmp})()):debugOutput("generate",options,Date.now(),{css:generate(compressResult.ast),map:null})
return result}function minifyStylesheet(source,options){return minify("stylesheet",source,options)}function minifyBlock(source,options){return minify("declarationList",source,options)}const csstreeWalkSkip=walk$3.skip
const parseRule=(ruleNode,dynamic)=>{const declarations=[]
ruleNode.block.children.forEach((cssNode=>{cssNode.type==="Declaration"&&declarations.push({name:cssNode.property,value:generate$I(cssNode.value),important:cssNode.important===true})}))
const rules=[]
walk$3(ruleNode.prelude,(node=>{if(node.type==="Selector"){const newNode=clone$1(node)
let hasPseudoClasses=false
walk$3(newNode,((pseudoClassNode,item,list)=>{if(pseudoClassNode.type==="PseudoClassSelector"){hasPseudoClasses=true
list.remove(item)}}))
rules.push({specificity:specificity(node),dynamic:hasPseudoClasses||dynamic,selector:generate$I(newNode),declarations:declarations})}}))
return rules}
const parseStylesheet=(css,dynamic)=>{const rules=[]
const ast=parse$I(css,{parseValue:false,parseAtrulePrelude:false})
walk$3(ast,(cssNode=>{if(cssNode.type==="Rule"){rules.push(...parseRule(cssNode,dynamic||false))
return csstreeWalkSkip}if(cssNode.type==="Atrule"){if(["keyframes","-webkit-keyframes","-o-keyframes","-moz-keyframes"].includes(cssNode.name))return csstreeWalkSkip
walk$3(cssNode,(ruleNode=>{if(ruleNode.type==="Rule"){rules.push(...parseRule(ruleNode,dynamic||true))
return csstreeWalkSkip}}))
return csstreeWalkSkip}}))
return rules}
const parseStyleDeclarations=css=>{const declarations=[]
const ast=parse$I(css,{context:"declarationList",parseValue:false})
walk$3(ast,(cssNode=>{cssNode.type==="Declaration"&&declarations.push({name:cssNode.property,value:generate$I(cssNode.value),important:cssNode.important===true})}))
return declarations}
const computeOwnStyle=(stylesheet,node,parents)=>{const computedStyle={}
const importantStyles=new Map
for(const[name,value]of Object.entries(node.attributes))if(attrsGroups.presentation.has(name)){computedStyle[name]={type:"static",inherited:false,value:value}
importantStyles.set(name,false)}for(const{selector:selector,declarations:declarations,dynamic:dynamic}of stylesheet.rules)if(matches(node,selector,parents))for(const{name:name,value:value,important:important}of declarations){const computed=computedStyle[name]
if(computed&&computed.type==="dynamic")continue
if(dynamic){computedStyle[name]={type:"dynamic",inherited:false}
continue}if(computed==null||important===true||importantStyles.get(name)===false){computedStyle[name]={type:"static",inherited:false,value:value}
importantStyles.set(name,important)}}const styleDeclarations=node.attributes.style==null?[]:parseStyleDeclarations(node.attributes.style)
for(const{name:name,value:value,important:important}of styleDeclarations){const computed=computedStyle[name]
if(computed&&computed.type==="dynamic")continue
if(computed==null||important===true||importantStyles.get(name)===false){computedStyle[name]={type:"static",inherited:false,value:value}
importantStyles.set(name,important)}}return computedStyle}
const compareSpecificity=(a,b)=>{for(let i=0;i<4;i+=1){if(a[i]<b[i])return-1
if(a[i]>b[i])return 1}return 0}
const collectStylesheet=root=>{const rules=[]
const parents=new Map
visit(root,{element:{enter:(node,parentNode)=>{parents.set(node,parentNode)
if(node.name!=="style")return
if(node.attributes.type==null||node.attributes.type===""||node.attributes.type==="text/css"){const dynamic=node.attributes.media!=null&&node.attributes.media!=="all"
for(const child of node.children)child.type!=="text"&&child.type!=="cdata"||rules.push(...parseStylesheet(child.value,dynamic))}}}})
rules.sort(((a,b)=>compareSpecificity(a.specificity,b.specificity)))
return{rules:rules,parents:parents}}
const computeStyle=(stylesheet,node)=>{const{parents:parents}=stylesheet
const computedStyles=computeOwnStyle(stylesheet,node,parents)
let parent=parents.get(node)
while(parent!=null&&parent.type!=="root"){const inheritedStyles=computeOwnStyle(stylesheet,parent,parents)
for(const[name,computed]of Object.entries(inheritedStyles))computedStyles[name]==null&&inheritableAttrs.has(name)&&!presentationNonInheritableGroupAttrs.has(name)&&(computedStyles[name]={...computed,inherited:true})
parent=parents.get(parent)}return computedStyles}
const includesAttrSelector=(selector,name,value=null,traversed=false)=>{const selectors=parse$1w(typeof selector==="string"?selector:generate$I(selector.data))
for(const subselector of selectors){const hasAttrSelector=subselector.some(((segment,index)=>{if(traversed){if(index===subselector.length-1)return false
const isNextTraversal=isTraversal$1(subselector[index+1])
if(!isNextTraversal)return false}if(segment.type!=="attribute"||segment.name!==name)return false
return value==null||segment.value===value}))
if(hasAttrSelector)return true}return false}
const name$N="removeDeprecatedAttrs"
const description$N="removes deprecated attributes"
function extractAttributesInStylesheet(stylesheet){const attributesInStylesheet=new Set
stylesheet.rules.forEach((rule=>{const selectors=parse$1w(rule.selector)
selectors.forEach((subselector=>{subselector.forEach((segment=>{if(segment.type!=="attribute")return
attributesInStylesheet.add(segment.name)}))}))}))
return attributesInStylesheet}function processAttributes(node,deprecatedAttrs,params,attributesInStylesheet){if(!deprecatedAttrs)return
deprecatedAttrs.safe&&deprecatedAttrs.safe.forEach((name=>{if(attributesInStylesheet.has(name))return
delete node.attributes[name]}))
params.removeUnsafe&&deprecatedAttrs.unsafe&&deprecatedAttrs.unsafe.forEach((name=>{if(attributesInStylesheet.has(name))return
delete node.attributes[name]}))}function fn$N(root,params){const stylesheet=collectStylesheet(root)
const attributesInStylesheet=extractAttributesInStylesheet(stylesheet)
return{element:{enter:node=>{const elemConfig=elems[node.name]
if(!elemConfig)return
elemConfig.attrsGroups.has("core")&&node.attributes["xml:lang"]&&!attributesInStylesheet.has("xml:lang")&&node.attributes["lang"]&&delete node.attributes["xml:lang"]
elemConfig.attrsGroups.forEach((attrsGroup=>{processAttributes(node,attrsGroupsDeprecated[attrsGroup],params,attributesInStylesheet)}))
processAttributes(node,elemConfig.deprecated,params,attributesInStylesheet)}}}}var removeDeprecatedAttrs=Object.freeze({__proto__:null,description:description$N,fn:fn$N,name:name$N})
const name$M="removeMetadata"
const description$M="removes <metadata>"
const fn$M=()=>({element:{enter:(node,parentNode)=>{node.name==="metadata"&&detachNodeFromParent(node,parentNode)}}})
var removeMetadata=Object.freeze({__proto__:null,description:description$M,fn:fn$M,name:name$M})
const name$L="removeEditorsNSData"
const description$L="removes editors namespaces, elements and attributes"
const fn$L=(_root,params)=>{let namespaces=[...editorNamespaces]
Array.isArray(params.additionalNamespaces)&&(namespaces=[...editorNamespaces,...params.additionalNamespaces])
const prefixes=[]
return{element:{enter:(node,parentNode)=>{if(node.name==="svg")for(const[name,value]of Object.entries(node.attributes))if(name.startsWith("xmlns:")&&namespaces.includes(value)){prefixes.push(name.slice(6))
delete node.attributes[name]}for(const name of Object.keys(node.attributes))if(name.includes(":")){const[prefix]=name.split(":")
prefixes.includes(prefix)&&delete node.attributes[name]}if(node.name.includes(":")){const[prefix]=node.name.split(":")
prefixes.includes(prefix)&&detachNodeFromParent(node,parentNode)}}}}}
var removeEditorsNSData=Object.freeze({__proto__:null,description:description$L,fn:fn$L,name:name$L})
const name$K="cleanupAttrs"
const description$K="cleanups attributes from newlines, trailing and repeating spaces"
const regNewlinesNeedSpace=/(\S)\r?\n(\S)/g
const regNewlines=/\r?\n/g
const regSpaces=/\s{2,}/g
const fn$K=(root,params)=>{const{newlines:newlines=true,trim:trim=true,spaces:spaces=true}=params
return{element:{enter:node=>{for(const name of Object.keys(node.attributes)){if(newlines){node.attributes[name]=node.attributes[name].replace(regNewlinesNeedSpace,((match,p1,p2)=>p1+" "+p2))
node.attributes[name]=node.attributes[name].replace(regNewlines,"")}trim&&(node.attributes[name]=node.attributes[name].trim())
spaces&&(node.attributes[name]=node.attributes[name].replace(regSpaces," "))}}}}}
var cleanupAttrs=Object.freeze({__proto__:null,description:description$K,fn:fn$K,name:name$K})
const name$J="mergeStyles"
const description$J="merge multiple style elements into one"
const fn$J=()=>{let firstStyleElement=null
let collectedStyles=""
let styleContentType="text"
return{element:{enter:(node,parentNode)=>{if(node.name==="foreignObject")return visitSkip
if(node.name!=="style")return
if(node.attributes.type!=null&&node.attributes.type!==""&&node.attributes.type!=="text/css")return
let css=""
for(const child of node.children){child.type==="text"&&(css+=child.value)
if(child.type==="cdata"){styleContentType="cdata"
css+=child.value}}if(css.trim().length===0){detachNodeFromParent(node,parentNode)
return}if(node.attributes.media==null)collectedStyles+=css
else{collectedStyles+=`@media ${node.attributes.media}{${css}}`
delete node.attributes.media}if(firstStyleElement==null)firstStyleElement=node
else{detachNodeFromParent(node,parentNode)
const child={type:styleContentType,value:collectedStyles}
firstStyleElement.children=[child]}}}}}
var mergeStyles=Object.freeze({__proto__:null,description:description$J,fn:fn$J,name:name$J})
const name$I="inlineStyles"
const description$I="inline styles (additional options)"
const preservedPseudos=[...pseudoClasses.functional,...pseudoClasses.treeStructural]
const fn$I=(root,params)=>{const{onlyMatchedOnce:onlyMatchedOnce=true,removeMatchedSelectors:removeMatchedSelectors=true,useMqs:useMqs=["","screen"],usePseudos:usePseudos=[""]}=params
const styles=[]
const selectors=[]
return{element:{enter:(node,parentNode)=>{if(node.name==="foreignObject")return visitSkip
if(node.name!=="style"||node.children.length===0)return
if(node.attributes.type!=null&&node.attributes.type!==""&&node.attributes.type!=="text/css")return
const cssText=node.children.filter((child=>child.type==="text"||child.type==="cdata")).map((child=>child.value)).join("")
let cssAst=null
try{cssAst=parse$I(cssText,{parseValue:false,parseCustomProperty:false})}catch{return}cssAst.type==="StyleSheet"&&styles.push({node:node,parentNode:parentNode,cssAst:cssAst})
walk$3(cssAst,{visit:"Rule",enter(node){const atrule=this.atrule
let mediaQuery=""
if(atrule!=null){mediaQuery=atrule.name
atrule.prelude!=null&&(mediaQuery+=` ${generate$I(atrule.prelude)}`)}if(!useMqs.includes(mediaQuery))return
node.prelude.type==="SelectorList"&&node.prelude.children.forEach(((childNode,item)=>{if(childNode.type==="Selector"){const pseudos=[]
childNode.children.forEach(((grandchildNode,grandchildItem,grandchildList)=>{const isPseudo=grandchildNode.type==="PseudoClassSelector"||grandchildNode.type==="PseudoElementSelector"
isPseudo&&!preservedPseudos.includes(grandchildNode.name)&&pseudos.push({item:grandchildItem,list:grandchildList})}))
const pseudoSelectors=generate$I({type:"Selector",children:(new List$1).fromArray(pseudos.map((pseudo=>pseudo.item.data)))})
if(usePseudos.includes(pseudoSelectors))for(const pseudo of pseudos)pseudo.list.remove(pseudo.item)
selectors.push({node:childNode,rule:node,item:item})}}))}})}},root:{exit:()=>{if(styles.length===0)return
const sortedSelectors=selectors.slice().sort(((a,b)=>{const aSpecificity=specificity(a.item.data)
const bSpecificity=specificity(b.item.data)
return compareSpecificity(aSpecificity,bSpecificity)})).reverse()
for(const selector of sortedSelectors){const selectorText=generate$I(selector.item.data)
const matchedElements=[]
try{for(const node of querySelectorAll(root,selectorText))node.type==="element"&&matchedElements.push(node)}catch{continue}if(matchedElements.length===0)continue
if(onlyMatchedOnce&&matchedElements.length>1)continue
for(const selectedEl of matchedElements){const styleDeclarationList=parse$I(selectedEl.attributes.style??"",{context:"declarationList",parseValue:false})
if(styleDeclarationList.type!=="DeclarationList")continue
const styleDeclarationItems=new Map
let firstListItem
walk$3(styleDeclarationList,{visit:"Declaration",enter(node,item){firstListItem==null&&(firstListItem=item)
styleDeclarationItems.set(node.property.toLowerCase(),item)}})
walk$3(selector.rule,{visit:"Declaration",enter(ruleDeclaration){const property=ruleDeclaration.property
attrsGroups.presentation.has(property)&&!selectors.some((selector=>includesAttrSelector(selector.item,property)))&&delete selectedEl.attributes[property]
const matchedItem=styleDeclarationItems.get(property)
const ruleDeclarationItem=styleDeclarationList.children.createItem(ruleDeclaration)
if(matchedItem==null)styleDeclarationList.children.insert(ruleDeclarationItem,firstListItem)
else if(matchedItem.data.important!==true&&ruleDeclaration.important===true){styleDeclarationList.children.replace(matchedItem,ruleDeclarationItem)
styleDeclarationItems.set(property,ruleDeclarationItem)}}})
const newStyles=generate$I(styleDeclarationList)
newStyles.length!==0&&(selectedEl.attributes.style=newStyles)}removeMatchedSelectors&&matchedElements.length!==0&&selector.rule.prelude.type==="SelectorList"&&selector.rule.prelude.children.remove(selector.item)
selector.matchedElements=matchedElements}if(!removeMatchedSelectors)return
for(const selector of sortedSelectors){if(selector.matchedElements==null)continue
if(onlyMatchedOnce&&selector.matchedElements.length>1)continue
for(const selectedEl of selector.matchedElements){const classList=new Set(selectedEl.attributes.class==null?null:selectedEl.attributes.class.split(" "))
for(const child of selector.node.children)child.type!=="ClassSelector"||selectors.some((selector=>includesAttrSelector(selector.item,"class",child.name,true)))||classList.delete(child.name)
classList.size===0?delete selectedEl.attributes.class:selectedEl.attributes.class=Array.from(classList).join(" ")
const firstSubSelector=selector.node.children.first
firstSubSelector?.type!=="IdSelector"||selectedEl.attributes.id!==firstSubSelector.name||selectors.some((selector=>includesAttrSelector(selector.item,"id",firstSubSelector.name,true)))||delete selectedEl.attributes.id}}for(const style of styles){walk$3(style.cssAst,{visit:"Rule",enter:function(node,item,list){node.type==="Rule"&&node.prelude.type==="SelectorList"&&node.prelude.children.isEmpty&&list.remove(item)}})
if(style.cssAst.children.isEmpty)detachNodeFromParent(style.node,style.parentNode)
else{const firstChild=style.node.children[0]
firstChild.type!=="text"&&firstChild.type!=="cdata"||(firstChild.value=generate$I(style.cssAst))}}}}}}
var inlineStyles=Object.freeze({__proto__:null,description:description$I,fn:fn$I,name:name$I})
const regReferencesUrl=/\burl\((["'])?#(.+?)\1\)/g
const regReferencesHref=/^#(.+?)$/
const regReferencesBegin=/(\w+)\.[a-zA-Z]/
const encodeSVGDatauri=(str,type)=>{let prefix="data:image/svg+xml"
if(type&&type!=="base64")type==="enc"?str=prefix+","+encodeURIComponent(str):type==="unenc"&&(str=prefix+","+str)
else{prefix+=";base64,"
str=prefix+Buffer.from(str).toString("base64")}return str}
const cleanupOutData=(data,params,command)=>{let str=""
let delimiter
let prev
data.forEach(((item,i)=>{delimiter=" "
i==0&&(delimiter="")
params.noSpaceAfterFlags&&command=="a"
const itemStr=params.leadingZero?removeLeadingZero(item):item.toString()
params.negativeExtraSpace&&delimiter!=""&&(item<0||itemStr.charAt(0)==="."&&prev%1!==0)&&(delimiter="")
prev=item
str+=delimiter+itemStr}))
return str}
const removeLeadingZero=value=>{const strValue=value.toString()
if(0<value&&value<1&&strValue.startsWith("0"))return strValue.slice(1)
if(-1<value&&value<0&&strValue[1]==="0")return strValue[0]+strValue.slice(2)
return strValue}
const hasScripts=node=>{if(node.name==="script"&&node.children.length!==0)return true
if(node.name==="a"){const hasJsLinks=Object.entries(node.attributes).some((([attrKey,attrValue])=>(attrKey==="href"||attrKey.endsWith(":href"))&&attrValue!=null&&attrValue.trimStart().startsWith("javascript:")))
if(hasJsLinks)return true}const eventAttrs=[...attrsGroups.animationEvent,...attrsGroups.documentEvent,...attrsGroups.documentElementEvent,...attrsGroups.globalEvent,...attrsGroups.graphicalEvent]
return eventAttrs.some((attr=>node.attributes[attr]!=null))}
const includesUrlReference=body=>new RegExp(regReferencesUrl).test(body)
const findReferences=(attribute,value)=>{const results=[]
if(referencesProps.has(attribute)){const matches=value.matchAll(regReferencesUrl)
for(const match of matches)results.push(match[2])}if(attribute==="href"||attribute.endsWith(":href")){const match=regReferencesHref.exec(value)
match!=null&&results.push(match[1])}if(attribute==="begin"){const match=regReferencesBegin.exec(value)
match!=null&&results.push(match[1])}return results.map((body=>decodeURI(body)))}
const toFixed=(num,precision)=>{const pow=10**precision
return Math.round(num*pow)/pow}
const name$H="minifyStyles"
const description$H="minifies styles and removes unused styles"
const fn$H=(_root,{usage:usage,...params})=>{const styleElements=new Map
const elementsWithStyleAttributes=[]
const tagsUsage=new Set
const idsUsage=new Set
const classesUsage=new Set
let enableTagsUsage=true
let enableIdsUsage=true
let enableClassesUsage=true
let forceUsageDeoptimized=false
if(typeof usage==="boolean"){enableTagsUsage=usage
enableIdsUsage=usage
enableClassesUsage=usage}else if(usage){enableTagsUsage=usage.tags==null||usage.tags
enableIdsUsage=usage.ids==null||usage.ids
enableClassesUsage=usage.classes==null||usage.classes
forceUsageDeoptimized=usage.force!=null&&usage.force}let deoptimized=false
return{element:{enter:(node,parentNode)=>{hasScripts(node)&&(deoptimized=true)
tagsUsage.add(node.name)
node.attributes.id!=null&&idsUsage.add(node.attributes.id)
if(node.attributes.class!=null)for(const className of node.attributes.class.split(/\s+/))classesUsage.add(className)
node.name==="style"&&node.children.length!==0?styleElements.set(node,parentNode):node.attributes.style!=null&&elementsWithStyleAttributes.push(node)}},root:{exit:()=>{const cssoUsage={}
if(!deoptimized||forceUsageDeoptimized){enableTagsUsage&&(cssoUsage.tags=Array.from(tagsUsage))
enableIdsUsage&&(cssoUsage.ids=Array.from(idsUsage))
enableClassesUsage&&(cssoUsage.classes=Array.from(classesUsage))}for(const[styleNode,styleNodeParent]of styleElements.entries())if(styleNode.children[0].type==="text"||styleNode.children[0].type==="cdata"){const cssText=styleNode.children[0].value
const minified=minifyStylesheet(cssText,{...params,usage:cssoUsage}).css
if(minified.length===0){detachNodeFromParent(styleNode,styleNodeParent)
continue}if(cssText.indexOf(">")>=0||cssText.indexOf("<")>=0){styleNode.children[0].type="cdata"
styleNode.children[0].value=minified}else{styleNode.children[0].type="text"
styleNode.children[0].value=minified}}for(const node of elementsWithStyleAttributes){const elemStyle=node.attributes.style
node.attributes.style=minifyBlock(elemStyle,{...params}).css}}}}}
var minifyStyles=Object.freeze({__proto__:null,description:description$H,fn:fn$H,name:name$H})
const name$G="cleanupIds"
const description$G="removes unused IDs and minifies used"
const generateIdChars=["a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"]
const maxIdIndex=generateIdChars.length-1
const hasStringPrefix=(string,prefixes)=>{for(const prefix of prefixes)if(string.startsWith(prefix))return true
return false}
const generateId=currentId=>{if(currentId==null)return[0]
currentId[currentId.length-1]+=1
for(let i=currentId.length-1;i>0;i--)if(currentId[i]>maxIdIndex){currentId[i]=0
currentId[i-1]!==void 0&&currentId[i-1]++}if(currentId[0]>maxIdIndex){currentId[0]=0
currentId.unshift(0)}return currentId}
const getIdString=arr=>arr.map((i=>generateIdChars[i])).join("")
const fn$G=(_root,params)=>{const{remove:remove=true,minify:minify=true,preserve:preserve=[],preservePrefixes:preservePrefixes=[],force:force=false}=params
const preserveIds=new Set(Array.isArray(preserve)?preserve:preserve?[preserve]:[])
const preserveIdPrefixes=Array.isArray(preservePrefixes)?preservePrefixes:preservePrefixes?[preservePrefixes]:[]
const nodeById=new Map
const referencesById=new Map
let deoptimized=false
return{element:{enter:node=>{if(!force){if(node.name==="style"&&node.children.length!==0||hasScripts(node)){deoptimized=true
return}if(node.name==="svg"){let hasDefsOnly=true
for(const child of node.children)if(child.type!=="element"||child.name!=="defs"){hasDefsOnly=false
break}if(hasDefsOnly)return visitSkip}}for(const[name,value]of Object.entries(node.attributes))if(name==="id"){const id=value
nodeById.has(id)?delete node.attributes.id:nodeById.set(id,node)}else{const ids=findReferences(name,value)
for(const id of ids){let refs=referencesById.get(id)
if(refs==null){refs=[]
referencesById.set(id,refs)}refs.push({element:node,name:name})}}}},root:{exit:()=>{if(deoptimized)return
const isIdPreserved=id=>preserveIds.has(id)||hasStringPrefix(id,preserveIdPrefixes)
let currentId=null
for(const[id,refs]of referencesById){const node=nodeById.get(id)
if(node!=null){if(minify&&isIdPreserved(id)===false){let currentIdString
do{currentId=generateId(currentId)
currentIdString=getIdString(currentId)}while(isIdPreserved(currentIdString)||referencesById.has(currentIdString)&&nodeById.get(currentIdString)==null)
node.attributes.id=currentIdString
for(const{element:element,name:name}of refs){const value=element.attributes[name]
value.includes("#")?element.attributes[name]=value.replace(`#${encodeURI(id)}`,`#${currentIdString}`).replace(`#${id}`,`#${currentIdString}`):element.attributes[name]=value.replace(`${id}.`,`${currentIdString}.`)}}nodeById.delete(id)}}if(remove)for(const[id,node]of nodeById)isIdPreserved(id)===false&&delete node.attributes.id}}}}
var cleanupIds=Object.freeze({__proto__:null,description:description$G,fn:fn$G,name:name$G})
const name$F="removeUselessDefs"
const description$F="removes elements in <defs> without id"
const fn$F=()=>({element:{enter:(node,parentNode)=>{if(node.name==="defs"||elemsGroups.nonRendering.has(node.name)&&node.attributes.id==null){const usefulNodes=[]
collectUsefulNodes(node,usefulNodes)
usefulNodes.length===0&&detachNodeFromParent(node,parentNode)
node.children=usefulNodes}}}})
const collectUsefulNodes=(node,usefulNodes)=>{for(const child of node.children)child.type==="element"&&(child.attributes.id!=null||child.name==="style"?usefulNodes.push(child):collectUsefulNodes(child,usefulNodes))}
var removeUselessDefs=Object.freeze({__proto__:null,description:description$F,fn:fn$F,name:name$F})
const name$E="cleanupNumericValues"
const description$E='rounds numeric values to the fixed precision, removes default "px" units'
const regNumericValues$3=/^([-+]?\d*\.?\d+([eE][-+]?\d+)?)(px|pt|pc|mm|cm|m|in|ft|em|ex|%)?$/
const absoluteLengths$1={cm:96/2.54,mm:96/25.4,in:96,pt:4/3,pc:16,px:1}
const fn$E=(_root,params)=>{const{floatPrecision:floatPrecision=3,leadingZero:leadingZero=true,defaultPx:defaultPx=true,convertToPx:convertToPx=true}=params
return{element:{enter:node=>{if(node.attributes.viewBox!=null){const nums=node.attributes.viewBox.trim().split(/(?:\s,?|,)\s*/g)
node.attributes.viewBox=nums.map((value=>{const num=Number(value)
return Number.isNaN(num)?value:Number(num.toFixed(floatPrecision))})).join(" ")}for(const[name,value]of Object.entries(node.attributes)){if(name==="version")continue
const match=regNumericValues$3.exec(value)
if(match){let num=Number(Number(match[1]).toFixed(floatPrecision))
const matchedUnit=match[3]||""
let units=matchedUnit
if(convertToPx&&units!==""&&units in absoluteLengths$1){const pxNum=Number((absoluteLengths$1[units]*Number(match[1])).toFixed(floatPrecision))
if(pxNum.toString().length<match[0].length){num=pxNum
units="px"}}let str
str=leadingZero?removeLeadingZero(num):num.toString()
defaultPx&&units==="px"&&(units="")
node.attributes[name]=str+units}}}}}}
var cleanupNumericValues=Object.freeze({__proto__:null,description:description$E,fn:fn$E,name:name$E})
const name$D="convertColors"
const description$D="converts colors: rgb() to #rrggbb and #rrggbb to #rgb"
const rNumber="([+-]?(?:\\d*\\.\\d+|\\d+\\.?)%?)"
const rComma="(?:\\s*,\\s*|\\s+)"
const regRGB=new RegExp("^rgb\\(\\s*"+rNumber+rComma+rNumber+rComma+rNumber+"\\s*\\)$")
const regHEX=/^#(([a-fA-F0-9])\2){3}$/
const convertRgbToHex=([r,g,b])=>{const hexNumber=(256+r<<8|g)<<8|b
return"#"+hexNumber.toString(16).slice(1).toUpperCase()}
const fn$D=(_root,params)=>{const{currentColor:currentColor=false,names2hex:names2hex=true,rgb2hex:rgb2hex=true,convertCase:convertCase="lower",shorthex:shorthex=true,shortname:shortname=true}=params
let maskCounter=0
return{element:{enter:node=>{node.name==="mask"&&maskCounter++
for(const[name,value]of Object.entries(node.attributes))if(colorsProps.has(name)){let val=value
if(currentColor&&maskCounter===0){let matched
matched=typeof currentColor==="string"?val===currentColor:currentColor instanceof RegExp?currentColor.exec(val)!=null:val!=="none"
matched&&(val="currentColor")}if(names2hex){const colorName=val.toLowerCase()
colorsNames[colorName]!=null&&(val=colorsNames[colorName])}if(rgb2hex){const match=val.match(regRGB)
if(match!=null){const nums=match.slice(1,4).map((m=>{let n
n=m.indexOf("%")>-1?Math.round(parseFloat(m)*2.55):Number(m)
return Math.max(0,Math.min(n,255))}))
val=convertRgbToHex(nums)}}convertCase&&!includesUrlReference(val)&&val!=="currentColor"&&(convertCase==="lower"?val=val.toLowerCase():convertCase==="upper"&&(val=val.toUpperCase()))
if(shorthex){const match=regHEX.exec(val)
match!=null&&(val="#"+match[0][1]+match[0][3]+match[0][5])}if(shortname){const colorName=val.toLowerCase()
colorsShortNames[colorName]!=null&&(val=colorsShortNames[colorName])}node.attributes[name]=val}},exit:node=>{node.name==="mask"&&maskCounter--}}}}
var convertColors=Object.freeze({__proto__:null,description:description$D,fn:fn$D,name:name$D})
const name$C="removeUnknownsAndDefaults"
const description$C="removes unknown elements content and attributes, removes attrs with default values"
const allowedChildrenPerElement=new Map
const allowedAttributesPerElement=new Map
const attributesDefaultsPerElement=new Map
for(const[name,config]of Object.entries(elems)){const allowedChildren=new Set
if(config.content)for(const elementName of config.content)allowedChildren.add(elementName)
if(config.contentGroups)for(const contentGroupName of config.contentGroups){const elemsGroup=elemsGroups[contentGroupName]
if(elemsGroup)for(const elementName of elemsGroup)allowedChildren.add(elementName)}const allowedAttributes=new Set
if(config.attrs)for(const attrName of config.attrs)allowedAttributes.add(attrName)
const attributesDefaults=new Map
if(config.defaults)for(const[attrName,defaultValue]of Object.entries(config.defaults))attributesDefaults.set(attrName,defaultValue)
for(const attrsGroupName of config.attrsGroups){const attrsGroup=attrsGroups[attrsGroupName]
if(attrsGroup)for(const attrName of attrsGroup)allowedAttributes.add(attrName)
const groupDefaults=attrsGroupsDefaults[attrsGroupName]
if(groupDefaults)for(const[attrName,defaultValue]of Object.entries(groupDefaults))attributesDefaults.set(attrName,defaultValue)}allowedChildrenPerElement.set(name,allowedChildren)
allowedAttributesPerElement.set(name,allowedAttributes)
attributesDefaultsPerElement.set(name,attributesDefaults)}const fn$C=(root,params)=>{const{unknownContent:unknownContent=true,unknownAttrs:unknownAttrs=true,defaultAttrs:defaultAttrs=true,defaultMarkupDeclarations:defaultMarkupDeclarations=true,uselessOverrides:uselessOverrides=true,keepDataAttrs:keepDataAttrs=true,keepAriaAttrs:keepAriaAttrs=true,keepRoleAttr:keepRoleAttr=false}=params
const stylesheet=collectStylesheet(root)
return{instruction:{enter:node=>{defaultMarkupDeclarations&&(node.value=node.value.replace(/\s*standalone\s*=\s*(["'])no\1/,""))}},element:{enter:(node,parentNode)=>{if(node.name.includes(":"))return
if(node.name==="foreignObject")return visitSkip
if(unknownContent&&parentNode.type==="element"){const allowedChildren=allowedChildrenPerElement.get(parentNode.name)
if(allowedChildren==null||allowedChildren.size===0){if(allowedChildrenPerElement.get(node.name)==null){detachNodeFromParent(node,parentNode)
return}}else if(allowedChildren.has(node.name)===false){detachNodeFromParent(node,parentNode)
return}}const allowedAttributes=allowedAttributesPerElement.get(node.name)
const attributesDefaults=attributesDefaultsPerElement.get(node.name)
const computedParentStyle=parentNode.type==="element"?computeStyle(stylesheet,parentNode):null
for(const[name,value]of Object.entries(node.attributes)){if(keepDataAttrs&&name.startsWith("data-"))continue
if(keepAriaAttrs&&name.startsWith("aria-"))continue
if(keepRoleAttr&&name==="role")continue
if(name==="xmlns")continue
if(name.includes(":")){const[prefix]=name.split(":")
if(prefix!=="xml"&&prefix!=="xlink")continue}unknownAttrs&&allowedAttributes&&allowedAttributes.has(name)===false&&delete node.attributes[name]
defaultAttrs&&node.attributes.id==null&&attributesDefaults&&attributesDefaults.get(name)===value&&computedParentStyle?.[name]==null&&delete node.attributes[name]
if(uselessOverrides&&node.attributes.id==null){const style=computedParentStyle?.[name]
presentationNonInheritableGroupAttrs.has(name)===false&&style!=null&&style.type==="static"&&style.value===value&&delete node.attributes[name]}}}}}}
var removeUnknownsAndDefaults=Object.freeze({__proto__:null,description:description$C,fn:fn$C,name:name$C})
const name$B="removeNonInheritableGroupAttrs"
const description$B="removes non-inheritable group's presentational attributes"
const fn$B=()=>({element:{enter:node=>{if(node.name==="g")for(const name of Object.keys(node.attributes))!attrsGroups.presentation.has(name)||inheritableAttrs.has(name)||presentationNonInheritableGroupAttrs.has(name)||delete node.attributes[name]}}})
var removeNonInheritableGroupAttrs=Object.freeze({__proto__:null,description:description$B,fn:fn$B,name:name$B})
const name$A="removeUselessStrokeAndFill"
const description$A="removes useless stroke and fill attributes"
const fn$A=(root,params)=>{const{stroke:removeStroke=true,fill:removeFill=true,removeNone:removeNone=false}=params
let hasStyleOrScript=false
visit(root,{element:{enter:node=>{(node.name==="style"||hasScripts(node))&&(hasStyleOrScript=true)}}})
if(hasStyleOrScript)return null
const stylesheet=collectStylesheet(root)
return{element:{enter:(node,parentNode)=>{if(node.attributes.id!=null)return visitSkip
if(!elemsGroups.shape.has(node.name))return
const computedStyle=computeStyle(stylesheet,node)
const stroke=computedStyle.stroke
const strokeOpacity=computedStyle["stroke-opacity"]
const strokeWidth=computedStyle["stroke-width"]
const markerEnd=computedStyle["marker-end"]
const fill=computedStyle.fill
const fillOpacity=computedStyle["fill-opacity"]
const computedParentStyle=parentNode.type==="element"?computeStyle(stylesheet,parentNode):null
const parentStroke=computedParentStyle==null?null:computedParentStyle.stroke
if(removeStroke&&(stroke==null||stroke.type==="static"&&stroke.value=="none"||strokeOpacity!=null&&strokeOpacity.type==="static"&&strokeOpacity.value==="0"||strokeWidth!=null&&strokeWidth.type==="static"&&strokeWidth.value==="0")&&(strokeWidth!=null&&strokeWidth.type==="static"&&strokeWidth.value==="0"||markerEnd==null)){for(const name of Object.keys(node.attributes))name.startsWith("stroke")&&delete node.attributes[name]
parentStroke!=null&&parentStroke.type==="static"&&parentStroke.value!=="none"&&(node.attributes.stroke="none")}if(removeFill&&(fill!=null&&fill.type==="static"&&fill.value==="none"||fillOpacity!=null&&fillOpacity.type==="static"&&fillOpacity.value==="0")){for(const name of Object.keys(node.attributes))name.startsWith("fill-")&&delete node.attributes[name];(fill==null||fill.type==="static"&&fill.value!=="none")&&(node.attributes.fill="none")}removeNone&&(stroke!=null&&node.attributes.stroke!=="none"||(fill==null||fill.type!=="static"||fill.value!=="none")&&node.attributes.fill!=="none"||detachNodeFromParent(node,parentNode))}}}}
var removeUselessStrokeAndFill=Object.freeze({__proto__:null,description:description$A,fn:fn$A,name:name$A})
const name$z="cleanupEnableBackground"
const description$z="remove or cleanup enable-background attribute when possible"
const regEnableBackground=/^new\s0\s0\s([-+]?\d*\.?\d+([eE][-+]?\d+)?)\s([-+]?\d*\.?\d+([eE][-+]?\d+)?)$/
const fn$z=root=>{let hasFilter=false
visit(root,{element:{enter:node=>{node.name==="filter"&&(hasFilter=true)}}})
return{element:{enter:node=>{let newStyle=null
let enableBackgroundDeclaration=null
if(node.attributes.style!=null){newStyle=parse$I(node.attributes.style,{context:"declarationList"})
if(newStyle.type==="DeclarationList"){const enableBackgroundDeclarations=[]
walk$3(newStyle,((node,nodeItem)=>{if(node.type==="Declaration"&&node.property==="enable-background"){enableBackgroundDeclarations.push(nodeItem)
enableBackgroundDeclaration=nodeItem}}))
for(let i=0;i<enableBackgroundDeclarations.length-1;i++)newStyle.children.remove(enableBackgroundDeclarations[i])}}if(!hasFilter){delete node.attributes["enable-background"]
if(newStyle?.type==="DeclarationList"){enableBackgroundDeclaration&&newStyle.children.remove(enableBackgroundDeclaration)
newStyle.children.isEmpty?delete node.attributes.style:node.attributes.style=generate$I(newStyle)}return}const hasDimensions=node.attributes.width!=null&&node.attributes.height!=null
if((node.name==="svg"||node.name==="mask"||node.name==="pattern")&&hasDimensions){const attrValue=node.attributes["enable-background"]
const attrCleaned=cleanupValue(attrValue,node.name,node.attributes.width,node.attributes.height)
attrCleaned?node.attributes["enable-background"]=attrCleaned:delete node.attributes["enable-background"]
if(newStyle?.type==="DeclarationList"&&enableBackgroundDeclaration){const styleValue=generate$I(enableBackgroundDeclaration.data.value)
const styleCleaned=cleanupValue(styleValue,node.name,node.attributes.width,node.attributes.height)
styleCleaned?enableBackgroundDeclaration.data.value={type:"Raw",value:styleCleaned}:newStyle.children.remove(enableBackgroundDeclaration)}}newStyle?.type==="DeclarationList"&&(newStyle.children.isEmpty?delete node.attributes.style:node.attributes.style=generate$I(newStyle))}}}}
const cleanupValue=(value,nodeName,width,height)=>{const match=regEnableBackground.exec(value)
if(match!=null&&width===match[1]&&height===match[3])return nodeName==="svg"?void 0:"new"
return value}
var cleanupEnableBackground=Object.freeze({__proto__:null,description:description$z,fn:fn$z,name:name$z})
const argsCountPerCommand={M:2,m:2,Z:0,z:0,L:2,l:2,H:1,h:1,V:1,v:1,C:6,c:6,S:4,s:4,Q:4,q:4,T:2,t:2,A:7,a:7}
const isCommand=c=>c in argsCountPerCommand
const isWhiteSpace=c=>c===" "||c==="\t"||c==="\r"||c==="\n"
const isDigit=c=>{const codePoint=c.codePointAt(0)
if(codePoint==null)return false
return 48<=codePoint&&codePoint<=57}
const readNumber=(string,cursor)=>{let i=cursor
let value=""
let state="none"
for(;i<string.length;i+=1){const c=string[i]
if(c==="+"||c==="-"){if(state==="none"){state="sign"
value+=c
continue}if(state==="e"){state="exponent_sign"
value+=c
continue}}if(isDigit(c)){if(state==="none"||state==="sign"||state==="whole"){state="whole"
value+=c
continue}if(state==="decimal_point"||state==="decimal"){state="decimal"
value+=c
continue}if(state==="e"||state==="exponent_sign"||state==="exponent"){state="exponent"
value+=c
continue}}if(c==="."&&(state==="none"||state==="sign"||state==="whole")){state="decimal_point"
value+=c
continue}if((c==="E"||c=="e")&&(state==="whole"||state==="decimal_point"||state==="decimal")){state="e"
value+=c
continue}break}const number=Number.parseFloat(value)
return Number.isNaN(number)?[cursor,null]:[i-1,number]}
const parsePathData=string=>{const pathData=[]
let command=null
let args=[]
let argsCount=0
let canHaveComma=false
let hadComma=false
for(let i=0;i<string.length;i+=1){const c=string.charAt(i)
if(isWhiteSpace(c))continue
if(canHaveComma&&c===","){if(hadComma)break
hadComma=true
continue}if(isCommand(c)){if(hadComma)return pathData
if(command==null){if(c!=="M"&&c!=="m")return pathData}else if(args.length!==0)return pathData
command=c
args=[]
argsCount=argsCountPerCommand[command]
canHaveComma=false
argsCount===0&&pathData.push({command:command,args:args})
continue}if(command==null)return pathData
let newCursor=i
let number=null
if(command==="A"||command==="a"){const position=args.length
position!==0&&position!==1||c!=="+"&&c!=="-"&&([newCursor,number]=readNumber(string,i))
position!==2&&position!==5&&position!==6||([newCursor,number]=readNumber(string,i))
if(position===3||position===4){c==="0"&&(number=0)
c==="1"&&(number=1)}}else[newCursor,number]=readNumber(string,i)
if(number==null)return pathData
args.push(number)
canHaveComma=true
hadComma=false
i=newCursor
if(args.length===argsCount){pathData.push({command:command,args:args})
command==="M"&&(command="L")
command==="m"&&(command="l")
args=[]}}return pathData}
const roundAndStringify=(number,precision)=>{precision!=null&&(number=toFixed(number,precision))
return{roundedStr:removeLeadingZero(number),rounded:number}}
const stringifyArgs=(command,args,precision,disableSpaceAfterFlags)=>{let result=""
let previous
for(let i=0;i<args.length;i++){const{roundedStr:roundedStr,rounded:rounded}=roundAndStringify(args[i],precision)
!disableSpaceAfterFlags||command!=="A"&&command!=="a"||i%7!==4&&i%7!==5?i===0||rounded<0?result+=roundedStr:Number.isInteger(previous)||isDigit(roundedStr[0])?result+=` ${roundedStr}`:result+=roundedStr:result+=roundedStr
previous=rounded}return result}
const stringifyPathData=({pathData:pathData,precision:precision,disableSpaceAfterFlags:disableSpaceAfterFlags})=>{if(pathData.length===1){const{command:command,args:args}=pathData[0]
return command+stringifyArgs(command,args,precision,disableSpaceAfterFlags)}let result=""
let prev={...pathData[0]}
pathData[1].command==="L"?prev.command="M":pathData[1].command==="l"&&(prev.command="m")
for(let i=1;i<pathData.length;i++){const{command:command,args:args}=pathData[i]
if(prev.command===command&&prev.command!=="M"&&prev.command!=="m"||prev.command==="M"&&command==="L"||prev.command==="m"&&command==="l"){prev.args=[...prev.args,...args]
i===pathData.length-1&&(result+=prev.command+stringifyArgs(prev.command,prev.args,precision,disableSpaceAfterFlags))}else{result+=prev.command+stringifyArgs(prev.command,prev.args,precision,disableSpaceAfterFlags)
i===pathData.length-1?result+=command+stringifyArgs(command,args,precision,disableSpaceAfterFlags):prev={command:command,args:args}}}return result}
const nonRendering=elemsGroups.nonRendering
const name$y="removeHiddenElems"
const description$y="removes hidden elements (zero sized, with absent attributes)"
const fn$y=(root,params)=>{const{isHidden:isHidden=true,displayNone:displayNone=true,opacity0:opacity0=true,circleR0:circleR0=true,ellipseRX0:ellipseRX0=true,ellipseRY0:ellipseRY0=true,rectWidth0:rectWidth0=true,rectHeight0:rectHeight0=true,patternWidth0:patternWidth0=true,patternHeight0:patternHeight0=true,imageWidth0:imageWidth0=true,imageHeight0:imageHeight0=true,pathEmptyD:pathEmptyD=true,polylineEmptyPoints:polylineEmptyPoints=true,polygonEmptyPoints:polygonEmptyPoints=true}=params
const stylesheet=collectStylesheet(root)
const nonRenderedNodes=new Map
const removedDefIds=new Set
const allDefs=new Map
const allReferences=new Set
const referencesById=new Map
let deoptimized=false
function canRemoveNonRenderingNode(node){if(allReferences.has(node.attributes.id))return false
for(const child of node.children)if(child.type==="element"&&!canRemoveNonRenderingNode(child))return false
return true}function removeElement(node,parentNode){node.type==="element"&&node.attributes.id!=null&&parentNode.type==="element"&&parentNode.name==="defs"&&removedDefIds.add(node.attributes.id)
detachNodeFromParent(node,parentNode)}visit(root,{element:{enter:(node,parentNode)=>{if(nonRendering.has(node.name)){nonRenderedNodes.set(node,parentNode)
return visitSkip}const computedStyle=computeStyle(stylesheet,node)
if(opacity0&&computedStyle.opacity&&computedStyle.opacity.type==="static"&&computedStyle.opacity.value==="0"){if(node.name==="path"){nonRenderedNodes.set(node,parentNode)
return visitSkip}removeElement(node,parentNode)}}}})
return{element:{enter:(node,parentNode)=>{if(node.name==="style"&&node.children.length!==0||hasScripts(node)){deoptimized=true
return}node.name==="defs"&&allDefs.set(node,parentNode)
if(node.name==="use")for(const attr of Object.keys(node.attributes)){if(attr!=="href"&&!attr.endsWith(":href"))continue
const value=node.attributes[attr]
const id=value.slice(1)
let refs=referencesById.get(id)
if(!refs){refs=[]
referencesById.set(id,refs)}refs.push({node:node,parentNode:parentNode})}const computedStyle=computeStyle(stylesheet,node)
if(isHidden&&computedStyle.visibility&&computedStyle.visibility.type==="static"&&computedStyle.visibility.value==="hidden"&&querySelector(node,"[visibility=visible]")==null){removeElement(node,parentNode)
return}if(displayNone&&computedStyle.display&&computedStyle.display.type==="static"&&computedStyle.display.value==="none"&&node.name!=="marker"){removeElement(node,parentNode)
return}if(circleR0&&node.name==="circle"&&node.children.length===0&&node.attributes.r==="0"){removeElement(node,parentNode)
return}if(ellipseRX0&&node.name==="ellipse"&&node.children.length===0&&node.attributes.rx==="0"){removeElement(node,parentNode)
return}if(ellipseRY0&&node.name==="ellipse"&&node.children.length===0&&node.attributes.ry==="0"){removeElement(node,parentNode)
return}if(rectWidth0&&node.name==="rect"&&node.children.length===0&&node.attributes.width==="0"){removeElement(node,parentNode)
return}if(rectHeight0&&rectWidth0&&node.name==="rect"&&node.children.length===0&&node.attributes.height==="0"){removeElement(node,parentNode)
return}if(patternWidth0&&node.name==="pattern"&&node.attributes.width==="0"){removeElement(node,parentNode)
return}if(patternHeight0&&node.name==="pattern"&&node.attributes.height==="0"){removeElement(node,parentNode)
return}if(imageWidth0&&node.name==="image"&&node.attributes.width==="0"){removeElement(node,parentNode)
return}if(imageHeight0&&node.name==="image"&&node.attributes.height==="0"){removeElement(node,parentNode)
return}if(pathEmptyD&&node.name==="path"){if(node.attributes.d==null){removeElement(node,parentNode)
return}const pathData=parsePathData(node.attributes.d)
if(pathData.length===0){removeElement(node,parentNode)
return}if(pathData.length===1&&computedStyle["marker-start"]==null&&computedStyle["marker-end"]==null){removeElement(node,parentNode)
return}}if(polylineEmptyPoints&&node.name==="polyline"&&node.attributes.points==null){removeElement(node,parentNode)
return}if(polygonEmptyPoints&&node.name==="polygon"&&node.attributes.points==null){removeElement(node,parentNode)
return}for(const[name,value]of Object.entries(node.attributes)){const ids=findReferences(name,value)
for(const id of ids)allReferences.add(id)}}},root:{exit:()=>{for(const id of removedDefIds){const refs=referencesById.get(id)
if(refs)for(const{node:node,parentNode:parentNode}of refs)detachNodeFromParent(node,parentNode)}if(!deoptimized)for(const[nonRenderedNode,nonRenderedParent]of nonRenderedNodes.entries())canRemoveNonRenderingNode(nonRenderedNode)&&detachNodeFromParent(nonRenderedNode,nonRenderedParent)
for(const[node,parentNode]of allDefs.entries())node.children.length===0&&detachNodeFromParent(node,parentNode)}}}}
var removeHiddenElems=Object.freeze({__proto__:null,description:description$y,fn:fn$y,name:name$y})
const name$x="removeEmptyText"
const description$x="removes empty <text> elements"
const fn$x=(root,params)=>{const{text:text=true,tspan:tspan=true,tref:tref=true}=params
return{element:{enter:(node,parentNode)=>{text&&node.name==="text"&&node.children.length===0&&detachNodeFromParent(node,parentNode)
tspan&&node.name==="tspan"&&node.children.length===0&&detachNodeFromParent(node,parentNode)
tref&&node.name==="tref"&&node.attributes["xlink:href"]==null&&detachNodeFromParent(node,parentNode)}}}}
var removeEmptyText=Object.freeze({__proto__:null,description:description$x,fn:fn$x,name:name$x})
const name$w="convertShapeToPath"
const description$w="converts basic shapes to more compact path form"
const regNumber=/[-+]?(?:\d*\.\d+|\d+\.?)(?:[eE][-+]?\d+)?/g
const fn$w=(root,params)=>{const{convertArcs:convertArcs=false,floatPrecision:precision}=params
return{element:{enter:(node,parentNode)=>{if(node.name==="rect"&&node.attributes.width!=null&&node.attributes.height!=null&&node.attributes.rx==null&&node.attributes.ry==null){const x=Number(node.attributes.x||"0")
const y=Number(node.attributes.y||"0")
const width=Number(node.attributes.width)
const height=Number(node.attributes.height)
if(Number.isNaN(x-y+width-height))return
const pathData=[{command:"M",args:[x,y]},{command:"H",args:[x+width]},{command:"V",args:[y+height]},{command:"H",args:[x]},{command:"z",args:[]}]
node.name="path"
node.attributes.d=stringifyPathData({pathData:pathData,precision:precision})
delete node.attributes.x
delete node.attributes.y
delete node.attributes.width
delete node.attributes.height}if(node.name==="line"){const x1=Number(node.attributes.x1||"0")
const y1=Number(node.attributes.y1||"0")
const x2=Number(node.attributes.x2||"0")
const y2=Number(node.attributes.y2||"0")
if(Number.isNaN(x1-y1+x2-y2))return
const pathData=[{command:"M",args:[x1,y1]},{command:"L",args:[x2,y2]}]
node.name="path"
node.attributes.d=stringifyPathData({pathData:pathData,precision:precision})
delete node.attributes.x1
delete node.attributes.y1
delete node.attributes.x2
delete node.attributes.y2}if((node.name==="polyline"||node.name==="polygon")&&node.attributes.points!=null){const coords=(node.attributes.points.match(regNumber)||[]).map(Number)
if(coords.length<4){detachNodeFromParent(node,parentNode)
return}const pathData=[]
for(let i=0;i<coords.length;i+=2)pathData.push({command:i===0?"M":"L",args:coords.slice(i,i+2)})
node.name==="polygon"&&pathData.push({command:"z",args:[]})
node.name="path"
node.attributes.d=stringifyPathData({pathData:pathData,precision:precision})
delete node.attributes.points}if(node.name==="circle"&&convertArcs){const cx=Number(node.attributes.cx||"0")
const cy=Number(node.attributes.cy||"0")
const r=Number(node.attributes.r||"0")
if(Number.isNaN(cx-cy+r))return
const pathData=[{command:"M",args:[cx,cy-r]},{command:"A",args:[r,r,0,1,0,cx,cy+r]},{command:"A",args:[r,r,0,1,0,cx,cy-r]},{command:"z",args:[]}]
node.name="path"
node.attributes.d=stringifyPathData({pathData:pathData,precision:precision})
delete node.attributes.cx
delete node.attributes.cy
delete node.attributes.r}if(node.name==="ellipse"&&convertArcs){const ecx=Number(node.attributes.cx||"0")
const ecy=Number(node.attributes.cy||"0")
const rx=Number(node.attributes.rx||"0")
const ry=Number(node.attributes.ry||"0")
if(Number.isNaN(ecx-ecy+rx-ry))return
const pathData=[{command:"M",args:[ecx,ecy-ry]},{command:"A",args:[rx,ry,0,1,0,ecx,ecy+ry]},{command:"A",args:[rx,ry,0,1,0,ecx,ecy-ry]},{command:"z",args:[]}]
node.name="path"
node.attributes.d=stringifyPathData({pathData:pathData,precision:precision})
delete node.attributes.cx
delete node.attributes.cy
delete node.attributes.rx
delete node.attributes.ry}}}}}
var convertShapeToPath=Object.freeze({__proto__:null,description:description$w,fn:fn$w,name:name$w})
const name$v="convertEllipseToCircle"
const description$v="converts non-eccentric <ellipse>s to <circle>s"
const fn$v=()=>({element:{enter:node=>{if(node.name==="ellipse"){const rx=node.attributes.rx||"0"
const ry=node.attributes.ry||"0"
if(rx===ry||rx==="auto"||ry==="auto"){node.name="circle"
const radius=rx==="auto"?ry:rx
delete node.attributes.rx
delete node.attributes.ry
node.attributes.r=radius}}}}})
var convertEllipseToCircle=Object.freeze({__proto__:null,description:description$v,fn:fn$v,name:name$v})
const name$u="moveElemsAttrsToGroup"
const description$u="Move common attributes of group children to the group"
const fn$u=root=>{let deoptimizedWithStyles=false
visit(root,{element:{enter:node=>{node.name==="style"&&(deoptimizedWithStyles=true)}}})
return{element:{exit:node=>{if(node.name!=="g"||node.children.length<=1)return
if(deoptimizedWithStyles)return
const commonAttributes=new Map
let initial=true
let everyChildIsPath=true
for(const child of node.children)if(child.type==="element"){pathElems.has(child.name)||(everyChildIsPath=false)
if(initial){initial=false
for(const[name,value]of Object.entries(child.attributes))inheritableAttrs.has(name)&&commonAttributes.set(name,value)}else for(const[name,value]of commonAttributes)child.attributes[name]!==value&&commonAttributes.delete(name)}node.attributes["filter"]==null&&node.attributes["clip-path"]==null&&node.attributes.mask==null||commonAttributes.delete("transform")
everyChildIsPath&&commonAttributes.delete("transform")
for(const[name,value]of commonAttributes)name==="transform"?node.attributes.transform!=null?node.attributes.transform=`${node.attributes.transform} ${value}`:node.attributes.transform=value:node.attributes[name]=value
for(const child of node.children)if(child.type==="element")for(const[name]of commonAttributes)delete child.attributes[name]}}}}
var moveElemsAttrsToGroup=Object.freeze({__proto__:null,description:description$u,fn:fn$u,name:name$u})
const name$t="moveGroupAttrsToElems"
const description$t="moves some group attributes to the content elements"
const pathElemsWithGroupsAndText=[...pathElems,"g","text"]
const fn$t=()=>({element:{enter:node=>{if(node.name==="g"&&node.children.length!==0&&node.attributes.transform!=null&&Object.entries(node.attributes).some((([name,value])=>referencesProps.has(name)&&includesUrlReference(value)))===false&&node.children.every((child=>child.type==="element"&&pathElemsWithGroupsAndText.includes(child.name)&&child.attributes.id==null))){for(const child of node.children){const value=node.attributes.transform
child.type==="element"&&(child.attributes.transform!=null?child.attributes.transform=`${value} ${child.attributes.transform}`:child.attributes.transform=value)}delete node.attributes.transform}}}})
var moveGroupAttrsToElems=Object.freeze({__proto__:null,description:description$t,fn:fn$t,name:name$t})
const name$s="collapseGroups"
const description$s="collapses useless groups"
const hasAnimatedAttr=(node,name)=>{if(node.type==="element"){if(elemsGroups.animation.has(node.name)&&node.attributes.attributeName===name)return true
for(const child of node.children)if(hasAnimatedAttr(child,name))return true}return false}
const fn$s=root=>{const stylesheet=collectStylesheet(root)
return{element:{exit:(node,parentNode)=>{if(parentNode.type==="root"||parentNode.name==="switch")return
if(node.name!=="g"||node.children.length===0)return
if(Object.keys(node.attributes).length!==0&&node.children.length===1){const firstChild=node.children[0]
const nodeHasFilter=!!(node.attributes.filter||computeStyle(stylesheet,node).filter)
if(firstChild.type==="element"&&firstChild.attributes.id==null&&!nodeHasFilter&&(node.attributes.class==null||firstChild.attributes.class==null)&&(node.attributes["clip-path"]==null&&node.attributes.mask==null||firstChild.name==="g"&&node.attributes.transform==null&&firstChild.attributes.transform==null)){const newChildElemAttrs={...firstChild.attributes}
for(const[name,value]of Object.entries(node.attributes)){if(hasAnimatedAttr(firstChild,name))return
if(newChildElemAttrs[name]==null)newChildElemAttrs[name]=value
else if(name==="transform")newChildElemAttrs[name]=value+" "+newChildElemAttrs[name]
else if(newChildElemAttrs[name]==="inherit")newChildElemAttrs[name]=value
else if(!inheritableAttrs.has(name)&&newChildElemAttrs[name]!==value)return}node.attributes={}
firstChild.attributes=newChildElemAttrs}}if(Object.keys(node.attributes).length===0){for(const child of node.children)if(child.type==="element"&&elemsGroups.animation.has(child.name))return
const index=parentNode.children.indexOf(node)
parentNode.children.splice(index,1,...node.children)}}}}}
var collapseGroups=Object.freeze({__proto__:null,description:description$s,fn:fn$s,name:name$s})
let prevCtrlPoint
const path2js=path=>{if(path.pathJS)return path.pathJS
const pathData=[]
const newPathData=parsePathData(path.attributes.d)
for(const{command:command,args:args}of newPathData)pathData.push({command:command,args:args})
pathData.length&&pathData[0].command=="m"&&(pathData[0].command="M")
path.pathJS=pathData
return pathData}
const convertRelativeToAbsolute=data=>{const newData=[]
const start=[0,0]
const cursor=[0,0]
for(let{command:command,args:args}of data){args=args.slice()
if(command==="m"){args[0]+=cursor[0]
args[1]+=cursor[1]
command="M"}if(command==="M"){cursor[0]=args[0]
cursor[1]=args[1]
start[0]=cursor[0]
start[1]=cursor[1]}if(command==="h"){args[0]+=cursor[0]
command="H"}command==="H"&&(cursor[0]=args[0])
if(command==="v"){args[0]+=cursor[1]
command="V"}command==="V"&&(cursor[1]=args[0])
if(command==="l"){args[0]+=cursor[0]
args[1]+=cursor[1]
command="L"}if(command==="L"){cursor[0]=args[0]
cursor[1]=args[1]}if(command==="c"){args[0]+=cursor[0]
args[1]+=cursor[1]
args[2]+=cursor[0]
args[3]+=cursor[1]
args[4]+=cursor[0]
args[5]+=cursor[1]
command="C"}if(command==="C"){cursor[0]=args[4]
cursor[1]=args[5]}if(command==="s"){args[0]+=cursor[0]
args[1]+=cursor[1]
args[2]+=cursor[0]
args[3]+=cursor[1]
command="S"}if(command==="S"){cursor[0]=args[2]
cursor[1]=args[3]}if(command==="q"){args[0]+=cursor[0]
args[1]+=cursor[1]
args[2]+=cursor[0]
args[3]+=cursor[1]
command="Q"}if(command==="Q"){cursor[0]=args[2]
cursor[1]=args[3]}if(command==="t"){args[0]+=cursor[0]
args[1]+=cursor[1]
command="T"}if(command==="T"){cursor[0]=args[0]
cursor[1]=args[1]}if(command==="a"){args[5]+=cursor[0]
args[6]+=cursor[1]
command="A"}if(command==="A"){cursor[0]=args[5]
cursor[1]=args[6]}if(command==="z"||command==="Z"){cursor[0]=start[0]
cursor[1]=start[1]
command="z"}newData.push({command:command,args:args})}return newData}
const js2path=function(path,data,params){path.pathJS=data
const pathData=[]
for(const item of data){if(pathData.length!==0&&(item.command==="M"||item.command==="m")){const last=pathData[pathData.length-1]
last.command!=="M"&&last.command!=="m"||pathData.pop()}pathData.push({command:item.command,args:item.args})}path.attributes.d=stringifyPathData({pathData:pathData,precision:params.floatPrecision,disableSpaceAfterFlags:params.noSpaceAfterFlags})}
function set(dest,source){dest[0]=source[source.length-2]
dest[1]=source[source.length-1]
return dest}const intersects=function(path1,path2){const points1=gatherPoints(convertRelativeToAbsolute(path1))
const points2=gatherPoints(convertRelativeToAbsolute(path2))
if(points1.maxX<=points2.minX||points2.maxX<=points1.minX||points1.maxY<=points2.minY||points2.maxY<=points1.minY||points1.list.every((set1=>points2.list.every((set2=>set1.list[set1.maxX][0]<=set2.list[set2.minX][0]||set2.list[set2.maxX][0]<=set1.list[set1.minX][0]||set1.list[set1.maxY][1]<=set2.list[set2.minY][1]||set2.list[set2.maxY][1]<=set1.list[set1.minY][1])))))return false
const hullNest1=points1.list.map(convexHull)
const hullNest2=points2.list.map(convexHull)
return hullNest1.some((function(hull1){if(hull1.list.length<3)return false
return hullNest2.some((function(hull2){if(hull2.list.length<3)return false
const simplex=[getSupport(hull1,hull2,[1,0])]
const direction=minus(simplex[0])
let iterations=1e4
while(true){if(iterations--==0){console.error("Error: infinite loop while processing mergePaths plugin.")
return true}simplex.push(getSupport(hull1,hull2,direction))
if(dot(direction,simplex[simplex.length-1])<=0)return false
if(processSimplex(simplex,direction))return true}}))}))
function getSupport(a,b,direction){return sub(supportPoint(a,direction),supportPoint(b,minus(direction)))}function supportPoint(polygon,direction){let index=direction[1]>=0?direction[0]<0?polygon.maxY:polygon.maxX:direction[0]<0?polygon.minX:polygon.minY
let max=-1/0
let value
while((value=dot(polygon.list[index],direction))>max){max=value
index=++index%polygon.list.length}return polygon.list[(index||polygon.list.length)-1]}}
function processSimplex(simplex,direction){if(simplex.length==2){const a=simplex[1]
const b=simplex[0]
const AO=minus(simplex[1])
const AB=sub(b,a)
if(dot(AO,AB)>0)set(direction,orth(AB,a))
else{set(direction,AO)
simplex.shift()}}else{const a=simplex[2]
const b=simplex[1]
const c=simplex[0]
const AB=sub(b,a)
const AC=sub(c,a)
const AO=minus(a)
const ACB=orth(AB,AC)
const ABC=orth(AC,AB)
if(dot(ACB,AO)>0)if(dot(AB,AO)>0){set(direction,ACB)
simplex.shift()}else{set(direction,AO)
simplex.splice(0,2)}else{if(!(dot(ABC,AO)>0))return true
if(dot(AC,AO)>0){set(direction,ABC)
simplex.splice(1,1)}else{set(direction,AO)
simplex.splice(0,2)}}}return false}function minus(v){return[-v[0],-v[1]]}function sub(v1,v2){return[v1[0]-v2[0],v1[1]-v2[1]]}function dot(v1,v2){return v1[0]*v2[0]+v1[1]*v2[1]}function orth(v,from){const o=[-v[1],v[0]]
return dot(o,minus(from))<0?minus(o):o}function gatherPoints(pathData){const points={list:[],minX:0,minY:0,maxX:0,maxY:0}
const addPoint=(path,point)=>{if(!path.list.length||point[1]>path.list[path.maxY][1]){path.maxY=path.list.length
points.maxY=points.list.length?Math.max(point[1],points.maxY):point[1]}if(!path.list.length||point[0]>path.list[path.maxX][0]){path.maxX=path.list.length
points.maxX=points.list.length?Math.max(point[0],points.maxX):point[0]}if(!path.list.length||point[1]<path.list[path.minY][1]){path.minY=path.list.length
points.minY=points.list.length?Math.min(point[1],points.minY):point[1]}if(!path.list.length||point[0]<path.list[path.minX][0]){path.minX=path.list.length
points.minX=points.list.length?Math.min(point[0],points.minX):point[0]}path.list.push(point)}
for(let i=0;i<pathData.length;i+=1){const pathDataItem=pathData[i]
let subPath=points.list.length===0?{list:[],minX:0,minY:0,maxX:0,maxY:0}:points.list[points.list.length-1]
const prev=i===0?null:pathData[i-1]
let basePoint=subPath.list.length===0?null:subPath.list[subPath.list.length-1]
const data=pathDataItem.args
let ctrlPoint=basePoint
const toAbsolute=(n,i)=>n+(basePoint==null?0:basePoint[i%2])
switch(pathDataItem.command){case"M":subPath={list:[],minX:0,minY:0,maxX:0,maxY:0}
points.list.push(subPath)
break
case"H":basePoint!=null&&addPoint(subPath,[data[0],basePoint[1]])
break
case"V":basePoint!=null&&addPoint(subPath,[basePoint[0],data[0]])
break
case"Q":addPoint(subPath,data.slice(0,2))
prevCtrlPoint=[data[2]-data[0],data[3]-data[1]]
break
case"T":if(basePoint!=null&&prev!=null&&(prev.command=="Q"||prev.command=="T")){ctrlPoint=[basePoint[0]+prevCtrlPoint[0],basePoint[1]+prevCtrlPoint[1]]
addPoint(subPath,ctrlPoint)
prevCtrlPoint=[data[0]-ctrlPoint[0],data[1]-ctrlPoint[1]]}break
case"C":basePoint!=null&&addPoint(subPath,[0.5*(basePoint[0]+data[0]),0.5*(basePoint[1]+data[1])])
addPoint(subPath,[0.5*(data[0]+data[2]),0.5*(data[1]+data[3])])
addPoint(subPath,[0.5*(data[2]+data[4]),0.5*(data[3]+data[5])])
prevCtrlPoint=[data[4]-data[2],data[5]-data[3]]
break
case"S":if(basePoint!=null&&prev!=null&&(prev.command=="C"||prev.command=="S")){addPoint(subPath,[basePoint[0]+0.5*prevCtrlPoint[0],basePoint[1]+0.5*prevCtrlPoint[1]])
ctrlPoint=[basePoint[0]+prevCtrlPoint[0],basePoint[1]+prevCtrlPoint[1]]}ctrlPoint!=null&&addPoint(subPath,[0.5*(ctrlPoint[0]+data[0]),0.5*(ctrlPoint[1]+data[1])])
addPoint(subPath,[0.5*(data[0]+data[2]),0.5*(data[1]+data[3])])
prevCtrlPoint=[data[2]-data[0],data[3]-data[1]]
break
case"A":if(basePoint!=null){const curves=a2c.apply(0,basePoint.concat(data))
for(var cData;(cData=curves.splice(0,6).map(toAbsolute)).length;){basePoint!=null&&addPoint(subPath,[0.5*(basePoint[0]+cData[0]),0.5*(basePoint[1]+cData[1])])
addPoint(subPath,[0.5*(cData[0]+cData[2]),0.5*(cData[1]+cData[3])])
addPoint(subPath,[0.5*(cData[2]+cData[4]),0.5*(cData[3]+cData[5])])
curves.length&&addPoint(subPath,basePoint=cData.slice(-2))}}break}data.length>=2&&addPoint(subPath,data.slice(-2))}return points}function convexHull(points){points.list.sort((function(a,b){return a[0]==b[0]?a[1]-b[1]:a[0]-b[0]}))
const lower=[]
let minY=0
let bottom=0
for(let i=0;i<points.list.length;i++){while(lower.length>=2&&cross(lower[lower.length-2],lower[lower.length-1],points.list[i])<=0)lower.pop()
if(points.list[i][1]<points.list[minY][1]){minY=i
bottom=lower.length}lower.push(points.list[i])}const upper=[]
let maxY=points.list.length-1
let top=0
for(let i=points.list.length;i--;){while(upper.length>=2&&cross(upper[upper.length-2],upper[upper.length-1],points.list[i])<=0)upper.pop()
if(points.list[i][1]>points.list[maxY][1]){maxY=i
top=upper.length}upper.push(points.list[i])}upper.pop()
lower.pop()
const hullList=lower.concat(upper)
const hull={list:hullList,minX:0,maxX:lower.length,minY:bottom,maxY:(lower.length+top)%hullList.length}
return hull}function cross(o,a,b){return(a[0]-o[0])*(b[1]-o[1])-(a[1]-o[1])*(b[0]-o[0])}const a2c=(x1,y1,rx,ry,angle,large_arc_flag,sweep_flag,x2,y2,recursive)=>{const _120=Math.PI*120/180
const rad=Math.PI/180*(+angle||0)
let res=[]
const rotateX=(x,y,rad)=>x*Math.cos(rad)-y*Math.sin(rad)
const rotateY=(x,y,rad)=>x*Math.sin(rad)+y*Math.cos(rad)
if(recursive){f1=recursive[0]
f2=recursive[1]
cx=recursive[2]
cy=recursive[3]}else{x1=rotateX(x1,y1,-rad)
y1=rotateY(x1,y1,-rad)
x2=rotateX(x2,y2,-rad)
y2=rotateY(x2,y2,-rad)
const x=(x1-x2)/2
const y=(y1-y2)/2
let h=x*x/(rx*rx)+y*y/(ry*ry)
if(h>1){h=Math.sqrt(h)
rx*=h
ry*=h}const rx2=rx*rx
const ry2=ry*ry
const k=(large_arc_flag==sweep_flag?-1:1)*Math.sqrt(Math.abs((rx2*ry2-rx2*y*y-ry2*x*x)/(rx2*y*y+ry2*x*x)))
var cx=k*rx*y/ry+(x1+x2)/2
var cy=k*-ry*x/rx+(y1+y2)/2
var f1=Math.asin(Number(((y1-cy)/ry).toFixed(9)))
var f2=Math.asin(Number(((y2-cy)/ry).toFixed(9)))
f1=x1<cx?Math.PI-f1:f1
f2=x2<cx?Math.PI-f2:f2
f1<0&&(f1=Math.PI*2+f1)
f2<0&&(f2=Math.PI*2+f2)
sweep_flag&&f1>f2&&(f1-=Math.PI*2)
!sweep_flag&&f2>f1&&(f2-=Math.PI*2)}let df=f2-f1
if(Math.abs(df)>_120){const f2old=f2
const x2old=x2
const y2old=y2
f2=f1+_120*(sweep_flag&&f2>f1?1:-1)
x2=cx+rx*Math.cos(f2)
y2=cy+ry*Math.sin(f2)
res=a2c(x2,y2,rx,ry,angle,0,sweep_flag,x2old,y2old,[f2,f2old,cx,cy])}df=f2-f1
const c1=Math.cos(f1)
const s1=Math.sin(f1)
const c2=Math.cos(f2)
const s2=Math.sin(f2)
const t=Math.tan(df/4)
const hx=4/3*rx*t
const hy=4/3*ry*t
const m=[-hx*s1,hy*c1,x2+hx*s2-x1,y2-hy*c2-y1,x2-x1,y2-y1]
if(recursive)return m.concat(res)
{res=m.concat(res)
const newres=[]
for(let i=0,n=res.length;i<n;i++)newres[i]=i%2?rotateY(res[i-1],res[i],rad):rotateX(res[i],res[i+1],rad)
return newres}}
const transformTypes=new Set(["matrix","rotate","scale","skewX","skewY","translate"])
const regTransformSplit=/\s*(matrix|translate|scale|rotate|skewX|skewY)\s*\(\s*(.+?)\s*\)[\s,]*/
const regNumericValues$2=/[-+]?(?:\d*\.\d+|\d+\.?)(?:[eE][-+]?\d+)?/g
const transform2js=transformString=>{const transforms=[]
let currentTransform=null
for(const item of transformString.split(regTransformSplit)){if(!item)continue
if(transformTypes.has(item)){currentTransform={name:item,data:[]}
transforms.push(currentTransform)}else{let num
while(num=regNumericValues$2.exec(item)){num=Number(num)
currentTransform!=null&&currentTransform.data.push(num)}}}return currentTransform==null||currentTransform.data.length==0?[]:transforms}
const transformsMultiply=transforms=>{const matrixData=transforms.map((transform=>{if(transform.name==="matrix")return transform.data
return transformToMatrix(transform)}))
const matrixTransform={name:"matrix",data:matrixData.length>0?matrixData.reduce(multiplyTransformMatrices):[]}
return matrixTransform}
const mth={rad:deg=>deg*Math.PI/180,deg:rad=>rad*180/Math.PI,cos:deg=>Math.cos(mth.rad(deg)),acos:(val,floatPrecision)=>toFixed(mth.deg(Math.acos(val)),floatPrecision),sin:deg=>Math.sin(mth.rad(deg)),asin:(val,floatPrecision)=>toFixed(mth.deg(Math.asin(val)),floatPrecision),tan:deg=>Math.tan(mth.rad(deg)),atan:(val,floatPrecision)=>toFixed(mth.deg(Math.atan(val)),floatPrecision)}
const getDecompositions=matrix=>{const decompositions=[]
const qrab=decomposeQRAB(matrix)
const qrcd=decomposeQRCD(matrix)
qrab&&decompositions.push(qrab)
qrcd&&decompositions.push(qrcd)
return decompositions}
const decomposeQRAB=matrix=>{const data=matrix.data
const[a,b,c,d,e,f]=data
const delta=a*d-b*c
if(delta===0)return
const r=Math.hypot(a,b)
if(r===0)return
const decomposition=[]
const cosOfRotationAngle=a/r;(e||f)&&decomposition.push({name:"translate",data:[e,f]})
if(cosOfRotationAngle!==1){const rotationAngleRads=Math.acos(cosOfRotationAngle)
decomposition.push({name:"rotate",data:[mth.deg(b<0?-rotationAngleRads:rotationAngleRads),0,0]})}const sx=r
const sy=delta/sx
sx===1&&sy===1||decomposition.push({name:"scale",data:[sx,sy]})
const ac_plus_bd=a*c+b*d
ac_plus_bd&&decomposition.push({name:"skewX",data:[mth.deg(Math.atan(ac_plus_bd/(a*a+b*b)))]})
return decomposition}
const decomposeQRCD=matrix=>{const data=matrix.data
const[a,b,c,d,e,f]=data
const delta=a*d-b*c
if(delta===0)return
const s=Math.hypot(c,d)
if(s===0)return
const decomposition=[];(e||f)&&decomposition.push({name:"translate",data:[e,f]})
const rotationAngleRads=Math.PI/2-(d<0?-1:1)*Math.acos(-c/s)
decomposition.push({name:"rotate",data:[mth.deg(rotationAngleRads),0,0]})
const sx=delta/s
const sy=s
sx===1&&sy===1||decomposition.push({name:"scale",data:[sx,sy]})
const ac_plus_bd=a*c+b*d
ac_plus_bd&&decomposition.push({name:"skewY",data:[mth.deg(Math.atan(ac_plus_bd/(c*c+d*d)))]})
return decomposition}
const mergeTranslateAndRotate=(tx,ty,a)=>{const rotationAngleRads=mth.rad(a)
const d=1-Math.cos(rotationAngleRads)
const e=Math.sin(rotationAngleRads)
const cy=(d*ty+e*tx)/(d*d+e*e)
const cx=(tx-e*cy)/d
return{name:"rotate",data:[a,cx,cy]}}
const isIdentityTransform=t=>{switch(t.name){case"rotate":case"skewX":case"skewY":return t.data[0]===0
case"scale":return t.data[0]===1&&t.data[1]===1
case"translate":return t.data[0]===0&&t.data[1]===0}return false}
const optimize$1=(roundedTransforms,rawTransforms)=>{const optimizedTransforms=[]
for(let index=0;index<roundedTransforms.length;index++){const roundedTransform=roundedTransforms[index]
if(isIdentityTransform(roundedTransform))continue
const data=roundedTransform.data
switch(roundedTransform.name){case"rotate":switch(data[0]){case 180:case-180:{const next=roundedTransforms[index+1]
if(next&&next.name==="scale"){optimizedTransforms.push(createScaleTransform(next.data.map((v=>-v))))
index++}else optimizedTransforms.push({name:"scale",data:[-1]})}continue}optimizedTransforms.push({name:"rotate",data:data.slice(0,data[1]||data[2]?3:1)})
break
case"scale":optimizedTransforms.push(createScaleTransform(data))
break
case"skewX":case"skewY":optimizedTransforms.push({name:roundedTransform.name,data:[data[0]]})
break
case"translate":{const next=roundedTransforms[index+1]
if(next&&next.name==="rotate"&&next.data[0]!==180&&next.data[0]!==-180&&next.data[0]!==0&&next.data[1]===0&&next.data[2]===0){const data=rawTransforms[index].data
optimizedTransforms.push(mergeTranslateAndRotate(data[0],data[1],rawTransforms[index+1].data[0]))
index++
continue}}optimizedTransforms.push({name:"translate",data:data.slice(0,data[1]?2:1)})
break}}return optimizedTransforms.length?optimizedTransforms:[{name:"scale",data:[1]}]}
const createScaleTransform=data=>{const scaleData=data.slice(0,data[0]===data[1]?1:2)
return{name:"scale",data:scaleData}}
const matrixToTransform=(origMatrix,params)=>{const decomposed=getDecompositions(origMatrix)
let shortest
let shortestLen=Number.MAX_VALUE
for(const decomposition of decomposed){const roundedTransforms=decomposition.map((transformItem=>{const transformCopy={name:transformItem.name,data:[...transformItem.data]}
return roundTransform(transformCopy,params)}))
const optimized=optimize$1(roundedTransforms,decomposition)
const len=js2transform(optimized,params).length
if(len<shortestLen){shortest=optimized
shortestLen=len}}return shortest??[origMatrix]}
const transformToMatrix=transform=>{if(transform.name==="matrix")return transform.data
switch(transform.name){case"translate":return[1,0,0,1,transform.data[0],transform.data[1]||0]
case"scale":return[transform.data[0],0,0,transform.data[1]??transform.data[0],0,0]
case"rotate":var cos=mth.cos(transform.data[0])
var sin=mth.sin(transform.data[0])
var cx=transform.data[1]||0
var cy=transform.data[2]||0
return[cos,sin,-sin,cos,(1-cos)*cx+sin*cy,(1-cos)*cy-sin*cx]
case"skewX":return[1,0,mth.tan(transform.data[0]),1,0,0]
case"skewY":return[1,mth.tan(transform.data[0]),0,1,0,0]
default:throw Error(`Unknown transform ${transform.name}`)}}
const transformArc=(cursor,arc,transform)=>{const x=arc[5]-cursor[0]
const y=arc[6]-cursor[1]
let a=arc[0]
let b=arc[1]
const rot=arc[2]*Math.PI/180
const cos=Math.cos(rot)
const sin=Math.sin(rot)
if(a>0&&b>0){let h=Math.pow(x*cos+y*sin,2)/(4*a*a)+Math.pow(y*cos-x*sin,2)/(4*b*b)
if(h>1){h=Math.sqrt(h)
a*=h
b*=h}}const ellipse=[a*cos,a*sin,-b*sin,b*cos,0,0]
const m=multiplyTransformMatrices(transform,ellipse)
const lastCol=m[2]*m[2]+m[3]*m[3]
const squareSum=m[0]*m[0]+m[1]*m[1]+lastCol
const root=Math.hypot(m[0]-m[3],m[1]+m[2])*Math.hypot(m[0]+m[3],m[1]-m[2])
if(root){const majorAxisSqr=(squareSum+root)/2
const minorAxisSqr=(squareSum-root)/2
const major=Math.abs(majorAxisSqr-lastCol)>1e-6
const sub=(major?majorAxisSqr:minorAxisSqr)-lastCol
const rowsSum=m[0]*m[2]+m[1]*m[3]
const term1=m[0]*sub+m[2]*rowsSum
const term2=m[1]*sub+m[3]*rowsSum
arc[0]=Math.sqrt(majorAxisSqr)
arc[1]=Math.sqrt(minorAxisSqr)
arc[2]=((major?term2<0:term1>0)?-1:1)*Math.acos((major?term1:term2)/Math.hypot(term1,term2))*180/Math.PI}else{arc[0]=arc[1]=Math.sqrt(squareSum/2)
arc[2]=0}transform[0]<0!==transform[3]<0&&(arc[4]=1-arc[4])
return arc}
const multiplyTransformMatrices=(a,b)=>[a[0]*b[0]+a[2]*b[1],a[1]*b[0]+a[3]*b[1],a[0]*b[2]+a[2]*b[3],a[1]*b[2]+a[3]*b[3],a[0]*b[4]+a[2]*b[5]+a[4],a[1]*b[4]+a[3]*b[5]+a[5]]
const roundTransform=(transform,params)=>{switch(transform.name){case"translate":transform.data=floatRound(transform.data,params)
break
case"rotate":transform.data=[...degRound(transform.data.slice(0,1),params),...floatRound(transform.data.slice(1),params)]
break
case"skewX":case"skewY":transform.data=degRound(transform.data,params)
break
case"scale":transform.data=transformRound(transform.data,params)
break
case"matrix":transform.data=[...transformRound(transform.data.slice(0,4),params),...floatRound(transform.data.slice(4),params)]
break}return transform}
const degRound=(data,params)=>params.degPrecision!=null&&params.degPrecision>=1&&params.floatPrecision<20?smartRound(params.degPrecision,data):round$1(data)
const floatRound=(data,params)=>params.floatPrecision>=1&&params.floatPrecision<20?smartRound(params.floatPrecision,data):round$1(data)
const transformRound=(data,params)=>params.transformPrecision>=1&&params.floatPrecision<20?smartRound(params.transformPrecision,data):round$1(data)
const round$1=data=>data.map(Math.round)
const smartRound=(precision,data)=>{for(let i=data.length,tolerance=+Math.pow(0.1,precision).toFixed(precision);i--;)if(toFixed(data[i],precision)!==data[i]){const rounded=+data[i].toFixed(precision-1)
data[i]=+Math.abs(rounded-data[i]).toFixed(precision+1)>=tolerance?+data[i].toFixed(precision):rounded}return data}
const js2transform=(transformJS,params)=>{const transformString=transformJS.map((transform=>{roundTransform(transform,params)
return`${transform.name}(${cleanupOutData(transform.data,params)})`})).join("")
return transformString}
const regNumericValues$1=/[-+]?(\d*\.\d+|\d+\.?)(?:[eE][-+]?\d+)?/g
const applyTransforms=(root,params)=>{const stylesheet=collectStylesheet(root)
return{element:{enter:node=>{if(node.attributes.d==null)return
if(node.attributes.id!=null)return
if(node.attributes.transform==null||node.attributes.transform===""||node.attributes.style!=null||Object.entries(node.attributes).some((([name,value])=>referencesProps.has(name)&&includesUrlReference(value))))return
const computedStyle=computeStyle(stylesheet,node)
const transformStyle=computedStyle.transform
if(transformStyle.type==="static"&&transformStyle.value!==node.attributes.transform)return
const matrix=transformsMultiply(transform2js(node.attributes.transform))
const stroke=computedStyle.stroke?.type==="static"?computedStyle.stroke.value:null
const strokeWidth=computedStyle["stroke-width"]?.type==="static"?computedStyle["stroke-width"].value:null
const transformPrecision=params.transformPrecision
if(computedStyle.stroke?.type==="dynamic"||computedStyle["stroke-width"]?.type==="dynamic")return
const scale=Number(Math.hypot(matrix.data[0],matrix.data[1]).toFixed(transformPrecision))
if(stroke&&stroke!="none"){if(!params.applyTransformsStroked)return
if((matrix.data[0]!==matrix.data[3]||matrix.data[1]!==-matrix.data[2])&&(matrix.data[0]!==-matrix.data[3]||matrix.data[1]!==matrix.data[2]))return
if(scale!==1&&node.attributes["vector-effect"]!=="non-scaling-stroke"){node.attributes["stroke-width"]=(strokeWidth||attrsGroupsDefaults.presentation["stroke-width"]).trim().replace(regNumericValues$1,(num=>removeLeadingZero(Number(num)*scale)))
node.attributes["stroke-dashoffset"]!=null&&(node.attributes["stroke-dashoffset"]=node.attributes["stroke-dashoffset"].trim().replace(regNumericValues$1,(num=>removeLeadingZero(Number(num)*scale))))
node.attributes["stroke-dasharray"]!=null&&(node.attributes["stroke-dasharray"]=node.attributes["stroke-dasharray"].trim().replace(regNumericValues$1,(num=>removeLeadingZero(Number(num)*scale))))}}const pathData=path2js(node)
applyMatrixToPathData(pathData,matrix.data)
delete node.attributes.transform}}}}
const transformAbsolutePoint=(matrix,x,y)=>{const newX=matrix[0]*x+matrix[2]*y+matrix[4]
const newY=matrix[1]*x+matrix[3]*y+matrix[5]
return[newX,newY]}
const transformRelativePoint=(matrix,x,y)=>{const newX=matrix[0]*x+matrix[2]*y
const newY=matrix[1]*x+matrix[3]*y
return[newX,newY]}
const applyMatrixToPathData=(pathData,matrix)=>{const start=[0,0]
const cursor=[0,0]
for(const pathItem of pathData){let{command:command,args:args}=pathItem
if(command==="M"){cursor[0]=args[0]
cursor[1]=args[1]
start[0]=cursor[0]
start[1]=cursor[1]
const[x,y]=transformAbsolutePoint(matrix,args[0],args[1])
args[0]=x
args[1]=y}if(command==="m"){cursor[0]+=args[0]
cursor[1]+=args[1]
start[0]=cursor[0]
start[1]=cursor[1]
const[x,y]=transformRelativePoint(matrix,args[0],args[1])
args[0]=x
args[1]=y}if(command==="H"){command="L"
args=[args[0],cursor[1]]}if(command==="h"){command="l"
args=[args[0],0]}if(command==="V"){command="L"
args=[cursor[0],args[0]]}if(command==="v"){command="l"
args=[0,args[0]]}if(command==="L"){cursor[0]=args[0]
cursor[1]=args[1]
const[x,y]=transformAbsolutePoint(matrix,args[0],args[1])
args[0]=x
args[1]=y}if(command==="l"){cursor[0]+=args[0]
cursor[1]+=args[1]
const[x,y]=transformRelativePoint(matrix,args[0],args[1])
args[0]=x
args[1]=y}if(command==="C"){cursor[0]=args[4]
cursor[1]=args[5]
const[x1,y1]=transformAbsolutePoint(matrix,args[0],args[1])
const[x2,y2]=transformAbsolutePoint(matrix,args[2],args[3])
const[x,y]=transformAbsolutePoint(matrix,args[4],args[5])
args[0]=x1
args[1]=y1
args[2]=x2
args[3]=y2
args[4]=x
args[5]=y}if(command==="c"){cursor[0]+=args[4]
cursor[1]+=args[5]
const[x1,y1]=transformRelativePoint(matrix,args[0],args[1])
const[x2,y2]=transformRelativePoint(matrix,args[2],args[3])
const[x,y]=transformRelativePoint(matrix,args[4],args[5])
args[0]=x1
args[1]=y1
args[2]=x2
args[3]=y2
args[4]=x
args[5]=y}if(command==="S"){cursor[0]=args[2]
cursor[1]=args[3]
const[x2,y2]=transformAbsolutePoint(matrix,args[0],args[1])
const[x,y]=transformAbsolutePoint(matrix,args[2],args[3])
args[0]=x2
args[1]=y2
args[2]=x
args[3]=y}if(command==="s"){cursor[0]+=args[2]
cursor[1]+=args[3]
const[x2,y2]=transformRelativePoint(matrix,args[0],args[1])
const[x,y]=transformRelativePoint(matrix,args[2],args[3])
args[0]=x2
args[1]=y2
args[2]=x
args[3]=y}if(command==="Q"){cursor[0]=args[2]
cursor[1]=args[3]
const[x1,y1]=transformAbsolutePoint(matrix,args[0],args[1])
const[x,y]=transformAbsolutePoint(matrix,args[2],args[3])
args[0]=x1
args[1]=y1
args[2]=x
args[3]=y}if(command==="q"){cursor[0]+=args[2]
cursor[1]+=args[3]
const[x1,y1]=transformRelativePoint(matrix,args[0],args[1])
const[x,y]=transformRelativePoint(matrix,args[2],args[3])
args[0]=x1
args[1]=y1
args[2]=x
args[3]=y}if(command==="T"){cursor[0]=args[0]
cursor[1]=args[1]
const[x,y]=transformAbsolutePoint(matrix,args[0],args[1])
args[0]=x
args[1]=y}if(command==="t"){cursor[0]+=args[0]
cursor[1]+=args[1]
const[x,y]=transformRelativePoint(matrix,args[0],args[1])
args[0]=x
args[1]=y}if(command==="A"){transformArc(cursor,args,matrix)
cursor[0]=args[5]
cursor[1]=args[6]
if(Math.abs(args[2])>80){const a=args[0]
const rotation=args[2]
args[0]=args[1]
args[1]=a
args[2]=rotation+(rotation>0?-90:90)}const[x,y]=transformAbsolutePoint(matrix,args[5],args[6])
args[5]=x
args[6]=y}if(command==="a"){transformArc([0,0],args,matrix)
cursor[0]+=args[5]
cursor[1]+=args[6]
if(Math.abs(args[2])>80){const a=args[0]
const rotation=args[2]
args[0]=args[1]
args[1]=a
args[2]=rotation+(rotation>0?-90:90)}const[x,y]=transformRelativePoint(matrix,args[5],args[6])
args[5]=x
args[6]=y}if(command==="z"||command==="Z"){cursor[0]=start[0]
cursor[1]=start[1]}pathItem.command=command
pathItem.args=args}}
const name$r="convertPathData"
const description$r="optimizes path data: writes in shorter form, applies transformations"
let roundData
let precision
let error
let arcThreshold
let arcTolerance
const fn$r=(root,params)=>{const{applyTransforms:_applyTransforms=true,applyTransformsStroked:applyTransformsStroked=true,makeArcs:makeArcs={threshold:2.5,tolerance:0.5},straightCurves:straightCurves=true,convertToQ:convertToQ=true,lineShorthands:lineShorthands=true,convertToZ:convertToZ=true,curveSmoothShorthands:curveSmoothShorthands=true,floatPrecision:floatPrecision=3,transformPrecision:transformPrecision=5,smartArcRounding:smartArcRounding=true,removeUseless:removeUseless=true,collapseRepeated:collapseRepeated=true,utilizeAbsolute:utilizeAbsolute=true,leadingZero:leadingZero=true,negativeExtraSpace:negativeExtraSpace=true,noSpaceAfterFlags:noSpaceAfterFlags=false,forceAbsolutePath:forceAbsolutePath=false}=params
const newParams={applyTransforms:_applyTransforms,applyTransformsStroked:applyTransformsStroked,makeArcs:makeArcs,straightCurves:straightCurves,convertToQ:convertToQ,lineShorthands:lineShorthands,convertToZ:convertToZ,curveSmoothShorthands:curveSmoothShorthands,floatPrecision:floatPrecision,transformPrecision:transformPrecision,smartArcRounding:smartArcRounding,removeUseless:removeUseless,collapseRepeated:collapseRepeated,utilizeAbsolute:utilizeAbsolute,leadingZero:leadingZero,negativeExtraSpace:negativeExtraSpace,noSpaceAfterFlags:noSpaceAfterFlags,forceAbsolutePath:forceAbsolutePath}
_applyTransforms&&visit(root,applyTransforms(root,{transformPrecision:transformPrecision,applyTransformsStroked:applyTransformsStroked}))
const stylesheet=collectStylesheet(root)
return{element:{enter:node=>{if(pathElems.has(node.name)&&node.attributes.d!=null){const computedStyle=computeStyle(stylesheet,node)
precision=floatPrecision
error=precision!==false?+Math.pow(0.1,precision).toFixed(precision):1e-2
roundData=precision&&precision>0&&precision<20?strongRound:round
if(makeArcs){arcThreshold=makeArcs.threshold
arcTolerance=makeArcs.tolerance}const hasMarkerMid=computedStyle["marker-mid"]!=null
const maybeHasStroke=computedStyle.stroke&&(computedStyle.stroke.type==="dynamic"||computedStyle.stroke.value!=="none")
const maybeHasLinecap=computedStyle["stroke-linecap"]&&(computedStyle["stroke-linecap"].type==="dynamic"||computedStyle["stroke-linecap"].value!=="butt")
const maybeHasStrokeAndLinecap=maybeHasStroke&&maybeHasLinecap
const isSafeToUseZ=!maybeHasStroke||computedStyle["stroke-linecap"]?.type==="static"&&computedStyle["stroke-linecap"].value==="round"&&computedStyle["stroke-linejoin"]?.type==="static"&&computedStyle["stroke-linejoin"].value==="round"
let data=path2js(node)
if(data.length){const includesVertices=data.some((item=>item.command!=="m"&&item.command!=="M"))
convertToRelative(data)
data=filters(data,newParams,{isSafeToUseZ:isSafeToUseZ,maybeHasStrokeAndLinecap:maybeHasStrokeAndLinecap,hasMarkerMid:hasMarkerMid})
utilizeAbsolute&&(data=convertToMixed(data,newParams))
const hasMarker=node.attributes["marker-start"]!=null||node.attributes["marker-end"]!=null
const isMarkersOnlyPath=hasMarker&&includesVertices&&data.every((item=>item.command==="m"||item.command==="M"))
isMarkersOnlyPath&&data.push({command:"z",args:[]})
js2path(node,data,newParams)}}}}}}
const convertToRelative=pathData=>{const start=[0,0]
const cursor=[0,0]
let prevCoords=[0,0]
for(let i=0;i<pathData.length;i+=1){const pathItem=pathData[i]
let{command:command,args:args}=pathItem
if(command==="m"){cursor[0]+=args[0]
cursor[1]+=args[1]
start[0]=cursor[0]
start[1]=cursor[1]}if(command==="M"){i!==0&&(command="m")
args[0]-=cursor[0]
args[1]-=cursor[1]
cursor[0]+=args[0]
cursor[1]+=args[1]
start[0]=cursor[0]
start[1]=cursor[1]}if(command==="l"){cursor[0]+=args[0]
cursor[1]+=args[1]}if(command==="L"){command="l"
args[0]-=cursor[0]
args[1]-=cursor[1]
cursor[0]+=args[0]
cursor[1]+=args[1]}command==="h"&&(cursor[0]+=args[0])
if(command==="H"){command="h"
args[0]-=cursor[0]
cursor[0]+=args[0]}command==="v"&&(cursor[1]+=args[0])
if(command==="V"){command="v"
args[0]-=cursor[1]
cursor[1]+=args[0]}if(command==="c"){cursor[0]+=args[4]
cursor[1]+=args[5]}if(command==="C"){command="c"
args[0]-=cursor[0]
args[1]-=cursor[1]
args[2]-=cursor[0]
args[3]-=cursor[1]
args[4]-=cursor[0]
args[5]-=cursor[1]
cursor[0]+=args[4]
cursor[1]+=args[5]}if(command==="s"){cursor[0]+=args[2]
cursor[1]+=args[3]}if(command==="S"){command="s"
args[0]-=cursor[0]
args[1]-=cursor[1]
args[2]-=cursor[0]
args[3]-=cursor[1]
cursor[0]+=args[2]
cursor[1]+=args[3]}if(command==="q"){cursor[0]+=args[2]
cursor[1]+=args[3]}if(command==="Q"){command="q"
args[0]-=cursor[0]
args[1]-=cursor[1]
args[2]-=cursor[0]
args[3]-=cursor[1]
cursor[0]+=args[2]
cursor[1]+=args[3]}if(command==="t"){cursor[0]+=args[0]
cursor[1]+=args[1]}if(command==="T"){command="t"
args[0]-=cursor[0]
args[1]-=cursor[1]
cursor[0]+=args[0]
cursor[1]+=args[1]}if(command==="a"){cursor[0]+=args[5]
cursor[1]+=args[6]}if(command==="A"){command="a"
args[5]-=cursor[0]
args[6]-=cursor[1]
cursor[0]+=args[5]
cursor[1]+=args[6]}if(command==="Z"||command==="z"){cursor[0]=start[0]
cursor[1]=start[1]}pathItem.command=command
pathItem.args=args
pathItem.base=prevCoords
pathItem.coords=[cursor[0],cursor[1]]
prevCoords=pathItem.coords}return pathData}
function filters(path,params,{isSafeToUseZ:isSafeToUseZ,maybeHasStrokeAndLinecap:maybeHasStrokeAndLinecap,hasMarkerMid:hasMarkerMid}){const stringify=data2Path.bind(null,params)
const relSubpoint=[0,0]
const pathBase=[0,0]
let prev={}
let prevQControlPoint
path=path.filter((function(item,index,path){const qControlPoint=prevQControlPoint
let command=item.command
let data=item.args
let next=path[index+1]
if(command!=="Z"&&command!=="z"){let sdata=data
let circle
if(command==="s"){sdata=[0,0].concat(data)
const pdata=prev.args
const n=pdata.length
sdata[0]=pdata[n-2]-pdata[n-4]
sdata[1]=pdata[n-1]-pdata[n-3]}if(params.makeArcs&&(command=="c"||command=="s")&&isConvex(sdata)&&(circle=findCircle(sdata))){const r=roundData([circle.radius])[0]
let angle=findArcAngle(sdata,circle)
const sweep=sdata[5]*sdata[0]-sdata[4]*sdata[1]>0?1:0
let arc={command:"a",args:[r,r,0,0,sweep,sdata[4],sdata[5]],coords:item.coords.slice(),base:item.base}
const output=[arc]
const relCenter=[circle.center[0]-sdata[4],circle.center[1]-sdata[5]]
const relCircle={center:relCenter,radius:circle.radius}
const arcCurves=[item]
let hasPrev=0
let suffix=""
let nextLonghand
if(prev.command=="c"&&isConvex(prev.args)&&isArcPrev(prev.args,circle)||prev.command=="a"&&prev.sdata&&isArcPrev(prev.sdata,circle)){arcCurves.unshift(prev)
arc.base=prev.base
arc.args[5]=arc.coords[0]-arc.base[0]
arc.args[6]=arc.coords[1]-arc.base[1]
const prevData=prev.command=="a"?prev.sdata:prev.args
const prevAngle=findArcAngle(prevData,{center:[prevData[4]+circle.center[0],prevData[5]+circle.center[1]],radius:circle.radius})
angle+=prevAngle
angle>Math.PI&&(arc.args[3]=1)
hasPrev=1}for(var j=index;(next=path[++j])&&(next.command==="c"||next.command==="s");){let nextData=next.args
if(next.command=="s"){nextLonghand=makeLonghand({command:"s",args:next.args.slice()},path[j-1].args)
nextData=nextLonghand.args
nextLonghand.args=nextData.slice(0,2)
suffix=stringify([nextLonghand])}if(!isConvex(nextData)||!isArc(nextData,relCircle))break
angle+=findArcAngle(nextData,relCircle)
if(angle-2*Math.PI>1e-3)break
angle>Math.PI&&(arc.args[3]=1)
arcCurves.push(next)
if(!(2*Math.PI-angle>1e-3)){arc.args[5]=2*(relCircle.center[0]-nextData[4])
arc.args[6]=2*(relCircle.center[1]-nextData[5])
arc.coords=[arc.base[0]+arc.args[5],arc.base[1]+arc.args[6]]
arc={command:"a",args:[r,r,0,0,sweep,next.coords[0]-arc.coords[0],next.coords[1]-arc.coords[1]],coords:next.coords,base:arc.coords}
output.push(arc)
j++
break}arc.coords=next.coords
arc.args[5]=arc.coords[0]-arc.base[0]
arc.args[6]=arc.coords[1]-arc.base[1]
relCenter[0]-=nextData[4]
relCenter[1]-=nextData[5]}if((stringify(output)+suffix).length<stringify(arcCurves).length){path[j]&&path[j].command=="s"&&makeLonghand(path[j],path[j-1].args)
if(hasPrev){const prevArc=output.shift()
roundData(prevArc.args)
relSubpoint[0]+=prevArc.args[5]-prev.args[prev.args.length-2]
relSubpoint[1]+=prevArc.args[6]-prev.args[prev.args.length-1]
prev.command="a"
prev.args=prevArc.args
item.base=prev.coords=prevArc.coords}arc=output.shift()
arcCurves.length==1?item.sdata=sdata.slice():arcCurves.length-1-hasPrev>0&&path.splice(index+1,arcCurves.length-1-hasPrev,...output)
if(!arc)return false
command="a"
data=arc.args
item.coords=arc.coords}}if(precision!==false){if(command==="m"||command==="l"||command==="t"||command==="q"||command==="s"||command==="c")for(let i=data.length;i--;)data[i]+=item.base[i%2]-relSubpoint[i%2]
else if(command=="h")data[0]+=item.base[0]-relSubpoint[0]
else if(command=="v")data[0]+=item.base[1]-relSubpoint[1]
else if(command=="a"){data[5]+=item.base[0]-relSubpoint[0]
data[6]+=item.base[1]-relSubpoint[1]}roundData(data)
if(command=="h")relSubpoint[0]+=data[0]
else if(command=="v")relSubpoint[1]+=data[0]
else{relSubpoint[0]+=data[data.length-2]
relSubpoint[1]+=data[data.length-1]}roundData(relSubpoint)
if(command==="M"||command==="m"){pathBase[0]=relSubpoint[0]
pathBase[1]=relSubpoint[1]}}const sagitta=command==="a"?calculateSagitta(data):void 0
if(params.smartArcRounding&&sagitta!==void 0&&precision)for(let precisionNew=precision;precisionNew>=0;precisionNew--){const radius=toFixed(data[0],precisionNew)
const sagittaNew=calculateSagitta([radius,radius,...data.slice(2)])
if(!(Math.abs(sagitta-sagittaNew)<error))break
data[0]=radius
data[1]=radius}if(params.straightCurves)if(command==="c"&&isCurveStraightLine(data)||command==="s"&&isCurveStraightLine(sdata)){next&&next.command=="s"&&makeLonghand(next,data)
command="l"
data=data.slice(-2)}else if(command==="q"&&isCurveStraightLine(data)){next&&next.command=="t"&&makeLonghand(next,data)
command="l"
data=data.slice(-2)}else if(command==="t"&&prev.command!=="q"&&prev.command!=="t"){command="l"
data=data.slice(-2)}else if(command==="a"&&(data[0]===0||data[1]===0||sagitta!==void 0&&sagitta<error)){command="l"
data=data.slice(-2)}if(params.convertToQ&&command=="c"){const x1=0.75*(item.base[0]+data[0])-0.25*item.base[0]
const x2=0.75*(item.base[0]+data[2])-0.25*(item.base[0]+data[4])
if(Math.abs(x1-x2)<error*2){const y1=0.75*(item.base[1]+data[1])-0.25*item.base[1]
const y2=0.75*(item.base[1]+data[3])-0.25*(item.base[1]+data[5])
if(Math.abs(y1-y2)<error*2){const newData=data.slice()
newData.splice(0,4,x1+x2-item.base[0],y1+y2-item.base[1])
roundData(newData)
const originalLength=cleanupOutData(data,params).length
const newLength=cleanupOutData(newData,params).length
if(newLength<originalLength){command="q"
data=newData
next&&next.command=="s"&&makeLonghand(next,data)}}}}if(params.lineShorthands&&command==="l")if(data[1]===0){command="h"
data.pop()}else if(data[0]===0){command="v"
data.shift()}if(params.collapseRepeated&&hasMarkerMid===false&&(command==="m"||command==="h"||command==="v")&&prev.command&&command==prev.command.toLowerCase()&&(command!="h"&&command!="v"||prev.args[0]>=0==data[0]>=0)){prev.args[0]+=data[0]
command!="h"&&command!="v"&&(prev.args[1]+=data[1])
prev.coords=item.coords
path[index]=prev
return false}if(params.curveSmoothShorthands&&prev.command)if(command==="c"){if(prev.command==="c"&&Math.abs(data[0]- -(prev.args[2]-prev.args[4]))<error&&Math.abs(data[1]- -(prev.args[3]-prev.args[5]))<error){command="s"
data=data.slice(2)}else if(prev.command==="s"&&Math.abs(data[0]- -(prev.args[0]-prev.args[2]))<error&&Math.abs(data[1]- -(prev.args[1]-prev.args[3]))<error){command="s"
data=data.slice(2)}else if(prev.command!=="c"&&prev.command!=="s"&&Math.abs(data[0])<error&&Math.abs(data[1])<error){command="s"
data=data.slice(2)}}else if(command==="q")if(prev.command==="q"&&Math.abs(data[0]-(prev.args[2]-prev.args[0]))<error&&Math.abs(data[1]-(prev.args[3]-prev.args[1]))<error){command="t"
data=data.slice(2)}else if(prev.command==="t"){const predictedControlPoint=reflectPoint(qControlPoint,item.base)
const realControlPoint=[data[0]+item.base[0],data[1]+item.base[1]]
if(Math.abs(predictedControlPoint[0]-realControlPoint[0])<error&&Math.abs(predictedControlPoint[1]-realControlPoint[1])<error){command="t"
data=data.slice(2)}}if(params.removeUseless&&!maybeHasStrokeAndLinecap){if((command==="l"||command==="h"||command==="v"||command==="q"||command==="t"||command==="c"||command==="s")&&data.every((function(i){return i===0}))){path[index]=prev
return false}if(command==="a"&&data[5]===0&&data[6]===0){path[index]=prev
return false}}if(params.convertToZ&&(isSafeToUseZ||next?.command==="Z"||next?.command==="z")&&(command==="l"||command==="h"||command==="v")&&Math.abs(pathBase[0]-item.coords[0])<error&&Math.abs(pathBase[1]-item.coords[1])<error){command="z"
data=[]}item.command=command
item.args=data}else{relSubpoint[0]=pathBase[0]
relSubpoint[1]=pathBase[1]
if(prev.command==="Z"||prev.command==="z")return false}if((command==="Z"||command==="z")&&params.removeUseless&&isSafeToUseZ&&Math.abs(item.base[0]-item.coords[0])<error/10&&Math.abs(item.base[1]-item.coords[1])<error/10)return false
prevQControlPoint=command==="q"?[data[0]+item.base[0],data[1]+item.base[1]]:command==="t"?qControlPoint?reflectPoint(qControlPoint,item.base):item.coords:void 0
prev=item
return true}))
return path}function convertToMixed(path,params){let prev=path[0]
path=path.filter((function(item,index){if(index==0)return true
if(item.command==="Z"||item.command==="z"){prev=item
return true}const command=item.command
const data=item.args
const adata=data.slice()
const rdata=data.slice()
if(command==="m"||command==="l"||command==="t"||command==="q"||command==="s"||command==="c")for(let i=adata.length;i--;)adata[i]+=item.base[i%2]
else if(command=="h")adata[0]+=item.base[0]
else if(command=="v")adata[0]+=item.base[1]
else if(command=="a"){adata[5]+=item.base[0]
adata[6]+=item.base[1]}roundData(adata)
roundData(rdata)
const absoluteDataStr=cleanupOutData(adata,params)
const relativeDataStr=cleanupOutData(rdata,params)
if(params.forceAbsolutePath||absoluteDataStr.length<relativeDataStr.length&&!(params.negativeExtraSpace&&command==prev.command&&prev.command.charCodeAt(0)>96&&absoluteDataStr.length==relativeDataStr.length-1&&(data[0]<0||Math.floor(data[0])===0&&!Number.isInteger(data[0])&&prev.args[prev.args.length-1]%1))){item.command=command.toUpperCase()
item.args=adata}prev=item
return true}))
return path}function isConvex(data){const center=getIntersection([0,0,data[2],data[3],data[0],data[1],data[4],data[5]])
return center!=null&&data[2]<center[0]==center[0]<0&&data[3]<center[1]==center[1]<0&&data[4]<center[0]==center[0]<data[0]&&data[5]<center[1]==center[1]<data[1]}function getIntersection(coords){const a1=coords[1]-coords[3]
const b1=coords[2]-coords[0]
const c1=coords[0]*coords[3]-coords[2]*coords[1]
const a2=coords[5]-coords[7]
const b2=coords[6]-coords[4]
const c2=coords[4]*coords[7]-coords[5]*coords[6]
const denom=a1*b2-a2*b1
if(!denom)return
const cross=[(b1*c2-b2*c1)/denom,(a1*c2-a2*c1)/-denom]
if(!isNaN(cross[0])&&!isNaN(cross[1])&&isFinite(cross[0])&&isFinite(cross[1]))return cross}function strongRound(data){const precisionNum=precision||0
for(let i=data.length;i-- >0;){const fixed=toFixed(data[i],precisionNum)
if(fixed!==data[i]){const rounded=toFixed(data[i],precisionNum-1)
data[i]=toFixed(Math.abs(rounded-data[i]),precisionNum+1)>=error?fixed:rounded}}return data}function round(data){for(let i=data.length;i-- >0;)data[i]=Math.round(data[i])
return data}function isCurveStraightLine(data){let i=data.length-2
const a=-data[i+1]
const b=data[i]
const d=1/(a*a+b*b)
if(i<=1||!isFinite(d))return false
while((i-=2)>=0)if(Math.sqrt(Math.pow(a*data[i]+b*data[i+1],2)*d)>error)return false
return true}function calculateSagitta(data){if(data[3]===1)return
const[rx,ry]=data
if(Math.abs(rx-ry)>error)return
const chord=Math.hypot(data[5],data[6])
if(chord>rx*2)return
return rx-Math.sqrt(rx**2-0.25*chord**2)}function makeLonghand(item,data){switch(item.command){case"s":item.command="c"
break
case"t":item.command="q"
break}item.args.unshift(data[data.length-2]-data[data.length-4],data[data.length-1]-data[data.length-3])
return item}function getDistance(point1,point2){return Math.hypot(point1[0]-point2[0],point1[1]-point2[1])}function reflectPoint(controlPoint,base){return[2*base[0]-controlPoint[0],2*base[1]-controlPoint[1]]}function getCubicBezierPoint(curve,t){const sqrT=t*t
const cubT=sqrT*t
const mt=1-t
const sqrMt=mt*mt
return[3*sqrMt*t*curve[0]+3*mt*sqrT*curve[2]+cubT*curve[4],3*sqrMt*t*curve[1]+3*mt*sqrT*curve[3]+cubT*curve[5]]}function findCircle(curve){const midPoint=getCubicBezierPoint(curve,.5)
const m1=[midPoint[0]/2,midPoint[1]/2]
const m2=[(midPoint[0]+curve[4])/2,(midPoint[1]+curve[5])/2]
const center=getIntersection([m1[0],m1[1],m1[0]+m1[1],m1[1]-m1[0],m2[0],m2[1],m2[0]+(m2[1]-midPoint[1]),m2[1]-(m2[0]-midPoint[0])])
const radius=center&&getDistance([0,0],center)
const tolerance=Math.min(arcThreshold*error,arcTolerance*radius/100)
if(center&&radius<1e15&&[1/4,3/4].every((function(point){return Math.abs(getDistance(getCubicBezierPoint(curve,point),center)-radius)<=tolerance})))return{center:center,radius:radius}}function isArc(curve,circle){const tolerance=Math.min(arcThreshold*error,arcTolerance*circle.radius/100)
return[0,1/4,.5,3/4,1].every((function(point){return Math.abs(getDistance(getCubicBezierPoint(curve,point),circle.center)-circle.radius)<=tolerance}))}function isArcPrev(curve,circle){return isArc(curve,{center:[circle.center[0]+curve[4],circle.center[1]+curve[5]],radius:circle.radius})}function findArcAngle(curve,relCircle){const x1=-relCircle.center[0]
const y1=-relCircle.center[1]
const x2=curve[4]-relCircle.center[0]
const y2=curve[5]-relCircle.center[1]
return Math.acos((x1*x2+y1*y2)/Math.sqrt((x1*x1+y1*y1)*(x2*x2+y2*y2)))}function data2Path(params,pathData){return pathData.reduce((function(pathString,item){let strData=""
item.args&&(strData=cleanupOutData(roundData(item.args.slice()),params))
return pathString+item.command+strData}),"")}var convertPathData=Object.freeze({__proto__:null,description:description$r,fn:fn$r,name:name$r})
const name$q="convertTransform"
const description$q="collapses multiple transformations and optimizes it"
const fn$q=(_root,params)=>{const{convertToShorts:convertToShorts=true,degPrecision:degPrecision,floatPrecision:floatPrecision=3,transformPrecision:transformPrecision=5,matrixToTransform:matrixToTransform=true,shortTranslate:shortTranslate=true,shortScale:shortScale=true,shortRotate:shortRotate=true,removeUseless:removeUseless=true,collapseIntoOne:collapseIntoOne=true,leadingZero:leadingZero=true,negativeExtraSpace:negativeExtraSpace=false}=params
const newParams={convertToShorts:convertToShorts,degPrecision:degPrecision,floatPrecision:floatPrecision,transformPrecision:transformPrecision,matrixToTransform:matrixToTransform,shortTranslate:shortTranslate,shortScale:shortScale,shortRotate:shortRotate,removeUseless:removeUseless,collapseIntoOne:collapseIntoOne,leadingZero:leadingZero,negativeExtraSpace:negativeExtraSpace}
return{element:{enter:node=>{node.attributes.transform!=null&&convertTransform(node,"transform",newParams)
node.attributes.gradientTransform!=null&&convertTransform(node,"gradientTransform",newParams)
node.attributes.patternTransform!=null&&convertTransform(node,"patternTransform",newParams)}}}}
const convertTransform=(item,attrName,params)=>{let data=transform2js(item.attributes[attrName])
params=definePrecision(data,params)
params.collapseIntoOne&&data.length>1&&(data=[transformsMultiply(data)])
params.convertToShorts?data=convertToShorts(data,params):data.forEach((item=>roundTransform(item,params)))
params.removeUseless&&(data=removeUseless(data))
data.length?item.attributes[attrName]=js2transform(data,params):delete item.attributes[attrName]}
const definePrecision=(data,{...newParams})=>{const matrixData=[]
for(const item of data)item.name=="matrix"&&matrixData.push(...item.data.slice(0,4))
let numberOfDigits=newParams.transformPrecision
if(matrixData.length){newParams.transformPrecision=Math.min(newParams.transformPrecision,Math.max.apply(Math,matrixData.map(floatDigits))||newParams.transformPrecision)
numberOfDigits=Math.max.apply(Math,matrixData.map((n=>n.toString().replace(/\D+/g,"").length)))}newParams.degPrecision==null&&(newParams.degPrecision=Math.max(0,Math.min(newParams.floatPrecision,numberOfDigits-2)))
return newParams}
const floatDigits=n=>{const str=n.toString()
return str.slice(str.indexOf(".")).length-1}
const convertToShorts=(transforms,params)=>{for(let i=0;i<transforms.length;i++){let transform=transforms[i]
if(params.matrixToTransform&&transform.name==="matrix"){const decomposed=matrixToTransform(transform,params)
js2transform(decomposed,params).length<=js2transform([transform],params).length&&transforms.splice(i,1,...decomposed)
transform=transforms[i]}roundTransform(transform,params)
params.shortTranslate&&transform.name==="translate"&&transform.data.length===2&&!transform.data[1]&&transform.data.pop()
params.shortScale&&transform.name==="scale"&&transform.data.length===2&&transform.data[0]===transform.data[1]&&transform.data.pop()
if(params.shortRotate&&transforms[i-2]?.name==="translate"&&transforms[i-1].name==="rotate"&&transforms[i].name==="translate"&&transforms[i-2].data[0]===-transforms[i].data[0]&&transforms[i-2].data[1]===-transforms[i].data[1]){transforms.splice(i-2,3,{name:"rotate",data:[transforms[i-1].data[0],transforms[i-2].data[0],transforms[i-2].data[1]]})
i-=2}}return transforms}
const removeUseless=transforms=>transforms.filter((transform=>{if(["translate","rotate","skewX","skewY"].indexOf(transform.name)>-1&&(transform.data.length==1||transform.name=="rotate")&&!transform.data[0]||transform.name=="translate"&&!transform.data[0]&&!transform.data[1]||transform.name=="scale"&&transform.data[0]==1&&(transform.data.length<2||transform.data[1]==1)||transform.name=="matrix"&&transform.data[0]==1&&transform.data[3]==1&&!(transform.data[1]||transform.data[2]||transform.data[4]||transform.data[5]))return false
return true}))
var convertTransform$1=Object.freeze({__proto__:null,description:description$q,fn:fn$q,name:name$q})
const name$p="removeEmptyAttrs"
const description$p="removes empty attributes"
const fn$p=()=>({element:{enter:node=>{for(const[name,value]of Object.entries(node.attributes))value!==""||attrsGroups.conditionalProcessing.has(name)||delete node.attributes[name]}}})
var removeEmptyAttrs=Object.freeze({__proto__:null,description:description$p,fn:fn$p,name:name$p})
const name$o="removeEmptyContainers"
const description$o="removes empty container elements"
const fn$o=root=>{const stylesheet=collectStylesheet(root)
return{element:{exit:(node,parentNode)=>{if(node.name==="svg"||!elemsGroups.container.has(node.name)||node.children.length!==0)return
if(node.name==="pattern"&&Object.keys(node.attributes).length!==0)return
if(node.name==="mask"&&node.attributes.id!=null)return
if(parentNode.type==="element"&&parentNode.name==="switch")return
if(node.name==="g"&&(node.attributes.filter!=null||computeStyle(stylesheet,node).filter))return
detachNodeFromParent(node,parentNode)}}}}
var removeEmptyContainers=Object.freeze({__proto__:null,description:description$o,fn:fn$o,name:name$o})
const name$n="mergePaths"
const description$n="merges multiple paths in one if possible"
function elementHasUrl(computedStyle,attName){const style=computedStyle[attName]
if(style?.type==="static")return includesUrlReference(style.value)
return false}const fn$n=(root,params)=>{const{force:force=false,floatPrecision:floatPrecision=3,noSpaceAfterFlags:noSpaceAfterFlags=false}=params
const stylesheet=collectStylesheet(root)
return{element:{enter:node=>{if(node.children.length<=1)return
const elementsToRemove=[]
let prevChild=node.children[0]
let prevPathData=null
const updatePreviousPath=(child,pathData)=>{js2path(child,pathData,{floatPrecision:floatPrecision,noSpaceAfterFlags:noSpaceAfterFlags})
prevPathData=null}
for(let i=1;i<node.children.length;i++){const child=node.children[i]
if(prevChild.type!=="element"||prevChild.name!=="path"||prevChild.children.length!==0||prevChild.attributes.d==null){prevPathData&&prevChild.type==="element"&&updatePreviousPath(prevChild,prevPathData)
prevChild=child
continue}if(child.type!=="element"||child.name!=="path"||child.children.length!==0||child.attributes.d==null){prevPathData&&updatePreviousPath(prevChild,prevPathData)
prevChild=child
continue}const computedStyle=computeStyle(stylesheet,child)
if(computedStyle["marker-start"]||computedStyle["marker-mid"]||computedStyle["marker-end"]||computedStyle["clip-path"]||computedStyle["mask"]||computedStyle["mask-image"]||["fill","filter","stroke"].some((attName=>elementHasUrl(computedStyle,attName)))){prevPathData&&updatePreviousPath(prevChild,prevPathData)
prevChild=child
continue}const childAttrs=Object.keys(child.attributes)
if(childAttrs.length!==Object.keys(prevChild.attributes).length){prevPathData&&updatePreviousPath(prevChild,prevPathData)
prevChild=child
continue}const areAttrsEqual=childAttrs.some((attr=>attr!=="d"&&prevChild.type==="element"&&prevChild.attributes[attr]!==child.attributes[attr]))
if(areAttrsEqual){prevPathData&&updatePreviousPath(prevChild,prevPathData)
prevChild=child
continue}const hasPrevPath=prevPathData!=null
const currentPathData=path2js(child)
prevPathData=prevPathData??path2js(prevChild)
if(force||!intersects(prevPathData,currentPathData)){prevPathData.push(...currentPathData)
elementsToRemove.push(child)
continue}hasPrevPath&&updatePreviousPath(prevChild,prevPathData)
prevChild=child
prevPathData=null}prevPathData&&prevChild.type==="element"&&updatePreviousPath(prevChild,prevPathData)
node.children=node.children.filter((child=>!elementsToRemove.includes(child)))}}}}
var mergePaths=Object.freeze({__proto__:null,description:description$n,fn:fn$n,name:name$n})
const name$m="removeUnusedNS"
const description$m="removes unused namespaces declaration"
const fn$m=()=>{const unusedNamespaces=new Set
return{element:{enter:(node,parentNode)=>{if(node.name==="svg"&&parentNode.type==="root")for(const name of Object.keys(node.attributes))if(name.startsWith("xmlns:")){const local=name.slice(6)
unusedNamespaces.add(local)}if(unusedNamespaces.size!==0){if(node.name.includes(":")){const[ns]=node.name.split(":")
unusedNamespaces.has(ns)&&unusedNamespaces.delete(ns)}for(const name of Object.keys(node.attributes))if(name.includes(":")){const[ns]=name.split(":")
unusedNamespaces.delete(ns)}}},exit:(node,parentNode)=>{if(node.name==="svg"&&parentNode.type==="root")for(const name of unusedNamespaces)delete node.attributes[`xmlns:${name}`]}}}}
var removeUnusedNS=Object.freeze({__proto__:null,description:description$m,fn:fn$m,name:name$m})
const name$l="sortAttrs"
const description$l="Sort element attributes for better compression"
const fn$l=(_root,params)=>{const{order:order=["id","width","height","x","x1","x2","y","y1","y2","cx","cy","r","fill","stroke","marker","d","points"],xmlnsOrder:xmlnsOrder="front"}=params
const getNsPriority=name=>{if(xmlnsOrder==="front"){if(name==="xmlns")return 3
if(name.startsWith("xmlns:"))return 2}if(name.includes(":"))return 1
return 0}
const compareAttrs=([aName],[bName])=>{const aPriority=getNsPriority(aName)
const bPriority=getNsPriority(bName)
const priorityNs=bPriority-aPriority
if(priorityNs!==0)return priorityNs
const[aPart]=aName.split("-")
const[bPart]=bName.split("-")
if(aPart!==bPart){const aInOrderFlag=order.includes(aPart)?1:0
const bInOrderFlag=order.includes(bPart)?1:0
if(aInOrderFlag===1&&bInOrderFlag===1)return order.indexOf(aPart)-order.indexOf(bPart)
const priorityOrder=bInOrderFlag-aInOrderFlag
if(priorityOrder!==0)return priorityOrder}return aName<bName?-1:1}
return{element:{enter:node=>{const attrs=Object.entries(node.attributes)
attrs.sort(compareAttrs)
const sortedAttributes={}
for(const[name,value]of attrs)sortedAttributes[name]=value
node.attributes=sortedAttributes}}}}
var sortAttrs=Object.freeze({__proto__:null,description:description$l,fn:fn$l,name:name$l})
const name$k="sortDefsChildren"
const description$k="Sorts children of <defs> to improve compression"
const fn$k=()=>({element:{enter:node=>{if(node.name==="defs"){const frequencies=new Map
for(const child of node.children)if(child.type==="element"){const frequency=frequencies.get(child.name)
frequency==null?frequencies.set(child.name,1):frequencies.set(child.name,frequency+1)}node.children.sort(((a,b)=>{if(a.type!=="element"||b.type!=="element")return 0
const aFrequency=frequencies.get(a.name)
const bFrequency=frequencies.get(b.name)
if(aFrequency!=null&&bFrequency!=null){const frequencyComparison=bFrequency-aFrequency
if(frequencyComparison!==0)return frequencyComparison}const lengthComparison=b.name.length-a.name.length
if(lengthComparison!==0)return lengthComparison
if(a.name!==b.name)return a.name>b.name?-1:1
return 0}))}}}})
var sortDefsChildren=Object.freeze({__proto__:null,description:description$k,fn:fn$k,name:name$k})
const name$j="removeDesc"
const description$j="removes <desc>"
const standardDescs=/^(Created with|Created using)/
const fn$j=(root,params)=>{const{removeAny:removeAny=false}=params
return{element:{enter:(node,parentNode)=>{node.name==="desc"&&(removeAny||node.children.length===0||node.children[0].type==="text"&&standardDescs.test(node.children[0].value))&&detachNodeFromParent(node,parentNode)}}}}
var removeDesc=Object.freeze({__proto__:null,description:description$j,fn:fn$j,name:name$j})
const presetDefault=createPreset({name:"preset-default",plugins:[removeDoctype,removeXMLProcInst,removeComments,removeDeprecatedAttrs,removeMetadata,removeEditorsNSData,cleanupAttrs,mergeStyles,inlineStyles,minifyStyles,cleanupIds,removeUselessDefs,cleanupNumericValues,convertColors,removeUnknownsAndDefaults,removeNonInheritableGroupAttrs,removeUselessStrokeAndFill,cleanupEnableBackground,removeHiddenElems,removeEmptyText,convertShapeToPath,convertEllipseToCircle,moveElemsAttrsToGroup,moveGroupAttrsToElems,collapseGroups,convertPathData,convertTransform$1,removeEmptyAttrs,removeEmptyContainers,mergePaths,removeUnusedNS,sortAttrs,sortDefsChildren,removeDesc]})
const name$i="addAttributesToSVGElement"
const description$i="adds attributes to an outer <svg> element"
const ENOCLS$1='Error in plugin "addAttributesToSVGElement": absent parameters.\nIt should have a list of "attributes" or one "attribute".\nConfig example:\n\nplugins: [\n  {\n    name: \'addAttributesToSVGElement\',\n    params: {\n      attribute: "mySvg"\n    }\n  }\n]\n\nplugins: [\n  {\n    name: \'addAttributesToSVGElement\',\n    params: {\n      attributes: ["mySvg", "size-big"]\n    }\n  }\n]\n\nplugins: [\n  {\n    name: \'addAttributesToSVGElement\',\n    params: {\n      attributes: [\n        {\n          focusable: false\n        },\n        {\n          \'data-image\': icon\n        }\n      ]\n    }\n  }\n]\n'
const fn$i=(root,params)=>{if(!Array.isArray(params.attributes)&&!params.attribute){console.error(ENOCLS$1)
return null}const attributes=params.attributes||[params.attribute]
return{element:{enter:(node,parentNode)=>{if(node.name==="svg"&&parentNode.type==="root")for(const attribute of attributes){typeof attribute==="string"&&node.attributes[attribute]==null&&(node.attributes[attribute]=void 0)
if(typeof attribute==="object")for(const key of Object.keys(attribute))node.attributes[key]==null&&(node.attributes[key]=attribute[key])}}}}}
var addAttributesToSVGElement=Object.freeze({__proto__:null,description:description$i,fn:fn$i,name:name$i})
const name$h="addClassesToSVGElement"
const description$h="adds classnames to an outer <svg> element"
const ENOCLS='Error in plugin "addClassesToSVGElement": absent parameters.\nIt should have a list of classes in "classNames" or one "className".\nConfig example:\n\nplugins: [\n  {\n    name: "addClassesToSVGElement",\n    params: {\n      className: "mySvg"\n    }\n  }\n]\n\nplugins: [\n  {\n    name: "addClassesToSVGElement",\n    params: {\n      classNames: ["mySvg", "size-big"]\n    }\n  }\n]\n'
const fn$h=(root,params,info)=>{if(!(Array.isArray(params.classNames)&&params.classNames.length!==0)&&!params.className){console.error(ENOCLS)
return null}const classNames=params.classNames||[params.className]
return{element:{enter:(node,parentNode)=>{if(node.name==="svg"&&parentNode.type==="root"){const classList=new Set(node.attributes.class==null?null:node.attributes.class.split(" "))
for(const className of classNames)if(className!=null){const classToAdd=typeof className==="string"?className:className(node,info)
classList.add(classToAdd)}node.attributes.class=Array.from(classList).join(" ")}}}}}
var addClassesToSVGElement=Object.freeze({__proto__:null,description:description$h,fn:fn$h,name:name$h})
const name$g="cleanupListOfValues"
const description$g="rounds list of values to the fixed precision"
const regNumericValues=/^([-+]?\d*\.?\d+([eE][-+]?\d+)?)(px|pt|pc|mm|cm|m|in|ft|em|ex|%)?$/
const regSeparator=/\s+,?\s*|,\s*/
const absoluteLengths={cm:96/2.54,mm:96/25.4,in:96,pt:4/3,pc:16,px:1}
const fn$g=(_root,params)=>{const{floatPrecision:floatPrecision=3,leadingZero:leadingZero=true,defaultPx:defaultPx=true,convertToPx:convertToPx=true}=params
const roundValues=lists=>{const roundedList=[]
for(const elem of lists.split(regSeparator)){const match=elem.match(regNumericValues)
const matchNew=elem.match(/new/)
if(match){let num=Number(Number(match[1]).toFixed(floatPrecision))
const matchedUnit=match[3]||""
let units=matchedUnit
if(convertToPx&&units&&units in absoluteLengths){const pxNum=Number((absoluteLengths[units]*Number(match[1])).toFixed(floatPrecision))
if(pxNum.toString().length<match[0].length){num=pxNum
units="px"}}let str
str=leadingZero?removeLeadingZero(num):num.toString()
defaultPx&&units==="px"&&(units="")
roundedList.push(str+units)}else matchNew?roundedList.push("new"):elem&&roundedList.push(elem)}return roundedList.join(" ")}
return{element:{enter:node=>{node.attributes.points!=null&&(node.attributes.points=roundValues(node.attributes.points))
node.attributes["enable-background"]!=null&&(node.attributes["enable-background"]=roundValues(node.attributes["enable-background"]))
node.attributes.viewBox!=null&&(node.attributes.viewBox=roundValues(node.attributes.viewBox))
node.attributes["stroke-dasharray"]!=null&&(node.attributes["stroke-dasharray"]=roundValues(node.attributes["stroke-dasharray"]))
node.attributes.dx!=null&&(node.attributes.dx=roundValues(node.attributes.dx))
node.attributes.dy!=null&&(node.attributes.dy=roundValues(node.attributes.dy))
node.attributes.x!=null&&(node.attributes.x=roundValues(node.attributes.x))
node.attributes.y!=null&&(node.attributes.y=roundValues(node.attributes.y))}}}}
var cleanupListOfValues=Object.freeze({__proto__:null,description:description$g,fn:fn$g,name:name$g})
const name$f="convertOneStopGradients"
const description$f="converts one-stop (single color) gradients to a plain color"
const fn$f=root=>{const stylesheet=collectStylesheet(root)
const effectedDefs=new Set
const allDefs=new Map
const gradientsToDetach=new Map
let xlinkHrefCount=0
return{element:{enter:(node,parentNode)=>{node.attributes["xlink:href"]!=null&&xlinkHrefCount++
if(node.name==="defs"){allDefs.set(node,parentNode)
return}if(node.name!=="linearGradient"&&node.name!=="radialGradient")return
const stops=node.children.filter((child=>child.type==="element"&&child.name==="stop"))
const href=node.attributes["xlink:href"]||node.attributes["href"]
const effectiveNode=stops.length===0&&href!=null&&href.startsWith("#")?querySelector(root,href):node
if(effectiveNode==null||effectiveNode.type!=="element"){gradientsToDetach.set(node,parentNode)
return}const effectiveStops=effectiveNode.children.filter((child=>child.type==="element"&&child.name==="stop"))
if(effectiveStops.length!==1||effectiveStops[0].type!=="element")return
parentNode.type==="element"&&parentNode.name==="defs"&&effectedDefs.add(parentNode)
gradientsToDetach.set(node,parentNode)
let color
const style=computeStyle(stylesheet,effectiveStops[0])["stop-color"]
style!=null&&style.type==="static"&&(color=style.value)
const selectorVal=`url(#${node.attributes.id})`
const selector=[...colorsProps].map((attr=>`[${attr}="${selectorVal}"]`)).join(",")
const elements=querySelectorAll(root,selector)
for(const element of elements){if(element.type!=="element")continue
for(const attr of colorsProps){if(element.attributes[attr]!==selectorVal)continue
color!=null?element.attributes[attr]=color:delete element.attributes[attr]}}const styledElements=querySelectorAll(root,`[style*=${selectorVal}]`)
for(const element of styledElements){if(element.type!=="element")continue
element.attributes.style=element.attributes.style.replace(selectorVal,color||attrsGroupsDefaults.presentation["stop-color"])}},exit:node=>{if(node.name==="svg"){for(const[gradient,parent]of gradientsToDetach.entries()){gradient.attributes["xlink:href"]!=null&&xlinkHrefCount--
detachNodeFromParent(gradient,parent)}xlinkHrefCount===0&&delete node.attributes["xmlns:xlink"]
for(const[defs,parent]of allDefs.entries())effectedDefs.has(defs)&&defs.children.length===0&&detachNodeFromParent(defs,parent)}}}}}
var convertOneStopGradients=Object.freeze({__proto__:null,description:description$f,fn:fn$f,name:name$f})
const name$e="convertStyleToAttrs"
const description$e="converts style to attributes"
const g=(...args)=>"(?:"+args.join("|")+")"
const stylingProps=attrsGroups.presentation
const rEscape="\\\\(?:[0-9a-f]{1,6}\\s?|\\r\\n|.)"
const rAttr="\\s*("+g("[^:;\\\\]",rEscape)+"*?)\\s*"
const rSingleQuotes="'(?:[^'\\n\\r\\\\]|"+rEscape+")*?(?:'|$)"
const rQuotes='"(?:[^"\\n\\r\\\\]|'+rEscape+')*?(?:"|$)'
const rQuotedString=new RegExp("^"+g(rSingleQuotes,rQuotes)+"$")
const rParenthesis="\\("+g("[^'\"()\\\\]+",rEscape,rSingleQuotes,rQuotes)+"*?\\)"
const rValue="\\s*("+g("[^!'\"();\\\\]+?",rEscape,rSingleQuotes,rQuotes,rParenthesis,"[^;]*?")+"*?)"
const rDeclEnd="\\s*(?:;\\s*|$)"
const rImportant="(\\s*!important(?![-(\\w]))?"
const regDeclarationBlock=new RegExp(rAttr+":"+rValue+rImportant+rDeclEnd,"ig")
const regStripComments=new RegExp(g(rEscape,rSingleQuotes,rQuotes,"/\\*[^]*?\\*/"),"ig")
const fn$e=(_root,params)=>{const{keepImportant:keepImportant=false}=params
return{element:{enter:node=>{if(node.attributes.style!=null){let styles=[]
const newAttributes={}
const styleValue=node.attributes.style.replace(regStripComments,(match=>match[0]=="/"?"":match[0]=="\\"&&/[-g-z]/i.test(match[1])?match[1]:match))
regDeclarationBlock.lastIndex=0
for(var rule;rule=regDeclarationBlock.exec(styleValue);)keepImportant&&rule[3]||styles.push([rule[1],rule[2]])
if(styles.length){styles=styles.filter((function(style){if(style[0]){const prop=style[0].toLowerCase()
let val=style[1]
rQuotedString.test(val)&&(val=val.slice(1,-1))
if(stylingProps.has(prop)){newAttributes[prop]=val
return false}}return true}))
Object.assign(node.attributes,newAttributes)
styles.length?node.attributes.style=styles.map((declaration=>declaration.join(":"))).join(";"):delete node.attributes.style}}}}}}
var convertStyleToAttrs=Object.freeze({__proto__:null,description:description$e,fn:fn$e,name:name$e})
const name$d="prefixIds"
const description$d="prefix IDs"
const getBasename=path=>{const matched=/[/\\]?([^/\\]+)$/.exec(path)
if(matched)return matched[1]
return""}
const escapeIdentifierName=str=>str.replace(/[. ]/g,"_")
const unquote=string=>{if(string.startsWith('"')&&string.endsWith('"')||string.startsWith("'")&&string.endsWith("'"))return string.slice(1,-1)
return string}
const prefixId=(prefixGenerator,body)=>{const prefix=prefixGenerator(body)
if(body.startsWith(prefix))return body
return prefix+body}
const prefixReference=(prefixGenerator,reference)=>{if(reference.startsWith("#"))return"#"+prefixId(prefixGenerator,reference.slice(1))
return null}
const generatePrefix=(body,node,info,prefixGenerator,delim,history)=>{if(typeof prefixGenerator==="function"){let prefix=history.get(body)
if(prefix!=null)return prefix
prefix=prefixGenerator(node,info)+delim
history.set(body,prefix)
return prefix}if(typeof prefixGenerator==="string")return prefixGenerator+delim
if(prefixGenerator===false)return""
if(info.path!=null&&info.path.length>0)return escapeIdentifierName(getBasename(info.path))+delim
return"prefix"+delim}
const fn$d=(_root,params,info)=>{const{delim:delim="__",prefix:prefix,prefixIds:prefixIds=true,prefixClassNames:prefixClassNames=true}=params
const prefixMap=new Map
return{element:{enter:node=>{const prefixGenerator=id=>generatePrefix(id,node,info,prefix,delim,prefixMap)
if(node.name==="style"){if(node.children.length===0)return
for(const child of node.children){if(child.type!=="text"&&child.type!=="cdata")continue
const cssText=child.value
let cssAst
try{cssAst=parse$I(cssText,{parseValue:true,parseCustomProperty:false})}catch{return}walk$3(cssAst,(node=>{if(prefixIds&&node.type==="IdSelector"||prefixClassNames&&node.type==="ClassSelector"){node.name=prefixId(prefixGenerator,node.name)
return}if(node.type==="Url"&&node.value.length>0){const prefixed=prefixReference(prefixGenerator,unquote(node.value))
prefixed!=null&&(node.value=prefixed)}}))
child.value=generate$I(cssAst)}}prefixIds&&node.attributes.id!=null&&node.attributes.id.length!==0&&(node.attributes.id=prefixId(prefixGenerator,node.attributes.id))
prefixClassNames&&node.attributes.class!=null&&node.attributes.class.length!==0&&(node.attributes.class=node.attributes.class.split(/\s+/).map((name=>prefixId(prefixGenerator,name))).join(" "))
for(const name of["href","xlink:href"])if(node.attributes[name]!=null&&node.attributes[name].length!==0){const prefixed=prefixReference(prefixGenerator,node.attributes[name])
prefixed!=null&&(node.attributes[name]=prefixed)}for(const name of referencesProps)node.attributes[name]!=null&&node.attributes[name].length!==0&&(node.attributes[name]=node.attributes[name].replace(/\burl\((["'])?(#.+?)\1\)/gi,((match,_,url)=>{const prefixed=prefixReference(prefixGenerator,url)
if(prefixed==null)return match
return`url(${prefixed})`})))
for(const name of["begin","end"])if(node.attributes[name]!=null&&node.attributes[name].length!==0){const parts=node.attributes[name].split(/\s*;\s+/).map((val=>{if(val.endsWith(".end")||val.endsWith(".start")){const[id,postfix]=val.split(".")
return`${prefixId(prefixGenerator,id)}.${postfix}`}return val}))
node.attributes[name]=parts.join("; ")}}}}}
var prefixIds=Object.freeze({__proto__:null,description:description$d,fn:fn$d,name:name$d})
const name$c="removeAttributesBySelector"
const description$c="removes attributes of elements that match a css selector"
const fn$c=(root,params)=>{const selectors=Array.isArray(params.selectors)?params.selectors:[params]
for(const{selector:selector,attributes:attributes}of selectors){const nodes=querySelectorAll(root,selector)
for(const node of nodes)if(node.type==="element")if(Array.isArray(attributes))for(const name of attributes)delete node.attributes[name]
else delete node.attributes[attributes]}return{}}
var removeAttributesBySelector=Object.freeze({__proto__:null,description:description$c,fn:fn$c,name:name$c})
const name$b="removeAttrs"
const description$b="removes specified attributes"
const DEFAULT_SEPARATOR=":"
const ENOATTRS='Warning: The plugin "removeAttrs" requires the "attrs" parameter.\nIt should have a pattern to remove, otherwise the plugin is a noop.\nConfig example:\n\nplugins: [\n  {\n    name: "removeAttrs",\n    params: {\n      attrs: "(fill|stroke)"\n    }\n  }\n]\n'
const fn$b=(root,params)=>{if(typeof params.attrs=="undefined"){console.warn(ENOATTRS)
return null}const elemSeparator=typeof params.elemSeparator=="string"?params.elemSeparator:DEFAULT_SEPARATOR
const preserveCurrentColor=typeof params.preserveCurrentColor=="boolean"&&params.preserveCurrentColor
const attrs=Array.isArray(params.attrs)?params.attrs:[params.attrs]
return{element:{enter:node=>{for(let pattern of attrs){pattern.includes(elemSeparator)?pattern.split(elemSeparator).length<3&&(pattern=[pattern,".*"].join(elemSeparator)):pattern=[".*",pattern,".*"].join(elemSeparator)
const list=pattern.split(elemSeparator).map((value=>{value==="*"&&(value=".*")
return new RegExp(["^",value,"$"].join(""),"i")}))
if(list[0].test(node.name))for(const[name,value]of Object.entries(node.attributes)){const isCurrentColor=value.toLowerCase()==="currentcolor"
const isFillCurrentColor=preserveCurrentColor&&name=="fill"&&isCurrentColor
const isStrokeCurrentColor=preserveCurrentColor&&name=="stroke"&&isCurrentColor
!isFillCurrentColor&&!isStrokeCurrentColor&&list[1].test(name)&&list[2].test(value)&&delete node.attributes[name]}}}}}}
var removeAttrs=Object.freeze({__proto__:null,description:description$b,fn:fn$b,name:name$b})
const name$a="removeDimensions"
const description$a="removes width and height in presence of viewBox (opposite to removeViewBox)"
const fn$a=()=>({element:{enter:node=>{if(node.name==="svg")if(node.attributes.viewBox!=null){delete node.attributes.width
delete node.attributes.height}else if(node.attributes.width!=null&&node.attributes.height!=null&&Number.isNaN(Number(node.attributes.width))===false&&Number.isNaN(Number(node.attributes.height))===false){const width=Number(node.attributes.width)
const height=Number(node.attributes.height)
node.attributes.viewBox=`0 0 ${width} ${height}`
delete node.attributes.width
delete node.attributes.height}}}})
var removeDimensions=Object.freeze({__proto__:null,description:description$a,fn:fn$a,name:name$a})
const name$9="removeElementsByAttr"
const description$9="removes arbitrary elements by ID or className (disabled by default)"
const fn$9=(root,params)=>{const ids=params.id==null?[]:Array.isArray(params.id)?params.id:[params.id]
const classes=params.class==null?[]:Array.isArray(params.class)?params.class:[params.class]
return{element:{enter:(node,parentNode)=>{node.attributes.id!=null&&ids.length!==0&&ids.includes(node.attributes.id)&&detachNodeFromParent(node,parentNode)
if(node.attributes.class&&classes.length!==0){const classList=node.attributes.class.split(" ")
for(const item of classes)if(classList.includes(item)){detachNodeFromParent(node,parentNode)
break}}}}}}
var removeElementsByAttr=Object.freeze({__proto__:null,description:description$9,fn:fn$9,name:name$9})
const name$8="removeOffCanvasPaths"
const description$8="removes elements that are drawn outside of the viewBox (disabled by default)"
const fn$8=()=>{let viewBoxData=null
return{element:{enter:(node,parentNode)=>{if(node.name==="svg"&&parentNode.type==="root"){let viewBox=""
node.attributes.viewBox!=null?viewBox=node.attributes.viewBox:node.attributes.height!=null&&node.attributes.width!=null&&(viewBox=`0 0 ${node.attributes.width} ${node.attributes.height}`)
viewBox=viewBox.replace(/[,+]|px/g," ").replace(/\s+/g," ").replace(/^\s*|\s*$/g,"")
const m=/^(-?\d*\.?\d+) (-?\d*\.?\d+) (\d*\.?\d+) (\d*\.?\d+)$/.exec(viewBox)
if(m==null)return
const left=Number.parseFloat(m[1])
const top=Number.parseFloat(m[2])
const width=Number.parseFloat(m[3])
const height=Number.parseFloat(m[4])
viewBoxData={left:left,top:top,right:left+width,bottom:top+height,width:width,height:height}}if(node.attributes.transform!=null)return visitSkip
if(node.name==="path"&&node.attributes.d!=null&&viewBoxData!=null){const pathData=parsePathData(node.attributes.d)
let visible=false
for(const pathDataItem of pathData)if(pathDataItem.command==="M"){const[x,y]=pathDataItem.args
x>=viewBoxData.left&&x<=viewBoxData.right&&y>=viewBoxData.top&&y<=viewBoxData.bottom&&(visible=true)}if(visible)return
pathData.length===2&&pathData.push({command:"z",args:[]})
const{left:left,top:top,width:width,height:height}=viewBoxData
const viewBoxPathData=[{command:"M",args:[left,top]},{command:"h",args:[width]},{command:"v",args:[height]},{command:"H",args:[left]},{command:"z",args:[]}]
intersects(viewBoxPathData,pathData)===false&&detachNodeFromParent(node,parentNode)}}}}}
var removeOffCanvasPaths=Object.freeze({__proto__:null,description:description$8,fn:fn$8,name:name$8})
const name$7="removeRasterImages"
const description$7="removes raster images (disabled by default)"
const fn$7=()=>({element:{enter:(node,parentNode)=>{node.name==="image"&&node.attributes["xlink:href"]!=null&&/(\.|image\/)(jpe?g|png|gif)/.test(node.attributes["xlink:href"])&&detachNodeFromParent(node,parentNode)}}})
var removeRasterImages=Object.freeze({__proto__:null,description:description$7,fn:fn$7,name:name$7})
const name$6="removeScripts"
const description$6="removes scripts (disabled by default)"
const eventAttrs=[...attrsGroups.animationEvent,...attrsGroups.documentEvent,...attrsGroups.documentElementEvent,...attrsGroups.globalEvent,...attrsGroups.graphicalEvent]
const fn$6=()=>({element:{enter:(node,parentNode)=>{if(node.name==="script"){detachNodeFromParent(node,parentNode)
return}for(const attr of eventAttrs)node.attributes[attr]!=null&&delete node.attributes[attr]},exit:(node,parentNode)=>{if(node.name!=="a")return
for(const attr of Object.keys(node.attributes))if(attr==="href"||attr.endsWith(":href")){if(node.attributes[attr]==null||!node.attributes[attr].trimStart().startsWith("javascript:"))continue
const index=parentNode.children.indexOf(node)
const usefulChildren=node.children.filter((child=>child.type!=="text"))
parentNode.children.splice(index,1,...usefulChildren)}}}})
var removeScripts=Object.freeze({__proto__:null,description:description$6,fn:fn$6,name:name$6})
const name$5="removeStyleElement"
const description$5="removes <style> element (disabled by default)"
const fn$5=()=>({element:{enter:(node,parentNode)=>{node.name==="style"&&detachNodeFromParent(node,parentNode)}}})
var removeStyleElement=Object.freeze({__proto__:null,description:description$5,fn:fn$5,name:name$5})
const name$4="removeTitle"
const description$4="removes <title>"
const fn$4=()=>({element:{enter:(node,parentNode)=>{node.name==="title"&&detachNodeFromParent(node,parentNode)}}})
var removeTitle=Object.freeze({__proto__:null,description:description$4,fn:fn$4,name:name$4})
const name$3="removeViewBox"
const description$3="removes viewBox attribute when possible"
const viewBoxElems=new Set(["pattern","svg","symbol"])
const fn$3=()=>({element:{enter:(node,parentNode)=>{if(viewBoxElems.has(node.name)&&node.attributes.viewBox!=null&&node.attributes.width!=null&&node.attributes.height!=null){if(node.name==="svg"&&parentNode.type!=="root")return
const nums=node.attributes.viewBox.split(/[ ,]+/g)
nums[0]==="0"&&nums[1]==="0"&&node.attributes.width.replace(/px$/,"")===nums[2]&&node.attributes.height.replace(/px$/,"")===nums[3]&&delete node.attributes.viewBox}}}})
var removeViewBox=Object.freeze({__proto__:null,description:description$3,fn:fn$3,name:name$3})
const name$2="removeXlink"
const description$2="remove xlink namespace and replaces attributes with the SVG 2 equivalent where applicable"
const XLINK_NAMESPACE="http://www.w3.org/1999/xlink"
const SHOW_TO_TARGET={new:"_blank",replace:"_self"}
const LEGACY_ELEMENTS=new Set(["cursor","filter","font-face-uri","glyphRef","tref"])
const findPrefixedAttrs=(node,prefixes,attr)=>prefixes.map((prefix=>`${prefix}:${attr}`)).filter((attr=>node.attributes[attr]!=null))
const fn$2=(_,params)=>{const{includeLegacy:includeLegacy}=params
const xlinkPrefixes=[]
const overriddenPrefixes=[]
const usedInLegacyElement=[]
return{element:{enter:node=>{for(const[key,value]of Object.entries(node.attributes))if(key.startsWith("xmlns:")){const prefix=key.split(":",2)[1]
if(value===XLINK_NAMESPACE){xlinkPrefixes.push(prefix)
continue}xlinkPrefixes.includes(prefix)&&overriddenPrefixes.push(prefix)}if(overriddenPrefixes.some((prefix=>xlinkPrefixes.includes(prefix))))return
const showAttrs=findPrefixedAttrs(node,xlinkPrefixes,"show")
let showHandled=node.attributes.target!=null
for(let i=showAttrs.length-1;i>=0;i--){const attr=showAttrs[i]
const value=node.attributes[attr]
const mapping=SHOW_TO_TARGET[value]
if(showHandled||mapping==null){delete node.attributes[attr]
continue}mapping!==elems[node.name]?.defaults?.target&&(node.attributes.target=mapping)
delete node.attributes[attr]
showHandled=true}const titleAttrs=findPrefixedAttrs(node,xlinkPrefixes,"title")
for(let i=titleAttrs.length-1;i>=0;i--){const attr=titleAttrs[i]
const value=node.attributes[attr]
const hasTitle=node.children.filter((child=>child.type==="element"&&child.name==="title"))
if(hasTitle.length>0){delete node.attributes[attr]
continue}const titleTag={type:"element",name:"title",attributes:{},children:[{type:"text",value:value}]}
Object.defineProperty(titleTag,"parentNode",{writable:true,value:node})
node.children.unshift(titleTag)
delete node.attributes[attr]}const hrefAttrs=findPrefixedAttrs(node,xlinkPrefixes,"href")
if(hrefAttrs.length>0&&LEGACY_ELEMENTS.has(node.name)&&!includeLegacy){hrefAttrs.map((attr=>attr.split(":",1)[0])).forEach((prefix=>usedInLegacyElement.push(prefix)))
return}for(let i=hrefAttrs.length-1;i>=0;i--){const attr=hrefAttrs[i]
const value=node.attributes[attr]
if(node.attributes.href!=null){delete node.attributes[attr]
continue}node.attributes.href=value
delete node.attributes[attr]}},exit:node=>{for(const[key,value]of Object.entries(node.attributes)){const[prefix,attr]=key.split(":",2)
if(xlinkPrefixes.includes(prefix)&&!overriddenPrefixes.includes(prefix)&&!usedInLegacyElement.includes(prefix)&&!includeLegacy){delete node.attributes[key]
continue}if(key.startsWith("xmlns:")&&!usedInLegacyElement.includes(attr)){if(value===XLINK_NAMESPACE){const index=xlinkPrefixes.indexOf(attr)
xlinkPrefixes.splice(index,1)
delete node.attributes[key]
continue}if(overriddenPrefixes.includes(prefix)){const index=overriddenPrefixes.indexOf(attr)
overriddenPrefixes.splice(index,1)}}}}}}}
var removeXlink=Object.freeze({__proto__:null,description:description$2,fn:fn$2,name:name$2})
const name$1="removeXMLNS"
const description$1="removes xmlns attribute (for inline svg, disabled by default)"
const fn$1=()=>({element:{enter:node=>{node.name==="svg"&&delete node.attributes.xmlns}}})
var removeXMLNS=Object.freeze({__proto__:null,description:description$1,fn:fn$1,name:name$1})
const name="reusePaths"
const description="Finds <path> elements with the same d, fill, and stroke, and converts them to <use> elements referencing a single <path> def."
const fn=root=>{const stylesheet=collectStylesheet(root)
const paths=new Map
let svgDefs
const hrefs=new Set
return{element:{enter:(node,parentNode)=>{if(node.name==="path"&&node.attributes.d!=null){const d=node.attributes.d
const fill=node.attributes.fill||""
const stroke=node.attributes.stroke||""
const key=d+";s:"+stroke+";f:"+fill
let list=paths.get(key)
if(list==null){list=[]
paths.set(key,list)}list.push(node)}svgDefs==null&&node.name==="defs"&&parentNode.type==="element"&&parentNode.name==="svg"&&(svgDefs=node)
if(node.name==="use")for(const name of["href","xlink:href"]){const href=node.attributes[name]
href!=null&&href.startsWith("#")&&href.length>1&&hrefs.add(href.slice(1))}},exit:(node,parentNode)=>{if(node.name==="svg"&&parentNode.type==="root"){let defsTag=svgDefs
defsTag==null&&(defsTag={type:"element",name:"defs",attributes:{},children:[]})
let index=0
for(const list of paths.values())if(list.length>1){const reusablePath={type:"element",name:"path",attributes:{},children:[]}
for(const attr of["fill","stroke","d"])list[0].attributes[attr]!=null&&(reusablePath.attributes[attr]=list[0].attributes[attr])
const originalId=list[0].attributes.id
if(originalId==null||hrefs.has(originalId)||stylesheet.rules.some((rule=>rule.selector===`#${originalId}`)))reusablePath.attributes.id="reuse-"+index++
else{reusablePath.attributes.id=originalId
delete list[0].attributes.id}defsTag.children.push(reusablePath)
for(const pathNode of list){delete pathNode.attributes.d
delete pathNode.attributes.stroke
delete pathNode.attributes.fill
if(defsTag.children.includes(pathNode)&&pathNode.children.length===0){if(Object.keys(pathNode.attributes).length===0){detachNodeFromParent(pathNode,defsTag)
continue}if(Object.keys(pathNode.attributes).length===1&&pathNode.attributes.id!=null){detachNodeFromParent(pathNode,defsTag)
const selector=`[xlink\\:href=#${pathNode.attributes.id}], [href=#${pathNode.attributes.id}]`
for(const child of querySelectorAll(node,selector)){if(child.type!=="element")continue
for(const name of["href","xlink:href"])child.attributes[name]!=null&&(child.attributes[name]="#"+reusablePath.attributes.id)}continue}}pathNode.name="use"
pathNode.attributes["xlink:href"]="#"+reusablePath.attributes.id}}if(defsTag.children.length!==0){node.attributes["xmlns:xlink"]==null&&(node.attributes["xmlns:xlink"]="http://www.w3.org/1999/xlink")
svgDefs==null&&node.children.unshift(defsTag)}}}}}}
var reusePaths=Object.freeze({__proto__:null,description:description,fn:fn,name:name})
const builtinPlugins=Object.freeze([presetDefault,addAttributesToSVGElement,addClassesToSVGElement,cleanupAttrs,cleanupEnableBackground,cleanupIds,cleanupListOfValues,cleanupNumericValues,collapseGroups,convertColors,convertEllipseToCircle,convertOneStopGradients,convertPathData,convertShapeToPath,convertStyleToAttrs,convertTransform$1,inlineStyles,mergePaths,mergeStyles,minifyStyles,moveElemsAttrsToGroup,moveGroupAttrsToElems,prefixIds,removeAttributesBySelector,removeAttrs,removeComments,removeDeprecatedAttrs,removeDesc,removeDimensions,removeDoctype,removeEditorsNSData,removeElementsByAttr,removeEmptyAttrs,removeEmptyContainers,removeEmptyText,removeHiddenElems,removeMetadata,removeNonInheritableGroupAttrs,removeOffCanvasPaths,removeRasterImages,removeScripts,removeStyleElement,removeTitle,removeUnknownsAndDefaults,removeUnusedNS,removeUselessDefs,removeUselessStrokeAndFill,removeViewBox,removeXlink,removeXMLNS,removeXMLProcInst,reusePaths,sortAttrs,sortDefsChildren])
var sax={};(function(exports){(function(sax){sax.parser=function(strict,opt){return new SAXParser(strict,opt)}
sax.SAXParser=SAXParser
sax.MAX_BUFFER_LENGTH=65536
var buffers=["comment","sgmlDecl","textNode","tagName","doctype","procInstName","procInstBody","entity","attribName","attribValue","cdata","script"]
sax.EVENTS=["text","processinginstruction","sgmldeclaration","doctype","comment","opentagstart","attribute","opentag","closetag","opencdata","cdata","closecdata","error","end","ready","script","opennamespace","closenamespace"]
function SAXParser(strict,opt){if(!(this instanceof SAXParser))return new SAXParser(strict,opt)
var parser=this
clearBuffers(parser)
parser.q=parser.c=""
parser.bufferCheckPosition=sax.MAX_BUFFER_LENGTH
parser.opt=opt||{}
parser.opt.lowercase=parser.opt.lowercase||parser.opt.lowercasetags
parser.looseCase=parser.opt.lowercase?"toLowerCase":"toUpperCase"
parser.tags=[]
parser.closed=parser.closedRoot=parser.sawRoot=false
parser.tag=parser.error=null
parser.strict=!!strict
parser.noscript=!!(strict||parser.opt.noscript)
parser.state=S.BEGIN
parser.strictEntities=parser.opt.strictEntities
parser.ENTITIES=parser.strictEntities?Object.create(sax.XML_ENTITIES):Object.create(sax.ENTITIES)
parser.attribList=[]
parser.opt.xmlns&&(parser.ns=Object.create(rootNS))
parser.opt.unquotedAttributeValues===void 0&&(parser.opt.unquotedAttributeValues=!strict)
parser.trackPosition=parser.opt.position!==false
parser.trackPosition&&(parser.position=parser.line=parser.column=0)
emit(parser,"onready")}Object.create||(Object.create=function(o){function F(){}F.prototype=o
var newf=new F
return newf})
Object.keys||(Object.keys=function(o){var a=[]
for(var i in o)o.hasOwnProperty(i)&&a.push(i)
return a})
function checkBufferLength(parser){var maxAllowed=Math.max(sax.MAX_BUFFER_LENGTH,10)
var maxActual=0
for(var i=0,l=buffers.length;i<l;i++){var len=parser[buffers[i]].length
if(len>maxAllowed)switch(buffers[i]){case"textNode":closeText(parser)
break
case"cdata":emitNode(parser,"oncdata",parser.cdata)
parser.cdata=""
break
case"script":emitNode(parser,"onscript",parser.script)
parser.script=""
break
default:error(parser,"Max buffer length exceeded: "+buffers[i])}maxActual=Math.max(maxActual,len)}var m=sax.MAX_BUFFER_LENGTH-maxActual
parser.bufferCheckPosition=m+parser.position}function clearBuffers(parser){for(var i=0,l=buffers.length;i<l;i++)parser[buffers[i]]=""}function flushBuffers(parser){closeText(parser)
if(parser.cdata!==""){emitNode(parser,"oncdata",parser.cdata)
parser.cdata=""}if(parser.script!==""){emitNode(parser,"onscript",parser.script)
parser.script=""}}SAXParser.prototype={end:function(){end(this)},write:write,resume:function(){this.error=null
return this},close:function(){return this.write(null)},flush:function(){flushBuffers(this)}}
var CDATA="[CDATA["
var DOCTYPE="DOCTYPE"
var XML_NAMESPACE="http://www.w3.org/XML/1998/namespace"
var XMLNS_NAMESPACE="http://www.w3.org/2000/xmlns/"
var rootNS={xml:XML_NAMESPACE,xmlns:XMLNS_NAMESPACE}
var nameStart=/[:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]/
var nameBody=/[:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\u00B7\u0300-\u036F\u203F-\u2040.\d-]/
var entityStart=/[#:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]/
var entityBody=/[#:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\u00B7\u0300-\u036F\u203F-\u2040.\d-]/
function isWhitespace(c){return c===" "||c==="\n"||c==="\r"||c==="\t"}function isQuote(c){return c==='"'||c==="'"}function isAttribEnd(c){return c===">"||isWhitespace(c)}function isMatch(regex,c){return regex.test(c)}function notMatch(regex,c){return!isMatch(regex,c)}var S=0
sax.STATE={BEGIN:S++,BEGIN_WHITESPACE:S++,TEXT:S++,TEXT_ENTITY:S++,OPEN_WAKA:S++,SGML_DECL:S++,SGML_DECL_QUOTED:S++,DOCTYPE:S++,DOCTYPE_QUOTED:S++,DOCTYPE_DTD:S++,DOCTYPE_DTD_QUOTED:S++,COMMENT_STARTING:S++,COMMENT:S++,COMMENT_ENDING:S++,COMMENT_ENDED:S++,CDATA:S++,CDATA_ENDING:S++,CDATA_ENDING_2:S++,PROC_INST:S++,PROC_INST_BODY:S++,PROC_INST_ENDING:S++,OPEN_TAG:S++,OPEN_TAG_SLASH:S++,ATTRIB:S++,ATTRIB_NAME:S++,ATTRIB_NAME_SAW_WHITE:S++,ATTRIB_VALUE:S++,ATTRIB_VALUE_QUOTED:S++,ATTRIB_VALUE_CLOSED:S++,ATTRIB_VALUE_UNQUOTED:S++,ATTRIB_VALUE_ENTITY_Q:S++,ATTRIB_VALUE_ENTITY_U:S++,CLOSE_TAG:S++,CLOSE_TAG_SAW_WHITE:S++,SCRIPT:S++,SCRIPT_ENDING:S++}
sax.XML_ENTITIES={amp:"&",gt:">",lt:"<",quot:'"',apos:"'"}
sax.ENTITIES={amp:"&",gt:">",lt:"<",quot:'"',apos:"'",AElig:198,Aacute:193,Acirc:194,Agrave:192,Aring:197,Atilde:195,Auml:196,Ccedil:199,ETH:208,Eacute:201,Ecirc:202,Egrave:200,Euml:203,Iacute:205,Icirc:206,Igrave:204,Iuml:207,Ntilde:209,Oacute:211,Ocirc:212,Ograve:210,Oslash:216,Otilde:213,Ouml:214,THORN:222,Uacute:218,Ucirc:219,Ugrave:217,Uuml:220,Yacute:221,aacute:225,acirc:226,aelig:230,agrave:224,aring:229,atilde:227,auml:228,ccedil:231,eacute:233,ecirc:234,egrave:232,eth:240,euml:235,iacute:237,icirc:238,igrave:236,iuml:239,ntilde:241,oacute:243,ocirc:244,ograve:242,oslash:248,otilde:245,ouml:246,szlig:223,thorn:254,uacute:250,ucirc:251,ugrave:249,uuml:252,yacute:253,yuml:255,copy:169,reg:174,nbsp:160,iexcl:161,cent:162,pound:163,curren:164,yen:165,brvbar:166,sect:167,uml:168,ordf:170,laquo:171,not:172,shy:173,macr:175,deg:176,plusmn:177,sup1:185,sup2:178,sup3:179,acute:180,micro:181,para:182,middot:183,cedil:184,ordm:186,raquo:187,frac14:188,frac12:189,frac34:190,iquest:191,times:215,divide:247,OElig:338,oelig:339,Scaron:352,scaron:353,Yuml:376,fnof:402,circ:710,tilde:732,Alpha:913,Beta:914,Gamma:915,Delta:916,Epsilon:917,Zeta:918,Eta:919,Theta:920,Iota:921,Kappa:922,Lambda:923,Mu:924,Nu:925,Xi:926,Omicron:927,Pi:928,Rho:929,Sigma:931,Tau:932,Upsilon:933,Phi:934,Chi:935,Psi:936,Omega:937,alpha:945,beta:946,gamma:947,delta:948,epsilon:949,zeta:950,eta:951,theta:952,iota:953,kappa:954,lambda:955,mu:956,nu:957,xi:958,omicron:959,pi:960,rho:961,sigmaf:962,sigma:963,tau:964,upsilon:965,phi:966,chi:967,psi:968,omega:969,thetasym:977,upsih:978,piv:982,ensp:8194,emsp:8195,thinsp:8201,zwnj:8204,zwj:8205,lrm:8206,rlm:8207,ndash:8211,mdash:8212,lsquo:8216,rsquo:8217,sbquo:8218,ldquo:8220,rdquo:8221,bdquo:8222,dagger:8224,Dagger:8225,bull:8226,hellip:8230,permil:8240,prime:8242,Prime:8243,lsaquo:8249,rsaquo:8250,oline:8254,frasl:8260,euro:8364,image:8465,weierp:8472,real:8476,trade:8482,alefsym:8501,larr:8592,uarr:8593,rarr:8594,darr:8595,harr:8596,crarr:8629,lArr:8656,uArr:8657,rArr:8658,dArr:8659,hArr:8660,forall:8704,part:8706,exist:8707,empty:8709,nabla:8711,isin:8712,notin:8713,ni:8715,prod:8719,sum:8721,minus:8722,lowast:8727,radic:8730,prop:8733,infin:8734,ang:8736,and:8743,or:8744,cap:8745,cup:8746,int:8747,there4:8756,sim:8764,cong:8773,asymp:8776,ne:8800,equiv:8801,le:8804,ge:8805,sub:8834,sup:8835,nsub:8836,sube:8838,supe:8839,oplus:8853,otimes:8855,perp:8869,sdot:8901,lceil:8968,rceil:8969,lfloor:8970,rfloor:8971,lang:9001,rang:9002,loz:9674,spades:9824,clubs:9827,hearts:9829,diams:9830}
Object.keys(sax.ENTITIES).forEach((function(key){var e=sax.ENTITIES[key]
var s=typeof e==="number"?String.fromCharCode(e):e
sax.ENTITIES[key]=s}))
for(var s in sax.STATE)sax.STATE[sax.STATE[s]]=s
S=sax.STATE
function emit(parser,event,data){parser[event]&&parser[event](data)}function emitNode(parser,nodeType,data){parser.textNode&&closeText(parser)
emit(parser,nodeType,data)}function closeText(parser){parser.textNode=textopts(parser.opt,parser.textNode)
parser.textNode&&emit(parser,"ontext",parser.textNode)
parser.textNode=""}function textopts(opt,text){opt.trim&&(text=text.trim())
opt.normalize&&(text=text.replace(/\s+/g," "))
return text}function error(parser,er){closeText(parser)
parser.trackPosition&&(er+="\nLine: "+parser.line+"\nColumn: "+parser.column+"\nChar: "+parser.c)
er=new Error(er)
parser.error=er
emit(parser,"onerror",er)
return parser}function end(parser){parser.sawRoot&&!parser.closedRoot&&strictFail(parser,"Unclosed root tag")
parser.state!==S.BEGIN&&parser.state!==S.BEGIN_WHITESPACE&&parser.state!==S.TEXT&&error(parser,"Unexpected end")
closeText(parser)
parser.c=""
parser.closed=true
emit(parser,"onend")
SAXParser.call(parser,parser.strict,parser.opt)
return parser}function strictFail(parser,message){if(typeof parser!=="object"||!(parser instanceof SAXParser))throw new Error("bad call to strictFail")
parser.strict&&error(parser,message)}function newTag(parser){parser.strict||(parser.tagName=parser.tagName[parser.looseCase]())
var parent=parser.tags[parser.tags.length-1]||parser
var tag=parser.tag={name:parser.tagName,attributes:{}}
parser.opt.xmlns&&(tag.ns=parent.ns)
parser.attribList.length=0
emitNode(parser,"onopentagstart",tag)}function qname(name,attribute){var i=name.indexOf(":")
var qualName=i<0?["",name]:name.split(":")
var prefix=qualName[0]
var local=qualName[1]
if(attribute&&name==="xmlns"){prefix="xmlns"
local=""}return{prefix:prefix,local:local}}function attrib(parser){parser.strict||(parser.attribName=parser.attribName[parser.looseCase]())
if(parser.attribList.indexOf(parser.attribName)!==-1||parser.tag.attributes.hasOwnProperty(parser.attribName)){parser.attribName=parser.attribValue=""
return}if(parser.opt.xmlns){var qn=qname(parser.attribName,true)
var prefix=qn.prefix
var local=qn.local
if(prefix==="xmlns")if(local==="xml"&&parser.attribValue!==XML_NAMESPACE)strictFail(parser,"xml: prefix must be bound to "+XML_NAMESPACE+"\nActual: "+parser.attribValue)
else if(local==="xmlns"&&parser.attribValue!==XMLNS_NAMESPACE)strictFail(parser,"xmlns: prefix must be bound to "+XMLNS_NAMESPACE+"\nActual: "+parser.attribValue)
else{var tag=parser.tag
var parent=parser.tags[parser.tags.length-1]||parser
tag.ns===parent.ns&&(tag.ns=Object.create(parent.ns))
tag.ns[local]=parser.attribValue}parser.attribList.push([parser.attribName,parser.attribValue])}else{parser.tag.attributes[parser.attribName]=parser.attribValue
emitNode(parser,"onattribute",{name:parser.attribName,value:parser.attribValue})}parser.attribName=parser.attribValue=""}function openTag(parser,selfClosing){if(parser.opt.xmlns){var tag=parser.tag
var qn=qname(parser.tagName)
tag.prefix=qn.prefix
tag.local=qn.local
tag.uri=tag.ns[qn.prefix]||""
if(tag.prefix&&!tag.uri){strictFail(parser,"Unbound namespace prefix: "+JSON.stringify(parser.tagName))
tag.uri=qn.prefix}var parent=parser.tags[parser.tags.length-1]||parser
tag.ns&&parent.ns!==tag.ns&&Object.keys(tag.ns).forEach((function(p){emitNode(parser,"onopennamespace",{prefix:p,uri:tag.ns[p]})}))
for(var i=0,l=parser.attribList.length;i<l;i++){var nv=parser.attribList[i]
var name=nv[0]
var value=nv[1]
var qualName=qname(name,true)
var prefix=qualName.prefix
var local=qualName.local
var uri=prefix===""?"":tag.ns[prefix]||""
var a={name:name,value:value,prefix:prefix,local:local,uri:uri}
if(prefix&&prefix!=="xmlns"&&!uri){strictFail(parser,"Unbound namespace prefix: "+JSON.stringify(prefix))
a.uri=prefix}parser.tag.attributes[name]=a
emitNode(parser,"onattribute",a)}parser.attribList.length=0}parser.tag.isSelfClosing=!!selfClosing
parser.sawRoot=true
parser.tags.push(parser.tag)
emitNode(parser,"onopentag",parser.tag)
if(!selfClosing){parser.noscript||parser.tagName.toLowerCase()!=="script"?parser.state=S.TEXT:parser.state=S.SCRIPT
parser.tag=null
parser.tagName=""}parser.attribName=parser.attribValue=""
parser.attribList.length=0}function closeTag(parser){if(!parser.tagName){strictFail(parser,"Weird empty close tag.")
parser.textNode+="</>"
parser.state=S.TEXT
return}if(parser.script){if(parser.tagName!=="script"){parser.script+="</"+parser.tagName+">"
parser.tagName=""
parser.state=S.SCRIPT
return}emitNode(parser,"onscript",parser.script)
parser.script=""}var t=parser.tags.length
var tagName=parser.tagName
parser.strict||(tagName=tagName[parser.looseCase]())
var closeTo=tagName
while(t--){var close=parser.tags[t]
if(close.name===closeTo)break
strictFail(parser,"Unexpected close tag")}if(t<0){strictFail(parser,"Unmatched closing tag: "+parser.tagName)
parser.textNode+="</"+parser.tagName+">"
parser.state=S.TEXT
return}parser.tagName=tagName
var s=parser.tags.length
while(s-- >t){var tag=parser.tag=parser.tags.pop()
parser.tagName=parser.tag.name
emitNode(parser,"onclosetag",parser.tagName)
var x={}
for(var i in tag.ns)x[i]=tag.ns[i]
var parent=parser.tags[parser.tags.length-1]||parser
parser.opt.xmlns&&tag.ns!==parent.ns&&Object.keys(tag.ns).forEach((function(p){var n=tag.ns[p]
emitNode(parser,"onclosenamespace",{prefix:p,uri:n})}))}t===0&&(parser.closedRoot=true)
parser.tagName=parser.attribValue=parser.attribName=""
parser.attribList.length=0
parser.state=S.TEXT}function parseEntity(parser){var entity=parser.entity
var entityLC=entity.toLowerCase()
var num
var numStr=""
if(parser.ENTITIES[entity])return parser.ENTITIES[entity]
if(parser.ENTITIES[entityLC])return parser.ENTITIES[entityLC]
entity=entityLC
if(entity.charAt(0)==="#")if(entity.charAt(1)==="x"){entity=entity.slice(2)
num=parseInt(entity,16)
numStr=num.toString(16)}else{entity=entity.slice(1)
num=parseInt(entity,10)
numStr=num.toString(10)}entity=entity.replace(/^0+/,"")
if(isNaN(num)||numStr.toLowerCase()!==entity){strictFail(parser,"Invalid character entity")
return"&"+parser.entity+";"}return String.fromCodePoint(num)}function beginWhiteSpace(parser,c){if(c==="<"){parser.state=S.OPEN_WAKA
parser.startTagPosition=parser.position}else if(!isWhitespace(c)){strictFail(parser,"Non-whitespace before first tag.")
parser.textNode=c
parser.state=S.TEXT}}function charAt(chunk,i){var result=""
i<chunk.length&&(result=chunk.charAt(i))
return result}function write(chunk){var parser=this
if(this.error)throw this.error
if(parser.closed)return error(parser,"Cannot write after close. Assign an onready handler.")
if(chunk===null)return end(parser)
typeof chunk==="object"&&(chunk=chunk.toString())
var i=0
var c=""
while(true){c=charAt(chunk,i++)
parser.c=c
if(!c)break
if(parser.trackPosition){parser.position++
if(c==="\n"){parser.line++
parser.column=0}else parser.column++}switch(parser.state){case S.BEGIN:parser.state=S.BEGIN_WHITESPACE
if(c==="\ufeff")continue
beginWhiteSpace(parser,c)
continue
case S.BEGIN_WHITESPACE:beginWhiteSpace(parser,c)
continue
case S.TEXT:if(parser.sawRoot&&!parser.closedRoot){var starti=i-1
while(c&&c!=="<"&&c!=="&"){c=charAt(chunk,i++)
if(c&&parser.trackPosition){parser.position++
if(c==="\n"){parser.line++
parser.column=0}else parser.column++}}parser.textNode+=chunk.substring(starti,i-1)}if(c!=="<"||parser.sawRoot&&parser.closedRoot&&!parser.strict){isWhitespace(c)||parser.sawRoot&&!parser.closedRoot||strictFail(parser,"Text data outside of root node.")
c==="&"?parser.state=S.TEXT_ENTITY:parser.textNode+=c}else{parser.state=S.OPEN_WAKA
parser.startTagPosition=parser.position}continue
case S.SCRIPT:c==="<"?parser.state=S.SCRIPT_ENDING:parser.script+=c
continue
case S.SCRIPT_ENDING:if(c==="/")parser.state=S.CLOSE_TAG
else{parser.script+="<"+c
parser.state=S.SCRIPT}continue
case S.OPEN_WAKA:if(c==="!"){parser.state=S.SGML_DECL
parser.sgmlDecl=""}else if(isWhitespace(c));else if(isMatch(nameStart,c)){parser.state=S.OPEN_TAG
parser.tagName=c}else if(c==="/"){parser.state=S.CLOSE_TAG
parser.tagName=""}else if(c==="?"){parser.state=S.PROC_INST
parser.procInstName=parser.procInstBody=""}else{strictFail(parser,"Unencoded <")
if(parser.startTagPosition+1<parser.position){var pad=parser.position-parser.startTagPosition
c=new Array(pad).join(" ")+c}parser.textNode+="<"+c
parser.state=S.TEXT}continue
case S.SGML_DECL:if(parser.sgmlDecl+c==="--"){parser.state=S.COMMENT
parser.comment=""
parser.sgmlDecl=""
continue}if(parser.doctype&&parser.doctype!==true&&parser.sgmlDecl){parser.state=S.DOCTYPE_DTD
parser.doctype+="<!"+parser.sgmlDecl+c
parser.sgmlDecl=""}else if((parser.sgmlDecl+c).toUpperCase()===CDATA){emitNode(parser,"onopencdata")
parser.state=S.CDATA
parser.sgmlDecl=""
parser.cdata=""}else if((parser.sgmlDecl+c).toUpperCase()===DOCTYPE){parser.state=S.DOCTYPE;(parser.doctype||parser.sawRoot)&&strictFail(parser,"Inappropriately located doctype declaration")
parser.doctype=""
parser.sgmlDecl=""}else if(c===">"){emitNode(parser,"onsgmldeclaration",parser.sgmlDecl)
parser.sgmlDecl=""
parser.state=S.TEXT}else if(isQuote(c)){parser.state=S.SGML_DECL_QUOTED
parser.sgmlDecl+=c}else parser.sgmlDecl+=c
continue
case S.SGML_DECL_QUOTED:if(c===parser.q){parser.state=S.SGML_DECL
parser.q=""}parser.sgmlDecl+=c
continue
case S.DOCTYPE:if(c===">"){parser.state=S.TEXT
emitNode(parser,"ondoctype",parser.doctype)
parser.doctype=true}else{parser.doctype+=c
if(c==="[")parser.state=S.DOCTYPE_DTD
else if(isQuote(c)){parser.state=S.DOCTYPE_QUOTED
parser.q=c}}continue
case S.DOCTYPE_QUOTED:parser.doctype+=c
if(c===parser.q){parser.q=""
parser.state=S.DOCTYPE}continue
case S.DOCTYPE_DTD:if(c==="]"){parser.doctype+=c
parser.state=S.DOCTYPE}else if(c==="<"){parser.state=S.OPEN_WAKA
parser.startTagPosition=parser.position}else if(isQuote(c)){parser.doctype+=c
parser.state=S.DOCTYPE_DTD_QUOTED
parser.q=c}else parser.doctype+=c
continue
case S.DOCTYPE_DTD_QUOTED:parser.doctype+=c
if(c===parser.q){parser.state=S.DOCTYPE_DTD
parser.q=""}continue
case S.COMMENT:c==="-"?parser.state=S.COMMENT_ENDING:parser.comment+=c
continue
case S.COMMENT_ENDING:if(c==="-"){parser.state=S.COMMENT_ENDED
parser.comment=textopts(parser.opt,parser.comment)
parser.comment&&emitNode(parser,"oncomment",parser.comment)
parser.comment=""}else{parser.comment+="-"+c
parser.state=S.COMMENT}continue
case S.COMMENT_ENDED:if(c!==">"){strictFail(parser,"Malformed comment")
parser.comment+="--"+c
parser.state=S.COMMENT}else parser.doctype&&parser.doctype!==true?parser.state=S.DOCTYPE_DTD:parser.state=S.TEXT
continue
case S.CDATA:c==="]"?parser.state=S.CDATA_ENDING:parser.cdata+=c
continue
case S.CDATA_ENDING:if(c==="]")parser.state=S.CDATA_ENDING_2
else{parser.cdata+="]"+c
parser.state=S.CDATA}continue
case S.CDATA_ENDING_2:if(c===">"){parser.cdata&&emitNode(parser,"oncdata",parser.cdata)
emitNode(parser,"onclosecdata")
parser.cdata=""
parser.state=S.TEXT}else if(c==="]")parser.cdata+="]"
else{parser.cdata+="]]"+c
parser.state=S.CDATA}continue
case S.PROC_INST:c==="?"?parser.state=S.PROC_INST_ENDING:isWhitespace(c)?parser.state=S.PROC_INST_BODY:parser.procInstName+=c
continue
case S.PROC_INST_BODY:if(!parser.procInstBody&&isWhitespace(c))continue
c==="?"?parser.state=S.PROC_INST_ENDING:parser.procInstBody+=c
continue
case S.PROC_INST_ENDING:if(c===">"){emitNode(parser,"onprocessinginstruction",{name:parser.procInstName,body:parser.procInstBody})
parser.procInstName=parser.procInstBody=""
parser.state=S.TEXT}else{parser.procInstBody+="?"+c
parser.state=S.PROC_INST_BODY}continue
case S.OPEN_TAG:if(isMatch(nameBody,c))parser.tagName+=c
else{newTag(parser)
if(c===">")openTag(parser)
else if(c==="/")parser.state=S.OPEN_TAG_SLASH
else{isWhitespace(c)||strictFail(parser,"Invalid character in tag name")
parser.state=S.ATTRIB}}continue
case S.OPEN_TAG_SLASH:if(c===">"){openTag(parser,true)
closeTag(parser)}else{strictFail(parser,"Forward-slash in opening tag not followed by >")
parser.state=S.ATTRIB}continue
case S.ATTRIB:if(isWhitespace(c))continue
if(c===">")openTag(parser)
else if(c==="/")parser.state=S.OPEN_TAG_SLASH
else if(isMatch(nameStart,c)){parser.attribName=c
parser.attribValue=""
parser.state=S.ATTRIB_NAME}else strictFail(parser,"Invalid attribute name")
continue
case S.ATTRIB_NAME:if(c==="=")parser.state=S.ATTRIB_VALUE
else if(c===">"){strictFail(parser,"Attribute without value")
parser.attribValue=parser.attribName
attrib(parser)
openTag(parser)}else isWhitespace(c)?parser.state=S.ATTRIB_NAME_SAW_WHITE:isMatch(nameBody,c)?parser.attribName+=c:strictFail(parser,"Invalid attribute name")
continue
case S.ATTRIB_NAME_SAW_WHITE:if(c==="=")parser.state=S.ATTRIB_VALUE
else{if(isWhitespace(c))continue
strictFail(parser,"Attribute without value")
parser.tag.attributes[parser.attribName]=""
parser.attribValue=""
emitNode(parser,"onattribute",{name:parser.attribName,value:""})
parser.attribName=""
if(c===">")openTag(parser)
else if(isMatch(nameStart,c)){parser.attribName=c
parser.state=S.ATTRIB_NAME}else{strictFail(parser,"Invalid attribute name")
parser.state=S.ATTRIB}}continue
case S.ATTRIB_VALUE:if(isWhitespace(c))continue
if(isQuote(c)){parser.q=c
parser.state=S.ATTRIB_VALUE_QUOTED}else{parser.opt.unquotedAttributeValues||error(parser,"Unquoted attribute value")
parser.state=S.ATTRIB_VALUE_UNQUOTED
parser.attribValue=c}continue
case S.ATTRIB_VALUE_QUOTED:if(c!==parser.q){c==="&"?parser.state=S.ATTRIB_VALUE_ENTITY_Q:parser.attribValue+=c
continue}attrib(parser)
parser.q=""
parser.state=S.ATTRIB_VALUE_CLOSED
continue
case S.ATTRIB_VALUE_CLOSED:if(isWhitespace(c))parser.state=S.ATTRIB
else if(c===">")openTag(parser)
else if(c==="/")parser.state=S.OPEN_TAG_SLASH
else if(isMatch(nameStart,c)){strictFail(parser,"No whitespace between attributes")
parser.attribName=c
parser.attribValue=""
parser.state=S.ATTRIB_NAME}else strictFail(parser,"Invalid attribute name")
continue
case S.ATTRIB_VALUE_UNQUOTED:if(!isAttribEnd(c)){c==="&"?parser.state=S.ATTRIB_VALUE_ENTITY_U:parser.attribValue+=c
continue}attrib(parser)
c===">"?openTag(parser):parser.state=S.ATTRIB
continue
case S.CLOSE_TAG:if(parser.tagName)if(c===">")closeTag(parser)
else if(isMatch(nameBody,c))parser.tagName+=c
else if(parser.script){parser.script+="</"+parser.tagName
parser.tagName=""
parser.state=S.SCRIPT}else{isWhitespace(c)||strictFail(parser,"Invalid tagname in closing tag")
parser.state=S.CLOSE_TAG_SAW_WHITE}else{if(isWhitespace(c))continue
if(notMatch(nameStart,c))if(parser.script){parser.script+="</"+c
parser.state=S.SCRIPT}else strictFail(parser,"Invalid tagname in closing tag.")
else parser.tagName=c}continue
case S.CLOSE_TAG_SAW_WHITE:if(isWhitespace(c))continue
c===">"?closeTag(parser):strictFail(parser,"Invalid characters in closing tag")
continue
case S.TEXT_ENTITY:case S.ATTRIB_VALUE_ENTITY_Q:case S.ATTRIB_VALUE_ENTITY_U:var returnState
var buffer
switch(parser.state){case S.TEXT_ENTITY:returnState=S.TEXT
buffer="textNode"
break
case S.ATTRIB_VALUE_ENTITY_Q:returnState=S.ATTRIB_VALUE_QUOTED
buffer="attribValue"
break
case S.ATTRIB_VALUE_ENTITY_U:returnState=S.ATTRIB_VALUE_UNQUOTED
buffer="attribValue"
break}if(c===";"){var parsedEntity=parseEntity(parser)
if(parser.opt.unparsedEntities&&!Object.values(sax.XML_ENTITIES).includes(parsedEntity)){parser.entity=""
parser.state=returnState
parser.write(parsedEntity)}else{parser[buffer]+=parsedEntity
parser.entity=""
parser.state=returnState}}else if(isMatch(parser.entity.length?entityBody:entityStart,c))parser.entity+=c
else{strictFail(parser,"Invalid character in entity name")
parser[buffer]+="&"+parser.entity+c
parser.entity=""
parser.state=returnState}continue
default:throw new Error(parser,"Unknown state: "+parser.state)}}parser.position>=parser.bufferCheckPosition&&checkBufferLength(parser)
return parser}String.fromCodePoint||function(){var stringFromCharCode=String.fromCharCode
var floor=Math.floor
var fromCodePoint=function(){var MAX_SIZE=0x4000
var codeUnits=[]
var highSurrogate
var lowSurrogate
var index=-1
var length=arguments.length
if(!length)return""
var result=""
while(++index<length){var codePoint=Number(arguments[index])
if(!isFinite(codePoint)||codePoint<0||codePoint>0x10FFFF||floor(codePoint)!==codePoint)throw RangeError("Invalid code point: "+codePoint)
if(codePoint<=0xFFFF)codeUnits.push(codePoint)
else{codePoint-=0x10000
highSurrogate=0xD800+(codePoint>>10)
lowSurrogate=codePoint%0x400+0xDC00
codeUnits.push(highSurrogate,lowSurrogate)}if(index+1===length||codeUnits.length>MAX_SIZE){result+=stringFromCharCode.apply(null,codeUnits)
codeUnits.length=0}}return result}
Object.defineProperty?Object.defineProperty(String,"fromCodePoint",{value:fromCodePoint,configurable:true,writable:true}):String.fromCodePoint=fromCodePoint}()})(exports)})(sax)
var SAX=getDefaultExportFromCjs(sax)
class SvgoParserError extends Error{constructor(message,line,column,source,file){super(message)
this.name="SvgoParserError"
this.message=`${file||"<input>"}:${line}:${column}: ${message}`
this.reason=message
this.line=line
this.column=column
this.source=source
Error.captureStackTrace&&Error.captureStackTrace(this,SvgoParserError)}toString(){const lines=this.source.split(/\r?\n/)
const startLine=Math.max(this.line-3,0)
const endLine=Math.min(this.line+2,lines.length)
const lineNumberWidth=String(endLine).length
const startColumn=Math.max(this.column-54,0)
const endColumn=Math.max(this.column+20,80)
const code=lines.slice(startLine,endLine).map(((line,index)=>{const lineSlice=line.slice(startColumn,endColumn)
let ellipsisPrefix=""
let ellipsisSuffix=""
startColumn!==0&&(ellipsisPrefix=startColumn>line.length-1?" ":"…")
endColumn<line.length-1&&(ellipsisSuffix="…")
const number=startLine+1+index
const gutter=` ${number.toString().padStart(lineNumberWidth)} | `
if(number===this.line){const gutterSpacing=gutter.replace(/[^|]/g," ")
const lineSpacing=(ellipsisPrefix+line.slice(startColumn,this.column-1)).replace(/[^\t]/g," ")
const spacing=gutterSpacing+lineSpacing
return`>${gutter}${ellipsisPrefix}${lineSlice}${ellipsisSuffix}\n ${spacing}^`}return` ${gutter}${ellipsisPrefix}${lineSlice}${ellipsisSuffix}`})).join("\n")
return`${this.name}: ${this.message}\n\n${code}\n`}}const entityDeclaration=/<!ENTITY\s+(\S+)\s+(?:'([^']+)'|"([^"]+)")\s*>/g
const config={strict:true,trim:false,normalize:false,lowercase:true,xmlns:true,position:true,unparsedEntities:true}
const parseSvg=(data,from)=>{const sax=SAX.parser(config.strict,config)
const root={type:"root",children:[]}
let current=root
const stack=[root]
const pushToContent=node=>{current.children.push(node)}
sax.ondoctype=doctype=>{const node={type:"doctype",name:"svg",data:{doctype:doctype}}
pushToContent(node)
const subsetStart=doctype.indexOf("[")
if(subsetStart>=0){entityDeclaration.lastIndex=subsetStart
let entityMatch=entityDeclaration.exec(data)
while(entityMatch!=null){sax.ENTITIES[entityMatch[1]]=entityMatch[2]||entityMatch[3]
entityMatch=entityDeclaration.exec(data)}}}
sax.onprocessinginstruction=data=>{const node={type:"instruction",name:data.name,value:data.body}
pushToContent(node)}
sax.oncomment=comment=>{const node={type:"comment",value:comment.trim()}
pushToContent(node)}
sax.oncdata=cdata=>{const node={type:"cdata",value:cdata}
pushToContent(node)}
sax.onopentag=data=>{const element={type:"element",name:data.name,attributes:{},children:[]}
for(const[name,attr]of Object.entries(data.attributes))element.attributes[name]=attr.value
pushToContent(element)
current=element
stack.push(element)}
sax.ontext=text=>{if(current.type==="element")if(textElems.has(current.name)){const node={type:"text",value:text}
pushToContent(node)}else{const value=text.trim()
if(value!==""){const node={type:"text",value:value}
pushToContent(node)}}}
sax.onclosetag=()=>{stack.pop()
current=stack[stack.length-1]}
sax.onerror=e=>{const reason=e.message.split("\n")[0]
const error=new SvgoParserError(reason,sax.line+1,sax.column,data,from)
if(e.message.indexOf("Unexpected end")===-1)throw error}
sax.write(data).close()
return root}
const encodeEntity=char=>entities[char]
const defaults={doctypeStart:"<!DOCTYPE",doctypeEnd:">",procInstStart:"<?",procInstEnd:"?>",tagOpenStart:"<",tagOpenEnd:">",tagCloseStart:"</",tagCloseEnd:">",tagShortStart:"<",tagShortEnd:"/>",attrStart:'="',attrEnd:'"',commentStart:"\x3c!--",commentEnd:"--\x3e",cdataStart:"<![CDATA[",cdataEnd:"]]>",textStart:"",textEnd:"",indent:4,regEntities:/[&'"<>]/g,regValEntities:/[&"<>]/g,encodeEntity:encodeEntity,pretty:false,useShortTags:true,eol:"lf",finalNewline:false}
const entities={"&":"&amp;","'":"&apos;",'"':"&quot;",">":"&gt;","<":"&lt;"}
const stringifySvg=(data,userOptions={})=>{const config={...defaults,...userOptions}
const indent=config.indent
let newIndent="    "
typeof indent==="number"&&Number.isNaN(indent)===false?newIndent=indent<0?"\t":" ".repeat(indent):typeof indent==="string"&&(newIndent=indent)
const state={indent:newIndent,textContext:null,indentLevel:0}
const eol=config.eol==="crlf"?"\r\n":"\n"
if(config.pretty){config.doctypeEnd+=eol
config.procInstEnd+=eol
config.commentEnd+=eol
config.cdataEnd+=eol
config.tagShortEnd+=eol
config.tagOpenEnd+=eol
config.tagCloseEnd+=eol
config.textEnd+=eol}let svg=stringifyNode(data,config,state)
config.finalNewline&&svg.length>0&&!svg.endsWith("\n")&&(svg+=eol)
return svg}
const stringifyNode=(data,config,state)=>{let svg=""
state.indentLevel++
for(const item of data.children)switch(item.type){case"element":svg+=stringifyElement(item,config,state)
break
case"text":svg+=stringifyText(item,config,state)
break
case"doctype":svg+=stringifyDoctype(item,config)
break
case"instruction":svg+=stringifyInstruction(item,config)
break
case"comment":svg+=stringifyComment(item,config)
break
case"cdata":svg+=stringifyCdata(item,config,state)}state.indentLevel--
return svg}
const createIndent=(config,state)=>{let indent=""
config.pretty&&state.textContext==null&&(indent=state.indent.repeat(state.indentLevel-1))
return indent}
const stringifyDoctype=(node,config)=>config.doctypeStart+node.data.doctype+config.doctypeEnd
const stringifyInstruction=(node,config)=>config.procInstStart+node.name+" "+node.value+config.procInstEnd
const stringifyComment=(node,config)=>config.commentStart+node.value+config.commentEnd
const stringifyCdata=(node,config,state)=>createIndent(config,state)+config.cdataStart+node.value+config.cdataEnd
const stringifyElement=(node,config,state)=>{if(node.children.length===0){if(config.useShortTags)return createIndent(config,state)+config.tagShortStart+node.name+stringifyAttributes(node,config)+config.tagShortEnd
return createIndent(config,state)+config.tagShortStart+node.name+stringifyAttributes(node,config)+config.tagOpenEnd+config.tagCloseStart+node.name+config.tagCloseEnd}let tagOpenStart=config.tagOpenStart
let tagOpenEnd=config.tagOpenEnd
let tagCloseStart=config.tagCloseStart
let tagCloseEnd=config.tagCloseEnd
let openIndent=createIndent(config,state)
let closeIndent=createIndent(config,state)
if(state.textContext){tagOpenStart=defaults.tagOpenStart
tagOpenEnd=defaults.tagOpenEnd
tagCloseStart=defaults.tagCloseStart
tagCloseEnd=defaults.tagCloseEnd
openIndent=""}else if(textElems.has(node.name)){tagOpenEnd=defaults.tagOpenEnd
tagCloseStart=defaults.tagCloseStart
closeIndent=""
state.textContext=node}const children=stringifyNode(node,config,state)
state.textContext===node&&(state.textContext=null)
return openIndent+tagOpenStart+node.name+stringifyAttributes(node,config)+tagOpenEnd+children+closeIndent+tagCloseStart+node.name+tagCloseEnd}
const stringifyAttributes=(node,config)=>{let attrs=""
for(const[name,value]of Object.entries(node.attributes)){attrs+=" "+name
if(value!==void 0){const encodedValue=value.toString().replace(config.regValEntities,config.encodeEntity)
attrs+=config.attrStart+encodedValue+config.attrEnd}}return attrs}
const stringifyText=(node,config,state)=>createIndent(config,state)+config.textStart+node.value.replace(config.regEntities,config.encodeEntity)+(state.textContext?"":config.textEnd)
const VERSION="4.0.0"
const pluginsMap=new Map
for(const plugin of builtinPlugins)pluginsMap.set(plugin.name,plugin)
function getPlugin(name){if(name==="removeScriptElement"){console.warn("Warning: removeScriptElement has been renamed to removeScripts, please update your SVGO config")
return pluginsMap.get("removeScripts")}return pluginsMap.get(name)}const resolvePluginConfig=plugin=>{if(typeof plugin==="string"){const builtinPlugin=getPlugin(plugin)
if(builtinPlugin==null)throw Error(`Unknown builtin plugin "${plugin}" specified.`)
return{name:plugin,params:{},fn:builtinPlugin.fn}}if(typeof plugin==="object"&&plugin!=null){if(plugin.name==null)throw Error("Plugin name must be specified")
let fn=plugin.fn
if(fn==null){const builtinPlugin=getPlugin(plugin.name)
if(builtinPlugin==null)throw Error(`Unknown builtin plugin "${plugin.name}" specified.`)
fn=builtinPlugin.fn}return{name:plugin.name,params:plugin.params,fn:fn}}return null}
const optimize=(input,config)=>{config==null&&(config={})
if(typeof config!=="object")throw Error("Config should be an object")
const maxPassCount=config.multipass?10:1
let prevResultSize=Number.POSITIVE_INFINITY
let output=""
const info={}
config.path!=null&&(info.path=config.path)
for(let i=0;i<maxPassCount;i+=1){info.multipassCount=i
const ast=parseSvg(input,config.path)
const plugins=config.plugins||["preset-default"]
if(!Array.isArray(plugins))throw Error("malformed config, `plugins` property must be an array.\nSee more info here: https://github.com/svg/svgo#configuration")
const resolvedPlugins=plugins.filter((plugin=>plugin!=null)).map(resolvePluginConfig)
resolvedPlugins.length<plugins.length&&console.warn("Warning: plugins list includes null or undefined elements, these will be ignored.")
const globalOverrides={}
config.floatPrecision!=null&&(globalOverrides.floatPrecision=config.floatPrecision)
invokePlugins(ast,info,resolvedPlugins,null,globalOverrides)
output=stringifySvg(ast,config.js2svg)
if(!(output.length<prevResultSize))break
input=output
prevResultSize=output.length}config.datauri&&(output=encodeSVGDatauri(output,config.datauri))
return{data:output}}
export{VERSION,_collections,builtinPlugins,mapNodesToParents,optimize,querySelector,querySelectorAll}
