/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Arrays;
import javax.media.j3d.BHLeafInterface;
import javax.media.j3d.BHLeafNode;
import javax.media.j3d.BHNode;
import javax.media.j3d.BHTree;
import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.BehaviorStructure;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.Locale;
import javax.media.j3d.MRSWLock;
import javax.media.j3d.NnuId;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.PickShape;
import javax.media.j3d.RenderBin;
import javax.media.j3d.UnorderList;
import javax.media.j3d.UpdateTargets;
import javax.media.j3d.VirtualUniverse;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupIndexedList;
import javax.media.j3d.WakeupOnCollisionEntry;
import javax.media.j3d.WakeupOnCollisionExit;
import javax.media.j3d.WakeupOnCollisionMovement;
import javax.vecmath.Vector3d;

class GeometryStructure
extends J3dStructure {
    UpdateTargets targets = null;
    private MRSWLock lock = null;
    private Object visLock = new Object();
    private Object collideListLock = new Object();
    private BHTree[] bhTreeArr = null;
    private int bhTreeCount = 0;
    private int bhTreeMax = 1;
    private int bhTreeBlockSize = 5;
    private BHNode[] bhNodeArr = null;
    private int bhNodeCount = 0;
    private int bhNodeMax;
    private int bhNodeBlockSize = 50;
    private Vector3d localeTrans = new Vector3d();
    WakeupIndexedList collideEntryList;
    WakeupIndexedList collideExitList;
    WakeupIndexedList collideMovementList;
    WakeupIndexedList wakeupOnCollisionEntry;
    WakeupIndexedList wakeupOnCollisionExit;
    WakeupIndexedList wakeupOnCollisionMovement;
    boolean reEvaluateWakeupCollisionGAs;
    private boolean transformMsg = false;

    GeometryStructure(VirtualUniverse virtualUniverse) {
        super(virtualUniverse, 64);
        this.bhNodeMax = this.bhNodeBlockSize;
        this.bhNodeArr = new BHNode[this.bhNodeMax];
        this.bhTreeArr = new BHTree[this.bhTreeMax];
        this.lock = new MRSWLock();
        this.collideEntryList = new WakeupIndexedList(WakeupOnCollisionEntry.class, 1, virtualUniverse);
        this.collideExitList = new WakeupIndexedList(WakeupOnCollisionExit.class, 1, virtualUniverse);
        this.collideMovementList = new WakeupIndexedList(WakeupOnCollisionMovement.class, 1, virtualUniverse);
        this.wakeupOnCollisionEntry = new WakeupIndexedList(WakeupOnCollisionEntry.class, 0, virtualUniverse);
        this.wakeupOnCollisionExit = new WakeupIndexedList(WakeupOnCollisionExit.class, 0, virtualUniverse);
        this.wakeupOnCollisionMovement = new WakeupIndexedList(WakeupOnCollisionMovement.class, 0, virtualUniverse);
    }

    @Override
    void processMessages(long l) {
        Object[] objectArray = this.getMessages(l);
        int n = this.getNumMessage();
        if (n > 0) {
            this.reEvaluateWakeupCollisionGAs = false;
            for (int i = 0; i < n; ++i) {
                this.lock.writeLock();
                J3dMessage j3dMessage = objectArray[i];
                switch (j3dMessage.type) {
                    case 3: {
                        this.transformMsg = true;
                        break;
                    }
                    case 27: {
                        this.processSwitchChanged(j3dMessage);
                        if (!this.universe.transformStructure.getLazyUpdate()) break;
                        this.transformMsg = true;
                        break;
                    }
                    case 0: {
                        this.insertNodes((Object[])j3dMessage.args[0]);
                        this.reEvaluateWakeupCollisionGAs = true;
                        break;
                    }
                    case 1: {
                        this.removeNodes(j3dMessage);
                        this.reEvaluateWakeupCollisionGAs = true;
                        break;
                    }
                    case 24: {
                        int n2 = (Integer)j3dMessage.args[1];
                        if (n2 == 1) {
                            j3dMessage.args[0] = j3dMessage.args[2];
                            this.removeNodes(j3dMessage);
                            this.insertNodes((Object[])j3dMessage.args[3]);
                            this.reEvaluateWakeupCollisionGAs = true;
                            break;
                        }
                        if (n2 != 2) break;
                        this.processVisibleChanged(j3dMessage.args[2], (GeometryAtom[])j3dMessage.args[3]);
                        break;
                    }
                    case 26: {
                        this.removeNodes(j3dMessage);
                        this.insertNodes((Object[])j3dMessage.args[1]);
                        break;
                    }
                    case 25: {
                        this.processBoundsChanged((Object[])j3dMessage.args[0], false);
                        break;
                    }
                    case 16: {
                        int n2 = (Integer)j3dMessage.args[1];
                        if (n2 == 1) {
                            this.processBoundsChanged((Object[])j3dMessage.args[3], false);
                            break;
                        }
                        if (n2 != 2) break;
                        this.processVisibleChanged(j3dMessage.args[2], (GeometryAtom[])j3dMessage.args[3]);
                        break;
                    }
                    case 35: 
                    case 37: {
                        this.processBoundsChanged((Object[])j3dMessage.args[0], false);
                        break;
                    }
                    case 17: {
                        this.processBoundsChanged((Object[])j3dMessage.args[0], false);
                        break;
                    }
                    case 10: {
                        this.processVisibleChanged(j3dMessage.args[2], (GeometryAtom[])j3dMessage.args[3]);
                    }
                }
                this.lock.writeUnlock();
                j3dMessage.decRefcount();
            }
            if (this.transformMsg) {
                this.targets = this.universe.transformStructure.getTargetList();
                this.lock.writeLock();
                this.processTransformChanged(this.targets);
                this.lock.writeUnlock();
                this.transformMsg = false;
                this.targets = null;
            }
            Arrays.fill(objectArray, 0, n, null);
        }
        this.processCollisionDetection();
    }

    private int getBHTreeIndex(Locale locale) {
        for (int i = 0; i < this.bhTreeCount; ++i) {
            if (this.bhTreeArr[i].locale != locale) continue;
            return i;
        }
        return -1;
    }

    private int getOrAddBHTreeIndex(Locale locale) {
        int n;
        for (n = 0; n < this.bhTreeCount; ++n) {
            if (this.bhTreeArr[n].locale != locale) continue;
            return n;
        }
        if (this.bhTreeCount >= this.bhTreeMax) {
            this.bhTreeMax += this.bhTreeBlockSize;
            BHTree[] bHTreeArray = this.bhTreeArr;
            this.bhTreeArr = new BHTree[this.bhTreeMax];
            System.arraycopy(bHTreeArray, 0, this.bhTreeArr, 0, bHTreeArray.length);
        }
        this.bhTreeArr[this.bhTreeCount] = new BHTree(locale);
        ++this.bhTreeCount;
        return n;
    }

    private void clearBhNodeArr() {
        for (int i = 0; i < this.bhNodeCount; ++i) {
            this.bhNodeArr[i] = null;
        }
        this.bhNodeCount = 0;
    }

    private void addToBhNodeArr(BHNode bHNode) {
        if (this.bhNodeCount >= this.bhNodeMax) {
            this.bhNodeMax += this.bhNodeBlockSize;
            BHNode[] bHNodeArray = this.bhNodeArr;
            this.bhNodeArr = new BHNode[this.bhNodeMax];
            System.arraycopy(bHNodeArray, 0, this.bhNodeArr, 0, bHNodeArray.length);
        }
        this.bhNodeArr[this.bhNodeCount] = bHNode;
        ++this.bhNodeCount;
    }

    private void processVisibleChanged(Object object, GeometryAtom[] geometryAtomArray) {
        boolean bl = true;
        if (geometryAtomArray == null || geometryAtomArray.length < 1) {
            return;
        }
        int n = this.getBHTreeIndex(geometryAtomArray[0].locale);
        bl = (Boolean)object;
        for (int i = geometryAtomArray.length - 1; i >= 0; --i) {
            geometryAtomArray[i].visible = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNodes(Object[] objectArray) {
        Object object;
        int n;
        this.clearBhNodeArr();
        for (n = 0; n < objectArray.length; ++n) {
            Object object2;
            Object object3 = objectArray[n];
            if (object3 instanceof GeometryAtom) {
                object = object3;
                synchronized (object) {
                    GeometryAtom geometryAtom = (GeometryAtom)object3;
                    if (geometryAtom.source.inBackgroundGroup) {
                        geometryAtom.source.geometryBackground.addBgGeometryAtomList(geometryAtom);
                        continue;
                    }
                    object2 = new BHLeafNode();
                    ((BHLeafNode)object2).leafIF = geometryAtom;
                    geometryAtom.bhLeafNode = object2;
                    ((BHLeafNode)object2).computeBoundingHull();
                    this.addToBhNodeArr((BHNode)object2);
                    continue;
                }
            }
            if (!(object3 instanceof GroupRetained)) continue;
            object = object3;
            synchronized (object) {
                object2 = (GroupRetained)object3;
                BHLeafNode bHLeafNode = new BHLeafNode();
                bHLeafNode.leafIF = object2;
                ((GroupRetained)object2).bhLeafNode = bHLeafNode;
                bHLeafNode.computeBoundingHull();
                this.addToBhNodeArr(bHLeafNode);
                continue;
            }
        }
        if (this.bhNodeCount < 1) {
            return;
        }
        n = this.getOrAddBHTreeIndex(((BHLeafNode)this.bhNodeArr[0]).getLocale());
        object = this.bhTreeArr[n];
        ((BHTree)object).insert(this.bhNodeArr, this.bhNodeCount);
        this.clearBhNodeArr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void removeNodes(J3dMessage j3dMessage) {
        Object object;
        Object object2;
        int n;
        Object[] objectArray = (Object[])j3dMessage.args[0];
        this.clearBhNodeArr();
        for (n = 0; n < objectArray.length; ++n) {
            Object object3 = objectArray[n];
            if (object3 instanceof GeometryAtom) {
                object2 = object3;
                synchronized (object2) {
                    object = (GeometryAtom)object3;
                    if (((GeometryAtom)object).source != null && ((GeometryAtom)object).source.inBackgroundGroup) {
                        ((GeometryAtom)object).source.geometryBackground.removeBgGeometryAtomList((GeometryAtom)object);
                        continue;
                    }
                    if (((GeometryAtom)object).bhLeafNode != null) {
                        this.addToBhNodeArr(((GeometryAtom)object).bhLeafNode);
                        ((GeometryAtom)object).bhLeafNode = null;
                    }
                    continue;
                }
            }
            if (object3 instanceof GroupRetained) {
                if (((NodeRetained)object3).nodeType == 20) continue;
                object2 = object3;
                synchronized (object2) {
                    object = (GroupRetained)object3;
                    if (((GroupRetained)object).bhLeafNode != null) {
                        this.addToBhNodeArr(((GroupRetained)object).bhLeafNode);
                        ((GroupRetained)object).bhLeafNode = null;
                    }
                    continue;
                }
            }
            if (!(object3 instanceof BehaviorRetained)) continue;
            object2 = object3;
            synchronized (object2) {
                object = (BehaviorRetained)object3;
                WakeupOnCollisionEntry[] wakeupOnCollisionEntryArray = (WakeupOnCollisionEntry[])this.collideEntryList.toArray();
                for (int i = this.collideEntryList.arraySize() - 1; i >= 0; --i) {
                    WakeupOnCollisionEntry wakeupOnCollisionEntry = wakeupOnCollisionEntryArray[i];
                    if (wakeupOnCollisionEntry.behav != object) continue;
                    this.collideEntryList.remove(wakeupOnCollisionEntry);
                }
                WakeupOnCollisionExit[] wakeupOnCollisionExitArray = (WakeupOnCollisionExit[])this.collideExitList.toArray();
                for (int i = this.collideExitList.arraySize() - 1; i >= 0; --i) {
                    WakeupOnCollisionExit wakeupOnCollisionExit = wakeupOnCollisionExitArray[i];
                    if (wakeupOnCollisionExit.behav != object) continue;
                    this.collideExitList.remove(wakeupOnCollisionExit);
                }
                continue;
            }
        }
        if (this.bhNodeCount < 1) {
            return;
        }
        n = this.getBHTreeIndex(((BHLeafNode)this.bhNodeArr[0]).getLocale());
        if (n < 0) {
            this.clearBhNodeArr();
            return;
        }
        object2 = this.bhTreeArr[n];
        ((BHTree)object2).delete(this.bhNodeArr, this.bhNodeCount);
        this.clearBhNodeArr();
        this.wakeupOnCollisionEntry.clearMirror();
        this.wakeupOnCollisionMovement.clearMirror();
        this.wakeupOnCollisionExit.clearMirror();
        object = this.collideListLock;
        synchronized (object) {
            this.collideEntryList.clearMirror();
            this.collideExitList.clearMirror();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBoundsChanged(Object[] objectArray, boolean bl) {
        this.clearBhNodeArr();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            Object object2;
            Object object3 = objectArray[i];
            if (object3 instanceof GeometryAtom) {
                object2 = object3;
                synchronized (object2) {
                    object = (GeometryAtom)object3;
                    if (((GeometryAtom)object).bhLeafNode != null) {
                        this.addToBhNodeArr(((GeometryAtom)object).bhLeafNode);
                    }
                    continue;
                }
            }
            if (!(object3 instanceof GroupRetained)) continue;
            object2 = (GroupRetained)object3;
            if (((GroupRetained)object2).nodeType == 18) continue;
            object = object3;
            synchronized (object) {
                if (((GroupRetained)object2).bhLeafNode != null) {
                    this.addToBhNodeArr(((GroupRetained)object2).bhLeafNode);
                }
                continue;
            }
        }
        if (this.bhNodeCount < 1) {
            return;
        }
        int n = this.getBHTreeIndex(((BHLeafNode)this.bhNodeArr[0]).getLocale());
        if (n >= 0) {
            this.bhTreeArr[n].boundsChanged(this.bhNodeArr, this.bhNodeCount);
        }
        this.clearBhNodeArr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTransformChanged(UpdateTargets updateTargets) {
        GeometryAtom geometryAtom;
        NnuId nnuId;
        int n;
        Object[] objectArray;
        int n2;
        Object[] objectArray2;
        int n3;
        this.clearBhNodeArr();
        UnorderList unorderList = updateTargets.targetList[0];
        if (unorderList != null) {
            n3 = unorderList.size();
            objectArray2 = unorderList.toArray(false);
            for (n2 = 0; n2 < n3; ++n2) {
                objectArray = (Object[])objectArray2[n2];
                for (n = 0; n < objectArray.length; ++n) {
                    geometryAtom = nnuId = (GeometryAtom)objectArray[n];
                    synchronized (geometryAtom) {
                        if (nnuId.bhLeafNode != null) {
                            this.addToBhNodeArr(nnuId.bhLeafNode);
                        }
                        continue;
                    }
                }
            }
        }
        if ((unorderList = updateTargets.targetList[6]) != null) {
            n3 = unorderList.size();
            objectArray2 = unorderList.toArray(false);
            for (n2 = 0; n2 < n3; ++n2) {
                objectArray = (Object[])objectArray2[n2];
                for (n = 0; n < objectArray.length; ++n) {
                    nnuId = (GroupRetained)objectArray[n];
                    if (((GroupRetained)nnuId).nodeType == 18) continue;
                    geometryAtom = nnuId;
                    synchronized (geometryAtom) {
                        if (((GroupRetained)nnuId).bhLeafNode != null) {
                            this.addToBhNodeArr(((GroupRetained)nnuId).bhLeafNode);
                        }
                        continue;
                    }
                }
            }
        }
        if (this.bhNodeCount < 1) {
            return;
        }
        int n4 = this.getBHTreeIndex(((BHLeafNode)this.bhNodeArr[0]).getLocale());
        if (n4 >= 0) {
            this.bhTreeArr[n4].boundsChanged(this.bhNodeArr, this.bhNodeCount);
        }
        this.clearBhNodeArr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getVisibleBHTrees(RenderBin renderBin, BoundingBox boundingBox, Locale locale, long l, boolean bl, int n) {
        boolean bl2 = true;
        this.lock.readLock();
        ArrayList arrayList = new ArrayList();
        if (this.bhTreeCount == 1) {
            Object object = this.visLock;
            synchronized (object) {
                bl2 = this.bhTreeArr[0].getVisibleBHTrees(renderBin, arrayList, boundingBox, l, bl, n, true);
            }
        }
        BoundingBox boundingBox2 = new BoundingBox();
        Object object = this.visLock;
        synchronized (object) {
            for (int i = 0; i < this.bhTreeCount; ++i) {
                if (!locale.hiRes.equals(this.bhTreeArr[i].locale.hiRes)) {
                    this.bhTreeArr[i].locale.hiRes.difference(locale.hiRes, this.localeTrans);
                    boundingBox2.lower.x = boundingBox.lower.x + this.localeTrans.x;
                    boundingBox2.lower.y = boundingBox.lower.y + this.localeTrans.y;
                    boundingBox2.lower.z = boundingBox.lower.z + this.localeTrans.z;
                    boundingBox2.upper.x = boundingBox.upper.x + this.localeTrans.x;
                    boundingBox2.upper.y = boundingBox.upper.y + this.localeTrans.y;
                    boundingBox2.upper.z = boundingBox.upper.z + this.localeTrans.z;
                } else {
                    boundingBox.copy(boundingBox2);
                }
                if (this.bhTreeArr[i].getVisibleBHTrees(renderBin, arrayList, boundingBox2, l, bl, n, false)) continue;
                bl2 = false;
            }
        }
        this.lock.readUnlock();
        return bl2;
    }

    GeometryAtom[] pickAll(Locale locale, PickShape pickShape) {
        UnorderList unorderList = new UnorderList(BHNode.class);
        unorderList.clear();
        this.lock.readLock();
        int n = this.getBHTreeIndex(locale);
        if (n < 0) {
            this.lock.readUnlock();
            return null;
        }
        this.bhTreeArr[n].select(pickShape, unorderList);
        this.lock.readUnlock();
        int n2 = unorderList.size();
        if (n2 < 1) {
            return null;
        }
        BHNode[] bHNodeArray = (BHNode[])unorderList.toArray(false);
        GeometryAtom[] geometryAtomArray = new GeometryAtom[n2];
        for (n = 0; n < n2; ++n) {
            geometryAtomArray[n] = (GeometryAtom)((BHLeafNode)bHNodeArray[n]).leafIF;
        }
        return geometryAtomArray;
    }

    GeometryAtom pickAny(Locale locale, PickShape pickShape) {
        BHNode bHNode = null;
        this.lock.readLock();
        int n = this.getBHTreeIndex(locale);
        if (n < 0) {
            this.lock.readUnlock();
            return null;
        }
        bHNode = this.bhTreeArr[n].selectAny(pickShape);
        this.lock.readUnlock();
        if (bHNode == null) {
            return null;
        }
        return (GeometryAtom)((BHLeafNode)bHNode).leafIF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWakeupOnCollision(WakeupOnCollisionEntry wakeupOnCollisionEntry) {
        boolean bl = true;
        Object object = this.collideListLock;
        synchronized (object) {
            WakeupOnCollisionEntry[] wakeupOnCollisionEntryArray = (WakeupOnCollisionEntry[])this.collideEntryList.toArray();
            for (int i = this.collideEntryList.arraySize() - 1; i >= 0; --i) {
                WakeupOnCollisionEntry wakeupOnCollisionEntry2 = wakeupOnCollisionEntryArray[i];
                if (wakeupOnCollisionEntry2.behav != wakeupOnCollisionEntry.behav || wakeupOnCollisionEntry2.geometryAtoms != wakeupOnCollisionEntry.geometryAtoms) continue;
                this.collideEntryList.remove(i);
                bl = false;
                break;
            }
        }
        this.wakeupOnCollisionEntry.add(wakeupOnCollisionEntry);
        wakeupOnCollisionEntry.updateCollisionBounds(false);
        object = this.collide(wakeupOnCollisionEntry.behav.locale, wakeupOnCollisionEntry.accuracyMode, wakeupOnCollisionEntry.geometryAtoms, wakeupOnCollisionEntry.vwcBounds, wakeupOnCollisionEntry.boundingLeaf, wakeupOnCollisionEntry.armingNode, null);
        if (object != null) {
            this.collideEntryList.add(wakeupOnCollisionEntry);
            wakeupOnCollisionEntry.setTarget((BHLeafInterface)object);
        }
        if (object != null && bl) {
            wakeupOnCollisionEntry.setTriggered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWakeupOnCollision(WakeupOnCollisionExit wakeupOnCollisionExit) {
        WakeupOnCollisionEntry[] wakeupOnCollisionEntryArray;
        Object object;
        boolean bl = true;
        Object object2 = this.collideListLock;
        synchronized (object2) {
            object = (WakeupOnCollisionExit[])this.collideExitList.toArray();
            for (int i = this.collideExitList.arraySize() - 1; i >= 0; --i) {
                wakeupOnCollisionEntryArray = object[i];
                if (wakeupOnCollisionEntryArray.behav != wakeupOnCollisionExit.behav || wakeupOnCollisionEntryArray.geometryAtoms != wakeupOnCollisionExit.geometryAtoms) continue;
                this.collideExitList.remove(i);
                bl = false;
                break;
            }
        }
        this.wakeupOnCollisionExit.add(wakeupOnCollisionExit);
        wakeupOnCollisionExit.updateCollisionBounds(false);
        object2 = this.collide(wakeupOnCollisionExit.behav.locale, wakeupOnCollisionExit.accuracyMode, wakeupOnCollisionExit.geometryAtoms, wakeupOnCollisionExit.vwcBounds, wakeupOnCollisionExit.boundingLeaf, wakeupOnCollisionExit.armingNode, null);
        if (object2 != null) {
            wakeupOnCollisionExit.setTarget((BHLeafInterface)object2);
            this.collideExitList.add(wakeupOnCollisionExit);
        }
        if (!bl) {
            return;
        }
        object = this.collideListLock;
        synchronized (object) {
            wakeupOnCollisionEntryArray = (WakeupOnCollisionEntry[])this.collideEntryList.toArray();
            for (int i = this.collideEntryList.arraySize() - 1; i >= 0; --i) {
                WakeupOnCollisionEntry wakeupOnCollisionEntry = wakeupOnCollisionEntryArray[i];
                if (wakeupOnCollisionEntry.behav != wakeupOnCollisionExit.behav || wakeupOnCollisionEntry.geometryAtoms != wakeupOnCollisionExit.geometryAtoms) continue;
                if (object2 != null) break;
                wakeupOnCollisionExit.setTriggered();
                break;
            }
        }
    }

    void addWakeupOnCollision(WakeupOnCollisionMovement wakeupOnCollisionMovement) {
        this.wakeupOnCollisionMovement.add(wakeupOnCollisionMovement);
        wakeupOnCollisionMovement.updateCollisionBounds(false);
        BHLeafInterface bHLeafInterface = this.collide(wakeupOnCollisionMovement.behav.locale, wakeupOnCollisionMovement.accuracyMode, wakeupOnCollisionMovement.geometryAtoms, wakeupOnCollisionMovement.vwcBounds, wakeupOnCollisionMovement.boundingLeaf, wakeupOnCollisionMovement.armingNode, wakeupOnCollisionMovement);
        if (bHLeafInterface != null) {
            wakeupOnCollisionMovement.setTarget(bHLeafInterface);
            this.collideMovementList.add(wakeupOnCollisionMovement);
        }
    }

    void removeWakeupOnCollision(WakeupOnCollisionEntry wakeupOnCollisionEntry) {
        this.wakeupOnCollisionEntry.remove(wakeupOnCollisionEntry);
    }

    void removeWakeupOnCollision(WakeupOnCollisionExit wakeupOnCollisionExit) {
        this.wakeupOnCollisionExit.remove(wakeupOnCollisionExit);
    }

    void removeWakeupOnCollision(WakeupOnCollisionMovement wakeupOnCollisionMovement) {
        this.wakeupOnCollisionMovement.remove(wakeupOnCollisionMovement);
        this.collideMovementList.remove(wakeupOnCollisionMovement);
    }

    void processCollisionDetection() {
        int n;
        BHLeafInterface bHLeafInterface;
        int n2;
        WakeupOnCollisionEntry[] wakeupOnCollisionEntryArray = (WakeupOnCollisionEntry[])this.wakeupOnCollisionEntry.toArray();
        for (n2 = this.wakeupOnCollisionEntry.arraySize() - 1; n2 >= 0; --n2) {
            WakeupOnCollisionEntry wakeupOnCollisionEntry = wakeupOnCollisionEntryArray[n2];
            wakeupOnCollisionEntry.updateCollisionBounds(this.reEvaluateWakeupCollisionGAs);
            bHLeafInterface = this.collide(wakeupOnCollisionEntry.behav.locale, wakeupOnCollisionEntry.accuracyMode, wakeupOnCollisionEntry.geometryAtoms, wakeupOnCollisionEntry.vwcBounds, wakeupOnCollisionEntry.boundingLeaf, wakeupOnCollisionEntry.armingNode, null);
            n = this.collideEntryList.indexOf(wakeupOnCollisionEntry);
            if (bHLeafInterface != null) {
                if (n >= 0) continue;
                this.collideEntryList.add(wakeupOnCollisionEntry);
                wakeupOnCollisionEntry.setTarget(bHLeafInterface);
                wakeupOnCollisionEntry.setTriggered();
                continue;
            }
            if (n < 0) continue;
            this.collideEntryList.remove(n);
        }
        WakeupOnCollisionMovement[] wakeupOnCollisionMovementArray = (WakeupOnCollisionMovement[])this.wakeupOnCollisionMovement.toArray();
        for (n2 = this.wakeupOnCollisionMovement.arraySize() - 1; n2 >= 0; --n2) {
            WakeupOnCollisionMovement wakeupOnCollisionMovement = wakeupOnCollisionMovementArray[n2];
            wakeupOnCollisionMovement.updateCollisionBounds(this.reEvaluateWakeupCollisionGAs);
            bHLeafInterface = this.collide(wakeupOnCollisionMovement.behav.locale, wakeupOnCollisionMovement.accuracyMode, wakeupOnCollisionMovement.geometryAtoms, wakeupOnCollisionMovement.vwcBounds, wakeupOnCollisionMovement.boundingLeaf, wakeupOnCollisionMovement.armingNode, wakeupOnCollisionMovement);
            n = this.collideMovementList.indexOf(wakeupOnCollisionMovement);
            if (bHLeafInterface != null) {
                if (n < 0) {
                    this.collideMovementList.add(wakeupOnCollisionMovement);
                    wakeupOnCollisionMovement.setTarget(bHLeafInterface);
                    continue;
                }
                if (wakeupOnCollisionMovement.duplicateEvent) continue;
                wakeupOnCollisionMovement.setTriggered();
                continue;
            }
            if (n < 0) continue;
            this.collideMovementList.remove(n);
            wakeupOnCollisionMovement.lastSrcBounds = null;
            wakeupOnCollisionMovement.lastDstBounds = null;
        }
        WakeupOnCollisionExit[] wakeupOnCollisionExitArray = (WakeupOnCollisionExit[])this.wakeupOnCollisionExit.toArray();
        for (n2 = this.wakeupOnCollisionExit.arraySize() - 1; n2 >= 0; --n2) {
            WakeupOnCollisionExit wakeupOnCollisionExit = wakeupOnCollisionExitArray[n2];
            wakeupOnCollisionExit.updateCollisionBounds(this.reEvaluateWakeupCollisionGAs);
            bHLeafInterface = this.collide(wakeupOnCollisionExit.behav.locale, wakeupOnCollisionExit.accuracyMode, wakeupOnCollisionExit.geometryAtoms, wakeupOnCollisionExit.vwcBounds, wakeupOnCollisionExit.boundingLeaf, wakeupOnCollisionExit.armingNode, null);
            n = this.collideExitList.indexOf(wakeupOnCollisionExit);
            if (bHLeafInterface != null) {
                if (n >= 0) continue;
                this.collideExitList.add(wakeupOnCollisionExit);
                wakeupOnCollisionExit.setTarget(bHLeafInterface);
                continue;
            }
            if (n < 0) continue;
            this.collideExitList.remove(n);
            wakeupOnCollisionExit.setTriggered();
        }
    }

    void checkDuplicateEvent(WakeupOnCollisionMovement wakeupOnCollisionMovement, Bounds bounds, BHLeafInterface bHLeafInterface) {
        if (wakeupOnCollisionMovement.lastSrcBounds != null && wakeupOnCollisionMovement.lastSrcBounds.equals(bounds)) {
            BoundingBox boundingBox = bHLeafInterface instanceof GeometryAtom ? ((GeometryAtom)bHLeafInterface).source.vwcBounds : ((GroupRetained)bHLeafInterface).collisionVwcBounds;
            if (wakeupOnCollisionMovement.lastDstBounds != null && wakeupOnCollisionMovement.lastDstBounds.equals(boundingBox)) {
                wakeupOnCollisionMovement.duplicateEvent = true;
            } else {
                wakeupOnCollisionMovement.duplicateEvent = false;
                wakeupOnCollisionMovement.lastDstBounds = (Bounds)((Bounds)boundingBox).clone();
            }
        } else {
            wakeupOnCollisionMovement.duplicateEvent = false;
            wakeupOnCollisionMovement.lastSrcBounds = (Bounds)bounds.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BHLeafInterface collide(Locale locale, int n, UnorderList unorderList, Bounds bounds, BoundingLeafRetained boundingLeafRetained, NodeRetained nodeRetained, WakeupCriterion wakeupCriterion) {
        this.lock.readLock();
        int n2 = this.getBHTreeIndex(locale);
        if (n2 < 0) {
            this.lock.readUnlock();
            return null;
        }
        if (unorderList != null) {
            BHTree bHTree = this.bhTreeArr[n2];
            synchronized (bHTree) {
                if (bounds != null && nodeRetained instanceof GroupRetained) {
                    BHLeafInterface bHLeafInterface = this.bhTreeArr[n2].selectAny(bounds, n, (GroupRetained)nodeRetained);
                    if (bHLeafInterface == null) {
                        this.lock.readUnlock();
                        return null;
                    }
                    GeometryAtom[] geometryAtomArray = (GeometryAtom[])unorderList.toArray(false);
                    bHLeafInterface = this.bhTreeArr[n2].selectAny(geometryAtomArray, unorderList.arraySize(), n);
                    if (bHLeafInterface != null) {
                        this.lock.readUnlock();
                        if (wakeupCriterion != null) {
                            this.checkDuplicateEvent((WakeupOnCollisionMovement)wakeupCriterion, bounds, bHLeafInterface);
                        }
                        return bHLeafInterface;
                    }
                } else {
                    GeometryAtom geometryAtom = (GeometryAtom)unorderList.get(0);
                    BHLeafInterface bHLeafInterface = this.bhTreeArr[n2].selectAny(geometryAtom, n);
                    if (bHLeafInterface != null) {
                        this.lock.readUnlock();
                        if (wakeupCriterion != null) {
                            this.checkDuplicateEvent((WakeupOnCollisionMovement)wakeupCriterion, geometryAtom.source.vwcBounds, bHLeafInterface);
                        }
                        return bHLeafInterface;
                    }
                }
            }
        } else {
            if (bounds == null) {
                if (boundingLeafRetained == null) {
                    this.lock.readUnlock();
                    return null;
                }
                bounds = boundingLeafRetained.transformedRegion;
            }
            if (bounds == null) {
                this.lock.readUnlock();
                return null;
            }
            if (nodeRetained instanceof GroupRetained) {
                BHTree bHTree = this.bhTreeArr[n2];
                synchronized (bHTree) {
                    BHLeafInterface bHLeafInterface = this.bhTreeArr[n2].selectAny(bounds, n, (GroupRetained)nodeRetained);
                    this.lock.readUnlock();
                    if (bHLeafInterface != null && wakeupCriterion != null) {
                        this.checkDuplicateEvent((WakeupOnCollisionMovement)wakeupCriterion, bounds, bHLeafInterface);
                    }
                    return bHLeafInterface;
                }
            }
            BHTree bHTree = this.bhTreeArr[n2];
            synchronized (bHTree) {
                BHLeafInterface bHLeafInterface = this.bhTreeArr[n2].selectAny(bounds, n, nodeRetained);
                this.lock.readUnlock();
                if (bHLeafInterface != null && wakeupCriterion != null) {
                    this.checkDuplicateEvent((WakeupOnCollisionMovement)wakeupCriterion, bounds, bHLeafInterface);
                }
                return bHLeafInterface;
            }
        }
        this.lock.readUnlock();
        return null;
    }

    void resetConditionMet() {
        BehaviorStructure.resetConditionMet(this.wakeupOnCollisionEntry);
        BehaviorStructure.resetConditionMet(this.wakeupOnCollisionExit);
        BehaviorStructure.resetConditionMet(this.wakeupOnCollisionMovement);
    }

    private void processSwitchChanged(J3dMessage j3dMessage) {
    }

    @Override
    void cleanup() {
        this.collideEntryList.clear();
        this.collideExitList.clear();
        this.collideMovementList.clear();
        this.wakeupOnCollisionEntry.clear();
        this.wakeupOnCollisionExit.clear();
        this.wakeupOnCollisionMovement.clear();
    }
}

